C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_tpss03.F 
C> The nwxcm_c_tpss03 functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_tpss03 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_3} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_4} &=& \sqrt{{\it t_3}}\\\\ 
C>   {\it t_5} &=& {{1}\over{{\it t_4}}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_3}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_4}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_5}+0.10186556948\right)\,{
C>    \it t_5}+0.22308199064\right)\,{\it t_5}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.1325688999052018\,{\it t_6}+1.0\\\\ 
C>   {\it t_9} &=& \log \left({{1.269642451250142\,{\it t_4}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_5}+0.029729725188\right)
C>    \,{\it t_5}+0.12236585478\right)\,{\it t_5}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_{10}} &=& 0.06901399211255826\,{\it t_6}+1.0\\\\ 
C>   {\it t_{11}} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_9}
C>    \,{\it t_{10}}+1.0\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_7}\,{\it t_8}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_4}}\over{0.7876233178997433
C>    \,\left(0.7876233178997433\,\left(0.01530901310039024\,{\it t_5}
C>    +0.10465751434\right)\,{\it t_5}+0.19269083139\right)\,{\it t_5}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{\it t_6}
C>    +1.0\right)\right)-0.0337738\,{\it t_9}\,{
C>    \it t_{10}}\right)\right)-0.0621814\,{\it t_7}\,{\it t_8}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{
C>    \left(\rho_\alpha^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{11}}}}}
C>    -1.0\\\\ 
C>   {\it t_{14}} &=& {{0.2162211495206379\,{\it t_{12}}\,
C>    \sigma_{\alpha\alpha}}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{15}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{16}} &=& {\it t_{15}}\,{\it t_2}\\\\ 
C>   {\it t_{17}} &=& 2.26\,{\it t_{16}}^{6.0}+0.5\,{\it t_{16}}^{4.0}
C>    +0.87\,{\it t_{16}}^{2.0}+0.53\\\\ 
C>   {\it t_{18}} &=& 1.0-{\it t_{15}}\,{\it t_2}\\\\ 
C>   {\it t_{19}} &=& {\it t_{16}}+1.0\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left({{0.0130605864926168\,
C>    \left({{1}\over{{\it t_{19}}^{1.333333333333333}}}+{{1}
C>    \over{{\it t_{18}}^{1.333333333333333}}}\right)\,\left({
C>    \it t_{19}}^2\,\sigma_{\beta\beta}-2.0\,{\it t_{18}}\,{
C>    \it t_{19}}\,\sigma_{\alpha\beta}+{\it t_{18}}^2\,
C>    \sigma_{\alpha\alpha}\right)}\over{{\it t_1}^{{{8}\over{3}}}}}
C>    +1.0\right)^{4.0}}}\\\\ 
C>   {\it t_{21}} &=& {\it t_{17}}\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{22}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{23}} &=& {{{\it t_2}\,{\it t_{22}}}\over{\tau_\beta
C>    +\tau_\alpha}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}^{2.0}\\\\ 
C>   {\it t_{25}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{26}} &=& \sqrt{{\it t_{25}}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_{26}}}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{25}}}}\\\\ 
C>   {\it t_{29}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{26}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{27}}+0.10186556948\right)
C>    \,{\it t_{27}}+0.22308199064\right)\,{\it t_{27}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{30}} &=& 0.1325688999052018\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{31}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{26}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{27}}
C>    +0.029729725188\right)\,{\it t_{27}}+0.12236585478\right)\,{
C>    \it t_{27}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{32}} &=& 0.06901399211255826\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{33}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{31}}\,{\it t_{32}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{29}}\,{\it t_{30}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{26}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{27}}+0.10465751434\right)
C>    \,{\it t_{27}}+0.19269083139\right)\,{\it t_{27}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{28}}+1.0\right)\right)-0.0337738\,{\it t_{31}}\,{
C>    \it t_{32}}\right)\right)-0.0621814\,{\it t_{29}}\,{
C>    \it t_{30}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{
C>    \left(\rho_\beta^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{33}}}}}
C>    -1.0\\\\ 
C>   {\it t_{36}} &=& {{0.2162211495206379\,{\it t_{34}}\,
C>    \sigma_{\beta\beta}}\over{{\it t_{35}}}}\\\\ 
C>   {\it t_{37}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{37}}}}\\\\ 
C>   {\it t_{39}} &=& 0.1325688999052018\,{\it t_{38}}+1.0\\\\ 
C>   {\it t_{40}} &=& \sqrt{{\it t_{37}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{40}}}}\\\\ 
C>   {\it t_{42}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.02414199311453321\,{\it t_{41}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{43}} &=& 0.06901399211255826\,{\it t_{38}}+1.0\\\\ 
C>   {\it t_{44}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.01321299881039884\,{\it t_{41}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{45}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{19}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{18}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_{15}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{39}}\,{\it t_{42}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{38}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{40}}}
C>    \over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.01530901310039024\,{\it t_{41}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{43}}\,{\it t_{44}}\right)}\over{{
C>    \it t_1}^4}}+0.0337738\,{\it t_{43}}\,{\it t_{44}}\right)
C>    -0.0621814\,{\it t_{39}}\,{\it t_{42}}\\\\ 
C>   {\it t_{46}} &=& 0.5\,{\it t_{19}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{18}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{47}} &=& {\it t_{46}}^{3.0}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{{\it t_{46}}^{2.0}}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{e^{{{32.16396844291483\,{
C>    \it t_{45}}}\over{{\it t_{47}}}}}}}-1.0\\\\ 
C>   {\it t_{51}} &=& {{0.1362107888567592\,{\it t_{48}}\,{
C>    \it t_{49}}\,{\it t_{22}}}\over{{\it t_{50}}}}\\\\ 
C>   {\it t_{52}} &=& \left(0.03109069086965489\,{\it t_{47}}
C>    \,\log \left({{0.1362107888567592\,{\it t_{48}}\,{\it t_{49}}
C>    \,{\it t_{22}}\,\left({\it t_{51}}+1.0\right)}
C>    \over{{{0.01855337900098064\,\left({\it t_{48}}\,{
C>    \it t_{22}}\right)^{2.0}}\over{{\it t_{46}}^{4.0}\,{
C>    \it t_{50}}^{2.0}}}+{\it t_{51}}+1.0}}+1.0\right)+1.0\,{
C>    \it t_{45}}\right)\,\left(0.015625\,{\it t_{17}}\,{\it t_{20}}
C>    \,{\it t_{24}}+1.0\right)-0.015625\,\rho_\beta\,{\it t_2}\,{
C>    \it t_{21}}\,\left(0.01554534543482744\,\log 
C>    \left({{0.2162211495206379\,{\it t_{34}}\,\sigma_{\beta\beta}
C>    \,\left({\it t_{36}}+1.0\right)}\over{{{0.04675158550002606
C>    \,\left({\it t_{34}}\,\sigma_{\beta\beta}\right)^{2.0}}
C>    \over{{\it t_{35}}^{2.0}}}+{\it t_{36}}+1.0}}+1.0\right)+1.0
C>    \,{\it t_{33}}\right)\,{\it t_{24}}-0.015625\,\rho_\alpha\,{
C>    \it t_2}\,\left(0.01554534543482744\,\log 
C>    \left({{0.2162211495206379\,{\it t_{12}}\,
C>    \sigma_{\alpha\alpha}\,\left({\it t_{14}}+1.0\right)}
C>    \over{{{0.04675158550002606\,\left({\it t_{12}}\,
C>    \sigma_{\alpha\alpha}\right)^{2.0}}\over{{\it t_{13}}^{2.0}}}
C>    +{\it t_{14}}+1.0}}+1.0\right)+1.0\,{\it t_{11}}\right)\,{
C>    \it t_{21}}\,{\it t_{24}}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,{\it t_{52}}\,\left(0.00546875\,{
C>    \it t_{23}}^{3.0}\,{\it t_{52}}+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.0\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] J Tao, JP Perdew, VN Staveroverov, GE Scuseria
C>    , Phys.Rev.Lett. 91, 146401 (2003)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.91.146401 "> 
C> 10.1103/PhysRevLett.91.146401 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_tpss03(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Cmat,Mmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = rhoa**3.333333333333333d-1
              t2 = t1**5.0d-1
              t3 = 1/t2
              t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3
     1           *(7.016926042943223d-1*(2.150807071909054d-2*t3+1.01865
     2           56948d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
              t5 = 1/t1
              t6 = 1.0522000558389215d-1*t5+1.0d+0
              t7 = rhoa**1.1666666666666667d+0
              t8 = 1/t7**2.0d+0
              t9 = exp(2.0000005873362642d+0*t4*t6)-1.0d+0
              t10 = 1.0811057476031892d-1*gammaaa*t8/t9
              t11 = (gammaaa*t8)**2.0d+0
              t12 = 1/rhoa
              t13 = 1/taua
              t14 = gammaaa*t12*t13
              t15 = t14**2.0d+0
              t16 = 1.530901310039024d-2*t3+1.0465751434d-1
              t17 = 7.876233178997433d-1*t16*t3+1.9269083139d-1
              t18 = 7.876233178997433d-1*t17*t3+4.3896648423d-1
              t19 = 1/t18
              t20 = 1.269642451250142d+0*t19*t2+1.0d+0
              t21 = log(t20)
              t22 = 1.2746961887000874d-1*t5+1.0d+0
              t23 = 2.4141993114533214d-2*t3+1.0186556948d-1
              t24 = 7.876233178997433d-1*t23*t3+2.2308199064d-1
              t25 = 7.876233178997433d-1*t24*t3+4.7231125998d-1
              t26 = 1/t25
              t27 = 1.269642451250142d+0*t2*t26+1.0d+0
              t28 = log(t27)
              t29 = 1.325688999052018d-1*t5+1.0d+0
              t30 = 1.3212998810398843d-2*t3+2.9729725188d-2
              t31 = 7.876233178997433d-1*t3*t30+1.2236585478d-1
              t32 = 7.876233178997433d-1*t3*t31+3.497952466d-1
              t33 = 1/t32
              t34 = 1.269642451250142d+0*t2*t33+1.0d+0
              t35 = log(t34)
              t36 = 6.901399211255826d-2*t5+1.0d+0
              t37 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t28*t29-3.10907d-2*t21*t22)-3.37738d-2*t35*t
     2           36)+3.37738d-2*t35*t36)-6.21814d-2*t28*t29
              t38 = exp(-6.432793688582967d+1*t37)
              t39 = t38-1.0d+0
              t40 = 1/t39
              t41 = 2.1622114952063792d-1*gammaaa*t40*t8
              t42 = t41+1.0d+0
              t43 = 1/t39**2.0d+0
              t44 = 4.675158550002606d-2*t11*t43+t41+1.0d+0
              t45 = 1/t44
              t46 = 2.1622114952063792d-1*gammaaa*t42*t45*t8+1.0d+0
              t47 = 1.5545345434827443d-2*log(t46)+1.0d+0*t37
              t48 = (8.28125d-3*t15+1.0d+0)*(3.109069086965489d-2*log(1.
     1           0811057476031892d-1*gammaaa*(t10+1.0d+0)*t8/(1.16878963
     2           75006504d-2*t11/t9**2.0d+0+t10+1.0d+0)+1.0d+0)-6.21814d
     3           -2*t4*t6)-2.390625d-2*t15*t47
              t49 = 2.1508070719090538d-2*t3+1.0186556948d-1
              t50 = 7.016926042943222d-1*t3*t49+2.2308199064d-1
              t51 = 7.016926042943222d-1*t3*t50+4.7231125998d-1
              t52 = 1/t51
              t53 = 1.425125466450768d+0*t2*t52+1.0d+0
              t54 = log(t53)
              t55 = 1.0522000558389213d-1*t5+1.0d+0
              t56 = exp(2.0000005873362642d+0*t54*t55)
              t57 = t56-1.0d+0
              t58 = 1/t57
              t59 = 1.0811057476031893d-1*gammaaa*t58*t8
              t60 = t59+1.0d+0
              t61 = 1/t57**2.0d+0
              t62 = 1.168789637500651d-2*t11*t61+t59+1.0d+0
              t63 = 1/t62
              t64 = 1.0811057476031893d-1*gammaaa*t60*t63*t8+1.0d+0
              t65 = 3.109069086965489d-2*log(t64)-6.21814d-2*t54*t55
              t66 = 1.0d+0*gammaaa*t12*t13
              t67 = t66**2.0d+0
              t68 = 8.28125d-3*t67+1.0d+0
              t69 = t65*t68-2.390625d-2*t47*t67
              t70 = t66**3.0d+0
              t71 = 5.46875d-3*t69*t70+1.0d+0
              t72 = 1/rhoa**1.3333333333333333d+0
              t73 = 1/rhoa**1.3333333333333336d+0
              t74 = 1/t2**3
              t75 = 1/rhoa**6.666666666666667d-1
              t76 = 1.090454542535705d-3*t54*t72-6.21814d-2*t55*(1.18760
     1           45553756398d-1*t3*t52*t75-1.425125466450768d+0*t2*(7.01
     2           6926042943222d-1*t3*(-5.847438369119352d-2*t49*t74*t75-
     3           1.2576711796854242d-3*t73)-5.847438369119352d-2*t50*t74
     4           *t75)/t51**2)/t53
              t77 = 1/t64
              t78 = rhoa**1.6666666666666674d-1
              t79 = 1/t7**3.0d+0
              t80 = -1.2612900388703877d-1*gammaaa*t58*t78*t79
              t81 = 3.4772651149362827d+0*gammaaa*t56*t76*t8/t57**2
              t82 = 1/t62**2
              t83 = gammaaa**2
              t84 = 1/t7**5.0d+0
              t85 = 1/t27
              t86 = 2.11607075208357d-1*t26*t3*t75-1.269642451250142d+0*
     1           t2*(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t23
     2           *t74*t75-3.169132786263567d-3*t73)-1.3127055298329054d-
     3           1*t24*t74*t75)/t25**2
              t87 = 1/t34
              t88 = 2.11607075208357d-1*t3*t33*t75-1.269642451250142d+0*
     1           t2*(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t30
     2           *t74*t75-1.7344776604086162d-3*t73)-1.3127055298329054d
     3           -1*t31*t74*t75)/t32**2
              t89 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t36*t87*t8
     1           8+1.709920934161365d+0*(6.21814d-2*t29*t85*t86-3.10907d
     2           -2*t22*(2.11607075208357d-1*t19*t3*t75-1.26964245125014
     3           2d+0*t2*(7.876233178997433d-1*t3*(-1.3127055298329054d-
     4           1*t16*t74*t75-2.0096226153166658d-3*t73)-1.312705529832
     5           9054d-1*t17*t74*t75)/t18**2)/t20-2.747773264188438d-3*t
     6           28*t72+1.3210398931339265d-3*t21*t72)+7.769549222703733
     7           d-4*t35*t72)+3.37738d-2*t36*t87*t88-7.769549222703733d-
     8           4*t35*t72)-6.21814d-2*t29*t85*t86+2.747773264188438d-3*
     9           t28*t72
              t90 = 1/t46
              t91 = -5.045160155481552d-1*gammaaa*t40*t78*t79
              t92 = 1.3909060459745137d+1*gammaaa*t38*t8*t89/t39**2
              t93 = 1/t44**2
              t94 = 1/rhoa**3
              t95 = 1/taua**2
              t96 = -8.28125d-3*t65*t83*t94*t95+2.390625d-2*t47*t83*t94*
     1           t95-1.1953125d-2*t67*(1.5545345434827443d-2*t90*(-2.162
     2           2114952063792d-1*gammaaa*t42*t8*(t92+t91+6.014866082716
     3           293d+0*t11*t38*t89/t39**3.0d+0-2.181740656667883d-1*t43
     4           *t78*t83*t84)*t93+2.1622114952063792d-1*gammaaa*t45*t8*
     5           (t92+t91)-5.045160155481552d-1*gammaaa*t42*t45*t78*t79)
     6           +1.0d+0*t89)+t68*(3.109069086965489d-2*t77*(-1.08110574
     7           76031893d-1*gammaaa*t60*t8*t82*(-2.7271758208348523d-2*
     8           t61*t78*t83*t84+t81+t80+7.518582603395361d-1*t11*t56*t7
     9           6/t57**3.0d+0)+1.0811057476031893d-1*gammaaa*t63*t8*(t8
     :           1+t80)-1.2612900388703877d-1*gammaaa*t60*t63*t78*t79)+1
     ;           .0d+0*t76)
              t97 = 1/rhoa**2
              t98 = 1/t7**4.0d+0
              t99 = 7.874506561842959d-2
              t100 = 1/rhoa**2.6666666666666666d+0
              t101 = 1.5749013123685918d-1
              t102 = 1.7305277102717265d-3*t100*t47*t67*t99+3.1090690869
     1           65489d-2*t68*t77*(-1.0811057476031893d-1*gammaaa*t60*t8
     2           *t82*(5.843948187503255d-3*gammaaa*t61*t98+2.7027643690
     3           079733d-2*t58*t8)+2.9219740937516275d-3*gammaaa*t58*t63
     4           *t98+2.7027643690079733d-2*t60*t63*t8)-1.85815457150671
     5           77d-4*t67*t90*(-2.1622114952063792d-1*gammaaa*t42*t8*t9
     6           3*(9.350317100005212d-2*gammaaa*t43*t98+2.1622114952063
     7           792d-1*t40*t8)+4.675158550002606d-2*gammaaa*t40*t45*t98
     8           +2.1622114952063792d-1*t42*t45*t8)+t65*(4.140625d-3*gam
     9           maaa*t95*t97-8.652638551358631d-4*t100*t101*t67)-1.1953
     :           125d-2*gammaaa*t47*t95*t97
              t103 = -3.461055420543453d-3*t100*t47*t67*t99+3.1090690869
     1           65489d-2*t68*t77*(-1.0811057476031893d-1*gammaaa*t60*t8
     2           *t82*(1.168789637500651d-2*gammaaa*t61*t98+5.4055287380
     3           15947d-2*t58*t8)+5.843948187503255d-3*gammaaa*t58*t63*t
     4           98+5.405528738015947d-2*t60*t63*t8)+t65*(8.28125d-3*gam
     5           maaa*t95*t97+1.7305277102717265d-3*t100*t101*t67)-2.390
     6           625d-2*gammaaa*t47*t95*t97
              t104 = 1/taua**3
              t105 = 2.390625d-2*t104*t47*t83*t97-8.28125d-3*t104*t65*t8
     1           3*t97
              fnc(iq) = 2.0d+0*rhoa*t48*(5.46875d-3*t14**3.0d+0*t48+1.0d
     1           +0)*wght+fnc(iq)
              Amat(iq,D1_RA) = 2.0d+0*rhoa*t69*(5.46875d-3*t70*t96-8.203
     1           124999999999d-3*gammaaa*t13*t67*t69*t97)*wght+2.0d+0*rh
     2           oa*t71*t96*wght+1.0d+0*t69*t71*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = 2.0d+0*rhoa*t102*t71*wght+2.0d+0*rhoa*t6
     1           9*(5.46875d-3*t102*t70+4.1015624999999994d-3*t12*t13*t6
     2           7*t69)*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = 2.0d+0*rhoa*t103*t71*wght+2.0d+0*rhoa*t6
     1           9*(5.46875d-3*t103*t70+8.203124999999999d-3*t12*t13*t67
     2           *t69)*wght+Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = 2.0d+0*rhoa*t69*(5.46875d-3*t105*t70-8.20
     1           3124999999999d-3*gammaaa*t12*t67*t69*t95)*wght+2.0d+0*r
     2           hoa*t105*t71*wght+Mmat(iq,D1_TA)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 1/(3.291061569204112d-52*t1+1.0d+0)**4.0d+0
              t3 = rhoa**3.333333333333333d-1
              t4 = t3**5.0d-1
              t5 = 1/t4
              t6 = 1.530901310039024d-2*t5+1.0465751434d-1
              t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
              t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
              t9 = 1/t8
              t10 = 1.269642451250142d+0*t4*t9+1.0d+0
              t11 = log(t10)
              t12 = 1/t3
              t13 = 1.2746961887000874d-1*t12+1.0d+0
              t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
              t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
              t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
              t17 = 1/t16
              t18 = 1.269642451250142d+0*t17*t4+1.0d+0
              t19 = log(t18)
              t20 = 1.325688999052018d-1*t12+1.0d+0
              t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
              t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
              t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
              t24 = 1/t23
              t25 = 1.269642451250142d+0*t24*t4+1.0d+0
              t26 = log(t25)
              t27 = 6.901399211255826d-2*t12+1.0d+0
              t28 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t19*t20-3.10907d-2*t11*t13)-3.37738d-2*t26*t
     2           27)+3.37738d-2*t26*t27)-6.21814d-2*t19*t20
              t29 = rhoa**1.1666666666666667d+0
              t30 = 1/t29**2.0d+0
              t31 = exp(-6.432793688582967d+1*t28)
              t32 = t31-1.0d+0
              t33 = 1/t32
              t34 = 8.648845980825518d-51*rhoa*t30*t33
              t35 = t34+1.0d+0
              t36 = (rhoa*t30)**2.0d+0
              t37 = 1/t32**2.0d+0
              t38 = 7.480253680004171d-101*t36*t37+t34+1.0d+0
              t39 = 1/t38
              t40 = 8.648845980825518d-51*rhoa*t30*t35*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t28
              t42 = log(1.4251254664507676d+0*t4/(7.016926042943223d-1*t
     1           5*(7.016926042943223d-1*(2.150807071909054d-2*t5+1.0186
     2           556948d-1)*t5+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
              t43 = 1.0522000558389215d-1*t12+1.0d+0
              t44 = exp(2.0000005873362642d+0*t42*t43)-1.0d+0
              t45 = 2.1622114952063787d-51*rhoa*t30/t44
              t46 = (3.3125000000000004d-2*t2+1.0d+0)*(3.109069086965489
     1           d-2*log(2.1622114952063787d-51*rhoa*t30*(t45+1.0d+0)/(t
     2           45+4.6751585500026027d-102*t36/t44**2.0d+0+1.0d+0)+1.0d
     3           +0)-6.21814d-2*t42*t43)-6.25d-2*(5.3d-1*t2+1.0d+0)*t41
              t47 = 1.5749013123685918d-1
              t48 = 2.0896938388186886d-51*t1*t47+1.0d+0
              t49 = 1/t48**4.0d+0
              t50 = 5.3d-1*t49+1.0d+0
              t51 = 3.312500000000001d-2*t49+1.0d+0
              t52 = 2.1508070719090538d-2*t5+1.0186556948d-1
              t53 = 7.016926042943222d-1*t5*t52+2.2308199064d-1
              t54 = 7.016926042943222d-1*t5*t53+4.7231125998d-1
              t55 = 1/t54
              t56 = 1.425125466450768d+0*t4*t55+1.0d+0
              t57 = log(t56)
              t58 = 1.0522000558389213d-1*t12+1.0d+0
              t59 = exp(2.0000005873362642d+0*t57*t58)
              t60 = t59-1.0d+0
              t61 = 1/t60
              t62 = 2.162211495206379d-51*rhoa*t30*t61
              t63 = t62+1.0d+0
              t64 = 1/t60**2.0d+0
              t65 = 4.6751585500026044d-102*t36*t64+t62+1.0d+0
              t66 = 1/t65
              t67 = 2.162211495206379d-51*rhoa*t30*t63*t66+1.0d+0
              t68 = 3.109069086965489d-2*log(t67)-6.21814d-2*t57*t58
              t69 = t51*t68-6.250000000000001d-2*t41*t50
              t70 = 4.375000000000001d-2*t69+1.0d+0
              t71 = 1/rhoa**1.3333333333333333d+0
              t72 = 1/rhoa**1.3333333333333336d+0
              t73 = 1/t4**3
              t74 = 1/rhoa**6.666666666666667d-1
              t75 = 1/t18
              t76 = 2.11607075208357d-1*t17*t5*t74-1.269642451250142d+0*
     1           t4*(7.876233178997433d-1*t5*(-1.3127055298329054d-1*t14
     2           *t73*t74-3.169132786263567d-3*t72)-1.3127055298329054d-
     3           1*t15*t73*t74)/t16**2
              t77 = 1/t25
              t78 = 2.11607075208357d-1*t24*t5*t74-1.269642451250142d+0*
     1           t4*(7.876233178997433d-1*t5*(-1.3127055298329054d-1*t21
     2           *t73*t74-1.7344776604086162d-3*t72)-1.3127055298329054d
     3           -1*t22*t73*t74)/t23**2
              t79 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           -3.10907d-2*t13*(2.11607075208357d-1*t5*t74*t9-1.269642
     2           451250142d+0*t4*(7.876233178997433d-1*t5*(-1.3127055298
     3           329054d-1*t6*t73*t74-2.0096226153166658d-3*t72)-1.31270
     4           55298329054d-1*t7*t73*t74)/t8**2)/t10+6.21814d-2*t20*t7
     5           5*t76-2.747773264188438d-3*t19*t71+1.3210398931339265d-
     6           3*t11*t71)-3.37738d-2*t27*t77*t78+7.769549222703733d-4*
     7           t26*t71)+3.37738d-2*t27*t77*t78-7.769549222703733d-4*t2
     8           6*t71)-6.21814d-2*t20*t75*t76+2.747773264188438d-3*t19*
     9           t71
              t80 = 1/t29**3.0d+0
              t81 = -2.018064062192621d-50*t29*t33*t80
              t82 = 8.648845980825518d-51*t30*t33
              t83 = 5.563624183898056d-49*rhoa*t30*t31*t79/t32**2
              t84 = 1.090454542535705d-3*t57*t71-6.21814d-2*t58*(1.18760
     1           45553756398d-1*t5*t55*t74-1.425125466450768d+0*t4*(7.01
     2           6926042943222d-1*t5*(-5.847438369119352d-2*t52*t73*t74-
     3           1.2576711796854242d-3*t72)-5.847438369119352d-2*t53*t73
     4           *t74)/t54**2)/t56
              t85 = -2.5225800777407753d-51*t29*t61*t80
              t86 = 1.0811057476031895d-51*t30*t61
              t87 = 6.954530229872565d-50*rhoa*t30*t59*t84/t60**2
              t88 = 1/rhoa**2.6666666666666666d+0
              t89 = 1.0448469194093443d-51*t47*t88-4.3880820922721503d-5
     1           2*t88
              t90 = 1/t48**5.0d+0
              t91 = -1.3250000000000003d-1*t68*t89*t90+1.325000000000000
     1           3d-1*t41*t89*t90+t51*(3.109069086965489d-2*(-2.16221149
     2           5206379d-51*rhoa*t30*t63*(t87+t86+t85+3.007433041358144
     3           6d-100*t36*t59*t84/t60**3.0d+0+5.890330668744275d-52*rh
     4           oa*t30*t64*(7.937005259840997d-51*t30-1.851967893962899
     5           7d-50*t29*t80))/t65**2+2.162211495206379d-51*rhoa*t30*t
     6           66*(t87+t86+t85)-2.5225800777407753d-51*t29*t63*t66*t80
     7           +1.0811057476031895d-51*t30*t63*t66)/t67+1.0d+0*t84)-3.
     8           1250000000000006d-2*t50*(1.5545345434827443d-2*(-8.6488
     9           45980825518d-51*rhoa*t30*t35*(t83+t82+t81+1.49605073600
     :           08343d-100*rhoa*t30*t37*(t30-2.3333333333333334d+0*t29*
     ;           t80)+9.623785732346068d-99*t31*t36*t79/t32**3.0d+0)/t38
     <           **2+8.648845980825518d-51*rhoa*t30*t39*(t83+t82+t81)-2.
     =           018064062192621d-50*t29*t35*t39*t80+8.648845980825518d-
     >           51*t30*t35*t39)/t40+1.0d+0*t79)
              fnc(iq) = 2.0d+0*rhoa*(4.375d-2*t46+1.0d+0)*t46*wght+fnc(i
     1           q)
              Amat(iq,D1_RA) = 2.0d+0*rhoa*t70*t91*wght+8.75000000000000
     1           2d-2*rhoa*t69*t91*wght+1.0d+0*t69*t70*wght+Amat(iq,D1_R
     2           A)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 2.1622114952063792d-1*gammaaa*t29*t32
              t34 = t33+1.0d+0
              t35 = gammaaa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 4.675158550002606d-2*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 2.1622114952063792d-1*gammaaa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = rhoa-rhob
              t44 = t42*t43
              t45 = 2.2599999999999998d+0*t44**6.0d+0+5.0d-1*t44**4.0d+0
     1           +8.7d-1*t44**2.0d+0+5.3d-1
              t46 = 1/t1**2.6666666666666666d+0
              t47 = 1.0d+0-t42*t43
              t48 = t44+1.0d+0
              t49 = 1/t48**1.333333333333333d+0+1/t47**1.333333333333333
     1           d+0
              t50 = t47**2
              t51 = t48**2
              t52 = gammabb*t51+gammaaa*t50-2.0d+0*gammaab*t47*t48
              t53 = 1.3060586492616802d-2*t46*t49*t52+1.0d+0
              t54 = 1/t53**4.0d+0
              t55 = t45*t54+1.0d+0
              t56 = gammabb+2.0d+0*gammaab+gammaaa
              t57 = taub+taua
              t58 = 1/t57
              t59 = t42*t56*t58
              t60 = t59**2.0d+0
              t61 = rhob**3.333333333333333d-1
              t62 = t61**5.0d-1
              t63 = 1/t62
              t64 = 1.530901310039024d-2*t63+1.0465751434d-1
              t65 = 7.876233178997433d-1*t63*t64+1.9269083139d-1
              t66 = 7.876233178997433d-1*t63*t65+4.3896648423d-1
              t67 = 1/t66
              t68 = 1.269642451250142d+0*t62*t67+1.0d+0
              t69 = log(t68)
              t70 = 1/t61
              t71 = 1.2746961887000874d-1*t70+1.0d+0
              t72 = 2.4141993114533214d-2*t63+1.0186556948d-1
              t73 = 7.876233178997433d-1*t63*t72+2.2308199064d-1
              t74 = 7.876233178997433d-1*t63*t73+4.7231125998d-1
              t75 = 1/t74
              t76 = 1.269642451250142d+0*t62*t75+1.0d+0
              t77 = log(t76)
              t78 = 1.325688999052018d-1*t70+1.0d+0
              t79 = 1.3212998810398843d-2*t63+2.9729725188d-2
              t80 = 7.876233178997433d-1*t63*t79+1.2236585478d-1
              t81 = 7.876233178997433d-1*t63*t80+3.497952466d-1
              t82 = 1/t81
              t83 = 1.269642451250142d+0*t62*t82+1.0d+0
              t84 = log(t83)
              t85 = 6.901399211255826d-2*t70+1.0d+0
              t86 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t77*t78-3.10907d-2*t69*t71)-3.37738d-2*t84*t
     2           85)+3.37738d-2*t84*t85)-6.21814d-2*t77*t78
              t87 = rhob**1.1666666666666667d+0
              t88 = 1/t87**2.0d+0
              t89 = exp(-6.432793688582967d+1*t86)
              t90 = t89-1.0d+0
              t91 = 1/t90
              t92 = 2.1622114952063792d-1*gammabb*t88*t91
              t93 = t92+1.0d+0
              t94 = gammabb*t88
              t95 = t94**2.0d+0
              t96 = 1/t90**2.0d+0
              t97 = 4.675158550002606d-2*t95*t96+t92+1.0d+0
              t98 = 1/t97
              t99 = 2.1622114952063792d-1*gammabb*t88*t93*t98+1.0d+0
              t100 = 1.5545345434827443d-2*log(t99)+1.0d+0*t86
              t101 = t1**3.333333333333333d-1
              t102 = 1/t101
              t103 = 1.325688999052018d-1*t102+1.0d+0
              t104 = t101**5.0d-1
              t105 = 1/t104
              t106 = 2.4141993114533214d-2*t105+1.0186556948d-1
              t107 = 7.876233178997433d-1*t105*t106+2.2308199064d-1
              t108 = 7.876233178997433d-1*t105*t107+4.7231125998d-1
              t109 = 1/t108
              t110 = 1.269642451250142d+0*t104*t109+1.0d+0
              t111 = log(t110)
              t112 = 1.923661050931536d+0*t48**1.3333333333333333d+0+1.9
     1           23661050931536d+0*t47**1.3333333333333333d+0-3.84732210
     2           1863072d+0
              t113 = 6.901399211255826d-2*t102+1.0d+0
              t114 = 1.3212998810398843d-2*t105+2.9729725188d-2
              t115 = 7.876233178997433d-1*t105*t114+1.2236585478d-1
              t116 = 7.876233178997433d-1*t105*t115+3.497952466d-1
              t117 = 1/t116
              t118 = 1.269642451250142d+0*t104*t117+1.0d+0
              t119 = log(t118)
              t120 = t43**4
              t121 = 1/t1**4
              t122 = 1.2746961887000874d-1*t102+1.0d+0
              t123 = 1.530901310039024d-2*t105+1.0465751434d-1
              t124 = 7.876233178997433d-1*t105*t123+1.9269083139d-1
              t125 = 7.876233178997433d-1*t105*t124+4.3896648423d-1
              t126 = 1/t125
              t127 = 1.269642451250142d+0*t104*t126+1.0d+0
              t128 = log(t127)
              t129 = 1.709920934161365d+0*(6.21814d-2*t103*t111-3.10907d
     1           -2*t122*t128)-3.37738d-2*t113*t119
              t130 = t120*t121*t129+3.37738d-2*t113*t119
              t131 = 5.848223622634648d-1*t112*t130-6.21814d-2*t103*t111
              t132 = 5.0d-1*t48**6.666666666666666d-1+5.0d-1*t47**6.6666
     1           66666666666d-1
              t133 = t132**3.0d+0
              t134 = t1**1.1666666666666667d+0
              t135 = 1/t134**2.0d+0
              t136 = t132**2.0d+0
              t137 = 1/t136
              t138 = 1/t133
              t139 = exp(-3.216396844291483d+1*t131*t138)
              t140 = t139-1.0d+0
              t141 = 1/t140
              t142 = 1.3621078885675922d-1*t135*t137*t141*t56
              t143 = t142+1.0d+0
              t144 = 1/t132**4.0d+0
              t145 = t135*t56
              t146 = t145**2.0d+0
              t147 = 1/t140**2.0d+0
              t148 = 1.855337900098064d-2*t144*t146*t147+t142+1.0d+0
              t149 = 1/t148
              t150 = 1.3621078885675922d-1*t135*t137*t143*t149*t56+1.0d+
     1           0
              t151 = log(t150)
              t152 = 3.109069086965489d-2*t133*t151+1.0d+0*t131
              t153 = 1.5625d-2*t45*t54*t60+1.0d+0
              t154 = -1.5625d-2*rhoa*t41*t42*t55*t60-1.5625d-2*rhob*t100
     1           *t42*t55*t60+t152*t153
              t155 = t59**3.0d+0
              t156 = 5.46875d-3*t154*t155+1.0d+0
              t157 = 1/t1**3
              t158 = 3.125d-2*rhoa*t157*t41*t55*t56*t58*t59
              t159 = 3.125d-2*rhob*t100*t157*t55*t56*t58*t59
              t160 = 1/t1**2
              t161 = t160*t43
              t162 = -t42
              t163 = t162+t161
              t164 = -t160*t43
              t165 = t42+t164
              t166 = 1/t47**2.333333333333333d+0
              t167 = 1/t48**2.333333333333333d+0
              t168 = 1/t1**3.6666666666666664d+0
              t169 = -3.482823064697814d-2*t168*t49*t52
              t170 = 1.3060586492616802d-2*(-1.333333333333333d+0*t165*t
     1           167-1.333333333333333d+0*t163*t166)*t46*t52+1.306058649
     2           2616802d-2*t46*(2*gammabb*t165*t48-2.0d+0*gammaab*t163*
     3           t48-2.0d+0*gammaab*t165*t47+2*gammaaa*t163*t47)*t49+t16
     4           9
              t171 = 1/t53**5.0d+0
              t172 = t44**3.0d+0
              t173 = t44**5.0d+0
              t174 = 1.74d+0*t165*t44+1.356d+1*t165*t173+2.0d+0*t165*t17
     1           2
              t175 = t174*t54-4.0d+0*t170*t171*t45
              t176 = 1.5625d-2*rhoa*t160*t41*t55*t60
              t177 = 1/rhoa**1.3333333333333333d+0
              t178 = 1/rhoa**1.3333333333333336d+0
              t179 = 1/t3**3
              t180 = 1/rhoa**6.666666666666667d-1
              t181 = 1/t17
              t182 = 2.11607075208357d-1*t16*t180*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t13*
     2           t179*t180-3.169132786263567d-3*t178)*t4-1.3127055298329
     3           054d-1*t14*t179*t180)/t15**2
              t183 = 1/t24
              t184 = 2.11607075208357d-1*t180*t23*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t179
     2           *t180*t20-1.7344776604086162d-3*t178)*t4-1.312705529832
     3           9054d-1*t179*t180*t21)/t22**2
              t185 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t12*(2.11607075208357d-1*t180*t4*t8-1.2696
     2           42451250142d+0*t3*(7.876233178997433d-1*t4*(-1.31270552
     3           98329054d-1*t179*t180*t5-2.0096226153166658d-3*t178)-1.
     4           3127055298329054d-1*t179*t180*t6)/t7**2)/t9+6.21814d-2*
     5           t181*t182*t19-2.747773264188438d-3*t177*t18+1.321039893
     6           1339265d-3*t10*t177)-3.37738d-2*t183*t184*t26+7.7695492
     7           22703733d-4*t177*t25)+3.37738d-2*t183*t184*t26-7.769549
     8           222703733d-4*t177*t25)-6.21814d-2*t181*t182*t19+2.74777
     9           3264188438d-3*t177*t18
              t186 = 1/t40
              t187 = rhoa**1.6666666666666674d-1
              t188 = 1/t28**3.0d+0
              t189 = -5.045160155481552d-1*gammaaa*t187*t188*t32
              t190 = 1.3909060459745137d+1*gammaaa*t185*t29*t30/t31**2
              t191 = 1/t38**2
              t192 = 1.5625d-2*rhob*t100*t160*t55*t60
              t193 = -3.125d-2*t160*t45*t54*t56*t58*t59
              t194 = 1/t1**1.3333333333333336d+0
              t195 = 1/t1**6.666666666666667d-1
              t196 = 1/t104**3
              t197 = 2.11607075208357d-1*t105*t109*t195-1.26964245125014
     1           2d+0*t104*(7.876233178997433d-1*t105*(-1.31270552983290
     2           54d-1*t106*t195*t196-3.169132786263567d-3*t194)-1.31270
     3           55298329054d-1*t107*t195*t196)/t108**2
              t198 = 1/t110
              t199 = -6.21814d-2*t103*t197*t198
              t200 = 1/t1**1.3333333333333333d+0
              t201 = 2.747773264188438d-3*t111*t200
              t202 = 2.11607075208357d-1*t105*t117*t195-1.26964245125014
     1           2d+0*t104*(7.876233178997433d-1*t105*(-1.31270552983290
     2           54d-1*t114*t195*t196-1.7344776604086162d-3*t194)-1.3127
     3           055298329054d-1*t115*t195*t196)/t116**2
              t203 = 1/t118
              t204 = 3.37738d-2*t113*t202*t203
              t205 = -7.769549222703733d-4*t119*t200
              t206 = t120*t121*(-3.37738d-2*t113*t202*t203+1.70992093416
     1           1365d+0*(1.3210398931339265d-3*t128*t200-2.747773264188
     2           438d-3*t111*t200+6.21814d-2*t103*t197*t198-3.10907d-2*t
     3           122*(2.11607075208357d-1*t105*t126*t195-1.2696424512501
     4           42d+0*t104*(7.876233178997433d-1*t105*(-1.3127055298329
     5           054d-1*t123*t195*t196-2.0096226153166658d-3*t194)-1.312
     6           7055298329054d-1*t124*t195*t196)/t125**2)/t127)+7.76954
     7           9222703733d-4*t119*t200)
              t207 = -4*t120*t129/t1**5
              t208 = t43**3
              t209 = t47**3.333333333333333d-1
              t210 = t48**3.333333333333333d-1
              t211 = 5.848223622634648d-1*t130*(2.564881401242048d+0*t16
     1           5*t210+2.564881401242048d+0*t163*t209)+5.84822362263464
     2           8d-1*t112*(4*t121*t129*t208+t207+t206+t205+t204)+t201+t
     3           199
              t212 = 1/t150
              t213 = 1/t209
              t214 = 1/t210
              t215 = 3.333333333333333d-1*t165*t214+3.333333333333333d-1
     1           *t163*t213
              t216 = t1**1.6666666666666674d-1
              t217 = 1/t134**3.0d+0
              t218 = -3.1782517399910487d-1*t137*t143*t149*t216*t217*t56
              t219 = -2.7242157771351844d-1*t135*t138*t141*t215*t56
              t220 = -3.1782517399910487d-1*t137*t141*t216*t217*t56
              t221 = 1/t140**2
              t222 = 9.649190532874448d+1*t131*t144*t215-3.2163968442914
     1           83d+1*t138*t211
              t223 = -1.3621078885675922d-1*t135*t137*t139*t221*t222*t56
              t224 = 1/t148**2
              t225 = -8.658243533790966d-2*t144*t145*t147*t216*t217*t56
              t226 = 1/t132**5.0d+0
              t227 = 1/t140**3.0d+0
              t228 = t152*(1.5625d-2*t174*t54*t60-6.25d-2*t170*t171*t45*
     1           t60+t193)-1.5625d-2*t41*t42*t55*t60-1.5625d-2*rhoa*(1.5
     2           545345434827443d-2*t186*(-5.045160155481552d-1*gammaaa*
     3           t187*t188*t34*t39+2.1622114952063792d-1*gammaaa*(t190+t
     4           189)*t29*t39-2.1622114952063792d-1*gammaaa*t191*t29*t34
     5           *(-2.181740656667883d-1*gammaaa*t187*t188*t35*t37+6.014
     6           866082716293d+0*t185*t30*t36/t31**3.0d+0+t190+t189))+1.
     7           0d+0*t185)*t42*t55*t60-1.5625d-2*rhoa*t175*t41*t42*t60-
     8           1.5625d-2*rhob*t100*t175*t42*t60+t153*(3.10906908696548
     9           9d-2*t133*t212*(-1.3621078885675922d-1*t135*t137*t143*t
     :           224*(-3.710675800196128d-2*t139*t144*t146*t222*t227-7.4
     ;           21351600392256d-2*t146*t147*t215*t226+t225+t223+t220+t2
     <           19)*t56+1.3621078885675922d-1*t135*t137*t149*(t223+t220
     =           +t219)*t56-2.7242157771351844d-1*t135*t138*t143*t149*t2
     >           15*t56+t218)+9.327207260896466d-2*t136*t151*t215+1.0d+0
     ?           *t211)+t192+t176+t159+t158
              t229 = -1.6406249999999997d-2*t154*t160*t56*t58*t60
              t230 = 1.0d+0*t154*t156*wght
              t231 = t164+t162
              t232 = t42+t161
              t233 = 1.3060586492616802d-2*(-1.333333333333333d+0*t166*t
     1           232-1.333333333333333d+0*t167*t231)*t46*t52+1.306058649
     2           2616802d-2*t46*(-2.0d+0*gammaab*t232*t48+2*gammabb*t231
     3           *t48+2*gammaaa*t232*t47-2.0d+0*gammaab*t231*t47)*t49+t1
     4           69
              t234 = 1.74d+0*t231*t44+1.356d+1*t173*t231+2.0d+0*t172*t23
     1           1
              t235 = t234*t54-4.0d+0*t171*t233*t45
              t236 = 1/rhob**1.3333333333333333d+0
              t237 = 1/rhob**1.3333333333333336d+0
              t238 = 1/t62**3
              t239 = 1/rhob**6.666666666666667d-1
              t240 = 1/t76
              t241 = 2.11607075208357d-1*t239*t63*t75-1.269642451250142d
     1           +0*t62*(7.876233178997433d-1*t63*(-1.3127055298329054d-
     2           1*t238*t239*t72-3.169132786263567d-3*t237)-1.3127055298
     3           329054d-1*t238*t239*t73)/t74**2
              t242 = 1/t83
              t243 = 2.11607075208357d-1*t239*t63*t82-1.269642451250142d
     1           +0*t62*(7.876233178997433d-1*t63*(-1.3127055298329054d-
     2           1*t238*t239*t79-1.7344776604086162d-3*t237)-1.312705529
     3           8329054d-1*t238*t239*t80)/t81**2
              t244 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t242*t243
     1           *t85+7.769549222703733d-4*t236*t84+1.709920934161365d+0
     2           *(6.21814d-2*t240*t241*t78-2.747773264188438d-3*t236*t7
     3           7-3.10907d-2*(2.11607075208357d-1*t239*t63*t67-1.269642
     4           451250142d+0*t62*(7.876233178997433d-1*t63*(-1.31270552
     5           98329054d-1*t238*t239*t64-2.0096226153166658d-3*t237)-1
     6           .3127055298329054d-1*t238*t239*t65)/t66**2)*t71/t68+1.3
     7           210398931339265d-3*t236*t69))+3.37738d-2*t242*t243*t85-
     8           7.769549222703733d-4*t236*t84)-6.21814d-2*t240*t241*t78
     9           +2.747773264188438d-3*t236*t77
              t245 = 1/t99
              t246 = rhob**1.6666666666666674d-1
              t247 = 1/t87**3.0d+0
              t248 = -5.045160155481552d-1*gammabb*t246*t247*t91
              t249 = 1.3909060459745137d+1*gammabb*t244*t88*t89/t90**2
              t250 = 1/t97**2
              t251 = 5.848223622634648d-1*t130*(2.564881401242048d+0*t20
     1           9*t232+2.564881401242048d+0*t210*t231)+5.84822362263464
     2           8d-1*t112*(-4*t121*t129*t208+t207+t206+t205+t204)+t201+
     3           t199
              t252 = 3.333333333333333d-1*t213*t232+3.333333333333333d-1
     1           *t214*t231
              t253 = -2.7242157771351844d-1*t135*t138*t141*t252*t56
              t254 = 9.649190532874448d+1*t131*t144*t252-3.2163968442914
     1           83d+1*t138*t251
              t255 = -1.3621078885675922d-1*t135*t137*t139*t221*t254*t56
              t256 = -1.5625d-2*rhob*t42*t55*t60*(1.5545345434827443d-2*
     1           t245*(-5.045160155481552d-1*gammabb*t246*t247*t93*t98+2
     2           .1622114952063792d-1*gammabb*(t249+t248)*t88*t98-2.1622
     3           114952063792d-1*gammabb*t250*t88*t93*(-2.18174065666788
     4           3d-1*gammabb*t246*t247*t94*t96+6.014866082716293d+0*t24
     5           4*t89*t95/t90**3.0d+0+t249+t248))+1.0d+0*t244)+t152*(1.
     6           5625d-2*t234*t54*t60-6.25d-2*t171*t233*t45*t60+t193)-1.
     7           5625d-2*t100*t42*t55*t60-1.5625d-2*rhoa*t235*t41*t42*t6
     8           0-1.5625d-2*rhob*t100*t235*t42*t60+t153*(3.109069086965
     9           489d-2*t133*t212*(-1.3621078885675922d-1*t135*t137*t143
     :           *t224*(t255-3.710675800196128d-2*t139*t144*t146*t227*t2
     ;           54+t253-7.421351600392256d-2*t146*t147*t226*t252+t225+t
     <           220)*t56+1.3621078885675922d-1*t135*t137*t149*(t255+t25
     =           3+t220)*t56-2.7242157771351844d-1*t135*t138*t143*t149*t
     >           252*t56+t218)+9.327207260896466d-2*t136*t151*t252+1.0d+
     ?           0*t251)+t192+t176+t159+t158
              t257 = -3.125d-2*rhoa*t160*t41*t55*t58*t59
              t258 = -3.125d-2*rhob*t100*t160*t55*t58*t59
              t259 = 3.125d-2*t42*t45*t54*t58*t59
              t260 = 1/t134**4.0d+0
              t261 = 3.109069086965489d-2*t133*t153*t212*(1.855337900098
     1           064d-2*t141*t144*t149*t260*t56-1.3621078885675922d-1*t1
     2           35*t137*t143*(3.710675800196128d-2*t135*t144*t145*t147+
     3           1.3621078885675922d-1*t135*t137*t141)*t224*t56+1.362107
     4           8885675922d-1*t135*t137*t143*t149)
              t262 = t152*(t259-8.162866557885502d-4*t171*t45*t46*t49*t5
     1           0*t60)-2.4289602241917876d-4*rhoa*t186*(2.1622114952063
     2           792d-1*t29*t34*t39+4.675158550002606d-2*gammaaa*t32*t39
     3           /t28**4.0d+0-2.1622114952063792d-1*gammaaa*t191*t29*t34
     4           *(9.350317100005212d-2*t29*t35*t37+2.1622114952063792d-
     5           1*t29*t32))*t42*t55*t60+8.162866557885502d-4*rhoa*t168*
     6           t171*t41*t45*t49*t50*t60+8.162866557885502d-4*rhob*t100
     7           *t168*t171*t45*t49*t50*t60+t261+t258+t257
              t263 = 1.6406249999999997d-2*t154*t42*t58*t60
              t264 = t152*(1.6325733115771002d-3*t171*t45*t46*t47*t48*t4
     1           9*t60+6.25d-2*t42*t45*t54*t58*t59)-1.6325733115771002d-
     2           3*rhoa*t168*t171*t41*t45*t47*t48*t49*t60-1.632573311577
     3           1002d-3*rhob*t100*t168*t171*t45*t47*t48*t49*t60-6.25d-2
     4           *rhoa*t160*t41*t55*t58*t59-6.25d-2*rhob*t100*t160*t55*t
     5           58*t59+3.109069086965489d-2*t133*t153*t212*(3.710675800
     6           196128d-2*t141*t144*t149*t260*t56-1.3621078885675922d-1
     7           *t135*t137*t143*(7.421351600392256d-2*t135*t144*t145*t1
     8           47+2.7242157771351844d-1*t135*t137*t141)*t224*t56+2.724
     9           2157771351844d-1*t135*t137*t143*t149)
              t265 = -2.4289602241917876d-4*rhob*t245*t42*t55*t60*(2.162
     1           2114952063792d-1*t88*t93*t98+4.675158550002606d-2*gamma
     2           bb*t91*t98/t87**4.0d+0-2.1622114952063792d-1*gammabb*t2
     3           50*t88*t93*(9.350317100005212d-2*t88*t94*t96+2.16221149
     4           52063792d-1*t88*t91))+t152*(t259-8.162866557885502d-4*t
     5           171*t45*t46*t49*t51*t60)+8.162866557885502d-4*rhoa*t168
     6           *t171*t41*t45*t49*t51*t60+8.162866557885502d-4*rhob*t10
     7           0*t168*t171*t45*t49*t51*t60+t261+t258+t257
              t266 = 1/t57**2
              t267 = 3.125d-2*rhoa*t160*t266*t41*t55*t56*t59+3.125d-2*rh
     1           ob*t100*t160*t266*t55*t56*t59-3.125d-2*t152*t266*t42*t4
     2           5*t54*t56*t59
              t268 = 1.0d+0*t1*t154*(5.46875d-3*t155*t267-1.640624999999
     1           9997d-2*t154*t266*t42*t56*t60)*wght+1.0d+0*t1*t156*t267
     2           *wght
              fnc(iq) = 1.0d+0*t1*t154*t156*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t154*(t229+5.46875d-3*t155*t228
     1           )*wght+1.0d+0*t1*t156*t228*wght+t230+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t154*(5.46875d-3*t155*t256+t229
     1           )*wght+1.0d+0*t1*t156*t256*wght+t230+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = 1.0d+0*t1*t154*(t263+5.46875d-3*t155*t26
     1           2)*wght+1.0d+0*t1*t156*t262*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = 1.0d+0*t1*t154*(3.2812499999999994d-2*t1
     1           54*t42*t58*t60+5.46875d-3*t155*t264)*wght+1.0d+0*t1*t15
     2           6*t264*wght+Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = 1.0d+0*t1*t154*(5.46875d-3*t155*t265+t26
     1           3)*wght+1.0d+0*t1*t156*t265*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = t268+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = t268+Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 2.1622114952063792d-1*gammaaa*t29*t32
              t34 = t33+1.0d+0
              t35 = gammaaa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 4.675158550002606d-2*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 2.1622114952063792d-1*gammaaa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = rhoa-rhob
              t44 = t42*t43
              t45 = 2.2599999999999998d+0*t44**6.0d+0+5.0d-1*t44**4.0d+0
     1           +8.7d-1*t44**2.0d+0+5.3d-1
              t46 = 1/t1**2.6666666666666666d+0
              t47 = 1.0d+0-t42*t43
              t48 = t44+1.0d+0
              t49 = 1/t48**1.333333333333333d+0+1/t47**1.333333333333333
     1           d+0
              t50 = t47**2
              t51 = t48**2
              t52 = 4.0d-50*rhob*t51+gammaaa*t50
              t53 = 1.3060586492616802d-2*t46*t49*t52+1.0d+0
              t54 = 1/t53**4.0d+0
              t55 = t45*t54+1.0d+0
              t56 = 4.0d-50*rhob+gammaaa
              t57 = taua+1.0d-50
              t58 = 1/t57
              t59 = t42*t56*t58
              t60 = t59**2.0d+0
              t61 = rhob**3.333333333333333d-1
              t62 = t61**5.0d-1
              t63 = 1/t62
              t64 = 1.530901310039024d-2*t63+1.0465751434d-1
              t65 = 7.876233178997433d-1*t63*t64+1.9269083139d-1
              t66 = 7.876233178997433d-1*t63*t65+4.3896648423d-1
              t67 = 1/t66
              t68 = 1.269642451250142d+0*t62*t67+1.0d+0
              t69 = log(t68)
              t70 = 1/t61
              t71 = 1.2746961887000874d-1*t70+1.0d+0
              t72 = 2.4141993114533214d-2*t63+1.0186556948d-1
              t73 = 7.876233178997433d-1*t63*t72+2.2308199064d-1
              t74 = 7.876233178997433d-1*t63*t73+4.7231125998d-1
              t75 = 1/t74
              t76 = 1.269642451250142d+0*t62*t75+1.0d+0
              t77 = log(t76)
              t78 = 1.325688999052018d-1*t70+1.0d+0
              t79 = 1.3212998810398843d-2*t63+2.9729725188d-2
              t80 = 7.876233178997433d-1*t63*t79+1.2236585478d-1
              t81 = 7.876233178997433d-1*t63*t80+3.497952466d-1
              t82 = 1/t81
              t83 = 1.269642451250142d+0*t62*t82+1.0d+0
              t84 = log(t83)
              t85 = 6.901399211255826d-2*t70+1.0d+0
              t86 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t77*t78-3.10907d-2*t69*t71)-3.37738d-2*t84*t
     2           85)+3.37738d-2*t84*t85)-6.21814d-2*t77*t78
              t87 = rhob**1.1666666666666667d+0
              t88 = 1/t87**2.0d+0
              t89 = exp(-6.432793688582967d+1*t86)
              t90 = t89-1.0d+0
              t91 = 1/t90
              t92 = 8.648845980825518d-51*rhob*t88*t91
              t93 = t92+1.0d+0
              t94 = rhob*t88
              t95 = t94**2.0d+0
              t96 = 1/t90**2.0d+0
              t97 = 7.480253680004171d-101*t95*t96+t92+1.0d+0
              t98 = 1/t97
              t99 = 8.648845980825518d-51*rhob*t88*t93*t98+1.0d+0
              t100 = 1.5545345434827443d-2*log(t99)+1.0d+0*t86
              t101 = t1**3.333333333333333d-1
              t102 = 1/t101
              t103 = 1.325688999052018d-1*t102+1.0d+0
              t104 = t101**5.0d-1
              t105 = 1/t104
              t106 = 2.4141993114533214d-2*t105+1.0186556948d-1
              t107 = 7.876233178997433d-1*t105*t106+2.2308199064d-1
              t108 = 7.876233178997433d-1*t105*t107+4.7231125998d-1
              t109 = 1/t108
              t110 = 1.269642451250142d+0*t104*t109+1.0d+0
              t111 = log(t110)
              t112 = 1.923661050931536d+0*t48**1.3333333333333333d+0+1.9
     1           23661050931536d+0*t47**1.3333333333333333d+0-3.84732210
     2           1863072d+0
              t113 = 6.901399211255826d-2*t102+1.0d+0
              t114 = 1.3212998810398843d-2*t105+2.9729725188d-2
              t115 = 7.876233178997433d-1*t105*t114+1.2236585478d-1
              t116 = 7.876233178997433d-1*t105*t115+3.497952466d-1
              t117 = 1/t116
              t118 = 1.269642451250142d+0*t104*t117+1.0d+0
              t119 = log(t118)
              t120 = t43**4
              t121 = 1/t1**4
              t122 = 1.2746961887000874d-1*t102+1.0d+0
              t123 = 1.530901310039024d-2*t105+1.0465751434d-1
              t124 = 7.876233178997433d-1*t105*t123+1.9269083139d-1
              t125 = 7.876233178997433d-1*t105*t124+4.3896648423d-1
              t126 = 1/t125
              t127 = 1.269642451250142d+0*t104*t126+1.0d+0
              t128 = log(t127)
              t129 = 1.709920934161365d+0*(6.21814d-2*t103*t111-3.10907d
     1           -2*t122*t128)-3.37738d-2*t113*t119
              t130 = t120*t121*t129+3.37738d-2*t113*t119
              t131 = 5.848223622634648d-1*t112*t130-6.21814d-2*t103*t111
              t132 = 5.0d-1*t48**6.666666666666666d-1+5.0d-1*t47**6.6666
     1           66666666666d-1
              t133 = t132**3.0d+0
              t134 = t1**1.1666666666666667d+0
              t135 = 1/t134**2.0d+0
              t136 = t132**2.0d+0
              t137 = 1/t136
              t138 = 1/t133
              t139 = exp(-3.216396844291483d+1*t131*t138)
              t140 = t139-1.0d+0
              t141 = 1/t140
              t142 = 1.3621078885675922d-1*t135*t137*t141*t56
              t143 = t142+1.0d+0
              t144 = 1/t132**4.0d+0
              t145 = t135*t56
              t146 = t145**2.0d+0
              t147 = 1/t140**2.0d+0
              t148 = 1.855337900098064d-2*t144*t146*t147+t142+1.0d+0
              t149 = 1/t148
              t150 = 1.3621078885675922d-1*t135*t137*t143*t149*t56+1.0d+
     1           0
              t151 = log(t150)
              t152 = 3.109069086965489d-2*t133*t151+1.0d+0*t131
              t153 = 1.5625d-2*t45*t54*t60+1.0d+0
              t154 = -1.5625d-2*rhoa*t41*t42*t55*t60-1.5625d-2*rhob*t100
     1           *t42*t55*t60+t152*t153
              t155 = t59**3.0d+0
              t156 = 5.46875d-3*t154*t155+1.0d+0
              t157 = 1/t1**3
              t158 = 1/t1**2
              t159 = t158*t43
              t160 = -t42
              t161 = t160+t159
              t162 = -t158*t43
              t163 = t42+t162
              t164 = 1/t47**2.333333333333333d+0
              t165 = 1/t48**2.333333333333333d+0
              t166 = 1/t1**3.6666666666666664d+0
              t167 = -3.482823064697814d-2*t166*t49*t52
              t168 = 1.3060586492616802d-2*(-1.333333333333333d+0*t163*t
     1           165-1.333333333333333d+0*t161*t164)*t46*t52+1.306058649
     2           2616802d-2*t46*(8.0d-50*rhob*t163*t48+2*gammaaa*t161*t4
     3           7)*t49+t167
              t169 = 1/t53**5.0d+0
              t170 = t44**3.0d+0
              t171 = t44**5.0d+0
              t172 = 1.74d+0*t163*t44+1.356d+1*t163*t171+2.0d+0*t163*t17
     1           0
              t173 = t172*t54-4.0d+0*t168*t169*t45
              t174 = 1.5625d-2*rhoa*t158*t41*t55*t60
              t175 = 1/rhoa**1.3333333333333333d+0
              t176 = 1/rhoa**1.3333333333333336d+0
              t177 = 1/t3**3
              t178 = 1/rhoa**6.666666666666667d-1
              t179 = 1/t17
              t180 = 2.11607075208357d-1*t16*t178*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t13*
     2           t177*t178-3.169132786263567d-3*t176)*t4-1.3127055298329
     3           054d-1*t14*t177*t178)/t15**2
              t181 = 1/t24
              t182 = 2.11607075208357d-1*t178*t23*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t177
     2           *t178*t20-1.7344776604086162d-3*t176)*t4-1.312705529832
     3           9054d-1*t177*t178*t21)/t22**2
              t183 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t12*(2.11607075208357d-1*t178*t4*t8-1.2696
     2           42451250142d+0*t3*(7.876233178997433d-1*t4*(-1.31270552
     3           98329054d-1*t177*t178*t5-2.0096226153166658d-3*t176)-1.
     4           3127055298329054d-1*t177*t178*t6)/t7**2)/t9+6.21814d-2*
     5           t179*t180*t19-2.747773264188438d-3*t175*t18+1.321039893
     6           1339265d-3*t10*t175)-3.37738d-2*t181*t182*t26+7.7695492
     7           22703733d-4*t175*t25)+3.37738d-2*t181*t182*t26-7.769549
     8           222703733d-4*t175*t25)-6.21814d-2*t179*t180*t19+2.74777
     9           3264188438d-3*t175*t18
              t184 = 1/t40
              t185 = rhoa**1.6666666666666674d-1
              t186 = 1/t28**3.0d+0
              t187 = -5.045160155481552d-1*gammaaa*t185*t186*t32
              t188 = 1.3909060459745137d+1*gammaaa*t183*t29*t30/t31**2
              t189 = 1/t38**2
              t190 = 1.5625d-2*rhob*t100*t158*t55*t60
              t191 = 1/t1**1.3333333333333336d+0
              t192 = 1/t1**6.666666666666667d-1
              t193 = 1/t104**3
              t194 = 2.11607075208357d-1*t105*t109*t192-1.26964245125014
     1           2d+0*t104*(7.876233178997433d-1*t105*(-1.31270552983290
     2           54d-1*t106*t192*t193-3.169132786263567d-3*t191)-1.31270
     3           55298329054d-1*t107*t192*t193)/t108**2
              t195 = 1/t110
              t196 = -6.21814d-2*t103*t194*t195
              t197 = 1/t1**1.3333333333333333d+0
              t198 = 2.747773264188438d-3*t111*t197
              t199 = 2.11607075208357d-1*t105*t117*t192-1.26964245125014
     1           2d+0*t104*(7.876233178997433d-1*t105*(-1.31270552983290
     2           54d-1*t114*t192*t193-1.7344776604086162d-3*t191)-1.3127
     3           055298329054d-1*t115*t192*t193)/t116**2
              t200 = 1/t118
              t201 = 3.37738d-2*t113*t199*t200
              t202 = -7.769549222703733d-4*t119*t197
              t203 = t120*t121*(-3.37738d-2*t113*t199*t200+1.70992093416
     1           1365d+0*(1.3210398931339265d-3*t128*t197-2.747773264188
     2           438d-3*t111*t197+6.21814d-2*t103*t194*t195-3.10907d-2*t
     3           122*(2.11607075208357d-1*t105*t126*t192-1.2696424512501
     4           42d+0*t104*(7.876233178997433d-1*t105*(-1.3127055298329
     5           054d-1*t123*t192*t193-2.0096226153166658d-3*t191)-1.312
     6           7055298329054d-1*t124*t192*t193)/t125**2)/t127)+7.76954
     7           9222703733d-4*t119*t197)
              t204 = -4*t120*t129/t1**5
              t205 = t43**3
              t206 = t47**3.333333333333333d-1
              t207 = t48**3.333333333333333d-1
              t208 = 5.848223622634648d-1*t130*(2.564881401242048d+0*t16
     1           3*t207+2.564881401242048d+0*t161*t206)+5.84822362263464
     2           8d-1*t112*(4*t121*t129*t205+t204+t203+t202+t201)+t198+t
     3           196
              t209 = 1/t150
              t210 = 1/t206
              t211 = 1/t207
              t212 = 3.333333333333333d-1*t163*t211+3.333333333333333d-1
     1           *t161*t210
              t213 = t1**1.6666666666666674d-1
              t214 = 1/t134**3.0d+0
              t215 = -3.1782517399910487d-1*t137*t143*t149*t213*t214*t56
              t216 = -2.7242157771351844d-1*t135*t138*t141*t212*t56
              t217 = -3.1782517399910487d-1*t137*t141*t213*t214*t56
              t218 = 1/t140**2
              t219 = 9.649190532874448d+1*t131*t144*t212-3.2163968442914
     1           83d+1*t138*t208
              t220 = -1.3621078885675922d-1*t135*t137*t139*t218*t219*t56
              t221 = 1/t148**2
              t222 = 1/t132**5.0d+0
              t223 = 1/t140**3.0d+0
              t224 = t152*(1.5625d-2*t172*t54*t60-6.25d-2*t168*t169*t45*
     1           t60-3.125d-2*t158*t45*t54*t56*t58*t59)-1.5625d-2*t41*t4
     2           2*t55*t60-1.5625d-2*rhoa*(1.5545345434827443d-2*t184*(-
     3           5.045160155481552d-1*gammaaa*t185*t186*t34*t39+2.162211
     4           4952063792d-1*gammaaa*(t188+t187)*t29*t39-2.16221149520
     5           63792d-1*gammaaa*t189*t29*t34*(-2.181740656667883d-1*ga
     6           mmaaa*t185*t186*t35*t37+6.014866082716293d+0*t183*t30*t
     7           36/t31**3.0d+0+t188+t187))+1.0d+0*t183)*t42*t55*t60-1.5
     8           625d-2*rhoa*t173*t41*t42*t60-1.5625d-2*rhob*t100*t173*t
     9           42*t60+3.125d-2*rhoa*t157*t41*t55*t56*t58*t59+3.125d-2*
     :           rhob*t100*t157*t55*t56*t58*t59+t153*(3.109069086965489d
     ;           -2*t133*t209*(-1.3621078885675922d-1*t135*t137*t143*t22
     <           1*t56*(-8.658243533790966d-2*t144*t145*t147*t213*t214*t
     =           56-3.710675800196128d-2*t139*t144*t146*t219*t223-7.4213
     >           51600392256d-2*t146*t147*t212*t222+t220+t217+t216)+1.36
     ?           21078885675922d-1*t135*t137*t149*(t220+t217+t216)*t56-2
     @           .7242157771351844d-1*t135*t138*t143*t149*t212*t56+t215)
     1           +9.327207260896466d-2*t136*t151*t212+1.0d+0*t208)+t190+
     2           t174
              t225 = 1.0d+0*t154*t156*wght
              t226 = 4.0d-50*t42*t58-t158*t56*t58
              t227 = t42+t159
              t228 = t162+t160
              t229 = 1.3060586492616802d-2*(-1.333333333333333d+0*t165*t
     1           228-1.333333333333333d+0*t164*t227)*t46*t52+1.306058649
     2           2616802d-2*t46*t49*(4.0d-50*t51+8.0d-50*rhob*t228*t48+2
     3           *gammaaa*t227*t47)+t167
              t230 = 1.74d+0*t228*t44+1.356d+1*t171*t228+2.0d+0*t170*t22
     1           8
              t231 = t230*t54-4.0d+0*t169*t229*t45
              t232 = 1/rhob**1.3333333333333333d+0
              t233 = 1/rhob**1.3333333333333336d+0
              t234 = 1/t62**3
              t235 = 1/rhob**6.666666666666667d-1
              t236 = 1/t76
              t237 = 2.11607075208357d-1*t235*t63*t75-1.269642451250142d
     1           +0*t62*(7.876233178997433d-1*t63*(-1.3127055298329054d-
     2           1*t234*t235*t72-3.169132786263567d-3*t233)-1.3127055298
     3           329054d-1*t234*t235*t73)/t74**2
              t238 = 1/t83
              t239 = 2.11607075208357d-1*t235*t63*t82-1.269642451250142d
     1           +0*t62*(7.876233178997433d-1*t63*(-1.3127055298329054d-
     2           1*t234*t235*t79-1.7344776604086162d-3*t233)-1.312705529
     3           8329054d-1*t234*t235*t80)/t81**2
              t240 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t238*t239
     1           *t85+7.769549222703733d-4*t232*t84+1.709920934161365d+0
     2           *(6.21814d-2*t236*t237*t78-2.747773264188438d-3*t232*t7
     3           7-3.10907d-2*(2.11607075208357d-1*t235*t63*t67-1.269642
     4           451250142d+0*t62*(7.876233178997433d-1*t63*(-1.31270552
     5           98329054d-1*t234*t235*t64-2.0096226153166658d-3*t233)-1
     6           .3127055298329054d-1*t234*t235*t65)/t66**2)*t71/t68+1.3
     7           210398931339265d-3*t232*t69))+3.37738d-2*t238*t239*t85-
     8           7.769549222703733d-4*t232*t84)-6.21814d-2*t236*t237*t78
     9           +2.747773264188438d-3*t232*t77
              t241 = 1/t87**3.0d+0
              t242 = -2.018064062192621d-50*t241*t87*t91
              t243 = 8.648845980825518d-51*t88*t91
              t244 = 5.563624183898056d-49*rhob*t240*t88*t89/t90**2
              t245 = 5.848223622634648d-1*t130*(2.564881401242048d+0*t20
     1           7*t228+2.564881401242048d+0*t206*t227)+5.84822362263464
     2           8d-1*t112*(-4*t121*t129*t205+t204+t203+t202+t201)+t198+
     3           t196
              t246 = 3.333333333333333d-1*t211*t228+3.333333333333333d-1
     1           *t210*t227
              t247 = -2.7242157771351844d-1*t135*t138*t141*t246*t56
              t248 = 5.44843155427037d-51*t135*t137*t141
              t249 = 9.649190532874448d+1*t131*t144*t246-3.2163968442914
     1           83d+1*t138*t245
              t250 = -1.3621078885675922d-1*t135*t137*t139*t218*t249*t56
              t251 = -1.5625d-2*rhob*t42*t55*t60*(1.5545345434827443d-2*
     1           (8.648845980825518d-51*t88*t93*t98-2.018064062192621d-5
     2           0*t241*t87*t93*t98+8.648845980825518d-51*rhob*(t244+t24
     3           3+t242)*t88*t98-8.648845980825518d-51*rhob*t88*t93*(1.4
     4           960507360008343d-100*(t88-2.3333333333333334d+0*t241*t8
     5           7)*t94*t96+9.623785732346068d-99*t240*t89*t95/t90**3.0d
     6           +0+t244+t243+t242)/t97**2)/t99+1.0d+0*t240)+t152*(1.562
     7           5d-2*t230*t54*t60-6.25d-2*t169*t229*t45*t60+3.125d-2*t2
     8           26*t45*t54*t59)-1.5625d-2*t100*t42*t55*t60-1.5625d-2*rh
     9           oa*t231*t41*t42*t60-1.5625d-2*rhob*t100*t231*t42*t60-3.
     :           125d-2*rhoa*t226*t41*t42*t55*t59-3.125d-2*rhob*t100*t22
     ;           6*t42*t55*t59+t153*(3.109069086965489d-2*t133*t209*(-1.
     <           3621078885675922d-1*t135*t137*t143*t221*t56*(3.71067580
     =           0196128d-2*t144*t145*t147*(4.0d-50*t135-2.3333333333333
     >           334d+0*t213*t214*t56)+t250-3.710675800196128d-2*t139*t1
     ?           44*t146*t223*t249+t248+t247-7.421351600392256d-2*t146*t
     @           147*t222*t246+t217)+1.3621078885675922d-1*t135*t137*t14
     1           9*(t250+t248+t247+t217)*t56-2.7242157771351844d-1*t135*
     2           t138*t143*t149*t246*t56+t215+5.44843155427037d-51*t135*
     3           t137*t143*t149)+9.327207260896466d-2*t136*t151*t246+1.0
     4           d+0*t245)+t190+t174
              t252 = t152*(3.125d-2*t42*t45*t54*t58*t59-8.16286655788550
     1           2d-4*t169*t45*t46*t49*t50*t60)-2.4289602241917876d-4*rh
     2           oa*t184*(2.1622114952063792d-1*t29*t34*t39+4.6751585500
     3           02606d-2*gammaaa*t32*t39/t28**4.0d+0-2.1622114952063792
     4           d-1*gammaaa*t189*t29*t34*(9.350317100005212d-2*t29*t35*
     5           t37+2.1622114952063792d-1*t29*t32))*t42*t55*t60+8.16286
     6           6557885502d-4*rhoa*t166*t169*t41*t45*t49*t50*t60+8.1628
     7           66557885502d-4*rhob*t100*t166*t169*t45*t49*t50*t60-3.12
     8           5d-2*rhoa*t158*t41*t55*t58*t59-3.125d-2*rhob*t100*t158*
     9           t55*t58*t59+3.109069086965489d-2*t133*t153*t209*(-1.362
     :           1078885675922d-1*t135*t137*t143*(3.710675800196128d-2*t
     ;           135*t144*t145*t147+1.3621078885675922d-1*t135*t137*t141
     <           )*t221*t56+1.855337900098064d-2*t141*t144*t149*t56/t134
     =           **4.0d+0+1.3621078885675922d-1*t135*t137*t143*t149)
              t253 = 1/t57**2
              t254 = 3.125d-2*rhoa*t158*t253*t41*t55*t56*t59+3.125d-2*rh
     1           ob*t100*t158*t253*t55*t56*t59-3.125d-2*t152*t253*t42*t4
     2           5*t54*t56*t59
              fnc(iq) = 1.0d+0*t1*t154*t156*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t154*(5.46875d-3*t155*t224-1.64
     1           06249999999997d-2*t154*t158*t56*t58*t60)*wght+1.0d+0*t1
     2           *t156*t224*wght+t225+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t154*(1.6406249999999997d-2*t15
     1           4*t226*t60+5.46875d-3*t155*t251)*wght+1.0d+0*t1*t156*t2
     2           51*wght+t225+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = 1.0d+0*t1*t154*(1.6406249999999997d-2*t1
     1           54*t42*t58*t60+5.46875d-3*t155*t252)*wght+1.0d+0*t1*t15
     2           6*t252*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = 1.0d+0*t1*t154*(5.46875d-3*t155*t254-1.64
     1           06249999999997d-2*t154*t253*t42*t56*t60)*wght+1.0d+0*t1
     2           *t156*t254*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 8.648845980825518d-51*rhoa*t29*t32
              t34 = t33+1.0d+0
              t35 = rhoa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 7.480253680004171d-101*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 8.648845980825518d-51*rhoa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = rhoa-rhob
              t44 = t42*t43
              t45 = 2.2599999999999998d+0*t44**6.0d+0+5.0d-1*t44**4.0d+0
     1           +8.7d-1*t44**2.0d+0+5.3d-1
              t46 = 1/t1**2.6666666666666666d+0
              t47 = 1.0d+0-t42*t43
              t48 = t44+1.0d+0
              t49 = 1/t48**1.333333333333333d+0+1/t47**1.333333333333333
     1           d+0
              t50 = t47**2
              t51 = t48**2
              t52 = gammabb*t51+4.0d-50*rhoa*t50
              t53 = 1.3060586492616802d-2*t46*t49*t52+1.0d+0
              t54 = 1/t53**4.0d+0
              t55 = t45*t54+1.0d+0
              t56 = 4.0d-50*rhoa+gammabb
              t57 = taub+1.0d-50
              t58 = 1/t57
              t59 = t42*t56*t58
              t60 = t59**2.0d+0
              t61 = rhob**3.333333333333333d-1
              t62 = t61**5.0d-1
              t63 = 1/t62
              t64 = 1.530901310039024d-2*t63+1.0465751434d-1
              t65 = 7.876233178997433d-1*t63*t64+1.9269083139d-1
              t66 = 7.876233178997433d-1*t63*t65+4.3896648423d-1
              t67 = 1/t66
              t68 = 1.269642451250142d+0*t62*t67+1.0d+0
              t69 = log(t68)
              t70 = 1/t61
              t71 = 1.2746961887000874d-1*t70+1.0d+0
              t72 = 2.4141993114533214d-2*t63+1.0186556948d-1
              t73 = 7.876233178997433d-1*t63*t72+2.2308199064d-1
              t74 = 7.876233178997433d-1*t63*t73+4.7231125998d-1
              t75 = 1/t74
              t76 = 1.269642451250142d+0*t62*t75+1.0d+0
              t77 = log(t76)
              t78 = 1.325688999052018d-1*t70+1.0d+0
              t79 = 1.3212998810398843d-2*t63+2.9729725188d-2
              t80 = 7.876233178997433d-1*t63*t79+1.2236585478d-1
              t81 = 7.876233178997433d-1*t63*t80+3.497952466d-1
              t82 = 1/t81
              t83 = 1.269642451250142d+0*t62*t82+1.0d+0
              t84 = log(t83)
              t85 = 6.901399211255826d-2*t70+1.0d+0
              t86 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t77*t78-3.10907d-2*t69*t71)-3.37738d-2*t84*t
     2           85)+3.37738d-2*t84*t85)-6.21814d-2*t77*t78
              t87 = rhob**1.1666666666666667d+0
              t88 = 1/t87**2.0d+0
              t89 = exp(-6.432793688582967d+1*t86)
              t90 = t89-1.0d+0
              t91 = 1/t90
              t92 = 2.1622114952063792d-1*gammabb*t88*t91
              t93 = t92+1.0d+0
              t94 = gammabb*t88
              t95 = t94**2.0d+0
              t96 = 1/t90**2.0d+0
              t97 = 4.675158550002606d-2*t95*t96+t92+1.0d+0
              t98 = 1/t97
              t99 = 2.1622114952063792d-1*gammabb*t88*t93*t98+1.0d+0
              t100 = 1.5545345434827443d-2*log(t99)+1.0d+0*t86
              t101 = t1**3.333333333333333d-1
              t102 = 1/t101
              t103 = 1.325688999052018d-1*t102+1.0d+0
              t104 = t101**5.0d-1
              t105 = 1/t104
              t106 = 2.4141993114533214d-2*t105+1.0186556948d-1
              t107 = 7.876233178997433d-1*t105*t106+2.2308199064d-1
              t108 = 7.876233178997433d-1*t105*t107+4.7231125998d-1
              t109 = 1/t108
              t110 = 1.269642451250142d+0*t104*t109+1.0d+0
              t111 = log(t110)
              t112 = 1.923661050931536d+0*t48**1.3333333333333333d+0+1.9
     1           23661050931536d+0*t47**1.3333333333333333d+0-3.84732210
     2           1863072d+0
              t113 = 6.901399211255826d-2*t102+1.0d+0
              t114 = 1.3212998810398843d-2*t105+2.9729725188d-2
              t115 = 7.876233178997433d-1*t105*t114+1.2236585478d-1
              t116 = 7.876233178997433d-1*t105*t115+3.497952466d-1
              t117 = 1/t116
              t118 = 1.269642451250142d+0*t104*t117+1.0d+0
              t119 = log(t118)
              t120 = t43**4
              t121 = 1/t1**4
              t122 = 1.2746961887000874d-1*t102+1.0d+0
              t123 = 1.530901310039024d-2*t105+1.0465751434d-1
              t124 = 7.876233178997433d-1*t105*t123+1.9269083139d-1
              t125 = 7.876233178997433d-1*t105*t124+4.3896648423d-1
              t126 = 1/t125
              t127 = 1.269642451250142d+0*t104*t126+1.0d+0
              t128 = log(t127)
              t129 = 1.709920934161365d+0*(6.21814d-2*t103*t111-3.10907d
     1           -2*t122*t128)-3.37738d-2*t113*t119
              t130 = t120*t121*t129+3.37738d-2*t113*t119
              t131 = 5.848223622634648d-1*t112*t130-6.21814d-2*t103*t111
              t132 = 5.0d-1*t48**6.666666666666666d-1+5.0d-1*t47**6.6666
     1           66666666666d-1
              t133 = t132**3.0d+0
              t134 = t1**1.1666666666666667d+0
              t135 = 1/t134**2.0d+0
              t136 = t132**2.0d+0
              t137 = 1/t136
              t138 = 1/t133
              t139 = exp(-3.216396844291483d+1*t131*t138)
              t140 = t139-1.0d+0
              t141 = 1/t140
              t142 = 1.3621078885675922d-1*t135*t137*t141*t56
              t143 = t142+1.0d+0
              t144 = 1/t132**4.0d+0
              t145 = t135*t56
              t146 = t145**2.0d+0
              t147 = 1/t140**2.0d+0
              t148 = 1.855337900098064d-2*t144*t146*t147+t142+1.0d+0
              t149 = 1/t148
              t150 = 1.3621078885675922d-1*t135*t137*t143*t149*t56+1.0d+
     1           0
              t151 = log(t150)
              t152 = 3.109069086965489d-2*t133*t151+1.0d+0*t131
              t153 = 1.5625d-2*t45*t54*t60+1.0d+0
              t154 = -1.5625d-2*rhoa*t41*t42*t55*t60-1.5625d-2*rhob*t100
     1           *t42*t55*t60+t152*t153
              t155 = t59**3.0d+0
              t156 = 5.46875d-3*t154*t155+1.0d+0
              t157 = 1/t1**2
              t158 = 4.0d-50*t42*t58-t157*t56*t58
              t159 = t157*t43
              t160 = -t42
              t161 = t160+t159
              t162 = -t157*t43
              t163 = t42+t162
              t164 = 1/t47**2.333333333333333d+0
              t165 = 1/t48**2.333333333333333d+0
              t166 = 1/t1**3.6666666666666664d+0
              t167 = -3.482823064697814d-2*t166*t49*t52
              t168 = 1.3060586492616802d-2*(-1.333333333333333d+0*t163*t
     1           165-1.333333333333333d+0*t161*t164)*t46*t52+1.306058649
     2           2616802d-2*t46*t49*(4.0d-50*t50+2*gammabb*t163*t48+8.0d
     3           -50*rhoa*t161*t47)+t167
              t169 = 1/t53**5.0d+0
              t170 = t44**3.0d+0
              t171 = t44**5.0d+0
              t172 = 1.74d+0*t163*t44+1.356d+1*t163*t171+2.0d+0*t163*t17
     1           0
              t173 = t172*t54-4.0d+0*t168*t169*t45
              t174 = 1.5625d-2*rhoa*t157*t41*t55*t60
              t175 = 1/rhoa**1.3333333333333333d+0
              t176 = 1/rhoa**1.3333333333333336d+0
              t177 = 1/t3**3
              t178 = 1/rhoa**6.666666666666667d-1
              t179 = 1/t17
              t180 = 2.11607075208357d-1*t16*t178*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t13*
     2           t177*t178-3.169132786263567d-3*t176)*t4-1.3127055298329
     3           054d-1*t14*t177*t178)/t15**2
              t181 = 1/t24
              t182 = 2.11607075208357d-1*t178*t23*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t177
     2           *t178*t20-1.7344776604086162d-3*t176)*t4-1.312705529832
     3           9054d-1*t177*t178*t21)/t22**2
              t183 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t12*(2.11607075208357d-1*t178*t4*t8-1.2696
     2           42451250142d+0*t3*(7.876233178997433d-1*t4*(-1.31270552
     3           98329054d-1*t177*t178*t5-2.0096226153166658d-3*t176)-1.
     4           3127055298329054d-1*t177*t178*t6)/t7**2)/t9+6.21814d-2*
     5           t179*t180*t19-2.747773264188438d-3*t175*t18+1.321039893
     6           1339265d-3*t10*t175)-3.37738d-2*t181*t182*t26+7.7695492
     7           22703733d-4*t175*t25)+3.37738d-2*t181*t182*t26-7.769549
     8           222703733d-4*t175*t25)-6.21814d-2*t179*t180*t19+2.74777
     9           3264188438d-3*t175*t18
              t184 = 1/t28**3.0d+0
              t185 = -2.018064062192621d-50*t184*t28*t32
              t186 = 8.648845980825518d-51*t29*t32
              t187 = 5.563624183898056d-49*rhoa*t183*t29*t30/t31**2
              t188 = 1.5625d-2*rhob*t100*t157*t55*t60
              t189 = 1/t1**1.3333333333333336d+0
              t190 = 1/t1**6.666666666666667d-1
              t191 = 1/t104**3
              t192 = 2.11607075208357d-1*t105*t109*t190-1.26964245125014
     1           2d+0*t104*(7.876233178997433d-1*t105*(-1.31270552983290
     2           54d-1*t106*t190*t191-3.169132786263567d-3*t189)-1.31270
     3           55298329054d-1*t107*t190*t191)/t108**2
              t193 = 1/t110
              t194 = -6.21814d-2*t103*t192*t193
              t195 = 1/t1**1.3333333333333333d+0
              t196 = 2.747773264188438d-3*t111*t195
              t197 = 2.11607075208357d-1*t105*t117*t190-1.26964245125014
     1           2d+0*t104*(7.876233178997433d-1*t105*(-1.31270552983290
     2           54d-1*t114*t190*t191-1.7344776604086162d-3*t189)-1.3127
     3           055298329054d-1*t115*t190*t191)/t116**2
              t198 = 1/t118
              t199 = 3.37738d-2*t113*t197*t198
              t200 = -7.769549222703733d-4*t119*t195
              t201 = t120*t121*(-3.37738d-2*t113*t197*t198+1.70992093416
     1           1365d+0*(1.3210398931339265d-3*t128*t195-2.747773264188
     2           438d-3*t111*t195+6.21814d-2*t103*t192*t193-3.10907d-2*t
     3           122*(2.11607075208357d-1*t105*t126*t190-1.2696424512501
     4           42d+0*t104*(7.876233178997433d-1*t105*(-1.3127055298329
     5           054d-1*t123*t190*t191-2.0096226153166658d-3*t189)-1.312
     6           7055298329054d-1*t124*t190*t191)/t125**2)/t127)+7.76954
     7           9222703733d-4*t119*t195)
              t202 = -4*t120*t129/t1**5
              t203 = t43**3
              t204 = t47**3.333333333333333d-1
              t205 = t48**3.333333333333333d-1
              t206 = 5.848223622634648d-1*t130*(2.564881401242048d+0*t16
     1           3*t205+2.564881401242048d+0*t161*t204)+5.84822362263464
     2           8d-1*t112*(4*t121*t129*t203+t202+t201+t200+t199)+t196+t
     3           194
              t207 = 1/t150
              t208 = 1/t204
              t209 = 1/t205
              t210 = 3.333333333333333d-1*t163*t209+3.333333333333333d-1
     1           *t161*t208
              t211 = t1**1.6666666666666674d-1
              t212 = 1/t134**3.0d+0
              t213 = -3.1782517399910487d-1*t137*t143*t149*t211*t212*t56
              t214 = -2.7242157771351844d-1*t135*t138*t141*t210*t56
              t215 = -3.1782517399910487d-1*t137*t141*t211*t212*t56
              t216 = 5.44843155427037d-51*t135*t137*t141
              t217 = 1/t140**2
              t218 = 9.649190532874448d+1*t131*t144*t210-3.2163968442914
     1           83d+1*t138*t206
              t219 = -1.3621078885675922d-1*t135*t137*t139*t217*t218*t56
              t220 = 1/t148**2
              t221 = 1/t132**5.0d+0
              t222 = 1/t140**3.0d+0
              t223 = t152*(1.5625d-2*t172*t54*t60-6.25d-2*t168*t169*t45*
     1           t60+3.125d-2*t158*t45*t54*t59)-1.5625d-2*t41*t42*t55*t6
     2           0-1.5625d-2*rhoa*(1.5545345434827443d-2*(8.648845980825
     3           518d-51*t29*t34*t39-2.018064062192621d-50*t184*t28*t34*
     4           t39+8.648845980825518d-51*rhoa*(t187+t186+t185)*t29*t39
     5           -8.648845980825518d-51*rhoa*t29*t34*(1.4960507360008343
     6           d-100*(t29-2.3333333333333334d+0*t184*t28)*t35*t37+9.62
     7           3785732346068d-99*t183*t30*t36/t31**3.0d+0+t187+t186+t1
     8           85)/t38**2)/t40+1.0d+0*t183)*t42*t55*t60-1.5625d-2*rhoa
     9           *t173*t41*t42*t60-1.5625d-2*rhob*t100*t173*t42*t60-3.12
     :           5d-2*rhoa*t158*t41*t42*t55*t59-3.125d-2*rhob*t100*t158*
     ;           t42*t55*t59+t153*(3.109069086965489d-2*t133*t207*(-1.36
     <           21078885675922d-1*t135*t137*t143*t220*t56*(3.7106758001
     =           96128d-2*t144*t145*t147*(4.0d-50*t135-2.333333333333333
     >           4d+0*t211*t212*t56)-3.710675800196128d-2*t139*t144*t146
     ?           *t218*t222-7.421351600392256d-2*t146*t147*t210*t221+t21
     @           9+t216+t215+t214)+1.3621078885675922d-1*t135*t137*t149*
     1           (t219+t216+t215+t214)*t56-2.7242157771351844d-1*t135*t1
     2           38*t143*t149*t210*t56+t213+5.44843155427037d-51*t135*t1
     3           37*t143*t149)+9.327207260896466d-2*t136*t151*t210+1.0d+
     4           0*t206)+t188+t174
              t224 = 1.0d+0*t154*t156*wght
              t225 = 1/t1**3
              t226 = t42+t159
              t227 = t162+t160
              t228 = 1.3060586492616802d-2*(-1.333333333333333d+0*t165*t
     1           227-1.333333333333333d+0*t164*t226)*t46*t52+1.306058649
     2           2616802d-2*t46*(2*gammabb*t227*t48+8.0d-50*rhoa*t226*t4
     3           7)*t49+t167
              t229 = 1.74d+0*t227*t44+1.356d+1*t171*t227+2.0d+0*t170*t22
     1           7
              t230 = t229*t54-4.0d+0*t169*t228*t45
              t231 = 1/rhob**1.3333333333333333d+0
              t232 = 1/rhob**1.3333333333333336d+0
              t233 = 1/t62**3
              t234 = 1/rhob**6.666666666666667d-1
              t235 = 1/t76
              t236 = 2.11607075208357d-1*t234*t63*t75-1.269642451250142d
     1           +0*t62*(7.876233178997433d-1*t63*(-1.3127055298329054d-
     2           1*t233*t234*t72-3.169132786263567d-3*t232)-1.3127055298
     3           329054d-1*t233*t234*t73)/t74**2
              t237 = 1/t83
              t238 = 2.11607075208357d-1*t234*t63*t82-1.269642451250142d
     1           +0*t62*(7.876233178997433d-1*t63*(-1.3127055298329054d-
     2           1*t233*t234*t79-1.7344776604086162d-3*t232)-1.312705529
     3           8329054d-1*t233*t234*t80)/t81**2
              t239 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t237*t238
     1           *t85+7.769549222703733d-4*t231*t84+1.709920934161365d+0
     2           *(6.21814d-2*t235*t236*t78-2.747773264188438d-3*t231*t7
     3           7-3.10907d-2*(2.11607075208357d-1*t234*t63*t67-1.269642
     4           451250142d+0*t62*(7.876233178997433d-1*t63*(-1.31270552
     5           98329054d-1*t233*t234*t64-2.0096226153166658d-3*t232)-1
     6           .3127055298329054d-1*t233*t234*t65)/t66**2)*t71/t68+1.3
     7           210398931339265d-3*t231*t69))+3.37738d-2*t237*t238*t85-
     8           7.769549222703733d-4*t231*t84)-6.21814d-2*t235*t236*t78
     9           +2.747773264188438d-3*t231*t77
              t240 = 1/t99
              t241 = rhob**1.6666666666666674d-1
              t242 = 1/t87**3.0d+0
              t243 = -5.045160155481552d-1*gammabb*t241*t242*t91
              t244 = 1.3909060459745137d+1*gammabb*t239*t88*t89/t90**2
              t245 = 1/t97**2
              t246 = 5.848223622634648d-1*t130*(2.564881401242048d+0*t20
     1           5*t227+2.564881401242048d+0*t204*t226)+5.84822362263464
     2           8d-1*t112*(-4*t121*t129*t203+t202+t201+t200+t199)+t196+
     3           t194
              t247 = 3.333333333333333d-1*t209*t227+3.333333333333333d-1
     1           *t208*t226
              t248 = -2.7242157771351844d-1*t135*t138*t141*t247*t56
              t249 = 9.649190532874448d+1*t131*t144*t247-3.2163968442914
     1           83d+1*t138*t246
              t250 = -1.3621078885675922d-1*t135*t137*t139*t217*t249*t56
              t251 = -1.5625d-2*rhob*t42*t55*t60*(1.5545345434827443d-2*
     1           t240*(-5.045160155481552d-1*gammabb*t241*t242*t93*t98+2
     2           .1622114952063792d-1*gammabb*(t244+t243)*t88*t98-2.1622
     3           114952063792d-1*gammabb*t245*t88*t93*(-2.18174065666788
     4           3d-1*gammabb*t241*t242*t94*t96+6.014866082716293d+0*t23
     5           9*t89*t95/t90**3.0d+0+t244+t243))+1.0d+0*t239)+t152*(1.
     6           5625d-2*t229*t54*t60-6.25d-2*t169*t228*t45*t60-3.125d-2
     7           *t157*t45*t54*t56*t58*t59)-1.5625d-2*t100*t42*t55*t60-1
     8           .5625d-2*rhoa*t230*t41*t42*t60-1.5625d-2*rhob*t100*t230
     9           *t42*t60+3.125d-2*rhoa*t225*t41*t55*t56*t58*t59+3.125d-
     :           2*rhob*t100*t225*t55*t56*t58*t59+t153*(3.10906908696548
     ;           9d-2*t133*t207*(-1.3621078885675922d-1*t135*t137*t143*t
     <           220*t56*(-8.658243533790966d-2*t144*t145*t147*t211*t212
     =           *t56+t250-3.710675800196128d-2*t139*t144*t146*t222*t249
     >           +t248-7.421351600392256d-2*t146*t147*t221*t247+t215)+1.
     ?           3621078885675922d-1*t135*t137*t149*(t250+t248+t215)*t56
     @           -2.7242157771351844d-1*t135*t138*t143*t149*t247*t56+t21
     1           3)+9.327207260896466d-2*t136*t151*t247+1.0d+0*t246)+t18
     2           8+t174
              t252 = -2.4289602241917876d-4*rhob*t240*t42*t55*t60*(2.162
     1           2114952063792d-1*t88*t93*t98+4.675158550002606d-2*gamma
     2           bb*t91*t98/t87**4.0d+0-2.1622114952063792d-1*gammabb*t2
     3           45*t88*t93*(9.350317100005212d-2*t88*t94*t96+2.16221149
     4           52063792d-1*t88*t91))+t152*(3.125d-2*t42*t45*t54*t58*t5
     5           9-8.162866557885502d-4*t169*t45*t46*t49*t51*t60)+8.1628
     6           66557885502d-4*rhoa*t166*t169*t41*t45*t49*t51*t60+8.162
     7           866557885502d-4*rhob*t100*t166*t169*t45*t49*t51*t60-3.1
     8           25d-2*rhoa*t157*t41*t55*t58*t59-3.125d-2*rhob*t100*t157
     9           *t55*t58*t59+3.109069086965489d-2*t133*t153*t207*(-1.36
     :           21078885675922d-1*t135*t137*t143*(3.710675800196128d-2*
     ;           t135*t144*t145*t147+1.3621078885675922d-1*t135*t137*t14
     <           1)*t220*t56+1.855337900098064d-2*t141*t144*t149*t56/t13
     =           4**4.0d+0+1.3621078885675922d-1*t135*t137*t143*t149)
              t253 = 1/t57**2
              t254 = 3.125d-2*rhoa*t157*t253*t41*t55*t56*t59+3.125d-2*rh
     1           ob*t100*t157*t253*t55*t56*t59-3.125d-2*t152*t253*t42*t4
     2           5*t54*t56*t59
              fnc(iq) = 1.0d+0*t1*t154*t156*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t154*(1.6406249999999997d-2*t15
     1           4*t158*t60+5.46875d-3*t155*t223)*wght+1.0d+0*t1*t156*t2
     2           23*wght+t224+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t154*(5.46875d-3*t155*t251-1.64
     1           06249999999997d-2*t154*t157*t56*t58*t60)*wght+1.0d+0*t1
     2           *t156*t251*wght+t224+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = 1.0d+0*t1*t154*(1.6406249999999997d-2*t1
     1           54*t42*t58*t60+5.46875d-3*t155*t252)*wght+1.0d+0*t1*t15
     2           6*t252*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = 1.0d+0*t1*t154*(5.46875d-3*t155*t254-1.64
     1           06249999999997d-2*t154*t253*t42*t56*t60)*wght+1.0d+0*t1
     2           *t156*t254*wght+Mmat(iq,D1_TB)
            else 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 8.648845980825518d-51*rhoa*t29*t32
              t34 = t33+1.0d+0
              t35 = rhoa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 7.480253680004171d-101*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 8.648845980825518d-51*rhoa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = 4.0d-50*rhob+4.0d-50*rhoa
              t44 = t42*t43
              t45 = t44**2.0d+0
              t46 = rhoa-rhob
              t47 = t42*t46
              t48 = 2.2599999999999998d+0*t47**6.0d+0+5.0d-1*t47**4.0d+0
     1           +8.7d-1*t47**2.0d+0+5.3d-1
              t49 = 1/t1**2.6666666666666666d+0
              t50 = 1.0d+0-t42*t46
              t51 = t47+1.0d+0
              t52 = 1/t51**1.333333333333333d+0+1/t50**1.333333333333333
     1           d+0
              t53 = t50**2
              t54 = t51**2
              t55 = 4.0d-50*rhob*t54+4.0d-50*rhoa*t53
              t56 = 1.3060586492616802d-2*t49*t52*t55+1.0d+0
              t57 = 1/t56**4.0d+0
              t58 = t48*t57+1.0d+0
              t59 = rhob**3.333333333333333d-1
              t60 = t59**5.0d-1
              t61 = 1/t60
              t62 = 1.530901310039024d-2*t61+1.0465751434d-1
              t63 = 7.876233178997433d-1*t61*t62+1.9269083139d-1
              t64 = 7.876233178997433d-1*t61*t63+4.3896648423d-1
              t65 = 1/t64
              t66 = 1.269642451250142d+0*t60*t65+1.0d+0
              t67 = log(t66)
              t68 = 1/t59
              t69 = 1.2746961887000874d-1*t68+1.0d+0
              t70 = 2.4141993114533214d-2*t61+1.0186556948d-1
              t71 = 7.876233178997433d-1*t61*t70+2.2308199064d-1
              t72 = 7.876233178997433d-1*t61*t71+4.7231125998d-1
              t73 = 1/t72
              t74 = 1.269642451250142d+0*t60*t73+1.0d+0
              t75 = log(t74)
              t76 = 1.325688999052018d-1*t68+1.0d+0
              t77 = 1.3212998810398843d-2*t61+2.9729725188d-2
              t78 = 7.876233178997433d-1*t61*t77+1.2236585478d-1
              t79 = 7.876233178997433d-1*t61*t78+3.497952466d-1
              t80 = 1/t79
              t81 = 1.269642451250142d+0*t60*t80+1.0d+0
              t82 = log(t81)
              t83 = 6.901399211255826d-2*t68+1.0d+0
              t84 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t75*t76-3.10907d-2*t67*t69)-3.37738d-2*t82*t
     2           83)+3.37738d-2*t82*t83)-6.21814d-2*t75*t76
              t85 = rhob**1.1666666666666667d+0
              t86 = 1/t85**2.0d+0
              t87 = exp(-6.432793688582967d+1*t84)
              t88 = t87-1.0d+0
              t89 = 1/t88
              t90 = 8.648845980825518d-51*rhob*t86*t89
              t91 = t90+1.0d+0
              t92 = rhob*t86
              t93 = t92**2.0d+0
              t94 = 1/t88**2.0d+0
              t95 = 7.480253680004171d-101*t93*t94+t90+1.0d+0
              t96 = 1/t95
              t97 = 8.648845980825518d-51*rhob*t86*t91*t96+1.0d+0
              t98 = 1.5545345434827443d-2*log(t97)+1.0d+0*t84
              t99 = 3.9062500000000006d+97*t45*t48*t57+1.0d+0
              t100 = t1**3.333333333333333d-1
              t101 = 1/t100
              t102 = 1.325688999052018d-1*t101+1.0d+0
              t103 = t100**5.0d-1
              t104 = 1/t103
              t105 = 2.4141993114533214d-2*t104+1.0186556948d-1
              t106 = 7.876233178997433d-1*t104*t105+2.2308199064d-1
              t107 = 7.876233178997433d-1*t104*t106+4.7231125998d-1
              t108 = 1/t107
              t109 = 1.269642451250142d+0*t103*t108+1.0d+0
              t110 = log(t109)
              t111 = 1.923661050931536d+0*t51**1.3333333333333333d+0+1.9
     1           23661050931536d+0*t50**1.3333333333333333d+0-3.84732210
     2           1863072d+0
              t112 = 6.901399211255826d-2*t101+1.0d+0
              t113 = 1.3212998810398843d-2*t104+2.9729725188d-2
              t114 = 7.876233178997433d-1*t104*t113+1.2236585478d-1
              t115 = 7.876233178997433d-1*t104*t114+3.497952466d-1
              t116 = 1/t115
              t117 = 1.269642451250142d+0*t103*t116+1.0d+0
              t118 = log(t117)
              t119 = t46**4
              t120 = 1/t1**4
              t121 = 1.2746961887000874d-1*t101+1.0d+0
              t122 = 1.530901310039024d-2*t104+1.0465751434d-1
              t123 = 7.876233178997433d-1*t104*t122+1.9269083139d-1
              t124 = 7.876233178997433d-1*t104*t123+4.3896648423d-1
              t125 = 1/t124
              t126 = 1.269642451250142d+0*t103*t125+1.0d+0
              t127 = log(t126)
              t128 = 1.709920934161365d+0*(6.21814d-2*t102*t110-3.10907d
     1           -2*t121*t127)-3.37738d-2*t112*t118
              t129 = t119*t120*t128+3.37738d-2*t112*t118
              t130 = 5.848223622634648d-1*t111*t129-6.21814d-2*t102*t110
              t131 = 5.0d-1*t51**6.666666666666666d-1+5.0d-1*t50**6.6666
     1           66666666666d-1
              t132 = t131**3.0d+0
              t133 = t1**1.1666666666666667d+0
              t134 = 1/t133**2.0d+0
              t135 = t131**2.0d+0
              t136 = 1/t135
              t137 = 1/t132
              t138 = exp(-3.216396844291483d+1*t130*t137)
              t139 = t138-1.0d+0
              t140 = 1/t139
              t141 = 1.3621078885675922d-1*t134*t136*t140*t43
              t142 = t141+1.0d+0
              t143 = 1/t131**4.0d+0
              t144 = t134*t43
              t145 = t144**2.0d+0
              t146 = 1/t139**2.0d+0
              t147 = 1.855337900098064d-2*t143*t145*t146+t141+1.0d+0
              t148 = 1/t147
              t149 = 1.3621078885675922d-1*t134*t136*t142*t148*t43+1.0d+
     1           0
              t150 = log(t149)
              t151 = 3.109069086965489d-2*t132*t150+1.0d+0*t130
              t152 = t151*t99-3.9062500000000006d+97*rhob*t42*t45*t58*t9
     1           8-3.9062500000000006d+97*rhoa*t41*t42*t45*t58
              t153 = t44**3.0d+0
              t154 = 6.835937500000002d+146*t152*t153+1.0d+0
              t155 = 1/t1**2
              t156 = t155*t46
              t157 = -t42
              t158 = t157+t156
              t159 = -t155*t46
              t160 = t42+t159
              t161 = 1/t50**2.333333333333333d+0
              t162 = 1/t51**2.333333333333333d+0
              t163 = -3.482823064697814d-2*t52*t55/t1**3.666666666666666
     1           4d+0
              t164 = 1.3060586492616802d-2*(-1.333333333333333d+0*t160*t
     1           162-1.333333333333333d+0*t158*t161)*t49*t55+1.306058649
     2           2616802d-2*t49*t52*(4.0d-50*t53+8.0d-50*rhob*t160*t51+8
     3           .0d-50*rhoa*t158*t50)+t163
              t165 = 1/t56**5.0d+0
              t166 = t47**3.0d+0
              t167 = t47**5.0d+0
              t168 = 1.74d+0*t160*t47+1.356d+1*t160*t167+2.0d+0*t160*t16
     1           6
              t169 = t168*t57-4.0d+0*t164*t165*t48
              t170 = 4.0d-50*t42-t155*t43
              t171 = -7.812500000000001d+97*rhoa*t170*t41*t42*t44*t58
              t172 = 3.9062500000000006d+97*rhoa*t155*t41*t45*t58
              t173 = 1/rhoa**1.3333333333333333d+0
              t174 = 1/rhoa**1.3333333333333336d+0
              t175 = 1/t3**3
              t176 = 1/rhoa**6.666666666666667d-1
              t177 = 1/t17
              t178 = 2.11607075208357d-1*t16*t176*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t13*
     2           t175*t176-3.169132786263567d-3*t174)*t4-1.3127055298329
     3           054d-1*t14*t175*t176)/t15**2
              t179 = 1/t24
              t180 = 2.11607075208357d-1*t176*t23*t4-1.269642451250142d+
     1           0*t3*(7.876233178997433d-1*(-1.3127055298329054d-1*t175
     2           *t176*t20-1.7344776604086162d-3*t174)*t4-1.312705529832
     3           9054d-1*t175*t176*t21)/t22**2
              t181 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t12*(2.11607075208357d-1*t176*t4*t8-1.2696
     2           42451250142d+0*t3*(7.876233178997433d-1*t4*(-1.31270552
     3           98329054d-1*t175*t176*t5-2.0096226153166658d-3*t174)-1.
     4           3127055298329054d-1*t175*t176*t6)/t7**2)/t9+6.21814d-2*
     5           t177*t178*t19-2.747773264188438d-3*t173*t18+1.321039893
     6           1339265d-3*t10*t173)-3.37738d-2*t179*t180*t26+7.7695492
     7           22703733d-4*t173*t25)+3.37738d-2*t179*t180*t26-7.769549
     8           222703733d-4*t173*t25)-6.21814d-2*t177*t178*t19+2.74777
     9           3264188438d-3*t173*t18
              t182 = 1/t28**3.0d+0
              t183 = -2.018064062192621d-50*t182*t28*t32
              t184 = 8.648845980825518d-51*t29*t32
              t185 = 5.563624183898056d-49*rhoa*t181*t29*t30/t31**2
              t186 = -7.812500000000001d+97*rhob*t170*t42*t44*t58*t98
              t187 = 3.9062500000000006d+97*rhob*t155*t45*t58*t98
              t188 = 1/t1**1.3333333333333336d+0
              t189 = 1/t1**6.666666666666667d-1
              t190 = 1/t103**3
              t191 = 2.11607075208357d-1*t104*t108*t189-1.26964245125014
     1           2d+0*t103*(7.876233178997433d-1*t104*(-1.31270552983290
     2           54d-1*t105*t189*t190-3.169132786263567d-3*t188)-1.31270
     3           55298329054d-1*t106*t189*t190)/t107**2
              t192 = 1/t109
              t193 = -6.21814d-2*t102*t191*t192
              t194 = 1/t1**1.3333333333333333d+0
              t195 = 2.747773264188438d-3*t110*t194
              t196 = 2.11607075208357d-1*t104*t116*t189-1.26964245125014
     1           2d+0*t103*(7.876233178997433d-1*t104*(-1.31270552983290
     2           54d-1*t113*t189*t190-1.7344776604086162d-3*t188)-1.3127
     3           055298329054d-1*t114*t189*t190)/t115**2
              t197 = 1/t117
              t198 = 3.37738d-2*t112*t196*t197
              t199 = -7.769549222703733d-4*t118*t194
              t200 = t119*t120*(-3.37738d-2*t112*t196*t197+1.70992093416
     1           1365d+0*(1.3210398931339265d-3*t127*t194-2.747773264188
     2           438d-3*t110*t194+6.21814d-2*t102*t191*t192-3.10907d-2*t
     3           121*(2.11607075208357d-1*t104*t125*t189-1.2696424512501
     4           42d+0*t103*(7.876233178997433d-1*t104*(-1.3127055298329
     5           054d-1*t122*t189*t190-2.0096226153166658d-3*t188)-1.312
     6           7055298329054d-1*t123*t189*t190)/t124**2)/t126)+7.76954
     7           9222703733d-4*t118*t194)
              t201 = -4*t119*t128/t1**5
              t202 = t46**3
              t203 = t50**3.333333333333333d-1
              t204 = t51**3.333333333333333d-1
              t205 = 5.848223622634648d-1*t129*(2.564881401242048d+0*t16
     1           0*t204+2.564881401242048d+0*t158*t203)+5.84822362263464
     2           8d-1*t111*(4*t120*t128*t202+t201+t200+t199+t198)+t195+t
     3           193
              t206 = 1/t149
              t207 = 1/t203
              t208 = 1/t204
              t209 = 3.333333333333333d-1*t160*t208+3.333333333333333d-1
     1           *t158*t207
              t210 = t1**1.6666666666666674d-1
              t211 = 1/t133**3.0d+0
              t212 = -3.1782517399910487d-1*t136*t142*t148*t210*t211*t43
              t213 = 5.44843155427037d-51*t134*t136*t142*t148
              t214 = -2.7242157771351844d-1*t134*t137*t140*t209*t43
              t215 = -3.1782517399910487d-1*t136*t140*t210*t211*t43
              t216 = 5.44843155427037d-51*t134*t136*t140
              t217 = 1/t139**2
              t218 = 9.649190532874448d+1*t130*t143*t209-3.2163968442914
     1           83d+1*t137*t205
              t219 = -1.3621078885675922d-1*t134*t136*t138*t217*t218*t43
              t220 = 1/t147**2
              t221 = 3.710675800196128d-2*t143*t144*t146*(4.0d-50*t134-2
     1           .3333333333333334d+0*t210*t211*t43)
              t222 = 1/t131**5.0d+0
              t223 = 1/t139**3.0d+0
              t224 = 7.812500000000001d+97*t170*t44*t48*t57
              t225 = (3.109069086965489d-2*t132*t206*(-1.362107888567592
     1           2d-1*t134*t136*t142*t220*(-3.710675800196128d-2*t138*t1
     2           43*t145*t218*t223-7.421351600392256d-2*t145*t146*t209*t
     3           222+t221+t219+t216+t215+t214)*t43+1.3621078885675922d-1
     4           *t134*t136*t148*(t219+t216+t215+t214)*t43-2.72421577713
     5           51844d-1*t134*t137*t142*t148*t209*t43+t213+t212)+9.3272
     6           07260896466d-2*t135*t150*t209+1.0d+0*t205)*t99-3.906250
     7           0000000006d+97*rhob*t169*t42*t45*t98-3.9062500000000006
     8           d+97*t41*t42*t45*t58-3.9062500000000006d+97*rhoa*(1.554
     9           5345434827443d-2*(8.648845980825518d-51*t29*t34*t39-2.0
     :           18064062192621d-50*t182*t28*t34*t39+8.648845980825518d-
     ;           51*rhoa*(t185+t184+t183)*t29*t39-8.648845980825518d-51*
     <           rhoa*t29*t34*(1.4960507360008343d-100*(t29-2.3333333333
     =           333334d+0*t182*t28)*t35*t37+9.623785732346068d-99*t181*
     >           t30*t36/t31**3.0d+0+t185+t184+t183)/t38**2)/t40+1.0d+0*
     ?           t181)*t42*t45*t58+t151*(3.9062500000000006d+97*t168*t45
     @           *t57-1.5625000000000003d+98*t164*t165*t45*t48+t224)-3.9
     1           062500000000006d+97*rhoa*t169*t41*t42*t45+t187+t186+t17
     2           2+t171
              t226 = 2.0507812500000006d+147*t152*t170*t45
              t227 = 1.0d+0*t152*t154*wght
              t228 = t42+t156
              t229 = t159+t157
              t230 = 1.3060586492616802d-2*(-1.333333333333333d+0*t162*t
     1           229-1.333333333333333d+0*t161*t228)*t49*t55+1.306058649
     2           2616802d-2*t49*t52*(4.0d-50*t54+8.0d-50*rhob*t229*t51+8
     3           .0d-50*rhoa*t228*t50)+t163
              t231 = 1.74d+0*t229*t47+1.356d+1*t167*t229+2.0d+0*t166*t22
     1           9
              t232 = t231*t57-4.0d+0*t165*t230*t48
              t233 = 1/rhob**1.3333333333333333d+0
              t234 = 1/rhob**1.3333333333333336d+0
              t235 = 1/t60**3
              t236 = 1/rhob**6.666666666666667d-1
              t237 = 1/t74
              t238 = 2.11607075208357d-1*t236*t61*t73-1.269642451250142d
     1           +0*t60*(7.876233178997433d-1*t61*(-1.3127055298329054d-
     2           1*t235*t236*t70-3.169132786263567d-3*t234)-1.3127055298
     3           329054d-1*t235*t236*t71)/t72**2
              t239 = 1/t81
              t240 = 2.11607075208357d-1*t236*t61*t80-1.269642451250142d
     1           +0*t60*(7.876233178997433d-1*t61*(-1.3127055298329054d-
     2           1*t235*t236*t77-1.7344776604086162d-3*t234)-1.312705529
     3           8329054d-1*t235*t236*t78)/t79**2
              t241 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t239*t240
     1           *t83+7.769549222703733d-4*t233*t82+1.709920934161365d+0
     2           *(6.21814d-2*t237*t238*t76-2.747773264188438d-3*t233*t7
     3           5-3.10907d-2*(2.11607075208357d-1*t236*t61*t65-1.269642
     4           451250142d+0*t60*(7.876233178997433d-1*t61*(-1.31270552
     5           98329054d-1*t235*t236*t62-2.0096226153166658d-3*t234)-1
     6           .3127055298329054d-1*t235*t236*t63)/t64**2)*t69/t66+1.3
     7           210398931339265d-3*t233*t67))+3.37738d-2*t239*t240*t83-
     8           7.769549222703733d-4*t233*t82)-6.21814d-2*t237*t238*t76
     9           +2.747773264188438d-3*t233*t75
              t242 = 1/t85**3.0d+0
              t243 = -2.018064062192621d-50*t242*t85*t89
              t244 = 8.648845980825518d-51*t86*t89
              t245 = 5.563624183898056d-49*rhob*t241*t86*t87/t88**2
              t246 = 5.848223622634648d-1*t129*(2.564881401242048d+0*t20
     1           4*t229+2.564881401242048d+0*t203*t228)+5.84822362263464
     2           8d-1*t111*(-4*t120*t128*t202+t201+t200+t199+t198)+t195+
     3           t193
              t247 = 3.333333333333333d-1*t208*t229+3.333333333333333d-1
     1           *t207*t228
              t248 = -2.7242157771351844d-1*t134*t137*t140*t247*t43
              t249 = 9.649190532874448d+1*t130*t143*t247-3.2163968442914
     1           83d+1*t137*t246
              t250 = -1.3621078885675922d-1*t134*t136*t138*t217*t249*t43
              t251 = (3.109069086965489d-2*t132*t206*(-1.362107888567592
     1           2d-1*t134*t136*t142*t220*(t250-3.710675800196128d-2*t13
     2           8*t143*t145*t223*t249+t248-7.421351600392256d-2*t145*t1
     3           46*t222*t247+t221+t216+t215)*t43+1.3621078885675922d-1*
     4           t134*t136*t148*(t250+t248+t216+t215)*t43-2.724215777135
     5           1844d-1*t134*t137*t142*t148*t247*t43+t213+t212)+9.32720
     6           7260896466d-2*t135*t150*t247+1.0d+0*t246)*t99-3.9062500
     7           000000006d+97*t42*t45*t58*t98-3.9062500000000006d+97*rh
     8           ob*t232*t42*t45*t98-3.9062500000000006d+97*rhob*t42*t45
     9           *t58*(1.5545345434827443d-2*(8.648845980825518d-51*t86*
     :           t91*t96-2.018064062192621d-50*t242*t85*t91*t96+8.648845
     ;           980825518d-51*rhob*(t245+t244+t243)*t86*t96-8.648845980
     <           825518d-51*rhob*t86*t91*(1.4960507360008343d-100*(t86-2
     =           .3333333333333334d+0*t242*t85)*t92*t94+9.62378573234606
     >           8d-99*t241*t87*t93/t88**3.0d+0+t245+t244+t243)/t95**2)/
     ?           t97+1.0d+0*t241)+t151*(3.9062500000000006d+97*t231*t45*
     @           t57-1.5625000000000003d+98*t165*t230*t45*t48+t224)-3.90
     1           62500000000006d+97*rhoa*t232*t41*t42*t45+t187+t186+t172
     2           +t171
              fnc(iq) = 1.0d+0*t1*t152*t154*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t152*(t226+6.835937500000002d+1
     1           46*t153*t225)*wght+1.0d+0*t1*t154*t225*wght+t227+Amat(i
     2           q,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t152*(6.835937500000002d+146*t1
     1           53*t251+t226)*wght+1.0d+0*t1*t154*t251*wght+t227+Amat(i
     2           q,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            else 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            else 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_tpss03 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_3} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_4} &=& \sqrt{{\it t_3}}\\\\ 
C>   {\it t_5} &=& {{1}\over{{\it t_4}}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_3}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_4}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_5}+0.10186556948\right)\,{
C>    \it t_5}+0.22308199064\right)\,{\it t_5}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.1325688999052018\,{\it t_6}+1.0\\\\ 
C>   {\it t_9} &=& \log \left({{1.269642451250142\,{\it t_4}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_5}+0.029729725188\right)
C>    \,{\it t_5}+0.12236585478\right)\,{\it t_5}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_{10}} &=& 0.06901399211255826\,{\it t_6}+1.0\\\\ 
C>   {\it t_{11}} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_9}
C>    \,{\it t_{10}}+1.0\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_7}\,{\it t_8}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_4}}\over{0.7876233178997433
C>    \,\left(0.7876233178997433\,\left(0.01530901310039024\,{\it t_5}
C>    +0.10465751434\right)\,{\it t_5}+0.19269083139\right)\,{\it t_5}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{\it t_6}
C>    +1.0\right)\right)-0.0337738\,{\it t_9}\,{
C>    \it t_{10}}\right)\right)-0.0621814\,{\it t_7}\,{\it t_8}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{
C>    \left(\rho_\alpha^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{11}}}}}
C>    -1.0\\\\ 
C>   {\it t_{14}} &=& {{0.2162211495206379\,{\it t_{12}}\,
C>    \sigma_{\alpha\alpha}}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{15}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{16}} &=& {\it t_{15}}\,{\it t_2}\\\\ 
C>   {\it t_{17}} &=& 2.26\,{\it t_{16}}^{6.0}+0.5\,{\it t_{16}}^{4.0}
C>    +0.87\,{\it t_{16}}^{2.0}+0.53\\\\ 
C>   {\it t_{18}} &=& 1.0-{\it t_{15}}\,{\it t_2}\\\\ 
C>   {\it t_{19}} &=& {\it t_{16}}+1.0\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left({{0.0130605864926168\,
C>    \left({{1}\over{{\it t_{19}}^{1.333333333333333}}}+{{1}
C>    \over{{\it t_{18}}^{1.333333333333333}}}\right)\,\left({
C>    \it t_{19}}^2\,\sigma_{\beta\beta}-2.0\,{\it t_{18}}\,{
C>    \it t_{19}}\,\sigma_{\alpha\beta}+{\it t_{18}}^2\,
C>    \sigma_{\alpha\alpha}\right)}\over{{\it t_1}^{{{8}\over{3}}}}}
C>    +1.0\right)^{4.0}}}\\\\ 
C>   {\it t_{21}} &=& {\it t_{17}}\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{22}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{23}} &=& {{{\it t_2}\,{\it t_{22}}}\over{\tau_\beta
C>    +\tau_\alpha}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}^{2.0}\\\\ 
C>   {\it t_{25}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{26}} &=& \sqrt{{\it t_{25}}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_{26}}}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{25}}}}\\\\ 
C>   {\it t_{29}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{26}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{27}}+0.10186556948\right)
C>    \,{\it t_{27}}+0.22308199064\right)\,{\it t_{27}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{30}} &=& 0.1325688999052018\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{31}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{26}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{27}}
C>    +0.029729725188\right)\,{\it t_{27}}+0.12236585478\right)\,{
C>    \it t_{27}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{32}} &=& 0.06901399211255826\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{33}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{31}}\,{\it t_{32}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{29}}\,{\it t_{30}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{26}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{27}}+0.10465751434\right)
C>    \,{\it t_{27}}+0.19269083139\right)\,{\it t_{27}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{28}}+1.0\right)\right)-0.0337738\,{\it t_{31}}\,{
C>    \it t_{32}}\right)\right)-0.0621814\,{\it t_{29}}\,{
C>    \it t_{30}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{
C>    \left(\rho_\beta^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{33}}}}}
C>    -1.0\\\\ 
C>   {\it t_{36}} &=& {{0.2162211495206379\,{\it t_{34}}\,
C>    \sigma_{\beta\beta}}\over{{\it t_{35}}}}\\\\ 
C>   {\it t_{37}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{37}}}}\\\\ 
C>   {\it t_{39}} &=& 0.1325688999052018\,{\it t_{38}}+1.0\\\\ 
C>   {\it t_{40}} &=& \sqrt{{\it t_{37}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{40}}}}\\\\ 
C>   {\it t_{42}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.02414199311453321\,{\it t_{41}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{43}} &=& 0.06901399211255826\,{\it t_{38}}+1.0\\\\ 
C>   {\it t_{44}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.01321299881039884\,{\it t_{41}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{45}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{19}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{18}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_{15}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{39}}\,{\it t_{42}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{38}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{40}}}
C>    \over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.01530901310039024\,{\it t_{41}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{43}}\,{\it t_{44}}\right)}\over{{
C>    \it t_1}^4}}+0.0337738\,{\it t_{43}}\,{\it t_{44}}\right)
C>    -0.0621814\,{\it t_{39}}\,{\it t_{42}}\\\\ 
C>   {\it t_{46}} &=& 0.5\,{\it t_{19}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{18}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{47}} &=& {\it t_{46}}^{3.0}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{{\it t_{46}}^{2.0}}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{e^{{{32.16396844291483\,{
C>    \it t_{45}}}\over{{\it t_{47}}}}}}}-1.0\\\\ 
C>   {\it t_{51}} &=& {{0.1362107888567592\,{\it t_{48}}\,{
C>    \it t_{49}}\,{\it t_{22}}}\over{{\it t_{50}}}}\\\\ 
C>   {\it t_{52}} &=& \left(0.03109069086965489\,{\it t_{47}}
C>    \,\log \left({{0.1362107888567592\,{\it t_{48}}\,{\it t_{49}}
C>    \,{\it t_{22}}\,\left({\it t_{51}}+1.0\right)}
C>    \over{{{0.01855337900098064\,\left({\it t_{48}}\,{
C>    \it t_{22}}\right)^{2.0}}\over{{\it t_{46}}^{4.0}\,{
C>    \it t_{50}}^{2.0}}}+{\it t_{51}}+1.0}}+1.0\right)+1.0\,{
C>    \it t_{45}}\right)\,\left(0.015625\,{\it t_{17}}\,{\it t_{20}}
C>    \,{\it t_{24}}+1.0\right)-0.015625\,\rho_\beta\,{\it t_2}\,{
C>    \it t_{21}}\,\left(0.01554534543482744\,\log 
C>    \left({{0.2162211495206379\,{\it t_{34}}\,\sigma_{\beta\beta}
C>    \,\left({\it t_{36}}+1.0\right)}\over{{{0.04675158550002606
C>    \,\left({\it t_{34}}\,\sigma_{\beta\beta}\right)^{2.0}}
C>    \over{{\it t_{35}}^{2.0}}}+{\it t_{36}}+1.0}}+1.0\right)+1.0
C>    \,{\it t_{33}}\right)\,{\it t_{24}}-0.015625\,\rho_\alpha\,{
C>    \it t_2}\,\left(0.01554534543482744\,\log 
C>    \left({{0.2162211495206379\,{\it t_{12}}\,
C>    \sigma_{\alpha\alpha}\,\left({\it t_{14}}+1.0\right)}
C>    \over{{{0.04675158550002606\,\left({\it t_{12}}\,
C>    \sigma_{\alpha\alpha}\right)^{2.0}}\over{{\it t_{13}}^{2.0}}}
C>    +{\it t_{14}}+1.0}}+1.0\right)+1.0\,{\it t_{11}}\right)\,{
C>    \it t_{21}}\,{\it t_{24}}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,{\it t_{52}}\,\left(0.00546875\,{
C>    \it t_{23}}^{3.0}\,{\it t_{52}}+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.0\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] J Tao, JP Perdew, VN Staveroverov, GE Scuseria
C>    , Phys.Rev.Lett. 91, 146401 (2003)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.91.146401 "> 
C> 10.1103/PhysRevLett.91.146401 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_tpss03_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Cmat,Cmat2,Mmat,Mmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = rhoa**3.333333333333333d-1
              t2 = t1**5.0d-1
              t3 = 1/t2
              t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3
     1           *(7.016926042943223d-1*(2.150807071909054d-2*t3+1.01865
     2           56948d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
              t5 = 1/t1
              t6 = 1.0522000558389215d-1*t5+1.0d+0
              t7 = rhoa**1.1666666666666667d+0
              t8 = 1/t7**2.0d+0
              t9 = exp(2.0000005873362642d+0*t4*t6)-1.0d+0
              t10 = 1.0811057476031892d-1*gammaaa*t8/t9
              t11 = (gammaaa*t8)**2.0d+0
              t12 = 1/rhoa
              t13 = 1/taua
              t14 = gammaaa*t12*t13
              t15 = t14**2.0d+0
              t16 = 1.530901310039024d-2*t3+1.0465751434d-1
              t17 = 7.876233178997433d-1*t16*t3+1.9269083139d-1
              t18 = 7.876233178997433d-1*t17*t3+4.3896648423d-1
              t19 = 1/t18
              t20 = 1.269642451250142d+0*t19*t2+1.0d+0
              t21 = log(t20)
              t22 = 1.2746961887000874d-1*t5+1.0d+0
              t23 = 2.4141993114533214d-2*t3+1.0186556948d-1
              t24 = 7.876233178997433d-1*t23*t3+2.2308199064d-1
              t25 = 7.876233178997433d-1*t24*t3+4.7231125998d-1
              t26 = 1/t25
              t27 = 1.269642451250142d+0*t2*t26+1.0d+0
              t28 = log(t27)
              t29 = 1.325688999052018d-1*t5+1.0d+0
              t30 = 1.3212998810398843d-2*t3+2.9729725188d-2
              t31 = 7.876233178997433d-1*t3*t30+1.2236585478d-1
              t32 = 7.876233178997433d-1*t3*t31+3.497952466d-1
              t33 = 1/t32
              t34 = 1.269642451250142d+0*t2*t33+1.0d+0
              t35 = log(t34)
              t36 = 6.901399211255826d-2*t5+1.0d+0
              t37 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t28*t29-3.10907d-2*t21*t22)-3.37738d-2*t35*t
     2           36)+3.37738d-2*t35*t36)-6.21814d-2*t28*t29
              t38 = exp(-6.432793688582967d+1*t37)
              t39 = t38-1.0d+0
              t40 = 1/t39
              t41 = 2.1622114952063792d-1*gammaaa*t40*t8
              t42 = t41+1.0d+0
              t43 = 1/t39**2.0d+0
              t44 = 4.675158550002606d-2*t11*t43+t41+1.0d+0
              t45 = 1/t44
              t46 = 2.1622114952063792d-1*gammaaa*t42*t45*t8+1.0d+0
              t47 = 1.5545345434827443d-2*log(t46)+1.0d+0*t37
              t48 = (8.28125d-3*t15+1.0d+0)*(3.109069086965489d-2*log(1.
     1           0811057476031892d-1*gammaaa*(t10+1.0d+0)*t8/(1.16878963
     2           75006504d-2*t11/t9**2.0d+0+t10+1.0d+0)+1.0d+0)-6.21814d
     3           -2*t4*t6)-2.390625d-2*t15*t47
              t49 = 2.1508070719090538d-2*t3+1.0186556948d-1
              t50 = 7.016926042943222d-1*t3*t49+2.2308199064d-1
              t51 = 7.016926042943222d-1*t3*t50+4.7231125998d-1
              t52 = 1/t51
              t53 = 1.425125466450768d+0*t2*t52+1.0d+0
              t54 = log(t53)
              t55 = 1.0522000558389213d-1*t5+1.0d+0
              t56 = exp(2.0000005873362642d+0*t54*t55)
              t57 = t56-1.0d+0
              t58 = 1/t57
              t59 = 1.0811057476031893d-1*gammaaa*t58*t8
              t60 = t59+1.0d+0
              t61 = 1/t57**2.0d+0
              t62 = 1.168789637500651d-2*t11*t61+t59+1.0d+0
              t63 = 1/t62
              t64 = 1.0811057476031893d-1*gammaaa*t60*t63*t8+1.0d+0
              t65 = log(t64)
              t66 = 3.109069086965489d-2*t65-6.21814d-2*t54*t55
              t67 = 1.0d+0*gammaaa*t12*t13
              t68 = t67**2.0d+0
              t69 = 8.28125d-3*t68+1.0d+0
              t70 = t66*t69-2.390625d-2*t47*t68
              t71 = t67**3.0d+0
              t72 = 5.46875d-3*t70*t71+1.0d+0
              t73 = 1/rhoa**1.3333333333333333d+0
              t74 = 1/t53
              t75 = 1/t51**2
              t76 = 1/rhoa**1.3333333333333336d+0
              t77 = 1/t2**3
              t78 = 1/rhoa**6.666666666666667d-1
              t79 = -5.847438369119352d-2*t49*t77*t78-1.2576711796854242
     1           d-3*t76
              t80 = 7.016926042943222d-1*t3*t79-5.847438369119352d-2*t50
     1           *t77*t78
              t81 = 1.1876045553756398d-1*t3*t52*t78-1.425125466450768d+
     1           0*t2*t75*t80
              t82 = 1.090454542535705d-3*t54*t73-6.21814d-2*t55*t74*t81
              t83 = 1/t64
              t84 = rhoa**1.6666666666666674d-1
              t85 = 1/t7**3.0d+0
              t86 = -1.2612900388703877d-1*gammaaa*t58*t84*t85
              t87 = 1/t57**2
              t88 = 3.4772651149362827d+0*gammaaa*t56*t8*t82*t87
              t89 = t88+t86
              t90 = 1/t62**2
              t91 = gammaaa**2
              t92 = 1/t7**5.0d+0
              t93 = 1/t57**3.0d+0
              t94 = 7.518582603395361d-1*t11*t56*t82*t93-2.7271758208348
     1           523d-2*t61*t84*t91*t92+t88+t86
              t95 = -1.0811057476031893d-1*gammaaa*t60*t8*t90*t94+1.0811
     1           057476031893d-1*gammaaa*t63*t8*t89-1.2612900388703877d-
     2           1*gammaaa*t60*t63*t84*t85
              t96 = 3.109069086965489d-2*t83*t95+1.0d+0*t82
              t97 = 1/t20
              t98 = 1/t18**2
              t99 = -1.3127055298329054d-1*t16*t77*t78-2.009622615316665
     1           8d-3*t76
              t100 = 7.876233178997433d-1*t3*t99-1.3127055298329054d-1*t
     1           17*t77*t78
              t101 = 2.11607075208357d-1*t19*t3*t78-1.269642451250142d+0
     1           *t100*t2*t98
              t102 = 1/t27
              t103 = 1/t25**2
              t104 = -1.3127055298329054d-1*t23*t77*t78-3.16913278626356
     1           7d-3*t76
              t105 = 7.876233178997433d-1*t104*t3-1.3127055298329054d-1*
     1           t24*t77*t78
              t106 = 2.11607075208357d-1*t26*t3*t78-1.269642451250142d+0
     1           *t103*t105*t2
              t107 = 1/t34
              t108 = 1/t32**2
              t109 = -1.3127055298329054d-1*t30*t77*t78-1.73447766040861
     1           62d-3*t76
              t110 = 7.876233178997433d-1*t109*t3-1.3127055298329054d-1*
     1           t31*t77*t78
              t111 = 2.11607075208357d-1*t3*t33*t78-1.269642451250142d+0
     1           *t108*t110*t2
              t112 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t101*t22*t97-2.747773264188438d-3*t28*t73+
     2           1.3210398931339265d-3*t21*t73+6.21814d-2*t102*t106*t29)
     3           +7.769549222703733d-4*t35*t73-3.37738d-2*t107*t111*t36)
     4           -7.769549222703733d-4*t35*t73+3.37738d-2*t107*t111*t36)
     5           +2.747773264188438d-3*t28*t73-6.21814d-2*t102*t106*t29
              t113 = 1/t46
              t114 = -5.045160155481552d-1*gammaaa*t40*t84*t85
              t115 = 1/t39**2
              t116 = 1.3909060459745137d+1*gammaaa*t112*t115*t38*t8
              t117 = t116+t114
              t118 = 1/t44**2
              t119 = 1/t39**3.0d+0
              t120 = -2.181740656667883d-1*t43*t84*t91*t92+6.01486608271
     1           6293d+0*t11*t112*t119*t38+t116+t114
              t121 = -5.045160155481552d-1*gammaaa*t42*t45*t84*t85+2.162
     1           2114952063792d-1*gammaaa*t117*t45*t8-2.1622114952063792
     2           d-1*gammaaa*t118*t120*t42*t8
              t122 = 1.5545345434827443d-2*t113*t121+1.0d+0*t112
              t123 = 1/rhoa**3
              t124 = 1/taua**2
              t125 = t69*t96-8.28125d-3*t123*t124*t66*t91+2.390625d-2*t1
     1           23*t124*t47*t91-1.1953125d-2*t122*t68
              t126 = 1/rhoa**2
              t127 = 5.46875d-3*t125*t71-8.203124999999999d-3*gammaaa*t1
     1           26*t13*t68*t70
              t128 = 1/t7**4.0d+0
              t129 = 2.7027643690079733d-2*t58*t8+5.843948187503255d-3*g
     1           ammaaa*t128*t61
              t130 = -1.0811057476031893d-1*gammaaa*t129*t60*t8*t90+2.70
     1           27643690079733d-2*t60*t63*t8+2.9219740937516275d-3*gamm
     2           aaa*t128*t58*t63
              t131 = 2.1622114952063792d-1*t40*t8+9.350317100005212d-2*g
     1           ammaaa*t128*t43
              t132 = 2.1622114952063792d-1*t42*t45*t8-2.1622114952063792
     1           d-1*gammaaa*t118*t131*t42*t8+4.675158550002606d-2*gamma
     2           aa*t128*t40*t45
              t133 = 7.874506561842959d-2
              t134 = 1/rhoa**2.6666666666666666d+0
              t135 = 1.5749013123685918d-1
              t136 = 4.140625d-3*gammaaa*t124*t126-8.652638551358631d-4*
     1           t134*t135*t68
              t137 = 3.109069086965489d-2*t130*t69*t83+1.730527710271726
     1           5d-3*t133*t134*t47*t68-1.8581545715067177d-4*t113*t132*
     2           t68+t136*t66-1.1953125d-2*gammaaa*t124*t126*t47
              t138 = 5.46875d-3*t137*t71+4.1015624999999994d-3*t12*t13*t
     1           68*t70
              t139 = 5.405528738015947d-2*t58*t8+1.168789637500651d-2*ga
     1           mmaaa*t128*t61
              t140 = -1.0811057476031893d-1*gammaaa*t139*t60*t8*t90+5.40
     1           5528738015947d-2*t60*t63*t8+5.843948187503255d-3*gammaa
     2           a*t128*t58*t63
              t141 = 1.7305277102717265d-3*t134*t135*t68+8.28125d-3*gamm
     1           aaa*t124*t126
              t142 = 3.109069086965489d-2*t140*t69*t83-3.461055420543453
     1           d-3*t133*t134*t47*t68+t141*t66-2.390625d-2*gammaaa*t124
     2           *t126*t47
              t143 = 5.46875d-3*t142*t71+8.203124999999999d-3*t12*t13*t6
     1           8*t70
              t144 = 1/taua**3
              t145 = 2.390625d-2*t126*t144*t47*t91-8.28125d-3*t126*t144*
     1           t66*t91
              t146 = 5.46875d-3*t145*t71-8.203124999999999d-3*gammaaa*t1
     1           2*t124*t68*t70
              t147 = 2.0d+0*t125*t72*wght
              t148 = 1/rhoa**2.333333333333333d+0
              t149 = -7.269696950238034d-4*t148*t54
              t150 = log(1.425125466450768d+0*t2/(7.016926042943222d-1*t
     1           3*(7.016926042943222d-1*(1.1771443702974158d-2*t3+2.972
     2           9725188d-2)*t3+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
              t151 = 5.477644184000001d-2*t5+1.0d+0
              t152 = 2.18090908507141d-3*t73*t74*t81
              t153 = 6.21814d-2*t55*t81**2/t53**2
              t154 = 1/rhoa**2.3333333333333334d+0
              t155 = 1/rhoa**1.6666666666666669d+0
              t156 = 1/t2**5
              t157 = -6.21814d-2*t55*t74*(2.850250932901536d+0*t2*t80**2
     1           /t51**3-2.3752091107512796d-1*t3*t75*t78*t80-1.42512546
     2           6450768d+0*t2*t75*(-1.1694876738238703d-1*t77*t78*t79+7
     3           .016926042943222d-1*t3*(1.949146123039784d-2*t155*t49*t
     4           77+1.4618595922798375d-2*t156*t49*t76+9.432533847640683
     5           d-4*t154)+1.949146123039784d-2*t155*t50*t77+1.461859592
     6           2798375d-2*t156*t50*t76)-9.896704628130328d-3*t52*t76*t
     7           77-3.9586818512521327d-2*t155*t3*t52)
              t158 = t157+t153+t152+8.443450000000001d-3*t126*t150*t151+
     1           t149
              t159 = 1/t64**2
              t160 = -3.109069086965489d-2*t159*t95**2
              t161 = rhoa**3.333333333333335d-1
              t162 = 2.2072575680231782d-1*gammaaa*t128*t161*t60*t63
              t163 = 1/rhoa**8.333333333333333d-1
              t164 = -1.0510750323919903d-2*gammaaa*t163*t60*t63*t85
              t165 = -2.5225800777407753d-1*gammaaa*t63*t84*t85*t89
              t166 = 2.5225800777407753d-1*gammaaa*t60*t84*t85*t90*t94
              t167 = -2.1622114952063787d-1*gammaaa*t8*t89*t90*t94
              t168 = 1/t62**3
              t169 = 2.1622114952063787d-1*gammaaa*t168*t60*t8*t94**2
              t170 = 2.2072575680231782d-1*gammaaa*t128*t161*t58
              t171 = -1.0510750323919903d-2*gammaaa*t163*t58*t85
              t172 = 1.2012286084479878d-2*gammaaa*t126*t58*t8
              t173 = -8.113618601517993d+0*gammaaa*t56*t82*t84*t85*t87
              t174 = t82**2
              t175 = -1.118426454244592d+2*gammaaa*t174*t56*t8*t87
              t176 = 3.3333343122271053d-1*t126*t54*t55-3.21639684429148
     1           3d+1*t158
              t177 = -1.0811057476031893d-1*gammaaa*t176*t56*t8*t87
              t178 = 1/t57**3
              t179 = exp(4.0000011746725284d+0*t54*t55)
              t180 = 2.236852908489184d+2*gammaaa*t174*t178*t179*t8
              t181 = 1/t7**6.0d+0
              t182 = 7.95426281076832d-2*t161*t181*t61*t91
              t183 = -2.2726465173623778d-3*t163*t61*t91*t92
              t184 = -3.508671881584501d+0*t56*t82*t84*t91*t92*t93
              t185 = 7.254823607731703d+1*t11*t174*t179/t57**4.0d+0
              t186 = 1/t27**2
              t187 = t106**2
              t188 = -1.269642451250142d+0*t103*t2*(-2.625411059665811d-
     1           1*t104*t77*t78+7.876233178997433d-1*t3*(8.7513701988860
     2           37d-2*t155*t23*t77+6.563527649164527d-2*t156*t23*t76+4.
     3           753699179395351d-3*t154)+8.751370198886037d-2*t155*t24*
     4           t77+6.563527649164527d-2*t156*t24*t76)-4.23214150416714
     5           d-1*t103*t105*t3*t78-3.52678458680595d-2*t26*t76*t77-1.
     6           4107138347223802d-1*t155*t26*t3+2.539284902500284d+0*t1
     7           05**2*t2/t25**3
              t189 = 1/t34**2
              t190 = t111**2
              t191 = -1.269642451250142d+0*t108*t2*(-2.625411059665811d-
     1           1*t109*t77*t78+7.876233178997433d-1*t3*(8.7513701988860
     2           37d-2*t155*t30*t77+6.563527649164527d-2*t156*t30*t76+2.
     3           601716490612924d-3*t154)+8.751370198886037d-2*t155*t31*
     4           t77+6.563527649164527d-2*t156*t31*t76)-4.23214150416714
     5           d-1*t108*t110*t3*t78-3.52678458680595d-2*t33*t76*t77-1.
     6           4107138347223802d-1*t155*t3*t33+2.539284902500284d+0*t1
     7           10**2*t2/t32**3
              t192 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t22*t97*(-1.269642451250142d+0*t2*t98*(-2.
     2           625411059665811d-1*t77*t78*t99+7.876233178997433d-1*t3*
     3           (8.751370198886037d-2*t155*t16*t77+6.563527649164527d-2
     4           *t156*t16*t76+3.0144339229749983d-3*t154)+8.75137019888
     5           6037d-2*t155*t17*t77+6.563527649164527d-2*t156*t17*t76)
     6           -4.23214150416714d-1*t100*t3*t78*t98-3.52678458680595d-
     7           2*t19*t76*t77-1.4107138347223802d-1*t155*t19*t3+2.53928
     8           4902500284d+0*t100**2*t2/t18**3)+2.642079786267853d-3*t
     9           101*t73*t97-5.495546528376876d-3*t102*t106*t73+6.21814d
     :           -2*t102*t188*t29-6.21814d-2*t186*t187*t29+3.66369768558
     ;           4584d-3*t148*t28+3.10907d-2*t101**2*t22/t20**2-1.761386
     <           5241785687d-3*t148*t21)+1.5539098445407465d-3*t107*t111
     =           *t73-3.37738d-2*t107*t191*t36+3.37738d-2*t189*t190*t36-
     >           1.0359398963604977d-3*t148*t35)-1.5539098445407465d-3*t
     ?           107*t111*t73+3.37738d-2*t107*t191*t36-3.37738d-2*t189*t
     @           190*t36+1.0359398963604977d-3*t148*t35)+5.4955465283768
     1           76d-3*t102*t106*t73-6.21814d-2*t102*t188*t29+6.21814d-2
     2           *t186*t187*t29-3.663697685584584d-3*t148*t28
              t193 = t112**2
              t194 = exp(-1.2865587377165935d+2*t37)
              t195 = 1.7894823267913484d+3*gammaaa*t193*t194*t8/t39**3
              t196 = 1.765806054418543d+0*gammaaa*t128*t161*t40
              t197 = -8.408600259135923d-2*gammaaa*t163*t40*t85
              t198 = -6.490894881214397d+1*gammaaa*t112*t115*t38*t84*t85
              t199 = -8.947411633956742d+2*gammaaa*t115*t193*t38*t8
              t200 = 1.3909060459745137d+1*gammaaa*t115*t192*t38*t8
              t201 = 1/t44**3
              t202 = 1/t46**2
              t203 = 1/rhoa**4.666666666666667d+0
              t204 = 2.390625d-2*t122*t123*t124*t91
              t205 = -1.6562500000000002d-2*t123*t124*t91*t96
              t206 = 1/rhoa**4
              t207 = -3.5859374999999993d-2*t124*t206*t47*t91
              t208 = 1.2421875d-2*t124*t206*t91
              t209 = t69*(3.109069086965489d-2*t83*(-1.0811057476031893d
     1           -1*gammaaa*t60*t8*t90*(-2.337579275001302d-2*t11*t176*t
     2           56*t93-2.4182745359105678d+1*t11*t174*t56*t93+2.5973103
     3           05557001d-3*t11*t126*t61+t185+t184+t183+t182+t180+t177+
     4           t175+t173+t172+t171+t170)+1.2012286084479878d-2*gammaaa
     5           *t126*t60*t63*t8+1.0811057476031893d-1*gammaaa*(t180+t1
     6           77+t175+t173+t172+t171+t170)*t63*t8+t169+t167+t166+t165
     7           +t164+t162)-5.181781811609147d-3*t126*t65+t160+1.0d+0*t
     8           158)-1.1953125d-2*t68*(1.5545345434827443d-2*t113*(-2.1
     9           622114952063792d-1*gammaaa*t118*t42*t8*(-5.613875010535
     :           206d+1*t112*t119*t38*t84*t91*t92-3.6362344277798064d-2*
     ;           t163*t43*t91*t92+1.2726820497229316d+0*t161*t181*t43*t9
     <           1+1.1607717772370736d+3*t11*t193*t194/t39**4.0d+0-3.869
     =           239257456912d+2*t11*t119*t193*t38+6.014866082716293d+0*
     >           t11*t119*t192*t38+t200+t199+t198+t197+t196+t195)-1.0090
     ?           320310963104d+0*gammaaa*t117*t45*t84*t85+1.009032031096
     @           3104d+0*gammaaa*t118*t120*t42*t84*t85-8.408600259135923
     1           d-2*gammaaa*t163*t42*t45*t85+2.1622114952063792d-1*gamm
     2           aaa*(t200+t199+t198+t197+t196+t195)*t45*t8+4.3244229904
     3           127585d-1*gammaaa*t120**2*t201*t42*t8-4.324422990412758
     4           5d-1*gammaaa*t117*t118*t120*t8+1.765806054418543d+0*gam
     5           maaa*t128*t161*t42*t45)-1.5545345434827443d-2*t121**2*t
     6           202+1.0d+0*t192)+t66*(-1.7305277102717265d-3*gammaaa*t1
     7           35*t203*t68+6.796875d-3*t126*t68+t208)-1.5625d-2*(4.35d
     8           -1*t126-1.1075377345739049d-1*gammaaa*t135*t203)*t47*t6
     9           8-1.1953125d-2*t12*t122*t68+t207+t205+t204
              t210 = 2.0d+0*t127*t70*wght
              t211 = 4.0d+0*rhoa*t125*t127*wght
              t212 = gammaaa**3
              t213 = 8.203124999999999d-3*t144*t212*t70/rhoa**5
              t214 = 8.203124999999999d-3*gammaaa*t123*t13*t68*t70
              t215 = -1.6406249999999997d-2*gammaaa*t125*t126*t13*t68
              t216 = t157+t153+t152-8.44345d-3*t126*t150*t151+t149
              t217 = -1.201228608447988d-2*gammaaa*t126*t58*t8
              t218 = -1.1184264542445921d+2*gammaaa*t174*t56*t8*t87
              t219 = -3.3333343122271064d-1*t126*t54*t55-3.2163968442914
     1           83d+1*t216
              t220 = -1.0811057476031893d-1*gammaaa*t219*t56*t8*t87
              t221 = 2.2368529084891842d+2*gammaaa*t174*t178*t179*t8
              t222 = t69*(3.109069086965489d-2*t83*(-1.0811057476031893d
     1           -1*gammaaa*t60*t8*t90*(-2.337579275001302d-2*t11*t219*t
     2           56*t93-2.418274535910568d+1*t11*t174*t56*t93-2.59731030
     3           55570024d-3*t11*t126*t61+t221+t220+t218+t217+t185+t184+
     4           t183+t182+t173+t171+t170)-1.201228608447988d-2*gammaaa*
     5           t126*t60*t63*t8+1.0811057476031893d-1*gammaaa*(t221+t22
     6           0+t218+t217+t173+t171+t170)*t63*t8+t169+t167+t166+t165+
     7           t164+t162)+5.181781811609147d-3*t126*t65+1.0d+0*t216+t1
     8           60)+t66*(1.7305277102717265d-3*gammaaa*t135*t203*t68-6.
     9           796875d-3*t126*t68+t208)-1.5625d-2*(1.1075377345739049d
     :           -1*gammaaa*t135*t203-4.35d-1*t126)*t47*t68+1.1953125d-2
     ;           *t12*t122*t68+t207+t205+t204
              t223 = -3.153225097175969d-2*t58*t84*t85
              t224 = 8.693162787340707d-1*t56*t8*t82*t87
              t225 = t69*(3.109069086965489d-2*t83*(-2.7027643690079733d
     1           -2*t60*t8*t90*t94-2.9219740937516275d-3*gammaaa*t128*t5
     2           8*t90*t94+2.1622114952063787d-1*gammaaa*t129*t168*t60*t
     3           8*t94-1.0811057476031893d-1*gammaaa*t60*t8*t90*(3.75929
     4           13016976803d-1*gammaaa*t128*t56*t82*t93-1.3635879104174
     5           26d-2*gammaaa*t61*t84*t92+t224+t223)-3.408969776043566d
     6           -3*gammaaa*t58*t63*t84*t92-1.0811057476031893d-1*gammaa
     7           a*t129*t8*t89*t90+1.2612900388703877d-1*gammaaa*t129*t6
     8           0*t84*t85*t90+2.7027643690079733d-2*t63*t8*t89-3.153225
     9           097175969d-2*t60*t63*t84*t85+1.0811057476031893d-1*gamm
     :           aaa*(t224+t223)*t63*t8)-3.109069086965489d-2*t130*t159*
     ;           t95)
              t226 = 8.652638551358631d-4*t122*t133*t134*t68
              t227 = -5.045160155481552d-1*t40*t84*t85
              t228 = 1.3909060459745137d+1*t112*t115*t38*t8
              t229 = 3.937253280921477d-2
              t230 = 1/rhoa**3.6666666666666664d+0
              t231 = -1.7305277102717265d-3*t229*t230*t47*t68
              t232 = 1.8581545715067177d-4*t113*t123*t124*t132*t91
              t233 = -5.9765625d-3*gammaaa*t122*t124*t126
              t234 = -2.5746978376432955d-4*t123*t124*t130*t83*t91
              t235 = 2.4607833005759258d-3
              t236 = 1/rhoa**5.666666666666667d+0
              t237 = -5.537688672869524d-2*t124*t235*t236*t47*t91
              t238 = 1.1953125d-2*gammaaa*t123*t124*t47
              t239 = 4.921566601151848d-3
              t240 = 2.768844336434762d-2*t124*t236*t239*t91
              t241 = -4.140625d-3*gammaaa*t123*t124
              t242 = t136*t96
              t243 = -1.1953125d-2*t68*(1.5545345434827443d-2*t113*(-2.1
     1           622114952063792d-1*gammaaa*t118*t42*t8*(-4.363481313335
     2           766d-1*gammaaa*t43*t84*t92+1.2029732165432584d+1*gammaa
     3           a*t112*t119*t128*t38+t228+t227)-1.0908703283339415d-1*g
     4           ammaaa*t40*t45*t84*t92-5.045160155481552d-1*t42*t45*t84
     5           *t85+5.045160155481552d-1*gammaaa*t118*t131*t42*t84*t85
     6           +2.1622114952063792d-1*gammaaa*(t228+t227)*t45*t8+2.162
     7           2114952063792d-1*t117*t45*t8+4.3244229904127585d-1*gamm
     8           aaa*t120*t131*t201*t42*t8-2.1622114952063792d-1*t118*t1
     9           20*t42*t8-2.1622114952063792d-1*gammaaa*t117*t118*t131*
     :           t8-4.675158550002606d-2*gammaaa*t118*t120*t128*t40)-1.5
     ;           545345434827443d-2*t121*t132*t202)+t66*(4.0378979906340
     <           284d-3*t133*t230*t68+t241+t240)-3.172634135498165d-3*t1
     =           33*t230*t47*t68-9.290772857533588d-5*t113*t12*t132*t68+
     >           t242+t238+t237+t234+t233+t232+t231+t226+t225
              t244 = 1.0d+0*t137*t72*wght
              t245 = 2.0d+0*rhoa*t127*t137*wght
              t246 = 1.0d+0*t138*t70*wght
              t247 = 2.0d+0*rhoa*t125*t138*wght
              t248 = -4.1015624999999994d-3*t144*t206*t70*t91
              t249 = -2.0507812499999997d-3*t126*t13*t68*t70
              t250 = 4.1015624999999994d-3*t12*t125*t13*t68
              t251 = -8.203124999999999d-3*gammaaa*t126*t13*t137*t68
              t252 = -6.306450194351938d-2*t58*t84*t85
              t253 = 1.7386325574681413d+0*t56*t8*t82*t87
              t254 = t141*t96+t69*(3.109069086965489d-2*t83*(-5.40552873
     1           8015947d-2*t60*t8*t90*t94-5.843948187503255d-3*gammaaa*
     2           t128*t58*t90*t94+2.1622114952063787d-1*gammaaa*t139*t16
     3           8*t60*t8*t94-1.0811057476031893d-1*gammaaa*t60*t8*t90*(
     4           7.518582603395361d-1*gammaaa*t128*t56*t82*t93-2.7271758
     5           20834852d-2*gammaaa*t61*t84*t92+t253+t252)-6.8179395520
     6           87132d-3*gammaaa*t58*t63*t84*t92-1.0811057476031893d-1*
     7           gammaaa*t139*t8*t89*t90+1.2612900388703877d-1*gammaaa*t
     8           139*t60*t84*t85*t90+5.405528738015947d-2*t63*t8*t89-6.3
     9           06450194351938d-2*t60*t63*t84*t85+1.0811057476031893d-1
     :           *gammaaa*(t253+t252)*t63*t8)-3.109069086965489d-2*t140*
     ;           t159*t95)+t66*(-5.537688672869524d-2*t124*t236*t239*t91
     <           -4.614740560724604d-3*t133*t230*t68-8.28125d-3*gammaaa*
     =           t123*t124)-2.5746978376432955d-4*t123*t124*t140*t83*t91
     >           +1.1075377345739049d-1*t124*t235*t236*t47*t91+3.4610554
     ?           20543453d-3*t229*t230*t47*t68+2.8842128504528775d-3*t13
     @           3*t230*t47*t68-1.7305277102717265d-3*t122*t133*t134*t68
     1           +2.390625d-2*gammaaa*t123*t124*t47-1.1953125d-2*gammaaa
     2           *t122*t124*t126
              t255 = t66*(5.768425700905755d-4*t133*t230*t68+t241+t240)+
     1           2.8842128504528763d-4*t133*t230*t47*t68+9.2907728575335
     2           88d-5*t113*t12*t132*t68+t242+t238+t237+t234+t233+t232+t
     3           231+t226+t225
              t256 = -3.109069086965489d-2*t130**2*t159*t69
              t257 = -5.405528738015947d-2*t129*t60*t8*t90
              t258 = -5.843948187503255d-3*gammaaa*t128*t129*t58*t90
              t259 = 3.109069086965489d-2*t69*t83*(-1.5794814935512527d-
     1           4*gammaaa*t181*t60*t61*t90+2.1622114952063787d-1*gammaa
     2           a*t129**2*t168*t60*t8+1.4609870468758138d-3*t128*t58*t6
     3           3+t258+t257)
              t260 = 2.6901651040714963d-5*t113*t132*t133*t134*t68
              t261 = 1.2401570718501566d-2
              t262 = 1/rhoa**5.333333333333333d+0
              t263 = -2.2601706837873994d-4*t261*t262*t47*t68
              t264 = -1.8581545715067177d-4*gammaaa*t113*t124*t126*t132
              t265 = 1.384422168217381d-2*gammaaa*t124*t203*t239*t47
              t266 = 1.9686266404607394d-2
              t267 = 3.461055420543453d-3*gammaaa*t124*t203*t266*t47
              t268 = -2.98828125d-3*t124*t126*t47
              t269 = 2.4803141437003123d-2
              t270 = 9.843133202303697d-3
              t271 = t66*(1.1300853418936997d-4*t262*t269*t68-6.92211084
     1           1086906d-3*gammaaa*t124*t203*t270-1.7305277102717265d-3
     2           *gammaaa*t124*t203*t229+1.03515625d-3*t124*t126)
              t272 = 6.218138173930978d-2*t130*t136*t83
              t273 = -1.8581545715067177d-4*t113*t68*(4.3244229904127585
     1           d-1*gammaaa*t131**2*t201*t42*t8-4.3244229904127585d-1*t
     2           118*t131*t42*t8+9.350317100005212d-2*t128*t40*t45-2.021
     3           7363117456047d-2*gammaaa*t118*t181*t42*t43-9.3503171000
     4           05212d-2*gammaaa*t118*t128*t131*t40)+1.8581545715067177
     5           d-4*t132**2*t202*t68+t272+t271+t268+t267+t265+t264+t263
     6           +t260+t259+t256
              t274 = 4.0d+0*rhoa*t137*t138*wght
              t275 = 2.0507812499999997d-3*gammaaa*t123*t144*t70
              t276 = 8.203124999999999d-3*t12*t13*t137*t68
              t277 = 3.109069086965489d-2*t69*t83*(-2.7027643690079733d-
     1           2*t139*t60*t8*t90-3.1589629871025054d-4*gammaaa*t181*t6
     2           0*t61*t90-2.9219740937516275d-3*gammaaa*t128*t139*t58*t
     3           90+2.1622114952063787d-1*gammaaa*t129*t139*t168*t60*t8+
     4           2.9219740937516275d-3*t128*t58*t63+t258+t257)+3.1090690
     5           86965489d-2*t130*t141*t83+3.109069086965489d-2*t136*t14
     6           0*t83-3.109069086965489d-2*t130*t140*t159*t69+t66*(-2.2
     7           601706837873994d-4*t262*t269*t68+1.384422168217381d-2*g
     8           ammaaa*t124*t203*t270-3.461055420543453d-3*gammaaa*t124
     9           *t203*t229+2.0703125d-3*t124*t126)+4.520341367574799d-4
     :           *t261*t262*t47*t68-2.6901651040714963d-5*t113*t132*t133
     ;           *t134*t68+6.922110841086906d-3*gammaaa*t124*t203*t266*t
     <           47-2.768844336434762d-2*gammaaa*t124*t203*t239*t47-5.97
     =           65625d-3*t124*t126*t47+t264
              t278 = t272+t271+t268+t267+t265+t264+t263+t260+t259+t256
              t279 = 3.109069086965489d-2*t69*t83*(-1.0811057476031893d-
     1           1*t139*t60*t8*t90-6.317925974205011d-4*gammaaa*t181*t60
     2           *t61*t90-1.168789637500651d-2*gammaaa*t128*t139*t58*t90
     3           +2.1622114952063787d-1*gammaaa*t139**2*t168*t60*t8+5.84
     4           3948187503255d-3*t128*t58*t63)+6.218138173930978d-2*t14
     5           0*t141*t83-3.109069086965489d-2*t140**2*t159*t69+t66*(4
     6           .520341367574799d-4*t262*t269*t68+2.768844336434762d-2*
     7           gammaaa*t124*t203*t270+6.922110841086906d-3*gammaaa*t12
     8           4*t203*t229+4.140625d-3*t124*t126)-9.040682735149598d-4
     9           *t261*t262*t47*t68-1.384422168217381d-2*gammaaa*t124*t2
     :           03*t266*t47-5.537688672869524d-2*gammaaa*t124*t203*t239
     ;           *t47-1.1953125d-2*t124*t126*t47
              t280 = -8.28125d-3*t126*t144*t91*t96+8.28125d-3*t123*t144*
     1           t66*t91-2.390625d-2*t123*t144*t47*t91+1.1953125d-2*t122
     2           *t126*t144*t91
              t281 = 1/taua**4
              t282 = 2.0d+0*rhoa*t280*t72*wght+1.0d+0*t145*t72*wght+2.0d
     1           +0*rhoa*t70*(5.46875d-3*t280*t71+4.1015624999999994d-3*
     2           gammaaa*t124*t126*t68*t70+8.203124999999999d-3*t206*t21
     3           2*t281*t70-8.203124999999999d-3*gammaaa*t126*t13*t145*t
     4           68-8.203124999999999d-3*gammaaa*t12*t124*t125*t68)*wght
     5           +1.0d+0*t146*t70*wght+2.0d+0*rhoa*t125*t146*wght+2.0d+0
     6           *rhoa*t127*t145*wght
              t283 = t66*(6.922110841086906d-3*t144*t203*t266*t91-4.1406
     1           25d-3*gammaaa*t126*t144)-2.5746978376432955d-4*t126*t13
     2           0*t144*t83*t91-1.384422168217381d-2*t144*t203*t270*t47*
     3           t91+1.8581545715067177d-4*t113*t126*t132*t144*t91+1.195
     4           3125d-2*gammaaa*t126*t144*t47
              t284 = 2.0d+0*rhoa*t70*(-4.1015624999999994d-3*t123*t281*t
     1           70*t91+5.46875d-3*t283*t71-2.0507812499999997d-3*t12*t1
     2           24*t68*t70+4.1015624999999994d-3*t12*t13*t145*t68-8.203
     3           124999999999d-3*gammaaa*t12*t124*t137*t68)*wght+2.0d+0*
     4           rhoa*t283*t72*wght+2.0d+0*rhoa*t137*t146*wght+2.0d+0*rh
     5           oa*t138*t145*wght
              t285 = t66*(-1.384422168217381d-2*t144*t203*t266*t91-8.281
     1           25d-3*gammaaa*t126*t144)-2.5746978376432955d-4*t126*t14
     2           0*t144*t83*t91+2.768844336434762d-2*t144*t203*t270*t47*
     3           t91+2.390625d-2*gammaaa*t126*t144*t47
              t286 = 1.2421875d-2*t126*t281*t66*t91-3.5859375d-2*t126*t2
     1           81*t47*t91
              t287 = 2.0d+0*rhoa*t70*(8.203124999999999d-3*t123*t212*t70
     1           /taua**5+5.46875d-3*t286*t71+8.203124999999999d-3*gamma
     2           aa*t12*t144*t68*t70-1.6406249999999997d-2*gammaaa*t12*t
     3           124*t145*t68)*wght+2.0d+0*rhoa*t286*t72*wght+4.0d+0*rho
     4           a*t145*t146*wght
              fnc(iq) = 2.0d+0*rhoa*t48*(5.46875d-3*t14**3.0d+0*t48+1.0d
     1           +0)*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t70*t72*wght+2.0d+0*rhoa*t125*t72*
     1           wght+2.0d+0*rhoa*t127*t70*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = 2.0d+0*rhoa*t137*t72*wght+2.0d+0*rhoa*t1
     1           38*t70*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = 2.0d+0*rhoa*t142*t72*wght+2.0d+0*rhoa*t1
     1           43*t70*wght+Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = 2.0d+0*rhoa*t145*t72*wght+2.0d+0*rhoa*t14
     1           6*t70*wght+Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t209*t72*wght+2.0d+0*rhoa
     1           *t70*(5.46875d-3*t209*t71+t215+t214+t213)*wght+t211+t21
     2           0+t147+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t222*t72*wght+2.0d+0*rhoa
     1           *t70*(5.46875d-3*t222*t71+t215+t214+t213)*wght+t211+t21
     2           0+t147+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = 2.0d+0*rhoa*t243*t72*wght+2.0d+0*rho
     1           a*t70*(5.46875d-3*t243*t71+t251+t250+t249+t248)*wght+t2
     2           47+t246+t245+t244+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = 2.0d+0*rhoa*t70*(-8.203124999999999d
     1           -3*t144*t206*t70*t91+5.46875d-3*t254*t71-4.101562499999
     2           9994d-3*t126*t13*t68*t70-8.203124999999999d-3*gammaaa*t
     3           126*t13*t142*t68+8.203124999999999d-3*t12*t125*t13*t68)
     4           *wght+2.0d+0*rhoa*t254*t72*wght+1.0d+0*t142*t72*wght+1.
     5           0d+0*t143*t70*wght+2.0d+0*rhoa*t125*t143*wght+2.0d+0*rh
     6           oa*t127*t142*wght+Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = 2.0d+0*rhoa*t255*t72*wght+2.0d+0*rho
     1           a*t70*(5.46875d-3*t255*t71+t251+t250+t249+t248)*wght+t2
     2           47+t246+t245+t244+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = 2.0d+0*rhoa*t273*t72*wght+2.0d+0*rh
     1           oa*t70*(5.46875d-3*t273*t71+t276+t275)*wght+t274+Cmat2(
     2           iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = 2.0d+0*rhoa*t277*t72*wght+2.0d+0*rh
     1           oa*t70*(5.46875d-3*t277*t71+4.1015624999999994d-3*gamma
     2           aa*t123*t144*t70+4.1015624999999994d-3*t12*t13*t142*t68
     3           +t276)*wght+2.0d+0*rhoa*t137*t143*wght+2.0d+0*rhoa*t138
     4           *t142*wght+Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 2.0d+0*rhoa*t278*t72*wght+2.0d+0*rh
     1           oa*t70*(5.46875d-3*t278*t71+t276+t275)*wght+t274+Cmat2(
     2           iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = 2.0d+0*rhoa*t279*t72*wght+2.0d+0*rh
     1           oa*t70*(5.46875d-3*t279*t71+8.203124999999999d-3*gammaa
     2           a*t123*t144*t70+1.6406249999999997d-2*t12*t13*t142*t68)
     3           *wght+4.0d+0*rhoa*t142*t143*wght+Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = t282+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = t282+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = t284+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = t284+Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = 2.0d+0*rhoa*t70*(-8.203124999999999d
     1           -3*t123*t281*t70*t91+5.46875d-3*t285*t71-4.101562499999
     2           9994d-3*t12*t124*t68*t70+8.203124999999999d-3*t12*t13*t
     3           145*t68-8.203124999999999d-3*gammaaa*t12*t124*t142*t68)
     4           *wght+2.0d+0*rhoa*t285*t72*wght+2.0d+0*rhoa*t142*t146*w
     5           ght+2.0d+0*rhoa*t143*t145*wght+Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = t287+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = t287+Mmat2(iq,D2_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 1/(3.291061569204112d-52*t1+1.0d+0)**4.0d+0
              t3 = rhoa**3.333333333333333d-1
              t4 = t3**5.0d-1
              t5 = 1/t4
              t6 = 1.530901310039024d-2*t5+1.0465751434d-1
              t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
              t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
              t9 = 1/t8
              t10 = 1.269642451250142d+0*t4*t9+1.0d+0
              t11 = log(t10)
              t12 = 1/t3
              t13 = 1.2746961887000874d-1*t12+1.0d+0
              t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
              t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
              t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
              t17 = 1/t16
              t18 = 1.269642451250142d+0*t17*t4+1.0d+0
              t19 = log(t18)
              t20 = 1.325688999052018d-1*t12+1.0d+0
              t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
              t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
              t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
              t24 = 1/t23
              t25 = 1.269642451250142d+0*t24*t4+1.0d+0
              t26 = log(t25)
              t27 = 6.901399211255826d-2*t12+1.0d+0
              t28 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t19*t20-3.10907d-2*t11*t13)-3.37738d-2*t26*t
     2           27)+3.37738d-2*t26*t27)-6.21814d-2*t19*t20
              t29 = rhoa**1.1666666666666667d+0
              t30 = 1/t29**2.0d+0
              t31 = exp(-6.432793688582967d+1*t28)
              t32 = t31-1.0d+0
              t33 = 1/t32
              t34 = 8.648845980825518d-51*rhoa*t30*t33
              t35 = t34+1.0d+0
              t36 = (rhoa*t30)**2.0d+0
              t37 = 1/t32**2.0d+0
              t38 = 7.480253680004171d-101*t36*t37+t34+1.0d+0
              t39 = 1/t38
              t40 = 8.648845980825518d-51*rhoa*t30*t35*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t28
              t42 = log(1.4251254664507676d+0*t4/(7.016926042943223d-1*t
     1           5*(7.016926042943223d-1*(2.150807071909054d-2*t5+1.0186
     2           556948d-1)*t5+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
              t43 = 1.0522000558389215d-1*t12+1.0d+0
              t44 = exp(2.0000005873362642d+0*t42*t43)-1.0d+0
              t45 = 2.1622114952063787d-51*rhoa*t30/t44
              t46 = (3.3125000000000004d-2*t2+1.0d+0)*(3.109069086965489
     1           d-2*log(2.1622114952063787d-51*rhoa*t30*(t45+1.0d+0)/(t
     2           45+4.6751585500026027d-102*t36/t44**2.0d+0+1.0d+0)+1.0d
     3           +0)-6.21814d-2*t42*t43)-6.25d-2*(5.3d-1*t2+1.0d+0)*t41
              t47 = 1.5749013123685918d-1
              t48 = 2.0896938388186886d-51*t1*t47+1.0d+0
              t49 = 1/t48**4.0d+0
              t50 = 5.3d-1*t49+1.0d+0
              t51 = 3.312500000000001d-2*t49+1.0d+0
              t52 = 2.1508070719090538d-2*t5+1.0186556948d-1
              t53 = 7.016926042943222d-1*t5*t52+2.2308199064d-1
              t54 = 7.016926042943222d-1*t5*t53+4.7231125998d-1
              t55 = 1/t54
              t56 = 1.425125466450768d+0*t4*t55+1.0d+0
              t57 = log(t56)
              t58 = 1.0522000558389213d-1*t12+1.0d+0
              t59 = exp(2.0000005873362642d+0*t57*t58)
              t60 = t59-1.0d+0
              t61 = 1/t60
              t62 = 2.162211495206379d-51*rhoa*t30*t61
              t63 = t62+1.0d+0
              t64 = 1/t60**2.0d+0
              t65 = 4.6751585500026044d-102*t36*t64+t62+1.0d+0
              t66 = 1/t65
              t67 = 2.162211495206379d-51*rhoa*t30*t63*t66+1.0d+0
              t68 = log(t67)
              t69 = 3.109069086965489d-2*t68-6.21814d-2*t57*t58
              t70 = t51*t69-6.250000000000001d-2*t41*t50
              t71 = 4.375000000000001d-2*t70+1.0d+0
              t72 = 1/rhoa**1.3333333333333333d+0
              t73 = 1/t10
              t74 = 1/t8**2
              t75 = rhoa**1.3333333333333336d+0
              t76 = 1/t75
              t77 = 1/t4**3
              t78 = 1/rhoa**6.666666666666667d-1
              t79 = -1.3127055298329054d-1*t6*t77*t78-2.0096226153166658
     1           d-3*t76
              t80 = 7.876233178997433d-1*t5*t79-1.3127055298329054d-1*t7
     1           *t77*t78
              t81 = 2.11607075208357d-1*t5*t78*t9-1.269642451250142d+0*t
     1           4*t74*t80
              t82 = 1/t18
              t83 = 1/t16**2
              t84 = -1.3127055298329054d-1*t14*t77*t78-3.169132786263567
     1           d-3*t76
              t85 = 7.876233178997433d-1*t5*t84-1.3127055298329054d-1*t1
     1           5*t77*t78
              t86 = 2.11607075208357d-1*t17*t5*t78-1.269642451250142d+0*
     1           t4*t83*t85
              t87 = 1/t25
              t88 = 1/t23**2
              t89 = -1.3127055298329054d-1*t21*t77*t78-1.734477660408616
     1           2d-3*t76
              t90 = 7.876233178997433d-1*t5*t89-1.3127055298329054d-1*t2
     1           2*t77*t78
              t91 = 2.11607075208357d-1*t24*t5*t78-1.269642451250142d+0*
     1           t4*t88*t90
              t92 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t87*t9
     1           1+1.709920934161365d+0*(6.21814d-2*t20*t82*t86-3.10907d
     2           -2*t13*t73*t81-2.747773264188438d-3*t19*t72+1.321039893
     3           1339265d-3*t11*t72)+7.769549222703733d-4*t26*t72)+3.377
     4           38d-2*t27*t87*t91-7.769549222703733d-4*t26*t72)-6.21814
     5           d-2*t20*t82*t86+2.747773264188438d-3*t19*t72
              t93 = 1/t40
              t94 = 1/t29**3.0d+0
              t95 = -2.018064062192621d-50*t29*t33*t94
              t96 = 8.648845980825518d-51*t30*t33
              t97 = 1/t32**2
              t98 = 5.563624183898056d-49*rhoa*t30*t31*t92*t97
              t99 = t98+t96+t95
              t100 = 1/t38**2
              t101 = t30-2.3333333333333334d+0*t29*t94
              t102 = 1/t32**3.0d+0
              t103 = t98+t96+t95+9.623785732346068d-99*t102*t31*t36*t92+
     1           1.4960507360008343d-100*rhoa*t101*t30*t37
              t104 = 8.648845980825518d-51*rhoa*t30*t39*t99-2.0180640621
     1           92621d-50*t29*t35*t39*t94+8.648845980825518d-51*t30*t35
     2           *t39-8.648845980825518d-51*rhoa*t100*t103*t30*t35
              t105 = 1.5545345434827443d-2*t104*t93+1.0d+0*t92
              t106 = 1/t56
              t107 = 1/t54**2
              t108 = -5.847438369119352d-2*t52*t77*t78-1.257671179685424
     1           2d-3*t76
              t109 = 7.016926042943222d-1*t108*t5-5.847438369119352d-2*t
     1           53*t77*t78
              t110 = 1.1876045553756398d-1*t5*t55*t78-1.425125466450768d
     1           +0*t107*t109*t4
              t111 = 1.090454542535705d-3*t57*t72-6.21814d-2*t106*t110*t
     1           58
              t112 = 1/t67
              t113 = -2.5225800777407753d-51*t29*t61*t94
              t114 = 1.0811057476031895d-51*t30*t61
              t115 = 1/t60**2
              t116 = 6.954530229872565d-50*rhoa*t111*t115*t30*t59
              t117 = t116+t114+t113
              t118 = 1/t65**2
              t119 = 7.937005259840997d-51*t30-1.8519678939628997d-50*t2
     1           9*t94
              t120 = 1/t60**3.0d+0
              t121 = 5.890330668744275d-52*rhoa*t119*t30*t64+3.007433041
     1           3581446d-100*t111*t120*t36*t59+t116+t114+t113
              t122 = -2.5225800777407753d-51*t29*t63*t66*t94+1.081105747
     1           6031895d-51*t30*t63*t66+2.162211495206379d-51*rhoa*t117
     2           *t30*t66-2.162211495206379d-51*rhoa*t118*t121*t30*t63
              t123 = 3.109069086965489d-2*t112*t122+1.0d+0*t111
              t124 = 7.874506561842959d-2
              t125 = 1/rhoa**2.6666666666666666d+0
              t126 = 1.0448469194093443d-51*t125*t47-5.572516903516502d-
     1           51*t124*t125
              t127 = 1/t48**5.0d+0
              t128 = -1.3250000000000003d-1*t126*t127*t69+t123*t51-3.125
     1           0000000000006d-2*t105*t50+1.3250000000000003d-1*t126*t1
     2           27*t41
              t129 = 1.7500000000000004d-1*rhoa*t128**2*wght
              t130 = 2.0d+0*t128*t71*wght
              t131 = 8.750000000000002d-2*t128*t70*wght
              t132 = 1.3250000000000003d-1*t105*t126*t127
              t133 = 1/rhoa
              t134 = 1/rhoa**2.333333333333333d+0
              t135 = 1/rhoa**2.3333333333333334d+0
              t136 = 1/rhoa**1.6666666666666669d+0
              t137 = 1/t4**5
              t138 = 1/t18**2
              t139 = t86**2
              t140 = 2.539284902500284d+0*t4*t85**2/t16**3-4.23214150416
     1           714d-1*t5*t78*t83*t85-1.269642451250142d+0*t4*t83*(-2.6
     2           25411059665811d-1*t77*t78*t84+7.876233178997433d-1*t5*(
     3           8.751370198886037d-2*t136*t14*t77+6.563527649164527d-2*
     4           t137*t14*t76+4.753699179395351d-3*t135)+8.7513701988860
     5           37d-2*t136*t15*t77+6.563527649164527d-2*t137*t15*t76)-3
     6           .52678458680595d-2*t17*t76*t77-1.4107138347223802d-1*t1
     7           36*t17*t5
              t141 = 1/t25**2
              t142 = t91**2
              t143 = 2.539284902500284d+0*t4*t90**2/t23**3-4.23214150416
     1           714d-1*t5*t78*t88*t90-1.269642451250142d+0*t4*t88*(-2.6
     2           25411059665811d-1*t77*t78*t89+7.876233178997433d-1*t5*(
     3           8.751370198886037d-2*t136*t21*t77+6.563527649164527d-2*
     4           t137*t21*t76+2.601716490612924d-3*t135)+8.7513701988860
     5           37d-2*t136*t22*t77+6.563527649164527d-2*t137*t22*t76)-3
     6           .52678458680595d-2*t24*t76*t77-1.4107138347223802d-1*t1
     7           36*t24*t5
              t144 = 5.848223622634643d-1*(1.0d+0*(1.5539098445407465d-3
     1           *t72*t87*t91+1.709920934161365d+0*(-3.10907d-2*t13*t73*
     2           (-3.52678458680595d-2*t76*t77*t9-1.4107138347223802d-1*
     3           t136*t5*t9+2.539284902500284d+0*t4*t80**2/t8**3-4.23214
     4           150416714d-1*t5*t74*t78*t80-1.269642451250142d+0*t4*t74
     5           *(-2.625411059665811d-1*t77*t78*t79+7.876233178997433d-
     6           1*t5*(8.751370198886037d-2*t136*t6*t77+6.56352764916452
     7           7d-2*t137*t6*t76+3.0144339229749983d-3*t135)+8.75137019
     8           8886037d-2*t136*t7*t77+6.563527649164527d-2*t137*t7*t76
     9           ))-5.495546528376876d-3*t72*t82*t86+6.21814d-2*t140*t20
     :           *t82+3.10907d-2*t13*t81**2/t10**2+2.642079786267853d-3*
     ;           t72*t73*t81-6.21814d-2*t138*t139*t20+3.663697685584584d
     <           -3*t134*t19-1.7613865241785687d-3*t11*t134)-3.37738d-2*
     =           t143*t27*t87+3.37738d-2*t141*t142*t27-1.035939896360497
     >           7d-3*t134*t26)-1.5539098445407465d-3*t72*t87*t91+3.3773
     ?           8d-2*t143*t27*t87-3.37738d-2*t141*t142*t27+1.0359398963
     @           604977d-3*t134*t26)+5.495546528376876d-3*t72*t82*t86-6.
     1           21814d-2*t140*t20*t82+6.21814d-2*t138*t139*t20-3.663697
     2           685584584d-3*t134*t19
              t145 = 1/t29**4.0d+0
              t146 = rhoa**1.6666666666666674d-1
              t147 = t92**2
              t148 = exp(-1.2865587377165935d+2*t28)
              t149 = 7.157929307165395d-47*rhoa*t147*t148*t30/t32**3
              t150 = 7.063224217674173d-50*t145*t33*t75
              t151 = -4.372472134750679d-50*t146*t33*t94
              t152 = -2.5963579524857594d-48*t29*t31*t92*t94*t97
              t153 = 1.1127248367796111d-48*t30*t31*t92*t97
              t154 = -3.5789646535826974d-47*rhoa*t147*t30*t31*t97
              t155 = 5.563624183898056d-49*rhoa*t144*t30*t31*t97
              t156 = -2.6500000000000007d-1*t123*t126*t127
              t157 = t126**2
              t158 = 1/t48**6.0d+0
              t159 = 1.0600000000000001d+1*t157*t158
              t160 = 1/rhoa**3.6666666666666664d+0
              t161 = 8.044817169165606d-52*t160
              t162 = -5.572516903516502d-51*t124*t160
              t163 = 5.804705107829684d-52*t160*t47+t162+t161
              t164 = 1/rhoa**2
              t165 = 6.625000000000003d-1*t157*t158
              t166 = -7.269696950238034d-4*t134*t57
              t167 = log(1.425125466450768d+0*t4/(7.016926042943222d-1*t
     1           5*(7.016926042943222d-1*(1.1771443702974158d-2*t5+2.972
     2           9725188d-2)*t5+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
              t168 = 5.477644184000001d-2*t12+1.0d+0
              t169 = 2.18090908507141d-3*t106*t110*t72
              t170 = 6.21814d-2*t110**2*t58/t56**2
              t171 = -6.21814d-2*t106*t58*(-1.425125466450768d+0*t107*t4
     1           *(-1.1694876738238703d-1*t108*t77*t78+7.016926042943222
     2           d-1*t5*(1.949146123039784d-2*t136*t52*t77+1.46185959227
     3           98375d-2*t137*t52*t76+9.432533847640683d-4*t135)+1.9491
     4           46123039784d-2*t136*t53*t77+1.4618595922798375d-2*t137*
     5           t53*t76)-2.3752091107512796d-1*t107*t109*t5*t78-9.89670
     6           4628130328d-3*t55*t76*t77-3.9586818512521327d-2*t136*t5
     7           *t55+2.850250932901536d+0*t109**2*t4/t54**3)
              t172 = t171+t170+t169+8.443450000000001d-3*t164*t167*t168+
     1           t166
              t173 = -3.109069086965489d-2*t122**2/t67**2
              t174 = 4.4145151360463564d-51*t145*t63*t66*t75
              t175 = -2.732795084219174d-51*t146*t63*t66*t94
              t176 = -5.045160155481551d-51*t117*t29*t66*t94
              t177 = 2.162211495206379d-51*t117*t30*t66
              t178 = 5.045160155481551d-51*t118*t121*t29*t63*t94
              t179 = -2.162211495206379d-51*t118*t121*t30*t63
              t180 = -4.324422990412758d-51*rhoa*t117*t118*t121*t30
              t181 = 4.324422990412758d-51*rhoa*t121**2*t30*t63/t65**3
              t182 = 4.4145151360463564d-51*t145*t61*t75
              t183 = -2.732795084219174d-51*t146*t61*t94
              t184 = 2.4024572168959757d-52*t133*t30*t61
              t185 = -1.6227237203035988d-49*t111*t115*t29*t59*t94
              t186 = 6.954530229872565d-50*t111*t115*t30*t59
              t187 = t111**2
              t188 = -2.2368529084891842d-48*rhoa*t115*t187*t30*t59
              t189 = 3.3333343122271053d-1*t164*t57*t58-3.21639684429148
     1           3d+1*t172
              t190 = -2.162211495206379d-51*rhoa*t115*t189*t30*t59
              t191 = exp(4.0000011746725284d+0*t57*t58)
              t192 = 4.4737058169783683d-48*rhoa*t187*t191*t30/t60**3
              t193 = 5.890330668744274d-52*rhoa*t30*t64*(3.2409438144350
     1           74d-50*t145*t75-2.0062985517931411d-50*t146*t94)
              t194 = 3.710675800196128d-2*t119**2*t64
              t195 = 7.578256389912968d-50*rhoa*t111*t119*t120*t30*t59
              t196 = -9.673098143642272d-99*t120*t187*t36*t59
              t197 = 1/t60**4.0d+0
              t198 = -3.1250000000000006d-2*t50*(1.5545345434827443d-2*t
     1           93*(-4.036128124385242d-50*t29*t39*t94*t99+1.7297691961
     2           651035d-50*t30*t39*t99-1.7297691961651035d-50*rhoa*t100
     3           *t103*t30*t99-8.648845980825518d-51*rhoa*t100*t30*t35*(
     4           1.4960507360008343d-100*rhoa*t30*t37*(8.166666666666668
     5           d+0*t145*t75-5.055555555555556d+0*t146*t94)+3.849514292
     6           9384274d-98*rhoa*t101*t102*t30*t31*t92+1.49605073600083
     7           43d-100*t101**2*t37+1.857234843579318d-96*t147*t148*t36
     8           /t32**4.0d+0-6.19078281193106d-97*t102*t147*t31*t36+9.6
     9           23785732346068d-99*t102*t144*t31*t36+t155+t154+t153+t15
     :           2+t151+t150+t149)-4.372472134750679d-50*t146*t35*t39*t9
     ;           4+4.036128124385242d-50*t100*t103*t29*t35*t94+7.0632242
     <           17674173d-50*t145*t35*t39*t75+8.648845980825518d-51*rho
     =           a*(t155+t154+t153+t152+t151+t150+t149)*t30*t39+1.729769
     >           1961651035d-50*rhoa*t103**2*t30*t35/t38**3-1.7297691961
     ?           651035d-50*t100*t103*t30*t35)-1.5545345434827443d-2*t10
     @           4**2/t40**2+1.0d+0*t144)+(2.718750000000001d-2*t164*t49
     1           +t165-1.3250000000000003d-1*t127*t163)*t69+t51*(-5.1817
     2           81811609147d-3*t164*t68+3.109069086965489d-2*t112*(2.40
     3           24572168959757d-52*t133*t30*t63*t66+2.162211495206379d-
     4           51*rhoa*(t192+t190+t188+t186+t185+t184+t183+t182)*t30*t
     5           66-2.162211495206379d-51*rhoa*t118*t30*t63*(1.038924122
     6           2228007d-102*t164*t36*t64-9.350317100005209d-102*t120*t
     7           189*t36*t59+2.901929443092682d-98*t187*t191*t197*t36+t1
     8           96+t195+t194+t193+t192+t190+t188+t186+t185+t184+t183+t1
     9           82)+t181+t180+t179+t178+t177+t176+t175+t174)+t173+1.0d+
     :           0*t172)-3.1250000000000006d-2*t105*t133*t50-6.250000000
     ;           000001d-2*t41*(4.35d-1*t164*t49-2.1200000000000002d+0*t
     <           127*t163+t159)+t156+t132
              t199 = -5.804705107829683d-52*t160*t47+t162+t161
              t200 = t171+t170+t169-8.44345d-3*t164*t167*t168+t166
              t201 = -2.4024572168959762d-52*t133*t30*t61
              t202 = -3.3333343122271064d-1*t164*t57*t58-3.2163968442914
     1           83d+1*t200
              t203 = -2.162211495206379d-51*rhoa*t115*t202*t30*t59
              t204 = (-2.718750000000001d-2*t164*t49-1.3250000000000003d
     1           -1*t127*t199+t165)*t69+t51*(5.181781811609147d-3*t164*t
     2           68+3.109069086965489d-2*t112*(-2.4024572168959762d-52*t
     3           133*t30*t63*t66+2.162211495206379d-51*rhoa*(t203+t201+t
     4           192+t188+t186+t185+t183+t182)*t30*t66-2.162211495206379
     5           d-51*rhoa*t118*t30*t63*(-1.038924122222801d-102*t164*t3
     6           6*t64-9.350317100005209d-102*t120*t202*t36*t59+2.901929
     7           443092681d-98*t187*t191*t197*t36+t203+t201+t196+t195+t1
     8           94+t193+t192+t188+t186+t185+t183+t182)+t181+t180+t179+t
     9           178+t177+t176+t175+t174)+1.0d+0*t200+t173)+3.1250000000
     :           000006d-2*t105*t133*t50-6.250000000000001d-2*t41*(-4.35
     ;           d-1*t164*t49-2.1200000000000002d+0*t127*t199+t159)+t156
     <           +t132
              fnc(iq) = 2.0d+0*rhoa*(4.375d-2*t46+1.0d+0)*t46*wght+fnc(i
     1           q)
              Amat(iq,D1_RA) = 1.0d+0*t70*t71*wght+2.0d+0*rhoa*t128*t71*
     1           wght+8.750000000000002d-2*rhoa*t128*t70*wght+Amat(iq,D1
     2           _RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t198*t71*wght+8.750000000
     1           000002d-2*rhoa*t198*t70*wght+t131+t130+t129+Amat2(iq,D2
     2           _RA_RA)
              Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t204*t71*wght+8.750000000
     1           000002d-2*rhoa*t204*t70*wght+t131+t130+t129+Amat2(iq,D2
     2           _RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 2.1622114952063792d-1*gammaaa*t29*t32
              t34 = t33+1.0d+0
              t35 = gammaaa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 4.675158550002606d-2*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 2.1622114952063792d-1*gammaaa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = rhoa-rhob
              t44 = t42*t43
              t45 = t44**2.0d+0
              t46 = t44**4.0d+0
              t47 = 5.0d-1*t46+8.7d-1*t45+2.2599999999999998d+0*t44**6.0
     1           d+0+5.3d-1
              t48 = 1/t1**2.6666666666666666d+0
              t49 = 1.0d+0-t42*t43
              t50 = t44+1.0d+0
              t51 = 1/t50**1.333333333333333d+0+1/t49**1.333333333333333
     1           d+0
              t52 = t49**2
              t53 = t50**2
              t54 = gammabb*t53+gammaaa*t52-2.0d+0*gammaab*t49*t50
              t55 = 1.3060586492616802d-2*t48*t51*t54+1.0d+0
              t56 = 1/t55**4.0d+0
              t57 = t47*t56+1.0d+0
              t58 = gammabb+2.0d+0*gammaab+gammaaa
              t59 = taub+taua
              t60 = 1/t59
              t61 = t42*t58*t60
              t62 = t61**2.0d+0
              t63 = rhob**3.333333333333333d-1
              t64 = t63**5.0d-1
              t65 = 1/t64
              t66 = 1.530901310039024d-2*t65+1.0465751434d-1
              t67 = 7.876233178997433d-1*t65*t66+1.9269083139d-1
              t68 = 7.876233178997433d-1*t65*t67+4.3896648423d-1
              t69 = 1/t68
              t70 = 1.269642451250142d+0*t64*t69+1.0d+0
              t71 = log(t70)
              t72 = 1/t63
              t73 = 1.2746961887000874d-1*t72+1.0d+0
              t74 = 2.4141993114533214d-2*t65+1.0186556948d-1
              t75 = 7.876233178997433d-1*t65*t74+2.2308199064d-1
              t76 = 7.876233178997433d-1*t65*t75+4.7231125998d-1
              t77 = 1/t76
              t78 = 1.269642451250142d+0*t64*t77+1.0d+0
              t79 = log(t78)
              t80 = 1.325688999052018d-1*t72+1.0d+0
              t81 = 1.3212998810398843d-2*t65+2.9729725188d-2
              t82 = 7.876233178997433d-1*t65*t81+1.2236585478d-1
              t83 = 7.876233178997433d-1*t65*t82+3.497952466d-1
              t84 = 1/t83
              t85 = 1.269642451250142d+0*t64*t84+1.0d+0
              t86 = log(t85)
              t87 = 6.901399211255826d-2*t72+1.0d+0
              t88 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t79*t80-3.10907d-2*t71*t73)-3.37738d-2*t86*t
     2           87)+3.37738d-2*t86*t87)-6.21814d-2*t79*t80
              t89 = rhob**1.1666666666666667d+0
              t90 = 1/t89**2.0d+0
              t91 = exp(-6.432793688582967d+1*t88)
              t92 = t91-1.0d+0
              t93 = 1/t92
              t94 = 2.1622114952063792d-1*gammabb*t90*t93
              t95 = t94+1.0d+0
              t96 = gammabb*t90
              t97 = t96**2.0d+0
              t98 = 1/t92**2.0d+0
              t99 = 4.675158550002606d-2*t97*t98+t94+1.0d+0
              t100 = 1/t99
              t101 = 2.1622114952063792d-1*gammabb*t100*t90*t95+1.0d+0
              t102 = 1.0d+0*t88+1.5545345434827443d-2*log(t101)
              t103 = t1**3.333333333333333d-1
              t104 = 1/t103
              t105 = 1.325688999052018d-1*t104+1.0d+0
              t106 = t103**5.0d-1
              t107 = 1/t106
              t108 = 2.4141993114533214d-2*t107+1.0186556948d-1
              t109 = 7.876233178997433d-1*t107*t108+2.2308199064d-1
              t110 = 7.876233178997433d-1*t107*t109+4.7231125998d-1
              t111 = 1/t110
              t112 = 1.269642451250142d+0*t106*t111+1.0d+0
              t113 = log(t112)
              t114 = t49**1.3333333333333333d+0
              t115 = t50**1.3333333333333333d+0
              t116 = 1.923661050931536d+0*t115+1.923661050931536d+0*t114
     1           -3.847322101863072d+0
              t117 = 6.901399211255826d-2*t104+1.0d+0
              t118 = 1.3212998810398843d-2*t107+2.9729725188d-2
              t119 = 7.876233178997433d-1*t107*t118+1.2236585478d-1
              t120 = 7.876233178997433d-1*t107*t119+3.497952466d-1
              t121 = 1/t120
              t122 = 1.269642451250142d+0*t106*t121+1.0d+0
              t123 = log(t122)
              t124 = t43**4
              t125 = 1/t1**4
              t126 = 1.2746961887000874d-1*t104+1.0d+0
              t127 = 1.530901310039024d-2*t107+1.0465751434d-1
              t128 = 7.876233178997433d-1*t107*t127+1.9269083139d-1
              t129 = 7.876233178997433d-1*t107*t128+4.3896648423d-1
              t130 = 1/t129
              t131 = 1.269642451250142d+0*t106*t130+1.0d+0
              t132 = log(t131)
              t133 = 1.709920934161365d+0*(6.21814d-2*t105*t113-3.10907d
     1           -2*t126*t132)-3.37738d-2*t117*t123
              t134 = t124*t125*t133+3.37738d-2*t117*t123
              t135 = 5.848223622634648d-1*t116*t134-6.21814d-2*t105*t113
              t136 = t49**6.666666666666666d-1
              t137 = t50**6.666666666666666d-1
              t138 = 5.0d-1*t137+5.0d-1*t136
              t139 = t138**3.0d+0
              t140 = t1**1.1666666666666667d+0
              t141 = 1/t140**2.0d+0
              t142 = t138**2.0d+0
              t143 = 1/t142
              t144 = 1/t139
              t145 = exp(-3.216396844291483d+1*t135*t144)
              t146 = t145-1.0d+0
              t147 = 1/t146
              t148 = 1.3621078885675922d-1*t141*t143*t147*t58
              t149 = t148+1.0d+0
              t150 = 1/t138**4.0d+0
              t151 = t141*t58
              t152 = t151**2.0d+0
              t153 = 1/t146**2.0d+0
              t154 = 1.855337900098064d-2*t150*t152*t153+t148+1.0d+0
              t155 = 1/t154
              t156 = 1.3621078885675922d-1*t141*t143*t149*t155*t58+1.0d+
     1           0
              t157 = log(t156)
              t158 = 3.109069086965489d-2*t139*t157+1.0d+0*t135
              t159 = 1.5625d-2*t47*t56*t62+1.0d+0
              t160 = -1.5625d-2*rhoa*t41*t42*t57*t62-1.5625d-2*rhob*t102
     1           *t42*t57*t62+t158*t159
              t161 = t61**3.0d+0
              t162 = 5.46875d-3*t160*t161+1.0d+0
              t163 = 1/t1**3
              t164 = 3.125d-2*rhoa*t163*t41*t57*t58*t60*t61
              t165 = 3.125d-2*rhob*t102*t163*t57*t58*t60*t61
              t166 = 1/t1**2
              t167 = t166*t43
              t168 = -t42
              t169 = t168+t167
              t170 = -t166*t43
              t171 = t42+t170
              t172 = 2*gammabb*t171*t50-2.0d+0*gammaab*t169*t50-2.0d+0*g
     1           ammaab*t171*t49+2*gammaaa*t169*t49
              t173 = 1/t49**2.333333333333333d+0
              t174 = 1/t50**2.333333333333333d+0
              t175 = -1.333333333333333d+0*t171*t174-1.333333333333333d+
     1           0*t169*t173
              t176 = 1/t1**3.6666666666666664d+0
              t177 = -3.482823064697814d-2*t176*t51*t54
              t178 = 1.3060586492616802d-2*t175*t48*t54+1.30605864926168
     1           02d-2*t172*t48*t51+t177
              t179 = 1/t55**5.0d+0
              t180 = t44**3.0d+0
              t181 = t44**5.0d+0
              t182 = 1.74d+0*t171*t44+1.356d+1*t171*t181+2.0d+0*t171*t18
     1           0
              t183 = t182*t56-4.0d+0*t178*t179*t47
              t184 = 1.5625d-2*rhoa*t166*t41*t57*t62
              t185 = 1/rhoa**1.3333333333333333d+0
              t186 = 1/t9
              t187 = 1/t7**2
              t188 = 1/rhoa**1.3333333333333336d+0
              t189 = 1/t3**3
              t190 = 1/rhoa**6.666666666666667d-1
              t191 = -1.3127055298329054d-1*t189*t190*t5-2.0096226153166
     1           658d-3*t188
              t192 = 7.876233178997433d-1*t191*t4-1.3127055298329054d-1*
     1           t189*t190*t6
              t193 = 2.11607075208357d-1*t190*t4*t8-1.269642451250142d+0
     1           *t187*t192*t3
              t194 = 1/t17
              t195 = 1/t15**2
              t196 = -1.3127055298329054d-1*t13*t189*t190-3.169132786263
     1           567d-3*t188
              t197 = 7.876233178997433d-1*t196*t4-1.3127055298329054d-1*
     1           t14*t189*t190
              t198 = 2.11607075208357d-1*t16*t190*t4-1.269642451250142d+
     1           0*t195*t197*t3
              t199 = 1/t24
              t200 = 1/t22**2
              t201 = -1.3127055298329054d-1*t189*t190*t20-1.734477660408
     1           6162d-3*t188
              t202 = 7.876233178997433d-1*t201*t4-1.3127055298329054d-1*
     1           t189*t190*t21
              t203 = 2.11607075208357d-1*t190*t23*t4-1.269642451250142d+
     1           0*t200*t202*t3
              t204 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t199*t203
     1           *t26+7.769549222703733d-4*t185*t25+1.709920934161365d+0
     2           *(6.21814d-2*t19*t194*t198-3.10907d-2*t12*t186*t193-2.7
     3           47773264188438d-3*t18*t185+1.3210398931339265d-3*t10*t1
     4           85))+3.37738d-2*t199*t203*t26-7.769549222703733d-4*t185
     5           *t25)-6.21814d-2*t19*t194*t198+2.747773264188438d-3*t18
     6           *t185
              t205 = 1/t40
              t206 = rhoa**1.6666666666666674d-1
              t207 = 1/t28**3.0d+0
              t208 = -5.045160155481552d-1*gammaaa*t206*t207*t32
              t209 = 1/t31**2
              t210 = 1.3909060459745137d+1*gammaaa*t204*t209*t29*t30
              t211 = t210+t208
              t212 = 1/t38**2
              t213 = 1/t31**3.0d+0
              t214 = -2.181740656667883d-1*gammaaa*t206*t207*t35*t37+6.0
     1           14866082716293d+0*t204*t213*t30*t36+t210+t208
              t215 = -5.045160155481552d-1*gammaaa*t206*t207*t34*t39+2.1
     1           622114952063792d-1*gammaaa*t211*t29*t39-2.1622114952063
     2           792d-1*gammaaa*t212*t214*t29*t34
              t216 = 1.5545345434827443d-2*t205*t215+1.0d+0*t204
              t217 = 1.5625d-2*rhob*t102*t166*t57*t62
              t218 = -3.125d-2*t166*t47*t56*t58*t60*t61
              t219 = 1.5625d-2*t182*t56*t62-6.25d-2*t178*t179*t47*t62+t2
     1           18
              t220 = 1/t1**1.3333333333333336d+0
              t221 = 1/t1**6.666666666666667d-1
              t222 = 1/t106**3
              t223 = -1.3127055298329054d-1*t108*t221*t222-3.16913278626
     1           3567d-3*t220
              t224 = 7.876233178997433d-1*t107*t223-1.3127055298329054d-
     1           1*t109*t221*t222
              t225 = 1/t110**2
              t226 = 2.11607075208357d-1*t107*t111*t221-1.26964245125014
     1           2d+0*t106*t224*t225
              t227 = 1/t112
              t228 = -6.21814d-2*t105*t226*t227
              t229 = 1/t1**1.3333333333333333d+0
              t230 = 2.747773264188438d-3*t113*t229
              t231 = -1.3127055298329054d-1*t118*t221*t222-1.73447766040
     1           86162d-3*t220
              t232 = 7.876233178997433d-1*t107*t231-1.3127055298329054d-
     1           1*t119*t221*t222
              t233 = 1/t120**2
              t234 = 2.11607075208357d-1*t107*t121*t221-1.26964245125014
     1           2d+0*t106*t232*t233
              t235 = 1/t122
              t236 = 3.37738d-2*t117*t234*t235
              t237 = -7.769549222703733d-4*t123*t229
              t238 = -1.3127055298329054d-1*t127*t221*t222-2.00962261531
     1           66658d-3*t220
              t239 = 7.876233178997433d-1*t107*t238-1.3127055298329054d-
     1           1*t128*t221*t222
              t240 = 1/t129**2
              t241 = 2.11607075208357d-1*t107*t130*t221-1.26964245125014
     1           2d+0*t106*t239*t240
              t242 = 1/t131
              t243 = 1.709920934161365d+0*(-3.10907d-2*t126*t241*t242+1.
     1           3210398931339265d-3*t132*t229-2.747773264188438d-3*t113
     2           *t229+6.21814d-2*t105*t226*t227)-3.37738d-2*t117*t234*t
     3           235+7.769549222703733d-4*t123*t229
              t244 = t124*t125*t243
              t245 = 1/t1**5
              t246 = -4*t124*t133*t245
              t247 = t43**3
              t248 = 4*t125*t133*t247+t246+t244+t237+t236
              t249 = t49**3.333333333333333d-1
              t250 = t50**3.333333333333333d-1
              t251 = 2.564881401242048d+0*t171*t250+2.564881401242048d+0
     1           *t169*t249
              t252 = 5.848223622634648d-1*t134*t251+5.848223622634648d-1
     1           *t116*t248+t230+t228
              t253 = 1/t156
              t254 = 1/t249
              t255 = 1/t250
              t256 = 3.333333333333333d-1*t171*t255+3.333333333333333d-1
     1           *t169*t254
              t257 = t1**1.6666666666666674d-1
              t258 = 1/t140**3.0d+0
              t259 = -3.1782517399910487d-1*t143*t149*t155*t257*t258*t58
              t260 = -2.7242157771351844d-1*t141*t144*t147*t256*t58
              t261 = -3.1782517399910487d-1*t143*t147*t257*t258*t58
              t262 = 1/t146**2
              t263 = 9.649190532874448d+1*t135*t150*t256-3.2163968442914
     1           83d+1*t144*t252
              t264 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t58
              t265 = t264+t261+t260
              t266 = 1/t154**2
              t267 = -8.658243533790966d-2*t150*t151*t153*t257*t258*t58
              t268 = 1/t138**5.0d+0
              t269 = 1/t146**3.0d+0
              t270 = -3.710675800196128d-2*t145*t150*t152*t263*t269-7.42
     1           1351600392256d-2*t152*t153*t256*t268+t267+t264+t261+t26
     2           0
              t271 = -1.3621078885675922d-1*t141*t143*t149*t266*t270*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t265*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t256*t58+t259
              t272 = 3.109069086965489d-2*t139*t253*t271+9.3272072608964
     1           66d-2*t142*t157*t256+1.0d+0*t252
              t273 = -1.5625d-2*t41*t42*t57*t62-1.5625d-2*rhoa*t216*t42*
     1           t57*t62-1.5625d-2*rhoa*t183*t41*t42*t62-1.5625d-2*rhob*
     2           t102*t183*t42*t62+t159*t272+t158*t219+t217+t184+t165+t1
     3           64
              t274 = -1.6406249999999997d-2*t160*t166*t58*t60*t62
              t275 = t274+5.46875d-3*t161*t273
              t276 = 1.0d+0*t160*t162*wght
              t277 = t170+t168
              t278 = t42+t167
              t279 = -2.0d+0*gammaab*t278*t50+2*gammabb*t277*t50+2*gamma
     1           aa*t278*t49-2.0d+0*gammaab*t277*t49
              t280 = -1.333333333333333d+0*t173*t278-1.333333333333333d+
     1           0*t174*t277
              t281 = 1.3060586492616802d-2*t280*t48*t54+1.30605864926168
     1           02d-2*t279*t48*t51+t177
              t282 = 1.74d+0*t277*t44+1.356d+1*t181*t277+2.0d+0*t180*t27
     1           7
              t283 = t282*t56-4.0d+0*t179*t281*t47
              t284 = 1/rhob**1.3333333333333333d+0
              t285 = 1/t70
              t286 = 1/t68**2
              t287 = 1/rhob**1.3333333333333336d+0
              t288 = 1/t64**3
              t289 = 1/rhob**6.666666666666667d-1
              t290 = -1.3127055298329054d-1*t288*t289*t66-2.009622615316
     1           6658d-3*t287
              t291 = 7.876233178997433d-1*t290*t65-1.3127055298329054d-1
     1           *t288*t289*t67
              t292 = 2.11607075208357d-1*t289*t65*t69-1.269642451250142d
     1           +0*t286*t291*t64
              t293 = 1/t78
              t294 = 1/t76**2
              t295 = -1.3127055298329054d-1*t288*t289*t74-3.169132786263
     1           567d-3*t287
              t296 = 7.876233178997433d-1*t295*t65-1.3127055298329054d-1
     1           *t288*t289*t75
              t297 = 2.11607075208357d-1*t289*t65*t77-1.269642451250142d
     1           +0*t294*t296*t64
              t298 = 1/t85
              t299 = 1/t83**2
              t300 = -1.3127055298329054d-1*t288*t289*t81-1.734477660408
     1           6162d-3*t287
              t301 = 7.876233178997433d-1*t300*t65-1.3127055298329054d-1
     1           *t288*t289*t82
              t302 = 2.11607075208357d-1*t289*t65*t84-1.269642451250142d
     1           +0*t299*t301*t64
              t303 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t298*t302
     1           *t87+7.769549222703733d-4*t284*t86+1.709920934161365d+0
     2           *(6.21814d-2*t293*t297*t80-2.747773264188438d-3*t284*t7
     3           9-3.10907d-2*t285*t292*t73+1.3210398931339265d-3*t284*t
     4           71))+3.37738d-2*t298*t302*t87-7.769549222703733d-4*t284
     5           *t86)-6.21814d-2*t293*t297*t80+2.747773264188438d-3*t28
     6           4*t79
              t304 = 1/t101
              t305 = rhob**1.6666666666666674d-1
              t306 = 1/t89**3.0d+0
              t307 = -5.045160155481552d-1*gammabb*t305*t306*t93
              t308 = 1/t92**2
              t309 = 1.3909060459745137d+1*gammabb*t303*t308*t90*t91
              t310 = t309+t307
              t311 = 1/t99**2
              t312 = 1/t92**3.0d+0
              t313 = -2.181740656667883d-1*gammabb*t305*t306*t96*t98+6.0
     1           14866082716293d+0*t303*t312*t91*t97+t309+t307
              t314 = -2.1622114952063792d-1*gammabb*t311*t313*t90*t95-5.
     1           045160155481552d-1*gammabb*t100*t305*t306*t95+2.1622114
     2           952063792d-1*gammabb*t100*t310*t90
              t315 = 1.5545345434827443d-2*t304*t314+1.0d+0*t303
              t316 = 1.5625d-2*t282*t56*t62-6.25d-2*t179*t281*t47*t62+t2
     1           18
              t317 = -4*t125*t133*t247+t246+t244+t237+t236
              t318 = 2.564881401242048d+0*t249*t278+2.564881401242048d+0
     1           *t250*t277
              t319 = 5.848223622634648d-1*t134*t318+5.848223622634648d-1
     1           *t116*t317+t230+t228
              t320 = 3.333333333333333d-1*t254*t278+3.333333333333333d-1
     1           *t255*t277
              t321 = -2.7242157771351844d-1*t141*t144*t147*t320*t58
              t322 = 9.649190532874448d+1*t135*t150*t320-3.2163968442914
     1           83d+1*t144*t319
              t323 = -1.3621078885675922d-1*t141*t143*t145*t262*t322*t58
              t324 = t323+t321+t261
              t325 = t323-3.710675800196128d-2*t145*t150*t152*t269*t322+
     1           t321-7.421351600392256d-2*t152*t153*t268*t320+t267+t261
              t326 = -1.3621078885675922d-1*t141*t143*t149*t266*t325*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t324*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t320*t58+t259
              t327 = 3.109069086965489d-2*t139*t253*t326+9.3272072608964
     1           66d-2*t142*t157*t320+1.0d+0*t319
              t328 = -1.5625d-2*rhob*t315*t42*t57*t62-1.5625d-2*t102*t42
     1           *t57*t62-1.5625d-2*rhoa*t283*t41*t42*t62-1.5625d-2*rhob
     2           *t102*t283*t42*t62+t159*t327+t158*t316+t217+t184+t165+t
     3           164
              t329 = 5.46875d-3*t161*t328+t274
              t330 = -3.125d-2*rhoa*t166*t41*t57*t60*t61
              t331 = -3.125d-2*rhob*t102*t166*t57*t60*t61
              t332 = 9.350317100005212d-2*t29*t35*t37+2.1622114952063792
     1           d-1*t29*t32
              t333 = 1/t28**4.0d+0
              t334 = 2.1622114952063792d-1*t29*t34*t39+4.675158550002606
     1           d-2*gammaaa*t32*t333*t39-2.1622114952063792d-1*gammaaa*
     2           t212*t29*t332*t34
              t335 = 3.125d-2*t42*t47*t56*t60*t61
              t336 = t335-8.162866557885502d-4*t179*t47*t48*t51*t52*t62
              t337 = 3.710675800196128d-2*t141*t150*t151*t153+1.36210788
     1           85675922d-1*t141*t143*t147
              t338 = 1/t140**4.0d+0
              t339 = 1.855337900098064d-2*t147*t150*t155*t338*t58-1.3621
     1           078885675922d-1*t141*t143*t149*t266*t337*t58+1.36210788
     2           85675922d-1*t141*t143*t149*t155
              t340 = 3.109069086965489d-2*t139*t159*t253*t339
              t341 = -2.4289602241917876d-4*rhoa*t205*t334*t42*t57*t62+8
     1           .162866557885502d-4*rhoa*t176*t179*t41*t47*t51*t52*t62+
     2           8.162866557885502d-4*rhob*t102*t176*t179*t47*t51*t52*t6
     3           2+t340+t158*t336+t331+t330
              t342 = 1.6406249999999997d-2*t160*t42*t60*t62
              t343 = t342+5.46875d-3*t161*t341
              t344 = 1.6325733115771002d-3*t179*t47*t48*t49*t50*t51*t62+
     1           6.25d-2*t42*t47*t56*t60*t61
              t345 = 7.421351600392256d-2*t141*t150*t151*t153+2.72421577
     1           71351844d-1*t141*t143*t147
              t346 = -1.3621078885675922d-1*t141*t143*t149*t266*t345*t58
     1           +3.710675800196128d-2*t147*t150*t155*t338*t58+2.7242157
     2           771351844d-1*t141*t143*t149*t155
              t347 = -1.6325733115771002d-3*rhoa*t176*t179*t41*t47*t49*t
     1           50*t51*t62-1.6325733115771002d-3*rhob*t102*t176*t179*t4
     2           7*t49*t50*t51*t62-6.25d-2*rhoa*t166*t41*t57*t60*t61-6.2
     3           5d-2*rhob*t102*t166*t57*t60*t61+3.109069086965489d-2*t1
     4           39*t159*t253*t346+t158*t344
              t348 = 3.2812499999999994d-2*t160*t42*t60*t62+5.46875d-3*t
     1           161*t347
              t349 = 9.350317100005212d-2*t90*t96*t98+2.1622114952063792
     1           d-1*t90*t93
              t350 = 1/t89**4.0d+0
              t351 = -2.1622114952063792d-1*gammabb*t311*t349*t90*t95+2.
     1           1622114952063792d-1*t100*t90*t95+4.675158550002606d-2*g
     2           ammabb*t100*t350*t93
              t352 = t335-8.162866557885502d-4*t179*t47*t48*t51*t53*t62
              t353 = -2.4289602241917876d-4*rhob*t304*t351*t42*t57*t62+8
     1           .162866557885502d-4*rhoa*t176*t179*t41*t47*t51*t53*t62+
     2           8.162866557885502d-4*rhob*t102*t176*t179*t47*t51*t53*t6
     3           2+t158*t352+t340+t331+t330
              t354 = 5.46875d-3*t161*t353+t342
              t355 = 1/t59**2
              t356 = 3.125d-2*rhoa*t166*t355*t41*t57*t58*t61+3.125d-2*rh
     1           ob*t102*t166*t355*t57*t58*t61-3.125d-2*t158*t355*t42*t4
     2           7*t56*t58*t61
              t357 = 5.46875d-3*t161*t356-1.6406249999999997d-2*t160*t35
     1           5*t42*t58*t62
              t358 = 1.0d+0*t1*t160*t357*wght+1.0d+0*t1*t162*t356*wght
              t359 = t58**2
              t360 = -1.25d-1*rhoa*t245*t355*t359*t41*t57
              t361 = -1.25d-1*rhob*t102*t245*t355*t359*t57
              t362 = 3.125d-2*rhoa*t163*t183*t41*t58*t60*t61
              t363 = -3.125d-2*rhoa*t125*t41*t57*t58*t60*t61
              t364 = 3.125d-2*rhoa*t163*t216*t57*t58*t60*t61
              t365 = 3.125d-2*t163*t41*t57*t58*t60*t61
              t366 = 3.125d-2*rhob*t102*t163*t183*t58*t60*t61
              t367 = -3.125d-2*rhob*t102*t125*t57*t58*t60*t61
              t368 = -3.125d-2*rhoa*t163*t41*t57*t62
              t369 = 1/rhoa**2.333333333333333d+0
              t370 = 1/rhoa**2.3333333333333334d+0
              t371 = 1/rhoa**1.6666666666666669d+0
              t372 = 1/t3**5
              t373 = 1/t17**2
              t374 = t198**2
              t375 = -1.269642451250142d+0*t195*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t13*t188*t372+8.751370198886037d
     2           -2*t13*t189*t371+4.753699179395351d-3*t370)*t4+6.563527
     3           649164527d-2*t14*t188*t372+8.751370198886037d-2*t14*t18
     4           9*t371-2.625411059665811d-1*t189*t190*t196)-1.410713834
     5           7223802d-1*t16*t371*t4-4.23214150416714d-1*t190*t195*t1
     6           97*t4+2.539284902500284d+0*t197**2*t3/t15**3-3.52678458
     7           680595d-2*t16*t188*t189
              t376 = 1/t24**2
              t377 = t203**2
              t378 = -1.269642451250142d+0*t200*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t188*t20*t372+8.751370198886037d
     2           -2*t189*t20*t371+2.601716490612924d-3*t370)*t4+6.563527
     3           649164527d-2*t188*t21*t372+8.751370198886037d-2*t189*t2
     4           1*t371-2.625411059665811d-1*t189*t190*t201)-1.410713834
     5           7223802d-1*t23*t371*t4-4.23214150416714d-1*t190*t200*t2
     6           02*t4+2.539284902500284d+0*t202**2*t3/t22**3-3.52678458
     7           680595d-2*t188*t189*t23
              t379 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (3.10907d-2*t12*t193**2/t9**2-3.10907d-2*t12*t186*(-1.4
     2           107138347223802d-1*t371*t4*t8-3.52678458680595d-2*t188*
     3           t189*t8+2.539284902500284d+0*t192**2*t3/t7**3-1.2696424
     4           51250142d+0*t187*t3*(6.563527649164527d-2*t188*t372*t6+
     5           8.751370198886037d-2*t189*t371*t6+7.876233178997433d-1*
     6           t4*(6.563527649164527d-2*t188*t372*t5+8.751370198886037
     7           d-2*t189*t371*t5+3.0144339229749983d-3*t370)-2.62541105
     8           9665811d-1*t189*t190*t191)-4.23214150416714d-1*t187*t19
     9           0*t192*t4)+6.21814d-2*t19*t194*t375-6.21814d-2*t19*t373
     :           *t374+3.663697685584584d-3*t18*t369-1.7613865241785687d
     ;           -3*t10*t369-5.495546528376876d-3*t185*t194*t198+2.64207
     <           9786267853d-3*t185*t186*t193)-3.37738d-2*t199*t26*t378+
     =           3.37738d-2*t26*t376*t377-1.0359398963604977d-3*t25*t369
     >           +1.5539098445407465d-3*t185*t199*t203)+3.37738d-2*t199*
     ?           t26*t378-3.37738d-2*t26*t376*t377+1.0359398963604977d-3
     @           *t25*t369-1.5539098445407465d-3*t185*t199*t203)-6.21814
     1           d-2*t19*t194*t375+6.21814d-2*t19*t373*t374-3.6636976855
     2           84584d-3*t18*t369+5.495546528376876d-3*t185*t194*t198
              t380 = rhoa**3.333333333333335d-1
              t381 = 1/rhoa**8.333333333333333d-1
              t382 = t204**2
              t383 = exp(-1.2865587377165935d+2*t27)
              t384 = 1.7894823267913484d+3*gammaaa*t29*t382*t383/t31**3
              t385 = 1.765806054418543d+0*gammaaa*t32*t333*t380
              t386 = -8.408600259135923d-2*gammaaa*t207*t32*t381
              t387 = -6.490894881214397d+1*gammaaa*t204*t206*t207*t209*t
     1           30
              t388 = -8.947411633956742d+2*gammaaa*t209*t29*t30*t382
              t389 = 1.3909060459745137d+1*gammaaa*t209*t29*t30*t379
              t390 = gammaaa**2
              t391 = 1/t28**6.0d+0
              t392 = 1/t28**5.0d+0
              t393 = 1/t38**3
              t394 = 1/t40**2
              t395 = t178**2
              t396 = 1/t55**6.0d+0
              t397 = 2*t163*t43
              t398 = -2*t166
              t399 = t398+t397
              t400 = -2*t163*t43
              t401 = 2*t166
              t402 = t401+t400
              t403 = t169**2
              t404 = t171**2
              t405 = 1/t49**3.333333333333333d+0
              t406 = 1/t50**3.333333333333333d+0
              t407 = 1/t1**4.666666666666667d+0
              t408 = 1.2770351237225316d-1*t407*t51*t54
              t409 = 1.3060586492616802d-2*(3.11111111111111d+0*t404*t40
     1           6+3.11111111111111d+0*t403*t405-1.333333333333333d+0*t1
     2           73*t402-1.333333333333333d+0*t174*t399)*t48*t54-6.96564
     3           6129395628d-2*t175*t176*t54+1.3060586492616802d-2*t48*(
     4           -2.0d+0*gammaab*t402*t50+2*gammabb*t399*t50+2*gammaaa*t
     5           402*t49-2.0d+0*gammaab*t399*t49+2*gammabb*t404+2*gammaa
     6           a*t403-4.0d+0*gammaab*t169*t171)*t51-6.965646129395628d
     7           -2*t172*t176*t51+2.6121172985233604d-2*t172*t175*t48+t4
     8           08
              t410 = 6.779999999999999d+1*t404*t46+6.0d+0*t404*t45+1.74d
     1           +0*t399*t42*t43+1.74d+0*t404+1.356d+1*t181*t399+2.0d+0*
     2           t180*t399
              t411 = t410*t56-4.0d+0*t179*t409*t47+2.0d+1*t395*t396*t47-
     1           8.0d+0*t178*t179*t182
              t412 = -3.125d-2*rhob*t102*t163*t57*t62
              t413 = t226**2
              t414 = 1/t112**2
              t415 = 6.21814d-2*t105*t413*t414
              t416 = 1/t1**2.3333333333333334d+0
              t417 = 1/t106**5
              t418 = 1/t1**1.6666666666666669d+0
              t419 = -1.269642451250142d+0*t106*t225*(7.876233178997433d
     1           -1*t107*(8.751370198886037d-2*t108*t222*t418+6.56352764
     2           9164527d-2*t108*t220*t417+4.753699179395351d-3*t416)+8.
     3           751370198886037d-2*t109*t222*t418+6.563527649164527d-2*
     4           t109*t220*t417-2.625411059665811d-1*t221*t222*t223)-1.4
     5           107138347223802d-1*t107*t111*t418-4.23214150416714d-1*t
     6           107*t221*t224*t225+2.539284902500284d+0*t106*t224**2/t1
     7           10**3-3.52678458680595d-2*t111*t220*t222
              t420 = -6.21814d-2*t105*t227*t419
              t421 = 5.495546528376876d-3*t226*t227*t229
              t422 = 1/t1**2.333333333333333d+0
              t423 = -3.663697685584584d-3*t113*t422
              t424 = t234**2
              t425 = 1/t122**2
              t426 = -3.37738d-2*t117*t424*t425
              t427 = -1.269642451250142d+0*t106*t233*(7.876233178997433d
     1           -1*t107*(8.751370198886037d-2*t118*t222*t418+6.56352764
     2           9164527d-2*t118*t220*t417+2.601716490612924d-3*t416)+8.
     3           751370198886037d-2*t119*t222*t418+6.563527649164527d-2*
     4           t119*t220*t417-2.625411059665811d-1*t221*t222*t231)-1.4
     5           107138347223802d-1*t107*t121*t418-4.23214150416714d-1*t
     6           107*t221*t232*t233+2.539284902500284d+0*t106*t232**2/t1
     7           20**3-3.52678458680595d-2*t121*t220*t222
              t428 = 3.37738d-2*t117*t235*t427
              t429 = -1.5539098445407465d-3*t229*t234*t235
              t430 = 1.0359398963604977d-3*t123*t422
              t431 = t124*t125*(-3.37738d-2*t117*t235*t427+3.37738d-2*t1
     1           17*t424*t425+1.709920934161365d+0*(-1.7613865241785687d
     2           -3*t132*t422+3.663697685584584d-3*t113*t422+6.21814d-2*
     3           t105*t227*t419-3.10907d-2*t126*t242*(-1.269642451250142
     4           d+0*t106*t240*(7.876233178997433d-1*t107*(8.75137019888
     5           6037d-2*t127*t222*t418+6.563527649164527d-2*t127*t220*t
     6           417+3.0144339229749983d-3*t416)+8.751370198886037d-2*t1
     7           28*t222*t418+6.563527649164527d-2*t128*t220*t417-2.6254
     8           11059665811d-1*t221*t222*t238)-1.4107138347223802d-1*t1
     9           07*t130*t418-4.23214150416714d-1*t107*t221*t239*t240+2.
     :           539284902500284d+0*t106*t239**2/t129**3-3.5267845868059
     ;           5d-2*t130*t220*t222)-6.21814d-2*t105*t413*t414+2.642079
     <           786267853d-3*t229*t241*t242+3.10907d-2*t126*t241**2/t13
     =           1**2-5.495546528376876d-3*t226*t227*t229)-1.03593989636
     >           04977d-3*t123*t422+1.5539098445407465d-3*t229*t234*t235
     ?           )
              t432 = -8*t124*t243*t245
              t433 = 20*t124*t133/t1**6
              t434 = t43**2
              t435 = 12*t125*t133*t434
              t436 = 1/t136
              t437 = 1/t137
              t438 = 5.848223622634648d-1*t134*(8.549604670806825d-1*t40
     1           4*t437+8.549604670806825d-1*t403*t436+2.564881401242048
     2           d+0*t249*t402+2.564881401242048d+0*t250*t399)+5.8482236
     3           22634648d-1*t116*(t435+t433+t432+t431+t430+t429+t428+t4
     4           26-32*t133*t245*t247+8*t125*t243*t247)+t423+t421+t420+t
     5           415+1.1696447245269297d+0*t248*t251
              t439 = t256**2
              t440 = 1/t114
              t441 = 1/t115
              t442 = -1.111111111111111d-1*t404*t441-1.111111111111111d-
     1           1*t403*t440+3.333333333333333d-1*t254*t402+3.3333333333
     2           33333d-1*t255*t399
              t443 = t1**3.333333333333335d-1
              t444 = 1.1123881089968671d+0*t143*t149*t155*t338*t443*t58
              t445 = 1/t1**8.333333333333333d-1
              t446 = -5.297086233318417d-2*t143*t149*t155*t258*t445*t58
              t447 = 8.172647331405554d-1*t141*t147*t150*t439*t58
              t448 = -2.7242157771351844d-1*t141*t144*t147*t442*t58
              t449 = 1.2713006959964196d+0*t144*t147*t256*t257*t258*t58
              t450 = 1.1123881089968671d+0*t143*t147*t338*t443*t58
              t451 = -5.297086233318417d-2*t143*t147*t258*t445*t58
              t452 = 9.649190532874448d+1*t135*t150*t442-3.8596762131497
     1           79d+2*t135*t268*t439-3.216396844291483d+1*t144*t438+1.9
     2           298381065748896d+2*t150*t252*t256
              t453 = -1.3621078885675922d-1*t141*t143*t145*t262*t452*t58
              t454 = 5.448431554270369d-1*t141*t144*t145*t256*t262*t263*
     1           t58
              t455 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t263*
     1           t58
              t456 = exp(-6.432793688582966d+1*t135*t144)
              t457 = 1/t146**3
              t458 = t263**2
              t459 = 2.7242157771351844d-1*t141*t143*t456*t457*t458*t58
              t460 = -1.3621078885675922d-1*t141*t143*t145*t262*t458*t58
              t461 = 3.4632974135163863d-1*t151*t153*t256*t257*t258*t268
     1           *t58
              t462 = 1/t140**5.0d+0
              t463 = 1/t140**6.0d+0
              t464 = 5.050642061378063d-1*t150*t153*t359*t443*t463
              t465 = -1.4430405889651615d-2*t150*t153*t359*t445*t462
              t466 = 1/t138**6.0d+0
              t467 = 1.7316487067581932d-1*t145*t150*t151*t257*t258*t263
     1           *t269*t58
              t468 = 1/t146**4.0d+0
              t469 = 1/t154**3
              t470 = 1/t156**2
              t471 = 9.375d-2*t125*t355*t359*t47*t56
              t472 = 1.25d-1*t166*t178*t179*t47*t58*t60*t61
              t473 = -3.125d-2*t166*t182*t56*t58*t60*t61
              t474 = t158*(1.5625d-2*t410*t56*t62-6.25d-2*t179*t409*t47*
     1           t62+3.125d-1*t395*t396*t47*t62-1.25d-1*t178*t179*t182*t
     2           62-3.125d-2*t163*t182*t355*t359*t56+t473+t472+t471+1.25
     3           d-1*t163*t178*t179*t355*t359*t47)-1.5625d-2*rhoa*(-1.55
     4           45345434827443d-2*t215**2*t394+1.5545345434827443d-2*t2
     5           05*(4.3244229904127585d-1*gammaaa*t214**2*t29*t34*t393-
     6           2.1622114952063792d-1*gammaaa*t212*t29*t34*(-3.63623442
     7           77798064d-2*t37*t381*t390*t392-2.806937505267603d+1*t20
     8           4*t206*t213*t30*t390*t392+1.2726820497229316d+0*t37*t38
     9           0*t390*t391+t389+t388+t387+t386+t385+t384+1.16077177723
     :           70736d+3*t36*t382*t383/t31**4.0d+0-3.869239257456912d+2
     ;           *t213*t30*t36*t382+6.014866082716293d+0*t213*t30*t36*t3
     <           79-2.806937505267603d+1*gammaaa*t204*t206*t207*t213*t30
     =           *t35)+2.1622114952063792d-1*gammaaa*t29*(t389+t388+t387
     >           +t386+t385+t384)*t39-8.408600259135923d-2*gammaaa*t207*
     ?           t34*t381*t39+1.765806054418543d+0*gammaaa*t333*t34*t380
     @           *t39-1.0090320310963104d+0*gammaaa*t206*t207*t211*t39+1
     1           .0090320310963104d+0*gammaaa*t206*t207*t212*t214*t34-4.
     2           3244229904127585d-1*gammaaa*t211*t212*t214*t29)+1.0d+0*
     3           t379)*t42*t57*t62-3.125d-2*t216*t42*t57*t62+3.125d-2*t1
     4           66*t41*t57*t62+3.125d-2*rhoa*t166*t216*t57*t62-1.5625d-
     5           2*rhoa*t41*t411*t42*t62-1.5625d-2*rhob*t102*t411*t42*t6
     6           2-3.125d-2*t183*t41*t42*t62-3.125d-2*rhoa*t183*t216*t42
     7           *t62+3.125d-2*rhoa*t166*t183*t41*t62+3.125d-2*rhob*t102
     8           *t166*t183*t62+t159*(3.109069086965489d-2*t139*t253*(2.
     9           7242157771351844d-1*t141*t143*t149*t270**2*t469*t58-1.3
     :           621078885675922d-1*t141*t143*t149*t266*(1.1132027400588
     ;           385d-1*t150*t152*t456*t458*t468+t467+3.710675800196128d
     <           -1*t152*t153*t439*t466+t465+t464+1.7316487067581932d-1*
     =           t145*t150*t257*t263*t269*t359*t462+3.4632974135163863d-
     >           1*t153*t256*t257*t268*t359*t462+t461+t460+t459-3.710675
     ?           800196128d-2*t145*t150*t152*t269*t458+t455+t454+t453-3.
     @           710675800196128d-2*t145*t150*t152*t269*t452+t451+t450+t
     1           449+t448+t447-7.421351600392256d-2*t152*t153*t268*t442+
     2           2.9685406401569026d-1*t145*t152*t256*t263*t268*t269)*t5
     3           8+1.3621078885675922d-1*t141*t143*t155*(t460+t459+t455+
     4           t454+t453+t451+t450+t449+t448+t447)*t58-2.7242157771351
     5           844d-1*t141*t144*t149*t155*t442*t58+8.172647331405554d-
     6           1*t141*t149*t150*t155*t439*t58-2.7242157771351844d-1*t1
     7           41*t143*t265*t266*t270*t58+6.356503479982097d-1*t143*t1
     8           49*t257*t258*t266*t270*t58+5.448431554270369d-1*t141*t1
     9           44*t149*t256*t266*t270*t58-6.356503479982097d-1*t143*t1
     :           55*t257*t258*t265*t58-5.448431554270369d-1*t141*t144*t1
     ;           55*t256*t265*t58+1.2713006959964196d+0*t144*t149*t155*t
     <           256*t257*t258*t58+t446+t444)-3.109069086965489d-2*t139*
     =           t271**2*t470+9.327207260896466d-2*t142*t157*t442+1.8654
     >           414521792934d-1*t138*t157*t439+1.0d+0*t438+1.8654414521
     ?           792934d-1*t142*t253*t256*t271)+3.125d-2*t125*t355*t359*
     @           t41*t57+3.125d-2*rhoa*t125*t216*t355*t359*t57+t412+3.12
     1           5d-2*rhoa*t125*t183*t355*t359*t41+t368+t367+t366+t365+t
     2           364+t363+t362+t361+t360+3.125d-2*rhob*t102*t125*t183*t3
     3           55*t359+2*t219*t272
              t475 = 3.2812499999999994d-2*t125*t160*t355*t359*t61
              t476 = 3.2812499999999994d-2*t160*t163*t58*t60*t62
              t477 = 3.125d-2*rhoa*t125*t283*t355*t359*t41
              t478 = 3.125d-2*rhob*t125*t315*t355*t359*t57
              t479 = 3.125d-2*rhob*t102*t125*t283*t355*t359
              t480 = 3.125d-2*t102*t125*t355*t359*t57
              t481 = 1.3060586492616802d-2*(-2.666666666666666d+0*t163*t
     1           174*t43+2.666666666666666d+0*t163*t173*t43+3.1111111111
     2           1111d+0*t171*t277*t406+3.11111111111111d+0*t169*t278*t4
     3           05)*t48*t54-3.482823064697814d-2*t176*t280*t54-3.482823
     4           064697814d-2*t175*t176*t54+1.3060586492616802d-2*t48*(4
     5           *gammabb*t163*t43*t50+4.0d+0*gammaab*t163*t43*t50-4.0d+
     6           0*gammaab*t163*t43*t49-4*gammaaa*t163*t43*t49-2.0d+0*ga
     7           mmaab*t171*t278+2*gammaaa*t169*t278+2*gammabb*t171*t277
     8           -2.0d+0*gammaab*t169*t277)*t51-3.482823064697814d-2*t17
     9           6*t279*t51-3.482823064697814d-2*t172*t176*t51+1.3060586
     :           492616802d-2*t172*t280*t48+1.3060586492616802d-2*t175*t
     ;           279*t48+t408
              t482 = 6.779999999999999d+1*t171*t277*t46+6.0d+0*t171*t277
     1           *t45+3.48d+0*t125*t434+2.712d+1*t163*t181*t43+4.0d+0*t1
     2           63*t180*t43+1.74d+0*t171*t277
              t483 = t482*t56-4.0d+0*t179*t47*t481+2.0d+1*t178*t281*t396
     1           *t47-4.0d+0*t178*t179*t282-4.0d+0*t179*t182*t281
              t484 = 1.25d-1*t163*t179*t281*t355*t359*t47
              t485 = -3.125d-2*t163*t282*t355*t359*t56
              t486 = 5.848223622634648d-1*t134*(8.549604670806825d-1*t17
     1           1*t277*t437+8.549604670806825d-1*t169*t278*t436+5.12976
     2           2802484096d+0*t163*t250*t43-5.129762802484096d+0*t163*t
     3           249*t43)+5.848223622634648d-1*t116*(-12*t125*t133*t434+
     4           t433+t432+t431+t430+t429+t428+t426)+t423+t421+t420+t415
     5           +5.848223622634648d-1*t248*t318+5.848223622634648d-1*t2
     6           51*t317
              t487 = -1.111111111111111d-1*t171*t277*t441-1.111111111111
     1           111d-1*t169*t278*t440+6.666666666666666d-1*t163*t255*t4
     2           3-6.666666666666666d-1*t163*t254*t43
              t488 = 8.172647331405554d-1*t141*t147*t150*t256*t320*t58
              t489 = -2.7242157771351844d-1*t141*t144*t147*t487*t58
              t490 = 6.356503479982097d-1*t144*t147*t257*t258*t320*t58
              t491 = 6.356503479982097d-1*t144*t147*t256*t257*t258*t58
              t492 = 9.649190532874448d+1*t135*t150*t487-3.2163968442914
     1           83d+1*t144*t486-3.859676213149779d+2*t135*t256*t268*t32
     2           0+9.649190532874448d+1*t150*t252*t320+9.649190532874448
     3           d+1*t150*t256*t319
              t493 = -1.3621078885675922d-1*t141*t143*t145*t262*t492*t58
              t494 = 2.7242157771351844d-1*t141*t144*t145*t256*t262*t322
     1           *t58
              t495 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t322
     1           *t58
              t496 = 2.7242157771351844d-1*t141*t144*t145*t262*t263*t320
     1           *t58
              t497 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t263
     1           *t58
              t498 = 2.7242157771351844d-1*t141*t143*t263*t322*t456*t457
     1           *t58
              t499 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t32
     1           2*t58
              t500 = 3.4632974135163863d-1*t153*t257*t268*t320*t359*t462
              t501 = 1.7316487067581932d-1*t145*t150*t257*t269*t322*t359
     1           *t462
              t502 = t158*(1.5625d-2*t482*t56*t62-6.25d-2*t179*t47*t481*
     1           t62+3.125d-1*t178*t281*t396*t47*t62-6.25d-2*t178*t179*t
     2           282*t62-6.25d-2*t179*t182*t281*t62+t485+t484+t473+t472+
     3           t471)+1.5625d-2*t166*t41*t57*t62+1.5625d-2*rhob*t166*t3
     4           15*t57*t62+1.5625d-2*rhoa*t166*t216*t57*t62+1.5625d-2*t
     5           102*t166*t57*t62-1.5625d-2*rhoa*t41*t42*t483*t62-1.5625
     6           d-2*rhob*t102*t42*t483*t62-1.5625d-2*t283*t41*t42*t62-1
     7           .5625d-2*rhob*t183*t315*t42*t62-1.5625d-2*rhoa*t216*t28
     8           3*t42*t62-1.5625d-2*t102*t183*t42*t62+1.5625d-2*rhoa*t1
     9           66*t283*t41*t62+1.5625d-2*rhoa*t166*t183*t41*t62+1.5625
     :           d-2*rhob*t102*t166*t283*t62+1.5625d-2*rhob*t102*t166*t1
     ;           83*t62+t159*(3.109069086965489d-2*t139*t253*(-1.3621078
     <           885675922d-1*t141*t143*t149*t266*(t501+t500+t499+t498+t
     =           497+t496+t495+t494+t493-3.710675800196128d-2*t145*t150*
     >           t152*t269*t492+t491+t490+t489+t488-7.421351600392256d-2
     ?           *t152*t153*t268*t487+1.1132027400588385d-1*t150*t152*t2
     @           63*t322*t456*t468+t467+3.710675800196128d-1*t152*t153*t
     1           256*t320*t466+t465+t464+t461+t451+t450+1.48427032007845
     2           13d-1*t145*t152*t256*t268*t269*t322-3.710675800196128d-
     3           2*t145*t150*t152*t263*t269*t322+1.4842703200784513d-1*t
     4           145*t152*t263*t268*t269*t320)*t58+1.3621078885675922d-1
     5           *t141*t143*t155*(t499+t498+t497+t496+t495+t494+t493+t49
     6           1+t490+t489+t488+t451+t450)*t58-2.7242157771351844d-1*t
     7           141*t144*t149*t155*t487*t58+2.7242157771351844d-1*t141*
     8           t143*t149*t270*t325*t469*t58-1.3621078885675922d-1*t141
     9           *t143*t265*t266*t325*t58+3.1782517399910487d-1*t143*t14
     :           9*t257*t258*t266*t325*t58+2.7242157771351844d-1*t141*t1
     ;           44*t149*t256*t266*t325*t58-1.3621078885675922d-1*t141*t
     <           143*t266*t270*t324*t58-3.1782517399910487d-1*t143*t155*
     =           t257*t258*t324*t58-2.7242157771351844d-1*t141*t144*t155
     >           *t256*t324*t58+2.7242157771351844d-1*t141*t144*t149*t26
     ?           6*t270*t320*t58-2.7242157771351844d-1*t141*t144*t155*t2
     @           65*t320*t58+6.356503479982097d-1*t144*t149*t155*t257*t2
     1           58*t320*t58+8.172647331405554d-1*t141*t149*t150*t155*t2
     2           56*t320*t58+3.1782517399910487d-1*t143*t149*t257*t258*t
     3           266*t270*t58-3.1782517399910487d-1*t143*t155*t257*t258*
     4           t265*t58+6.356503479982097d-1*t144*t149*t155*t256*t257*
     5           t258*t58+t446+t444)+9.327207260896466d-2*t142*t157*t487
     6           +1.0d+0*t486-3.109069086965489d-2*t139*t271*t326*t470+9
     7           .327207260896466d-2*t142*t253*t256*t326+9.3272072608964
     8           66d-2*t142*t253*t271*t320+1.8654414521792934d-1*t138*t1
     9           57*t256*t320)+t480+t479+t478+t477+t412+t368+t367+t366+t
     :           365+t364+t363+t362+t361+t360+t219*t327+t272*t316
              t503 = t281**2
              t504 = t400+t398
              t505 = t401+t397
              t506 = t277**2
              t507 = t278**2
              t508 = 1.3060586492616802d-2*t48*(3.11111111111111d+0*t405
     1           *t507+3.11111111111111d+0*t406*t506-1.333333333333333d+
     2           0*t174*t505-1.333333333333333d+0*t173*t504)*t54-6.96564
     3           6129395628d-2*t176*t280*t54+1.3060586492616802d-2*t48*(
     4           2*gammaaa*t507+2*gammabb*t506+2*gammabb*t50*t505-2.0d+0
     5           *gammaab*t49*t505-2.0d+0*gammaab*t50*t504+2*gammaaa*t49
     6           *t504-4.0d+0*gammaab*t277*t278)*t51-6.965646129395628d-
     7           2*t176*t279*t51+2.6121172985233604d-2*t279*t280*t48+t40
     8           8
              t509 = 6.779999999999999d+1*t46*t506+6.0d+0*t45*t506+1.74d
     1           +0*t506+1.74d+0*t42*t43*t505+1.356d+1*t181*t505+2.0d+0*
     2           t180*t505
              t510 = t509*t56-4.0d+0*t179*t47*t508+2.0d+1*t396*t47*t503-
     1           8.0d+0*t179*t281*t282
              t511 = 1/rhob**2.333333333333333d+0
              t512 = 1/rhob**2.3333333333333334d+0
              t513 = 1/rhob**1.6666666666666669d+0
              t514 = 1/t64**5
              t515 = 1/t78**2
              t516 = t297**2
              t517 = -1.4107138347223802d-1*t513*t65*t77-3.5267845868059
     1           5d-2*t287*t288*t77+2.539284902500284d+0*t296**2*t64/t76
     2           **3-1.269642451250142d+0*t294*t64*(6.563527649164527d-2
     3           *t287*t514*t75+8.751370198886037d-2*t288*t513*t75+7.876
     4           233178997433d-1*t65*(6.563527649164527d-2*t287*t514*t74
     5           +8.751370198886037d-2*t288*t513*t74+4.753699179395351d-
     6           3*t512)-2.625411059665811d-1*t288*t289*t295)-4.23214150
     7           416714d-1*t289*t294*t296*t65
              t518 = 1/t85**2
              t519 = t302**2
              t520 = -1.4107138347223802d-1*t513*t65*t84-3.5267845868059
     1           5d-2*t287*t288*t84+2.539284902500284d+0*t301**2*t64/t83
     2           **3-1.269642451250142d+0*t299*t64*(6.563527649164527d-2
     3           *t287*t514*t82+8.751370198886037d-2*t288*t513*t82+7.876
     4           233178997433d-1*t65*(6.563527649164527d-2*t287*t514*t81
     5           +8.751370198886037d-2*t288*t513*t81+2.601716490612924d-
     6           3*t512)-2.625411059665811d-1*t288*t289*t300)-4.23214150
     7           416714d-1*t289*t299*t301*t65
              t521 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t298*t520
     1           *t87+3.37738d-2*t518*t519*t87-1.0359398963604977d-3*t51
     2           1*t86+1.709920934161365d+0*(6.21814d-2*t293*t517*t80-6.
     3           21814d-2*t515*t516*t80+3.663697685584584d-3*t511*t79+3.
     4           10907d-2*t292**2*t73/t70**2-3.10907d-2*t285*(-1.4107138
     5           347223802d-1*t513*t65*t69-3.52678458680595d-2*t287*t288
     6           *t69+2.539284902500284d+0*t291**2*t64/t68**3-1.26964245
     7           1250142d+0*t286*t64*(6.563527649164527d-2*t287*t514*t67
     8           +8.751370198886037d-2*t288*t513*t67+7.876233178997433d-
     9           1*t65*(6.563527649164527d-2*t287*t514*t66+8.75137019888
     :           6037d-2*t288*t513*t66+3.0144339229749983d-3*t512)-2.625
     ;           411059665811d-1*t288*t289*t290)-4.23214150416714d-1*t28
     <           6*t289*t291*t65)*t73-1.7613865241785687d-3*t511*t71-5.4
     =           95546528376876d-3*t284*t293*t297+2.642079786267853d-3*t
     >           284*t285*t292)+1.5539098445407465d-3*t284*t298*t302)+3.
     ?           37738d-2*t298*t520*t87-3.37738d-2*t518*t519*t87+1.03593
     @           98963604977d-3*t511*t86-1.5539098445407465d-3*t284*t298
     1           *t302)-6.21814d-2*t293*t517*t80+6.21814d-2*t515*t516*t8
     2           0-3.663697685584584d-3*t511*t79+5.495546528376876d-3*t2
     3           84*t293*t297
              t522 = rhob**3.333333333333335d-1
              t523 = 1/rhob**8.333333333333333d-1
              t524 = t303**2
              t525 = exp(-1.2865587377165935d+2*t88)
              t526 = 1.7894823267913484d+3*gammabb*t524*t525*t90/t92**3
              t527 = 1.765806054418543d+0*gammabb*t350*t522*t93
              t528 = -8.408600259135923d-2*gammabb*t306*t523*t93
              t529 = -6.490894881214397d+1*gammabb*t303*t305*t306*t308*t
     1           91
              t530 = -8.947411633956742d+2*gammabb*t308*t524*t90*t91
              t531 = 1.3909060459745137d+1*gammabb*t308*t521*t90*t91
              t532 = gammabb**2
              t533 = 1/t89**6.0d+0
              t534 = 1/t89**5.0d+0
              t535 = 1/t99**3
              t536 = 1/t101**2
              t537 = 5.848223622634648d-1*t134*(8.549604670806825d-1*t43
     1           6*t507+8.549604670806825d-1*t437*t506+2.564881401242048
     2           d+0*t250*t505+2.564881401242048d+0*t249*t504)+5.8482236
     3           22634648d-1*t116*(t435+t433+t432+t431+t430+t429+t428+t4
     4           26+32*t133*t245*t247-8*t125*t243*t247)+t423+t421+t420+t
     5           415+1.1696447245269297d+0*t317*t318
              t538 = t320**2
              t539 = -1.111111111111111d-1*t440*t507-1.111111111111111d-
     1           1*t441*t506+3.333333333333333d-1*t255*t505+3.3333333333
     2           33333d-1*t254*t504
              t540 = 8.172647331405554d-1*t141*t147*t150*t538*t58
              t541 = -2.7242157771351844d-1*t141*t144*t147*t539*t58
              t542 = 1.2713006959964196d+0*t144*t147*t257*t258*t320*t58
              t543 = 9.649190532874448d+1*t135*t150*t539-3.8596762131497
     1           79d+2*t135*t268*t538-3.216396844291483d+1*t144*t537+1.9
     2           298381065748896d+2*t150*t319*t320
              t544 = -1.3621078885675922d-1*t141*t143*t145*t262*t543*t58
              t545 = 5.448431554270369d-1*t141*t144*t145*t262*t320*t322*
     1           t58
              t546 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t322*
     1           t58
              t547 = t322**2
              t548 = 2.7242157771351844d-1*t141*t143*t456*t457*t547*t58
              t549 = -1.3621078885675922d-1*t141*t143*t145*t262*t547*t58
              t550 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2*
     1           t304*(-2.1622114952063792d-1*gammabb*t311*t90*t95*(-3.6
     2           362344277798064d-2*t523*t532*t534*t98+1.272682049722931
     3           6d+0*t522*t532*t533*t98+1.1607717772370736d+3*t524*t525
     4           *t97/t92**4.0d+0-3.869239257456912d+2*t312*t524*t91*t97
     5           +6.014866082716293d+0*t312*t521*t91*t97-2.8069375052676
     6           03d+1*gammabb*t303*t305*t306*t312*t91*t96-2.80693750526
     7           7603d+1*t303*t305*t312*t532*t534*t91+t531+t530+t529+t52
     8           8+t527+t526)+4.3244229904127585d-1*gammabb*t313**2*t535
     9           *t90*t95-8.408600259135923d-2*gammabb*t100*t306*t523*t9
     :           5+1.765806054418543d+0*gammabb*t100*t350*t522*t95+1.009
     ;           0320310963104d+0*gammabb*t305*t306*t311*t313*t95+2.1622
     <           114952063792d-1*gammabb*t100*(t531+t530+t529+t528+t527+
     =           t526)*t90-4.3244229904127585d-1*gammabb*t310*t311*t313*
     >           t90-1.0090320310963104d+0*gammabb*t100*t305*t306*t310)-
     ?           1.5545345434827443d-2*t314**2*t536+1.0d+0*t521)+t158*(1
     @           .5625d-2*t509*t56*t62-6.25d-2*t179*t47*t508*t62+3.125d-
     1           1*t396*t47*t503*t62-1.25d-1*t179*t281*t282*t62-3.125d-2
     2           *t166*t282*t56*t58*t60*t61+1.25d-1*t166*t179*t281*t47*t
     3           58*t60*t61+t485+t484+t471)-3.125d-2*t315*t42*t57*t62+3.
     4           125d-2*rhob*t166*t315*t57*t62+3.125d-2*t102*t166*t57*t6
     5           2-1.5625d-2*rhoa*t41*t42*t510*t62-1.5625d-2*rhob*t102*t
     6           42*t510*t62-3.125d-2*rhob*t283*t315*t42*t62-3.125d-2*t1
     7           02*t283*t42*t62+3.125d-2*rhoa*t166*t283*t41*t62+3.125d-
     8           2*rhob*t102*t166*t283*t62+3.125d-2*rhob*t163*t315*t57*t
     9           58*t60*t61+3.125d-2*t102*t163*t57*t58*t60*t61+3.125d-2*
     :           rhoa*t163*t283*t41*t58*t60*t61+3.125d-2*rhob*t102*t163*
     ;           t283*t58*t60*t61+t159*(3.109069086965489d-2*t139*t253*(
     <           -1.3621078885675922d-1*t141*t143*t149*t266*t58*(1.73164
     =           87067581932d-1*t145*t150*t151*t257*t258*t269*t322*t58+3
     >           .4632974135163863d-1*t151*t153*t257*t258*t268*t320*t58+
     ?           t549+t548+1.1132027400588385d-1*t150*t152*t456*t468*t54
     @           7-3.710675800196128d-2*t145*t150*t152*t269*t547+t546+t5
     1           45+t544-3.710675800196128d-2*t145*t150*t152*t269*t543+t
     2           542+t541+t540-7.421351600392256d-2*t152*t153*t268*t539+
     3           3.710675800196128d-1*t152*t153*t466*t538+t501+t500+t465
     4           +t464+t451+t450+2.9685406401569026d-1*t145*t152*t268*t2
     5           69*t320*t322)+1.3621078885675922d-1*t141*t143*t155*(t54
     6           9+t548+t546+t545+t544+t542+t541+t540+t451+t450)*t58-2.7
     7           242157771351844d-1*t141*t144*t149*t155*t539*t58+8.17264
     8           7331405554d-1*t141*t149*t150*t155*t538*t58+2.7242157771
     9           351844d-1*t141*t143*t149*t325**2*t469*t58-2.72421577713
     :           51844d-1*t141*t143*t266*t324*t325*t58+5.448431554270369
     ;           d-1*t141*t144*t149*t266*t320*t325*t58+6.356503479982097
     <           d-1*t143*t149*t257*t258*t266*t325*t58-5.448431554270369
     =           d-1*t141*t144*t155*t320*t324*t58-6.356503479982097d-1*t
     >           143*t155*t257*t258*t324*t58+1.2713006959964196d+0*t144*
     ?           t149*t155*t257*t258*t320*t58+t446+t444)+9.3272072608964
     @           66d-2*t142*t157*t539+1.8654414521792934d-1*t138*t157*t5
     1           38+1.0d+0*t537-3.109069086965489d-2*t139*t326**2*t470+1
     2           .8654414521792934d-1*t142*t253*t320*t326)+t480+t479+t47
     3           8+t477+t412+t368+t367+t363+t361+t360+2*t316*t327
              t551 = -1.6406249999999997d-2*t166*t341*t58*t60*t62
              t552 = 1/t1**6.666666666666667d+0
              t553 = -1.6325733115771002d-3*rhoa*t179*t355*t359*t41*t47*
     1           t51*t52*t552
              t554 = 4.8579204483835753d-4*rhoa*t125*t205*t334*t355*t359
     1           *t57
              t555 = 6.25d-2*rhoa*t125*t355*t41*t57*t58
              t556 = -1.6325733115771002d-3*rhob*t102*t179*t355*t359*t47
     1           *t51*t52*t552
              t557 = 6.25d-2*rhob*t102*t125*t355*t57*t58
              t558 = -3.125d-2*rhoa*t166*t183*t41*t60*t61
              t559 = 3.125d-2*rhoa*t163*t41*t57*t60*t61
              t560 = -3.125d-2*rhoa*t166*t216*t57*t60*t61
              t561 = -3.125d-2*t166*t41*t57*t60*t61
              t562 = -3.125d-2*rhob*t102*t166*t183*t60*t61
              t563 = 3.125d-2*rhob*t102*t163*t57*t60*t61
              t564 = -8.162866557885502d-4*rhoa*t179*t407*t41*t47*t51*t5
     1           2*t62
              t565 = -3.482823064697814d-2*t176*t51*t52
              t566 = t565+1.3060586492616802d-2*t175*t48*t52+2.612117298
     1           5233604d-2*t169*t48*t49*t51
              t567 = -4.0d+0*t179*t47*t566+2.6121172985233604d-1*t178*t3
     1           96*t47*t48*t51*t52-5.224234597046721d-2*t179*t182*t48*t
     2           51*t52
              t568 = 2.4289602241917876d-4*rhoa*t166*t205*t334*t57*t62
              t569 = -5.045160155481552d-1*t206*t207*t32
              t570 = 1.3909060459745137d+1*t204*t209*t29*t30
              t571 = -8.162866557885502d-4*rhob*t102*t179*t407*t47*t51*t
     1           52*t62
              t572 = 1/t1**5.666666666666667d+0
              t573 = 1.6325733115771002d-3*t179*t355*t359*t47*t51*t52*t5
     1           72
              t574 = -6.25d-2*t163*t355*t47*t56*t58
              t575 = -1.25d-1*t178*t179*t42*t47*t60*t61
              t576 = 3.125d-2*t182*t42*t56*t60*t61
              t577 = 3.109069086965489d-2*t139*t219*t253*t339
              t578 = 3.1782517399910487d-1*t143*t149*t257*t258*t266*t337
     1           *t58
              t579 = -3.1782517399910487d-1*t143*t149*t155*t257*t258
              t580 = -4.3291217668954834d-2*t147*t150*t155*t257*t462*t58
              t581 = -2.7242157771351844d-1*t141*t144*t147*t256
              t582 = -3.1782517399910487d-1*t143*t147*t257*t258
              t583 = -1.3621078885675922d-1*t141*t143*t145*t262*t263
              t584 = -1.7316487067581932d-1*t150*t153*t257*t462*t58
              t585 = t159*(3.109069086965489d-2*t139*t253*(-1.3621078885
     1           675922d-1*t141*t143*t149*t266*t58*(t584+t583+t582+t581-
     2           7.421351600392256d-2*t141*t145*t150*t151*t263*t269-1.48
     3           42703200784513d-1*t141*t151*t153*t256*t268)+1.362107888
     4           5675922d-1*t141*t143*t155*t58*(t583+t582+t581)+t580+2.7
     5           242157771351844d-1*t141*t143*t149*t270*t337*t469*t58-1.
     6           855337900098064d-2*t147*t150*t266*t270*t338*t58-3.71067
     7           5800196128d-2*t147*t155*t256*t268*t338*t58-1.3621078885
     8           675922d-1*t141*t143*t265*t266*t337*t58+2.72421577713518
     9           44d-1*t141*t144*t149*t256*t266*t337*t58+t579+t578-1.362
     :           1078885675922d-1*t141*t143*t149*t266*t270+1.36210788856
     ;           75922d-1*t141*t143*t155*t265-2.7242157771351844d-1*t141
     <           *t144*t149*t155*t256)-3.109069086965489d-2*t139*t271*t3
     =           39*t470+9.327207260896466d-2*t142*t253*t256*t339)
              t586 = t158*(-6.25d-2*t179*t47*t566*t62+4.0814332789427504
     1           d-3*t178*t396*t47*t48*t51*t52*t62-8.162866557885502d-4*
     2           t179*t182*t48*t51*t52*t62+t576+t575+t574+t573)-1.5625d-
     3           2*rhoa*t42*t57*(1.5545345434827443d-2*t205*(-2.16221149
     4           52063792d-1*gammaaa*t212*t29*t34*(t570+t569-4.363481313
     5           335766d-1*gammaaa*t206*t37*t392+1.2029732165432584d+1*t
     6           204*t213*t29*t30*t35)+2.1622114952063792d-1*gammaaa*t29
     7           *t39*(t570+t569)+4.3244229904127585d-1*gammaaa*t214*t29
     8           *t332*t34*t393-1.0908703283339415d-1*gammaaa*t206*t32*t
     9           39*t392-5.045160155481552d-1*t206*t207*t34*t39+2.162211
     :           4952063792d-1*t211*t29*t39+5.045160155481552d-1*gammaaa
     ;           *t206*t207*t212*t332*t34-2.1622114952063792d-1*t212*t21
     <           4*t29*t34-4.675158550002606d-2*gammaaa*t212*t214*t32*t3
     =           33-2.1622114952063792d-1*gammaaa*t211*t212*t29*t332)-1.
     >           5545345434827443d-2*t215*t334*t394)*t62-2.4289602241917
     ?           876d-4*t205*t334*t42*t57*t62-1.5625d-2*rhoa*t41*t42*t56
     @           7*t62-1.5625d-2*rhob*t102*t42*t567*t62+8.16286655788550
     1           2d-4*t176*t179*t41*t47*t51*t52*t62+8.162866557885502d-4
     2           *rhoa*t176*t179*t216*t47*t51*t52*t62-2.4289602241917876
     3           d-4*rhoa*t183*t205*t334*t42*t62+t585+t577+t571+t568+t56
     4           4+t563+t562+t561+t560+t559+t558+t557+t556+t555+t554+t55
     5           3+t272*t336
              t587 = 1.6406249999999997d-2*t273*t42*t60*t62
              t588 = -3.2812499999999994d-2*t160*t163*t355*t58*t61
              t589 = -1.6406249999999997d-2*t160*t166*t60*t62
              t590 = 1.0d+0*t160*t343*wght
              t591 = 1.0d+0*t162*t341*wght
              t592 = -1.6406249999999997d-2*t166*t347*t58*t60*t62
              t593 = 3.2651466231542003d-3*rhoa*t179*t355*t359*t41*t47*t
     1           49*t50*t51*t552
              t594 = 1.25d-1*rhoa*t125*t355*t41*t57*t58
              t595 = 3.2651466231542003d-3*rhob*t102*t179*t355*t359*t47*
     1           t49*t50*t51*t552
              t596 = 1.25d-1*rhob*t102*t125*t355*t57*t58
              t597 = 6.25d-2*rhoa*t163*t41*t57*t60*t61
              t598 = 6.25d-2*rhob*t102*t163*t57*t60*t61
              t599 = 1.6325733115771002d-3*rhoa*t179*t407*t41*t47*t49*t5
     1           0*t51*t62
              t600 = 6.965646129395628d-2*t176*t49*t50*t51
              t601 = t600+1.3060586492616802d-2*t48*(-2.0d+0*t169*t50-2.
     1           0d+0*t171*t49)*t51-2.6121172985233604d-2*t175*t48*t49*t
     2           50
              t602 = -4.0d+0*t179*t47*t601-5.224234597046721d-1*t178*t39
     1           6*t47*t48*t49*t50*t51+1.0448469194093442d-1*t179*t182*t
     2           48*t49*t50*t51
              t603 = 1.6325733115771002d-3*rhob*t102*t179*t407*t47*t49*t
     1           50*t51*t62
              t604 = -3.2651466231542003d-3*t179*t355*t359*t47*t49*t50*t
     1           51*t572
              t605 = -1.25d-1*t163*t355*t47*t56*t58
              t606 = 3.1782517399910487d-1*t143*t149*t257*t258*t266*t345
     1           *t58
              t607 = -6.356503479982097d-1*t143*t149*t155*t257*t258
              t608 = -8.658243533790967d-2*t147*t150*t155*t257*t462*t58
              t609 = -5.448431554270369d-1*t141*t144*t147*t256
              t610 = -6.356503479982097d-1*t143*t147*t257*t258
              t611 = -2.7242157771351844d-1*t141*t143*t145*t262*t263
              t612 = -3.4632974135163863d-1*t150*t153*t257*t462*t58
              t613 = t158*(-6.25d-2*t179*t47*t601*t62-8.162866557885501d
     1           -3*t178*t396*t47*t48*t49*t50*t51*t62+1.6325733115771002
     2           d-3*t179*t182*t48*t49*t50*t51*t62+6.25d-2*t182*t42*t56*
     3           t60*t61-2.5d-1*t178*t179*t42*t47*t60*t61+t605+t604)-1.5
     4           625d-2*rhoa*t41*t42*t602*t62-1.5625d-2*rhob*t102*t42*t6
     5           02*t62-1.6325733115771002d-3*t176*t179*t41*t47*t49*t50*
     6           t51*t62-1.6325733115771002d-3*rhoa*t176*t179*t216*t47*t
     7           49*t50*t51*t62+t159*(3.109069086965489d-2*t139*t253*(-1
     8           .3621078885675922d-1*t141*t143*t149*t266*t58*(t612+t611
     9           +t610+t609-1.4842703200784513d-1*t141*t145*t150*t151*t2
     :           63*t269-2.9685406401569026d-1*t141*t151*t153*t256*t268)
     ;           +1.3621078885675922d-1*t141*t143*t155*t58*(t611+t610+t6
     <           09)+t608+t607+t606+2.7242157771351844d-1*t141*t143*t149
     =           *t270*t345*t469*t58-1.3621078885675922d-1*t141*t143*t26
     >           5*t266*t345*t58+2.7242157771351844d-1*t141*t144*t149*t2
     ?           56*t266*t345*t58-3.710675800196128d-2*t147*t150*t266*t2
     @           70*t338*t58-7.421351600392256d-2*t147*t155*t256*t268*t3
     1           38*t58-2.7242157771351844d-1*t141*t143*t149*t266*t270+2
     2           .7242157771351844d-1*t141*t143*t155*t265-5.448431554270
     3           369d-1*t141*t144*t149*t155*t256)-3.109069086965489d-2*t
     4           139*t271*t346*t470+9.327207260896466d-2*t142*t253*t256*
     5           t346)-6.25d-2*t166*t41*t57*t60*t61-6.25d-2*rhoa*t166*t2
     6           16*t57*t60*t61-6.25d-2*rhoa*t166*t183*t41*t60*t61-6.25d
     7           -2*rhob*t102*t166*t183*t60*t61+t603+t599+t598+t597+t596
     8           +t595+t594+t593+3.109069086965489d-2*t139*t219*t253*t34
     9           6+t272*t344
              t614 = -6.562499999999999d-2*t160*t163*t355*t58*t61
              t615 = -3.2812499999999994d-2*t160*t166*t60*t62
              t616 = 1.0d+0*t160*t348*wght
              t617 = 1.0d+0*t162*t347*wght
              t618 = -1.6406249999999997d-2*t166*t353*t58*t60*t62
              t619 = -1.6325733115771002d-3*rhoa*t179*t355*t359*t41*t47*
     1           t51*t53*t552
              t620 = 4.8579204483835753d-4*rhob*t125*t304*t351*t355*t359
     1           *t57
              t621 = -1.6325733115771002d-3*rhob*t102*t179*t355*t359*t47
     1           *t51*t53*t552
              t622 = -8.162866557885502d-4*rhoa*t179*t407*t41*t47*t51*t5
     1           3*t62
              t623 = -3.482823064697814d-2*t176*t51*t53
              t624 = t623+1.3060586492616802d-2*t175*t48*t53+2.612117298
     1           5233604d-2*t171*t48*t50*t51
              t625 = -4.0d+0*t179*t47*t624+2.6121172985233604d-1*t178*t3
     1           96*t47*t48*t51*t53-5.224234597046721d-2*t179*t182*t48*t
     2           51*t53
              t626 = 2.4289602241917876d-4*rhob*t166*t304*t351*t57*t62
              t627 = -8.162866557885502d-4*rhob*t102*t179*t407*t47*t51*t
     1           53*t62
              t628 = 1.6325733115771002d-3*t179*t355*t359*t47*t51*t53*t5
     1           72
              t629 = t158*(t628-6.25d-2*t179*t47*t62*t624+4.081433278942
     1           7504d-3*t178*t396*t47*t48*t51*t53*t62-8.162866557885502
     2           d-4*t179*t182*t48*t51*t53*t62+t576+t575+t574)+t627+t626
     3           -1.5625d-2*rhoa*t41*t42*t62*t625-1.5625d-2*rhob*t102*t4
     4           2*t62*t625+t622+t621+t620+8.162866557885502d-4*t176*t17
     5           9*t41*t47*t51*t53*t62+8.162866557885502d-4*rhoa*t176*t1
     6           79*t216*t47*t51*t53*t62-2.4289602241917876d-4*rhob*t183
     7           *t304*t351*t42*t62+t619+t585+t577+t563+t562+t561+t560+t
     8           559+t558+t557+t555+t272*t352
              t630 = 1.0d+0*t160*t354*wght
              t631 = 1.0d+0*t162*t353*wght
              t632 = -3.125d-2*rhoa*t166*t283*t41*t60*t61
              t633 = -3.125d-2*rhob*t166*t315*t57*t60*t61
              t634 = -3.125d-2*rhob*t102*t166*t283*t60*t61
              t635 = -3.125d-2*t102*t166*t57*t60*t61
              t636 = t565+1.3060586492616802d-2*t280*t48*t52+2.612117298
     1           5233604d-2*t278*t48*t49*t51
              t637 = -4.0d+0*t179*t47*t636+2.6121172985233604d-1*t281*t3
     1           96*t47*t48*t51*t52-5.224234597046721d-2*t179*t282*t48*t
     2           51*t52
              t638 = -1.25d-1*t179*t281*t42*t47*t60*t61
              t639 = 3.125d-2*t282*t42*t56*t60*t61
              t640 = 3.109069086965489d-2*t139*t253*t316*t339
              t641 = -2.7242157771351844d-1*t141*t144*t147*t320
              t642 = -1.3621078885675922d-1*t141*t143*t145*t262*t322
              t643 = t159*(3.109069086965489d-2*t139*t253*(-1.3621078885
     1           675922d-1*t141*t143*t149*t266*t58*(t642+t641+t584+t582-
     2           7.421351600392256d-2*t141*t145*t150*t151*t269*t322-1.48
     3           42703200784513d-1*t141*t151*t153*t268*t320)+1.362107888
     4           5675922d-1*t141*t143*t155*t58*(t642+t641+t582)+t580+2.7
     5           242157771351844d-1*t141*t143*t149*t325*t337*t469*t58-1.
     6           855337900098064d-2*t147*t150*t266*t325*t338*t58-3.71067
     7           5800196128d-2*t147*t155*t268*t320*t338*t58-1.3621078885
     8           675922d-1*t141*t143*t266*t324*t337*t58+2.72421577713518
     9           44d-1*t141*t144*t149*t266*t320*t337*t58+t579+t578-1.362
     :           1078885675922d-1*t141*t143*t149*t266*t325+1.36210788856
     ;           75922d-1*t141*t143*t155*t324-2.7242157771351844d-1*t141
     <           *t144*t149*t155*t320)-3.109069086965489d-2*t139*t326*t3
     =           39*t470+9.327207260896466d-2*t142*t253*t320*t339)
              t644 = t643+t640+t158*(t639+t638-6.25d-2*t179*t47*t62*t636
     1           +4.0814332789427504d-3*t281*t396*t47*t48*t51*t52*t62-8.
     2           162866557885502d-4*t179*t282*t48*t51*t52*t62+t574+t573)
     3           -1.5625d-2*rhoa*t41*t42*t62*t637-1.5625d-2*rhob*t102*t4
     4           2*t62*t637+t635+t634+t633+t632+8.162866557885502d-4*rho
     5           b*t176*t179*t315*t47*t51*t52*t62+8.162866557885502d-4*t
     6           102*t176*t179*t47*t51*t52*t62-2.4289602241917876d-4*rho
     7           a*t205*t283*t334*t42*t62+t571+t568+t564+t563+t559+t557+
     8           t556+t555+t554+t553+t327*t336
              t645 = 1.6406249999999997d-2*t328*t42*t60*t62
              t646 = t600+1.3060586492616802d-2*t48*(-2.0d+0*t278*t50-2.
     1           0d+0*t277*t49)*t51-2.6121172985233604d-2*t280*t48*t49*t
     2           50
              t647 = -4.0d+0*t179*t47*t646-5.224234597046721d-1*t281*t39
     1           6*t47*t48*t49*t50*t51+1.0448469194093442d-1*t179*t282*t
     2           48*t49*t50*t51
              t648 = -5.448431554270369d-1*t141*t144*t147*t320
              t649 = -2.7242157771351844d-1*t141*t143*t145*t262*t322
              t650 = t159*(3.109069086965489d-2*t139*t253*(-1.3621078885
     1           675922d-1*t141*t143*t149*t266*t58*(t649+t648+t612+t610-
     2           1.4842703200784513d-1*t141*t145*t150*t151*t269*t322-2.9
     3           685406401569026d-1*t141*t151*t153*t268*t320)+1.36210788
     4           85675922d-1*t141*t143*t155*t58*(t649+t648+t610)+t608+t6
     5           07+t606+2.7242157771351844d-1*t141*t143*t149*t325*t345*
     6           t469*t58-1.3621078885675922d-1*t141*t143*t266*t324*t345
     7           *t58+2.7242157771351844d-1*t141*t144*t149*t266*t320*t34
     8           5*t58-3.710675800196128d-2*t147*t150*t266*t325*t338*t58
     9           -7.421351600392256d-2*t147*t155*t268*t320*t338*t58-2.72
     :           42157771351844d-1*t141*t143*t149*t266*t325+2.7242157771
     ;           351844d-1*t141*t143*t155*t324-5.448431554270369d-1*t141
     <           *t144*t149*t155*t320)-3.109069086965489d-2*t139*t326*t3
     =           46*t470+9.327207260896466d-2*t142*t253*t320*t346)-1.562
     >           5d-2*rhoa*t41*t42*t62*t647-1.5625d-2*rhob*t102*t42*t62*
     ?           t647+t158*(-6.25d-2*t179*t47*t62*t646-8.162866557885501
     @           d-3*t281*t396*t47*t48*t49*t50*t51*t62+1.632573311577100
     1           2d-3*t179*t282*t48*t49*t50*t51*t62+6.25d-2*t282*t42*t56
     2           *t60*t61-2.5d-1*t179*t281*t42*t47*t60*t61+t605+t604)-1.
     3           6325733115771002d-3*rhob*t176*t179*t315*t47*t49*t50*t51
     4           *t62-1.6325733115771002d-3*t102*t176*t179*t47*t49*t50*t
     5           51*t62-6.25d-2*rhob*t166*t315*t57*t60*t61-6.25d-2*t102*
     6           t166*t57*t60*t61-6.25d-2*rhoa*t166*t283*t41*t60*t61-6.2
     7           5d-2*rhob*t102*t166*t283*t60*t61+t603+t599+t598+t597+t5
     8           96+t595+t594+t593+3.109069086965489d-2*t139*t253*t316*t
     9           346+t327*t344
              t651 = t623+1.3060586492616802d-2*t280*t48*t53+2.612117298
     1           5233604d-2*t277*t48*t50*t51
              t652 = -4.0d+0*t179*t47*t651+2.6121172985233604d-1*t281*t3
     1           96*t47*t48*t51*t53-5.224234597046721d-2*t179*t282*t48*t
     2           51*t53
              t653 = -5.045160155481552d-1*t305*t306*t93
              t654 = 1.3909060459745137d+1*t303*t308*t90*t91
              t655 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2*
     1           t304*(-2.1622114952063792d-1*gammabb*t311*t90*t95*(-4.3
     2           63481313335766d-1*gammabb*t305*t534*t98+1.2029732165432
     3           584d+1*t303*t312*t90*t91*t96+t654+t653)+4.3244229904127
     4           585d-1*gammabb*t313*t349*t535*t90*t95-2.162211495206379
     5           2d-1*t311*t313*t90*t95+5.045160155481552d-1*gammabb*t30
     6           5*t306*t311*t349*t95-5.045160155481552d-1*t100*t305*t30
     7           6*t95-1.0908703283339415d-1*gammabb*t100*t305*t534*t93-
     8           4.675158550002606d-2*gammabb*t311*t313*t350*t93+2.16221
     9           14952063792d-1*gammabb*t100*(t654+t653)*t90-2.162211495
     :           2063792d-1*gammabb*t310*t311*t349*t90+2.162211495206379
     ;           2d-1*t100*t310*t90)-1.5545345434827443d-2*t314*t351*t53
     <           6)-1.5625d-2*rhoa*t41*t42*t62*t652-1.5625d-2*rhob*t102*
     =           t42*t62*t652+t158*(-6.25d-2*t179*t47*t62*t651+t639+t638
     >           +t628+4.0814332789427504d-3*t281*t396*t47*t48*t51*t53*t
     ?           62-8.162866557885502d-4*t179*t282*t48*t51*t53*t62+t574)
     @           +t643+t640+t635+t634+t633+t632+t627+t626+t622+t621+t620
     1           -2.4289602241917876d-4*t304*t351*t42*t57*t62+8.16286655
     2           7885502d-4*rhob*t176*t179*t315*t47*t51*t53*t62+8.162866
     3           557885502d-4*t102*t176*t179*t47*t51*t53*t62-2.428960224
     4           1917876d-4*rhob*t283*t304*t351*t42*t62+t619+t563+t559+t
     5           557+t555+t327*t352
              t656 = -3.125d-2*rhoa*t163*t355*t41*t57
              t657 = -3.125d-2*rhob*t102*t163*t355*t57
              t658 = 1.6325733115771002d-3*rhoa*t179*t407*t41*t47*t51*t5
     1           2*t60*t61
              t659 = -4.8579204483835753d-4*rhoa*t166*t205*t334*t57*t60*
     1           t61
              t660 = 1.6325733115771002d-3*rhob*t102*t179*t407*t47*t51*t
     1           52*t60*t61
              t661 = 1/t1**6.333333333333333d+0
              t662 = t49**4
              t663 = t51**2
              t664 = 3.125d-2*t166*t355*t47*t56
              t665 = -1.6325733115771002d-3*t176*t179*t47*t51*t52*t60*t6
     1           1
              t666 = 1/t1**5.333333333333333d+0
              t667 = -3.109069086965489d-2*t139*t159*t339**2*t470
              t668 = -2.7242157771351844d-1*t141*t143*t149*t266*t337
              t669 = -3.710675800196128d-2*t147*t150*t266*t337*t338*t58
              t670 = 3.109069086965489d-2*t139*t159*t253*(t669+t668+2.72
     1           42157771351844d-1*t141*t143*t149*t337**2*t469*t58-5.054
     2           340779364009d-3*t149*t153*t266*t463*t466*t58+3.71067580
     3           0196128d-2*t147*t150*t155*t338)
              t671 = t670+t667+t158*(5.330591235347639d-5*t396*t47*t62*t
     1           662*t663*t666+t665+t664-1.6325733115771002d-3*t179*t355
     2           *t407*t47*t51*t52*t58)-5.330591235347639d-5*rhoa*t396*t
     3           41*t47*t62*t661*t662*t663-5.330591235347639d-5*rhob*t10
     4           2*t396*t47*t62*t661*t662*t663+t660+t659+t658+t657+t656+
     5           2.4289602241917876d-4*rhoa*t334**2*t394*t42*t57*t62-2.4
     6           289602241917876d-4*rhoa*t205*(4.3244229904127585d-1*gam
     7           maaa*t29*t332**2*t34*t393-2.0217363117456047d-2*gammaaa
     8           *t212*t34*t37*t391+9.350317100005212d-2*t32*t333*t39-4.
     9           3244229904127585d-1*t212*t29*t332*t34-9.350317100005212
     :           d-2*gammaaa*t212*t32*t332*t333)*t42*t57*t62+2.537891607
     ;           6146196d-5*rhoa*t176*t179*t205*t334*t47*t51*t52*t62+1.6
     <           325733115771002d-3*rhoa*t179*t355*t41*t47*t51*t52*t572*
     =           t58+1.6325733115771002d-3*rhob*t102*t179*t355*t47*t51*t
     >           52*t572*t58-4.8579204483835753d-4*rhoa*t163*t205*t334*t
     ?           355*t57*t58+6.218138173930978d-2*t139*t253*t336*t339
              t672 = 3.2812499999999994d-2*t341*t42*t60*t62
              t673 = 3.2812499999999994d-2*t160*t166*t355*t61
              t674 = 1.6406249999999997d-2*t347*t42*t60*t62
              t675 = -6.25d-2*rhoa*t163*t355*t41*t57
              t676 = -6.25d-2*rhob*t102*t163*t355*t57
              t677 = t49**3
              t678 = 6.25d-2*t166*t355*t47*t56
              t679 = 3.109069086965489d-2*t139*t253*t339*t344
              t680 = 3.109069086965489d-2*t139*t159*t253*(t669+t668+2.72
     1           42157771351844d-1*t141*t143*t149*t337*t345*t469*t58-1.0
     2           108681558728018d-2*t149*t153*t266*t463*t466*t58-1.85533
     3           7900098064d-2*t147*t150*t266*t338*t345*t58-1.3621078885
     4           675922d-1*t141*t143*t149*t266*t345+7.421351600392256d-2
     5           *t147*t150*t155*t338)
              t681 = -3.109069086965489d-2*t139*t159*t339*t346*t470
              t682 = t681+t680+t679+t158*(t678-1.066118247069528d-4*t396
     1           *t47*t50*t62*t663*t666*t677-3.2651466231542003d-3*t176*
     2           t179*t47*t51*t52*t60*t61+3.2651466231542003d-3*t179*t35
     3           5*t407*t47*t49*t50*t51*t58)+1.066118247069528d-4*rhoa*t
     4           396*t41*t47*t50*t62*t661*t663*t677+1.066118247069528d-4
     5           *rhob*t102*t396*t47*t50*t62*t661*t663*t677+t676+t675-2.
     6           5378916076146196d-5*rhoa*t176*t179*t205*t334*t47*t49*t5
     7           0*t51*t62-9.715840896767151d-4*rhoa*t166*t205*t334*t57*
     8           t60*t61+3.2651466231542003d-3*rhoa*t179*t407*t41*t47*t5
     9           1*t52*t60*t61+3.2651466231542003d-3*rhob*t102*t179*t407
     :           *t47*t51*t52*t60*t61-3.2651466231542003d-3*rhoa*t179*t3
     ;           55*t41*t47*t49*t50*t51*t572*t58-3.2651466231542003d-3*r
     <           hob*t102*t179*t355*t47*t49*t50*t51*t572*t58+3.109069086
     =           965489d-2*t139*t253*t336*t346
              t683 = 6.562499999999999d-2*t160*t166*t355*t61
              t684 = 1.6325733115771002d-3*rhoa*t179*t355*t41*t47*t51*t5
     1           3*t572*t58
              t685 = -4.8579204483835753d-4*rhob*t163*t304*t351*t355*t57
     1           *t58
              t686 = 1.6325733115771002d-3*rhob*t102*t179*t355*t47*t51*t
     1           53*t572*t58
              t687 = -1.6325733115771002d-3*t179*t355*t407*t47*t51*t53*t
     1           58
              t688 = t158*(t687+5.330591235347639d-5*t396*t47*t52*t53*t6
     1           2*t663*t666+t665+t664)+t686+t685+t684+t670+t667-5.33059
     2           1235347639d-5*rhoa*t396*t41*t47*t52*t53*t62*t661*t663-5
     3           .330591235347639d-5*rhob*t102*t396*t47*t52*t53*t62*t661
     4           *t663+t660+t659+t658+t657+t656+1.2689458038073098d-5*rh
     5           oa*t176*t179*t205*t334*t47*t51*t53*t62+1.26894580380730
     6           98d-5*rhob*t176*t179*t304*t351*t47*t51*t52*t62+3.109069
     7           086965489d-2*t139*t253*t339*t352+3.109069086965489d-2*t
     8           139*t253*t336*t339
              t689 = t158*(2.132236494139056d-4*t396*t47*t52*t53*t62*t66
     1           3*t666+6.530293246308401d-3*t176*t179*t47*t49*t50*t51*t
     2           60*t61+6.530293246308401d-3*t179*t355*t407*t47*t49*t50*
     3           t51*t58+1.25d-1*t166*t355*t47*t56)-2.132236494139056d-4
     4           *rhoa*t396*t41*t47*t52*t53*t62*t661*t663-2.132236494139
     5           056d-4*rhob*t102*t396*t47*t52*t53*t62*t661*t663-6.53029
     6           3246308401d-3*rhoa*t179*t407*t41*t47*t49*t50*t51*t60*t6
     7           1-6.530293246308401d-3*rhob*t102*t179*t407*t47*t49*t50*
     8           t51*t60*t61+3.109069086965489d-2*t139*t159*t253*(2.7242
     9           157771351844d-1*t141*t143*t149*t345**2*t469*t58-2.02173
     :           63117456036d-2*t149*t153*t266*t463*t466*t58-7.421351600
     ;           392256d-2*t147*t150*t266*t338*t345*t58-5.44843155427036
     <           9d-1*t141*t143*t149*t266*t345+1.4842703200784513d-1*t14
     =           7*t150*t155*t338)-6.530293246308401d-3*rhoa*t179*t355*t
     >           41*t47*t49*t50*t51*t572*t58-6.530293246308401d-3*rhob*t
     ?           102*t179*t355*t47*t49*t50*t51*t572*t58-1.25d-1*rhoa*t16
     @           3*t355*t41*t57-1.25d-1*rhob*t102*t163*t355*t57-3.109069
     1           086965489d-2*t139*t159*t346**2*t470+6.218138173930978d-
     2           2*t139*t253*t344*t346
              t690 = 3.2812499999999994d-2*t353*t42*t60*t62
              t691 = t50**3
              t692 = t158*(-1.066118247069528d-4*t396*t47*t49*t62*t663*t
     1           666*t691+t678+3.2651466231542003d-3*t176*t179*t47*t49*t
     2           50*t51*t60*t61-3.2651466231542003d-3*t179*t355*t407*t47
     3           *t51*t53*t58)+1.066118247069528d-4*rhoa*t396*t41*t47*t4
     4           9*t62*t661*t663*t691+1.066118247069528d-4*rhob*t102*t39
     5           6*t47*t49*t62*t661*t663*t691+t681+t680+t679+t676+t675-2
     6           .5378916076146196d-5*rhob*t176*t179*t304*t351*t47*t49*t
     7           50*t51*t62-3.2651466231542003d-3*rhoa*t179*t407*t41*t47
     8           *t49*t50*t51*t60*t61-3.2651466231542003d-3*rhob*t102*t1
     9           79*t407*t47*t49*t50*t51*t60*t61+3.2651466231542003d-3*r
     :           hoa*t179*t355*t41*t47*t51*t53*t572*t58+3.26514662315420
     ;           03d-3*rhob*t102*t179*t355*t47*t51*t53*t572*t58-9.715840
     <           896767151d-4*rhob*t163*t304*t351*t355*t57*t58+3.1090690
     =           86965489d-2*t139*t253*t346*t352
              t693 = t50**4
              t694 = -2.4289602241917876d-4*rhob*t304*t42*t57*t62*(-2.02
     1           17363117456047d-2*gammabb*t311*t533*t95*t98+4.324422990
     2           4127585d-1*gammabb*t349**2*t535*t90*t95-4.3244229904127
     3           585d-1*t311*t349*t90*t95-9.350317100005212d-2*gammabb*t
     4           311*t349*t350*t93+9.350317100005212d-2*t100*t350*t93)+t
     5           158*(5.330591235347639d-5*t396*t47*t62*t663*t666*t693+t
     6           687+t664-1.6325733115771002d-3*t176*t179*t47*t51*t53*t6
     7           0*t61)-5.330591235347639d-5*rhoa*t396*t41*t47*t62*t661*
     8           t663*t693-5.330591235347639d-5*rhob*t102*t396*t47*t62*t
     9           661*t663*t693+t686+t685+t684+t670+t667+t657+t656+2.4289
     :           602241917876d-4*rhob*t351**2*t42*t536*t57*t62+2.5378916
     ;           076146196d-5*rhob*t176*t179*t304*t351*t47*t51*t53*t62-4
     <           .8579204483835753d-4*rhob*t166*t304*t351*t57*t60*t61+1.
     =           6325733115771002d-3*rhoa*t179*t407*t41*t47*t51*t53*t60*
     >           t61+1.6325733115771002d-3*rhob*t102*t179*t407*t47*t51*t
     ?           53*t60*t61+6.218138173930978d-2*t139*t253*t339*t352
              t695 = -1.6406249999999997d-2*t166*t356*t58*t60*t62
              t696 = 1/t59**3
              t697 = -6.25d-2*rhoa*t125*t359*t41*t57*t696
              t698 = -6.25d-2*rhob*t102*t125*t359*t57*t696
              t699 = -3.125d-2*rhoa*t163*t355*t41*t57*t58*t61
              t700 = -3.125d-2*rhob*t102*t163*t355*t57*t58*t61
              t701 = 6.25d-2*t163*t359*t47*t56*t696
              t702 = t158*(t701-3.125d-2*t182*t355*t42*t56*t58*t61+1.25d
     1           -1*t178*t179*t355*t42*t47*t58*t61)+t700+t699+t698+t697+
     2           3.125d-2*t166*t355*t41*t57*t58*t61+3.125d-2*rhoa*t166*t
     3           216*t355*t57*t58*t61-3.125d-2*t272*t355*t42*t47*t56*t58
     4           *t61+3.125d-2*rhoa*t166*t183*t355*t41*t58*t61+3.125d-2*
     5           rhob*t102*t166*t183*t355*t58*t61
              t703 = 3.2812499999999994d-2*t160*t163*t359*t61*t696
              t704 = 1.6406249999999997d-2*t160*t166*t355*t58*t62
              t705 = 1.0d+0*t160*t357*wght
              t706 = 1.0d+0*t162*t356*wght
              t707 = 1.0d+0*t1*t160*(t704+t703+5.46875d-3*t161*t702+t695
     1           -1.6406249999999997d-2*t273*t355*t42*t58*t62)*wght+1.0d
     2           +0*t1*t162*t702*wght+1.0d+0*t1*t273*t357*wght+1.0d+0*t1
     3           *t275*t356*wght+t706+t705
              t708 = t158*(t701-3.125d-2*t282*t355*t42*t56*t58*t61+1.25d
     1           -1*t179*t281*t355*t42*t47*t58*t61)+t700+t699+t698+t697+
     2           3.125d-2*rhob*t166*t315*t355*t57*t58*t61+3.125d-2*t102*
     3           t166*t355*t57*t58*t61-3.125d-2*t327*t355*t42*t47*t56*t5
     4           8*t61+3.125d-2*rhoa*t166*t283*t355*t41*t58*t61+3.125d-2
     5           *rhob*t102*t166*t283*t355*t58*t61
              t709 = 1.0d+0*t1*t160*(5.46875d-3*t161*t708+t704+t703+t695
     1           -1.6406249999999997d-2*t328*t355*t42*t58*t62)*wght+1.0d
     2           +0*t1*t162*t708*wght+1.0d+0*t1*t328*t357*wght+1.0d+0*t1
     3           *t329*t356*wght+t706+t705
              t710 = 1.6406249999999997d-2*t356*t42*t60*t62
              t711 = 6.25d-2*rhoa*t163*t41*t57*t58*t696
              t712 = 6.25d-2*rhob*t102*t163*t57*t58*t696
              t713 = -9.715840896767153d-4*t139*t253*t339*t355*t42*t47*t
     1           56*t58*t61
              t714 = -6.25d-2*t166*t47*t56*t58*t696
              t715 = t158*(t714+1.6325733115771002d-3*t176*t179*t355*t47
     1           *t51*t52*t58*t61)+t713+t712+t711+4.8579204483835753d-4*
     2           rhoa*t166*t205*t334*t355*t57*t58*t61-1.6325733115771002
     3           d-3*rhoa*t179*t355*t407*t41*t47*t51*t52*t58*t61-1.63257
     4           33115771002d-3*rhob*t102*t179*t355*t407*t47*t51*t52*t58
     5           *t61
              t716 = -3.2812499999999994d-2*t160*t166*t58*t61*t696
              t717 = -1.6406249999999997d-2*t160*t355*t42*t62
              t718 = 1.0d+0*t1*t160*(t717+t716+5.46875d-3*t161*t715+t710
     1           -1.6406249999999997d-2*t341*t355*t42*t58*t62)*wght+1.0d
     2           +0*t1*t162*t715*wght+1.0d+0*t1*t341*t357*wght+1.0d+0*t1
     3           *t343*t356*wght
              t719 = t158*(-1.25d-1*t166*t47*t56*t58*t696-3.265146623154
     1           2003d-3*t176*t179*t355*t47*t49*t50*t51*t58*t61)+1.25d-1
     2           *rhoa*t163*t41*t57*t58*t696+1.25d-1*rhob*t102*t163*t57*
     3           t58*t696-9.715840896767153d-4*t139*t253*t346*t355*t42*t
     4           47*t56*t58*t61+3.2651466231542003d-3*rhoa*t179*t355*t40
     5           7*t41*t47*t49*t50*t51*t58*t61+3.2651466231542003d-3*rho
     6           b*t102*t179*t355*t407*t47*t49*t50*t51*t58*t61
              t720 = 1.0d+0*t1*t160*(5.46875d-3*t161*t719-6.562499999999
     1           999d-2*t160*t166*t58*t61*t696+3.2812499999999994d-2*t35
     2           6*t42*t60*t62-1.6406249999999997d-2*t347*t355*t42*t58*t
     3           62-3.2812499999999994d-2*t160*t355*t42*t62)*wght+1.0d+0
     4           *t1*t162*t719*wght+1.0d+0*t1*t347*t357*wght+1.0d+0*t1*t
     5           348*t356*wght
              t721 = t158*(t714+1.6325733115771002d-3*t176*t179*t355*t47
     1           *t51*t53*t58*t61)+t713+t712+t711+4.8579204483835753d-4*
     2           rhob*t166*t304*t351*t355*t57*t58*t61-1.6325733115771002
     3           d-3*rhoa*t179*t355*t407*t41*t47*t51*t53*t58*t61-1.63257
     4           33115771002d-3*rhob*t102*t179*t355*t407*t47*t51*t53*t58
     5           *t61
              t722 = 1.0d+0*t1*t160*(5.46875d-3*t161*t721+t717+t716+t710
     1           -1.6406249999999997d-2*t353*t355*t42*t58*t62)*wght+1.0d
     2           +0*t1*t162*t721*wght+1.0d+0*t1*t353*t357*wght+1.0d+0*t1
     3           *t354*t356*wght
              t723 = 1/t59**4
              t724 = -9.375d-2*rhoa*t163*t359*t41*t57*t723-9.375d-2*rhob
     1           *t102*t163*t359*t57*t723+9.375d-2*t158*t166*t359*t47*t5
     2           6*t723
              t725 = 1.0d+0*t1*t160*(5.46875d-3*t161*t724+3.281249999999
     1           9994d-2*t160*t166*t359*t61*t723+3.2812499999999994d-2*t
     2           160*t42*t58*t62*t696-3.2812499999999994d-2*t355*t356*t4
     3           2*t58*t62)*wght+1.0d+0*t1*t162*t724*wght+2.0d+0*t1*t356
     4           *t357*wght
              fnc(iq) = 1.0d+0*t1*t160*t162*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t160*t275*wght+1.0d+0*t1*t162*t
     1           273*wght+t276+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t160*t329*wght+1.0d+0*t1*t162*t
     1           328*wght+t276+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = 1.0d+0*t1*t160*t343*wght+1.0d+0*t1*t162*
     1           t341*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = 1.0d+0*t1*t160*t348*wght+1.0d+0*t1*t162*
     1           t347*wght+Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = 1.0d+0*t1*t160*t354*wght+1.0d+0*t1*t162*
     1           t353*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = t358+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = t358+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 1.0d+0*t1*t160*(-3.2812499999999994d-
     1           2*t166*t273*t58*t60*t62+t476+t475+5.46875d-3*t161*t474)
     2           *wght+1.0d+0*t1*t162*t474*wght+2.0d+0*t1*t273*t275*wght
     3           +2.0d+0*t160*t275*wght+2.0d+0*t162*t273*wght+Amat2(iq,D
     4           2_RA_RA)
              Amat2(iq,D2_RA_RB) = 1.0d+0*t1*t160*(-1.6406249999999997d-
     1           2*t166*t328*t58*t60*t62-1.6406249999999997d-2*t166*t273
     2           *t58*t60*t62+5.46875d-3*t161*t502+t476+t475)*wght+1.0d+
     3           0*t1*t162*t502*wght+1.0d+0*t1*t273*t329*wght+1.0d+0*t16
     4           0*t329*wght+1.0d+0*t1*t275*t328*wght+1.0d+0*t162*t328*w
     5           ght+1.0d+0*t160*t275*wght+1.0d+0*t162*t273*wght+Amat2(i
     6           q,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t160*(-3.2812499999999994d-
     1           2*t166*t328*t58*t60*t62+5.46875d-3*t161*t550+t476+t475)
     2           *wght+1.0d+0*t1*t162*t550*wght+2.0d+0*t1*t328*t329*wght
     3           +2.0d+0*t160*t329*wght+2.0d+0*t162*t328*wght+Amat2(iq,D
     4           2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = 1.0d+0*t1*t160*(t589+t588+t587+5.468
     1           75d-3*t161*t586+t551)*wght+1.0d+0*t1*t162*t586*wght+1.0
     2           d+0*t1*t273*t343*wght+1.0d+0*t1*t275*t341*wght+t591+t59
     3           0+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = 1.0d+0*t1*t160*(3.2812499999999994d-
     1           2*t273*t42*t60*t62+t615+t614+5.46875d-3*t161*t613+t592)
     2           *wght+1.0d+0*t1*t162*t613*wght+1.0d+0*t1*t273*t348*wght
     3           +1.0d+0*t1*t275*t347*wght+t617+t616+Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = 1.0d+0*t1*t160*(5.46875d-3*t161*t629
     1           +t618+t589+t588+t587)*wght+1.0d+0*t1*t162*t629*wght+1.0
     2           d+0*t1*t273*t354*wght+1.0d+0*t1*t275*t353*wght+t631+t63
     3           0+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = 1.0d+0*t1*t160*(t645+5.46875d-3*t161
     1           *t644+t589+t588+t551)*wght+1.0d+0*t1*t162*t644*wght+1.0
     2           d+0*t1*t328*t343*wght+1.0d+0*t1*t329*t341*wght+t591+t59
     3           0+Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = 1.0d+0*t1*t160*(5.46875d-3*t161*t650
     1           +3.2812499999999994d-2*t328*t42*t60*t62+t615+t614+t592)
     2           *wght+1.0d+0*t1*t162*t650*wght+1.0d+0*t1*t328*t348*wght
     3           +1.0d+0*t1*t329*t347*wght+t617+t616+Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = 1.0d+0*t1*t160*(5.46875d-3*t161*t655
     1           +t645+t618+t589+t588)*wght+1.0d+0*t1*t162*t655*wght+1.0
     2           d+0*t1*t328*t354*wght+1.0d+0*t1*t329*t353*wght+t631+t63
     3           0+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = 1.0d+0*t1*t160*(t673+t672+5.46875d-
     1           3*t161*t671)*wght+1.0d+0*t1*t162*t671*wght+2.0d+0*t1*t3
     2           41*t343*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = 1.0d+0*t1*t160*(t683+5.46875d-3*t16
     1           1*t682+t674+t672)*wght+1.0d+0*t1*t162*t682*wght+1.0d+0*
     2           t1*t341*t348*wght+1.0d+0*t1*t343*t347*wght+Cmat2(iq,D2_
     3           GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 1.0d+0*t1*t160*(5.46875d-3*t161*t68
     1           8+t673+1.6406249999999997d-2*t353*t42*t60*t62+1.6406249
     2           999999997d-2*t341*t42*t60*t62)*wght+1.0d+0*t1*t162*t688
     3           *wght+1.0d+0*t1*t341*t354*wght+1.0d+0*t1*t343*t353*wght
     4           +Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = 1.0d+0*t1*t160*(5.46875d-3*t161*t68
     1           9+6.562499999999999d-2*t347*t42*t60*t62+1.3124999999999
     2           998d-1*t160*t166*t355*t61)*wght+1.0d+0*t1*t162*t689*wgh
     3           t+2.0d+0*t1*t347*t348*wght+Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = 1.0d+0*t1*t160*(5.46875d-3*t161*t69
     1           2+t690+t683+t674)*wght+1.0d+0*t1*t162*t692*wght+1.0d+0*
     2           t1*t347*t354*wght+1.0d+0*t1*t348*t353*wght+Cmat2(iq,D2_
     3           GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = 1.0d+0*t1*t160*(5.46875d-3*t161*t69
     1           4+t690+t673)*wght+1.0d+0*t1*t162*t694*wght+2.0d+0*t1*t3
     2           53*t354*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = t707+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = t707+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = t709+Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = t709+Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = t718+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = t718+Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = t720+Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = t720+Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = t722+Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = t722+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = t725+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = t725+Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = t725+Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 2.1622114952063792d-1*gammaaa*t29*t32
              t34 = t33+1.0d+0
              t35 = gammaaa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 4.675158550002606d-2*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 2.1622114952063792d-1*gammaaa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = rhoa-rhob
              t44 = t42*t43
              t45 = t44**2.0d+0
              t46 = t44**4.0d+0
              t47 = 5.0d-1*t46+8.7d-1*t45+2.2599999999999998d+0*t44**6.0
     1           d+0+5.3d-1
              t48 = 1/t1**2.6666666666666666d+0
              t49 = 1.0d+0-t42*t43
              t50 = t44+1.0d+0
              t51 = 1/t50**1.333333333333333d+0+1/t49**1.333333333333333
     1           d+0
              t52 = t49**2
              t53 = t50**2
              t54 = 4.0d-50*rhob*t53+gammaaa*t52
              t55 = 1.3060586492616802d-2*t48*t51*t54+1.0d+0
              t56 = 1/t55**4.0d+0
              t57 = t47*t56+1.0d+0
              t58 = 4.0d-50*rhob+gammaaa
              t59 = taua+1.0d-50
              t60 = 1/t59
              t61 = t42*t58*t60
              t62 = t61**2.0d+0
              t63 = rhob**3.333333333333333d-1
              t64 = t63**5.0d-1
              t65 = 1/t64
              t66 = 1.530901310039024d-2*t65+1.0465751434d-1
              t67 = 7.876233178997433d-1*t65*t66+1.9269083139d-1
              t68 = 7.876233178997433d-1*t65*t67+4.3896648423d-1
              t69 = 1/t68
              t70 = 1.269642451250142d+0*t64*t69+1.0d+0
              t71 = log(t70)
              t72 = 1/t63
              t73 = 1.2746961887000874d-1*t72+1.0d+0
              t74 = 2.4141993114533214d-2*t65+1.0186556948d-1
              t75 = 7.876233178997433d-1*t65*t74+2.2308199064d-1
              t76 = 7.876233178997433d-1*t65*t75+4.7231125998d-1
              t77 = 1/t76
              t78 = 1.269642451250142d+0*t64*t77+1.0d+0
              t79 = log(t78)
              t80 = 1.325688999052018d-1*t72+1.0d+0
              t81 = 1.3212998810398843d-2*t65+2.9729725188d-2
              t82 = 7.876233178997433d-1*t65*t81+1.2236585478d-1
              t83 = 7.876233178997433d-1*t65*t82+3.497952466d-1
              t84 = 1/t83
              t85 = 1.269642451250142d+0*t64*t84+1.0d+0
              t86 = log(t85)
              t87 = 6.901399211255826d-2*t72+1.0d+0
              t88 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t79*t80-3.10907d-2*t71*t73)-3.37738d-2*t86*t
     2           87)+3.37738d-2*t86*t87)-6.21814d-2*t79*t80
              t89 = rhob**1.1666666666666667d+0
              t90 = 1/t89**2.0d+0
              t91 = exp(-6.432793688582967d+1*t88)
              t92 = t91-1.0d+0
              t93 = 1/t92
              t94 = 8.648845980825518d-51*rhob*t90*t93
              t95 = t94+1.0d+0
              t96 = rhob*t90
              t97 = t96**2.0d+0
              t98 = 1/t92**2.0d+0
              t99 = 7.480253680004171d-101*t97*t98+t94+1.0d+0
              t100 = 1/t99
              t101 = 8.648845980825518d-51*rhob*t100*t90*t95+1.0d+0
              t102 = 1.0d+0*t88+1.5545345434827443d-2*log(t101)
              t103 = t1**3.333333333333333d-1
              t104 = 1/t103
              t105 = 1.325688999052018d-1*t104+1.0d+0
              t106 = t103**5.0d-1
              t107 = 1/t106
              t108 = 2.4141993114533214d-2*t107+1.0186556948d-1
              t109 = 7.876233178997433d-1*t107*t108+2.2308199064d-1
              t110 = 7.876233178997433d-1*t107*t109+4.7231125998d-1
              t111 = 1/t110
              t112 = 1.269642451250142d+0*t106*t111+1.0d+0
              t113 = log(t112)
              t114 = t49**1.3333333333333333d+0
              t115 = t50**1.3333333333333333d+0
              t116 = 1.923661050931536d+0*t115+1.923661050931536d+0*t114
     1           -3.847322101863072d+0
              t117 = 6.901399211255826d-2*t104+1.0d+0
              t118 = 1.3212998810398843d-2*t107+2.9729725188d-2
              t119 = 7.876233178997433d-1*t107*t118+1.2236585478d-1
              t120 = 7.876233178997433d-1*t107*t119+3.497952466d-1
              t121 = 1/t120
              t122 = 1.269642451250142d+0*t106*t121+1.0d+0
              t123 = log(t122)
              t124 = t43**4
              t125 = 1/t1**4
              t126 = 1.2746961887000874d-1*t104+1.0d+0
              t127 = 1.530901310039024d-2*t107+1.0465751434d-1
              t128 = 7.876233178997433d-1*t107*t127+1.9269083139d-1
              t129 = 7.876233178997433d-1*t107*t128+4.3896648423d-1
              t130 = 1/t129
              t131 = 1.269642451250142d+0*t106*t130+1.0d+0
              t132 = log(t131)
              t133 = 1.709920934161365d+0*(6.21814d-2*t105*t113-3.10907d
     1           -2*t126*t132)-3.37738d-2*t117*t123
              t134 = t124*t125*t133+3.37738d-2*t117*t123
              t135 = 5.848223622634648d-1*t116*t134-6.21814d-2*t105*t113
              t136 = t49**6.666666666666666d-1
              t137 = t50**6.666666666666666d-1
              t138 = 5.0d-1*t137+5.0d-1*t136
              t139 = t138**3.0d+0
              t140 = t1**1.1666666666666667d+0
              t141 = 1/t140**2.0d+0
              t142 = t138**2.0d+0
              t143 = 1/t142
              t144 = 1/t139
              t145 = exp(-3.216396844291483d+1*t135*t144)
              t146 = t145-1.0d+0
              t147 = 1/t146
              t148 = 1.3621078885675922d-1*t141*t143*t147*t58
              t149 = t148+1.0d+0
              t150 = 1/t138**4.0d+0
              t151 = t141*t58
              t152 = t151**2.0d+0
              t153 = 1/t146**2.0d+0
              t154 = 1.855337900098064d-2*t150*t152*t153+t148+1.0d+0
              t155 = 1/t154
              t156 = 1.3621078885675922d-1*t141*t143*t149*t155*t58+1.0d+
     1           0
              t157 = log(t156)
              t158 = 3.109069086965489d-2*t139*t157+1.0d+0*t135
              t159 = 1.5625d-2*t47*t56*t62+1.0d+0
              t160 = -1.5625d-2*rhoa*t41*t42*t57*t62-1.5625d-2*rhob*t102
     1           *t42*t57*t62+t158*t159
              t161 = t61**3.0d+0
              t162 = 5.46875d-3*t160*t161+1.0d+0
              t163 = 1/t1**3
              t164 = 1/t1**2
              t165 = t164*t43
              t166 = -t42
              t167 = t166+t165
              t168 = -t164*t43
              t169 = t42+t168
              t170 = 8.0d-50*rhob*t169*t50+2*gammaaa*t167*t49
              t171 = 1/t49**2.333333333333333d+0
              t172 = 1/t50**2.333333333333333d+0
              t173 = -1.333333333333333d+0*t169*t172-1.333333333333333d+
     1           0*t167*t171
              t174 = 1/t1**3.6666666666666664d+0
              t175 = -3.482823064697814d-2*t174*t51*t54
              t176 = 1.3060586492616802d-2*t173*t48*t54+1.30605864926168
     1           02d-2*t170*t48*t51+t175
              t177 = 1/t55**5.0d+0
              t178 = t44**3.0d+0
              t179 = t44**5.0d+0
              t180 = 1.74d+0*t169*t44+1.356d+1*t169*t179+2.0d+0*t169*t17
     1           8
              t181 = t180*t56-4.0d+0*t176*t177*t47
              t182 = 1.5625d-2*rhoa*t164*t41*t57*t62
              t183 = 1/rhoa**1.3333333333333333d+0
              t184 = 1/t9
              t185 = 1/t7**2
              t186 = 1/rhoa**1.3333333333333336d+0
              t187 = 1/t3**3
              t188 = 1/rhoa**6.666666666666667d-1
              t189 = -1.3127055298329054d-1*t187*t188*t5-2.0096226153166
     1           658d-3*t186
              t190 = 7.876233178997433d-1*t189*t4-1.3127055298329054d-1*
     1           t187*t188*t6
              t191 = 2.11607075208357d-1*t188*t4*t8-1.269642451250142d+0
     1           *t185*t190*t3
              t192 = 1/t17
              t193 = 1/t15**2
              t194 = -1.3127055298329054d-1*t13*t187*t188-3.169132786263
     1           567d-3*t186
              t195 = 7.876233178997433d-1*t194*t4-1.3127055298329054d-1*
     1           t14*t187*t188
              t196 = 2.11607075208357d-1*t16*t188*t4-1.269642451250142d+
     1           0*t193*t195*t3
              t197 = 1/t24
              t198 = 1/t22**2
              t199 = -1.3127055298329054d-1*t187*t188*t20-1.734477660408
     1           6162d-3*t186
              t200 = 7.876233178997433d-1*t199*t4-1.3127055298329054d-1*
     1           t187*t188*t21
              t201 = 2.11607075208357d-1*t188*t23*t4-1.269642451250142d+
     1           0*t198*t200*t3
              t202 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t197*t201
     1           *t26+7.769549222703733d-4*t183*t25+1.709920934161365d+0
     2           *(6.21814d-2*t19*t192*t196-3.10907d-2*t12*t184*t191-2.7
     3           47773264188438d-3*t18*t183+1.3210398931339265d-3*t10*t1
     4           83))+3.37738d-2*t197*t201*t26-7.769549222703733d-4*t183
     5           *t25)-6.21814d-2*t19*t192*t196+2.747773264188438d-3*t18
     6           *t183
              t203 = 1/t40
              t204 = rhoa**1.6666666666666674d-1
              t205 = 1/t28**3.0d+0
              t206 = -5.045160155481552d-1*gammaaa*t204*t205*t32
              t207 = 1/t31**2
              t208 = 1.3909060459745137d+1*gammaaa*t202*t207*t29*t30
              t209 = t208+t206
              t210 = 1/t38**2
              t211 = 1/t31**3.0d+0
              t212 = -2.181740656667883d-1*gammaaa*t204*t205*t35*t37+6.0
     1           14866082716293d+0*t202*t211*t30*t36+t208+t206
              t213 = -5.045160155481552d-1*gammaaa*t204*t205*t34*t39+2.1
     1           622114952063792d-1*gammaaa*t209*t29*t39-2.1622114952063
     2           792d-1*gammaaa*t210*t212*t29*t34
              t214 = 1.5545345434827443d-2*t203*t213+1.0d+0*t202
              t215 = 1.5625d-2*rhob*t102*t164*t57*t62
              t216 = 1.5625d-2*t180*t56*t62-6.25d-2*t176*t177*t47*t62-3.
     1           125d-2*t164*t47*t56*t58*t60*t61
              t217 = 1/t1**1.3333333333333336d+0
              t218 = 1/t1**6.666666666666667d-1
              t219 = 1/t106**3
              t220 = -1.3127055298329054d-1*t108*t218*t219-3.16913278626
     1           3567d-3*t217
              t221 = 7.876233178997433d-1*t107*t220-1.3127055298329054d-
     1           1*t109*t218*t219
              t222 = 1/t110**2
              t223 = 2.11607075208357d-1*t107*t111*t218-1.26964245125014
     1           2d+0*t106*t221*t222
              t224 = 1/t112
              t225 = -6.21814d-2*t105*t223*t224
              t226 = 1/t1**1.3333333333333333d+0
              t227 = 2.747773264188438d-3*t113*t226
              t228 = -1.3127055298329054d-1*t118*t218*t219-1.73447766040
     1           86162d-3*t217
              t229 = 7.876233178997433d-1*t107*t228-1.3127055298329054d-
     1           1*t119*t218*t219
              t230 = 1/t120**2
              t231 = 2.11607075208357d-1*t107*t121*t218-1.26964245125014
     1           2d+0*t106*t229*t230
              t232 = 1/t122
              t233 = 3.37738d-2*t117*t231*t232
              t234 = -7.769549222703733d-4*t123*t226
              t235 = -1.3127055298329054d-1*t127*t218*t219-2.00962261531
     1           66658d-3*t217
              t236 = 7.876233178997433d-1*t107*t235-1.3127055298329054d-
     1           1*t128*t218*t219
              t237 = 1/t129**2
              t238 = 2.11607075208357d-1*t107*t130*t218-1.26964245125014
     1           2d+0*t106*t236*t237
              t239 = 1/t131
              t240 = 1.709920934161365d+0*(-3.10907d-2*t126*t238*t239+1.
     1           3210398931339265d-3*t132*t226-2.747773264188438d-3*t113
     2           *t226+6.21814d-2*t105*t223*t224)-3.37738d-2*t117*t231*t
     3           232+7.769549222703733d-4*t123*t226
              t241 = t124*t125*t240
              t242 = 1/t1**5
              t243 = -4*t124*t133*t242
              t244 = t43**3
              t245 = 4*t125*t133*t244+t243+t241+t234+t233
              t246 = t49**3.333333333333333d-1
              t247 = t50**3.333333333333333d-1
              t248 = 2.564881401242048d+0*t169*t247+2.564881401242048d+0
     1           *t167*t246
              t249 = 5.848223622634648d-1*t134*t248+5.848223622634648d-1
     1           *t116*t245+t227+t225
              t250 = 1/t156
              t251 = 1/t246
              t252 = 1/t247
              t253 = 3.333333333333333d-1*t169*t252+3.333333333333333d-1
     1           *t167*t251
              t254 = t1**1.6666666666666674d-1
              t255 = 1/t140**3.0d+0
              t256 = -3.1782517399910487d-1*t143*t149*t155*t254*t255*t58
              t257 = -2.7242157771351844d-1*t141*t144*t147*t253*t58
              t258 = -3.1782517399910487d-1*t143*t147*t254*t255*t58
              t259 = 1/t146**2
              t260 = 9.649190532874448d+1*t135*t150*t253-3.2163968442914
     1           83d+1*t144*t249
              t261 = -1.3621078885675922d-1*t141*t143*t145*t259*t260*t58
              t262 = t261+t258+t257
              t263 = 1/t154**2
              t264 = 1/t138**5.0d+0
              t265 = 1/t146**3.0d+0
              t266 = -8.658243533790966d-2*t150*t151*t153*t254*t255*t58-
     1           3.710675800196128d-2*t145*t150*t152*t260*t265-7.4213516
     2           00392256d-2*t152*t153*t253*t264+t261+t258+t257
              t267 = -1.3621078885675922d-1*t141*t143*t149*t263*t266*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t262*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t253*t58+t256
              t268 = 3.109069086965489d-2*t139*t250*t267+9.3272072608964
     1           66d-2*t142*t157*t253+1.0d+0*t249
              t269 = -1.5625d-2*t41*t42*t57*t62-1.5625d-2*rhoa*t214*t42*
     1           t57*t62-1.5625d-2*rhoa*t181*t41*t42*t62-1.5625d-2*rhob*
     2           t102*t181*t42*t62+3.125d-2*rhoa*t163*t41*t57*t58*t60*t6
     3           1+3.125d-2*rhob*t102*t163*t57*t58*t60*t61+t159*t268+t15
     4           8*t216+t215+t182
              t270 = 5.46875d-3*t161*t269-1.6406249999999997d-2*t160*t16
     1           4*t58*t60*t62
              t271 = 1.0d+0*t160*t162*wght
              t272 = 4.0d-50*t42*t60-t164*t58*t60
              t273 = t42+t165
              t274 = t168+t166
              t275 = 4.0d-50*t53+8.0d-50*rhob*t274*t50+2*gammaaa*t273*t4
     1           9
              t276 = -1.333333333333333d+0*t172*t274-1.333333333333333d+
     1           0*t171*t273
              t277 = 1.3060586492616802d-2*t276*t48*t54+1.30605864926168
     1           02d-2*t275*t48*t51+t175
              t278 = 1.74d+0*t274*t44+1.356d+1*t179*t274+2.0d+0*t178*t27
     1           4
              t279 = t278*t56-4.0d+0*t177*t277*t47
              t280 = 1/rhob**1.3333333333333333d+0
              t281 = 1/t70
              t282 = 1/t68**2
              t283 = rhob**1.3333333333333336d+0
              t284 = 1/t283
              t285 = 1/t64**3
              t286 = 1/rhob**6.666666666666667d-1
              t287 = -1.3127055298329054d-1*t285*t286*t66-2.009622615316
     1           6658d-3*t284
              t288 = 7.876233178997433d-1*t287*t65-1.3127055298329054d-1
     1           *t285*t286*t67
              t289 = 2.11607075208357d-1*t286*t65*t69-1.269642451250142d
     1           +0*t282*t288*t64
              t290 = 1/t78
              t291 = 1/t76**2
              t292 = -1.3127055298329054d-1*t285*t286*t74-3.169132786263
     1           567d-3*t284
              t293 = 7.876233178997433d-1*t292*t65-1.3127055298329054d-1
     1           *t285*t286*t75
              t294 = 2.11607075208357d-1*t286*t65*t77-1.269642451250142d
     1           +0*t291*t293*t64
              t295 = 1/t85
              t296 = 1/t83**2
              t297 = -1.3127055298329054d-1*t285*t286*t81-1.734477660408
     1           6162d-3*t284
              t298 = 7.876233178997433d-1*t297*t65-1.3127055298329054d-1
     1           *t285*t286*t82
              t299 = 2.11607075208357d-1*t286*t65*t84-1.269642451250142d
     1           +0*t296*t298*t64
              t300 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t295*t299
     1           *t87+7.769549222703733d-4*t280*t86+1.709920934161365d+0
     2           *(6.21814d-2*t290*t294*t80-2.747773264188438d-3*t280*t7
     3           9-3.10907d-2*t281*t289*t73+1.3210398931339265d-3*t280*t
     4           71))+3.37738d-2*t295*t299*t87-7.769549222703733d-4*t280
     5           *t86)-6.21814d-2*t290*t294*t80+2.747773264188438d-3*t28
     6           0*t79
              t301 = 1/t101
              t302 = 1/t89**3.0d+0
              t303 = -2.018064062192621d-50*t302*t89*t93
              t304 = 8.648845980825518d-51*t90*t93
              t305 = 1/t92**2
              t306 = 5.563624183898056d-49*rhob*t300*t305*t90*t91
              t307 = t306+t304+t303
              t308 = 1/t99**2
              t309 = t90-2.3333333333333334d+0*t302*t89
              t310 = 1/t92**3.0d+0
              t311 = 1.4960507360008343d-100*t309*t96*t98+9.623785732346
     1           068d-99*t300*t310*t91*t97+t306+t304+t303
              t312 = -8.648845980825518d-51*rhob*t308*t311*t90*t95+8.648
     1           845980825518d-51*t100*t90*t95-2.018064062192621d-50*t10
     2           0*t302*t89*t95+8.648845980825518d-51*rhob*t100*t307*t90
              t313 = 1.5545345434827443d-2*t301*t312+1.0d+0*t300
              t314 = 1.5625d-2*t278*t56*t62-6.25d-2*t177*t277*t47*t62+3.
     1           125d-2*t272*t47*t56*t61
              t315 = -4*t125*t133*t244+t243+t241+t234+t233
              t316 = 2.564881401242048d+0*t247*t274+2.564881401242048d+0
     1           *t246*t273
              t317 = 5.848223622634648d-1*t134*t316+5.848223622634648d-1
     1           *t116*t315+t227+t225
              t318 = 3.333333333333333d-1*t252*t274+3.333333333333333d-1
     1           *t251*t273
              t319 = -2.7242157771351844d-1*t141*t144*t147*t318*t58
              t320 = 5.44843155427037d-51*t141*t143*t147
              t321 = 9.649190532874448d+1*t135*t150*t318-3.2163968442914
     1           83d+1*t144*t317
              t322 = -1.3621078885675922d-1*t141*t143*t145*t259*t321*t58
              t323 = t322+t320+t319+t258
              t324 = 4.0d-50*t141-2.3333333333333334d+0*t254*t255*t58
              t325 = 3.710675800196128d-2*t150*t151*t153*t324+t322-3.710
     1           675800196128d-2*t145*t150*t152*t265*t321+t320+t319-7.42
     2           1351600392256d-2*t152*t153*t264*t318+t258
              t326 = -1.3621078885675922d-1*t141*t143*t149*t263*t325*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t323*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t318*t58+t256+5.44843
     3           155427037d-51*t141*t143*t149*t155
              t327 = 3.109069086965489d-2*t139*t250*t326+9.3272072608964
     1           66d-2*t142*t157*t318+1.0d+0*t317
              t328 = -1.5625d-2*rhob*t313*t42*t57*t62-1.5625d-2*t102*t42
     1           *t57*t62-1.5625d-2*rhoa*t279*t41*t42*t62-1.5625d-2*rhob
     2           *t102*t279*t42*t62-3.125d-2*rhoa*t272*t41*t42*t57*t61-3
     3           .125d-2*rhob*t102*t272*t42*t57*t61+t159*t327+t158*t314+
     4           t215+t182
              t329 = 1.6406249999999997d-2*t160*t272*t62+5.46875d-3*t161
     1           *t328
              t330 = 9.350317100005212d-2*t29*t35*t37+2.1622114952063792
     1           d-1*t29*t32
              t331 = 1/t28**4.0d+0
              t332 = 2.1622114952063792d-1*t29*t34*t39+4.675158550002606
     1           d-2*gammaaa*t32*t331*t39-2.1622114952063792d-1*gammaaa*
     2           t210*t29*t330*t34
              t333 = 3.125d-2*t42*t47*t56*t60*t61-8.162866557885502d-4*t
     1           177*t47*t48*t51*t52*t62
              t334 = 3.710675800196128d-2*t141*t150*t151*t153+1.36210788
     1           85675922d-1*t141*t143*t147
              t335 = 1/t140**4.0d+0
              t336 = 1.855337900098064d-2*t147*t150*t155*t335*t58-1.3621
     1           078885675922d-1*t141*t143*t149*t263*t334*t58+1.36210788
     2           85675922d-1*t141*t143*t149*t155
              t337 = -2.4289602241917876d-4*rhoa*t203*t332*t42*t57*t62+8
     1           .162866557885502d-4*rhoa*t174*t177*t41*t47*t51*t52*t62+
     2           8.162866557885502d-4*rhob*t102*t174*t177*t47*t51*t52*t6
     3           2-3.125d-2*rhoa*t164*t41*t57*t60*t61-3.125d-2*rhob*t102
     4           *t164*t57*t60*t61+3.109069086965489d-2*t139*t159*t250*t
     5           336+t158*t333
              t338 = 1.6406249999999997d-2*t160*t42*t60*t62+5.46875d-3*t
     1           161*t337
              t339 = 1/t59**2
              t340 = 3.125d-2*rhoa*t164*t339*t41*t57*t58*t61+3.125d-2*rh
     1           ob*t102*t164*t339*t57*t58*t61-3.125d-2*t158*t339*t42*t4
     2           7*t56*t58*t61
              t341 = 5.46875d-3*t161*t340-1.6406249999999997d-2*t160*t33
     1           9*t42*t58*t62
              t342 = t58**2
              t343 = -3.125d-2*rhoa*t163*t41*t57*t62
              t344 = 1/rhoa**2.333333333333333d+0
              t345 = 1/rhoa**2.3333333333333334d+0
              t346 = 1/rhoa**1.6666666666666669d+0
              t347 = 1/t3**5
              t348 = 1/t17**2
              t349 = t196**2
              t350 = -1.269642451250142d+0*t193*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t13*t186*t347+8.751370198886037d
     2           -2*t13*t187*t346+4.753699179395351d-3*t345)*t4+6.563527
     3           649164527d-2*t14*t186*t347+8.751370198886037d-2*t14*t18
     4           7*t346-2.625411059665811d-1*t187*t188*t194)-1.410713834
     5           7223802d-1*t16*t346*t4-4.23214150416714d-1*t188*t193*t1
     6           95*t4+2.539284902500284d+0*t195**2*t3/t15**3-3.52678458
     7           680595d-2*t16*t186*t187
              t351 = 1/t24**2
              t352 = t201**2
              t353 = -1.269642451250142d+0*t198*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t186*t20*t347+8.751370198886037d
     2           -2*t187*t20*t346+2.601716490612924d-3*t345)*t4+6.563527
     3           649164527d-2*t186*t21*t347+8.751370198886037d-2*t187*t2
     4           1*t346-2.625411059665811d-1*t187*t188*t199)-1.410713834
     5           7223802d-1*t23*t346*t4-4.23214150416714d-1*t188*t198*t2
     6           00*t4+2.539284902500284d+0*t200**2*t3/t22**3-3.52678458
     7           680595d-2*t186*t187*t23
              t354 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (3.10907d-2*t12*t191**2/t9**2-3.10907d-2*t12*t184*(-1.4
     2           107138347223802d-1*t346*t4*t8-3.52678458680595d-2*t186*
     3           t187*t8+2.539284902500284d+0*t190**2*t3/t7**3-1.2696424
     4           51250142d+0*t185*t3*(6.563527649164527d-2*t186*t347*t6+
     5           8.751370198886037d-2*t187*t346*t6+7.876233178997433d-1*
     6           t4*(6.563527649164527d-2*t186*t347*t5+8.751370198886037
     7           d-2*t187*t346*t5+3.0144339229749983d-3*t345)-2.62541105
     8           9665811d-1*t187*t188*t189)-4.23214150416714d-1*t185*t18
     9           8*t190*t4)+6.21814d-2*t19*t192*t350-6.21814d-2*t19*t348
     :           *t349+3.663697685584584d-3*t18*t344-1.7613865241785687d
     ;           -3*t10*t344-5.495546528376876d-3*t183*t192*t196+2.64207
     <           9786267853d-3*t183*t184*t191)-3.37738d-2*t197*t26*t353+
     =           3.37738d-2*t26*t351*t352-1.0359398963604977d-3*t25*t344
     >           +1.5539098445407465d-3*t183*t197*t201)+3.37738d-2*t197*
     ?           t26*t353-3.37738d-2*t26*t351*t352+1.0359398963604977d-3
     @           *t25*t344-1.5539098445407465d-3*t183*t197*t201)-6.21814
     1           d-2*t19*t192*t350+6.21814d-2*t19*t348*t349-3.6636976855
     2           84584d-3*t18*t344+5.495546528376876d-3*t183*t192*t196
              t355 = rhoa**3.333333333333335d-1
              t356 = 1/rhoa**8.333333333333333d-1
              t357 = t202**2
              t358 = exp(-1.2865587377165935d+2*t27)
              t359 = 1.7894823267913484d+3*gammaaa*t29*t357*t358/t31**3
              t360 = 1.765806054418543d+0*gammaaa*t32*t331*t355
              t361 = -8.408600259135923d-2*gammaaa*t205*t32*t356
              t362 = -6.490894881214397d+1*gammaaa*t202*t204*t205*t207*t
     1           30
              t363 = -8.947411633956742d+2*gammaaa*t207*t29*t30*t357
              t364 = 1.3909060459745137d+1*gammaaa*t207*t29*t30*t354
              t365 = gammaaa**2
              t366 = 1/t28**6.0d+0
              t367 = 1/t28**5.0d+0
              t368 = 1/t38**3
              t369 = 1/t40**2
              t370 = t176**2
              t371 = 1/t55**6.0d+0
              t372 = -2*t163*t43
              t373 = 2*t164
              t374 = t373+t372
              t375 = 2*t163*t43
              t376 = -2*t164
              t377 = t376+t375
              t378 = t167**2
              t379 = t169**2
              t380 = 1/t49**3.333333333333333d+0
              t381 = 1/t50**3.333333333333333d+0
              t382 = 1/t1**4.666666666666667d+0
              t383 = 1.2770351237225316d-1*t382*t51*t54
              t384 = 1.3060586492616802d-2*(3.11111111111111d+0*t379*t38
     1           1+3.11111111111111d+0*t378*t380-1.333333333333333d+0*t1
     2           72*t377-1.333333333333333d+0*t171*t374)*t48*t54-6.96564
     3           6129395628d-2*t173*t174*t54+1.3060586492616802d-2*t48*(
     4           8.0d-50*rhob*t377*t50+2*gammaaa*t374*t49+8.0d-50*rhob*t
     5           379+2*gammaaa*t378)*t51-6.965646129395628d-2*t170*t174*
     6           t51+2.6121172985233604d-2*t170*t173*t48+t383
              t385 = 6.779999999999999d+1*t379*t46+6.0d+0*t379*t45+1.74d
     1           +0*t377*t42*t43+1.74d+0*t379+1.356d+1*t179*t377+2.0d+0*
     2           t178*t377
              t386 = t385*t56-4.0d+0*t177*t384*t47+2.0d+1*t370*t371*t47-
     1           8.0d+0*t176*t177*t180
              t387 = -3.125d-2*rhob*t102*t163*t57*t62
              t388 = t223**2
              t389 = 1/t112**2
              t390 = 6.21814d-2*t105*t388*t389
              t391 = 1/t1**2.3333333333333334d+0
              t392 = 1/t106**5
              t393 = 1/t1**1.6666666666666669d+0
              t394 = -1.269642451250142d+0*t106*t222*(7.876233178997433d
     1           -1*t107*(8.751370198886037d-2*t108*t219*t393+6.56352764
     2           9164527d-2*t108*t217*t392+4.753699179395351d-3*t391)+8.
     3           751370198886037d-2*t109*t219*t393+6.563527649164527d-2*
     4           t109*t217*t392-2.625411059665811d-1*t218*t219*t220)-1.4
     5           107138347223802d-1*t107*t111*t393-4.23214150416714d-1*t
     6           107*t218*t221*t222+2.539284902500284d+0*t106*t221**2/t1
     7           10**3-3.52678458680595d-2*t111*t217*t219
              t395 = -6.21814d-2*t105*t224*t394
              t396 = 5.495546528376876d-3*t223*t224*t226
              t397 = 1/t1**2.333333333333333d+0
              t398 = -3.663697685584584d-3*t113*t397
              t399 = t231**2
              t400 = 1/t122**2
              t401 = -3.37738d-2*t117*t399*t400
              t402 = -1.269642451250142d+0*t106*t230*(7.876233178997433d
     1           -1*t107*(8.751370198886037d-2*t118*t219*t393+6.56352764
     2           9164527d-2*t118*t217*t392+2.601716490612924d-3*t391)+8.
     3           751370198886037d-2*t119*t219*t393+6.563527649164527d-2*
     4           t119*t217*t392-2.625411059665811d-1*t218*t219*t228)-1.4
     5           107138347223802d-1*t107*t121*t393-4.23214150416714d-1*t
     6           107*t218*t229*t230+2.539284902500284d+0*t106*t229**2/t1
     7           20**3-3.52678458680595d-2*t121*t217*t219
              t403 = 3.37738d-2*t117*t232*t402
              t404 = -1.5539098445407465d-3*t226*t231*t232
              t405 = 1.0359398963604977d-3*t123*t397
              t406 = t124*t125*(-3.37738d-2*t117*t232*t402+3.37738d-2*t1
     1           17*t399*t400+1.709920934161365d+0*(-1.7613865241785687d
     2           -3*t132*t397+3.663697685584584d-3*t113*t397+6.21814d-2*
     3           t105*t224*t394-3.10907d-2*t126*t239*(-1.269642451250142
     4           d+0*t106*t237*(7.876233178997433d-1*t107*(8.75137019888
     5           6037d-2*t127*t219*t393+6.563527649164527d-2*t127*t217*t
     6           392+3.0144339229749983d-3*t391)+8.751370198886037d-2*t1
     7           28*t219*t393+6.563527649164527d-2*t128*t217*t392-2.6254
     8           11059665811d-1*t218*t219*t235)-1.4107138347223802d-1*t1
     9           07*t130*t393-4.23214150416714d-1*t107*t218*t236*t237+2.
     :           539284902500284d+0*t106*t236**2/t129**3-3.5267845868059
     ;           5d-2*t130*t217*t219)-6.21814d-2*t105*t388*t389+2.642079
     <           786267853d-3*t226*t238*t239+3.10907d-2*t126*t238**2/t13
     =           1**2-5.495546528376876d-3*t223*t224*t226)-1.03593989636
     >           04977d-3*t123*t397+1.5539098445407465d-3*t226*t231*t232
     ?           )
              t407 = -8*t124*t240*t242
              t408 = 20*t124*t133/t1**6
              t409 = t43**2
              t410 = 12*t125*t133*t409
              t411 = 1/t136
              t412 = 1/t137
              t413 = 5.848223622634648d-1*t134*(8.549604670806825d-1*t37
     1           9*t412+8.549604670806825d-1*t378*t411+2.564881401242048
     2           d+0*t247*t377+2.564881401242048d+0*t246*t374)+5.8482236
     3           22634648d-1*t116*(t410+t408+t407+t406+t405+t404+t403+t4
     4           01-32*t133*t242*t244+8*t125*t240*t244)+t398+t396+t395+t
     5           390+1.1696447245269297d+0*t245*t248
              t414 = t253**2
              t415 = 1/t114
              t416 = 1/t115
              t417 = -1.111111111111111d-1*t379*t416-1.111111111111111d-
     1           1*t378*t415+3.333333333333333d-1*t252*t377+3.3333333333
     2           33333d-1*t251*t374
              t418 = t1**3.333333333333335d-1
              t419 = 1.1123881089968671d+0*t143*t149*t155*t335*t418*t58
              t420 = 1/t1**8.333333333333333d-1
              t421 = -5.297086233318417d-2*t143*t149*t155*t255*t420*t58
              t422 = 8.172647331405554d-1*t141*t147*t150*t414*t58
              t423 = -2.7242157771351844d-1*t141*t144*t147*t417*t58
              t424 = 1.2713006959964196d+0*t144*t147*t253*t254*t255*t58
              t425 = 1.1123881089968671d+0*t143*t147*t335*t418*t58
              t426 = -5.297086233318417d-2*t143*t147*t255*t420*t58
              t427 = 9.649190532874448d+1*t135*t150*t417-3.8596762131497
     1           79d+2*t135*t264*t414-3.216396844291483d+1*t144*t413+1.9
     2           298381065748896d+2*t150*t249*t253
              t428 = -1.3621078885675922d-1*t141*t143*t145*t259*t427*t58
              t429 = 5.448431554270369d-1*t141*t144*t145*t253*t259*t260*
     1           t58
              t430 = 6.356503479982097d-1*t143*t145*t254*t255*t259*t260*
     1           t58
              t431 = exp(-6.432793688582966d+1*t135*t144)
              t432 = 1/t146**3
              t433 = t260**2
              t434 = 2.7242157771351844d-1*t141*t143*t431*t432*t433*t58
              t435 = -1.3621078885675922d-1*t141*t143*t145*t259*t433*t58
              t436 = 1/t140**5.0d+0
              t437 = 1/t140**6.0d+0
              t438 = -1.4430405889651615d-2*t150*t153*t342*t420*t436
              t439 = 1/t138**6.0d+0
              t440 = 1/t146**4.0d+0
              t441 = 1/t154**3
              t442 = 1/t156**2
              t443 = t158*(1.5625d-2*t385*t56*t62-6.25d-2*t177*t384*t47*
     1           t62+3.125d-1*t370*t371*t47*t62-1.25d-1*t176*t177*t180*t
     2           62-3.125d-2*t164*t180*t56*t58*t60*t61+1.25d-1*t164*t176
     3           *t177*t47*t58*t60*t61+9.375d-2*t125*t339*t342*t47*t56-3
     4           .125d-2*t163*t180*t339*t342*t56+1.25d-1*t163*t176*t177*
     5           t339*t342*t47)-1.5625d-2*rhoa*(1.5545345434827443d-2*t2
     6           03*(2.1622114952063792d-1*gammaaa*t29*(t364+t363+t362+t
     7           361+t360+t359)*t39-8.408600259135923d-2*gammaaa*t205*t3
     8           4*t356*t39+1.765806054418543d+0*gammaaa*t331*t34*t355*t
     9           39-1.0090320310963104d+0*gammaaa*t204*t205*t209*t39-2.1
     :           622114952063792d-1*gammaaa*t210*t29*t34*(-3.63623442777
     ;           98064d-2*t356*t365*t367*t37+1.2726820497229316d+0*t355*
     <           t365*t366*t37-2.806937505267603d+1*t202*t204*t211*t30*t
     =           365*t367+t364+t363+t362+t361+t360+1.1607717772370736d+3
     >           *t357*t358*t36/t31**4.0d+0-3.869239257456912d+2*t211*t3
     ?           0*t357*t36+6.014866082716293d+0*t211*t30*t354*t36+t359-
     @           2.806937505267603d+1*gammaaa*t202*t204*t205*t211*t30*t3
     1           5)+4.3244229904127585d-1*gammaaa*t212**2*t29*t34*t368+1
     2           .0090320310963104d+0*gammaaa*t204*t205*t210*t212*t34-4.
     3           3244229904127585d-1*gammaaa*t209*t210*t212*t29)-1.55453
     4           45434827443d-2*t213**2*t369+1.0d+0*t354)*t42*t57*t62-3.
     5           125d-2*t214*t42*t57*t62+3.125d-2*t164*t41*t57*t62+3.125
     6           d-2*rhoa*t164*t214*t57*t62-1.5625d-2*rhoa*t386*t41*t42*
     7           t62-3.125d-2*t181*t41*t42*t62-1.5625d-2*rhob*t102*t386*
     8           t42*t62-3.125d-2*rhoa*t181*t214*t42*t62+3.125d-2*rhoa*t
     9           164*t181*t41*t62+3.125d-2*rhob*t102*t164*t181*t62+3.125
     :           d-2*t163*t41*t57*t58*t60*t61-3.125d-2*rhoa*t125*t41*t57
     ;           *t58*t60*t61+3.125d-2*rhoa*t163*t214*t57*t58*t60*t61-3.
     <           125d-2*rhob*t102*t125*t57*t58*t60*t61+3.125d-2*rhoa*t16
     =           3*t181*t41*t58*t60*t61+3.125d-2*rhob*t102*t163*t181*t58
     >           *t60*t61+t159*(3.109069086965489d-2*t139*t250*(-1.36210
     ?           78885675922d-1*t141*t143*t149*t263*t58*(1.7316487067581
     @           932d-1*t145*t150*t151*t254*t255*t260*t265*t58+3.4632974
     1           135163863d-1*t151*t153*t253*t254*t255*t264*t58+1.113202
     2           7400588385d-1*t150*t152*t431*t433*t440+3.71067580019612
     3           8d-1*t152*t153*t414*t439+t438+5.050642061378063d-1*t150
     4           *t153*t342*t418*t437+1.7316487067581932d-1*t145*t150*t2
     5           54*t260*t265*t342*t436+3.4632974135163863d-1*t153*t253*
     6           t254*t264*t342*t436+t435+t434-3.710675800196128d-2*t145
     7           *t150*t152*t265*t433+t430+t429+t428-3.710675800196128d-
     8           2*t145*t150*t152*t265*t427+t426+t425+t424+t423+t422-7.4
     9           21351600392256d-2*t152*t153*t264*t417+2.968540640156902
     :           6d-1*t145*t152*t253*t260*t264*t265)+2.7242157771351844d
     ;           -1*t141*t143*t149*t266**2*t441*t58+1.3621078885675922d-
     <           1*t141*t143*t155*(t435+t434+t430+t429+t428+t426+t425+t4
     =           24+t423+t422)*t58-2.7242157771351844d-1*t141*t144*t149*
     >           t155*t417*t58+8.172647331405554d-1*t141*t149*t150*t155*
     ?           t414*t58-2.7242157771351844d-1*t141*t143*t262*t263*t266
     @           *t58+6.356503479982097d-1*t143*t149*t254*t255*t263*t266
     1           *t58+5.448431554270369d-1*t141*t144*t149*t253*t263*t266
     2           *t58-6.356503479982097d-1*t143*t155*t254*t255*t262*t58-
     3           5.448431554270369d-1*t141*t144*t155*t253*t262*t58+1.271
     4           3006959964196d+0*t144*t149*t155*t253*t254*t255*t58+t421
     5           +t419)-3.109069086965489d-2*t139*t267**2*t442+9.3272072
     6           60896466d-2*t142*t157*t417+1.8654414521792934d-1*t138*t
     7           157*t414+1.0d+0*t413+1.8654414521792934d-1*t142*t250*t2
     8           53*t267)-1.25d-1*rhoa*t242*t339*t342*t41*t57+3.125d-2*t
     9           125*t339*t342*t41*t57-1.25d-1*rhob*t102*t242*t339*t342*
     :           t57+3.125d-2*rhoa*t125*t214*t339*t342*t57+3.125d-2*rhoa
     ;           *t125*t181*t339*t342*t41+t387+t343+3.125d-2*rhob*t102*t
     <           125*t181*t339*t342+2*t216*t268
              t444 = 3.2812499999999994d-2*t160*t163*t58*t60*t62
              t445 = 3.125d-2*rhoa*t163*t272*t41*t57*t58*t60
              t446 = 3.125d-2*rhob*t102*t163*t272*t57*t58*t60
              t447 = 3.125d-2*rhoa*t164*t272*t41*t57*t61
              t448 = 3.125d-2*rhob*t102*t164*t272*t57*t61
              t449 = 1.3060586492616802d-2*(-2.666666666666666d+0*t163*t
     1           172*t43+2.666666666666666d+0*t163*t171*t43+3.1111111111
     2           1111d+0*t169*t274*t381+3.11111111111111d+0*t167*t273*t3
     3           80)*t48*t54-3.482823064697814d-2*t174*t276*t54-3.482823
     4           064697814d-2*t173*t174*t54+1.3060586492616802d-2*t48*(1
     5           .6d-49*rhob*t163*t43*t50+8.0d-50*t169*t50-4*gammaaa*t16
     6           3*t43*t49+8.0d-50*rhob*t169*t274+2*gammaaa*t167*t273)*t
     7           51-3.482823064697814d-2*t174*t275*t51-3.482823064697814
     8           d-2*t170*t174*t51+1.3060586492616802d-2*t170*t276*t48+1
     9           .3060586492616802d-2*t173*t275*t48+t383
              t450 = 6.779999999999999d+1*t169*t274*t46+6.0d+0*t169*t274
     1           *t45+2.712d+1*t163*t179*t43+4.0d+0*t163*t178*t43+3.48d+
     2           0*t125*t409+1.74d+0*t169*t274
              t451 = t450*t56-4.0d+0*t177*t449*t47+2.0d+1*t176*t277*t371
     1           *t47-4.0d+0*t176*t177*t278-4.0d+0*t177*t180*t277
              t452 = 5.848223622634648d-1*t134*(5.129762802484096d+0*t16
     1           3*t247*t43-5.129762802484096d+0*t163*t246*t43+8.5496046
     2           70806825d-1*t169*t274*t412+8.549604670806825d-1*t167*t2
     3           73*t411)+5.848223622634648d-1*t116*(-12*t125*t133*t409+
     4           t408+t407+t406+t405+t404+t403+t401)+t398+t396+t395+t390
     5           +5.848223622634648d-1*t245*t316+5.848223622634648d-1*t2
     6           48*t315
              t453 = 6.666666666666666d-1*t163*t252*t43-6.66666666666666
     1           6d-1*t163*t251*t43-1.111111111111111d-1*t169*t274*t416-
     2           1.111111111111111d-1*t167*t273*t415
              t454 = 8.172647331405554d-1*t141*t147*t150*t253*t318*t58
              t455 = -2.7242157771351844d-1*t141*t144*t147*t453*t58
              t456 = 6.356503479982097d-1*t144*t147*t254*t255*t318*t58
              t457 = 6.356503479982097d-1*t144*t147*t253*t254*t255*t58
              t458 = -1.0896863108540739d-50*t141*t144*t147*t253
              t459 = -1.2713006959964193d-50*t143*t147*t254*t255
              t460 = 9.649190532874448d+1*t135*t150*t453-3.2163968442914
     1           83d+1*t144*t452-3.859676213149779d+2*t135*t253*t264*t31
     2           8+9.649190532874448d+1*t150*t249*t318+9.649190532874448
     3           d+1*t150*t253*t317
              t461 = -1.3621078885675922d-1*t141*t143*t145*t259*t460*t58
              t462 = 2.7242157771351844d-1*t141*t144*t145*t253*t259*t321
     1           *t58
              t463 = 3.1782517399910487d-1*t143*t145*t254*t255*t259*t321
     1           *t58
              t464 = 2.7242157771351844d-1*t141*t144*t145*t259*t260*t318
     1           *t58
              t465 = 3.1782517399910487d-1*t143*t145*t254*t255*t259*t260
     1           *t58
              t466 = -5.44843155427037d-51*t141*t143*t145*t259*t260
              t467 = 2.7242157771351844d-1*t141*t143*t260*t321*t431*t432
     1           *t58
              t468 = -1.3621078885675922d-1*t141*t143*t145*t259*t260*t32
     1           1*t58
              t469 = t158*(1.5625d-2*t450*t56*t62-6.25d-2*t177*t449*t47*
     1           t62+3.125d-1*t176*t277*t371*t47*t62-6.25d-2*t176*t177*t
     2           278*t62-6.25d-2*t177*t180*t277*t62+3.125d-2*t180*t272*t
     3           56*t61-1.25d-1*t176*t177*t272*t47*t61-3.125d-2*t164*t27
     4           2*t47*t56*t58*t60-1.25d-51*t163*t339*t47*t56*t58+6.25d-
     5           2*t125*t339*t342*t47*t56-3.125d-2*t163*t278*t339*t342*t
     6           56+1.25d-1*t163*t177*t277*t339*t342*t47)+1.5625d-2*t164
     7           *t41*t57*t62+1.5625d-2*rhob*t164*t313*t57*t62+1.5625d-2
     8           *rhoa*t164*t214*t57*t62+1.5625d-2*t102*t164*t57*t62-1.5
     9           625d-2*rhoa*t41*t42*t451*t62-1.5625d-2*rhob*t102*t42*t4
     :           51*t62-1.5625d-2*t279*t41*t42*t62-1.5625d-2*rhob*t181*t
     ;           313*t42*t62-1.5625d-2*rhoa*t214*t279*t42*t62-1.5625d-2*
     <           t102*t181*t42*t62+1.5625d-2*rhoa*t164*t279*t41*t62+1.56
     =           25d-2*rhoa*t164*t181*t41*t62+1.5625d-2*rhob*t102*t164*t
     >           279*t62+1.5625d-2*rhob*t102*t164*t181*t62-3.125d-2*t272
     ?           *t41*t42*t57*t61-3.125d-2*rhoa*t214*t272*t42*t57*t61-3.
     @           125d-2*rhoa*t181*t272*t41*t42*t61-3.125d-2*rhob*t102*t1
     1           81*t272*t42*t61+t159*(3.109069086965489d-2*t139*t250*(-
     2           1.3621078885675922d-1*t141*t143*t149*t263*t58*(-3.46329
     3           74135163863d-51*t150*t153*t254*t436*t58-8.6582435337909
     4           66d-2*t150*t153*t254*t255*t324*t58+t468+t467+t466+t465+
     5           t464+t463+t462+t461-3.710675800196128d-2*t145*t150*t152
     6           *t265*t460+t459+t458+t457+t456+t455+t454-7.421351600392
     7           256d-2*t152*t153*t264*t453+1.1132027400588385d-1*t150*t
     8           152*t260*t321*t431*t440+3.710675800196128d-1*t152*t153*
     9           t253*t318*t439+t438+3.030385236826838d-1*t150*t153*t342
     :           *t418*t437+1.7316487067581932d-1*t145*t150*t254*t265*t3
     ;           21*t342*t436+3.4632974135163863d-1*t153*t254*t264*t318*
     <           t342*t436+t426+t425-7.421351600392256d-2*t145*t150*t151
     =           *t260*t265*t324-1.4842703200784513d-1*t151*t153*t253*t2
     >           64*t324+1.4842703200784513d-1*t145*t152*t253*t264*t265*
     ?           t321-3.710675800196128d-2*t145*t150*t152*t260*t265*t321
     @           +1.4842703200784513d-1*t145*t152*t260*t264*t265*t318)+1
     1           .3621078885675922d-1*t141*t143*t155*(t468+t467+t466+t46
     2           5+t464+t463+t462+t461+t459+t458+t457+t456+t455+t454+t42
     3           6+t425)*t58-2.7242157771351844d-1*t141*t144*t149*t155*t
     4           453*t58+2.7242157771351844d-1*t141*t143*t149*t266*t325*
     5           t441*t58-1.3621078885675922d-1*t141*t143*t262*t263*t325
     6           *t58+3.1782517399910487d-1*t143*t149*t254*t255*t263*t32
     7           5*t58+2.7242157771351844d-1*t141*t144*t149*t253*t263*t3
     8           25*t58-1.3621078885675922d-1*t141*t143*t263*t266*t323*t
     9           58-3.1782517399910487d-1*t143*t155*t254*t255*t323*t58-2
     :           .7242157771351844d-1*t141*t144*t155*t253*t323*t58+2.724
     ;           2157771351844d-1*t141*t144*t149*t263*t266*t318*t58-2.72
     <           42157771351844d-1*t141*t144*t155*t262*t318*t58+6.356503
     =           479982097d-1*t144*t149*t155*t254*t255*t318*t58+8.172647
     >           331405554d-1*t141*t149*t150*t155*t253*t318*t58+3.178251
     ?           7399910487d-1*t143*t149*t254*t255*t263*t266*t58-3.17825
     @           17399910487d-1*t143*t155*t254*t255*t262*t58+6.356503479
     1           982097d-1*t144*t149*t155*t253*t254*t255*t58+t421+t419-5
     2           .44843155427037d-51*t141*t143*t149*t263*t266+5.44843155
     3           427037d-51*t141*t143*t155*t262-1.2713006959964193d-50*t
     4           143*t149*t155*t254*t255-1.0896863108540739d-50*t141*t14
     5           4*t149*t155*t253)+9.327207260896466d-2*t142*t157*t453+1
     6           .0d+0*t452-3.109069086965489d-2*t139*t267*t326*t442+9.3
     7           27207260896466d-2*t142*t250*t253*t326+9.327207260896466
     8           d-2*t142*t250*t267*t318+1.8654414521792934d-1*t138*t157
     9           *t253*t318)+1.25d-51*rhoa*t125*t339*t41*t57*t58+1.25d-5
     :           1*rhob*t102*t125*t339*t57*t58-9.375d-2*rhoa*t242*t339*t
     ;           342*t41*t57+3.125d-2*rhob*t125*t313*t339*t342*t57-9.375
     <           d-2*rhob*t102*t242*t339*t342*t57+3.125d-2*t102*t125*t33
     =           9*t342*t57+t448+t447+t446+t445+3.125d-2*rhoa*t125*t279*
     >           t339*t342*t41+t387+t343+3.125d-2*rhob*t102*t125*t279*t3
     ?           39*t342+t216*t327+t268*t314
              t470 = 2*t163*t58*t60-8.0d-50*t164*t60
              t471 = t277**2
              t472 = t376+t372
              t473 = t375+t373
              t474 = t274**2
              t475 = t273**2
              t476 = 1.3060586492616802d-2*(3.11111111111111d+0*t380*t47
     1           5+3.11111111111111d+0*t381*t474-1.333333333333333d+0*t1
     2           72*t473-1.333333333333333d+0*t171*t472)*t48*t54-6.96564
     3           6129395628d-2*t174*t276*t54+1.3060586492616802d-2*t48*(
     4           8.0d-50*rhob*t473*t50+1.6d-49*t274*t50+2*gammaaa*t472*t
     5           49+2*gammaaa*t475+8.0d-50*rhob*t474)*t51-6.965646129395
     6           628d-2*t174*t275*t51+2.6121172985233604d-2*t275*t276*t4
     7           8+t383
              t477 = 6.779999999999999d+1*t46*t474+6.0d+0*t45*t474+1.74d
     1           +0*t474+1.74d+0*t42*t43*t473+1.356d+1*t179*t473+2.0d+0*
     2           t178*t473
              t478 = t477*t56-4.0d+0*t177*t47*t476+2.0d+1*t371*t47*t471-
     1           8.0d+0*t177*t277*t278
              t479 = 1/rhob**2.333333333333333d+0
              t480 = 1/rhob**2.3333333333333334d+0
              t481 = 1/rhob**1.6666666666666669d+0
              t482 = 1/t64**5
              t483 = 1/t78**2
              t484 = t294**2
              t485 = -1.4107138347223802d-1*t481*t65*t77-3.5267845868059
     1           5d-2*t284*t285*t77+2.539284902500284d+0*t293**2*t64/t76
     2           **3-1.269642451250142d+0*t291*t64*(6.563527649164527d-2
     3           *t284*t482*t75+8.751370198886037d-2*t285*t481*t75+7.876
     4           233178997433d-1*t65*(6.563527649164527d-2*t284*t482*t74
     5           +8.751370198886037d-2*t285*t481*t74+4.753699179395351d-
     6           3*t480)-2.625411059665811d-1*t285*t286*t292)-4.23214150
     7           416714d-1*t286*t291*t293*t65
              t486 = 1/t85**2
              t487 = t299**2
              t488 = -1.4107138347223802d-1*t481*t65*t84-3.5267845868059
     1           5d-2*t284*t285*t84+2.539284902500284d+0*t298**2*t64/t83
     2           **3-1.269642451250142d+0*t296*t64*(6.563527649164527d-2
     3           *t284*t482*t82+8.751370198886037d-2*t285*t481*t82+7.876
     4           233178997433d-1*t65*(6.563527649164527d-2*t284*t482*t81
     5           +8.751370198886037d-2*t285*t481*t81+2.601716490612924d-
     6           3*t480)-2.625411059665811d-1*t285*t286*t297)-4.23214150
     7           416714d-1*t286*t296*t298*t65
              t489 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t295*t488
     1           *t87+3.37738d-2*t486*t487*t87-1.0359398963604977d-3*t47
     2           9*t86+1.709920934161365d+0*(6.21814d-2*t290*t485*t80-6.
     3           21814d-2*t483*t484*t80+3.663697685584584d-3*t479*t79+3.
     4           10907d-2*t289**2*t73/t70**2-3.10907d-2*t281*(-1.4107138
     5           347223802d-1*t481*t65*t69-3.52678458680595d-2*t284*t285
     6           *t69+2.539284902500284d+0*t288**2*t64/t68**3-1.26964245
     7           1250142d+0*t282*t64*(6.563527649164527d-2*t284*t482*t67
     8           +8.751370198886037d-2*t285*t481*t67+7.876233178997433d-
     9           1*t65*(6.563527649164527d-2*t284*t482*t66+8.75137019888
     :           6037d-2*t285*t481*t66+3.0144339229749983d-3*t480)-2.625
     ;           411059665811d-1*t285*t286*t287)-4.23214150416714d-1*t28
     <           2*t286*t288*t65)*t73-1.7613865241785687d-3*t479*t71-5.4
     =           95546528376876d-3*t280*t290*t294+2.642079786267853d-3*t
     >           280*t281*t289)+1.5539098445407465d-3*t280*t295*t299)+3.
     ?           37738d-2*t295*t488*t87-3.37738d-2*t486*t487*t87+1.03593
     @           98963604977d-3*t479*t86-1.5539098445407465d-3*t280*t295
     1           *t299)-6.21814d-2*t290*t485*t80+6.21814d-2*t483*t484*t8
     2           0-3.663697685584584d-3*t479*t79+5.495546528376876d-3*t2
     3           80*t290*t294
              t490 = 1/t89**4.0d+0
              t491 = rhob**1.6666666666666674d-1
              t492 = t300**2
              t493 = exp(-1.2865587377165935d+2*t88)
              t494 = 7.157929307165395d-47*rhob*t492*t493*t90/t92**3
              t495 = 7.063224217674173d-50*t283*t490*t93
              t496 = -4.372472134750679d-50*t302*t491*t93
              t497 = -2.5963579524857594d-48*t300*t302*t305*t89*t91
              t498 = 1.1127248367796111d-48*t300*t305*t90*t91
              t499 = -3.5789646535826974d-47*rhob*t305*t492*t90*t91
              t500 = 5.563624183898056d-49*rhob*t305*t489*t90*t91
              t501 = 5.848223622634648d-1*t134*(8.549604670806825d-1*t41
     1           1*t475+8.549604670806825d-1*t412*t474+2.564881401242048
     2           d+0*t247*t473+2.564881401242048d+0*t246*t472)+5.8482236
     3           22634648d-1*t116*(t410+t408+t407+t406+t405+t404+t403+t4
     4           01+32*t133*t242*t244-8*t125*t240*t244)+t398+t396+t395+t
     5           390+1.1696447245269297d+0*t315*t316
              t502 = t318**2
              t503 = -1.111111111111111d-1*t415*t475-1.111111111111111d-
     1           1*t416*t474+3.333333333333333d-1*t252*t473+3.3333333333
     2           33333d-1*t251*t472
              t504 = 8.172647331405554d-1*t141*t147*t150*t502*t58
              t505 = -2.7242157771351844d-1*t141*t144*t147*t503*t58
              t506 = 1.2713006959964196d+0*t144*t147*t254*t255*t318*t58
              t507 = -2.1793726217081477d-50*t141*t144*t147*t318
              t508 = -2.542601391992839d-50*t143*t147*t254*t255
              t509 = 9.649190532874448d+1*t135*t150*t503-3.8596762131497
     1           79d+2*t135*t264*t502-3.216396844291483d+1*t144*t501+1.9
     2           298381065748896d+2*t150*t317*t318
              t510 = -1.3621078885675922d-1*t141*t143*t145*t259*t509*t58
              t511 = 5.448431554270369d-1*t141*t144*t145*t259*t318*t321*
     1           t58
              t512 = 6.356503479982097d-1*t143*t145*t254*t255*t259*t321*
     1           t58
              t513 = -1.0896863108540739d-50*t141*t143*t145*t259*t321
              t514 = t321**2
              t515 = 2.7242157771351844d-1*t141*t143*t431*t432*t514*t58
              t516 = -1.3621078885675922d-1*t141*t143*t145*t259*t514*t58
              t517 = t272**2
              t518 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2*
     1           t301*(1.7297691961651035d-50*rhob*t311**2*t90*t95/t99**
     2           3-8.648845980825518d-51*rhob*t308*t90*t95*(1.4960507360
     3           008343d-100*rhob*(8.166666666666668d+0*t283*t490-5.0555
     4           55555555556d+0*t302*t491)*t90*t98+1.4960507360008343d-1
     5           00*t309**2*t98+1.857234843579318d-96*t492*t493*t97/t92*
     6           *4.0d+0-6.19078281193106d-97*t310*t492*t91*t97+9.623785
     7           732346068d-99*t310*t489*t91*t97+1.9247571464692137d-98*
     8           t300*t309*t310*t91*t96+1.9247571464692137d-98*rhob*t300
     9           *t309*t310*t90*t91+t500+t499+t498+t497+t496+t495+t494)-
     :           1.7297691961651035d-50*t308*t311*t90*t95+4.036128124385
     ;           242d-50*t302*t308*t311*t89*t95-4.372472134750679d-50*t1
     <           00*t302*t491*t95+7.063224217674173d-50*t100*t283*t490*t
     =           95+8.648845980825518d-51*rhob*t100*(t500+t499+t498+t497
     >           +t496+t495+t494)*t90-1.7297691961651035d-50*rhob*t307*t
     ?           308*t311*t90+1.7297691961651035d-50*t100*t307*t90-4.036
     @           128124385242d-50*t100*t302*t307*t89)+1.0d+0*t489-1.5545
     1           345434827443d-2*t312**2/t101**2)+t158*(1.5625d-2*t477*t
     2           56*t62-6.25d-2*t177*t47*t476*t62+3.125d-1*t371*t47*t471
     3           *t62-1.25d-1*t177*t277*t278*t62+3.125d-2*t272*t278*t56*
     4           t61-1.25d-1*t177*t272*t277*t47*t61+3.125d-2*t42*t47*t47
     5           0*t56*t58*t60+3.125d-2*t272*t278*t42*t56*t58*t60-1.25d-
     6           1*t177*t272*t277*t42*t47*t58*t60+3.125d-2*t47*t517*t56)
     7           -3.125d-2*t313*t42*t57*t62+3.125d-2*rhob*t164*t313*t57*
     8           t62+3.125d-2*t102*t164*t57*t62-1.5625d-2*rhoa*t41*t42*t
     9           478*t62-1.5625d-2*rhob*t102*t42*t478*t62-3.125d-2*rhob*
     :           t279*t313*t42*t62-3.125d-2*t102*t279*t42*t62+3.125d-2*r
     ;           hoa*t164*t279*t41*t62+3.125d-2*rhob*t102*t164*t279*t62-
     <           3.125d-2*rhob*t272*t313*t42*t57*t61-3.125d-2*t102*t272*
     =           t42*t57*t61-3.125d-2*rhoa*t272*t279*t41*t42*t61-3.125d-
     >           2*rhob*t102*t272*t279*t42*t61-3.125d-2*rhoa*t164*t41*t4
     ?           70*t57*t58*t60-3.125d-2*rhob*t102*t164*t470*t57*t58*t60
     @           -3.125d-2*rhob*t164*t272*t313*t57*t58*t60-3.125d-2*t102
     1           *t164*t272*t57*t58*t60-3.125d-2*rhoa*t164*t272*t279*t41
     2           *t58*t60-3.125d-2*rhob*t102*t164*t272*t279*t58*t60+t159
     3           *(3.109069086965489d-2*t139*t250*(-1.3621078885675922d-
     4           1*t141*t143*t149*t263*t58*(3.710675800196128d-2*t141*t1
     5           50*t153*t58*(-3.8888888888888906d-1*t255*t420*t58+8.166
     6           666666666668d+0*t335*t418*t58-1.866666666666667d-49*t25
     7           4*t255)-7.421351600392256d-2*t141*t145*t150*t265*t321*t
     8           324*t58-1.4842703200784513d-1*t141*t153*t264*t318*t324*
     9           t58+t516+t515+1.1132027400588385d-1*t150*t152*t431*t440
     :           *t514-3.710675800196128d-2*t145*t150*t152*t265*t514+t51
     ;           3+t512+t511+t510-3.710675800196128d-2*t145*t150*t152*t2
     <           65*t509+t508+t507+t506+t505+t504-7.421351600392256d-2*t
     =           152*t153*t264*t503+3.710675800196128d-1*t152*t153*t439*
     >           t502+t426+t425+3.710675800196128d-2*t150*t153*t324**2-7
     ?           .421351600392256d-2*t145*t150*t151*t265*t321*t324-1.484
     @           2703200784513d-1*t151*t153*t264*t318*t324+2.96854064015
     1           69026d-1*t145*t152*t264*t265*t318*t321)+1.3621078885675
     2           922d-1*t141*t143*t155*(t516+t515+t513+t512+t511+t510+t5
     3           08+t507+t506+t505+t504+t426+t425)*t58-2.724215777135184
     4           4d-1*t141*t144*t149*t155*t503*t58+8.172647331405554d-1*
     5           t141*t149*t150*t155*t502*t58+2.7242157771351844d-1*t141
     6           *t143*t149*t325**2*t441*t58-2.7242157771351844d-1*t141*
     7           t143*t263*t323*t325*t58+5.448431554270369d-1*t141*t144*
     8           t149*t263*t318*t325*t58+6.356503479982097d-1*t143*t149*
     9           t254*t255*t263*t325*t58-5.448431554270369d-1*t141*t144*
     :           t155*t318*t323*t58-6.356503479982097d-1*t143*t155*t254*
     ;           t255*t323*t58+1.2713006959964196d+0*t144*t149*t155*t254
     <           *t255*t318*t58+t421+t419-1.0896863108540739d-50*t141*t1
     =           43*t149*t263*t325+1.0896863108540739d-50*t141*t143*t155
     >           *t323-2.1793726217081477d-50*t141*t144*t149*t155*t318-2
     ?           .542601391992839d-50*t143*t149*t155*t254*t255)+9.327207
     @           260896466d-2*t142*t157*t503+1.8654414521792934d-1*t138*
     1           t157*t502+1.0d+0*t501-3.109069086965489d-2*t139*t326**2
     2           *t442+1.8654414521792934d-1*t142*t250*t318*t326)-3.125d
     3           -2*rhoa*t41*t42*t517*t57-3.125d-2*rhob*t102*t42*t517*t5
     4           7+t448+t447+t446+t445+t387+t343+2*t314*t327
              t519 = 1/t1**6.666666666666667d+0
              t520 = 3.125d-2*rhoa*t163*t41*t57*t60*t61
              t521 = 3.125d-2*rhob*t102*t163*t57*t60*t61
              t522 = -8.162866557885502d-4*rhoa*t177*t382*t41*t47*t51*t5
     1           2*t62
              t523 = -3.482823064697814d-2*t174*t51*t52
              t524 = t523+1.3060586492616802d-2*t173*t48*t52+2.612117298
     1           5233604d-2*t167*t48*t49*t51
              t525 = -4.0d+0*t177*t47*t524+2.6121172985233604d-1*t176*t3
     1           71*t47*t48*t51*t52-5.224234597046721d-2*t177*t180*t48*t
     2           51*t52
              t526 = 2.4289602241917876d-4*rhoa*t164*t203*t332*t57*t62
              t527 = -5.045160155481552d-1*t204*t205*t32
              t528 = 1.3909060459745137d+1*t202*t207*t29*t30
              t529 = -8.162866557885502d-4*rhob*t102*t177*t382*t47*t51*t
     1           52*t62
              t530 = 1/t1**5.666666666666667d+0
              t531 = 3.1782517399910487d-1*t143*t149*t254*t255*t263*t334
     1           *t58
              t532 = -3.1782517399910487d-1*t143*t149*t155*t254*t255
              t533 = -4.3291217668954834d-2*t147*t150*t155*t254*t436*t58
              t534 = -2.7242157771351844d-1*t141*t144*t147*t253
              t535 = -3.1782517399910487d-1*t143*t147*t254*t255
              t536 = -1.3621078885675922d-1*t141*t143*t145*t259*t260
              t537 = t158*(-6.25d-2*t177*t47*t524*t62+4.0814332789427504
     1           d-3*t176*t371*t47*t48*t51*t52*t62-8.162866557885502d-4*
     2           t177*t180*t48*t51*t52*t62+3.125d-2*t180*t42*t56*t60*t61
     3           -1.25d-1*t176*t177*t42*t47*t60*t61-6.25d-2*t163*t339*t4
     4           7*t56*t58+1.6325733115771002d-3*t177*t339*t342*t47*t51*
     5           t52*t530)-1.5625d-2*rhoa*t42*(1.5545345434827443d-2*t20
     6           3*(-2.1622114952063792d-1*gammaaa*t210*t29*t34*(t528+t5
     7           27-4.363481313335766d-1*gammaaa*t204*t367*t37+1.2029732
     8           165432584d+1*t202*t211*t29*t30*t35)+2.1622114952063792d
     9           -1*gammaaa*t29*t39*(t528+t527)-1.0908703283339415d-1*ga
     :           mmaaa*t204*t32*t367*t39-5.045160155481552d-1*t204*t205*
     ;           t34*t39+2.1622114952063792d-1*t209*t29*t39+4.3244229904
     <           127585d-1*gammaaa*t212*t29*t330*t34*t368+5.045160155481
     =           552d-1*gammaaa*t204*t205*t210*t330*t34-2.16221149520637
     >           92d-1*t210*t212*t29*t34-4.675158550002606d-2*gammaaa*t2
     ?           10*t212*t32*t331-2.1622114952063792d-1*gammaaa*t209*t21
     @           0*t29*t330)-1.5545345434827443d-2*t213*t332*t369)*t57*t
     1           62-2.4289602241917876d-4*t203*t332*t42*t57*t62-1.5625d-
     2           2*rhoa*t41*t42*t525*t62-1.5625d-2*rhob*t102*t42*t525*t6
     3           2+8.162866557885502d-4*t174*t177*t41*t47*t51*t52*t62+8.
     4           162866557885502d-4*rhoa*t174*t177*t214*t47*t51*t52*t62-
     5           2.4289602241917876d-4*rhoa*t181*t203*t332*t42*t62-3.125
     6           d-2*t164*t41*t57*t60*t61-3.125d-2*rhoa*t164*t214*t57*t6
     7           0*t61-3.125d-2*rhoa*t164*t181*t41*t60*t61-3.125d-2*rhob
     8           *t102*t164*t181*t60*t61+t159*(3.109069086965489d-2*t139
     9           *t250*(-1.3621078885675922d-1*t141*t143*t149*t263*t58*(
     :           -1.7316487067581932d-1*t150*t153*t254*t436*t58+t536+t53
     ;           5+t534-7.421351600392256d-2*t141*t145*t150*t151*t260*t2
     <           65-1.4842703200784513d-1*t141*t151*t153*t253*t264)+1.36
     =           21078885675922d-1*t141*t143*t155*(t536+t535+t534)*t58+2
     >           .7242157771351844d-1*t141*t143*t149*t266*t334*t441*t58-
     ?           1.855337900098064d-2*t147*t150*t263*t266*t335*t58-3.710
     @           675800196128d-2*t147*t155*t253*t264*t335*t58-1.36210788
     1           85675922d-1*t141*t143*t262*t263*t334*t58+2.724215777135
     2           1844d-1*t141*t144*t149*t253*t263*t334*t58+t533+t532+t53
     3           1-1.3621078885675922d-1*t141*t143*t149*t263*t266+1.3621
     4           078885675922d-1*t141*t143*t155*t262-2.7242157771351844d
     5           -1*t141*t144*t149*t155*t253)-3.109069086965489d-2*t139*
     6           t267*t336*t442+9.327207260896466d-2*t142*t250*t253*t336
     7           )+6.25d-2*rhoa*t125*t339*t41*t57*t58+6.25d-2*rhob*t102*
     8           t125*t339*t57*t58+4.8579204483835753d-4*rhoa*t125*t203*
     9           t332*t339*t342*t57+t529+t526+t522+t521+t520-1.632573311
     :           5771002d-3*rhoa*t177*t339*t342*t41*t47*t51*t519*t52-1.6
     ;           325733115771002d-3*rhob*t102*t177*t339*t342*t47*t51*t51
     <           9*t52+3.109069086965489d-2*t139*t216*t250*t336+t268*t33
     =           3
              t538 = -1.6406249999999997d-2*t160*t164*t60*t62
              t539 = 1.0d+0*t160*t338*wght
              t540 = 1.0d+0*t162*t337*wght
              t541 = t523+1.3060586492616802d-2*t276*t48*t52+2.612117298
     1           5233604d-2*t273*t48*t49*t51
              t542 = -4.0d+0*t177*t47*t541+2.6121172985233604d-1*t277*t3
     1           71*t47*t48*t51*t52-5.224234597046721d-2*t177*t278*t48*t
     2           51*t52
              t543 = -2.7242157771351844d-1*t141*t144*t147*t318
              t544 = -1.3621078885675922d-1*t141*t143*t145*t259*t321
              t545 = t158*(-6.25d-2*t177*t47*t541*t62+4.0814332789427504
     1           d-3*t277*t371*t47*t48*t51*t52*t62-8.162866557885502d-4*
     2           t177*t278*t48*t51*t52*t62+3.125d-2*t278*t42*t56*t60*t61
     3           -1.25d-1*t177*t277*t42*t47*t60*t61-1.6325733115771002d-
     4           3*t174*t177*t272*t47*t51*t52*t58*t60+3.125d-2*t272*t42*
     5           t47*t56*t60-3.125d-2*t163*t339*t47*t56*t58)-1.5625d-2*r
     6           hoa*t41*t42*t542*t62-1.5625d-2*rhob*t102*t42*t542*t62+8
     7           .162866557885502d-4*rhob*t174*t177*t313*t47*t51*t52*t62
     8           +8.162866557885502d-4*t102*t174*t177*t47*t51*t52*t62-2.
     9           4289602241917876d-4*rhoa*t203*t279*t332*t42*t62-3.125d-
     :           2*rhob*t164*t313*t57*t60*t61-3.125d-2*t102*t164*t57*t60
     ;           *t61-3.125d-2*rhoa*t164*t279*t41*t60*t61-3.125d-2*rhob*
     <           t102*t164*t279*t60*t61-4.8579204483835753d-4*rhoa*t164*
     =           t203*t272*t332*t57*t58*t60+1.6325733115771002d-3*rhoa*t
     >           177*t272*t382*t41*t47*t51*t52*t58*t60+1.632573311577100
     ?           2d-3*rhob*t102*t177*t272*t382*t47*t51*t52*t58*t60-3.125
     @           d-2*rhoa*t164*t272*t41*t57*t60-3.125d-2*rhob*t102*t164*
     1           t272*t57*t60+t159*(3.109069086965489d-2*t139*t250*(-1.3
     2           621078885675922d-1*t141*t143*t149*t263*t58*(-8.65824353
     3           3790966d-2*t150*t153*t254*t436*t58+t544+t543+t535+3.710
     4           675800196128d-2*t141*t150*t153*t324-7.421351600392256d-
     5           2*t141*t145*t150*t151*t265*t321-1.4842703200784513d-1*t
     6           141*t151*t153*t264*t318)+1.3621078885675922d-1*t141*t14
     7           3*t155*(t544+t543+t535)*t58+2.7242157771351844d-1*t141*
     8           t143*t149*t325*t334*t441*t58-1.855337900098064d-2*t147*
     9           t150*t263*t325*t335*t58-3.710675800196128d-2*t147*t155*
     :           t264*t318*t335*t58-1.3621078885675922d-1*t141*t143*t263
     ;           *t323*t334*t58+2.7242157771351844d-1*t141*t144*t149*t26
     <           3*t318*t334*t58+t533+t532+t531+7.421351600392257d-52*t1
     =           47*t150*t155*t335-5.44843155427037d-51*t141*t143*t149*t
     >           263*t334-1.3621078885675922d-1*t141*t143*t149*t263*t325
     ?           +1.3621078885675922d-1*t141*t143*t155*t323-2.7242157771
     @           351844d-1*t141*t144*t149*t155*t318)-3.109069086965489d-
     1           2*t139*t326*t336*t442+9.327207260896466d-2*t142*t250*t3
     2           18*t336)+3.125d-2*rhoa*t125*t339*t41*t57*t58+3.125d-2*r
     3           hob*t102*t125*t339*t57*t58+t529+t526+t522+t521+t520+3.1
     4           09069086965489d-2*t139*t250*t314*t336+t327*t333
              t546 = 1/t1**6.333333333333333d+0
              t547 = t49**4
              t548 = t51**2
              t549 = t158*(5.330591235347639d-5*t371*t47*t547*t548*t62/t
     1           1**5.333333333333333d+0-1.6325733115771002d-3*t174*t177
     2           *t47*t51*t52*t60*t61-1.6325733115771002d-3*t177*t339*t3
     3           82*t47*t51*t52*t58+3.125d-2*t164*t339*t47*t56)-2.428960
     4           2241917876d-4*rhoa*t203*(9.350317100005212d-2*t32*t331*
     5           t39-2.0217363117456047d-2*gammaaa*t210*t34*t366*t37+4.3
     6           244229904127585d-1*gammaaa*t29*t330**2*t34*t368-4.32442
     7           29904127585d-1*t210*t29*t330*t34-9.350317100005212d-2*g
     8           ammaaa*t210*t32*t330*t331)*t42*t57*t62+2.42896022419178
     9           76d-4*rhoa*t332**2*t369*t42*t57*t62-5.330591235347639d-
     :           5*rhoa*t371*t41*t47*t546*t547*t548*t62-5.33059123534763
     ;           9d-5*rhob*t102*t371*t47*t546*t547*t548*t62+2.5378916076
     <           146196d-5*rhoa*t174*t177*t203*t332*t47*t51*t52*t62-4.85
     =           79204483835753d-4*rhoa*t164*t203*t332*t57*t60*t61+1.632
     >           5733115771002d-3*rhoa*t177*t382*t41*t47*t51*t52*t60*t61
     ?           +1.6325733115771002d-3*rhob*t102*t177*t382*t47*t51*t52*
     @           t60*t61+3.109069086965489d-2*t139*t159*t250*(2.72421577
     1           71351844d-1*t141*t143*t149*t334**2*t441*t58-5.054340779
     2           364009d-3*t149*t153*t263*t437*t439*t58-3.71067580019612
     3           8d-2*t147*t150*t263*t334*t335*t58+3.710675800196128d-2*
     4           t147*t150*t155*t335-2.7242157771351844d-1*t141*t143*t14
     5           9*t263*t334)-4.8579204483835753d-4*rhoa*t163*t203*t332*
     6           t339*t57*t58+1.6325733115771002d-3*rhoa*t177*t339*t41*t
     7           47*t51*t52*t530*t58+1.6325733115771002d-3*rhob*t102*t17
     8           7*t339*t47*t51*t52*t530*t58-3.125d-2*rhoa*t163*t339*t41
     9           *t57-3.125d-2*rhob*t102*t163*t339*t57-3.109069086965489
     :           d-2*t139*t159*t336**2*t442+6.218138173930978d-2*t139*t2
     ;           50*t333*t336
              t550 = 1/t59**3
              t551 = -3.125d-2*rhoa*t163*t339*t41*t57*t58*t61
              t552 = -3.125d-2*rhob*t102*t163*t339*t57*t58*t61
              t553 = t158*(-3.125d-2*t180*t339*t42*t56*t58*t61+1.25d-1*t
     1           176*t177*t339*t42*t47*t58*t61+6.25d-2*t163*t342*t47*t55
     2           0*t56)+3.125d-2*t164*t339*t41*t57*t58*t61+3.125d-2*rhoa
     3           *t164*t214*t339*t57*t58*t61-3.125d-2*t268*t339*t42*t47*
     4           t56*t58*t61+3.125d-2*rhoa*t164*t181*t339*t41*t58*t61+3.
     5           125d-2*rhob*t102*t164*t181*t339*t58*t61-6.25d-2*rhoa*t1
     6           25*t342*t41*t550*t57-6.25d-2*rhob*t102*t125*t342*t550*t
     7           57+t552+t551
              t554 = 1.0d+0*t160*t341*wght
              t555 = 1.0d+0*t162*t340*wght
              t556 = t164*t339*t58-4.0d-50*t339*t42
              t557 = t158*(-3.125d-2*t278*t339*t42*t56*t58*t61+1.25d-1*t
     1           177*t277*t339*t42*t47*t58*t61+3.125d-2*t42*t47*t556*t56
     2           *t58*t60-3.125d-2*t272*t339*t42*t47*t56*t58)+3.125d-2*r
     3           hob*t164*t313*t339*t57*t58*t61+3.125d-2*t102*t164*t339*
     4           t57*t58*t61-3.125d-2*t327*t339*t42*t47*t56*t58*t61+3.12
     5           5d-2*rhoa*t164*t279*t339*t41*t58*t61+3.125d-2*rhob*t102
     6           *t164*t279*t339*t58*t61-3.125d-2*rhoa*t164*t41*t556*t57
     7           *t58*t60-3.125d-2*rhob*t102*t164*t556*t57*t58*t60+3.125
     8           d-2*rhoa*t164*t272*t339*t41*t57*t58+3.125d-2*rhob*t102*
     9           t164*t272*t339*t57*t58+t552+t551
              t558 = t158*(1.6325733115771002d-3*t174*t177*t339*t47*t51*
     1           t52*t58*t61-6.25d-2*t164*t47*t550*t56*t58)+4.8579204483
     2           835753d-4*rhoa*t164*t203*t332*t339*t57*t58*t61-9.715840
     3           896767153d-4*t139*t250*t336*t339*t42*t47*t56*t58*t61-1.
     4           6325733115771002d-3*rhoa*t177*t339*t382*t41*t47*t51*t52
     5           *t58*t61-1.6325733115771002d-3*rhob*t102*t177*t339*t382
     6           *t47*t51*t52*t58*t61+6.25d-2*rhoa*t163*t41*t550*t57*t58
     7           +6.25d-2*rhob*t102*t163*t550*t57*t58
              t559 = 1/t59**4
              t560 = -9.375d-2*rhoa*t163*t342*t41*t559*t57-9.375d-2*rhob
     1           *t102*t163*t342*t559*t57+9.375d-2*t158*t164*t342*t47*t5
     2           59*t56
              fnc(iq) = 1.0d+0*t1*t160*t162*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t160*t270*wght+1.0d+0*t1*t162*t
     1           269*wght+t271+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t160*t329*wght+1.0d+0*t1*t162*t
     1           328*wght+t271+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = 1.0d+0*t1*t160*t338*wght+1.0d+0*t1*t162*
     1           t337*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = 1.0d+0*t1*t160*t341*wght+1.0d+0*t1*t162*t
     1           340*wght+Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 1.0d+0*t1*t160*(-3.2812499999999994d-
     1           2*t164*t269*t58*t60*t62+3.2812499999999994d-2*t125*t160
     2           *t339*t342*t61+t444+5.46875d-3*t161*t443)*wght+1.0d+0*t
     3           1*t162*t443*wght+2.0d+0*t1*t269*t270*wght+2.0d+0*t160*t
     4           270*wght+2.0d+0*t162*t269*wght+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = 1.0d+0*t1*t160*(-1.6406249999999997d-
     1           2*t164*t328*t58*t60*t62-6.562499999999999d-52*t160*t164
     2           *t60*t62+1.6406249999999997d-2*t269*t272*t62-3.28124999
     3           99999994d-2*t160*t164*t272*t58*t60*t61+5.46875d-3*t161*
     4           t469+t444)*wght+1.0d+0*t1*t162*t469*wght+1.0d+0*t1*t269
     5           *t329*wght+1.0d+0*t160*t329*wght+1.0d+0*t1*t270*t328*wg
     6           ht+1.0d+0*t162*t328*wght+1.0d+0*t160*t270*wght+1.0d+0*t
     7           162*t269*wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t160*(1.6406249999999997d-2
     1           *t160*t470*t62+3.2812499999999994d-2*t272*t328*t62+3.28
     2           12499999999994d-2*t160*t517*t61+5.46875d-3*t161*t518)*w
     3           ght+1.0d+0*t1*t162*t518*wght+2.0d+0*t1*t328*t329*wght+2
     4           .0d+0*t160*t329*wght+2.0d+0*t162*t328*wght+Amat2(iq,D2_
     5           RB_RB)
              Cmat2(iq,D2_RA_GAA) = 1.0d+0*t1*t160*(-1.6406249999999997d
     1           -2*t164*t337*t58*t60*t62+1.6406249999999997d-2*t269*t42
     2           *t60*t62-3.2812499999999994d-2*t160*t163*t339*t58*t61+t
     3           538+5.46875d-3*t161*t537)*wght+1.0d+0*t1*t162*t537*wght
     4           +1.0d+0*t1*t269*t338*wght+1.0d+0*t1*t270*t337*wght+t540
     5           +t539+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = 1.0d+0*t1*t160*(1.6406249999999997d-
     1           2*t328*t42*t60*t62+1.6406249999999997d-2*t272*t337*t62+
     2           3.2812499999999994d-2*t160*t272*t42*t60*t61+5.46875d-3*
     3           t161*t545+t538)*wght+1.0d+0*t1*t162*t545*wght+1.0d+0*t1
     4           *t328*t338*wght+1.0d+0*t1*t329*t337*wght+t540+t539+Cmat
     5           2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = 1.0d+0*t1*t160*(3.2812499999999994d
     1           -2*t337*t42*t60*t62+3.2812499999999994d-2*t160*t164*t33
     2           9*t61+5.46875d-3*t161*t549)*wght+1.0d+0*t1*t162*t549*wg
     3           ht+2.0d+0*t1*t337*t338*wght+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = 1.0d+0*t1*t160*(-1.6406249999999997d-
     1           2*t164*t340*t58*t60*t62-1.6406249999999997d-2*t269*t339
     2           *t42*t58*t62+1.6406249999999997d-2*t160*t164*t339*t58*t
     3           62+3.2812499999999994d-2*t160*t163*t342*t550*t61+5.4687
     4           5d-3*t161*t553)*wght+1.0d+0*t1*t162*t553*wght+1.0d+0*t1
     5           *t269*t341*wght+1.0d+0*t1*t270*t340*wght+t555+t554+Mmat
     6           2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = 1.0d+0*t1*t160*(-1.6406249999999997d-
     1           2*t328*t339*t42*t58*t62+1.6406249999999997d-2*t160*t556
     2           *t62+1.6406249999999997d-2*t272*t340*t62-3.281249999999
     3           9994d-2*t160*t272*t339*t42*t58*t61+5.46875d-3*t161*t557
     4           )*wght+1.0d+0*t1*t162*t557*wght+1.0d+0*t1*t328*t341*wgh
     5           t+1.0d+0*t1*t329*t340*wght+t555+t554+Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = 1.0d+0*t1*t160*(1.6406249999999997d-
     1           2*t340*t42*t60*t62-1.6406249999999997d-2*t337*t339*t42*
     2           t58*t62-1.6406249999999997d-2*t160*t339*t42*t62-3.28124
     3           99999999994d-2*t160*t164*t550*t58*t61+5.46875d-3*t161*t
     4           558)*wght+1.0d+0*t1*t162*t558*wght+1.0d+0*t1*t337*t341*
     5           wght+1.0d+0*t1*t338*t340*wght+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = 1.0d+0*t1*t160*(3.2812499999999994d-2
     1           *t160*t42*t550*t58*t62-3.2812499999999994d-2*t339*t340*
     2           t42*t58*t62+3.2812499999999994d-2*t160*t164*t342*t559*t
     3           61+5.46875d-3*t161*t560)*wght+1.0d+0*t1*t162*t560*wght+
     4           2.0d+0*t1*t340*t341*wght+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 8.648845980825518d-51*rhoa*t29*t32
              t34 = t33+1.0d+0
              t35 = rhoa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 7.480253680004171d-101*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 8.648845980825518d-51*rhoa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = rhoa-rhob
              t44 = t42*t43
              t45 = t44**2.0d+0
              t46 = t44**4.0d+0
              t47 = 5.0d-1*t46+8.7d-1*t45+2.2599999999999998d+0*t44**6.0
     1           d+0+5.3d-1
              t48 = 1/t1**2.6666666666666666d+0
              t49 = 1.0d+0-t42*t43
              t50 = t44+1.0d+0
              t51 = 1/t50**1.333333333333333d+0+1/t49**1.333333333333333
     1           d+0
              t52 = t49**2
              t53 = t50**2
              t54 = gammabb*t53+4.0d-50*rhoa*t52
              t55 = 1.3060586492616802d-2*t48*t51*t54+1.0d+0
              t56 = 1/t55**4.0d+0
              t57 = t47*t56+1.0d+0
              t58 = 4.0d-50*rhoa+gammabb
              t59 = taub+1.0d-50
              t60 = 1/t59
              t61 = t42*t58*t60
              t62 = t61**2.0d+0
              t63 = rhob**3.333333333333333d-1
              t64 = t63**5.0d-1
              t65 = 1/t64
              t66 = 1.530901310039024d-2*t65+1.0465751434d-1
              t67 = 7.876233178997433d-1*t65*t66+1.9269083139d-1
              t68 = 7.876233178997433d-1*t65*t67+4.3896648423d-1
              t69 = 1/t68
              t70 = 1.269642451250142d+0*t64*t69+1.0d+0
              t71 = log(t70)
              t72 = 1/t63
              t73 = 1.2746961887000874d-1*t72+1.0d+0
              t74 = 2.4141993114533214d-2*t65+1.0186556948d-1
              t75 = 7.876233178997433d-1*t65*t74+2.2308199064d-1
              t76 = 7.876233178997433d-1*t65*t75+4.7231125998d-1
              t77 = 1/t76
              t78 = 1.269642451250142d+0*t64*t77+1.0d+0
              t79 = log(t78)
              t80 = 1.325688999052018d-1*t72+1.0d+0
              t81 = 1.3212998810398843d-2*t65+2.9729725188d-2
              t82 = 7.876233178997433d-1*t65*t81+1.2236585478d-1
              t83 = 7.876233178997433d-1*t65*t82+3.497952466d-1
              t84 = 1/t83
              t85 = 1.269642451250142d+0*t64*t84+1.0d+0
              t86 = log(t85)
              t87 = 6.901399211255826d-2*t72+1.0d+0
              t88 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t79*t80-3.10907d-2*t71*t73)-3.37738d-2*t86*t
     2           87)+3.37738d-2*t86*t87)-6.21814d-2*t79*t80
              t89 = rhob**1.1666666666666667d+0
              t90 = 1/t89**2.0d+0
              t91 = exp(-6.432793688582967d+1*t88)
              t92 = t91-1.0d+0
              t93 = 1/t92
              t94 = 2.1622114952063792d-1*gammabb*t90*t93
              t95 = t94+1.0d+0
              t96 = gammabb*t90
              t97 = t96**2.0d+0
              t98 = 1/t92**2.0d+0
              t99 = 4.675158550002606d-2*t97*t98+t94+1.0d+0
              t100 = 1/t99
              t101 = 2.1622114952063792d-1*gammabb*t100*t90*t95+1.0d+0
              t102 = 1.0d+0*t88+1.5545345434827443d-2*log(t101)
              t103 = t1**3.333333333333333d-1
              t104 = 1/t103
              t105 = 1.325688999052018d-1*t104+1.0d+0
              t106 = t103**5.0d-1
              t107 = 1/t106
              t108 = 2.4141993114533214d-2*t107+1.0186556948d-1
              t109 = 7.876233178997433d-1*t107*t108+2.2308199064d-1
              t110 = 7.876233178997433d-1*t107*t109+4.7231125998d-1
              t111 = 1/t110
              t112 = 1.269642451250142d+0*t106*t111+1.0d+0
              t113 = log(t112)
              t114 = t49**1.3333333333333333d+0
              t115 = t50**1.3333333333333333d+0
              t116 = 1.923661050931536d+0*t115+1.923661050931536d+0*t114
     1           -3.847322101863072d+0
              t117 = 6.901399211255826d-2*t104+1.0d+0
              t118 = 1.3212998810398843d-2*t107+2.9729725188d-2
              t119 = 7.876233178997433d-1*t107*t118+1.2236585478d-1
              t120 = 7.876233178997433d-1*t107*t119+3.497952466d-1
              t121 = 1/t120
              t122 = 1.269642451250142d+0*t106*t121+1.0d+0
              t123 = log(t122)
              t124 = t43**4
              t125 = 1/t1**4
              t126 = 1.2746961887000874d-1*t104+1.0d+0
              t127 = 1.530901310039024d-2*t107+1.0465751434d-1
              t128 = 7.876233178997433d-1*t107*t127+1.9269083139d-1
              t129 = 7.876233178997433d-1*t107*t128+4.3896648423d-1
              t130 = 1/t129
              t131 = 1.269642451250142d+0*t106*t130+1.0d+0
              t132 = log(t131)
              t133 = 1.709920934161365d+0*(6.21814d-2*t105*t113-3.10907d
     1           -2*t126*t132)-3.37738d-2*t117*t123
              t134 = t124*t125*t133+3.37738d-2*t117*t123
              t135 = 5.848223622634648d-1*t116*t134-6.21814d-2*t105*t113
              t136 = t49**6.666666666666666d-1
              t137 = t50**6.666666666666666d-1
              t138 = 5.0d-1*t137+5.0d-1*t136
              t139 = t138**3.0d+0
              t140 = t1**1.1666666666666667d+0
              t141 = 1/t140**2.0d+0
              t142 = t138**2.0d+0
              t143 = 1/t142
              t144 = 1/t139
              t145 = exp(-3.216396844291483d+1*t135*t144)
              t146 = t145-1.0d+0
              t147 = 1/t146
              t148 = 1.3621078885675922d-1*t141*t143*t147*t58
              t149 = t148+1.0d+0
              t150 = 1/t138**4.0d+0
              t151 = t141*t58
              t152 = t151**2.0d+0
              t153 = 1/t146**2.0d+0
              t154 = 1.855337900098064d-2*t150*t152*t153+t148+1.0d+0
              t155 = 1/t154
              t156 = 1.3621078885675922d-1*t141*t143*t149*t155*t58+1.0d+
     1           0
              t157 = log(t156)
              t158 = 3.109069086965489d-2*t139*t157+1.0d+0*t135
              t159 = 1.5625d-2*t47*t56*t62+1.0d+0
              t160 = -1.5625d-2*rhoa*t41*t42*t57*t62-1.5625d-2*rhob*t102
     1           *t42*t57*t62+t158*t159
              t161 = t61**3.0d+0
              t162 = 5.46875d-3*t160*t161+1.0d+0
              t163 = 1/t1**2
              t164 = 4.0d-50*t42*t60-t163*t58*t60
              t165 = t163*t43
              t166 = -t42
              t167 = t166+t165
              t168 = -t163*t43
              t169 = t42+t168
              t170 = 4.0d-50*t52+2*gammabb*t169*t50+8.0d-50*rhoa*t167*t4
     1           9
              t171 = 1/t49**2.333333333333333d+0
              t172 = 1/t50**2.333333333333333d+0
              t173 = -1.333333333333333d+0*t169*t172-1.333333333333333d+
     1           0*t167*t171
              t174 = 1/t1**3.6666666666666664d+0
              t175 = -3.482823064697814d-2*t174*t51*t54
              t176 = 1.3060586492616802d-2*t173*t48*t54+1.30605864926168
     1           02d-2*t170*t48*t51+t175
              t177 = 1/t55**5.0d+0
              t178 = t44**3.0d+0
              t179 = t44**5.0d+0
              t180 = 1.74d+0*t169*t44+1.356d+1*t169*t179+2.0d+0*t169*t17
     1           8
              t181 = t180*t56-4.0d+0*t176*t177*t47
              t182 = 1.5625d-2*rhoa*t163*t41*t57*t62
              t183 = 1/rhoa**1.3333333333333333d+0
              t184 = 1/t9
              t185 = 1/t7**2
              t186 = rhoa**1.3333333333333336d+0
              t187 = 1/t186
              t188 = 1/t3**3
              t189 = 1/rhoa**6.666666666666667d-1
              t190 = -1.3127055298329054d-1*t188*t189*t5-2.0096226153166
     1           658d-3*t187
              t191 = 7.876233178997433d-1*t190*t4-1.3127055298329054d-1*
     1           t188*t189*t6
              t192 = 2.11607075208357d-1*t189*t4*t8-1.269642451250142d+0
     1           *t185*t191*t3
              t193 = 1/t17
              t194 = 1/t15**2
              t195 = -1.3127055298329054d-1*t13*t188*t189-3.169132786263
     1           567d-3*t187
              t196 = 7.876233178997433d-1*t195*t4-1.3127055298329054d-1*
     1           t14*t188*t189
              t197 = 2.11607075208357d-1*t16*t189*t4-1.269642451250142d+
     1           0*t194*t196*t3
              t198 = 1/t24
              t199 = 1/t22**2
              t200 = -1.3127055298329054d-1*t188*t189*t20-1.734477660408
     1           6162d-3*t187
              t201 = 7.876233178997433d-1*t200*t4-1.3127055298329054d-1*
     1           t188*t189*t21
              t202 = 2.11607075208357d-1*t189*t23*t4-1.269642451250142d+
     1           0*t199*t201*t3
              t203 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t198*t202
     1           *t26+7.769549222703733d-4*t183*t25+1.709920934161365d+0
     2           *(6.21814d-2*t19*t193*t197-3.10907d-2*t12*t184*t192-2.7
     3           47773264188438d-3*t18*t183+1.3210398931339265d-3*t10*t1
     4           83))+3.37738d-2*t198*t202*t26-7.769549222703733d-4*t183
     5           *t25)-6.21814d-2*t19*t193*t197+2.747773264188438d-3*t18
     6           *t183
              t204 = 1/t40
              t205 = 1/t28**3.0d+0
              t206 = -2.018064062192621d-50*t205*t28*t32
              t207 = 8.648845980825518d-51*t29*t32
              t208 = 1/t31**2
              t209 = 5.563624183898056d-49*rhoa*t203*t208*t29*t30
              t210 = t209+t207+t206
              t211 = 1/t38**2
              t212 = t29-2.3333333333333334d+0*t205*t28
              t213 = 1/t31**3.0d+0
              t214 = 1.4960507360008343d-100*t212*t35*t37+9.623785732346
     1           068d-99*t203*t213*t30*t36+t209+t207+t206
              t215 = 8.648845980825518d-51*t29*t34*t39-2.018064062192621
     1           d-50*t205*t28*t34*t39+8.648845980825518d-51*rhoa*t210*t
     2           29*t39-8.648845980825518d-51*rhoa*t211*t214*t29*t34
              t216 = 1.5545345434827443d-2*t204*t215+1.0d+0*t203
              t217 = 1.5625d-2*rhob*t102*t163*t57*t62
              t218 = 1.5625d-2*t180*t56*t62-6.25d-2*t176*t177*t47*t62+3.
     1           125d-2*t164*t47*t56*t61
              t219 = 1/t1**1.3333333333333336d+0
              t220 = 1/t1**6.666666666666667d-1
              t221 = 1/t106**3
              t222 = -1.3127055298329054d-1*t108*t220*t221-3.16913278626
     1           3567d-3*t219
              t223 = 7.876233178997433d-1*t107*t222-1.3127055298329054d-
     1           1*t109*t220*t221
              t224 = 1/t110**2
              t225 = 2.11607075208357d-1*t107*t111*t220-1.26964245125014
     1           2d+0*t106*t223*t224
              t226 = 1/t112
              t227 = -6.21814d-2*t105*t225*t226
              t228 = 1/t1**1.3333333333333333d+0
              t229 = 2.747773264188438d-3*t113*t228
              t230 = -1.3127055298329054d-1*t118*t220*t221-1.73447766040
     1           86162d-3*t219
              t231 = 7.876233178997433d-1*t107*t230-1.3127055298329054d-
     1           1*t119*t220*t221
              t232 = 1/t120**2
              t233 = 2.11607075208357d-1*t107*t121*t220-1.26964245125014
     1           2d+0*t106*t231*t232
              t234 = 1/t122
              t235 = 3.37738d-2*t117*t233*t234
              t236 = -7.769549222703733d-4*t123*t228
              t237 = -1.3127055298329054d-1*t127*t220*t221-2.00962261531
     1           66658d-3*t219
              t238 = 7.876233178997433d-1*t107*t237-1.3127055298329054d-
     1           1*t128*t220*t221
              t239 = 1/t129**2
              t240 = 2.11607075208357d-1*t107*t130*t220-1.26964245125014
     1           2d+0*t106*t238*t239
              t241 = 1/t131
              t242 = 1.709920934161365d+0*(-3.10907d-2*t126*t240*t241+1.
     1           3210398931339265d-3*t132*t228-2.747773264188438d-3*t113
     2           *t228+6.21814d-2*t105*t225*t226)-3.37738d-2*t117*t233*t
     3           234+7.769549222703733d-4*t123*t228
              t243 = t124*t125*t242
              t244 = 1/t1**5
              t245 = -4*t124*t133*t244
              t246 = t43**3
              t247 = 4*t125*t133*t246+t245+t243+t236+t235
              t248 = t49**3.333333333333333d-1
              t249 = t50**3.333333333333333d-1
              t250 = 2.564881401242048d+0*t169*t249+2.564881401242048d+0
     1           *t167*t248
              t251 = 5.848223622634648d-1*t134*t250+5.848223622634648d-1
     1           *t116*t247+t229+t227
              t252 = 1/t156
              t253 = 1/t248
              t254 = 1/t249
              t255 = 3.333333333333333d-1*t169*t254+3.333333333333333d-1
     1           *t167*t253
              t256 = t1**1.6666666666666674d-1
              t257 = 1/t140**3.0d+0
              t258 = -3.1782517399910487d-1*t143*t149*t155*t256*t257*t58
              t259 = -2.7242157771351844d-1*t141*t144*t147*t255*t58
              t260 = -3.1782517399910487d-1*t143*t147*t256*t257*t58
              t261 = 5.44843155427037d-51*t141*t143*t147
              t262 = 1/t146**2
              t263 = 9.649190532874448d+1*t135*t150*t255-3.2163968442914
     1           83d+1*t144*t251
              t264 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t58
              t265 = t264+t261+t260+t259
              t266 = 1/t154**2
              t267 = 4.0d-50*t141-2.3333333333333334d+0*t256*t257*t58
              t268 = 1/t138**5.0d+0
              t269 = 1/t146**3.0d+0
              t270 = -3.710675800196128d-2*t145*t150*t152*t263*t269-7.42
     1           1351600392256d-2*t152*t153*t255*t268+3.710675800196128d
     2           -2*t150*t151*t153*t267+t264+t261+t260+t259
              t271 = -1.3621078885675922d-1*t141*t143*t149*t266*t270*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t265*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t255*t58+t258+5.44843
     3           155427037d-51*t141*t143*t149*t155
              t272 = 3.109069086965489d-2*t139*t252*t271+9.3272072608964
     1           66d-2*t142*t157*t255+1.0d+0*t251
              t273 = -1.5625d-2*t41*t42*t57*t62-1.5625d-2*rhoa*t216*t42*
     1           t57*t62-1.5625d-2*rhoa*t181*t41*t42*t62-1.5625d-2*rhob*
     2           t102*t181*t42*t62-3.125d-2*rhoa*t164*t41*t42*t57*t61-3.
     3           125d-2*rhob*t102*t164*t42*t57*t61+t159*t272+t158*t218+t
     4           217+t182
              t274 = 1.6406249999999997d-2*t160*t164*t62+5.46875d-3*t161
     1           *t273
              t275 = 1.0d+0*t160*t162*wght
              t276 = 1/t1**3
              t277 = t42+t165
              t278 = t168+t166
              t279 = 2*gammabb*t278*t50+8.0d-50*rhoa*t277*t49
              t280 = -1.333333333333333d+0*t172*t278-1.333333333333333d+
     1           0*t171*t277
              t281 = 1.3060586492616802d-2*t280*t48*t54+1.30605864926168
     1           02d-2*t279*t48*t51+t175
              t282 = 1.74d+0*t278*t44+1.356d+1*t179*t278+2.0d+0*t178*t27
     1           8
              t283 = t282*t56-4.0d+0*t177*t281*t47
              t284 = 1/rhob**1.3333333333333333d+0
              t285 = 1/t70
              t286 = 1/t68**2
              t287 = 1/rhob**1.3333333333333336d+0
              t288 = 1/t64**3
              t289 = 1/rhob**6.666666666666667d-1
              t290 = -1.3127055298329054d-1*t288*t289*t66-2.009622615316
     1           6658d-3*t287
              t291 = 7.876233178997433d-1*t290*t65-1.3127055298329054d-1
     1           *t288*t289*t67
              t292 = 2.11607075208357d-1*t289*t65*t69-1.269642451250142d
     1           +0*t286*t291*t64
              t293 = 1/t78
              t294 = 1/t76**2
              t295 = -1.3127055298329054d-1*t288*t289*t74-3.169132786263
     1           567d-3*t287
              t296 = 7.876233178997433d-1*t295*t65-1.3127055298329054d-1
     1           *t288*t289*t75
              t297 = 2.11607075208357d-1*t289*t65*t77-1.269642451250142d
     1           +0*t294*t296*t64
              t298 = 1/t85
              t299 = 1/t83**2
              t300 = -1.3127055298329054d-1*t288*t289*t81-1.734477660408
     1           6162d-3*t287
              t301 = 7.876233178997433d-1*t300*t65-1.3127055298329054d-1
     1           *t288*t289*t82
              t302 = 2.11607075208357d-1*t289*t65*t84-1.269642451250142d
     1           +0*t299*t301*t64
              t303 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t298*t302
     1           *t87+7.769549222703733d-4*t284*t86+1.709920934161365d+0
     2           *(6.21814d-2*t293*t297*t80-2.747773264188438d-3*t284*t7
     3           9-3.10907d-2*t285*t292*t73+1.3210398931339265d-3*t284*t
     4           71))+3.37738d-2*t298*t302*t87-7.769549222703733d-4*t284
     5           *t86)-6.21814d-2*t293*t297*t80+2.747773264188438d-3*t28
     6           4*t79
              t304 = 1/t101
              t305 = rhob**1.6666666666666674d-1
              t306 = 1/t89**3.0d+0
              t307 = -5.045160155481552d-1*gammabb*t305*t306*t93
              t308 = 1/t92**2
              t309 = 1.3909060459745137d+1*gammabb*t303*t308*t90*t91
              t310 = t309+t307
              t311 = 1/t99**2
              t312 = 1/t92**3.0d+0
              t313 = -2.181740656667883d-1*gammabb*t305*t306*t96*t98+6.0
     1           14866082716293d+0*t303*t312*t91*t97+t309+t307
              t314 = -2.1622114952063792d-1*gammabb*t311*t313*t90*t95-5.
     1           045160155481552d-1*gammabb*t100*t305*t306*t95+2.1622114
     2           952063792d-1*gammabb*t100*t310*t90
              t315 = 1.5545345434827443d-2*t304*t314+1.0d+0*t303
              t316 = 1.5625d-2*t282*t56*t62-6.25d-2*t177*t281*t47*t62-3.
     1           125d-2*t163*t47*t56*t58*t60*t61
              t317 = -4*t125*t133*t246+t245+t243+t236+t235
              t318 = 2.564881401242048d+0*t249*t278+2.564881401242048d+0
     1           *t248*t277
              t319 = 5.848223622634648d-1*t134*t318+5.848223622634648d-1
     1           *t116*t317+t229+t227
              t320 = 3.333333333333333d-1*t254*t278+3.333333333333333d-1
     1           *t253*t277
              t321 = -2.7242157771351844d-1*t141*t144*t147*t320*t58
              t322 = 9.649190532874448d+1*t135*t150*t320-3.2163968442914
     1           83d+1*t144*t319
              t323 = -1.3621078885675922d-1*t141*t143*t145*t262*t322*t58
              t324 = t323+t321+t260
              t325 = -8.658243533790966d-2*t150*t151*t153*t256*t257*t58+
     1           t323-3.710675800196128d-2*t145*t150*t152*t269*t322+t321
     2           -7.421351600392256d-2*t152*t153*t268*t320+t260
              t326 = -1.3621078885675922d-1*t141*t143*t149*t266*t325*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t324*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t320*t58+t258
              t327 = 3.109069086965489d-2*t139*t252*t326+9.3272072608964
     1           66d-2*t142*t157*t320+1.0d+0*t319
              t328 = -1.5625d-2*rhob*t315*t42*t57*t62-1.5625d-2*t102*t42
     1           *t57*t62-1.5625d-2*rhoa*t283*t41*t42*t62-1.5625d-2*rhob
     2           *t102*t283*t42*t62+3.125d-2*rhoa*t276*t41*t57*t58*t60*t
     3           61+3.125d-2*rhob*t102*t276*t57*t58*t60*t61+t159*t327+t1
     4           58*t316+t217+t182
              t329 = 5.46875d-3*t161*t328-1.6406249999999997d-2*t160*t16
     1           3*t58*t60*t62
              t330 = 9.350317100005212d-2*t90*t96*t98+2.1622114952063792
     1           d-1*t90*t93
              t331 = 1/t89**4.0d+0
              t332 = -2.1622114952063792d-1*gammabb*t311*t330*t90*t95+2.
     1           1622114952063792d-1*t100*t90*t95+4.675158550002606d-2*g
     2           ammabb*t100*t331*t93
              t333 = 3.125d-2*t42*t47*t56*t60*t61-8.162866557885502d-4*t
     1           177*t47*t48*t51*t53*t62
              t334 = 3.710675800196128d-2*t141*t150*t151*t153+1.36210788
     1           85675922d-1*t141*t143*t147
              t335 = 1/t140**4.0d+0
              t336 = 1.855337900098064d-2*t147*t150*t155*t335*t58-1.3621
     1           078885675922d-1*t141*t143*t149*t266*t334*t58+1.36210788
     2           85675922d-1*t141*t143*t149*t155
              t337 = -2.4289602241917876d-4*rhob*t304*t332*t42*t57*t62+8
     1           .162866557885502d-4*rhoa*t174*t177*t41*t47*t51*t53*t62+
     2           8.162866557885502d-4*rhob*t102*t174*t177*t47*t51*t53*t6
     3           2-3.125d-2*rhoa*t163*t41*t57*t60*t61-3.125d-2*rhob*t102
     4           *t163*t57*t60*t61+3.109069086965489d-2*t139*t159*t252*t
     5           336+t158*t333
              t338 = 1.6406249999999997d-2*t160*t42*t60*t62+5.46875d-3*t
     1           161*t337
              t339 = 1/t59**2
              t340 = 3.125d-2*rhoa*t163*t339*t41*t57*t58*t61+3.125d-2*rh
     1           ob*t102*t163*t339*t57*t58*t61-3.125d-2*t158*t339*t42*t4
     2           7*t56*t58*t61
              t341 = 5.46875d-3*t161*t340-1.6406249999999997d-2*t160*t33
     1           9*t42*t58*t62
              t342 = 2*t276*t58*t60
              t343 = t342-8.0d-50*t163*t60
              t344 = -3.125d-2*rhoa*t276*t41*t57*t62
              t345 = 1/rhoa**2.333333333333333d+0
              t346 = 1/rhoa**2.3333333333333334d+0
              t347 = 1/rhoa**1.6666666666666669d+0
              t348 = 1/t3**5
              t349 = 1/t17**2
              t350 = t197**2
              t351 = -1.269642451250142d+0*t194*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t13*t187*t348+8.751370198886037d
     2           -2*t13*t188*t347+4.753699179395351d-3*t346)*t4+6.563527
     3           649164527d-2*t14*t187*t348+8.751370198886037d-2*t14*t18
     4           8*t347-2.625411059665811d-1*t188*t189*t195)-1.410713834
     5           7223802d-1*t16*t347*t4-4.23214150416714d-1*t189*t194*t1
     6           96*t4+2.539284902500284d+0*t196**2*t3/t15**3-3.52678458
     7           680595d-2*t16*t187*t188
              t352 = 1/t24**2
              t353 = t202**2
              t354 = -1.269642451250142d+0*t199*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t187*t20*t348+8.751370198886037d
     2           -2*t188*t20*t347+2.601716490612924d-3*t346)*t4+6.563527
     3           649164527d-2*t187*t21*t348+8.751370198886037d-2*t188*t2
     4           1*t347-2.625411059665811d-1*t188*t189*t200)-1.410713834
     5           7223802d-1*t23*t347*t4-4.23214150416714d-1*t189*t199*t2
     6           01*t4+2.539284902500284d+0*t201**2*t3/t22**3-3.52678458
     7           680595d-2*t187*t188*t23
              t355 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (3.10907d-2*t12*t192**2/t9**2-3.10907d-2*t12*t184*(-1.4
     2           107138347223802d-1*t347*t4*t8-3.52678458680595d-2*t187*
     3           t188*t8+2.539284902500284d+0*t191**2*t3/t7**3-1.2696424
     4           51250142d+0*t185*t3*(6.563527649164527d-2*t187*t348*t6+
     5           8.751370198886037d-2*t188*t347*t6+7.876233178997433d-1*
     6           t4*(6.563527649164527d-2*t187*t348*t5+8.751370198886037
     7           d-2*t188*t347*t5+3.0144339229749983d-3*t346)-2.62541105
     8           9665811d-1*t188*t189*t190)-4.23214150416714d-1*t185*t18
     9           9*t191*t4)+6.21814d-2*t19*t193*t351-6.21814d-2*t19*t349
     :           *t350+3.663697685584584d-3*t18*t345-1.7613865241785687d
     ;           -3*t10*t345-5.495546528376876d-3*t183*t193*t197+2.64207
     <           9786267853d-3*t183*t184*t192)-3.37738d-2*t198*t26*t354+
     =           3.37738d-2*t26*t352*t353-1.0359398963604977d-3*t25*t345
     >           +1.5539098445407465d-3*t183*t198*t202)+3.37738d-2*t198*
     ?           t26*t354-3.37738d-2*t26*t352*t353+1.0359398963604977d-3
     @           *t25*t345-1.5539098445407465d-3*t183*t198*t202)-6.21814
     1           d-2*t19*t193*t351+6.21814d-2*t19*t349*t350-3.6636976855
     2           84584d-3*t18*t345+5.495546528376876d-3*t183*t193*t197
              t356 = 1/t28**4.0d+0
              t357 = rhoa**1.6666666666666674d-1
              t358 = t203**2
              t359 = exp(-1.2865587377165935d+2*t27)
              t360 = 7.157929307165395d-47*rhoa*t29*t358*t359/t31**3
              t361 = 7.063224217674173d-50*t186*t32*t356
              t362 = -4.372472134750679d-50*t205*t32*t357
              t363 = -2.5963579524857594d-48*t203*t205*t208*t28*t30
              t364 = 1.1127248367796111d-48*t203*t208*t29*t30
              t365 = -3.5789646535826974d-47*rhoa*t208*t29*t30*t358
              t366 = 5.563624183898056d-49*rhoa*t208*t29*t30*t355
              t367 = t176**2
              t368 = 1/t55**6.0d+0
              t369 = -2*t276*t43
              t370 = 2*t163
              t371 = t370+t369
              t372 = 2*t276*t43
              t373 = -2*t163
              t374 = t373+t372
              t375 = t167**2
              t376 = t169**2
              t377 = 1/t49**3.333333333333333d+0
              t378 = 1/t50**3.333333333333333d+0
              t379 = 1/t1**4.666666666666667d+0
              t380 = 1.2770351237225316d-1*t379*t51*t54
              t381 = 1.3060586492616802d-2*(3.11111111111111d+0*t376*t37
     1           8+3.11111111111111d+0*t375*t377-1.333333333333333d+0*t1
     2           72*t374-1.333333333333333d+0*t171*t371)*t48*t54-6.96564
     3           6129395628d-2*t173*t174*t54+1.3060586492616802d-2*t48*(
     4           2*gammabb*t374*t50+8.0d-50*rhoa*t371*t49+1.6d-49*t167*t
     5           49+2*gammabb*t376+8.0d-50*rhoa*t375)*t51-6.965646129395
     6           628d-2*t170*t174*t51+2.6121172985233604d-2*t170*t173*t4
     7           8+t380
              t382 = 6.779999999999999d+1*t376*t46+6.0d+0*t376*t45+1.74d
     1           +0*t374*t42*t43+1.74d+0*t376+1.356d+1*t179*t374+2.0d+0*
     2           t178*t374
              t383 = t382*t56-4.0d+0*t177*t381*t47+2.0d+1*t367*t368*t47-
     1           8.0d+0*t176*t177*t180
              t384 = -3.125d-2*rhob*t102*t276*t57*t62
              t385 = t225**2
              t386 = 1/t112**2
              t387 = 6.21814d-2*t105*t385*t386
              t388 = 1/t1**2.3333333333333334d+0
              t389 = 1/t106**5
              t390 = 1/t1**1.6666666666666669d+0
              t391 = -1.269642451250142d+0*t106*t224*(7.876233178997433d
     1           -1*t107*(8.751370198886037d-2*t108*t221*t390+6.56352764
     2           9164527d-2*t108*t219*t389+4.753699179395351d-3*t388)+8.
     3           751370198886037d-2*t109*t221*t390+6.563527649164527d-2*
     4           t109*t219*t389-2.625411059665811d-1*t220*t221*t222)-1.4
     5           107138347223802d-1*t107*t111*t390-4.23214150416714d-1*t
     6           107*t220*t223*t224+2.539284902500284d+0*t106*t223**2/t1
     7           10**3-3.52678458680595d-2*t111*t219*t221
              t392 = -6.21814d-2*t105*t226*t391
              t393 = 5.495546528376876d-3*t225*t226*t228
              t394 = 1/t1**2.333333333333333d+0
              t395 = -3.663697685584584d-3*t113*t394
              t396 = t233**2
              t397 = 1/t122**2
              t398 = -3.37738d-2*t117*t396*t397
              t399 = -1.269642451250142d+0*t106*t232*(7.876233178997433d
     1           -1*t107*(8.751370198886037d-2*t118*t221*t390+6.56352764
     2           9164527d-2*t118*t219*t389+2.601716490612924d-3*t388)+8.
     3           751370198886037d-2*t119*t221*t390+6.563527649164527d-2*
     4           t119*t219*t389-2.625411059665811d-1*t220*t221*t230)-1.4
     5           107138347223802d-1*t107*t121*t390-4.23214150416714d-1*t
     6           107*t220*t231*t232+2.539284902500284d+0*t106*t231**2/t1
     7           20**3-3.52678458680595d-2*t121*t219*t221
              t400 = 3.37738d-2*t117*t234*t399
              t401 = -1.5539098445407465d-3*t228*t233*t234
              t402 = 1.0359398963604977d-3*t123*t394
              t403 = t124*t125*(-3.37738d-2*t117*t234*t399+3.37738d-2*t1
     1           17*t396*t397+1.709920934161365d+0*(-1.7613865241785687d
     2           -3*t132*t394+3.663697685584584d-3*t113*t394+6.21814d-2*
     3           t105*t226*t391-3.10907d-2*t126*t241*(-1.269642451250142
     4           d+0*t106*t239*(7.876233178997433d-1*t107*(8.75137019888
     5           6037d-2*t127*t221*t390+6.563527649164527d-2*t127*t219*t
     6           389+3.0144339229749983d-3*t388)+8.751370198886037d-2*t1
     7           28*t221*t390+6.563527649164527d-2*t128*t219*t389-2.6254
     8           11059665811d-1*t220*t221*t237)-1.4107138347223802d-1*t1
     9           07*t130*t390-4.23214150416714d-1*t107*t220*t238*t239+2.
     :           539284902500284d+0*t106*t238**2/t129**3-3.5267845868059
     ;           5d-2*t130*t219*t221)-6.21814d-2*t105*t385*t386+2.642079
     <           786267853d-3*t228*t240*t241+3.10907d-2*t126*t240**2/t13
     =           1**2-5.495546528376876d-3*t225*t226*t228)-1.03593989636
     >           04977d-3*t123*t394+1.5539098445407465d-3*t228*t233*t234
     ?           )
              t404 = -8*t124*t242*t244
              t405 = 20*t124*t133/t1**6
              t406 = t43**2
              t407 = 12*t125*t133*t406
              t408 = 1/t136
              t409 = 1/t137
              t410 = 5.848223622634648d-1*t134*(8.549604670806825d-1*t37
     1           6*t409+8.549604670806825d-1*t375*t408+2.564881401242048
     2           d+0*t249*t374+2.564881401242048d+0*t248*t371)+5.8482236
     3           22634648d-1*t116*(t407+t405+t404+t403+t402+t401+t400+t3
     4           98-32*t133*t244*t246+8*t125*t242*t246)+t395+t393+t392+t
     5           387+1.1696447245269297d+0*t247*t250
              t411 = t255**2
              t412 = 1/t114
              t413 = 1/t115
              t414 = -1.111111111111111d-1*t376*t413-1.111111111111111d-
     1           1*t375*t412+3.333333333333333d-1*t254*t374+3.3333333333
     2           33333d-1*t253*t371
              t415 = t1**3.333333333333335d-1
              t416 = 1.1123881089968671d+0*t143*t149*t155*t335*t415*t58
              t417 = 1/t1**8.333333333333333d-1
              t418 = -5.297086233318417d-2*t143*t149*t155*t257*t417*t58
              t419 = 8.172647331405554d-1*t141*t147*t150*t411*t58
              t420 = -2.7242157771351844d-1*t141*t144*t147*t414*t58
              t421 = 1.2713006959964196d+0*t144*t147*t255*t256*t257*t58
              t422 = -2.1793726217081477d-50*t141*t144*t147*t255
              t423 = 1.1123881089968671d+0*t143*t147*t335*t415*t58
              t424 = -5.297086233318417d-2*t143*t147*t257*t417*t58
              t425 = -2.542601391992839d-50*t143*t147*t256*t257
              t426 = 9.649190532874448d+1*t135*t150*t414-3.8596762131497
     1           79d+2*t135*t268*t411-3.216396844291483d+1*t144*t410+1.9
     2           298381065748896d+2*t150*t251*t255
              t427 = -1.3621078885675922d-1*t141*t143*t145*t262*t426*t58
              t428 = 5.448431554270369d-1*t141*t144*t145*t255*t262*t263*
     1           t58
              t429 = 6.356503479982097d-1*t143*t145*t256*t257*t262*t263*
     1           t58
              t430 = -1.0896863108540739d-50*t141*t143*t145*t262*t263
              t431 = exp(-6.432793688582966d+1*t135*t144)
              t432 = 1/t146**3
              t433 = t263**2
              t434 = 2.7242157771351844d-1*t141*t143*t431*t432*t433*t58
              t435 = -1.3621078885675922d-1*t141*t143*t145*t262*t433*t58
              t436 = 8.166666666666668d+0*t335*t415*t58
              t437 = -3.8888888888888906d-1*t257*t417*t58
              t438 = 1/t138**6.0d+0
              t439 = 1/t146**4.0d+0
              t440 = 1/t154**3
              t441 = 1/t156**2
              t442 = t164**2
              t443 = t158*(1.5625d-2*t382*t56*t62-6.25d-2*t177*t381*t47*
     1           t62+3.125d-1*t367*t368*t47*t62-1.25d-1*t176*t177*t180*t
     2           62+3.125d-2*t164*t180*t56*t61-1.25d-1*t164*t176*t177*t4
     3           7*t61+3.125d-2*t343*t42*t47*t56*t58*t60+3.125d-2*t164*t
     4           180*t42*t56*t58*t60-1.25d-1*t164*t176*t177*t42*t47*t58*
     5           t60+3.125d-2*t442*t47*t56)-1.5625d-2*rhoa*(-1.554534543
     6           4827443d-2*t215**2/t40**2+1.5545345434827443d-2*t204*(8
     7           .648845980825518d-51*rhoa*t29*(t366+t365+t364+t363+t362
     8           +t361+t360)*t39-4.372472134750679d-50*t205*t34*t357*t39
     9           +7.063224217674173d-50*t186*t34*t356*t39+1.729769196165
     :           1035d-50*t210*t29*t39-4.036128124385242d-50*t205*t210*t
     ;           28*t39+1.7297691961651035d-50*rhoa*t214**2*t29*t34/t38*
     <           *3-8.648845980825518d-51*rhoa*t211*t29*t34*(1.496050736
     =           0008343d-100*rhoa*t29*(8.166666666666668d+0*t186*t356-5
     >           .055555555555556d+0*t205*t357)*t37+1.4960507360008343d-
     ?           100*t212**2*t37+t366+t365+t364+t363+t362+t361+t360+1.85
     @           7234843579318d-96*t358*t359*t36/t31**4.0d+0-6.190782811
     1           93106d-97*t213*t30*t358*t36+9.623785732346068d-99*t213*
     2           t30*t355*t36+1.9247571464692137d-98*t203*t212*t213*t30*
     3           t35+1.9247571464692137d-98*rhoa*t203*t212*t213*t29*t30)
     4           -1.7297691961651035d-50*t211*t214*t29*t34+4.03612812438
     5           5242d-50*t205*t211*t214*t28*t34-1.7297691961651035d-50*
     6           rhoa*t210*t211*t214*t29)+1.0d+0*t355)*t42*t57*t62-3.125
     7           d-2*t216*t42*t57*t62+3.125d-2*t163*t41*t57*t62+3.125d-2
     8           *rhoa*t163*t216*t57*t62-1.5625d-2*rhoa*t383*t41*t42*t62
     9           -3.125d-2*t181*t41*t42*t62-1.5625d-2*rhob*t102*t383*t42
     :           *t62-3.125d-2*rhoa*t181*t216*t42*t62+3.125d-2*rhoa*t163
     ;           *t181*t41*t62+3.125d-2*rhob*t102*t163*t181*t62-3.125d-2
     <           *t164*t41*t42*t57*t61-3.125d-2*rhoa*t164*t216*t42*t57*t
     =           61+3.125d-2*rhoa*t163*t164*t41*t57*t61+3.125d-2*rhob*t1
     >           02*t163*t164*t57*t61-3.125d-2*rhoa*t164*t181*t41*t42*t6
     ?           1-3.125d-2*rhob*t102*t164*t181*t42*t61-3.125d-2*rhoa*t1
     @           63*t343*t41*t57*t58*t60+3.125d-2*rhoa*t164*t276*t41*t57
     1           *t58*t60-3.125d-2*t163*t164*t41*t57*t58*t60-3.125d-2*rh
     2           ob*t102*t163*t343*t57*t58*t60+3.125d-2*rhob*t102*t164*t
     3           276*t57*t58*t60-3.125d-2*rhoa*t163*t164*t216*t57*t58*t6
     4           0-3.125d-2*rhoa*t163*t164*t181*t41*t58*t60-3.125d-2*rho
     5           b*t102*t163*t164*t181*t58*t60+t159*(3.109069086965489d-
     6           2*t139*t252*(-1.3621078885675922d-1*t141*t143*t149*t266
     7           *t58*(3.710675800196128d-2*t141*t150*t153*(t437+t436-1.
     8           866666666666667d-49*t256*t257)*t58-7.421351600392256d-2
     9           *t141*t145*t150*t263*t267*t269*t58-1.4842703200784513d-
     :           1*t141*t153*t255*t267*t268*t58+1.1132027400588385d-1*t1
     ;           50*t152*t431*t433*t439+3.710675800196128d-1*t152*t153*t
     <           411*t438+t435+t434-3.710675800196128d-2*t145*t150*t152*
     =           t269*t433+t430+t429+t428+t427-3.710675800196128d-2*t145
     >           *t150*t152*t269*t426+t425+t424+t423+t422+t421+t420+t419
     ?           -7.421351600392256d-2*t152*t153*t268*t414+2.96854064015
     @           69026d-1*t145*t152*t255*t263*t268*t269-7.42135160039225
     1           6d-2*t145*t150*t151*t263*t267*t269-1.4842703200784513d-
     2           1*t151*t153*t255*t267*t268+3.710675800196128d-2*t150*t1
     3           53*t267**2)+2.7242157771351844d-1*t141*t143*t149*t270**
     4           2*t440*t58+1.3621078885675922d-1*t141*t143*t155*(t435+t
     5           434+t430+t429+t428+t427+t425+t424+t423+t422+t421+t420+t
     6           419)*t58-2.7242157771351844d-1*t141*t144*t149*t155*t414
     7           *t58+8.172647331405554d-1*t141*t149*t150*t155*t411*t58-
     8           2.7242157771351844d-1*t141*t143*t265*t266*t270*t58+6.35
     9           6503479982097d-1*t143*t149*t256*t257*t266*t270*t58+5.44
     :           8431554270369d-1*t141*t144*t149*t255*t266*t270*t58-6.35
     ;           6503479982097d-1*t143*t155*t256*t257*t265*t58-5.4484315
     <           54270369d-1*t141*t144*t155*t255*t265*t58+1.271300695996
     =           4196d+0*t144*t149*t155*t255*t256*t257*t58+t418+t416-1.0
     >           896863108540739d-50*t141*t143*t149*t266*t270+1.08968631
     ?           08540739d-50*t141*t143*t155*t265-2.542601391992839d-50*
     @           t143*t149*t155*t256*t257-2.1793726217081477d-50*t141*t1
     1           44*t149*t155*t255)-3.109069086965489d-2*t139*t271**2*t4
     2           41+9.327207260896466d-2*t142*t157*t414+1.86544145217929
     3           34d-1*t138*t157*t411+1.0d+0*t410+1.8654414521792934d-1*
     4           t142*t252*t255*t271)-3.125d-2*rhoa*t41*t42*t442*t57-3.1
     5           25d-2*rhob*t102*t42*t442*t57+t384+t344+2*t218*t272
              t444 = -3.125d-2*rhoa*t125*t41*t57*t58*t60*t61
              t445 = -3.125d-2*rhob*t102*t125*t57*t58*t60*t61
              t446 = t342-4.0d-50*t163*t60
              t447 = 1.3060586492616802d-2*(-2.666666666666666d+0*t172*t
     1           276*t43+2.666666666666666d+0*t171*t276*t43+3.1111111111
     2           1111d+0*t169*t278*t378+3.11111111111111d+0*t167*t277*t3
     3           77)*t48*t54-3.482823064697814d-2*t174*t280*t54-3.482823
     4           064697814d-2*t173*t174*t54+1.3060586492616802d-2*t48*(4
     5           *gammabb*t276*t43*t50-1.6d-49*rhoa*t276*t43*t49+8.0d-50
     6           *t277*t49+2*gammabb*t169*t278+8.0d-50*rhoa*t167*t277)*t
     7           51-3.482823064697814d-2*t174*t279*t51-3.482823064697814
     8           d-2*t170*t174*t51+1.3060586492616802d-2*t170*t280*t48+1
     9           .3060586492616802d-2*t173*t279*t48+t380
              t448 = 6.779999999999999d+1*t169*t278*t46+6.0d+0*t169*t278
     1           *t45+2.712d+1*t179*t276*t43+4.0d+0*t178*t276*t43+3.48d+
     2           0*t125*t406+1.74d+0*t169*t278
              t449 = t448*t56-4.0d+0*t177*t447*t47+2.0d+1*t176*t281*t368
     1           *t47-4.0d+0*t176*t177*t282-4.0d+0*t177*t180*t281
              t450 = 5.848223622634648d-1*t134*(5.129762802484096d+0*t24
     1           9*t276*t43-5.129762802484096d+0*t248*t276*t43+8.5496046
     2           70806825d-1*t169*t278*t409+8.549604670806825d-1*t167*t2
     3           77*t408)+5.848223622634648d-1*t116*(-12*t125*t133*t406+
     4           t405+t404+t403+t402+t401+t400+t398)+t395+t393+t392+t387
     5           +5.848223622634648d-1*t247*t318+5.848223622634648d-1*t2
     6           50*t317
              t451 = 6.666666666666666d-1*t254*t276*t43-6.66666666666666
     1           6d-1*t253*t276*t43-1.111111111111111d-1*t169*t278*t413-
     2           1.111111111111111d-1*t167*t277*t412
              t452 = 8.172647331405554d-1*t141*t147*t150*t255*t320*t58
              t453 = -2.7242157771351844d-1*t141*t144*t147*t451*t58
              t454 = 6.356503479982097d-1*t144*t147*t256*t257*t320*t58
              t455 = -1.0896863108540739d-50*t141*t144*t147*t320
              t456 = 6.356503479982097d-1*t144*t147*t255*t256*t257*t58
              t457 = -1.2713006959964196d-50*t143*t147*t256*t257
              t458 = 9.649190532874448d+1*t135*t150*t451-3.2163968442914
     1           83d+1*t144*t450-3.859676213149779d+2*t135*t255*t268*t32
     2           0+9.649190532874448d+1*t150*t251*t320+9.649190532874448
     3           d+1*t150*t255*t319
              t459 = -1.3621078885675922d-1*t141*t143*t145*t262*t458*t58
              t460 = 2.7242157771351844d-1*t141*t144*t145*t255*t262*t322
     1           *t58
              t461 = 3.1782517399910487d-1*t143*t145*t256*t257*t262*t322
     1           *t58
              t462 = -5.44843155427037d-51*t141*t143*t145*t262*t322
              t463 = 2.7242157771351844d-1*t141*t144*t145*t262*t263*t320
     1           *t58
              t464 = 3.1782517399910487d-1*t143*t145*t256*t257*t262*t263
     1           *t58
              t465 = 2.7242157771351844d-1*t141*t143*t263*t322*t431*t432
     1           *t58
              t466 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t32
     1           2*t58
              t467 = t158*(1.5625d-2*t448*t56*t62-6.25d-2*t177*t447*t47*
     1           t62+3.125d-1*t176*t281*t368*t47*t62-6.25d-2*t176*t177*t
     2           282*t62-6.25d-2*t177*t180*t281*t62-3.125d-2*t163*t180*t
     3           56*t58*t60*t61+1.25d-1*t163*t176*t177*t47*t58*t60*t61+3
     4           .125d-2*t42*t446*t47*t56*t58*t60-3.125d-2*t163*t164*t47
     5           *t56*t58*t60+3.125d-2*t164*t282*t42*t56*t58*t60-1.25d-1
     6           *t164*t177*t281*t42*t47*t58*t60)+1.5625d-2*t163*t41*t57
     7           *t62+1.5625d-2*rhob*t163*t315*t57*t62+1.5625d-2*rhoa*t1
     8           63*t216*t57*t62+1.5625d-2*t102*t163*t57*t62-1.5625d-2*r
     9           hoa*t41*t42*t449*t62-1.5625d-2*rhob*t102*t42*t449*t62-1
     :           .5625d-2*t283*t41*t42*t62-1.5625d-2*rhob*t181*t315*t42*
     ;           t62-1.5625d-2*rhoa*t216*t283*t42*t62-1.5625d-2*t102*t18
     <           1*t42*t62+1.5625d-2*rhoa*t163*t283*t41*t62+1.5625d-2*rh
     =           oa*t163*t181*t41*t62+1.5625d-2*rhob*t102*t163*t283*t62+
     >           1.5625d-2*rhob*t102*t163*t181*t62+3.125d-2*t276*t41*t57
     ?           *t58*t60*t61+3.125d-2*rhoa*t216*t276*t57*t58*t60*t61+3.
     @           125d-2*rhoa*t181*t276*t41*t58*t60*t61+3.125d-2*rhob*t10
     1           2*t181*t276*t58*t60*t61-3.125d-2*rhoa*t163*t41*t446*t57
     2           *t58*t60-3.125d-2*rhob*t102*t163*t446*t57*t58*t60+6.25d
     3           -2*rhoa*t164*t276*t41*t57*t58*t60-3.125d-2*rhob*t163*t1
     4           64*t315*t57*t58*t60+6.25d-2*rhob*t102*t164*t276*t57*t58
     5           *t60-3.125d-2*t102*t163*t164*t57*t58*t60-3.125d-2*rhoa*
     6           t163*t164*t283*t41*t58*t60-3.125d-2*rhob*t102*t163*t164
     7           *t283*t58*t60+t159*(3.109069086965489d-2*t139*t252*(-1.
     8           3621078885675922d-1*t141*t143*t149*t266*t58*(3.71067580
     9           0196128d-2*t141*t150*t153*(t437+t436-9.333333333333335d
     :           -50*t256*t257)*t58-7.421351600392256d-2*t141*t145*t150*
     ;           t267*t269*t322*t58-1.4842703200784513d-1*t141*t153*t267
     <           *t268*t320*t58+1.7316487067581932d-1*t145*t150*t151*t25
     =           6*t257*t263*t269*t58+3.4632974135163863d-1*t151*t153*t2
     >           55*t256*t257*t268*t58-8.658243533790966d-2*t150*t153*t2
     ?           56*t257*t267*t58+t466+t465+t464+t463+t462+t461+t460+t45
     @           9-3.710675800196128d-2*t145*t150*t152*t269*t458+t457+t4
     1           56+t455+t454+t453+t452-7.421351600392256d-2*t152*t153*t
     2           268*t451+1.1132027400588385d-1*t150*t152*t263*t322*t431
     3           *t439+3.710675800196128d-1*t152*t153*t255*t320*t438+t42
     4           4+t423+1.4842703200784513d-1*t145*t152*t255*t268*t269*t
     5           322-3.710675800196128d-2*t145*t150*t152*t263*t269*t322+
     6           1.4842703200784513d-1*t145*t152*t263*t268*t269*t320)+1.
     7           3621078885675922d-1*t141*t143*t155*(t466+t465+t464+t463
     8           +t462+t461+t460+t459+t457+t456+t455+t454+t453+t452+t424
     9           +t423)*t58-2.7242157771351844d-1*t141*t144*t149*t155*t4
     :           51*t58+2.7242157771351844d-1*t141*t143*t149*t270*t325*t
     ;           440*t58-1.3621078885675922d-1*t141*t143*t265*t266*t325*
     <           t58+3.1782517399910487d-1*t143*t149*t256*t257*t266*t325
     =           *t58+2.7242157771351844d-1*t141*t144*t149*t255*t266*t32
     >           5*t58-1.3621078885675922d-1*t141*t143*t266*t270*t324*t5
     ?           8-3.1782517399910487d-1*t143*t155*t256*t257*t324*t58-2.
     @           7242157771351844d-1*t141*t144*t155*t255*t324*t58+2.7242
     1           157771351844d-1*t141*t144*t149*t266*t270*t320*t58-2.724
     2           2157771351844d-1*t141*t144*t155*t265*t320*t58+6.3565034
     3           79982097d-1*t144*t149*t155*t256*t257*t320*t58+8.1726473
     4           31405554d-1*t141*t149*t150*t155*t255*t320*t58+3.1782517
     5           399910487d-1*t143*t149*t256*t257*t266*t270*t58-3.178251
     6           7399910487d-1*t143*t155*t256*t257*t265*t58+6.3565034799
     7           82097d-1*t144*t149*t155*t255*t256*t257*t58+t418+t416-5.
     8           44843155427037d-51*t141*t143*t149*t266*t325+5.448431554
     9           27037d-51*t141*t143*t155*t324-1.0896863108540739d-50*t1
     :           41*t144*t149*t155*t320-1.2713006959964196d-50*t143*t149
     ;           *t155*t256*t257)+9.327207260896466d-2*t142*t157*t451+1.
     <           0d+0*t450-3.109069086965489d-2*t139*t271*t326*t441+9.32
     =           7207260896466d-2*t142*t252*t255*t326+9.327207260896466d
     >           -2*t142*t252*t271*t320+1.8654414521792934d-1*t138*t157*
     ?           t255*t320)+t445+t444+t384+t344+t218*t327+t272*t316
              t468 = t58**2
              t469 = t281**2
              t470 = t373+t369
              t471 = t372+t370
              t472 = t278**2
              t473 = t277**2
              t474 = 1.3060586492616802d-2*(3.11111111111111d+0*t377*t47
     1           3+3.11111111111111d+0*t378*t472-1.333333333333333d+0*t1
     2           72*t471-1.333333333333333d+0*t171*t470)*t48*t54-6.96564
     3           6129395628d-2*t174*t280*t54+1.3060586492616802d-2*t48*(
     4           2*gammabb*t471*t50+8.0d-50*rhoa*t470*t49+8.0d-50*rhoa*t
     5           473+2*gammabb*t472)*t51-6.965646129395628d-2*t174*t279*
     6           t51+2.6121172985233604d-2*t279*t280*t48+t380
              t475 = 6.779999999999999d+1*t46*t472+6.0d+0*t45*t472+1.74d
     1           +0*t472+1.74d+0*t42*t43*t471+1.356d+1*t179*t471+2.0d+0*
     2           t178*t471
              t476 = t475*t56-4.0d+0*t177*t47*t474+2.0d+1*t368*t469*t47-
     1           8.0d+0*t177*t281*t282
              t477 = 1/rhob**2.333333333333333d+0
              t478 = 1/rhob**2.3333333333333334d+0
              t479 = 1/rhob**1.6666666666666669d+0
              t480 = 1/t64**5
              t481 = 1/t78**2
              t482 = t297**2
              t483 = -1.4107138347223802d-1*t479*t65*t77-3.5267845868059
     1           5d-2*t287*t288*t77+2.539284902500284d+0*t296**2*t64/t76
     2           **3-1.269642451250142d+0*t294*t64*(6.563527649164527d-2
     3           *t287*t480*t75+8.751370198886037d-2*t288*t479*t75+7.876
     4           233178997433d-1*t65*(6.563527649164527d-2*t287*t480*t74
     5           +8.751370198886037d-2*t288*t479*t74+4.753699179395351d-
     6           3*t478)-2.625411059665811d-1*t288*t289*t295)-4.23214150
     7           416714d-1*t289*t294*t296*t65
              t484 = 1/t85**2
              t485 = t302**2
              t486 = -1.4107138347223802d-1*t479*t65*t84-3.5267845868059
     1           5d-2*t287*t288*t84+2.539284902500284d+0*t301**2*t64/t83
     2           **3-1.269642451250142d+0*t299*t64*(6.563527649164527d-2
     3           *t287*t480*t82+8.751370198886037d-2*t288*t479*t82+7.876
     4           233178997433d-1*t65*(6.563527649164527d-2*t287*t480*t81
     5           +8.751370198886037d-2*t288*t479*t81+2.601716490612924d-
     6           3*t478)-2.625411059665811d-1*t288*t289*t300)-4.23214150
     7           416714d-1*t289*t299*t301*t65
              t487 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t298*t486
     1           *t87+3.37738d-2*t484*t485*t87-1.0359398963604977d-3*t47
     2           7*t86+1.709920934161365d+0*(6.21814d-2*t293*t483*t80-6.
     3           21814d-2*t481*t482*t80+3.663697685584584d-3*t477*t79+3.
     4           10907d-2*t292**2*t73/t70**2-3.10907d-2*t285*(-1.4107138
     5           347223802d-1*t479*t65*t69-3.52678458680595d-2*t287*t288
     6           *t69+2.539284902500284d+0*t291**2*t64/t68**3-1.26964245
     7           1250142d+0*t286*t64*(6.563527649164527d-2*t287*t480*t67
     8           +8.751370198886037d-2*t288*t479*t67+7.876233178997433d-
     9           1*t65*(6.563527649164527d-2*t287*t480*t66+8.75137019888
     :           6037d-2*t288*t479*t66+3.0144339229749983d-3*t478)-2.625
     ;           411059665811d-1*t288*t289*t290)-4.23214150416714d-1*t28
     <           6*t289*t291*t65)*t73-1.7613865241785687d-3*t477*t71-5.4
     =           95546528376876d-3*t284*t293*t297+2.642079786267853d-3*t
     >           284*t285*t292)+1.5539098445407465d-3*t284*t298*t302)+3.
     ?           37738d-2*t298*t486*t87-3.37738d-2*t484*t485*t87+1.03593
     @           98963604977d-3*t477*t86-1.5539098445407465d-3*t284*t298
     1           *t302)-6.21814d-2*t293*t483*t80+6.21814d-2*t481*t482*t8
     2           0-3.663697685584584d-3*t477*t79+5.495546528376876d-3*t2
     3           84*t293*t297
              t488 = rhob**3.333333333333335d-1
              t489 = 1/rhob**8.333333333333333d-1
              t490 = t303**2
              t491 = exp(-1.2865587377165935d+2*t88)
              t492 = 1.7894823267913484d+3*gammabb*t490*t491*t90/t92**3
              t493 = 1.765806054418543d+0*gammabb*t331*t488*t93
              t494 = -8.408600259135923d-2*gammabb*t306*t489*t93
              t495 = -6.490894881214397d+1*gammabb*t303*t305*t306*t308*t
     1           91
              t496 = -8.947411633956742d+2*gammabb*t308*t490*t90*t91
              t497 = 1.3909060459745137d+1*gammabb*t308*t487*t90*t91
              t498 = gammabb**2
              t499 = 1/t89**6.0d+0
              t500 = 1/t89**5.0d+0
              t501 = 1/t99**3
              t502 = 1/t101**2
              t503 = 5.848223622634648d-1*t134*(8.549604670806825d-1*t40
     1           8*t473+8.549604670806825d-1*t409*t472+2.564881401242048
     2           d+0*t249*t471+2.564881401242048d+0*t248*t470)+5.8482236
     3           22634648d-1*t116*(t407+t405+t404+t403+t402+t401+t400+t3
     4           98+32*t133*t244*t246-8*t125*t242*t246)+t395+t393+t392+t
     5           387+1.1696447245269297d+0*t317*t318
              t504 = t320**2
              t505 = -1.111111111111111d-1*t412*t473-1.111111111111111d-
     1           1*t413*t472+3.333333333333333d-1*t254*t471+3.3333333333
     2           33333d-1*t253*t470
              t506 = 8.172647331405554d-1*t141*t147*t150*t504*t58
              t507 = -2.7242157771351844d-1*t141*t144*t147*t505*t58
              t508 = 1.2713006959964196d+0*t144*t147*t256*t257*t320*t58
              t509 = 9.649190532874448d+1*t135*t150*t505-3.8596762131497
     1           79d+2*t135*t268*t504-3.216396844291483d+1*t144*t503+1.9
     2           298381065748896d+2*t150*t319*t320
              t510 = -1.3621078885675922d-1*t141*t143*t145*t262*t509*t58
              t511 = 5.448431554270369d-1*t141*t144*t145*t262*t320*t322*
     1           t58
              t512 = 6.356503479982097d-1*t143*t145*t256*t257*t262*t322*
     1           t58
              t513 = t322**2
              t514 = 2.7242157771351844d-1*t141*t143*t431*t432*t513*t58
              t515 = -1.3621078885675922d-1*t141*t143*t145*t262*t513*t58
              t516 = 1/t140**5.0d+0
              t517 = 1/t140**6.0d+0
              t518 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2*
     1           t304*(-2.1622114952063792d-1*gammabb*t311*t90*t95*(-3.6
     2           362344277798064d-2*t489*t498*t500*t98+1.272682049722931
     3           6d+0*t488*t498*t499*t98+1.1607717772370736d+3*t490*t491
     4           *t97/t92**4.0d+0-3.869239257456912d+2*t312*t490*t91*t97
     5           +6.014866082716293d+0*t312*t487*t91*t97-2.8069375052676
     6           03d+1*gammabb*t303*t305*t306*t312*t91*t96-2.80693750526
     7           7603d+1*t303*t305*t312*t498*t500*t91+t497+t496+t495+t49
     8           4+t493+t492)+4.3244229904127585d-1*gammabb*t313**2*t501
     9           *t90*t95-8.408600259135923d-2*gammabb*t100*t306*t489*t9
     :           5+1.765806054418543d+0*gammabb*t100*t331*t488*t95+1.009
     ;           0320310963104d+0*gammabb*t305*t306*t311*t313*t95+2.1622
     <           114952063792d-1*gammabb*t100*(t497+t496+t495+t494+t493+
     =           t492)*t90-4.3244229904127585d-1*gammabb*t310*t311*t313*
     >           t90-1.0090320310963104d+0*gammabb*t100*t305*t306*t310)-
     ?           1.5545345434827443d-2*t314**2*t502+1.0d+0*t487)+t158*(1
     @           .5625d-2*t475*t56*t62-6.25d-2*t177*t47*t474*t62+3.125d-
     1           1*t368*t469*t47*t62-1.25d-1*t177*t281*t282*t62-3.125d-2
     2           *t163*t282*t56*t58*t60*t61+1.25d-1*t163*t177*t281*t47*t
     3           58*t60*t61+9.375d-2*t125*t339*t468*t47*t56-3.125d-2*t27
     4           6*t282*t339*t468*t56+1.25d-1*t177*t276*t281*t339*t468*t
     5           47)-3.125d-2*t315*t42*t57*t62+3.125d-2*rhob*t163*t315*t
     6           57*t62+3.125d-2*t102*t163*t57*t62-1.5625d-2*rhoa*t41*t4
     7           2*t476*t62-1.5625d-2*rhob*t102*t42*t476*t62-3.125d-2*rh
     8           ob*t283*t315*t42*t62-3.125d-2*t102*t283*t42*t62+3.125d-
     9           2*rhoa*t163*t283*t41*t62+3.125d-2*rhob*t102*t163*t283*t
     :           62+3.125d-2*rhob*t276*t315*t57*t58*t60*t61+3.125d-2*t10
     ;           2*t276*t57*t58*t60*t61+3.125d-2*rhoa*t276*t283*t41*t58*
     <           t60*t61+3.125d-2*rhob*t102*t276*t283*t58*t60*t61+t159*(
     =           3.109069086965489d-2*t139*t252*(-1.3621078885675922d-1*
     >           t141*t143*t149*t266*t58*(1.7316487067581932d-1*t145*t15
     ?           0*t151*t256*t257*t269*t322*t58+3.4632974135163863d-1*t1
     @           51*t153*t256*t257*t268*t320*t58+5.050642061378063d-1*t1
     1           50*t153*t415*t468*t517-1.4430405889651615d-2*t150*t153*
     2           t417*t468*t516+1.7316487067581932d-1*t145*t150*t256*t26
     3           9*t322*t468*t516+3.4632974135163863d-1*t153*t256*t268*t
     4           320*t468*t516+t515+t514+1.1132027400588385d-1*t150*t152
     5           *t431*t439*t513-3.710675800196128d-2*t145*t150*t152*t26
     6           9*t513+t512+t511+t510-3.710675800196128d-2*t145*t150*t1
     7           52*t269*t509+t508+t507+t506-7.421351600392256d-2*t152*t
     8           153*t268*t505+3.710675800196128d-1*t152*t153*t438*t504+
     9           t424+t423+2.9685406401569026d-1*t145*t152*t268*t269*t32
     :           0*t322)+1.3621078885675922d-1*t141*t143*t155*(t515+t514
     ;           +t512+t511+t510+t508+t507+t506+t424+t423)*t58-2.7242157
     <           771351844d-1*t141*t144*t149*t155*t505*t58+8.17264733140
     =           5554d-1*t141*t149*t150*t155*t504*t58+2.7242157771351844
     >           d-1*t141*t143*t149*t325**2*t440*t58-2.7242157771351844d
     ?           -1*t141*t143*t266*t324*t325*t58+5.448431554270369d-1*t1
     @           41*t144*t149*t266*t320*t325*t58+6.356503479982097d-1*t1
     1           43*t149*t256*t257*t266*t325*t58-5.448431554270369d-1*t1
     2           41*t144*t155*t320*t324*t58-6.356503479982097d-1*t143*t1
     3           55*t256*t257*t324*t58+1.2713006959964196d+0*t144*t149*t
     4           155*t256*t257*t320*t58+t418+t416)+9.327207260896466d-2*
     5           t142*t157*t505+1.8654414521792934d-1*t138*t157*t504+1.0
     6           d+0*t503-3.109069086965489d-2*t139*t326**2*t441+1.86544
     7           14521792934d-1*t142*t252*t320*t326)-1.25d-1*rhoa*t244*t
     8           339*t41*t468*t57+3.125d-2*rhob*t125*t315*t339*t468*t57-
     9           1.25d-1*rhob*t102*t244*t339*t468*t57+3.125d-2*t102*t125
     :           *t339*t468*t57+3.125d-2*rhoa*t125*t283*t339*t41*t468+3.
     ;           125d-2*rhob*t102*t125*t283*t339*t468+t445+t444+t384+t34
     <           4+2*t316*t327
              t519 = 3.125d-2*rhoa*t276*t41*t57*t60*t61
              t520 = 3.125d-2*rhob*t102*t276*t57*t60*t61
              t521 = -8.162866557885502d-4*rhoa*t177*t379*t41*t47*t51*t5
     1           3*t62
              t522 = -3.482823064697814d-2*t174*t51*t53
              t523 = 1.3060586492616802d-2*t173*t48*t53+t522+2.612117298
     1           5233604d-2*t169*t48*t50*t51
              t524 = 2.6121172985233604d-1*t176*t368*t47*t48*t51*t53-5.2
     1           24234597046721d-2*t177*t180*t48*t51*t53-4.0d+0*t177*t47
     2           *t523
              t525 = 2.4289602241917876d-4*rhob*t163*t304*t332*t57*t62
              t526 = -8.162866557885502d-4*rhob*t102*t177*t379*t47*t51*t
     1           53*t62
              t527 = 3.1782517399910487d-1*t143*t149*t256*t257*t266*t334
     1           *t58
              t528 = -3.1782517399910487d-1*t143*t149*t155*t256*t257
              t529 = -4.3291217668954834d-2*t147*t150*t155*t256*t516*t58
              t530 = -2.7242157771351844d-1*t141*t144*t147*t255
              t531 = -3.1782517399910487d-1*t143*t147*t256*t257
              t532 = -1.3621078885675922d-1*t141*t143*t145*t262*t263
              t533 = t158*(4.0814332789427504d-3*t176*t368*t47*t48*t51*t
     1           53*t62-8.162866557885502d-4*t177*t180*t48*t51*t53*t62-6
     2           .25d-2*t177*t47*t523*t62+3.125d-2*t180*t42*t56*t60*t61-
     3           1.25d-1*t176*t177*t42*t47*t60*t61-1.6325733115771002d-3
     4           *t164*t174*t177*t47*t51*t53*t58*t60+3.125d-2*t164*t42*t
     5           47*t56*t60-3.125d-2*t276*t339*t47*t56*t58)+8.1628665578
     6           85502d-4*t174*t177*t41*t47*t51*t53*t62+8.16286655788550
     7           2d-4*rhoa*t174*t177*t216*t47*t51*t53*t62-1.5625d-2*rhoa
     8           *t41*t42*t524*t62-1.5625d-2*rhob*t102*t42*t524*t62-2.42
     9           89602241917876d-4*rhob*t181*t304*t332*t42*t62-3.125d-2*
     :           t163*t41*t57*t60*t61-3.125d-2*rhoa*t163*t216*t57*t60*t6
     ;           1-3.125d-2*rhoa*t163*t181*t41*t60*t61-3.125d-2*rhob*t10
     <           2*t163*t181*t60*t61-4.8579204483835753d-4*rhob*t163*t16
     =           4*t304*t332*t57*t58*t60+1.6325733115771002d-3*rhoa*t164
     >           *t177*t379*t41*t47*t51*t53*t58*t60+1.6325733115771002d-
     ?           3*rhob*t102*t164*t177*t379*t47*t51*t53*t58*t60-3.125d-2
     @           *rhoa*t163*t164*t41*t57*t60-3.125d-2*rhob*t102*t163*t16
     1           4*t57*t60+t159*(3.109069086965489d-2*t139*t252*(-1.3621
     2           078885675922d-1*t141*t143*t149*t266*t58*(-8.65824353379
     3           0966d-2*t150*t153*t256*t516*t58+t532+t531+t530-7.421351
     4           600392256d-2*t141*t145*t150*t151*t263*t269-1.4842703200
     5           784513d-1*t141*t151*t153*t255*t268+3.710675800196128d-2
     6           *t141*t150*t153*t267)+1.3621078885675922d-1*t141*t143*t
     7           155*(t532+t531+t530)*t58+2.7242157771351844d-1*t141*t14
     8           3*t149*t270*t334*t440*t58-1.855337900098064d-2*t147*t15
     9           0*t266*t270*t335*t58-3.710675800196128d-2*t147*t155*t25
     :           5*t268*t335*t58-1.3621078885675922d-1*t141*t143*t265*t2
     ;           66*t334*t58+2.7242157771351844d-1*t141*t144*t149*t255*t
     <           266*t334*t58+t529+t528+t527+7.421351600392257d-52*t147*
     =           t150*t155*t335-5.44843155427037d-51*t141*t143*t149*t266
     >           *t334-1.3621078885675922d-1*t141*t143*t149*t266*t270+1.
     ?           3621078885675922d-1*t141*t143*t155*t265-2.7242157771351
     @           844d-1*t141*t144*t149*t155*t255)-3.109069086965489d-2*t
     1           139*t271*t336*t441+9.327207260896466d-2*t142*t252*t255*
     2           t336)+3.125d-2*rhoa*t125*t339*t41*t57*t58+3.125d-2*rhob
     3           *t102*t125*t339*t57*t58+t526+t525+t521+t520+t519+3.1090
     4           69086965489d-2*t139*t218*t252*t336+t272*t333
              t534 = -1.6406249999999997d-2*t160*t163*t60*t62
              t535 = 1.0d+0*t160*t338*wght
              t536 = 1.0d+0*t162*t337*wght
              t537 = 1/t1**6.666666666666667d+0
              t538 = 1.3060586492616802d-2*t280*t48*t53+t522+2.612117298
     1           5233604d-2*t278*t48*t50*t51
              t539 = -4.0d+0*t177*t47*t538+2.6121172985233604d-1*t281*t3
     1           68*t47*t48*t51*t53-5.224234597046721d-2*t177*t282*t48*t
     2           51*t53
              t540 = -5.045160155481552d-1*t305*t306*t93
              t541 = 1.3909060459745137d+1*t303*t308*t90*t91
              t542 = 1/t1**5.666666666666667d+0
              t543 = -2.7242157771351844d-1*t141*t144*t147*t320
              t544 = -1.3621078885675922d-1*t141*t143*t145*t262*t322
              t545 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2*
     1           t304*(-2.1622114952063792d-1*gammabb*t311*t90*t95*(-4.3
     2           63481313335766d-1*gammabb*t305*t500*t98+1.2029732165432
     3           584d+1*t303*t312*t90*t91*t96+t541+t540)+4.3244229904127
     4           585d-1*gammabb*t313*t330*t501*t90*t95-2.162211495206379
     5           2d-1*t311*t313*t90*t95+5.045160155481552d-1*gammabb*t30
     6           5*t306*t311*t330*t95-5.045160155481552d-1*t100*t305*t30
     7           6*t95-1.0908703283339415d-1*gammabb*t100*t305*t500*t93-
     8           4.675158550002606d-2*gammabb*t311*t313*t331*t93+2.16221
     9           14952063792d-1*gammabb*t100*(t541+t540)*t90-2.162211495
     :           2063792d-1*gammabb*t310*t311*t330*t90+2.162211495206379
     ;           2d-1*t100*t310*t90)-1.5545345434827443d-2*t314*t332*t50
     <           2)+t158*(-6.25d-2*t177*t47*t538*t62+4.0814332789427504d
     =           -3*t281*t368*t47*t48*t51*t53*t62-8.162866557885502d-4*t
     >           177*t282*t48*t51*t53*t62+3.125d-2*t282*t42*t56*t60*t61-
     ?           1.25d-1*t177*t281*t42*t47*t60*t61-6.25d-2*t276*t339*t47
     @           *t56*t58+1.6325733115771002d-3*t177*t339*t468*t47*t51*t
     1           53*t542)-2.4289602241917876d-4*t304*t332*t42*t57*t62-1.
     2           5625d-2*rhoa*t41*t42*t539*t62-1.5625d-2*rhob*t102*t42*t
     3           539*t62+8.162866557885502d-4*rhob*t174*t177*t315*t47*t5
     4           1*t53*t62+8.162866557885502d-4*t102*t174*t177*t47*t51*t
     5           53*t62-2.4289602241917876d-4*rhob*t283*t304*t332*t42*t6
     6           2-3.125d-2*rhob*t163*t315*t57*t60*t61-3.125d-2*t102*t16
     7           3*t57*t60*t61-3.125d-2*rhoa*t163*t283*t41*t60*t61-3.125
     8           d-2*rhob*t102*t163*t283*t60*t61+t159*(3.109069086965489
     9           d-2*t139*t252*(-1.3621078885675922d-1*t141*t143*t149*t2
     :           66*t58*(-1.7316487067581932d-1*t150*t153*t256*t516*t58+
     ;           t544+t543+t531-7.421351600392256d-2*t141*t145*t150*t151
     <           *t269*t322-1.4842703200784513d-1*t141*t151*t153*t268*t3
     =           20)+1.3621078885675922d-1*t141*t143*t155*(t544+t543+t53
     >           1)*t58+2.7242157771351844d-1*t141*t143*t149*t325*t334*t
     ?           440*t58-1.855337900098064d-2*t147*t150*t266*t325*t335*t
     @           58-3.710675800196128d-2*t147*t155*t268*t320*t335*t58-1.
     1           3621078885675922d-1*t141*t143*t266*t324*t334*t58+2.7242
     2           157771351844d-1*t141*t144*t149*t266*t320*t334*t58+t529+
     3           t528+t527-1.3621078885675922d-1*t141*t143*t149*t266*t32
     4           5+1.3621078885675922d-1*t141*t143*t155*t324-2.724215777
     5           1351844d-1*t141*t144*t149*t155*t320)-3.109069086965489d
     6           -2*t139*t326*t336*t441+9.327207260896466d-2*t142*t252*t
     7           320*t336)+6.25d-2*rhoa*t125*t339*t41*t57*t58+6.25d-2*rh
     8           ob*t102*t125*t339*t57*t58+4.8579204483835753d-4*rhob*t1
     9           25*t304*t332*t339*t468*t57-1.6325733115771002d-3*rhoa*t
     :           177*t339*t41*t468*t47*t51*t53*t537-1.6325733115771002d-
     ;           3*rhob*t102*t177*t339*t468*t47*t51*t53*t537+t526+t525+t
     <           521+t520+t519+3.109069086965489d-2*t139*t252*t316*t336+
     =           t327*t333
              t546 = 1/t1**6.333333333333333d+0
              t547 = t50**4
              t548 = t51**2
              t549 = -2.4289602241917876d-4*rhob*t304*t42*t57*t62*(-2.02
     1           17363117456047d-2*gammabb*t311*t499*t95*t98+4.324422990
     2           4127585d-1*gammabb*t330**2*t501*t90*t95-4.3244229904127
     3           585d-1*t311*t330*t90*t95-9.350317100005212d-2*gammabb*t
     4           311*t330*t331*t93+9.350317100005212d-2*t100*t331*t93)+t
     5           158*(5.330591235347639d-5*t368*t47*t547*t548*t62/t1**5.
     6           333333333333333d+0-1.6325733115771002d-3*t174*t177*t47*
     7           t51*t53*t60*t61-1.6325733115771002d-3*t177*t339*t379*t4
     8           7*t51*t53*t58+3.125d-2*t163*t339*t47*t56)+2.42896022419
     9           17876d-4*rhob*t332**2*t42*t502*t57*t62-5.33059123534763
     :           9d-5*rhoa*t368*t41*t47*t546*t547*t548*t62-5.33059123534
     ;           7639d-5*rhob*t102*t368*t47*t546*t547*t548*t62+2.5378916
     <           076146196d-5*rhob*t174*t177*t304*t332*t47*t51*t53*t62-4
     =           .8579204483835753d-4*rhob*t163*t304*t332*t57*t60*t61+1.
     >           6325733115771002d-3*rhoa*t177*t379*t41*t47*t51*t53*t60*
     ?           t61+1.6325733115771002d-3*rhob*t102*t177*t379*t47*t51*t
     @           53*t60*t61+3.109069086965489d-2*t139*t159*t252*(-5.0543
     1           40779364009d-3*t149*t153*t266*t438*t517*t58+2.724215777
     2           1351844d-1*t141*t143*t149*t334**2*t440*t58-3.7106758001
     3           96128d-2*t147*t150*t266*t334*t335*t58+3.710675800196128
     4           d-2*t147*t150*t155*t335-2.7242157771351844d-1*t141*t143
     5           *t149*t266*t334)-4.8579204483835753d-4*rhob*t276*t304*t
     6           332*t339*t57*t58+1.6325733115771002d-3*rhoa*t177*t339*t
     7           41*t47*t51*t53*t542*t58+1.6325733115771002d-3*rhob*t102
     8           *t177*t339*t47*t51*t53*t542*t58-3.125d-2*rhoa*t276*t339
     9           *t41*t57-3.125d-2*rhob*t102*t276*t339*t57-3.10906908696
     :           5489d-2*t139*t159*t336**2*t441+6.218138173930978d-2*t13
     ;           9*t252*t333*t336
              t550 = 1.0d+0*t160*t341*wght
              t551 = t163*t339*t58-4.0d-50*t339*t42
              t552 = -3.125d-2*rhoa*t276*t339*t41*t57*t58*t61
              t553 = -3.125d-2*rhob*t102*t276*t339*t57*t58*t61
              t554 = t158*(-3.125d-2*t180*t339*t42*t56*t58*t61+1.25d-1*t
     1           176*t177*t339*t42*t47*t58*t61+3.125d-2*t42*t47*t551*t56
     2           *t58*t60-3.125d-2*t164*t339*t42*t47*t56*t58)+3.125d-2*t
     3           163*t339*t41*t57*t58*t61+3.125d-2*rhoa*t163*t216*t339*t
     4           57*t58*t61-3.125d-2*t272*t339*t42*t47*t56*t58*t61+3.125
     5           d-2*rhoa*t163*t181*t339*t41*t58*t61+3.125d-2*rhob*t102*
     6           t163*t181*t339*t58*t61-3.125d-2*rhoa*t163*t41*t551*t57*
     7           t58*t60-3.125d-2*rhob*t102*t163*t551*t57*t58*t60+3.125d
     8           -2*rhoa*t163*t164*t339*t41*t57*t58+3.125d-2*rhob*t102*t
     9           163*t164*t339*t57*t58+t553+t552
              t555 = 1.0d+0*t162*t340*wght
              t556 = 1/t59**3
              t557 = t158*(-3.125d-2*t282*t339*t42*t56*t58*t61+1.25d-1*t
     1           177*t281*t339*t42*t47*t58*t61+6.25d-2*t276*t468*t47*t55
     2           6*t56)+3.125d-2*rhob*t163*t315*t339*t57*t58*t61+3.125d-
     3           2*t102*t163*t339*t57*t58*t61-3.125d-2*t327*t339*t42*t47
     4           *t56*t58*t61+3.125d-2*rhoa*t163*t283*t339*t41*t58*t61+3
     5           .125d-2*rhob*t102*t163*t283*t339*t58*t61-6.25d-2*rhoa*t
     6           125*t41*t468*t556*t57-6.25d-2*rhob*t102*t125*t468*t556*
     7           t57+t553+t552
              t558 = t158*(1.6325733115771002d-3*t174*t177*t339*t47*t51*
     1           t53*t58*t61-6.25d-2*t163*t47*t556*t56*t58)+4.8579204483
     2           835753d-4*rhob*t163*t304*t332*t339*t57*t58*t61-9.715840
     3           896767153d-4*t139*t252*t336*t339*t42*t47*t56*t58*t61-1.
     4           6325733115771002d-3*rhoa*t177*t339*t379*t41*t47*t51*t53
     5           *t58*t61-1.6325733115771002d-3*rhob*t102*t177*t339*t379
     6           *t47*t51*t53*t58*t61+6.25d-2*rhoa*t276*t41*t556*t57*t58
     7           +6.25d-2*rhob*t102*t276*t556*t57*t58
              t559 = 1/t59**4
              t560 = -9.375d-2*rhoa*t276*t41*t468*t559*t57-9.375d-2*rhob
     1           *t102*t276*t468*t559*t57+9.375d-2*t158*t163*t468*t47*t5
     2           59*t56
              fnc(iq) = 1.0d+0*t1*t160*t162*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t160*t274*wght+1.0d+0*t1*t162*t
     1           273*wght+t275+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t160*t329*wght+1.0d+0*t1*t162*t
     1           328*wght+t275+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = 1.0d+0*t1*t160*t338*wght+1.0d+0*t1*t162*
     1           t337*wght+Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = 1.0d+0*t1*t160*t341*wght+1.0d+0*t1*t162*t
     1           340*wght+Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 1.0d+0*t1*t160*(1.6406249999999997d-2
     1           *t160*t343*t62+3.2812499999999994d-2*t164*t273*t62+3.28
     2           12499999999994d-2*t160*t442*t61+5.46875d-3*t161*t443)*w
     3           ght+1.0d+0*t1*t162*t443*wght+2.0d+0*t1*t273*t274*wght+2
     4           .0d+0*t160*t274*wght+2.0d+0*t162*t273*wght+Amat2(iq,D2_
     5           RA_RA)
              Amat2(iq,D2_RA_RB) = 1.0d+0*t1*t160*(-1.6406249999999997d-
     1           2*t163*t273*t58*t60*t62+1.6406249999999997d-2*t160*t446
     2           *t62+1.6406249999999997d-2*t164*t328*t62-3.281249999999
     3           9994d-2*t160*t163*t164*t58*t60*t61+5.46875d-3*t161*t467
     4           )*wght+1.0d+0*t1*t162*t467*wght+1.0d+0*t1*t273*t329*wgh
     5           t+1.0d+0*t160*t329*wght+1.0d+0*t1*t274*t328*wght+1.0d+0
     6           *t162*t328*wght+1.0d+0*t160*t274*wght+1.0d+0*t162*t273*
     7           wght+Amat2(iq,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t160*(-3.2812499999999994d-
     1           2*t163*t328*t58*t60*t62+3.2812499999999994d-2*t160*t276
     2           *t58*t60*t62+3.2812499999999994d-2*t125*t160*t339*t468*
     3           t61+5.46875d-3*t161*t518)*wght+1.0d+0*t1*t162*t518*wght
     4           +2.0d+0*t1*t328*t329*wght+2.0d+0*t160*t329*wght+2.0d+0*
     5           t162*t328*wght+Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = 1.0d+0*t1*t160*(1.6406249999999997d-
     1           2*t273*t42*t60*t62+1.6406249999999997d-2*t164*t337*t62+
     2           3.2812499999999994d-2*t160*t164*t42*t60*t61+t534+5.4687
     3           5d-3*t161*t533)*wght+1.0d+0*t1*t162*t533*wght+1.0d+0*t1
     4           *t273*t338*wght+1.0d+0*t1*t274*t337*wght+t536+t535+Cmat
     5           2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = 1.0d+0*t1*t160*(-1.6406249999999997d
     1           -2*t163*t337*t58*t60*t62+1.6406249999999997d-2*t328*t42
     2           *t60*t62-3.2812499999999994d-2*t160*t276*t339*t58*t61+5
     3           .46875d-3*t161*t545+t534)*wght+1.0d+0*t1*t162*t545*wght
     4           +1.0d+0*t1*t328*t338*wght+1.0d+0*t1*t329*t337*wght+t536
     5           +t535+Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = 1.0d+0*t1*t160*(3.2812499999999994d
     1           -2*t337*t42*t60*t62+3.2812499999999994d-2*t160*t163*t33
     2           9*t61+5.46875d-3*t161*t549)*wght+1.0d+0*t1*t162*t549*wg
     3           ht+2.0d+0*t1*t337*t338*wght+Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = 1.0d+0*t1*t160*(-1.6406249999999997d-
     1           2*t273*t339*t42*t58*t62+1.6406249999999997d-2*t160*t551
     2           *t62+1.6406249999999997d-2*t164*t340*t62-3.281249999999
     3           9994d-2*t160*t164*t339*t42*t58*t61+5.46875d-3*t161*t554
     4           )*wght+1.0d+0*t1*t162*t554*wght+1.0d+0*t1*t273*t341*wgh
     5           t+1.0d+0*t1*t274*t340*wght+t555+t550+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = 1.0d+0*t1*t160*(-1.6406249999999997d-
     1           2*t163*t340*t58*t60*t62-1.6406249999999997d-2*t328*t339
     2           *t42*t58*t62+1.6406249999999997d-2*t160*t163*t339*t58*t
     3           62+3.2812499999999994d-2*t160*t276*t468*t556*t61+5.4687
     4           5d-3*t161*t557)*wght+1.0d+0*t1*t162*t557*wght+1.0d+0*t1
     5           *t328*t341*wght+1.0d+0*t1*t329*t340*wght+t555+t550+Mmat
     6           2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = 1.0d+0*t1*t160*(1.6406249999999997d-
     1           2*t340*t42*t60*t62-1.6406249999999997d-2*t337*t339*t42*
     2           t58*t62-1.6406249999999997d-2*t160*t339*t42*t62-3.28124
     3           99999999994d-2*t160*t163*t556*t58*t61+5.46875d-3*t161*t
     4           558)*wght+1.0d+0*t1*t162*t558*wght+1.0d+0*t1*t337*t341*
     5           wght+1.0d+0*t1*t338*t340*wght+Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = 1.0d+0*t1*t160*(3.2812499999999994d-2
     1           *t160*t42*t556*t58*t62-3.2812499999999994d-2*t339*t340*
     2           t42*t58*t62+3.2812499999999994d-2*t160*t163*t468*t559*t
     3           61+5.46875d-3*t161*t560)*wght+1.0d+0*t1*t162*t560*wght+
     4           2.0d+0*t1*t340*t341*wght+Mmat2(iq,D2_TB_TB)
            else 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 8.648845980825518d-51*rhoa*t29*t32
              t34 = t33+1.0d+0
              t35 = rhoa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 7.480253680004171d-101*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 8.648845980825518d-51*rhoa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = 4.0d-50*rhob+4.0d-50*rhoa
              t44 = t42*t43
              t45 = t44**2.0d+0
              t46 = rhoa-rhob
              t47 = t42*t46
              t48 = t47**2.0d+0
              t49 = t47**4.0d+0
              t50 = 5.0d-1*t49+8.7d-1*t48+2.2599999999999998d+0*t47**6.0
     1           d+0+5.3d-1
              t51 = 1/t1**2.6666666666666666d+0
              t52 = 1.0d+0-t42*t46
              t53 = t47+1.0d+0
              t54 = 1/t53**1.333333333333333d+0+1/t52**1.333333333333333
     1           d+0
              t55 = t52**2
              t56 = t53**2
              t57 = 4.0d-50*rhob*t56+4.0d-50*rhoa*t55
              t58 = 1.3060586492616802d-2*t51*t54*t57+1.0d+0
              t59 = 1/t58**4.0d+0
              t60 = t50*t59+1.0d+0
              t61 = rhob**3.333333333333333d-1
              t62 = t61**5.0d-1
              t63 = 1/t62
              t64 = 1.530901310039024d-2*t63+1.0465751434d-1
              t65 = 7.876233178997433d-1*t63*t64+1.9269083139d-1
              t66 = 7.876233178997433d-1*t63*t65+4.3896648423d-1
              t67 = 1/t66
              t68 = 1.269642451250142d+0*t62*t67+1.0d+0
              t69 = log(t68)
              t70 = 1/t61
              t71 = 1.2746961887000874d-1*t70+1.0d+0
              t72 = 2.4141993114533214d-2*t63+1.0186556948d-1
              t73 = 7.876233178997433d-1*t63*t72+2.2308199064d-1
              t74 = 7.876233178997433d-1*t63*t73+4.7231125998d-1
              t75 = 1/t74
              t76 = 1.269642451250142d+0*t62*t75+1.0d+0
              t77 = log(t76)
              t78 = 1.325688999052018d-1*t70+1.0d+0
              t79 = 1.3212998810398843d-2*t63+2.9729725188d-2
              t80 = 7.876233178997433d-1*t63*t79+1.2236585478d-1
              t81 = 7.876233178997433d-1*t63*t80+3.497952466d-1
              t82 = 1/t81
              t83 = 1.269642451250142d+0*t62*t82+1.0d+0
              t84 = log(t83)
              t85 = 6.901399211255826d-2*t70+1.0d+0
              t86 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t77*t78-3.10907d-2*t69*t71)-3.37738d-2*t84*t
     2           85)+3.37738d-2*t84*t85)-6.21814d-2*t77*t78
              t87 = rhob**1.1666666666666667d+0
              t88 = 1/t87**2.0d+0
              t89 = exp(-6.432793688582967d+1*t86)
              t90 = t89-1.0d+0
              t91 = 1/t90
              t92 = 8.648845980825518d-51*rhob*t88*t91
              t93 = t92+1.0d+0
              t94 = rhob*t88
              t95 = t94**2.0d+0
              t96 = 1/t90**2.0d+0
              t97 = 7.480253680004171d-101*t95*t96+t92+1.0d+0
              t98 = 1/t97
              t99 = 8.648845980825518d-51*rhob*t88*t93*t98+1.0d+0
              t100 = 1.5545345434827443d-2*log(t99)+1.0d+0*t86
              t101 = 3.9062500000000006d+97*t45*t50*t59+1.0d+0
              t102 = t1**3.333333333333333d-1
              t103 = 1/t102
              t104 = 1.325688999052018d-1*t103+1.0d+0
              t105 = t102**5.0d-1
              t106 = 1/t105
              t107 = 2.4141993114533214d-2*t106+1.0186556948d-1
              t108 = 7.876233178997433d-1*t106*t107+2.2308199064d-1
              t109 = 7.876233178997433d-1*t106*t108+4.7231125998d-1
              t110 = 1/t109
              t111 = 1.269642451250142d+0*t105*t110+1.0d+0
              t112 = log(t111)
              t113 = t52**1.3333333333333333d+0
              t114 = t53**1.3333333333333333d+0
              t115 = 1.923661050931536d+0*t114+1.923661050931536d+0*t113
     1           -3.847322101863072d+0
              t116 = 6.901399211255826d-2*t103+1.0d+0
              t117 = 1.3212998810398843d-2*t106+2.9729725188d-2
              t118 = 7.876233178997433d-1*t106*t117+1.2236585478d-1
              t119 = 7.876233178997433d-1*t106*t118+3.497952466d-1
              t120 = 1/t119
              t121 = 1.269642451250142d+0*t105*t120+1.0d+0
              t122 = log(t121)
              t123 = t46**4
              t124 = 1/t1**4
              t125 = 1.2746961887000874d-1*t103+1.0d+0
              t126 = 1.530901310039024d-2*t106+1.0465751434d-1
              t127 = 7.876233178997433d-1*t106*t126+1.9269083139d-1
              t128 = 7.876233178997433d-1*t106*t127+4.3896648423d-1
              t129 = 1/t128
              t130 = 1.269642451250142d+0*t105*t129+1.0d+0
              t131 = log(t130)
              t132 = 1.709920934161365d+0*(6.21814d-2*t104*t112-3.10907d
     1           -2*t125*t131)-3.37738d-2*t116*t122
              t133 = t123*t124*t132+3.37738d-2*t116*t122
              t134 = 5.848223622634648d-1*t115*t133-6.21814d-2*t104*t112
              t135 = t52**6.666666666666666d-1
              t136 = t53**6.666666666666666d-1
              t137 = 5.0d-1*t136+5.0d-1*t135
              t138 = t137**3.0d+0
              t139 = t1**1.1666666666666667d+0
              t140 = 1/t139**2.0d+0
              t141 = t137**2.0d+0
              t142 = 1/t141
              t143 = 1/t138
              t144 = exp(-3.216396844291483d+1*t134*t143)
              t145 = t144-1.0d+0
              t146 = 1/t145
              t147 = 1.3621078885675922d-1*t140*t142*t146*t43
              t148 = t147+1.0d+0
              t149 = 1/t137**4.0d+0
              t150 = t140*t43
              t151 = t150**2.0d+0
              t152 = 1/t145**2.0d+0
              t153 = 1.855337900098064d-2*t149*t151*t152+t147+1.0d+0
              t154 = 1/t153
              t155 = 1.3621078885675922d-1*t140*t142*t148*t154*t43+1.0d+
     1           0
              t156 = log(t155)
              t157 = 3.109069086965489d-2*t138*t156+1.0d+0*t134
              t158 = -3.9062500000000006d+97*rhoa*t41*t42*t45*t60-3.9062
     1           500000000006d+97*rhob*t100*t42*t45*t60+t101*t157
              t159 = t44**3.0d+0
              t160 = 6.835937500000002d+146*t158*t159+1.0d+0
              t161 = 1/t1**2
              t162 = t161*t46
              t163 = -t42
              t164 = t163+t162
              t165 = -t161*t46
              t166 = t42+t165
              t167 = 4.0d-50*t55+8.0d-50*rhob*t166*t53+8.0d-50*rhoa*t164
     1           *t52
              t168 = 1/t52**2.333333333333333d+0
              t169 = 1/t53**2.333333333333333d+0
              t170 = -1.333333333333333d+0*t166*t169-1.333333333333333d+
     1           0*t164*t168
              t171 = 1/t1**3.6666666666666664d+0
              t172 = -3.482823064697814d-2*t171*t54*t57
              t173 = 1.3060586492616802d-2*t170*t51*t57+1.30605864926168
     1           02d-2*t167*t51*t54+t172
              t174 = 1/t58**5.0d+0
              t175 = t47**3.0d+0
              t176 = t47**5.0d+0
              t177 = 1.74d+0*t166*t47+1.356d+1*t166*t176+2.0d+0*t166*t17
     1           5
              t178 = t177*t59-4.0d+0*t173*t174*t50
              t179 = 4.0d-50*t42-t161*t43
              t180 = -7.812500000000001d+97*rhoa*t179*t41*t42*t44*t60
              t181 = 3.9062500000000006d+97*rhoa*t161*t41*t45*t60
              t182 = 1/rhoa**1.3333333333333333d+0
              t183 = 1/t9
              t184 = 1/t7**2
              t185 = rhoa**1.3333333333333336d+0
              t186 = 1/t185
              t187 = 1/t3**3
              t188 = 1/rhoa**6.666666666666667d-1
              t189 = -1.3127055298329054d-1*t187*t188*t5-2.0096226153166
     1           658d-3*t186
              t190 = 7.876233178997433d-1*t189*t4-1.3127055298329054d-1*
     1           t187*t188*t6
              t191 = 2.11607075208357d-1*t188*t4*t8-1.269642451250142d+0
     1           *t184*t190*t3
              t192 = 1/t17
              t193 = 1/t15**2
              t194 = -1.3127055298329054d-1*t13*t187*t188-3.169132786263
     1           567d-3*t186
              t195 = 7.876233178997433d-1*t194*t4-1.3127055298329054d-1*
     1           t14*t187*t188
              t196 = 2.11607075208357d-1*t16*t188*t4-1.269642451250142d+
     1           0*t193*t195*t3
              t197 = 1/t24
              t198 = 1/t22**2
              t199 = -1.3127055298329054d-1*t187*t188*t20-1.734477660408
     1           6162d-3*t186
              t200 = 7.876233178997433d-1*t199*t4-1.3127055298329054d-1*
     1           t187*t188*t21
              t201 = 2.11607075208357d-1*t188*t23*t4-1.269642451250142d+
     1           0*t198*t200*t3
              t202 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t197*t201
     1           *t26+7.769549222703733d-4*t182*t25+1.709920934161365d+0
     2           *(6.21814d-2*t19*t192*t196-3.10907d-2*t12*t183*t191-2.7
     3           47773264188438d-3*t18*t182+1.3210398931339265d-3*t10*t1
     4           82))+3.37738d-2*t197*t201*t26-7.769549222703733d-4*t182
     5           *t25)-6.21814d-2*t19*t192*t196+2.747773264188438d-3*t18
     6           *t182
              t203 = 1/t40
              t204 = 1/t28**3.0d+0
              t205 = -2.018064062192621d-50*t204*t28*t32
              t206 = 8.648845980825518d-51*t29*t32
              t207 = 1/t31**2
              t208 = 5.563624183898056d-49*rhoa*t202*t207*t29*t30
              t209 = t208+t206+t205
              t210 = 1/t38**2
              t211 = t29-2.3333333333333334d+0*t204*t28
              t212 = 1/t31**3.0d+0
              t213 = 1.4960507360008343d-100*t211*t35*t37+9.623785732346
     1           068d-99*t202*t212*t30*t36+t208+t206+t205
              t214 = 8.648845980825518d-51*t29*t34*t39-2.018064062192621
     1           d-50*t204*t28*t34*t39+8.648845980825518d-51*rhoa*t209*t
     2           29*t39-8.648845980825518d-51*rhoa*t210*t213*t29*t34
              t215 = 1.5545345434827443d-2*t203*t214+1.0d+0*t202
              t216 = -7.812500000000001d+97*rhob*t100*t179*t42*t44*t60
              t217 = 3.9062500000000006d+97*rhob*t100*t161*t45*t60
              t218 = 1/t1**1.3333333333333336d+0
              t219 = 1/t1**6.666666666666667d-1
              t220 = 1/t105**3
              t221 = -1.3127055298329054d-1*t107*t219*t220-3.16913278626
     1           3567d-3*t218
              t222 = 7.876233178997433d-1*t106*t221-1.3127055298329054d-
     1           1*t108*t219*t220
              t223 = 1/t109**2
              t224 = 2.11607075208357d-1*t106*t110*t219-1.26964245125014
     1           2d+0*t105*t222*t223
              t225 = 1/t111
              t226 = -6.21814d-2*t104*t224*t225
              t227 = 1/t1**1.3333333333333333d+0
              t228 = 2.747773264188438d-3*t112*t227
              t229 = -1.3127055298329054d-1*t117*t219*t220-1.73447766040
     1           86162d-3*t218
              t230 = 7.876233178997433d-1*t106*t229-1.3127055298329054d-
     1           1*t118*t219*t220
              t231 = 1/t119**2
              t232 = 2.11607075208357d-1*t106*t120*t219-1.26964245125014
     1           2d+0*t105*t230*t231
              t233 = 1/t121
              t234 = 3.37738d-2*t116*t232*t233
              t235 = -7.769549222703733d-4*t122*t227
              t236 = -1.3127055298329054d-1*t126*t219*t220-2.00962261531
     1           66658d-3*t218
              t237 = 7.876233178997433d-1*t106*t236-1.3127055298329054d-
     1           1*t127*t219*t220
              t238 = 1/t128**2
              t239 = 2.11607075208357d-1*t106*t129*t219-1.26964245125014
     1           2d+0*t105*t237*t238
              t240 = 1/t130
              t241 = 1.709920934161365d+0*(-3.10907d-2*t125*t239*t240+1.
     1           3210398931339265d-3*t131*t227-2.747773264188438d-3*t112
     2           *t227+6.21814d-2*t104*t224*t225)-3.37738d-2*t116*t232*t
     3           233+7.769549222703733d-4*t122*t227
              t242 = t123*t124*t241
              t243 = 1/t1**5
              t244 = -4*t123*t132*t243
              t245 = t46**3
              t246 = 4*t124*t132*t245+t244+t242+t235+t234
              t247 = t52**3.333333333333333d-1
              t248 = t53**3.333333333333333d-1
              t249 = 2.564881401242048d+0*t166*t248+2.564881401242048d+0
     1           *t164*t247
              t250 = 5.848223622634648d-1*t133*t249+5.848223622634648d-1
     1           *t115*t246+t228+t226
              t251 = 1/t155
              t252 = 1/t247
              t253 = 1/t248
              t254 = 3.333333333333333d-1*t166*t253+3.333333333333333d-1
     1           *t164*t252
              t255 = t1**1.6666666666666674d-1
              t256 = 1/t139**3.0d+0
              t257 = -3.1782517399910487d-1*t142*t148*t154*t255*t256*t43
              t258 = 5.44843155427037d-51*t140*t142*t148*t154
              t259 = -2.7242157771351844d-1*t140*t143*t146*t254*t43
              t260 = -3.1782517399910487d-1*t142*t146*t255*t256*t43
              t261 = 5.44843155427037d-51*t140*t142*t146
              t262 = 1/t145**2
              t263 = 9.649190532874448d+1*t134*t149*t254-3.2163968442914
     1           83d+1*t143*t250
              t264 = -1.3621078885675922d-1*t140*t142*t144*t262*t263*t43
              t265 = t264+t261+t260+t259
              t266 = 1/t153**2
              t267 = 4.0d-50*t140-2.3333333333333334d+0*t255*t256*t43
              t268 = 3.710675800196128d-2*t149*t150*t152*t267
              t269 = 1/t137**5.0d+0
              t270 = 1/t145**3.0d+0
              t271 = -3.710675800196128d-2*t144*t149*t151*t263*t270-7.42
     1           1351600392256d-2*t151*t152*t254*t269+t268+t264+t261+t26
     2           0+t259
              t272 = -1.3621078885675922d-1*t140*t142*t148*t266*t271*t43
     1           +1.3621078885675922d-1*t140*t142*t154*t265*t43-2.724215
     2           7771351844d-1*t140*t143*t148*t154*t254*t43+t258+t257
              t273 = 3.109069086965489d-2*t138*t251*t272+9.3272072608964
     1           66d-2*t141*t156*t254+1.0d+0*t250
              t274 = 7.812500000000001d+97*t179*t44*t50*t59
              t275 = 3.9062500000000006d+97*t177*t45*t59-1.5625000000000
     1           003d+98*t173*t174*t45*t50+t274
              t276 = -3.9062500000000006d+97*t41*t42*t45*t60-3.906250000
     1           0000006d+97*rhoa*t215*t42*t45*t60-3.9062500000000006d+9
     2           7*rhoa*t178*t41*t42*t45-3.9062500000000006d+97*rhob*t10
     3           0*t178*t42*t45+t157*t275+t101*t273+t217+t216+t181+t180
              t277 = 2.0507812500000006d+147*t158*t179*t45
              t278 = t277+6.835937500000002d+146*t159*t276
              t279 = 1.0d+0*t158*t160*wght
              t280 = t42+t162
              t281 = t165+t163
              t282 = 4.0d-50*t56+8.0d-50*rhob*t281*t53+8.0d-50*rhoa*t280
     1           *t52
              t283 = -1.333333333333333d+0*t169*t281-1.333333333333333d+
     1           0*t168*t280
              t284 = 1.3060586492616802d-2*t283*t51*t57+1.30605864926168
     1           02d-2*t282*t51*t54+t172
              t285 = 1.74d+0*t281*t47+1.356d+1*t176*t281+2.0d+0*t175*t28
     1           1
              t286 = t285*t59-4.0d+0*t174*t284*t50
              t287 = 1/rhob**1.3333333333333333d+0
              t288 = 1/t68
              t289 = 1/t66**2
              t290 = rhob**1.3333333333333336d+0
              t291 = 1/t290
              t292 = 1/t62**3
              t293 = 1/rhob**6.666666666666667d-1
              t294 = -1.3127055298329054d-1*t292*t293*t64-2.009622615316
     1           6658d-3*t291
              t295 = 7.876233178997433d-1*t294*t63-1.3127055298329054d-1
     1           *t292*t293*t65
              t296 = 2.11607075208357d-1*t293*t63*t67-1.269642451250142d
     1           +0*t289*t295*t62
              t297 = 1/t76
              t298 = 1/t74**2
              t299 = -1.3127055298329054d-1*t292*t293*t72-3.169132786263
     1           567d-3*t291
              t300 = 7.876233178997433d-1*t299*t63-1.3127055298329054d-1
     1           *t292*t293*t73
              t301 = 2.11607075208357d-1*t293*t63*t75-1.269642451250142d
     1           +0*t298*t300*t62
              t302 = 1/t83
              t303 = 1/t81**2
              t304 = -1.3127055298329054d-1*t292*t293*t79-1.734477660408
     1           6162d-3*t291
              t305 = 7.876233178997433d-1*t304*t63-1.3127055298329054d-1
     1           *t292*t293*t80
              t306 = 2.11607075208357d-1*t293*t63*t82-1.269642451250142d
     1           +0*t303*t305*t62
              t307 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t302*t306
     1           *t85+7.769549222703733d-4*t287*t84+1.709920934161365d+0
     2           *(6.21814d-2*t297*t301*t78-2.747773264188438d-3*t287*t7
     3           7-3.10907d-2*t288*t296*t71+1.3210398931339265d-3*t287*t
     4           69))+3.37738d-2*t302*t306*t85-7.769549222703733d-4*t287
     5           *t84)-6.21814d-2*t297*t301*t78+2.747773264188438d-3*t28
     6           7*t77
              t308 = 1/t99
              t309 = 1/t87**3.0d+0
              t310 = -2.018064062192621d-50*t309*t87*t91
              t311 = 8.648845980825518d-51*t88*t91
              t312 = 1/t90**2
              t313 = 5.563624183898056d-49*rhob*t307*t312*t88*t89
              t314 = t313+t311+t310
              t315 = 1/t97**2
              t316 = t88-2.3333333333333334d+0*t309*t87
              t317 = 1/t90**3.0d+0
              t318 = 1.4960507360008343d-100*t316*t94*t96+9.623785732346
     1           068d-99*t307*t317*t89*t95+t313+t311+t310
              t319 = 8.648845980825518d-51*t88*t93*t98-2.018064062192621
     1           d-50*t309*t87*t93*t98+8.648845980825518d-51*rhob*t314*t
     2           88*t98-8.648845980825518d-51*rhob*t315*t318*t88*t93
              t320 = 1.5545345434827443d-2*t308*t319+1.0d+0*t307
              t321 = -4*t124*t132*t245+t244+t242+t235+t234
              t322 = 2.564881401242048d+0*t248*t281+2.564881401242048d+0
     1           *t247*t280
              t323 = 5.848223622634648d-1*t133*t322+5.848223622634648d-1
     1           *t115*t321+t228+t226
              t324 = 3.333333333333333d-1*t253*t281+3.333333333333333d-1
     1           *t252*t280
              t325 = -2.7242157771351844d-1*t140*t143*t146*t324*t43
              t326 = 9.649190532874448d+1*t134*t149*t324-3.2163968442914
     1           83d+1*t143*t323
              t327 = -1.3621078885675922d-1*t140*t142*t144*t262*t326*t43
              t328 = t327+t325+t261+t260
              t329 = t327-3.710675800196128d-2*t144*t149*t151*t270*t326+
     1           t325-7.421351600392256d-2*t151*t152*t269*t324+t268+t261
     2           +t260
              t330 = -1.3621078885675922d-1*t140*t142*t148*t266*t329*t43
     1           +1.3621078885675922d-1*t140*t142*t154*t328*t43-2.724215
     2           7771351844d-1*t140*t143*t148*t154*t324*t43+t258+t257
              t331 = 3.109069086965489d-2*t138*t251*t330+9.3272072608964
     1           66d-2*t141*t156*t324+1.0d+0*t323
              t332 = 3.9062500000000006d+97*t285*t45*t59-1.5625000000000
     1           003d+98*t174*t284*t45*t50+t274
              t333 = -3.9062500000000006d+97*rhob*t320*t42*t45*t60-3.906
     1           2500000000006d+97*t100*t42*t45*t60-3.9062500000000006d+
     2           97*rhoa*t286*t41*t42*t45-3.9062500000000006d+97*rhob*t1
     3           00*t286*t42*t45+t157*t332+t101*t331+t217+t216+t181+t180
              t334 = 6.835937500000002d+146*t159*t333+t277
              t335 = -7.812500000000001d+97*rhoa*t178*t179*t41*t42*t44
              t336 = 1/t1**3
              t337 = 2*t336*t43-8.0d-50*t161
              t338 = -7.812500000000001d+97*rhoa*t161*t337*t41*t43*t60
              t339 = 7.812500000000001d+97*rhoa*t179*t336*t41*t43*t60
              t340 = 7.812500000000001d+97*rhoa*t161*t179*t41*t44*t60
              t341 = -7.812500000000001d+97*rhoa*t179*t215*t42*t44*t60
              t342 = -7.812500000000001d+97*t179*t41*t42*t44*t60
              t343 = t179**2
              t344 = -7.812500000000001d+97*rhoa*t343*t41*t42*t60
              t345 = -7.812500000000001d+97*rhoa*t336*t41*t45*t60
              t346 = 1/rhoa**2.333333333333333d+0
              t347 = 1/rhoa**2.3333333333333334d+0
              t348 = 1/rhoa**1.6666666666666669d+0
              t349 = 1/t3**5
              t350 = 1/t17**2
              t351 = t196**2
              t352 = -1.269642451250142d+0*t193*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t13*t186*t349+8.751370198886037d
     2           -2*t13*t187*t348+4.753699179395351d-3*t347)*t4+6.563527
     3           649164527d-2*t14*t186*t349+8.751370198886037d-2*t14*t18
     4           7*t348-2.625411059665811d-1*t187*t188*t194)-1.410713834
     5           7223802d-1*t16*t348*t4-4.23214150416714d-1*t188*t193*t1
     6           95*t4+2.539284902500284d+0*t195**2*t3/t15**3-3.52678458
     7           680595d-2*t16*t186*t187
              t353 = 1/t24**2
              t354 = t201**2
              t355 = -1.269642451250142d+0*t198*t3*(7.876233178997433d-1
     1           *(6.563527649164527d-2*t186*t20*t349+8.751370198886037d
     2           -2*t187*t20*t348+2.601716490612924d-3*t347)*t4+6.563527
     3           649164527d-2*t186*t21*t349+8.751370198886037d-2*t187*t2
     4           1*t348-2.625411059665811d-1*t187*t188*t199)-1.410713834
     5           7223802d-1*t23*t348*t4-4.23214150416714d-1*t188*t198*t2
     6           00*t4+2.539284902500284d+0*t200**2*t3/t22**3-3.52678458
     7           680595d-2*t186*t187*t23
              t356 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (3.10907d-2*t12*t191**2/t9**2-3.10907d-2*t12*t183*(-1.4
     2           107138347223802d-1*t348*t4*t8-3.52678458680595d-2*t186*
     3           t187*t8+2.539284902500284d+0*t190**2*t3/t7**3-1.2696424
     4           51250142d+0*t184*t3*(6.563527649164527d-2*t186*t349*t6+
     5           8.751370198886037d-2*t187*t348*t6+7.876233178997433d-1*
     6           t4*(6.563527649164527d-2*t186*t349*t5+8.751370198886037
     7           d-2*t187*t348*t5+3.0144339229749983d-3*t347)-2.62541105
     8           9665811d-1*t187*t188*t189)-4.23214150416714d-1*t184*t18
     9           8*t190*t4)+6.21814d-2*t19*t192*t352-6.21814d-2*t19*t350
     :           *t351+3.663697685584584d-3*t18*t346-1.7613865241785687d
     ;           -3*t10*t346-5.495546528376876d-3*t182*t192*t196+2.64207
     <           9786267853d-3*t182*t183*t191)-3.37738d-2*t197*t26*t355+
     =           3.37738d-2*t26*t353*t354-1.0359398963604977d-3*t25*t346
     >           +1.5539098445407465d-3*t182*t197*t201)+3.37738d-2*t197*
     ?           t26*t355-3.37738d-2*t26*t353*t354+1.0359398963604977d-3
     @           *t25*t346-1.5539098445407465d-3*t182*t197*t201)-6.21814
     1           d-2*t19*t192*t352+6.21814d-2*t19*t350*t351-3.6636976855
     2           84584d-3*t18*t346+5.495546528376876d-3*t182*t192*t196
              t357 = 1/t28**4.0d+0
              t358 = rhoa**1.6666666666666674d-1
              t359 = t202**2
              t360 = exp(-1.2865587377165935d+2*t27)
              t361 = 7.157929307165395d-47*rhoa*t29*t359*t360/t31**3
              t362 = 7.063224217674173d-50*t185*t32*t357
              t363 = -4.372472134750679d-50*t204*t32*t358
              t364 = -2.5963579524857594d-48*t202*t204*t207*t28*t30
              t365 = 1.1127248367796111d-48*t202*t207*t29*t30
              t366 = -3.5789646535826974d-47*rhoa*t207*t29*t30*t359
              t367 = 5.563624183898056d-49*rhoa*t207*t29*t30*t356
              t368 = t173**2
              t369 = 1/t58**6.0d+0
              t370 = -2*t336*t46
              t371 = 2*t161
              t372 = t371+t370
              t373 = 2*t336*t46
              t374 = -2*t161
              t375 = t374+t373
              t376 = t164**2
              t377 = t166**2
              t378 = 1/t52**3.333333333333333d+0
              t379 = 1/t53**3.333333333333333d+0
              t380 = 1.2770351237225316d-1*t54*t57/t1**4.666666666666667
     1           d+0
              t381 = 1.3060586492616802d-2*(3.11111111111111d+0*t377*t37
     1           9+3.11111111111111d+0*t376*t378-1.333333333333333d+0*t1
     2           69*t375-1.333333333333333d+0*t168*t372)*t51*t57-6.96564
     3           6129395628d-2*t170*t171*t57+1.3060586492616802d-2*t51*(
     4           8.0d-50*rhob*t375*t53+8.0d-50*rhoa*t372*t52+1.6d-49*t16
     5           4*t52+8.0d-50*rhob*t377+8.0d-50*rhoa*t376)*t54-6.965646
     6           129395628d-2*t167*t171*t54+2.6121172985233604d-2*t167*t
     7           170*t51+t380
              t382 = 6.779999999999999d+1*t377*t49+6.0d+0*t377*t48+1.74d
     1           +0*t375*t42*t46+1.74d+0*t377+1.356d+1*t176*t375+2.0d+0*
     2           t175*t375
              t383 = t382*t59-4.0d+0*t174*t381*t50+2.0d+1*t368*t369*t50-
     1           8.0d+0*t173*t174*t177
              t384 = -7.812500000000001d+97*rhob*t100*t178*t179*t42*t44
              t385 = -7.812500000000001d+97*rhob*t100*t161*t337*t43*t60
              t386 = 7.812500000000001d+97*rhob*t100*t179*t336*t43*t60
              t387 = 7.812500000000001d+97*rhob*t100*t161*t179*t44*t60
              t388 = -7.812500000000001d+97*rhob*t100*t343*t42*t60
              t389 = -7.812500000000001d+97*rhob*t100*t336*t45*t60
              t390 = t224**2
              t391 = 1/t111**2
              t392 = 6.21814d-2*t104*t390*t391
              t393 = 1/t1**2.3333333333333334d+0
              t394 = 1/t105**5
              t395 = 1/t1**1.6666666666666669d+0
              t396 = -1.269642451250142d+0*t105*t223*(7.876233178997433d
     1           -1*t106*(8.751370198886037d-2*t107*t220*t395+6.56352764
     2           9164527d-2*t107*t218*t394+4.753699179395351d-3*t393)+8.
     3           751370198886037d-2*t108*t220*t395+6.563527649164527d-2*
     4           t108*t218*t394-2.625411059665811d-1*t219*t220*t221)-1.4
     5           107138347223802d-1*t106*t110*t395-4.23214150416714d-1*t
     6           106*t219*t222*t223+2.539284902500284d+0*t105*t222**2/t1
     7           09**3-3.52678458680595d-2*t110*t218*t220
              t397 = -6.21814d-2*t104*t225*t396
              t398 = 5.495546528376876d-3*t224*t225*t227
              t399 = 1/t1**2.333333333333333d+0
              t400 = -3.663697685584584d-3*t112*t399
              t401 = t232**2
              t402 = 1/t121**2
              t403 = -3.37738d-2*t116*t401*t402
              t404 = -1.269642451250142d+0*t105*t231*(7.876233178997433d
     1           -1*t106*(8.751370198886037d-2*t117*t220*t395+6.56352764
     2           9164527d-2*t117*t218*t394+2.601716490612924d-3*t393)+8.
     3           751370198886037d-2*t118*t220*t395+6.563527649164527d-2*
     4           t118*t218*t394-2.625411059665811d-1*t219*t220*t229)-1.4
     5           107138347223802d-1*t106*t120*t395-4.23214150416714d-1*t
     6           106*t219*t230*t231+2.539284902500284d+0*t105*t230**2/t1
     7           19**3-3.52678458680595d-2*t120*t218*t220
              t405 = 3.37738d-2*t116*t233*t404
              t406 = -1.5539098445407465d-3*t227*t232*t233
              t407 = 1.0359398963604977d-3*t122*t399
              t408 = t123*t124*(-3.37738d-2*t116*t233*t404+3.37738d-2*t1
     1           16*t401*t402+1.709920934161365d+0*(-1.7613865241785687d
     2           -3*t131*t399+3.663697685584584d-3*t112*t399+6.21814d-2*
     3           t104*t225*t396-3.10907d-2*t125*t240*(-1.269642451250142
     4           d+0*t105*t238*(7.876233178997433d-1*t106*(8.75137019888
     5           6037d-2*t126*t220*t395+6.563527649164527d-2*t126*t218*t
     6           394+3.0144339229749983d-3*t393)+8.751370198886037d-2*t1
     7           27*t220*t395+6.563527649164527d-2*t127*t218*t394-2.6254
     8           11059665811d-1*t219*t220*t236)-1.4107138347223802d-1*t1
     9           06*t129*t395-4.23214150416714d-1*t106*t219*t237*t238+2.
     :           539284902500284d+0*t105*t237**2/t128**3-3.5267845868059
     ;           5d-2*t129*t218*t220)-6.21814d-2*t104*t390*t391+2.642079
     <           786267853d-3*t227*t239*t240+3.10907d-2*t125*t239**2/t13
     =           0**2-5.495546528376876d-3*t224*t225*t227)-1.03593989636
     >           04977d-3*t122*t399+1.5539098445407465d-3*t227*t232*t233
     ?           )
              t409 = -8*t123*t241*t243
              t410 = 20*t123*t132/t1**6
              t411 = t46**2
              t412 = 12*t124*t132*t411
              t413 = 1/t135
              t414 = 1/t136
              t415 = 5.848223622634648d-1*t133*(8.549604670806825d-1*t37
     1           7*t414+8.549604670806825d-1*t376*t413+2.564881401242048
     2           d+0*t248*t375+2.564881401242048d+0*t247*t372)+5.8482236
     3           22634648d-1*t115*(t412+t410+t409+t408+t407+t406+t405+t4
     4           03-32*t132*t243*t245+8*t124*t241*t245)+t400+t398+t397+t
     5           392+1.1696447245269297d+0*t246*t249
              t416 = t254**2
              t417 = 1/t113
              t418 = 1/t114
              t419 = -1.111111111111111d-1*t377*t418-1.111111111111111d-
     1           1*t376*t417+3.333333333333333d-1*t253*t375+3.3333333333
     2           33333d-1*t252*t372
              t420 = t1**3.333333333333335d-1
              t421 = 1/t139**4.0d+0
              t422 = 1.1123881089968671d+0*t142*t148*t154*t420*t421*t43
              t423 = 1/t1**8.333333333333333d-1
              t424 = -5.297086233318417d-2*t142*t148*t154*t256*t423*t43
              t425 = -2.542601391992839d-50*t142*t148*t154*t255*t256
              t426 = 8.172647331405554d-1*t140*t146*t149*t416*t43
              t427 = -2.7242157771351844d-1*t140*t143*t146*t419*t43
              t428 = 1.2713006959964196d+0*t143*t146*t254*t255*t256*t43
              t429 = -2.1793726217081477d-50*t140*t143*t146*t254
              t430 = 1.1123881089968671d+0*t142*t146*t420*t421*t43
              t431 = -5.297086233318417d-2*t142*t146*t256*t423*t43
              t432 = -2.542601391992839d-50*t142*t146*t255*t256
              t433 = 9.649190532874448d+1*t134*t149*t419-3.8596762131497
     1           79d+2*t134*t269*t416-3.216396844291483d+1*t143*t415+1.9
     2           298381065748896d+2*t149*t250*t254
              t434 = -1.3621078885675922d-1*t140*t142*t144*t262*t43*t433
              t435 = 5.448431554270369d-1*t140*t143*t144*t254*t262*t263*
     1           t43
              t436 = 6.356503479982097d-1*t142*t144*t255*t256*t262*t263*
     1           t43
              t437 = -1.0896863108540739d-50*t140*t142*t144*t262*t263
              t438 = exp(-6.432793688582966d+1*t134*t143)
              t439 = 1/t145**3
              t440 = t263**2
              t441 = 2.7242157771351844d-1*t140*t142*t43*t438*t439*t440
              t442 = -1.3621078885675922d-1*t140*t142*t144*t262*t43*t440
              t443 = 3.710675800196128d-2*t140*t149*t152*t43*(-3.8888888
     1           888888906d-1*t256*t423*t43+8.166666666666668d+0*t420*t4
     2           21*t43-1.866666666666667d-49*t255*t256)
              t444 = -1.4842703200784513d-1*t150*t152*t254*t267*t269
              t445 = 3.710675800196128d-2*t149*t152*t267**2
              t446 = 1/t137**6.0d+0
              t447 = -7.421351600392256d-2*t144*t149*t150*t263*t267*t270
              t448 = 1/t145**4.0d+0
              t449 = 1/t153**3
              t450 = 1/t155**2
              t451 = -3.1250000000000006d+98*t173*t174*t179*t44*t50
              t452 = 7.812500000000001d+97*t177*t179*t44*t59
              t453 = 7.812500000000001d+97*t337*t42*t43*t50*t59
              t454 = 7.812500000000001d+97*t343*t50*t59
              t455 = -3.9062500000000006d+97*rhoa*(-1.5545345434827443d-
     1           2*t214**2/t40**2+1.5545345434827443d-2*t203*(8.64884598
     2           0825518d-51*rhoa*t29*(t367+t366+t365+t364+t363+t362+t36
     3           1)*t39-4.372472134750679d-50*t204*t34*t358*t39+7.063224
     4           217674173d-50*t185*t34*t357*t39+1.7297691961651035d-50*
     5           t209*t29*t39-4.036128124385242d-50*t204*t209*t28*t39+1.
     6           7297691961651035d-50*rhoa*t213**2*t29*t34/t38**3-8.6488
     7           45980825518d-51*rhoa*t210*t29*t34*(1.4960507360008343d-
     8           100*rhoa*t29*(8.166666666666668d+0*t185*t357-5.05555555
     9           5555556d+0*t204*t358)*t37+1.4960507360008343d-100*t211*
     :           *2*t37+t367+t366+t365+t364+t363+t362+t361+1.85723484357
     ;           9318d-96*t359*t36*t360/t31**4.0d+0-6.19078281193106d-97
     <           *t212*t30*t359*t36+9.623785732346068d-99*t212*t30*t356*
     =           t36+1.9247571464692137d-98*t202*t211*t212*t30*t35+1.924
     >           7571464692137d-98*rhoa*t202*t211*t212*t29*t30)-1.729769
     ?           1961651035d-50*t210*t213*t29*t34+4.036128124385242d-50*
     @           t204*t210*t213*t28*t34-1.7297691961651035d-50*rhoa*t209
     1           *t210*t213*t29)+1.0d+0*t356)*t42*t45*t60-7.812500000000
     2           001d+97*t215*t42*t45*t60+7.812500000000001d+97*t161*t41
     3           *t45*t60+7.812500000000001d+97*rhoa*t161*t215*t45*t60-7
     4           .812500000000001d+97*t161*t179*t41*t43*t60-7.8125000000
     5           00001d+97*rhoa*t161*t179*t215*t43*t60+t157*(3.906250000
     6           0000006d+97*t382*t45*t59+7.812500000000001d+97*t177*t17
     7           9*t42*t43*t59-1.5625000000000003d+98*t174*t381*t45*t50+
     8           7.812500000000002d+98*t368*t369*t45*t50-3.1250000000000
     9           006d+98*t173*t174*t179*t42*t43*t50+t454+t453+t452+t451-
     :           3.1250000000000006d+98*t173*t174*t177*t45)+t101*(-3.109
     ;           069086965489d-2*t138*t272**2*t450+3.109069086965489d-2*
     <           t138*t251*(2.7242157771351844d-1*t140*t142*t148*t271**2
     =           *t43*t449-1.3621078885675922d-1*t140*t142*t148*t266*t43
     >           *(1.1132027400588385d-1*t149*t151*t438*t440*t448+t447+3
     ?           .710675800196128d-1*t151*t152*t416*t446+t445+t444+t443+
     @           t442+t441-3.710675800196128d-2*t144*t149*t151*t270*t440
     1           +t437+t436+t435+t434-3.710675800196128d-2*t144*t149*t15
     2           1*t270*t433+t432+t431+t430-7.421351600392256d-2*t140*t1
     3           44*t149*t263*t267*t270*t43-1.4842703200784513d-1*t140*t
     4           152*t254*t267*t269*t43+t429+t428+t427+t426-7.4213516003
     5           92256d-2*t151*t152*t269*t419+2.9685406401569026d-1*t144
     6           *t151*t254*t263*t269*t270)+1.3621078885675922d-1*t140*t
     7           142*t154*t43*(t442+t441+t437+t436+t435+t434+t432+t431+t
     8           430+t429+t428+t427+t426)-2.7242157771351844d-1*t140*t14
     9           3*t148*t154*t419*t43+8.172647331405554d-1*t140*t148*t14
     :           9*t154*t416*t43-2.7242157771351844d-1*t140*t142*t265*t2
     ;           66*t271*t43+6.356503479982097d-1*t142*t148*t255*t256*t2
     <           66*t271*t43+5.448431554270369d-1*t140*t143*t148*t254*t2
     =           66*t271*t43-6.356503479982097d-1*t142*t154*t255*t256*t2
     >           65*t43-5.448431554270369d-1*t140*t143*t154*t254*t265*t4
     ?           3+1.2713006959964196d+0*t143*t148*t154*t254*t255*t256*t
     @           43+t425+t424+t422-1.0896863108540739d-50*t140*t142*t148
     1           *t266*t271+1.0896863108540739d-50*t140*t142*t154*t265-2
     2           .1793726217081477d-50*t140*t143*t148*t154*t254)+9.32720
     3           7260896466d-2*t141*t156*t419+1.8654414521792934d-1*t137
     4           *t156*t416+1.0d+0*t415+1.8654414521792934d-1*t141*t251*
     5           t254*t272)-3.9062500000000006d+97*rhoa*t383*t41*t42*t45
     6           -7.812500000000001d+97*t178*t41*t42*t45-3.9062500000000
     7           006d+97*rhob*t100*t383*t42*t45-7.812500000000001d+97*rh
     8           oa*t178*t215*t42*t45+7.812500000000001d+97*rhoa*t161*t1
     9           78*t41*t45+7.812500000000001d+97*rhob*t100*t161*t178*t4
     :           5-7.812500000000001d+97*rhoa*t161*t178*t179*t41*t43-7.8
     ;           12500000000001d+97*rhob*t100*t161*t178*t179*t43+t389+t3
     <           88+t387+t386+t385+t384+t345+t344+t342+t341+t340+t339+t3
     =           38+t335+2*t273*t275
              t456 = 4.101562500000001d+147*t158*t343*t44
              t457 = 2.0507812500000006d+147*t158*t337*t45
              t458 = 1.3060586492616802d-2*(-2.666666666666666d+0*t169*t
     1           336*t46+2.666666666666666d+0*t168*t336*t46+3.1111111111
     2           1111d+0*t166*t281*t379+3.11111111111111d+0*t164*t280*t3
     3           78)*t51*t57-3.482823064697814d-2*t171*t283*t57-3.482823
     4           064697814d-2*t170*t171*t57+1.3060586492616802d-2*t51*(1
     5           .6d-49*rhob*t336*t46*t53+8.0d-50*t166*t53-1.6d-49*rhoa*
     6           t336*t46*t52+8.0d-50*t280*t52+8.0d-50*rhob*t166*t281+8.
     7           0d-50*rhoa*t164*t280)*t54-3.482823064697814d-2*t171*t28
     8           2*t54-3.482823064697814d-2*t167*t171*t54+1.306058649261
     9           6802d-2*t167*t283*t51+1.3060586492616802d-2*t170*t282*t
     :           51+t380
              t459 = 6.779999999999999d+1*t166*t281*t49+6.0d+0*t166*t281
     1           *t48+2.712d+1*t176*t336*t46+4.0d+0*t175*t336*t46+3.48d+
     2           0*t124*t411+1.74d+0*t166*t281
              t460 = t459*t59-4.0d+0*t174*t458*t50+2.0d+1*t173*t284*t369
     1           *t50-4.0d+0*t173*t174*t285-4.0d+0*t174*t177*t284
              t461 = -7.812500000000001d+97*rhoa*t161*t179*t286*t41*t43
              t462 = -7.812500000000001d+97*rhob*t161*t179*t320*t43*t60
              t463 = -7.812500000000001d+97*rhob*t100*t161*t179*t286*t43
              t464 = -7.812500000000001d+97*t100*t161*t179*t43*t60
              t465 = 5.848223622634648d-1*t133*(5.129762802484096d+0*t24
     1           8*t336*t46-5.129762802484096d+0*t247*t336*t46+8.5496046
     2           70806825d-1*t166*t281*t414+8.549604670806825d-1*t164*t2
     3           80*t413)+5.848223622634648d-1*t115*(-12*t124*t132*t411+
     4           t410+t409+t408+t407+t406+t405+t403)+t400+t398+t397+t392
     5           +5.848223622634648d-1*t246*t322+5.848223622634648d-1*t2
     6           49*t321
              t466 = 6.666666666666666d-1*t253*t336*t46-6.66666666666666
     1           6d-1*t252*t336*t46-1.111111111111111d-1*t166*t281*t418-
     2           1.111111111111111d-1*t164*t280*t417
              t467 = 8.172647331405554d-1*t140*t146*t149*t254*t324*t43
              t468 = -2.7242157771351844d-1*t140*t143*t146*t43*t466
              t469 = 6.356503479982097d-1*t143*t146*t255*t256*t324*t43
              t470 = -1.0896863108540739d-50*t140*t143*t146*t324
              t471 = 6.356503479982097d-1*t143*t146*t254*t255*t256*t43
              t472 = -1.0896863108540739d-50*t140*t143*t146*t254
              t473 = 9.649190532874448d+1*t134*t149*t466-3.2163968442914
     1           83d+1*t143*t465-3.859676213149779d+2*t134*t254*t269*t32
     2           4+9.649190532874448d+1*t149*t250*t324+9.649190532874448
     3           d+1*t149*t254*t323
              t474 = -1.3621078885675922d-1*t140*t142*t144*t262*t43*t473
              t475 = 2.7242157771351844d-1*t140*t143*t144*t254*t262*t326
     1           *t43
              t476 = 3.1782517399910487d-1*t142*t144*t255*t256*t262*t326
     1           *t43
              t477 = -5.44843155427037d-51*t140*t142*t144*t262*t326
              t478 = 2.7242157771351844d-1*t140*t143*t144*t262*t263*t324
     1           *t43
              t479 = 3.1782517399910487d-1*t142*t144*t255*t256*t262*t263
     1           *t43
              t480 = -5.44843155427037d-51*t140*t142*t144*t262*t263
              t481 = 2.7242157771351844d-1*t140*t142*t263*t326*t43*t438*
     1           t439
              t482 = -1.3621078885675922d-1*t140*t142*t144*t262*t263*t32
     1           6*t43
              t483 = -1.4842703200784513d-1*t140*t152*t267*t269*t324*t43
              t484 = -7.421351600392256d-2*t140*t144*t149*t267*t270*t326
     1           *t43
              t485 = -3.1250000000000006d+98*t174*t179*t284*t42*t43*t50
              t486 = 7.812500000000001d+97*t179*t285*t42*t43*t59
              t487 = 3.9062500000000006d+97*t161*t41*t45*t60+3.906250000
     1           0000006d+97*rhob*t161*t320*t45*t60+3.9062500000000006d+
     2           97*rhoa*t161*t215*t45*t60+3.9062500000000006d+97*t100*t
     3           161*t45*t60+t157*(3.9062500000000006d+97*t45*t459*t59-1
     4           .5625000000000003d+98*t174*t45*t458*t50+7.8125000000000
     5           02d+98*t173*t284*t369*t45*t50+t486+t485+t454+t453+t452+
     6           t451-1.5625000000000003d+98*t173*t174*t285*t45-1.562500
     7           0000000003d+98*t174*t177*t284*t45)+t101*(3.109069086965
     8           489d-2*t138*t251*(-1.3621078885675922d-1*t140*t142*t148
     9           *t266*t43*(t484+t483+t482+t481+t480+t479+t478+t477+t476
     :           +t475+t474-3.710675800196128d-2*t144*t149*t151*t270*t47
     ;           3+t472+t471+t470+t469+t468+t467-7.421351600392256d-2*t1
     <           51*t152*t269*t466+1.1132027400588385d-1*t149*t151*t263*
     =           t326*t438*t448+t447+3.710675800196128d-1*t151*t152*t254
     >           *t324*t446+t445+t444+t443+t432+t431+t430+1.484270320078
     ?           4513d-1*t144*t151*t254*t269*t270*t326-3.710675800196128
     @           d-2*t144*t149*t151*t263*t270*t326+1.4842703200784513d-1
     1           *t144*t151*t263*t269*t270*t324)+1.3621078885675922d-1*t
     2           140*t142*t154*t43*(t482+t481+t480+t479+t478+t477+t476+t
     3           475+t474+t472+t471+t470+t469+t468+t467+t432+t431+t430)-
     4           2.7242157771351844d-1*t140*t143*t148*t154*t43*t466+2.72
     5           42157771351844d-1*t140*t142*t148*t271*t329*t43*t449-1.3
     6           621078885675922d-1*t140*t142*t265*t266*t329*t43+3.17825
     7           17399910487d-1*t142*t148*t255*t256*t266*t329*t43+2.7242
     8           157771351844d-1*t140*t143*t148*t254*t266*t329*t43-1.362
     9           1078885675922d-1*t140*t142*t266*t271*t328*t43-3.1782517
     :           399910487d-1*t142*t154*t255*t256*t328*t43-2.72421577713
     ;           51844d-1*t140*t143*t154*t254*t328*t43+2.724215777135184
     <           4d-1*t140*t143*t148*t266*t271*t324*t43-2.72421577713518
     =           44d-1*t140*t143*t154*t265*t324*t43+6.356503479982097d-1
     >           *t143*t148*t154*t255*t256*t324*t43+8.172647331405554d-1
     ?           *t140*t148*t149*t154*t254*t324*t43+3.1782517399910487d-
     @           1*t142*t148*t255*t256*t266*t271*t43-3.1782517399910487d
     1           -1*t142*t154*t255*t256*t265*t43+6.356503479982097d-1*t1
     2           43*t148*t154*t254*t255*t256*t43+t425+t424+t422-5.448431
     3           55427037d-51*t140*t142*t148*t266*t329+5.44843155427037d
     4           -51*t140*t142*t154*t328-1.0896863108540739d-50*t140*t14
     5           3*t148*t154*t324-5.44843155427037d-51*t140*t142*t148*t2
     6           66*t271+5.44843155427037d-51*t140*t142*t154*t265-1.0896
     7           863108540739d-50*t140*t143*t148*t154*t254)+9.3272072608
     8           96466d-2*t141*t156*t466+1.0d+0*t465-3.109069086965489d-
     9           2*t138*t272*t330*t450+9.327207260896466d-2*t141*t251*t2
     :           54*t330+9.327207260896466d-2*t141*t251*t272*t324+1.8654
     ;           414521792934d-1*t137*t156*t254*t324)+t464+t463+t462+t46
     <           1-3.9062500000000006d+97*rhoa*t41*t42*t45*t460-3.906250
     =           0000000006d+97*rhob*t100*t42*t45*t460-3.906250000000000
     >           6d+97*t286*t41*t42*t45-3.9062500000000006d+97*rhob*t178
     ?           *t320*t42*t45-3.9062500000000006d+97*rhoa*t215*t286*t42
     @           *t45-3.9062500000000006d+97*t100*t178*t42*t45+3.9062500
     1           000000006d+97*rhoa*t161*t286*t41*t45+3.9062500000000006
     2           d+97*rhoa*t161*t178*t41*t45+3.9062500000000006d+97*rhob
     3           *t100*t161*t286*t45+3.9062500000000006d+97*rhob*t100*t1
     4           61*t178*t45+t389+t388+t387+t386+t385+t384+t345+t344+t34
     5           2+t341+t340+t339+t338+t335+t273*t332+t275*t331
              t488 = t284**2
              t489 = t374+t370
              t490 = t373+t371
              t491 = t281**2
              t492 = t280**2
              t493 = 1.3060586492616802d-2*(3.11111111111111d+0*t378*t49
     1           2+3.11111111111111d+0*t379*t491-1.333333333333333d+0*t1
     2           69*t490-1.333333333333333d+0*t168*t489)*t51*t57-6.96564
     3           6129395628d-2*t171*t283*t57+1.3060586492616802d-2*t51*(
     4           8.0d-50*rhob*t490*t53+1.6d-49*t281*t53+8.0d-50*rhoa*t48
     5           9*t52+8.0d-50*rhoa*t492+8.0d-50*rhob*t491)*t54-6.965646
     6           129395628d-2*t171*t282*t54+2.6121172985233604d-2*t282*t
     7           283*t51+t380
              t494 = 6.779999999999999d+1*t49*t491+6.0d+0*t48*t491+1.74d
     1           +0*t491+1.74d+0*t42*t46*t490+1.356d+1*t176*t490+2.0d+0*
     2           t175*t490
              t495 = t494*t59-4.0d+0*t174*t493*t50+2.0d+1*t369*t488*t50-
     1           8.0d+0*t174*t284*t285
              t496 = 1/rhob**2.333333333333333d+0
              t497 = 1/rhob**2.3333333333333334d+0
              t498 = 1/rhob**1.6666666666666669d+0
              t499 = 1/t62**5
              t500 = 1/t76**2
              t501 = t301**2
              t502 = -1.4107138347223802d-1*t498*t63*t75-3.5267845868059
     1           5d-2*t291*t292*t75+2.539284902500284d+0*t300**2*t62/t74
     2           **3-1.269642451250142d+0*t298*t62*(6.563527649164527d-2
     3           *t291*t499*t73+8.751370198886037d-2*t292*t498*t73+7.876
     4           233178997433d-1*t63*(6.563527649164527d-2*t291*t499*t72
     5           +8.751370198886037d-2*t292*t498*t72+4.753699179395351d-
     6           3*t497)-2.625411059665811d-1*t292*t293*t299)-4.23214150
     7           416714d-1*t293*t298*t300*t63
              t503 = 1/t83**2
              t504 = t306**2
              t505 = -1.4107138347223802d-1*t498*t63*t82-3.5267845868059
     1           5d-2*t291*t292*t82+2.539284902500284d+0*t305**2*t62/t81
     2           **3-1.269642451250142d+0*t303*t62*(6.563527649164527d-2
     3           *t291*t499*t80+8.751370198886037d-2*t292*t498*t80+7.876
     4           233178997433d-1*t63*(6.563527649164527d-2*t291*t499*t79
     5           +8.751370198886037d-2*t292*t498*t79+2.601716490612924d-
     6           3*t497)-2.625411059665811d-1*t292*t293*t304)-4.23214150
     7           416714d-1*t293*t303*t305*t63
              t506 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t302*t505
     1           *t85+3.37738d-2*t503*t504*t85-1.0359398963604977d-3*t49
     2           6*t84+1.709920934161365d+0*(6.21814d-2*t297*t502*t78-6.
     3           21814d-2*t500*t501*t78+3.663697685584584d-3*t496*t77+3.
     4           10907d-2*t296**2*t71/t68**2-3.10907d-2*t288*(-1.4107138
     5           347223802d-1*t498*t63*t67-3.52678458680595d-2*t291*t292
     6           *t67+2.539284902500284d+0*t295**2*t62/t66**3-1.26964245
     7           1250142d+0*t289*t62*(6.563527649164527d-2*t291*t499*t65
     8           +8.751370198886037d-2*t292*t498*t65+7.876233178997433d-
     9           1*t63*(6.563527649164527d-2*t291*t499*t64+8.75137019888
     :           6037d-2*t292*t498*t64+3.0144339229749983d-3*t497)-2.625
     ;           411059665811d-1*t292*t293*t294)-4.23214150416714d-1*t28
     <           9*t293*t295*t63)*t71-1.7613865241785687d-3*t496*t69-5.4
     =           95546528376876d-3*t287*t297*t301+2.642079786267853d-3*t
     >           287*t288*t296)+1.5539098445407465d-3*t287*t302*t306)+3.
     ?           37738d-2*t302*t505*t85-3.37738d-2*t503*t504*t85+1.03593
     @           98963604977d-3*t496*t84-1.5539098445407465d-3*t287*t302
     1           *t306)-6.21814d-2*t297*t502*t78+6.21814d-2*t500*t501*t7
     2           8-3.663697685584584d-3*t496*t77+5.495546528376876d-3*t2
     3           87*t297*t301
              t507 = 1/t87**4.0d+0
              t508 = rhob**1.6666666666666674d-1
              t509 = t307**2
              t510 = exp(-1.2865587377165935d+2*t86)
              t511 = 7.157929307165395d-47*rhob*t509*t510*t88/t90**3
              t512 = 7.063224217674173d-50*t290*t507*t91
              t513 = -4.372472134750679d-50*t309*t508*t91
              t514 = -2.5963579524857594d-48*t307*t309*t312*t87*t89
              t515 = 1.1127248367796111d-48*t307*t312*t88*t89
              t516 = -3.5789646535826974d-47*rhob*t312*t509*t88*t89
              t517 = 5.563624183898056d-49*rhob*t312*t506*t88*t89
              t518 = 5.848223622634648d-1*t133*(8.549604670806825d-1*t41
     1           3*t492+8.549604670806825d-1*t414*t491+2.564881401242048
     2           d+0*t248*t490+2.564881401242048d+0*t247*t489)+5.8482236
     3           22634648d-1*t115*(t412+t410+t409+t408+t407+t406+t405+t4
     4           03+32*t132*t243*t245-8*t124*t241*t245)+t400+t398+t397+t
     5           392+1.1696447245269297d+0*t321*t322
              t519 = t324**2
              t520 = -1.111111111111111d-1*t417*t492-1.111111111111111d-
     1           1*t418*t491+3.333333333333333d-1*t253*t490+3.3333333333
     2           33333d-1*t252*t489
              t521 = 8.172647331405554d-1*t140*t146*t149*t43*t519
              t522 = -2.7242157771351844d-1*t140*t143*t146*t43*t520
              t523 = 1.2713006959964196d+0*t143*t146*t255*t256*t324*t43
              t524 = -2.1793726217081477d-50*t140*t143*t146*t324
              t525 = 9.649190532874448d+1*t134*t149*t520-3.8596762131497
     1           79d+2*t134*t269*t519-3.216396844291483d+1*t143*t518+1.9
     2           298381065748896d+2*t149*t323*t324
              t526 = -1.3621078885675922d-1*t140*t142*t144*t262*t43*t525
              t527 = 5.448431554270369d-1*t140*t143*t144*t262*t324*t326*
     1           t43
              t528 = 6.356503479982097d-1*t142*t144*t255*t256*t262*t326*
     1           t43
              t529 = -1.0896863108540739d-50*t140*t142*t144*t262*t326
              t530 = t326**2
              t531 = 2.7242157771351844d-1*t140*t142*t43*t438*t439*t530
              t532 = -1.3621078885675922d-1*t140*t142*t144*t262*t43*t530
              t533 = -3.9062500000000006d+97*rhob*t42*t45*t60*(-1.554534
     1           5434827443d-2*t319**2/t99**2+1.5545345434827443d-2*t308
     2           *(-4.372472134750679d-50*t309*t508*t93*t98+7.0632242176
     3           74173d-50*t290*t507*t93*t98+8.648845980825518d-51*rhob*
     4           (t517+t516+t515+t514+t513+t512+t511)*t88*t98+1.72976919
     5           61651035d-50*t314*t88*t98-4.036128124385242d-50*t309*t3
     6           14*t87*t98+1.7297691961651035d-50*rhob*t318**2*t88*t93/
     7           t97**3-8.648845980825518d-51*rhob*t315*t88*t93*(1.49605
     8           07360008343d-100*rhob*(8.166666666666668d+0*t290*t507-5
     9           .055555555555556d+0*t309*t508)*t88*t96+1.49605073600083
     :           43d-100*t316**2*t96+1.857234843579318d-96*t509*t510*t95
     ;           /t90**4.0d+0-6.19078281193106d-97*t317*t509*t89*t95+9.6
     <           23785732346068d-99*t317*t506*t89*t95+1.9247571464692137
     =           d-98*t307*t316*t317*t89*t94+1.9247571464692137d-98*rhob
     >           *t307*t316*t317*t88*t89+t517+t516+t515+t514+t513+t512+t
     ?           511)-1.7297691961651035d-50*t315*t318*t88*t93+4.0361281
     @           24385242d-50*t309*t315*t318*t87*t93-1.7297691961651035d
     1           -50*rhob*t314*t315*t318*t88)+1.0d+0*t506)-7.81250000000
     2           0001d+97*t320*t42*t45*t60+7.812500000000001d+97*rhob*t1
     3           61*t320*t45*t60+7.812500000000001d+97*t100*t161*t45*t60
     4           -7.812500000000001d+97*rhob*t179*t320*t42*t44*t60-7.812
     5           500000000001d+97*t100*t179*t42*t44*t60+t157*(3.90625000
     6           00000006d+97*t45*t494*t59+7.812500000000001d+97*t179*t2
     7           85*t44*t59-1.5625000000000003d+98*t174*t45*t493*t50+7.8
     8           12500000000002d+98*t369*t45*t488*t50-3.1250000000000006
     9           d+98*t174*t179*t284*t44*t50+t486+t485+t454+t453-3.12500
     :           00000000006d+98*t174*t284*t285*t45)+t101*(3.10906908696
     ;           5489d-2*t138*t251*(-1.3621078885675922d-1*t140*t142*t14
     <           8*t266*t43*(t532+t531+1.1132027400588385d-1*t149*t151*t
     =           438*t448*t530-3.710675800196128d-2*t144*t149*t151*t270*
     >           t530+t529+t528+t527+t526-3.710675800196128d-2*t144*t149
     ?           *t151*t270*t525+t524+t523+t522+t521-7.421351600392256d-
     @           2*t151*t152*t269*t520+3.710675800196128d-1*t151*t152*t4
     1           46*t519+t484+t483+t445+t443+t432+t431+t430+2.9685406401
     2           569026d-1*t144*t151*t269*t270*t324*t326-7.4213516003922
     3           56d-2*t144*t149*t150*t267*t270*t326-1.4842703200784513d
     4           -1*t150*t152*t267*t269*t324)+1.3621078885675922d-1*t140
     5           *t142*t154*t43*(t532+t531+t529+t528+t527+t526+t524+t523
     6           +t522+t521+t432+t431+t430)-2.7242157771351844d-1*t140*t
     7           143*t148*t154*t43*t520+8.172647331405554d-1*t140*t148*t
     8           149*t154*t43*t519+2.7242157771351844d-1*t140*t142*t148*
     9           t329**2*t43*t449-2.7242157771351844d-1*t140*t142*t266*t
     :           328*t329*t43+5.448431554270369d-1*t140*t143*t148*t266*t
     ;           324*t329*t43+6.356503479982097d-1*t142*t148*t255*t256*t
     <           266*t329*t43-5.448431554270369d-1*t140*t143*t154*t324*t
     =           328*t43-6.356503479982097d-1*t142*t154*t255*t256*t328*t
     >           43+1.2713006959964196d+0*t143*t148*t154*t255*t256*t324*
     ?           t43+t425+t424+t422-1.0896863108540739d-50*t140*t142*t14
     @           8*t266*t329+1.0896863108540739d-50*t140*t142*t154*t328-
     1           2.1793726217081477d-50*t140*t143*t148*t154*t324)+9.3272
     2           07260896466d-2*t141*t156*t520+1.8654414521792934d-1*t13
     3           7*t156*t519+1.0d+0*t518-3.109069086965489d-2*t138*t330*
     4           *2*t450+1.8654414521792934d-1*t141*t251*t324*t330)-3.90
     5           62500000000006d+97*rhoa*t41*t42*t45*t495-3.906250000000
     6           0006d+97*rhob*t100*t42*t45*t495+t464+t463+t462+t461-7.8
     7           12500000000001d+97*rhob*t286*t320*t42*t45-7.81250000000
     8           0001d+97*t100*t286*t42*t45+7.812500000000001d+97*rhoa*t
     9           161*t286*t41*t45+7.812500000000001d+97*rhob*t100*t161*t
     :           286*t45-7.812500000000001d+97*rhoa*t179*t286*t41*t42*t4
     ;           4-7.812500000000001d+97*rhob*t100*t179*t286*t42*t44+t38
     <           9+t388+t387+t386+t385+t345+t344+t340+t339+t338+2*t331*t
     =           332
              fnc(iq) = 1.0d+0*t1*t158*t160*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t1*t158*t278*wght+1.0d+0*t1*t160*t
     1           276*wght+t279+Amat(iq,D1_RA)
              Amat(iq,D1_RB) = 1.0d+0*t1*t158*t334*wght+1.0d+0*t1*t160*t
     1           333*wght+t279+Amat(iq,D1_RB)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = 1.0d+0*t1*t158*(t457+t456+6.835937500
     1           000002d+146*t159*t455+4.101562500000001d+147*t179*t276*
     2           t45)*wght+1.0d+0*t1*t160*t455*wght+2.0d+0*t1*t276*t278*
     3           wght+2.0d+0*t158*t278*wght+2.0d+0*t160*t276*wght+Amat2(
     4           iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = 1.0d+0*t1*t158*(6.835937500000002d+14
     1           6*t159*t487+t457+t456+2.0507812500000006d+147*t179*t333
     2           *t45+2.0507812500000006d+147*t179*t276*t45)*wght+1.0d+0
     3           *t1*t160*t487*wght+1.0d+0*t1*t276*t334*wght+1.0d+0*t158
     4           *t334*wght+1.0d+0*t1*t278*t333*wght+1.0d+0*t160*t333*wg
     5           ht+1.0d+0*t158*t278*wght+1.0d+0*t160*t276*wght+Amat2(iq
     6           ,D2_RA_RB)
              Amat2(iq,D2_RB_RB) = 1.0d+0*t1*t158*(6.835937500000002d+14
     1           6*t159*t533+t457+t456+4.101562500000001d+147*t179*t333*
     2           t45)*wght+1.0d+0*t1*t160*t533*wght+2.0d+0*t1*t333*t334*
     3           wght+2.0d+0*t158*t334*wght+2.0d+0*t160*t333*wght+Amat2(
     4           iq,D2_RB_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
              Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_GAB_TB) = Mmat2(iq,D2_GAB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            else 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RA) = Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Amat2(iq,D2_RA_RA) = Amat2(iq,D2_RA_RA)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.gt.tol_rho.and.taub.le.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            elseif (taua.le.tol_rho.and.taub.gt.tol_rho) then 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            else 
              fnc(iq) = fnc(iq)
              Amat(iq,D1_RB) = Amat(iq,D1_RB)
              Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)
              Mmat(iq,D1_TB) = Mmat(iq,D1_TB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RB_RB) = Amat2(iq,D2_RB_RB)
              Cmat2(iq,D2_RB_GBB) = Cmat2(iq,D2_RB_GBB)
              Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)
              Mmat2(iq,D2_RB_TA) = Mmat2(iq,D2_RB_TA)
              Mmat2(iq,D2_RB_TB) = Mmat2(iq,D2_RB_TB)
              Mmat2(iq,D2_GBB_TA) = Mmat2(iq,D2_GBB_TA)
              Mmat2(iq,D2_GBB_TB) = Mmat2(iq,D2_GBB_TB)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Mmat2(iq,D2_TB_TB) = Mmat2(iq,D2_TB_TB)
            endif 
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_tpss03 functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_3} &=& \rho_\alpha^{0.3333333333333333}\\\\ 
C>   {\it t_4} &=& \sqrt{{\it t_3}}\\\\ 
C>   {\it t_5} &=& {{1}\over{{\it t_4}}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_3}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_4}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.02414199311453321\,{\it t_5}+0.10186556948\right)\,{
C>    \it t_5}+0.22308199064\right)\,{\it t_5}+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& 0.1325688999052018\,{\it t_6}+1.0\\\\ 
C>   {\it t_9} &=& \log \left({{1.269642451250142\,{\it t_4}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01321299881039884\,{\it t_5}+0.029729725188\right)
C>    \,{\it t_5}+0.12236585478\right)\,{\it t_5}+0.3497952466}}
C>    +1.0\right)\\\\ 
C>   {\it t_{10}} &=& 0.06901399211255826\,{\it t_6}+1.0\\\\ 
C>   {\it t_{11}} &=& 0.5848223622634643\,\left(0.0337738\,{\it t_9}
C>    \,{\it t_{10}}+1.0\,\left(1.709920934161365\,\left(0.0621814
C>    \,{\it t_7}\,{\it t_8}-0.0310907\,\log 
C>    \left({{1.269642451250142\,{\it t_4}}\over{0.7876233178997433
C>    \,\left(0.7876233178997433\,\left(0.01530901310039024\,{\it t_5}
C>    +0.10465751434\right)\,{\it t_5}+0.19269083139\right)\,{\it t_5}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{\it t_6}
C>    +1.0\right)\right)-0.0337738\,{\it t_9}\,{
C>    \it t_{10}}\right)\right)-0.0621814\,{\it t_7}\,{\it t_8}\\\\ 
C>   {\it t_{12}} &=& {{1}\over{
C>    \left(\rho_\alpha^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{13}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{11}}}}}
C>    -1.0\\\\ 
C>   {\it t_{14}} &=& {{0.2162211495206379\,{\it t_{12}}\,
C>    \sigma_{\alpha\alpha}}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{15}} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_{16}} &=& {\it t_{15}}\,{\it t_2}\\\\ 
C>   {\it t_{17}} &=& 2.26\,{\it t_{16}}^{6.0}+0.5\,{\it t_{16}}^{4.0}
C>    +0.87\,{\it t_{16}}^{2.0}+0.53\\\\ 
C>   {\it t_{18}} &=& 1.0-{\it t_{15}}\,{\it t_2}\\\\ 
C>   {\it t_{19}} &=& {\it t_{16}}+1.0\\\\ 
C>   {\it t_{20}} &=& {{1}\over{\left({{0.0130605864926168\,
C>    \left({{1}\over{{\it t_{19}}^{1.333333333333333}}}+{{1}
C>    \over{{\it t_{18}}^{1.333333333333333}}}\right)\,\left({
C>    \it t_{19}}^2\,\sigma_{\beta\beta}-2.0\,{\it t_{18}}\,{
C>    \it t_{19}}\,\sigma_{\alpha\beta}+{\it t_{18}}^2\,
C>    \sigma_{\alpha\alpha}\right)}\over{{\it t_1}^{{{8}\over{3}}}}}
C>    +1.0\right)^{4.0}}}\\\\ 
C>   {\it t_{21}} &=& {\it t_{17}}\,{\it t_{20}}+1.0\\\\ 
C>   {\it t_{22}} &=& \sigma_{\beta\beta}+2.0\,\sigma_{\alpha\beta}
C>    +\sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{23}} &=& {{{\it t_2}\,{\it t_{22}}}\over{\tau_\beta
C>    +\tau_\alpha}}\\\\ 
C>   {\it t_{24}} &=& {\it t_{23}}^{2.0}\\\\ 
C>   {\it t_{25}} &=& \rho_\beta^{0.3333333333333333}\\\\ 
C>   {\it t_{26}} &=& \sqrt{{\it t_{25}}}\\\\ 
C>   {\it t_{27}} &=& {{1}\over{{\it t_{26}}}}\\\\ 
C>   {\it t_{28}} &=& {{1}\over{{\it t_{25}}}}\\\\ 
C>   {\it t_{29}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{26}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{27}}+0.10186556948\right)
C>    \,{\it t_{27}}+0.22308199064\right)\,{\it t_{27}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{30}} &=& 0.1325688999052018\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{31}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{26}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{27}}
C>    +0.029729725188\right)\,{\it t_{27}}+0.12236585478\right)\,{
C>    \it t_{27}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{32}} &=& 0.06901399211255826\,{\it t_{28}}+1.0\\\\ 
C>   {\it t_{33}} &=& 0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{31}}\,{\it t_{32}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{29}}\,{\it t_{30}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{26}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{27}}+0.10465751434\right)
C>    \,{\it t_{27}}+0.19269083139\right)\,{\it t_{27}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{28}}+1.0\right)\right)-0.0337738\,{\it t_{31}}\,{
C>    \it t_{32}}\right)\right)-0.0621814\,{\it t_{29}}\,{
C>    \it t_{30}}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{
C>    \left(\rho_\beta^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{35}} &=& {{1}\over{e^{64.32793688582967\,{\it t_{33}}}}}
C>    -1.0\\\\ 
C>   {\it t_{36}} &=& {{0.2162211495206379\,{\it t_{34}}\,
C>    \sigma_{\beta\beta}}\over{{\it t_{35}}}}\\\\ 
C>   {\it t_{37}} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_{38}} &=& {{1}\over{{\it t_{37}}}}\\\\ 
C>   {\it t_{39}} &=& 0.1325688999052018\,{\it t_{38}}+1.0\\\\ 
C>   {\it t_{40}} &=& \sqrt{{\it t_{37}}}\\\\ 
C>   {\it t_{41}} &=& {{1}\over{{\it t_{40}}}}\\\\ 
C>   {\it t_{42}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.02414199311453321\,{\it t_{41}}+0.10186556948\right)
C>    +0.22308199064\right)+0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{43}} &=& 0.06901399211255826\,{\it t_{38}}+1.0\\\\ 
C>   {\it t_{44}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{40}}}\over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.01321299881039884\,{\it t_{41}}+0.029729725188\right)
C>    +0.12236585478\right)+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{45}} &=& 0.5848223622634648\,\left(1.923661050931536
C>    \,{\it t_{19}}^{{{4}\over{3}}}+1.923661050931536\,{
C>    \it t_{18}}^{{{4}\over{3}}}-3.847322101863072\right)\,
C>    \left({{{\it t_{15}}^4\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{39}}\,{\it t_{42}}-0.0310907\,
C>    \left(0.1274696188700087\,{\it t_{38}}+1.0\right)\,\log 
C>    \left({{1.269642451250142\,{\it t_{40}}}
C>    \over{0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.7876233178997433\,{\it t_{41}}\,
C>    \left(0.01530901310039024\,{\it t_{41}}+0.10465751434\right)
C>    +0.19269083139\right)+0.43896648423}}+1.0\right)\right)
C>    -0.0337738\,{\it t_{43}}\,{\it t_{44}}\right)}\over{{
C>    \it t_1}^4}}+0.0337738\,{\it t_{43}}\,{\it t_{44}}\right)
C>    -0.0621814\,{\it t_{39}}\,{\it t_{42}}\\\\ 
C>   {\it t_{46}} &=& 0.5\,{\it t_{19}}^{{{2}\over{3}}}+0.5\,{
C>    \it t_{18}}^{{{2}\over{3}}}\\\\ 
C>   {\it t_{47}} &=& {\it t_{46}}^{3.0}\\\\ 
C>   {\it t_{48}} &=& {{1}\over{\left({
C>    \it t_1}^{1.166666666666667}\right)^{2.0}}}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{{\it t_{46}}^{2.0}}}\\\\ 
C>   {\it t_{50}} &=& {{1}\over{e^{{{32.16396844291483\,{
C>    \it t_{45}}}\over{{\it t_{47}}}}}}}-1.0\\\\ 
C>   {\it t_{51}} &=& {{0.1362107888567592\,{\it t_{48}}\,{
C>    \it t_{49}}\,{\it t_{22}}}\over{{\it t_{50}}}}\\\\ 
C>   {\it t_{52}} &=& \left(0.03109069086965489\,{\it t_{47}}
C>    \,\log \left({{0.1362107888567592\,{\it t_{48}}\,{\it t_{49}}
C>    \,{\it t_{22}}\,\left({\it t_{51}}+1.0\right)}
C>    \over{{{0.01855337900098064\,\left({\it t_{48}}\,{
C>    \it t_{22}}\right)^{2.0}}\over{{\it t_{46}}^{4.0}\,{
C>    \it t_{50}}^{2.0}}}+{\it t_{51}}+1.0}}+1.0\right)+1.0\,{
C>    \it t_{45}}\right)\,\left(0.015625\,{\it t_{17}}\,{\it t_{20}}
C>    \,{\it t_{24}}+1.0\right)-0.015625\,\rho_\beta\,{\it t_2}\,{
C>    \it t_{21}}\,\left(0.01554534543482744\,\log 
C>    \left({{0.2162211495206379\,{\it t_{34}}\,\sigma_{\beta\beta}
C>    \,\left({\it t_{36}}+1.0\right)}\over{{{0.04675158550002606
C>    \,\left({\it t_{34}}\,\sigma_{\beta\beta}\right)^{2.0}}
C>    \over{{\it t_{35}}^{2.0}}}+{\it t_{36}}+1.0}}+1.0\right)+1.0
C>    \,{\it t_{33}}\right)\,{\it t_{24}}-0.015625\,\rho_\alpha\,{
C>    \it t_2}\,\left(0.01554534543482744\,\log 
C>    \left({{0.2162211495206379\,{\it t_{12}}\,
C>    \sigma_{\alpha\alpha}\,\left({\it t_{14}}+1.0\right)}
C>    \over{{{0.04675158550002606\,\left({\it t_{12}}\,
C>    \sigma_{\alpha\alpha}\right)^{2.0}}\over{{\it t_{13}}^{2.0}}}
C>    +{\it t_{14}}+1.0}}+1.0\right)+1.0\,{\it t_{11}}\right)\,{
C>    \it t_{21}}\,{\it t_{24}}\\\\ 
C>   f &=& 1.0\,{\it t_1}\,{\it t_{52}}\,\left(0.00546875\,{
C>    \it t_{23}}^{3.0}\,{\it t_{52}}+1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 0.0\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc-Ds [3]. 
C> 
C> ### References ### 
C> 
C> [1] J Tao, JP Perdew, VN Staveroverov, GE Scuseria
C>    , Phys.Rev.Lett. 91, 146401 (2003)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevLett.91.146401 "> 
C> 10.1103/PhysRevLett.91.146401 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc-Ds, revision 27207 2015-06-23 
C> 
      subroutine nwxcm_c_tpss03_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,tau,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3,Mmat,Mmat2,Mmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,NCOL_RHO)      !< [Input] The density 
      double precision rgamma(nq,NCOL_GAMMA) !< [Input] The norm of the density 
                                             !< gradients 
      double precision tau(nq,NCOL_TAU)      !< [Input] The kinetic energy density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,NCOL_AMAT)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,NCOL_CMAT)   !< [Output] The derivative wrt rgamma 
      double precision Mmat(nq,NCOL_MMAT)   !< [Output] The derivative wrt tau 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,NCOL_AMAT2)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,NCOL_CMAT2)  !< [Output] The 2nd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat2(nq,NCOL_MMAT2)  !< [Output] The 2nd derivative wrt tau 
                                             !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,NCOL_AMAT3)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,NCOL_CMAT3)  !< [Output] The 3rd derivative wrt rgamma 
                                             !< and possibly rho 
      double precision Mmat3(nq,NCOL_MMAT3)  !< [Output] The 3rd derivative wrt tau 
                                             !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
!DIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          taua    = 0.5d0*tau(iq,T_T) 
          if (rhoa.gt.tol_rho) then 
            if (taua.gt.tol_rho) then 
              t1 = rhoa**3.333333333333333d-1
              t2 = t1**5.0d-1
              t3 = 1/t2
              t4 = log(1.4251254664507676d+0*t2/(7.016926042943223d-1*t3
     1           *(7.016926042943223d-1*(2.150807071909054d-2*t3+1.01865
     2           56948d-1)*t3+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
              t5 = 1/t1
              t6 = 1.0522000558389215d-1*t5+1.0d+0
              t7 = rhoa**1.1666666666666667d+0
              t8 = 1/t7**2.0d+0
              t9 = exp(2.0000005873362642d+0*t4*t6)-1.0d+0
              t10 = 1.0811057476031892d-1*gammaaa*t8/t9
              t11 = (gammaaa*t8)**2.0d+0
              t12 = 1/rhoa
              t13 = 1/taua
              t14 = gammaaa*t12*t13
              t15 = t14**2.0d+0
              t16 = 1.530901310039024d-2*t3+1.0465751434d-1
              t17 = 7.876233178997433d-1*t16*t3+1.9269083139d-1
              t18 = 7.876233178997433d-1*t17*t3+4.3896648423d-1
              t19 = 1/t18
              t20 = 1.269642451250142d+0*t19*t2+1.0d+0
              t21 = log(t20)
              t22 = 1.2746961887000874d-1*t5+1.0d+0
              t23 = 2.4141993114533214d-2*t3+1.0186556948d-1
              t24 = 7.876233178997433d-1*t23*t3+2.2308199064d-1
              t25 = 7.876233178997433d-1*t24*t3+4.7231125998d-1
              t26 = 1/t25
              t27 = 1.269642451250142d+0*t2*t26+1.0d+0
              t28 = log(t27)
              t29 = 1.325688999052018d-1*t5+1.0d+0
              t30 = 1.3212998810398843d-2*t3+2.9729725188d-2
              t31 = 7.876233178997433d-1*t3*t30+1.2236585478d-1
              t32 = 7.876233178997433d-1*t3*t31+3.497952466d-1
              t33 = 1/t32
              t34 = 1.269642451250142d+0*t2*t33+1.0d+0
              t35 = log(t34)
              t36 = 6.901399211255826d-2*t5+1.0d+0
              t37 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t28*t29-3.10907d-2*t21*t22)-3.37738d-2*t35*t
     2           36)+3.37738d-2*t35*t36)-6.21814d-2*t28*t29
              t38 = exp(-6.432793688582967d+1*t37)
              t39 = t38-1.0d+0
              t40 = 1/t39
              t41 = 2.1622114952063792d-1*gammaaa*t40*t8
              t42 = t41+1.0d+0
              t43 = 1/t39**2.0d+0
              t44 = 4.675158550002606d-2*t11*t43+t41+1.0d+0
              t45 = 1/t44
              t46 = 2.1622114952063792d-1*gammaaa*t42*t45*t8+1.0d+0
              t47 = 1.5545345434827443d-2*log(t46)+1.0d+0*t37
              t48 = (8.28125d-3*t15+1.0d+0)*(3.109069086965489d-2*log(1.
     1           0811057476031892d-1*gammaaa*(t10+1.0d+0)*t8/(1.16878963
     2           75006504d-2*t11/t9**2.0d+0+t10+1.0d+0)+1.0d+0)-6.21814d
     3           -2*t4*t6)-2.390625d-2*t15*t47
              t49 = 2.1508070719090538d-2*t3+1.0186556948d-1
              t50 = 7.016926042943222d-1*t3*t49+2.2308199064d-1
              t51 = 7.016926042943222d-1*t3*t50+4.7231125998d-1
              t52 = 1/t51
              t53 = 1.425125466450768d+0*t2*t52+1.0d+0
              t54 = log(t53)
              t55 = 1.0522000558389213d-1*t5+1.0d+0
              t56 = exp(2.0000005873362642d+0*t54*t55)
              t57 = t56-1.0d+0
              t58 = 1/t57
              t59 = 1.0811057476031893d-1*gammaaa*t58*t8
              t60 = t59+1.0d+0
              t61 = 1/t57**2.0d+0
              t62 = 1.168789637500651d-2*t11*t61+t59+1.0d+0
              t63 = 1/t62
              t64 = 1.0811057476031893d-1*gammaaa*t60*t63*t8+1.0d+0
              t65 = log(t64)
              t66 = 3.109069086965489d-2*t65-6.21814d-2*t54*t55
              t67 = 1.0d+0*gammaaa*t12*t13
              t68 = t67**2.0d+0
              t69 = 8.28125d-3*t68+1.0d+0
              t70 = t66*t69-2.390625d-2*t47*t68
              t71 = t67**3.0d+0
              t72 = 5.46875d-3*t70*t71+1.0d+0
              t73 = 1/rhoa**1.3333333333333333d+0
              t74 = 1/t53
              t75 = 1/t51**2
              t76 = 1/rhoa**1.3333333333333336d+0
              t77 = 1/t2**3
              t78 = 1/rhoa**6.666666666666667d-1
              t79 = -5.847438369119352d-2*t49*t77*t78-1.2576711796854242
     1           d-3*t76
              t80 = 7.016926042943222d-1*t3*t79-5.847438369119352d-2*t50
     1           *t77*t78
              t81 = 1.1876045553756398d-1*t3*t52*t78-1.425125466450768d+
     1           0*t2*t75*t80
              t82 = 1.090454542535705d-3*t54*t73-6.21814d-2*t55*t74*t81
              t83 = 1/t64
              t84 = rhoa**1.6666666666666674d-1
              t85 = 1/t7**3.0d+0
              t86 = -1.2612900388703877d-1*gammaaa*t58*t84*t85
              t87 = 1/t57**2
              t88 = 3.4772651149362827d+0*gammaaa*t56*t8*t82*t87
              t89 = t88+t86
              t90 = 1/t62**2
              t91 = gammaaa**2
              t92 = 1/t7**5.0d+0
              t93 = 1/t57**3.0d+0
              t94 = 7.518582603395361d-1*t11*t56*t82*t93-2.7271758208348
     1           523d-2*t61*t84*t91*t92+t88+t86
              t95 = -1.0811057476031893d-1*gammaaa*t60*t8*t90*t94+1.0811
     1           057476031893d-1*gammaaa*t63*t8*t89-1.2612900388703877d-
     2           1*gammaaa*t60*t63*t84*t85
              t96 = 3.109069086965489d-2*t83*t95+1.0d+0*t82
              t97 = 1/t20
              t98 = 1/t18**2
              t99 = -1.3127055298329054d-1*t16*t77*t78-2.009622615316665
     1           8d-3*t76
              t100 = 7.876233178997433d-1*t3*t99-1.3127055298329054d-1*t
     1           17*t77*t78
              t101 = 2.11607075208357d-1*t19*t3*t78-1.269642451250142d+0
     1           *t100*t2*t98
              t102 = 1/t27
              t103 = 1/t25**2
              t104 = -1.3127055298329054d-1*t23*t77*t78-3.16913278626356
     1           7d-3*t76
              t105 = 7.876233178997433d-1*t104*t3-1.3127055298329054d-1*
     1           t24*t77*t78
              t106 = 2.11607075208357d-1*t26*t3*t78-1.269642451250142d+0
     1           *t103*t105*t2
              t107 = 1/t34
              t108 = 1/t32**2
              t109 = -1.3127055298329054d-1*t30*t77*t78-1.73447766040861
     1           62d-3*t76
              t110 = 7.876233178997433d-1*t109*t3-1.3127055298329054d-1*
     1           t31*t77*t78
              t111 = 2.11607075208357d-1*t3*t33*t78-1.269642451250142d+0
     1           *t108*t110*t2
              t112 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t101*t22*t97-2.747773264188438d-3*t28*t73+
     2           1.3210398931339265d-3*t21*t73+6.21814d-2*t102*t106*t29)
     3           +7.769549222703733d-4*t35*t73-3.37738d-2*t107*t111*t36)
     4           -7.769549222703733d-4*t35*t73+3.37738d-2*t107*t111*t36)
     5           +2.747773264188438d-3*t28*t73-6.21814d-2*t102*t106*t29
              t113 = 1/t46
              t114 = -5.045160155481552d-1*gammaaa*t40*t84*t85
              t115 = 1/t39**2
              t116 = 1.3909060459745137d+1*gammaaa*t112*t115*t38*t8
              t117 = t116+t114
              t118 = 1/t44**2
              t119 = 1/t39**3.0d+0
              t120 = -2.181740656667883d-1*t43*t84*t91*t92+6.01486608271
     1           6293d+0*t11*t112*t119*t38+t116+t114
              t121 = -5.045160155481552d-1*gammaaa*t42*t45*t84*t85+2.162
     1           2114952063792d-1*gammaaa*t117*t45*t8-2.1622114952063792
     2           d-1*gammaaa*t118*t120*t42*t8
              t122 = 1.5545345434827443d-2*t113*t121+1.0d+0*t112
              t123 = 1/rhoa**3
              t124 = 1/taua**2
              t125 = t69*t96-8.28125d-3*t123*t124*t66*t91+2.390625d-2*t1
     1           23*t124*t47*t91-1.1953125d-2*t122*t68
              t126 = 1/rhoa**2
              t127 = 5.46875d-3*t125*t71-8.203124999999999d-3*gammaaa*t1
     1           26*t13*t68*t70
              t128 = 1/t7**4.0d+0
              t129 = 2.7027643690079733d-2*t58*t8+5.843948187503255d-3*g
     1           ammaaa*t128*t61
              t130 = -1.0811057476031893d-1*gammaaa*t129*t60*t8*t90+2.70
     1           27643690079733d-2*t60*t63*t8+2.9219740937516275d-3*gamm
     2           aaa*t128*t58*t63
              t131 = 2.1622114952063792d-1*t40*t8+9.350317100005212d-2*g
     1           ammaaa*t128*t43
              t132 = 2.1622114952063792d-1*t42*t45*t8-2.1622114952063792
     1           d-1*gammaaa*t118*t131*t42*t8+4.675158550002606d-2*gamma
     2           aa*t128*t40*t45
              t133 = 7.874506561842959d-2
              t134 = 1/rhoa**2.6666666666666666d+0
              t135 = 1.5749013123685918d-1
              t136 = 4.140625d-3*gammaaa*t124*t126-8.652638551358631d-4*
     1           t134*t135*t68
              t137 = 3.109069086965489d-2*t130*t69*t83+1.730527710271726
     1           5d-3*t133*t134*t47*t68-1.8581545715067177d-4*t113*t132*
     2           t68+t136*t66-1.1953125d-2*gammaaa*t124*t126*t47
              t138 = 5.46875d-3*t137*t71+4.1015624999999994d-3*t12*t13*t
     1           68*t70
              t139 = 5.405528738015947d-2*t58*t8+1.168789637500651d-2*ga
     1           mmaaa*t128*t61
              t140 = -1.0811057476031893d-1*gammaaa*t139*t60*t8*t90+5.40
     1           5528738015947d-2*t60*t63*t8+5.843948187503255d-3*gammaa
     2           a*t128*t58*t63
              t141 = 1.7305277102717265d-3*t134*t135*t68+8.28125d-3*gamm
     1           aaa*t124*t126
              t142 = 3.109069086965489d-2*t140*t69*t83-3.461055420543453
     1           d-3*t133*t134*t47*t68+t141*t66-2.390625d-2*gammaaa*t124
     2           *t126*t47
              t143 = 5.46875d-3*t142*t71+8.203124999999999d-3*t12*t13*t6
     1           8*t70
              t144 = 1/taua**3
              t145 = 2.390625d-2*t126*t144*t47*t91-8.28125d-3*t126*t144*
     1           t66*t91
              t146 = 5.46875d-3*t145*t71-8.203124999999999d-3*gammaaa*t1
     1           2*t124*t68*t70
              t147 = 2.0d+0*t125*t72*wght
              t148 = 1/rhoa**2.333333333333333d+0
              t149 = -7.269696950238034d-4*t148*t54
              t150 = 1.1771443702974158d-2*t3+2.9729725188d-2
              t151 = 7.016926042943222d-1*t150*t3+1.2236585478d-1
              t152 = 7.016926042943222d-1*t151*t3+3.497952466d-1
              t153 = 1/t152
              t154 = 1.425125466450768d+0*t153*t2+1.0d+0
              t155 = log(t154)
              t156 = 5.477644184000001d-2*t5+1.0d+0
              t157 = 2.18090908507141d-3*t73*t74*t81
              t158 = 1/t53**2
              t159 = t81**2
              t160 = 6.21814d-2*t158*t159*t55
              t161 = 1/t51**3
              t162 = t80**2
              t163 = 1/rhoa**2.3333333333333334d+0
              t164 = 1/rhoa**1.6666666666666669d+0
              t165 = 1/t2**5
              t166 = 1.949146123039784d-2*t164*t49*t77+1.461859592279837
     1           5d-2*t165*t49*t76+9.432533847640683d-4*t163
              t167 = -1.1694876738238703d-1*t77*t78*t79+1.94914612303978
     1           4d-2*t164*t50*t77+1.4618595922798375d-2*t165*t50*t76+7.
     2           016926042943222d-1*t166*t3
              t168 = -2.3752091107512796d-1*t3*t75*t78*t80-9.89670462813
     1           0328d-3*t52*t76*t77-1.425125466450768d+0*t167*t2*t75-3.
     2           9586818512521327d-2*t164*t3*t52+2.850250932901536d+0*t1
     3           61*t162*t2
              t169 = -6.21814d-2*t168*t55*t74
              t170 = t169+t160+t157+8.443450000000001d-3*t126*t155*t156+
     1           t149
              t171 = 1/t64**2
              t172 = t95**2
              t173 = -3.109069086965489d-2*t171*t172
              t174 = rhoa**3.333333333333335d-1
              t175 = 2.2072575680231782d-1*gammaaa*t128*t174*t60*t63
              t176 = 1/rhoa**8.333333333333333d-1
              t177 = -1.0510750323919903d-2*gammaaa*t176*t60*t63*t85
              t178 = -2.5225800777407753d-1*gammaaa*t63*t84*t85*t89
              t179 = 2.5225800777407753d-1*gammaaa*t60*t84*t85*t90*t94
              t180 = -2.1622114952063787d-1*gammaaa*t8*t89*t90*t94
              t181 = 1/t62**3
              t182 = t94**2
              t183 = 2.1622114952063787d-1*gammaaa*t181*t182*t60*t8
              t184 = 2.2072575680231782d-1*gammaaa*t128*t174*t58
              t185 = -1.0510750323919903d-2*gammaaa*t176*t58*t85
              t186 = 1.2012286084479878d-2*gammaaa*t126*t58*t8
              t187 = -8.113618601517993d+0*gammaaa*t56*t82*t84*t85*t87
              t188 = t82**2
              t189 = -1.118426454244592d+2*gammaaa*t188*t56*t8*t87
              t190 = 3.3333343122271053d-1*t126*t54*t55-3.21639684429148
     1           3d+1*t170
              t191 = -1.0811057476031893d-1*gammaaa*t190*t56*t8*t87
              t192 = 1/t57**3
              t193 = exp(4.0000011746725284d+0*t54*t55)
              t194 = 2.236852908489184d+2*gammaaa*t188*t192*t193*t8
              t195 = t194+t191+t189+t187+t186+t185+t184
              t196 = 1/t7**6.0d+0
              t197 = 7.95426281076832d-2*t174*t196*t61*t91
              t198 = -2.2726465173623778d-3*t176*t61*t91*t92
              t199 = -3.508671881584501d+0*t56*t82*t84*t91*t92*t93
              t200 = 1/t57**4.0d+0
              t201 = 7.254823607731703d+1*t11*t188*t193*t200
              t202 = -2.337579275001302d-2*t11*t190*t56*t93-2.4182745359
     1           105678d+1*t11*t188*t56*t93+2.597310305557001d-3*t11*t12
     2           6*t61+t201+t199+t198+t197+t194+t191+t189+t187+t186+t185
     3           +t184
              t203 = -1.0811057476031893d-1*gammaaa*t202*t60*t8*t90+1.20
     1           12286084479878d-2*gammaaa*t126*t60*t63*t8+1.08110574760
     2           31893d-1*gammaaa*t195*t63*t8+t183+t180+t179+t178+t177+t
     3           175
              t204 = 3.109069086965489d-2*t203*t83-5.181781811609147d-3*
     1           t126*t65+t173+1.0d+0*t170
              t205 = 1/t20**2
              t206 = t101**2
              t207 = 1/t18**3
              t208 = t100**2
              t209 = 8.751370198886037d-2*t16*t164*t77+6.563527649164527
     1           d-2*t16*t165*t76+3.0144339229749983d-3*t163
              t210 = -2.625411059665811d-1*t77*t78*t99+8.751370198886037
     1           d-2*t164*t17*t77+6.563527649164527d-2*t165*t17*t76+7.87
     2           6233178997433d-1*t209*t3
              t211 = -4.23214150416714d-1*t100*t3*t78*t98-1.269642451250
     1           142d+0*t2*t210*t98-3.52678458680595d-2*t19*t76*t77-1.41
     2           07138347223802d-1*t164*t19*t3+2.539284902500284d+0*t2*t
     3           207*t208
              t212 = 1/t27**2
              t213 = t106**2
              t214 = 1/t25**3
              t215 = t105**2
              t216 = 8.751370198886037d-2*t164*t23*t77+6.563527649164527
     1           d-2*t165*t23*t76+4.753699179395351d-3*t163
              t217 = -2.625411059665811d-1*t104*t77*t78+8.75137019888603
     1           7d-2*t164*t24*t77+6.563527649164527d-2*t165*t24*t76+7.8
     2           76233178997433d-1*t216*t3
              t218 = -4.23214150416714d-1*t103*t105*t3*t78-3.52678458680
     1           595d-2*t26*t76*t77-1.4107138347223802d-1*t164*t26*t3-1.
     2           269642451250142d+0*t103*t2*t217+2.539284902500284d+0*t2
     3           *t214*t215
              t219 = 1/t34**2
              t220 = t111**2
              t221 = 1/t32**3
              t222 = t110**2
              t223 = 8.751370198886037d-2*t164*t30*t77+6.563527649164527
     1           d-2*t165*t30*t76+2.601716490612924d-3*t163
              t224 = -2.625411059665811d-1*t109*t77*t78+8.75137019888603
     1           7d-2*t164*t31*t77+6.563527649164527d-2*t165*t31*t76+7.8
     2           76233178997433d-1*t223*t3
              t225 = -4.23214150416714d-1*t108*t110*t3*t78-3.52678458680
     1           595d-2*t33*t76*t77-1.4107138347223802d-1*t164*t3*t33-1.
     2           269642451250142d+0*t108*t2*t224+2.539284902500284d+0*t2
     3           *t221*t222
              t226 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (2.642079786267853d-3*t101*t73*t97-3.10907d-2*t211*t22*
     2           t97-5.495546528376876d-3*t102*t106*t73+6.21814d-2*t102*
     3           t218*t29-6.21814d-2*t212*t213*t29+3.663697685584584d-3*
     4           t148*t28+3.10907d-2*t205*t206*t22-1.7613865241785687d-3
     5           *t148*t21)+1.5539098445407465d-3*t107*t111*t73-3.37738d
     6           -2*t107*t225*t36+3.37738d-2*t219*t220*t36-1.03593989636
     7           04977d-3*t148*t35)-1.5539098445407465d-3*t107*t111*t73+
     8           3.37738d-2*t107*t225*t36-3.37738d-2*t219*t220*t36+1.035
     9           9398963604977d-3*t148*t35)+5.495546528376876d-3*t102*t1
     :           06*t73-6.21814d-2*t102*t218*t29+6.21814d-2*t212*t213*t2
     ;           9-3.663697685584584d-3*t148*t28
              t227 = t112**2
              t228 = exp(-1.2865587377165935d+2*t37)
              t229 = 1/t39**3
              t230 = 1.7894823267913484d+3*gammaaa*t227*t228*t229*t8
              t231 = 1.765806054418543d+0*gammaaa*t128*t174*t40
              t232 = -8.408600259135923d-2*gammaaa*t176*t40*t85
              t233 = -6.490894881214397d+1*gammaaa*t112*t115*t38*t84*t85
              t234 = -8.947411633956742d+2*gammaaa*t115*t227*t38*t8
              t235 = 1.3909060459745137d+1*gammaaa*t115*t226*t38*t8
              t236 = t235+t234+t233+t232+t231+t230
              t237 = 1/t39**4.0d+0
              t238 = -5.613875010535206d+1*t112*t119*t38*t84*t91*t92-3.6
     1           362344277798064d-2*t176*t43*t91*t92+1.2726820497229316d
     2           +0*t174*t196*t43*t91-3.869239257456912d+2*t11*t119*t227
     3           *t38+6.014866082716293d+0*t11*t119*t226*t38+1.160771777
     4           2370736d+3*t11*t227*t228*t237+t235+t234+t233+t232+t231+
     5           t230
              t239 = 1/t44**3
              t240 = t120**2
              t241 = -1.0090320310963104d+0*gammaaa*t117*t45*t84*t85+1.0
     1           090320310963104d+0*gammaaa*t118*t120*t42*t84*t85-8.4086
     2           00259135923d-2*gammaaa*t176*t42*t45*t85+2.1622114952063
     3           792d-1*gammaaa*t236*t45*t8+4.3244229904127585d-1*gammaa
     4           a*t239*t240*t42*t8-2.1622114952063792d-1*gammaaa*t118*t
     5           238*t42*t8-4.3244229904127585d-1*gammaaa*t117*t118*t120
     6           *t8+1.765806054418543d+0*gammaaa*t128*t174*t42*t45
              t242 = 1/t46**2
              t243 = t121**2
              t244 = -1.5545345434827443d-2*t242*t243+1.5545345434827443
     1           d-2*t113*t241+1.0d+0*t226
              t245 = 1/rhoa**4.666666666666667d+0
              t246 = 4.35d-1*t126-1.1075377345739049d-1*gammaaa*t135*t24
     1           5
              t247 = 2.390625d-2*t122*t123*t124*t91
              t248 = -1.6562500000000002d-2*t123*t124*t91*t96
              t249 = 1/rhoa**4
              t250 = -3.5859374999999993d-2*t124*t249*t47*t91
              t251 = 1.2421875d-2*t124*t249*t91
              t252 = -1.7305277102717265d-3*gammaaa*t135*t245*t68+6.7968
     1           75d-3*t126*t68+t251
              t253 = t204*t69-1.5625d-2*t246*t47*t68-1.1953125d-2*t244*t
     1           68-1.1953125d-2*t12*t122*t68+t252*t66+t250+t248+t247
              t254 = 2.0d+0*t127*t70*wght
              t255 = 4.0d+0*rhoa*t125*t127*wght
              t256 = gammaaa**3
              t257 = 1/rhoa**5
              t258 = 8.203124999999999d-3*t144*t256*t257*t70
              t259 = 8.203124999999999d-3*gammaaa*t123*t13*t68*t70
              t260 = -1.6406249999999997d-2*gammaaa*t125*t126*t13*t68
              t261 = 5.46875d-3*t253*t71+t260+t259+t258
              t262 = t169+t160+t157-8.44345d-3*t126*t155*t156+t149
              t263 = -1.201228608447988d-2*gammaaa*t126*t58*t8
              t264 = -1.1184264542445921d+2*gammaaa*t188*t56*t8*t87
              t265 = -3.3333343122271064d-1*t126*t54*t55-3.2163968442914
     1           83d+1*t262
              t266 = -1.0811057476031893d-1*gammaaa*t265*t56*t8*t87
              t267 = 2.2368529084891842d+2*gammaaa*t188*t192*t193*t8
              t268 = t267+t266+t264+t263+t187+t185+t184
              t269 = -2.337579275001302d-2*t11*t265*t56*t93-2.4182745359
     1           10568d+1*t11*t188*t56*t93-2.5973103055570024d-3*t11*t12
     2           6*t61+t267+t266+t264+t263+t201+t199+t198+t197+t187+t185
     3           +t184
              t270 = -1.0811057476031893d-1*gammaaa*t269*t60*t8*t90-1.20
     1           1228608447988d-2*gammaaa*t126*t60*t63*t8+1.081105747603
     2           1893d-1*gammaaa*t268*t63*t8+t183+t180+t179+t178+t177+t1
     3           75
              t271 = 3.109069086965489d-2*t270*t83+5.181781811609147d-3*
     1           t126*t65+1.0d+0*t262+t173
              t272 = 1.1075377345739049d-1*gammaaa*t135*t245-4.35d-1*t12
     1           6
              t273 = 1.7305277102717265d-3*gammaaa*t135*t245*t68-6.79687
     1           5d-3*t126*t68+t251
              t274 = t271*t69-1.5625d-2*t272*t47*t68+1.1953125d-2*t12*t1
     1           22*t68+t273*t66+t250+t248+t247
              t275 = 5.46875d-3*t274*t71+t260+t259+t258
              t276 = -3.153225097175969d-2*t58*t84*t85
              t277 = 8.693162787340707d-1*t56*t8*t82*t87
              t278 = t277+t276
              t279 = 3.7592913016976803d-1*gammaaa*t128*t56*t82*t93-1.36
     1           3587910417426d-2*gammaaa*t61*t84*t92+t277+t276
              t280 = -2.7027643690079733d-2*t60*t8*t90*t94-2.92197409375
     1           16275d-3*gammaaa*t128*t58*t90*t94+2.1622114952063787d-1
     2           *gammaaa*t129*t181*t60*t8*t94-3.408969776043566d-3*gamm
     3           aaa*t58*t63*t84*t92-1.0811057476031893d-1*gammaaa*t129*
     4           t8*t89*t90+1.2612900388703877d-1*gammaaa*t129*t60*t84*t
     5           85*t90-1.0811057476031893d-1*gammaaa*t279*t60*t8*t90+2.
     6           7027643690079733d-2*t63*t8*t89-3.153225097175969d-2*t60
     7           *t63*t84*t85+1.0811057476031893d-1*gammaaa*t278*t63*t8
              t281 = 3.109069086965489d-2*t280*t83-3.109069086965489d-2*
     1           t130*t171*t95
              t282 = t281*t69
              t283 = 8.652638551358631d-4*t122*t133*t134*t68
              t284 = -5.045160155481552d-1*t40*t84*t85
              t285 = 1.3909060459745137d+1*t112*t115*t38*t8
              t286 = t285+t284
              t287 = -4.363481313335766d-1*gammaaa*t43*t84*t92+1.2029732
     1           165432584d+1*gammaaa*t112*t119*t128*t38+t285+t284
              t288 = -1.0908703283339415d-1*gammaaa*t40*t45*t84*t92-5.04
     1           5160155481552d-1*t42*t45*t84*t85+5.045160155481552d-1*g
     2           ammaaa*t118*t131*t42*t84*t85+2.1622114952063792d-1*gamm
     3           aaa*t286*t45*t8+2.1622114952063792d-1*t117*t45*t8-2.162
     4           2114952063792d-1*gammaaa*t118*t287*t42*t8+4.32442299041
     5           27585d-1*gammaaa*t120*t131*t239*t42*t8-2.16221149520637
     6           92d-1*t118*t120*t42*t8-2.1622114952063792d-1*gammaaa*t1
     7           17*t118*t131*t8-4.675158550002606d-2*gammaaa*t118*t120*
     8           t128*t40
              t289 = 1.5545345434827443d-2*t113*t288-1.5545345434827443d
     1           -2*t121*t132*t242
              t290 = 3.937253280921477d-2
              t291 = 1/rhoa**3.6666666666666664d+0
              t292 = -1.7305277102717265d-3*t290*t291*t47*t68
              t293 = 1.8581545715067177d-4*t113*t123*t124*t132*t91
              t294 = -5.9765625d-3*gammaaa*t122*t124*t126
              t295 = -2.5746978376432955d-4*t123*t124*t130*t83*t91
              t296 = 2.4607833005759258d-3
              t297 = 1/rhoa**5.666666666666667d+0
              t298 = -5.537688672869524d-2*t124*t296*t297*t47*t91
              t299 = 1.1953125d-2*gammaaa*t123*t124*t47
              t300 = 4.921566601151848d-3
              t301 = 2.768844336434762d-2*t124*t297*t300*t91
              t302 = -4.140625d-3*gammaaa*t123*t124
              t303 = 4.0378979906340284d-3*t133*t291*t68+t302+t301
              t304 = t136*t96
              t305 = -3.172634135498165d-3*t133*t291*t47*t68-1.1953125d-
     1           2*t289*t68-9.290772857533588d-5*t113*t12*t132*t68+t303*
     2           t66+t304+t299+t298+t295+t294+t293+t292+t283+t282
              t306 = 1.0d+0*t137*t72*wght
              t307 = 2.0d+0*rhoa*t127*t137*wght
              t308 = 1.0d+0*t138*t70*wght
              t309 = 2.0d+0*rhoa*t125*t138*wght
              t310 = -4.1015624999999994d-3*t144*t249*t70*t91
              t311 = -2.0507812499999997d-3*t126*t13*t68*t70
              t312 = 4.1015624999999994d-3*t12*t125*t13*t68
              t313 = -8.203124999999999d-3*gammaaa*t126*t13*t137*t68
              t314 = 5.46875d-3*t305*t71+t313+t312+t311+t310
              t315 = -6.306450194351938d-2*t58*t84*t85
              t316 = 1.7386325574681413d+0*t56*t8*t82*t87
              t317 = t316+t315
              t318 = 7.518582603395361d-1*gammaaa*t128*t56*t82*t93-2.727
     1           175820834852d-2*gammaaa*t61*t84*t92+t316+t315
              t319 = -5.405528738015947d-2*t60*t8*t90*t94-5.843948187503
     1           255d-3*gammaaa*t128*t58*t90*t94+2.1622114952063787d-1*g
     2           ammaaa*t139*t181*t60*t8*t94-6.817939552087132d-3*gammaa
     3           a*t58*t63*t84*t92-1.0811057476031893d-1*gammaaa*t139*t8
     4           *t89*t90+1.2612900388703877d-1*gammaaa*t139*t60*t84*t85
     5           *t90-1.0811057476031893d-1*gammaaa*t318*t60*t8*t90+5.40
     6           5528738015947d-2*t63*t8*t89-6.306450194351938d-2*t60*t6
     7           3*t84*t85+1.0811057476031893d-1*gammaaa*t317*t63*t8
              t320 = 3.109069086965489d-2*t319*t83-3.109069086965489d-2*
     1           t140*t171*t95
              t321 = t320*t69
              t322 = -1.7305277102717265d-3*t122*t133*t134*t68
              t323 = 3.461055420543453d-3*t290*t291*t47*t68
              t324 = 2.8842128504528775d-3*t133*t291*t47*t68
              t325 = -1.1953125d-2*gammaaa*t122*t124*t126
              t326 = -2.5746978376432955d-4*t123*t124*t140*t83*t91
              t327 = 1.1075377345739049d-1*t124*t296*t297*t47*t91
              t328 = -5.537688672869524d-2*t124*t297*t300*t91-4.61474056
     1           0724604d-3*t133*t291*t68-8.28125d-3*gammaaa*t123*t124
              t329 = t328*t66
              t330 = t141*t96
              t331 = 2.390625d-2*gammaaa*t123*t124*t47+t330+t329+t327+t3
     1           26+t325+t324+t323+t322+t321
              t332 = -8.203124999999999d-3*t144*t249*t70*t91
              t333 = -4.1015624999999994d-3*t126*t13*t68*t70
              t334 = 8.203124999999999d-3*t12*t125*t13*t68
              t335 = -8.203124999999999d-3*gammaaa*t126*t13*t142*t68
              t336 = 5.46875d-3*t331*t71+t335+t334+t333+t332
              t337 = 9.290772857533588d-5*t113*t12*t132*t68
              t338 = 2.8842128504528763d-4*t133*t291*t47*t68
              t339 = 5.768425700905755d-4*t133*t291*t68+t302+t301
              t340 = t339*t66
              t341 = t340+t338+t337+t304+t299+t298+t295+t294+t293+t292+t
     1           283+t282
              t342 = 5.46875d-3*t341*t71+t313+t312+t311+t310
              t343 = t130**2
              t344 = -3.109069086965489d-2*t171*t343*t69
              t345 = t129**2
              t346 = -5.405528738015947d-2*t129*t60*t8*t90
              t347 = -5.843948187503255d-3*gammaaa*t128*t129*t58*t90
              t348 = -1.5794814935512527d-4*gammaaa*t196*t60*t61*t90+2.1
     1           622114952063787d-1*gammaaa*t181*t345*t60*t8+1.460987046
     2           8758138d-3*t128*t58*t63+t347+t346
              t349 = 3.109069086965489d-2*t348*t69*t83
              t350 = t132**2
              t351 = t131**2
              t352 = 4.3244229904127585d-1*gammaaa*t239*t351*t42*t8-4.32
     1           44229904127585d-1*t118*t131*t42*t8+9.350317100005212d-2
     2           *t128*t40*t45-2.0217363117456047d-2*gammaaa*t118*t196*t
     3           42*t43-9.350317100005212d-2*gammaaa*t118*t128*t131*t40
              t353 = 2.6901651040714963d-5*t113*t132*t133*t134*t68
              t354 = 1.2401570718501566d-2
              t355 = 1/rhoa**5.333333333333333d+0
              t356 = -2.2601706837873994d-4*t354*t355*t47*t68
              t357 = -1.8581545715067177d-4*gammaaa*t113*t124*t126*t132
              t358 = 1.384422168217381d-2*gammaaa*t124*t245*t300*t47
              t359 = 1.9686266404607394d-2
              t360 = 3.461055420543453d-3*gammaaa*t124*t245*t359*t47
              t361 = -2.98828125d-3*t124*t126*t47
              t362 = 2.4803141437003123d-2
              t363 = 9.843133202303697d-3
              t364 = 1.1300853418936997d-4*t355*t362*t68-6.9221108410869
     1           06d-3*gammaaa*t124*t245*t363-1.7305277102717265d-3*gamm
     2           aaa*t124*t245*t290+1.03515625d-3*t124*t126
              t365 = t364*t66
              t366 = 6.218138173930978d-2*t130*t136*t83
              t367 = -1.8581545715067177d-4*t113*t352*t68+1.858154571506
     1           7177d-4*t242*t350*t68+t366+t365+t361+t360+t358+t357+t35
     2           6+t353+t349+t344
              t368 = 4.0d+0*rhoa*t137*t138*wght
              t369 = 2.0507812499999997d-3*gammaaa*t123*t144*t70
              t370 = 8.203124999999999d-3*t12*t13*t137*t68
              t371 = 5.46875d-3*t367*t71+t370+t369
              t372 = -2.7027643690079733d-2*t139*t60*t8*t90-3.1589629871
     1           025054d-4*gammaaa*t196*t60*t61*t90-2.9219740937516275d-
     2           3*gammaaa*t128*t139*t58*t90+2.1622114952063787d-1*gamma
     3           aa*t129*t139*t181*t60*t8+2.9219740937516275d-3*t128*t58
     4           *t63+t347+t346
              t373 = 3.109069086965489d-2*t372*t69*t83
              t374 = -3.109069086965489d-2*t130*t140*t171*t69
              t375 = -2.6901651040714963d-5*t113*t132*t133*t134*t68
              t376 = 4.520341367574799d-4*t354*t355*t47*t68
              t377 = -5.9765625d-3*t124*t126*t47
              t378 = -2.2601706837873994d-4*t355*t362*t68
              t379 = 2.0703125d-3*t124*t126
              t380 = t379+t378+1.384422168217381d-2*gammaaa*t124*t245*t3
     1           63-3.461055420543453d-3*gammaaa*t124*t245*t290
              t381 = 3.109069086965489d-2*t136*t140*t83
              t382 = 3.109069086965489d-2*t130*t141*t83
              t383 = t380*t66+6.922110841086906d-3*gammaaa*t124*t245*t35
     1           9*t47-2.768844336434762d-2*gammaaa*t124*t245*t300*t47+t
     2           382+t381+t377+t376+t375+t374+t373+t357
              t384 = 4.1015624999999994d-3*gammaaa*t123*t144*t70
              t385 = 4.1015624999999994d-3*t12*t13*t142*t68
              t386 = 5.46875d-3*t383*t71+t385+t384+t370
              t387 = t366+t365+t361+t360+t358+t357+t356+t353+t349+t344
              t388 = 5.46875d-3*t387*t71+t370+t369
              t389 = t140**2
              t390 = t139**2
              t391 = -1.0811057476031893d-1*t139*t60*t8*t90-6.3179259742
     1           05011d-4*gammaaa*t196*t60*t61*t90-1.168789637500651d-2*
     2           gammaaa*t128*t139*t58*t90+2.1622114952063787d-1*gammaaa
     3           *t181*t390*t60*t8+5.843948187503255d-3*t128*t58*t63
              t392 = 4.520341367574799d-4*t355*t362*t68+2.76884433643476
     1           2d-2*gammaaa*t124*t245*t363+6.922110841086906d-3*gammaa
     2           a*t124*t245*t290+4.140625d-3*t124*t126
              t393 = 3.109069086965489d-2*t391*t69*t83+6.218138173930978
     1           d-2*t140*t141*t83-3.109069086965489d-2*t171*t389*t69-9.
     2           040682735149598d-4*t354*t355*t47*t68+t392*t66-1.3844221
     3           68217381d-2*gammaaa*t124*t245*t359*t47-5.53768867286952
     4           4d-2*gammaaa*t124*t245*t300*t47-1.1953125d-2*t124*t126*
     5           t47
              t394 = 5.46875d-3*t393*t71+8.203124999999999d-3*gammaaa*t1
     1           23*t144*t70+1.6406249999999997d-2*t12*t13*t142*t68
              t395 = 1.1953125d-2*t122*t126*t144*t91
              t396 = -8.28125d-3*t126*t144*t91*t96
              t397 = 8.28125d-3*t123*t144*t66*t91
              t398 = -2.390625d-2*t123*t144*t47*t91+t397+t396+t395
              t399 = 1/taua**4
              t400 = 8.203124999999999d-3*t249*t256*t399*t70
              t401 = 4.1015624999999994d-3*gammaaa*t124*t126*t68*t70
              t402 = -8.203124999999999d-3*gammaaa*t12*t124*t125*t68
              t403 = -8.203124999999999d-3*gammaaa*t126*t13*t145*t68
              t404 = 5.46875d-3*t398*t71+t403+t402+t401+t400
              t405 = 2.0d+0*rhoa*t398*t72*wght+1.0d+0*t145*t72*wght+2.0d
     1           +0*rhoa*t404*t70*wght+1.0d+0*t146*t70*wght+2.0d+0*rhoa*
     2           t125*t146*wght+2.0d+0*rhoa*t127*t145*wght
              t406 = 6.922110841086906d-3*t144*t245*t359*t91-4.140625d-3
     1           *gammaaa*t126*t144
              t407 = -2.5746978376432955d-4*t126*t130*t144*t83*t91-1.384
     1           422168217381d-2*t144*t245*t363*t47*t91+1.85815457150671
     2           77d-4*t113*t126*t132*t144*t91+t406*t66+1.1953125d-2*gam
     3           maaa*t126*t144*t47
              t408 = -4.1015624999999994d-3*t123*t399*t70*t91+5.46875d-3
     1           *t407*t71-2.0507812499999997d-3*t12*t124*t68*t70+4.1015
     2           624999999994d-3*t12*t13*t145*t68-8.203124999999999d-3*g
     3           ammaaa*t12*t124*t137*t68
              t409 = 2.0d+0*rhoa*t407*t72*wght+2.0d+0*rhoa*t408*t70*wght
     1           +2.0d+0*rhoa*t137*t146*wght+2.0d+0*rhoa*t138*t145*wght
              t410 = -1.384422168217381d-2*t144*t245*t359*t91-8.28125d-3
     1           *gammaaa*t126*t144
              t411 = -2.5746978376432955d-4*t126*t140*t144*t83*t91+2.768
     1           844336434762d-2*t144*t245*t363*t47*t91+t410*t66+2.39062
     2           5d-2*gammaaa*t126*t144*t47
              t412 = -8.203124999999999d-3*t123*t399*t70*t91+5.46875d-3*
     1           t411*t71-4.1015624999999994d-3*t12*t124*t68*t70+8.20312
     2           4999999999d-3*t12*t13*t145*t68-8.203124999999999d-3*gam
     3           maaa*t12*t124*t142*t68
              t413 = 1.2421875d-2*t126*t399*t66*t91-3.5859375d-2*t126*t3
     1           99*t47*t91
              t414 = 1/taua**5
              t415 = 5.46875d-3*t413*t71+8.203124999999999d-3*gammaaa*t1
     1           2*t144*t68*t70+8.203124999999999d-3*t123*t256*t414*t70-
     2           1.6406249999999997d-2*gammaaa*t12*t124*t145*t68
              t416 = 2.0d+0*rhoa*t413*t72*wght+2.0d+0*rhoa*t415*t70*wght
     1           +4.0d+0*rhoa*t145*t146*wght
              t417 = 1/rhoa**3.333333333333333d+0
              t418 = 8.48131310861104d-4*t417*t54
              t419 = -2.1809090850714105d-3*t148*t74*t81
              t420 = 3.37738d-2*t156*(1.1876045553756398d-1*t153*t3*t78-
     1           1.425125466450768d+0*t2*(7.016926042943222d-1*t3*(-5.84
     2           7438369119352d-2*t150*t77*t78-6.883279156869946d-4*t76)
     3           -5.847438369119352d-2*t151*t77*t78)/t152**2)/t154-3.083
     4           347652359653d-4*t155*t73
              t421 = -3.2713636276071156d-3*t158*t159*t73
              t422 = 3.2713636276071156d-3*t168*t73*t74
              t423 = -1.243628d-1*t55*t81**3/t53**3
              t424 = 1.865442d-1*t158*t168*t55*t81
              t425 = 1/rhoa**3.3333333333333337d+0
              t426 = 1/rhoa**2.666666666666667d+0
              t427 = 1/t2**7
              t428 = 1/rhoa**2.0d+0
              t429 = -6.21814d-2*t55*t74*(-8.550752798704606d+0*t2*t80**
     1           3/t51**4+2.969011388439098d-2*t75*t76*t77*t80+1.1876045
     2           553756398d-1*t164*t3*t75*t80+8.550752798704606d+0*t161*
     3           t167*t2*t80-1.425125466450768d+0*t2*t75*(5.847438369119
     4           352d-2*t164*t77*t79+4.385578776839513d-2*t165*t76*t79-1
     5           .7542315107358056d-1*t166*t77*t78+7.016926042943222d-1*
     6           t3*(-1.6242884358664864d-2*t426*t49*t77-6.0910816344993
     7           22d-3*t427*t428*t49-1.4618595922798375d-2*t163*t165*t49
     8           -1.161599075681677d-3*t425)-1.6242884358664864d-2*t426*
     9           t50*t77-6.091081634499322d-3*t427*t428*t50-1.4618595922
     :           798375d-2*t163*t165*t50)-3.5628136661269194d-1*t167*t3*
     ;           t75*t78+7.125627332253839d-1*t161*t162*t3*t78+9.8967046
     <           2813033d-3*t163*t52*t77+2.474176157032582d-3*t165*t428*
     =           t52+3.29890154271011d-2*t3*t426*t52)
              t430 = t429+t424+t423+t422+t421+7.500000000000002d-1*t126*
     1           t420+t419+t418-2.533035d-2*t123*t155*t156
              t431 = 1/t64**3
              t432 = 6.218138173930978d-2*t431*t95**3
              t433 = rhoa**5.000000000000002d-1
              t434 = -5.150267658720751d-1*gammaaa*t433*t60*t63*t92
              t435 = 1/rhoa**6.666666666666665d-1
              t436 = 5.518143920057951d-2*gammaaa*t128*t435*t60*t63
              t437 = 1/rhoa**1.8333333333333332d+0
              t438 = 7.567740233222326d-1*gammaaa*t84*t85*t89*t90*t94
              t439 = -7.567740233222326d-1*gammaaa*t181*t182*t60*t84*t85
              t440 = 6.486634485619136d-1*gammaaa*t181*t182*t8*t89
              t441 = 1/t62**4
              t442 = -6.486634485619136d-1*gammaaa*t441*t60*t8*t94**3
              t443 = -5.150267658720751d-1*gammaaa*t433*t58*t92
              t444 = 5.518143920057951d-2*gammaaa*t128*t435*t58
              t445 = -3.766352199404629d-2*gammaaa*t437*t58*t85
              t446 = -3.603685825343965d-2*gammaaa*t123*t58*t8
              t447 = 2.1298248828984737d+1*gammaaa*t128*t174*t56*t82*t87
              t448 = -1.0142023251897499d+0*gammaaa*t176*t56*t82*t85*t87
              t449 = 3.9144925898560723d+2*gammaaa*t188*t56*t84*t85*t87
              t450 = 3.783870116611163d-1*gammaaa*t190*t56*t84*t85*t87
              t451 = t82**3
              t452 = 3.597303318004418d+3*gammaaa*t451*t56*t8*t87
              t453 = 1.1590883716454273d+0*gammaaa*t126*t56*t8*t82*t87
              t454 = -1.608198422145741d+1*t126*t82-1.0000002936681321d+
     1           0*t123*t54*t55-3.216396844291483d+1*t430
              t455 = -1.0811057476031893d-1*gammaaa*t454*t56*t8*t87
              t456 = 1.0431795344808847d+1*gammaaa*t190*t56*t8*t82*t87
              t457 = -7.828985179712145d+2*gammaaa*t188*t192*t193*t84*t8
     1           5
              t458 = -2.1583819908026508d+4*gammaaa*t192*t193*t451*t8
              t459 = -2.0863590689617695d+1*gammaaa*t190*t192*t193*t8*t8
     1           2
              t460 = exp(6.000001762008792d+0*t54*t55)
              t461 = 2.1583819908026508d+4*gammaaa*t451*t460*t8/t57**4
              t462 = 1/t7**7.0d+0
              t463 = -2.783991983768912d-1*t433*t462*t61*t91
              t464 = 1.9885657026920814d-2*t196*t435*t61*t91
              t465 = 1.5350439481932196d+1*t174*t196*t56*t82*t91*t93
              t466 = 1.6927921751373973d+2*t188*t56*t84*t91*t92*t93
              t467 = 7.778130585933201d+2*t11*t451*t56*t93
              t468 = -5.078376525412192d+2*t188*t193*t200*t84*t91*t92
              t469 = -7.000317527339879d+3*t11*t193*t200*t451
              t470 = 9.33375670311984d+3*t11*t451*t460/t57**5.0d+0
              t471 = 1/t27**3
              t472 = t106**3
              t473 = -1.269642451250142d+0*t103*t2*(-3.9381165894987163d
     1           -1*t216*t77*t78+7.876233178997433d-1*t3*(-1.45856169981
     2           43394d-1*t23*t426*t77-5.469606374303773d-2*t23*t427*t42
     3           8-1.1708185015918181d-2*t425-1.3127055298329054d-1*t163
     4           *t165*t23)-1.4585616998143394d-1*t24*t426*t77+2.6254110
     5           59665811d-1*t104*t164*t77+1.9690582947493582d-1*t104*t1
     6           65*t76-5.469606374303773d-2*t24*t427*t428-1.31270552983
     7           29054d-1*t163*t165*t24)-6.34821225625071d-1*t103*t217*t
     8           3*t78+1.269642451250142d+0*t214*t215*t3*t78+1.058035376
     9           0417849d-1*t103*t105*t76*t77+7.053569173611901d-2*t163*
     :           t26*t77+1.763392293402975d-2*t165*t26*t428+2.3511897245
     ;           373004d-1*t26*t3*t426+4.2321415041671406d-1*t103*t105*t
     <           164*t3-7.617854707500852d+0*t105**3*t2/t25**4+7.6178547
     =           07500852d+0*t105*t2*t214*t217
              t474 = 1/t34**3
              t475 = t111**3
              t476 = -1.269642451250142d+0*t108*t2*(-3.9381165894987163d
     1           -1*t223*t77*t78+7.876233178997433d-1*t3*(-1.45856169981
     2           43394d-1*t30*t426*t77-5.469606374303773d-2*t30*t427*t42
     3           8-6.407931356509611d-3*t425-1.3127055298329054d-1*t163*
     4           t165*t30)-1.4585616998143394d-1*t31*t426*t77+2.62541105
     5           9665811d-1*t109*t164*t77+1.9690582947493582d-1*t109*t16
     6           5*t76-5.469606374303773d-2*t31*t427*t428-1.312705529832
     7           9054d-1*t163*t165*t31)-6.34821225625071d-1*t108*t224*t3
     8           *t78+1.269642451250142d+0*t221*t222*t3*t78+1.0580353760
     9           417849d-1*t108*t110*t76*t77+7.053569173611901d-2*t163*t
     :           33*t77+1.763392293402975d-2*t165*t33*t428+2.35118972453
     ;           73004d-1*t3*t33*t426-7.617854707500852d+0*t110**3*t2/t3
     <           2**4+4.2321415041671406d-1*t108*t110*t164*t3+7.61785470
     =           7500852d+0*t110*t2*t221*t224
              t477 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*
     1           (-3.10907d-2*t22*t97*(-1.269642451250142d+0*t2*t98*(2.6
     2           25411059665811d-1*t164*t77*t99+1.9690582947493582d-1*t1
     3           65*t76*t99-3.9381165894987163d-1*t209*t77*t78+7.8762331
     4           78997433d-1*t3*(-1.4585616998143394d-1*t16*t426*t77-5.4
     5           69606374303773d-2*t16*t427*t428-7.424439106586571d-3*t4
     6           25-1.3127055298329054d-1*t16*t163*t165)-1.4585616998143
     7           394d-1*t17*t426*t77-5.469606374303773d-2*t17*t427*t428-
     8           1.3127055298329054d-1*t163*t165*t17)-6.34821225625071d-
     9           1*t210*t3*t78*t98+1.0580353760417849d-1*t100*t76*t77*t9
     :           8+4.2321415041671406d-1*t100*t164*t3*t98+1.269642451250
     ;           142d+0*t207*t208*t3*t78+7.053569173611901d-2*t163*t19*t
     <           77+1.763392293402975d-2*t165*t19*t428+2.351189724537300
     =           4d-1*t19*t3*t426+7.617854707500852d+0*t100*t2*t207*t210
     >           -7.617854707500852d+0*t100**3*t2/t18**4)+3.963119679401
     ?           78d-3*t211*t73*t97-5.284159572535706d-3*t101*t148*t97-8
     @           .243319792565315d-3*t102*t218*t73+8.243319792565315d-3*
     1           t212*t213*t73-3.96311967940178d-3*t205*t206*t73+6.21814
     2           d-2*t102*t29*t473+1.243628d-1*t29*t471*t472-8.548627933
     3           030694d-3*t28*t417+4.1099018897499934d-3*t21*t417-1.865
     4           442d-1*t106*t212*t218*t29+9.327209999999999d-2*t101*t20
     5           5*t211*t22-6.21814d-2*t101**3*t22/t20**3+1.099109305675
     6           3751d-2*t102*t106*t148)+2.33086476681112d-3*t107*t225*t
     7           73-2.33086476681112d-3*t219*t220*t73-3.37738d-2*t107*t3
     8           6*t476-6.75476d-2*t36*t474*t475+2.4171930915078277d-3*t
     9           35*t417+1.013214d-1*t111*t219*t225*t36-3.10781968908149
     :           3d-3*t107*t111*t148)-2.33086476681112d-3*t107*t225*t73+
     ;           2.33086476681112d-3*t219*t220*t73+3.37738d-2*t107*t36*t
     <           476+6.75476d-2*t36*t474*t475-2.4171930915078277d-3*t35*
     =           t417-1.013214d-1*t111*t219*t225*t36+3.107819689081493d-
     >           3*t107*t111*t148)+8.243319792565315d-3*t102*t218*t73-8.
     ?           243319792565315d-3*t212*t213*t73-6.21814d-2*t102*t29*t4
     @           73-1.243628d-1*t29*t471*t472+8.548627933030694d-3*t28*t
     1           417+1.865442d-1*t106*t212*t218*t29-1.0991093056753751d-
     2           2*t102*t106*t148
              t478 = t112**3
              t479 = exp(-1.92983810657489d+2*t37)
              t480 = 3.453411185284245d+5*gammaaa*t478*t479*t8/t39**4
              t481 = -1.252637628753944d+4*gammaaa*t227*t228*t229*t84*t8
     1           5
              t482 = -3.453411185284245d+5*gammaaa*t228*t229*t478*t8
              t483 = 5.368446980374045d+3*gammaaa*t112*t226*t228*t229*t8
              t484 = -8.240428253953201d+0*gammaaa*t40*t433*t92
              t485 = 8.829030272092719d-1*gammaaa*t128*t40*t435
              t486 = 7.007166882613269d-2*gammaaa*t40*t437*t85
              t487 = 3.4077198126375585d+2*gammaaa*t112*t115*t128*t174*t
     1           38
              t488 = -1.6227237203036002d+1*gammaaa*t112*t115*t176*t38*t
     1           85
              t489 = 6.263188143769719d+3*gammaaa*t115*t227*t38*t84*t85
              t490 = -9.736342321821596d+1*gammaaa*t115*t226*t38*t84*t85
              t491 = 5.755685308807075d+4*gammaaa*t115*t38*t478*t8
              t492 = -2.6842234901870227d+3*gammaaa*t112*t115*t226*t38*t
     1           8
              t493 = 1.3909060459745137d+1*gammaaa*t115*t38*t477*t8
              t494 = 1/t44**4
              t495 = 1/t46**3
              t496 = -1.5672703791140163d-1*gammaaa*t135*t297-4.17938767
     1           7637377d-1*gammaaa*t133*t297
              t497 = 7.171875000000001d-2*t124*t257*t47*t91
              t498 = 1/rhoa**7.666666666666667d+0
              t499 = 3.461055420543453d-3*t124*t133*t256*t498
              t500 = 3*t252*t96+t69*(-1.5545345434827443d-2*t126*t83*t95
     1           -9.327207260896466d-2*t171*t203*t95+3.109069086965489d-
     2           2*t83*(3.153225097175971d-2*gammaaa*t176*t60*t85*t90*t9
     3           4-3.6036858253439635d-2*gammaaa*t126*t60*t8*t90*t94-3.2
     4           43317242809568d-1*gammaaa*t195*t8*t90*t94-6.62177270406
     5           9536d-1*gammaaa*t128*t174*t60*t90*t94+6.486634485619136
     6           d-1*gammaaa*t181*t202*t60*t8*t94-1.0811057476031893d-1*
     7           gammaaa*t60*t8*t90*(1.6363054925009113d-1*t190*t56*t84*
     8           t91*t92*t93-4.385839851980629d-1*t176*t56*t82*t91*t92*t
     9           93+2.2555747810186078d+0*t11*t190*t56*t82*t93+5.0123884
     :           02263571d-1*t11*t126*t56*t82*t93-2.337579275001302d-2*t
     ;           11*t454*t56*t93-1.723423608999802d-2*t437*t61*t91*t92-6
     <           .766724343055823d+0*t11*t190*t193*t200*t82-7.7919309166
     =           71007d-3*t11*t123*t61+t470+t469+t468+t467+t466+t465+t46
     >           4+t463+t461+t459+t458+t457+t456+t455+t453+t452+t450+t44
     ?           9+t448+t447+t446+t445+t444+t443)-3.243317242809568d-1*g
     @           ammaaa*t202*t8*t89*t90+3.783870116611163d-1*gammaaa*t20
     1           2*t60*t84*t85*t90-3.153225097175971d-2*gammaaa*t176*t63
     2           *t85*t89+3.6036858253439635d-2*gammaaa*t126*t63*t8*t89+
     3           6.621772704069536d-1*gammaaa*t128*t174*t63*t89-3.783870
     4           116611163d-1*gammaaa*t195*t63*t84*t85-3.766352199404629
     5           d-2*gammaaa*t437*t60*t63*t85-3.603685825343965d-2*gamma
     6           aa*t123*t60*t63*t8+1.0811057476031893d-1*gammaaa*(t461+
     7           t459+t458+t457+t456+t455+t453+t452+t450+t449+t448+t447+
     8           t446+t445+t444+t443)*t63*t8+t442+t440+t439+t438+t436+t4
     9           34)+1.5545345434827446d-2*t123*t65+t432+1.0d+0*t430)-1.
     :           1953125d-2*t68*(1.5545345434827443d-2*t113*(-2.16221149
     ;           52063792d-1*gammaaa*t118*t42*t8*(5.416934960439678d+3*t
     <           119*t227*t38*t84*t91*t92-8.420812515802809d+1*t119*t226
     =           *t38*t84*t91*t92-1.6250804881319034d+4*t227*t228*t237*t
     >           84*t91*t92+3.030195356483172d-2*t43*t437*t91*t92-1.4034
     ?           687526338024d+1*t112*t119*t176*t38*t91*t92-8.9087743480
     @           60522d+0*t43*t433*t462*t91+6.363410248614662d-1*t196*t4
     1           3*t435*t91+4.912140634218306d+2*t112*t119*t174*t196*t38
     2           *t91+t493+t492+t491+t490+t489+t488+t487+t486+t485+t484+
     3           t483+t482+t481+t480+2.9868021449983523d+5*t11*t478*t479
     4           /t39**5.0d+0+2.4890017874986267d+4*t11*t119*t38*t478-2.
     5           2401016087487644d+5*t11*t228*t237*t478+6.01486608271629
     6           3d+0*t11*t119*t38*t477-1.1607717772370736d+3*t11*t112*t
     7           119*t226*t38+3.482315331711221d+3*t11*t112*t226*t228*t2
     8           37)-8.240428253953201d+0*gammaaa*t42*t433*t45*t92-1.513
     9           5480466444656d+0*gammaaa*t236*t45*t84*t85-3.02709609328
     :           8931d+0*gammaaa*t239*t240*t42*t84*t85+1.513548046644465
     ;           6d+0*gammaaa*t118*t238*t42*t84*t85+3.027096093288931d+0
     <           *gammaaa*t117*t118*t120*t84*t85+7.007166882613269d-2*ga
     =           mmaaa*t42*t437*t45*t85-2.522580077740777d-1*gammaaa*t11
     >           7*t176*t45*t85+2.522580077740777d-1*gammaaa*t118*t120*t
     ?           176*t42*t85-1.2973268971238278d+0*gammaaa*t120**3*t42*t
     @           494*t8+2.1622114952063792d-1*gammaaa*t45*(t493+t492+t49
     1           1+t490+t489+t488+t487+t486+t485+t484+t483+t482+t481+t48
     2           0)*t8+1.2973268971238278d+0*gammaaa*t120*t238*t239*t42*
     3           t8+1.2973268971238278d+0*gammaaa*t117*t239*t240*t8-6.48
     4           6634485619138d-1*gammaaa*t117*t118*t238*t8-6.4866344856
     5           19138d-1*gammaaa*t118*t120*t236*t8+8.829030272092719d-1
     6           *gammaaa*t128*t42*t435*t45+5.297418163255629d+0*gammaaa
     7           *t117*t128*t174*t45-5.297418163255629d+0*gammaaa*t118*t
     8           120*t128*t174*t42)+3.1090690869654886d-2*t121**3*t495+1
     9           .0d+0*t477-4.6636036304482326d-2*t121*t241*t242)+t66*(-
     :           4.5234375d-2*t124*t257*t91-3.3125000000000004d-2*t496*t
     ;           68-2.0390624999999998d-2*t123*t68+t499+1.38442216821738
     <           1d-2*t124*t256*t290*t498)+4.6875d-2*t123*t124*t246*t47*
     =           t91-1.7929687500000002d-2*t122*t124*t249*t91+3.5859375d
     >           -2*t123*t124*t244*t91-2.484375d-2*t123*t124*t204*t91-1.
     ?           5625d-2*t47*(-2.1200000000000002d+0*t496-1.305d+0*t123)
     @           *t68-2.34375d-2*t122*t246*t68-1.79296875d-2*t12*t244*t6
     1           8+1.79296875d-2*t122*t126*t68+t497
              t501 = 6.0d+0*t125*t127*wght
              t502 = -2.8710937499999994d-2*t144*t256*t70/rhoa**6
              t503 = 2.4609374999999994d-2*t125*t144*t256*t257
              t504 = -1.2304687499999997d-2*gammaaa*t13*t249*t68*t70
              t505 = 2.4609374999999994d-2*gammaaa*t123*t125*t13*t68
              t506 = t429+t424+t423+t422+t421-2.4999999999999994d-1*t126
     1           *t420+t419+t418+8.44345d-3*t123*t155*t156
              t507 = 1.8393813066859827d-2*gammaaa*t437*t58*t85
              t508 = 1.2012286084479884d-2*gammaaa*t123*t58*t8
              t509 = 2.1298248828984734d+1*gammaaa*t128*t174*t56*t82*t87
              t510 = -1.0142023251897496d+0*gammaaa*t176*t56*t82*t85*t87
              t511 = 2.5225800777407753d-1*gammaaa*t265*t56*t84*t85*t87
              t512 = 1.2612900388703877d-1*gammaaa*t190*t56*t84*t85*t87
              t513 = -3.8636279054847583d-1*gammaaa*t126*t56*t8*t82*t87
              t514 = 5.360661407152473d+0*t126*t82+3.333334312227107d-1*
     1           t123*t54*t55-3.216396844291483d+1*t506
              t515 = -1.0811057476031893d-1*gammaaa*t514*t56*t8*t87
              t516 = 6.954530229872565d+0*gammaaa*t265*t56*t8*t82*t87
              t517 = 3.4772651149362827d+0*gammaaa*t190*t56*t8*t82*t87
              t518 = -1.3909060459745132d+1*gammaaa*t192*t193*t265*t8*t8
     1           2
              t519 = -6.954530229872565d+0*gammaaa*t190*t192*t193*t8*t82
              t520 = 5.224234597046721d-2*gammaaa*t135*t297+1.3931292258
     1           791256d-1*gammaaa*t133*t297
              t521 = 2*t273*t96+t252*t96+t69*(5.181781811609149d-3*t126*
     1           t83*t95-6.218138173930978d-2*t171*t270*t95-3.1090690869
     2           65489d-2*t171*t203*t95+3.109069086965489d-2*t83*(3.1532
     3           250971759707d-2*gammaaa*t176*t60*t85*t90*t94+1.20122860
     4           84479881d-2*gammaaa*t126*t60*t8*t90*t94-2.1622114952063
     5           787d-1*gammaaa*t268*t8*t90*t94-1.0811057476031893d-1*ga
     6           mmaaa*t195*t8*t90*t94-6.621772704069535d-1*gammaaa*t128
     7           *t174*t60*t90*t94+4.3244229904127574d-1*gammaaa*t181*t2
     8           69*t60*t8*t94+2.1622114952063787d-1*gammaaa*t181*t202*t
     9           60*t8*t94-1.0811057476031893d-1*gammaaa*t60*t8*t90*(1.0
     :           908703283339408d-1*t265*t56*t84*t91*t92*t93+5.454351641
     ;           669705d-2*t190*t56*t84*t91*t92*t93-4.3858398519806285d-
     <           1*t176*t56*t82*t91*t92*t93+1.503716520679072d+0*t11*t26
     =           5*t56*t82*t93+7.518582603395361d-1*t11*t190*t56*t82*t93
     >           -1.6707961340878583d-1*t11*t126*t56*t82*t93-2.337579275
     ?           001302d-2*t11*t514*t56*t93+7.00732676186733d-3*t437*t61
     @           *t91*t92-4.5111495620372155d+0*t11*t193*t200*t265*t82-2
     1           .2555747810186078d+0*t11*t190*t193*t200*t82+2.597310305
     2           557003d-3*t11*t123*t61+t519+t518+t517+t516+t515+t513+t5
     3           12+t511+t510+t509+t508+t507+t470+t469+t468+t467+t466+t4
     4           65+t464+t463+t461+t458+t457+t452+t449+t444+t443)-2.1622
     5           114952063787d-1*gammaaa*t269*t8*t89*t90-1.0811057476031
     6           893d-1*gammaaa*t202*t8*t89*t90+2.5225800777407753d-1*ga
     7           mmaaa*t269*t60*t84*t85*t90+1.2612900388703877d-1*gammaa
     8           a*t202*t60*t84*t85*t90-3.1532250971759707d-2*gammaaa*t1
     9           76*t63*t85*t89-1.2012286084479881d-2*gammaaa*t126*t63*t
     :           8*t89+6.621772704069535d-1*gammaaa*t128*t174*t63*t89-2.
     ;           5225800777407753d-1*gammaaa*t268*t63*t84*t85-1.26129003
     <           88703877d-1*gammaaa*t195*t63*t84*t85+1.8393813066859827
     =           d-2*gammaaa*t437*t60*t63*t85+1.2012286084479884d-2*gamm
     >           aaa*t123*t60*t63*t8+1.0811057476031893d-1*gammaaa*(t519
     ?           +t518+t517+t516+t515+t513+t512+t511+t510+t509+t508+t507
     @           +t461+t458+t457+t452+t449+t444+t443)*t63*t8+t442+t440+t
     1           439+t438+t436+t434)-5.18178181160915d-3*t123*t65+1.0d+0
     2           *t506+t432)+t66*(-1.8046875d-2*t124*t257*t91-3.31250000
     3           00000004d-2*t520*t68+6.796875d-3*t123*t68+t499-1.384422
     4           168217381d-2*t124*t256*t290*t498)+3.125d-2*t123*t124*t2
     5           72*t47*t91+1.5625d-2*t123*t124*t246*t47*t91-1.656250000
     6           0000002d-2*t123*t124*t271*t91-6.574218749999999d-2*t122
     7           *t124*t249*t91+1.1953125d-2*t123*t124*t244*t91-8.28125d
     8           -3*t123*t124*t204*t91-1.5625d-2*t47*(4.35d-1*t123-2.120
     9           0000000000002d+0*t520)*t68-8.673617379884035d-19*t123*t
     :           47*t68-1.5625d-2*t122*t272*t68-7.8125d-3*t122*t246*t68+
     ;           5.9765625d-3*t12*t244*t68-5.9765625d-3*t122*t126*t68+t4
     <           97
              t522 = -6.218138173930978d-2*t171*t280*t95
              t523 = 6.218138173930978d-2*t130*t172*t431
              t524 = -2.2072575680231782d-1*gammaaa*t128*t129*t174*t60*t
     1           90
              t525 = 1.0510750323919903d-2*gammaaa*t129*t176*t60*t85*t90
              t526 = 5.518143920057945d-2*t128*t174*t60*t63
              t527 = -2.6276875809799755d-3*t176*t60*t63*t85
              t528 = 5.96569710807624d-3*gammaaa*t174*t196*t58*t63
              t529 = -2.840808146702972d-4*gammaaa*t176*t58*t63*t92
              t530 = -2.5225800777407753d-1*gammaaa*t278*t63*t84*t85
              t531 = 2.5225800777407753d-1*gammaaa*t279*t60*t84*t85*t90
              t532 = 2.5225800777407753d-1*gammaaa*t129*t84*t85*t89*t90
              t533 = -6.306450194351938d-2*t63*t84*t85*t89
              t534 = -2.1622114952063787d-1*gammaaa*t279*t8*t89*t90
              t535 = -5.045160155481551d-1*gammaaa*t129*t181*t60*t84*t85
     1           *t94
              t536 = 6.306450194351938d-2*t60*t84*t85*t90*t94
              t537 = 6.817939552087132d-3*gammaaa*t58*t84*t90*t92*t94
              t538 = -2.1622114952063787d-1*gammaaa*t278*t8*t90*t94
              t539 = 4.3244229904127574d-1*gammaaa*t181*t279*t60*t8*t94
              t540 = 4.3244229904127574d-1*gammaaa*t129*t181*t8*t89*t94
              t541 = -5.405528738015947d-2*t8*t89*t90*t94
              t542 = -6.486634485619136d-1*gammaaa*t129*t182*t441*t60*t8
              t543 = 5.405528738015947d-2*t181*t182*t60*t8
              t544 = 5.843948187503255d-3*gammaaa*t128*t181*t182*t58
              t545 = 5.518143920057945d-2*t128*t174*t58
              t546 = -2.6276875809799755d-3*t176*t58*t85
              t547 = 3.00307152111997d-3*t126*t58*t8
              t548 = -2.0284046503794984d+0*t56*t82*t84*t85*t87
              t549 = -2.7960661356114797d+1*t188*t56*t8*t87
              t550 = -2.7027643690079733d-2*t190*t56*t8*t87
              t551 = 5.592132271222959d+1*t188*t192*t193*t8
              t552 = 3.97713140538416d-2*gammaaa*t174*t196*t61
              t553 = -1.1363232586811889d-3*gammaaa*t176*t61*t92
              t554 = -1.7543359407922504d+0*gammaaa*t56*t82*t84*t92*t93
              t555 = 3.627411803865852d+1*gammaaa*t128*t188*t193*t200
              t556 = t69*(3.109069086965489d-2*t83*(-1.0811057476031893d
     1           -1*gammaaa*t60*t8*t90*(-1.168789637500651d-2*gammaaa*t1
     2           28*t190*t56*t93-1.2091372679552839d+1*gammaaa*t128*t188
     3           *t56*t93+1.2986551527785004d-3*gammaaa*t126*t128*t61+t5
     4           55+t554+t553+t552+t551+t550+t549+t548+t547+t546+t545)-2
     5           .7027643690079733d-2*t202*t60*t8*t90-1.2012286084479878
     6           d-2*gammaaa*t126*t129*t60*t8*t90-1.0811057476031893d-1*
     7           gammaaa*t129*t195*t8*t90-2.9219740937516275d-3*gammaaa*
     8           t128*t202*t58*t90+3.00307152111997d-3*t126*t60*t63*t8+1
     9           .0811057476031893d-1*gammaaa*(t551+t550+t549+t548+t547+
     :           t546+t545)*t63*t8+2.7027643690079733d-2*t195*t63*t8+2.1
     ;           622114952063787d-1*gammaaa*t129*t181*t202*t60*t8+3.2466
     <           378819462516d-4*gammaaa*t126*t128*t58*t63+t544+t543+t54
     =           2+t541+t540+t539+t538+t537+t536+t535+t534+t533+t532+t53
     >           1+t530+t529+t528+t527+t526+t525+t524)-5.181781811609147
     ?           d-3*t126*t130*t83+t523+t522-3.109069086965489d-2*t130*t
     @           171*t203)
              t557 = -1.2144801120958938d-4*t113*t132*t246*t68
              t558 = -1.7305277102717265d-3*t122*t290*t291*t68
              t559 = -2.307370280362302d-3*t122*t133*t291*t68
              t560 = 8.652638551358631d-4*t133*t134*t244*t68
              t561 = 1.7894823267913484d+3*t227*t228*t229*t8
              t562 = 1.765806054418543d+0*t128*t174*t40
              t563 = -8.408600259135923d-2*t176*t40*t85
              t564 = -6.490894881214397d+1*t112*t115*t38*t84*t85
              t565 = -8.947411633956742d+2*t115*t227*t38*t8
              t566 = 1.3909060459745137d+1*t115*t226*t38*t8
              t567 = 3.461055420543453d-3*t245*t359*t47*t68
              t568 = -1.7305277102717265d-3*t245*t290*t47*t68
              t569 = 1/rhoa**7.333333333333333d+0
              t570 = 1.4465092376239355d-2*gammaaa*t362*t569
              t571 = -4.545084099430647d-2*t135*t245
              t572 = 5.340328699203314d-1*t245*t290+5.949822735525432d-2
     1           *t135*t245
              t573 = -5.537688672869524d-2*t122*t124*t296*t297*t91
              t574 = 5.976562499999999d-3*gammaaa*t122*t123*t124
              t575 = -5.9765625d-3*gammaaa*t124*t126*t244
              t576 = -1.6562500000000002d-2*t123*t124*t281*t91
              t577 = 1.2303916502879628d-3
              t578 = 1/rhoa**6.666666666666667d+0
              t579 = 2.768844336434762d-1*t124*t47*t577*t578*t91
              t580 = -5.537688672869524d-2*t124*t296*t47*t578*t91
              t581 = -1.7929687499999997d-2*gammaaa*t124*t249*t47
              t582 = -7.8125d-3*gammaaa*t124*t126*t246*t47
              t583 = 2.2601706837873992d-4*gammaaa*t362*t569*t68
              t584 = -7.101693905360386d-4*t135*t245*t68
              t585 = -8.306533009304287d-2*t124*t296*t578*t91
              t586 = -1.7305277102717265d-3*t124*t133*t578*t91
              t587 = 9.609375d-3*gammaaa*t124*t249
              t588 = 3.109069086965489d-2*t130*t252*t83
              t589 = t136*t204
              t590 = 2*t303*t96-1.1953125d-2*t68*(1.5545345434827443d-2*
     1           t113*(-2.1622114952063792d-1*gammaaa*t118*t42*t8*(-1.12
     2           27750021070412d+2*gammaaa*t112*t119*t38*t84*t92-7.27246
     3           8855559613d-2*gammaaa*t176*t43*t92+t566+t565+t564+t563+
     4           t562+t561+2.545364099445863d+0*gammaaa*t174*t196*t43-7.
     5           738478514913824d+2*gammaaa*t119*t128*t227*t38+1.2029732
     6           165432584d+1*gammaaa*t119*t128*t226*t38+2.3215435544741
     7           472d+3*gammaaa*t128*t227*t228*t237)+2.181740656667883d-
     8           1*gammaaa*t118*t120*t40*t84*t92-1.8181172138899032d-2*g
     9           ammaaa*t176*t40*t45*t92-1.0090320310963104d+0*gammaaa*t
     :           286*t45*t84*t85-1.0090320310963104d+0*t117*t45*t84*t85+
     ;           1.0090320310963104d+0*gammaaa*t118*t287*t42*t84*t85-2.0
     <           180640621926207d+0*gammaaa*t120*t131*t239*t42*t84*t85+1
     =           .0090320310963104d+0*t118*t120*t42*t84*t85+1.0090320310
     >           963104d+0*gammaaa*t117*t118*t131*t84*t85-8.408600259135
     ?           923d-2*t176*t42*t45*t85+8.408600259135923d-2*gammaaa*t1
     @           18*t131*t176*t42*t85+2.1622114952063792d-1*gammaaa*t45*
     1           (t566+t565+t564+t563+t562+t561)*t8-1.2973268971238278d+
     2           0*gammaaa*t131*t240*t42*t494*t8+2.1622114952063792d-1*t
     3           236*t45*t8+8.648845980825517d-1*gammaaa*t120*t239*t287*
     4           t42*t8+4.3244229904127585d-1*t239*t240*t42*t8+4.3244229
     5           904127585d-1*gammaaa*t131*t238*t239*t42*t8-2.1622114952
     6           063792d-1*t118*t238*t42*t8-4.3244229904127585d-1*gammaa
     7           a*t117*t118*t287*t8-4.3244229904127585d-1*gammaaa*t118*
     8           t120*t286*t8+8.648845980825517d-1*gammaaa*t117*t120*t13
     9           1*t239*t8-2.1622114952063792d-1*gammaaa*t118*t131*t236*
     :           t8-4.3244229904127585d-1*t117*t118*t120*t8+1.7658060544
     ;           18543d+0*t128*t174*t42*t45+3.818046149168795d-1*gammaaa
     <           *t174*t196*t40*t45-1.765806054418543d+0*gammaaa*t118*t1
     =           28*t131*t174*t42+9.350317100005212d-2*gammaaa*t128*t239
     >           *t240*t40-4.675158550002606d-2*gammaaa*t118*t128*t238*t
     ?           40)+3.1090690869654886d-2*t132*t243*t495-3.109069086965
     @           4886d-2*t121*t242*t288-1.5545345434827443d-2*t132*t241*
     1           t242)+t66*(-3.2303183925072226d-2*t124*t359*t578*t91-3.
     2           3125000000000004d-2*t572*t68+t587+t586+t585+t584+t583)+
     3           3.2303183925072226d-2*t124*t359*t47*t578*t91+2.390625d-
     4           2*t123*t124*t289*t91-9.290772857533589d-5*t113*t124*t13
     5           2*t249*t91-1.5625d-2*t47*(-2.1200000000000002d+0*t572+t
     6           571+t570)*t68-1.1953125d-2*t12*t289*t68+9.2907728575335
     7           88d-5*t113*t126*t132*t68+t589+t588+t582+t581+t580+t579+
     8           t576+t575+t574+t573+t568+t567+t560+t559+t558+t557+t556
              t591 = 2.0d+0*t127*t137*wght
              t592 = 2.0d+0*t125*t138*wght
              t593 = 2.0d+0*rhoa*t138*t253*wght
              t594 = 2.0d+0*rhoa*t137*t261*wght
              t595 = 1.0253906249999999d-2*t144*t257*t70*t91
              t596 = -8.203124999999999d-3*t125*t144*t249*t91
              t597 = 8.203124999999999d-3*t137*t144*t256*t257
              t598 = 2.0507812499999997d-3*t123*t13*t68*t70
              t599 = -4.1015624999999994d-3*t125*t126*t13*t68
              t600 = 4.1015624999999994d-3*t12*t13*t253*t68
              t601 = 8.203124999999999d-3*gammaaa*t123*t13*t137*t68
              t602 = -6.218138173930978d-2*t171*t319*t95
              t603 = 6.218138173930978d-2*t140*t172*t431
              t604 = -2.2072575680231782d-1*gammaaa*t128*t139*t174*t60*t
     1           90
              t605 = 1.0510750323919903d-2*gammaaa*t139*t176*t60*t85*t90
              t606 = 1.1036287840115891d-1*t128*t174*t60*t63
              t607 = -5.255375161959951d-3*t176*t60*t63*t85
              t608 = 1.1931394216152481d-2*gammaaa*t174*t196*t58*t63
              t609 = -5.681616293405944d-4*gammaaa*t176*t58*t63*t92
              t610 = -2.5225800777407753d-1*gammaaa*t317*t63*t84*t85
              t611 = 2.5225800777407753d-1*gammaaa*t318*t60*t84*t85*t90
              t612 = 2.5225800777407753d-1*gammaaa*t139*t84*t85*t89*t90
              t613 = -1.2612900388703877d-1*t63*t84*t85*t89
              t614 = -2.1622114952063787d-1*gammaaa*t318*t8*t89*t90
              t615 = -5.045160155481551d-1*gammaaa*t139*t181*t60*t84*t85
     1           *t94
              t616 = 1.2612900388703877d-1*t60*t84*t85*t90*t94
              t617 = 1.3635879104174264d-2*gammaaa*t58*t84*t90*t92*t94
              t618 = -2.1622114952063787d-1*gammaaa*t317*t8*t90*t94
              t619 = 4.3244229904127574d-1*gammaaa*t181*t318*t60*t8*t94
              t620 = 4.3244229904127574d-1*gammaaa*t139*t181*t8*t89*t94
              t621 = -1.0811057476031893d-1*t8*t89*t90*t94
              t622 = -6.486634485619136d-1*gammaaa*t139*t182*t441*t60*t8
              t623 = 1.0811057476031893d-1*t181*t182*t60*t8
              t624 = 1.168789637500651d-2*gammaaa*t128*t181*t182*t58
              t625 = 1.1036287840115891d-1*t128*t174*t58
              t626 = -5.255375161959951d-3*t176*t58*t85
              t627 = 6.00614304223994d-3*t126*t58*t8
              t628 = -4.0568093007589967d+0*t56*t82*t84*t85*t87
              t629 = -5.592132271222959d+1*t188*t56*t8*t87
              t630 = -5.405528738015947d-2*t190*t56*t8*t87
              t631 = 1.118426454244592d+2*t188*t192*t193*t8
              t632 = 7.95426281076832d-2*gammaaa*t174*t196*t61
              t633 = -2.2726465173623778d-3*gammaaa*t176*t61*t92
              t634 = -3.508671881584501d+0*gammaaa*t56*t82*t84*t92*t93
              t635 = 7.254823607731704d+1*gammaaa*t128*t188*t193*t200
              t636 = 3.461055420543453d-3*t122*t290*t291*t68
              t637 = -6.922110841086906d-3*t245*t359*t47*t68
              t638 = 3.461055420543453d-3*t245*t290*t47*t68
              t639 = -5.108140494890127d-1*t245*t290
              t640 = t639-1.451176276957421d-2*t135*t245
              t641 = 1.1075377345739049d-1*t122*t124*t296*t297*t91
              t642 = -1.6562500000000002d-2*t123*t124*t320*t91
              t643 = -5.537688672869524d-1*t124*t47*t577*t578*t91
              t644 = 1.1075377345739049d-1*t124*t296*t47*t578*t91
              t645 = -3.691792448579683d-2*t124*t359*t47*t578*t91
              t646 = 1.6613066018608574d-1*t124*t296*t578*t91
              t647 = 3.691792448579683d-2*t124*t359*t578*t91
              t648 = 2*t328*t96
              t649 = t69*(3.109069086965489d-2*t83*(-1.0811057476031893d
     1           -1*gammaaa*t60*t8*t90*(-2.337579275001302d-2*gammaaa*t1
     2           28*t190*t56*t93-2.4182745359105678d+1*gammaaa*t128*t188
     3           *t56*t93+t635+t634+t633+t632+t631+t630+t629+t628+t627+t
     4           626+t625+2.5973103055570007d-3*gammaaa*t126*t128*t61)-5
     5           .405528738015947d-2*t202*t60*t8*t90-1.2012286084479878d
     6           -2*gammaaa*t126*t139*t60*t8*t90-1.0811057476031893d-1*g
     7           ammaaa*t139*t195*t8*t90-5.843948187503255d-3*gammaaa*t1
     8           28*t202*t58*t90+1.0811057476031893d-1*gammaaa*t63*(t631
     9           +t630+t629+t628+t627+t626+t625)*t8+6.00614304223994d-3*
     :           t126*t60*t63*t8+5.405528738015947d-2*t195*t63*t8+2.1622
     ;           114952063787d-1*gammaaa*t139*t181*t202*t60*t8+6.4932757
     <           63892503d-4*gammaaa*t126*t128*t58*t63+t624+t623+t622+t6
     =           21+t620+t619+t618+t617+t616+t615+t614+t613+t612+t611+t6
     >           10+t609+t608+t607+t606+t605+t604)-5.181781811609147d-3*
     ?           t126*t140*t83+t603+t602-3.109069086965489d-2*t140*t171*
     @           t203)+t66*(-3.461055420543453d-3*t124*t133*t578*t91-3.3
     1           125000000000004d-2*t640*t68-4.5203413675747983d-4*gamma
     2           aa*t362*t569*t68+1.4203387810720772d-3*t135*t245*t68+t6
     3           47+t646+1.921875d-2*gammaaa*t124*t249)+3.10906908696548
     4           9d-2*t140*t252*t83-1.5625d-2*t47*(-2.1200000000000002d+
     5           0*t640-2.893018475247871d-2*gammaaa*t362*t569+9.0901681
     6           98861294d-2*t135*t245)*t68+1.1536851401811513d-3*t122*t
     7           133*t291*t68-1.7305277102717265d-3*t133*t134*t244*t68+t
     8           648+t645+t644+t643+t642+t641+t638+t637+t636-3.585937499
     9           9999993d-2*gammaaa*t124*t249*t47-1.5625d-2*gammaaa*t124
     :           *t126*t246*t47-1.1953125d-2*gammaaa*t124*t126*t244+t141
     ;           *t204+1.1953124999999998d-2*gammaaa*t122*t123*t124
              t650 = 2.0d+0*t127*t142*wght
              t651 = 2.0d+0*t125*t143*wght
              t652 = 2.0507812499999997d-2*t144*t257*t70*t91
              t653 = -1.6406249999999997d-2*t125*t144*t249*t91
              t654 = 8.203124999999999d-3*t142*t144*t256*t257
              t655 = 4.1015624999999994d-3*t123*t13*t68*t70
              t656 = -8.203124999999999d-3*t125*t126*t13*t68
              t657 = 8.203124999999999d-3*gammaaa*t123*t13*t142*t68
              t658 = 7.255881384787105d-3*t135*t245-2.3218820431318787d-
     1           2*t245*t290
              t659 = 2*t339*t96+t66*(-4.614740560724604d-3*t124*t359*t57
     1           8*t91-3.3125000000000004d-2*t658*t68+t587+t586+t585+t58
     2           4+t583)+4.614740560724604d-3*t124*t359*t47*t578*t91-4.6
     3           453864287667945d-4*t113*t124*t132*t249*t91-1.5625d-2*t4
     4           7*(-2.1200000000000002d+0*t658+t571+t570)*t68+1.1536851
     5           401811507d-3*t122*t133*t291*t68-9.290772857533588d-5*t1
     6           13*t126*t132*t68+t589+t588+t582+t581+t580+t579+t576+t57
     7           5+t574+t573+t568+t567+t560+t558+t557+t556
              t660 = 1.1953124999999998d-2*gammaaa*t123*t124*t47+t340+t3
     1           38+t337+t304+t298+t295+t294+t293+t292+t283+t282
              t661 = -3.00307152111997d-3*t126*t58*t8
              t662 = -2.79606613561148d+1*t188*t56*t8*t87
              t663 = -2.7027643690079733d-2*t265*t56*t8*t87
              t664 = 5.59213227122296d+1*t188*t192*t193*t8
              t665 = 2.5540702474450633d-1*t245*t290-2.0316467877403907d
     1           -2*t135*t245-2.6121172985233604d-2*t133*t245
              t666 = t339*t96+t303*t96+t69*(3.109069086965489d-2*t83*(-1
     1           .0811057476031893d-1*gammaaa*t60*t8*t90*(-1.16878963750
     2           0651d-2*gammaaa*t128*t265*t56*t93-1.209137267955284d+1*
     3           gammaaa*t128*t188*t56*t93+t664+t663+t662+t661-1.2986551
     4           52778501d-3*gammaaa*t126*t128*t61+t555+t554+t553+t552+t
     5           548+t546+t545)-2.7027643690079733d-2*t269*t60*t8*t90+1.
     6           201228608447988d-2*gammaaa*t126*t129*t60*t8*t90-1.08110
     7           57476031893d-1*gammaaa*t129*t268*t8*t90-2.9219740937516
     8           275d-3*gammaaa*t128*t269*t58*t90+1.0811057476031893d-1*
     9           gammaaa*t63*(t664+t663+t662+t661+t548+t546+t545)*t8-3.0
     :           0307152111997d-3*t126*t60*t63*t8+2.7027643690079733d-2*
     ;           t268*t63*t8+2.1622114952063787d-1*gammaaa*t129*t181*t26
     <           9*t60*t8-3.2466378819462527d-4*gammaaa*t126*t128*t58*t6
     =           3+t544+t543+t542+t541+t540+t539+t538+t537+t536+t535+t53
     >           4+t533+t532+t531+t530+t529+t528+t527+t526+t525+t524)+5.
     ?           181781811609147d-3*t126*t130*t83+t523+t522-3.1090690869
     @           65489d-2*t130*t171*t270)+t66*(-1.8458962242898416d-2*t1
     1           24*t359*t578*t91+1.7305277102717265d-3*t124*t133*t578*t
     2           91-3.3125000000000004d-2*t665*t68-2.2601706837873992d-4
     3           *gammaaa*t362*t569*t68+7.101693905360386d-4*t135*t245*t
     4           68+t585+2.8125000000000006d-3*gammaaa*t124*t249)+1.8458
     5           962242898416d-2*t124*t359*t47*t578*t91+1.1953125d-2*t12
     6           3*t124*t289*t91-2.787231857260076d-4*t113*t124*t132*t24
     7           9*t91+3.109069086965489d-2*t130*t273*t83-1.5625d-2*t47*
     8           (-2.1200000000000002d+0*t665-1.4465092376239355d-2*gamm
     9           aaa*t362*t569+4.545084099430647d-2*t135*t245)*t68-2.710
     :           505431213761d-20*t133*t245*t47*t68+5.9765625d-3*t12*t28
     ;           9*t68-1.2144801120958938d-4*t113*t132*t272*t68+t580+t57
     <           9+t576+t573+t568+t567+t559+t558-7.8125d-3*gammaaa*t124*
     =           t126*t272*t47-1.79296875d-2*gammaaa*t124*t249*t47+t136*
     >           t271+1.79296875d-2*gammaaa*t122*t123*t124
              t667 = 5.46875d-3*t660*t71+t313+t312+t311+t310
              t668 = 2.3906249999999996d-2*gammaaa*t123*t124*t47+t330+t3
     1           29+t327+t326+t325+t324+t323+t322+t321
              t669 = -6.00614304223994d-3*t126*t58*t8
              t670 = -5.59213227122296d+1*t188*t56*t8*t87
              t671 = -5.405528738015947d-2*t265*t56*t8*t87
              t672 = 1.1184264542445921d+2*t188*t192*t193*t8
              t673 = t639+1.451176276957421d-2*t135*t245
              t674 = t69*(3.109069086965489d-2*t83*(-1.0811057476031893d
     1           -1*gammaaa*t60*t8*t90*(-2.337579275001302d-2*gammaaa*t1
     2           28*t265*t56*t93-2.418274535910568d+1*gammaaa*t128*t188*
     3           t56*t93+t672+t671+t670+t669+t635+t634+t633+t632+t628+t6
     4           26+t625-2.597310305557002d-3*gammaaa*t126*t128*t61)-5.4
     5           05528738015947d-2*t269*t60*t8*t90+1.201228608447988d-2*
     6           gammaaa*t126*t139*t60*t8*t90-1.0811057476031893d-1*gamm
     7           aaa*t139*t268*t8*t90-5.843948187503255d-3*gammaaa*t128*
     8           t269*t58*t90+1.0811057476031893d-1*gammaaa*t63*(t672+t6
     9           71+t670+t669+t628+t626+t625)*t8-6.00614304223994d-3*t12
     :           6*t60*t63*t8+5.405528738015947d-2*t268*t63*t8+2.1622114
     ;           952063787d-1*gammaaa*t139*t181*t269*t60*t8-6.4932757638
     <           92505d-4*gammaaa*t126*t128*t58*t63+t624+t623+t622+t621+
     =           t620+t619+t618+t617+t616+t615+t614+t613+t612+t611+t610+
     >           t609+t608+t607+t606+t605+t604)+5.181781811609147d-3*t12
     ?           6*t140*t83+t603+t602-3.109069086965489d-2*t140*t171*t27
     @           0)+t66*(3.461055420543453d-3*t124*t133*t578*t91-3.31250
     1           00000000004d-2*t673*t68+4.5203413675747983d-4*gammaaa*t
     2           362*t569*t68-1.4203387810720772d-3*t135*t245*t68+t647+t
     3           646+5.625000000000001d-3*gammaaa*t124*t249)+3.109069086
     4           965489d-2*t140*t273*t83-1.5625d-2*t47*(-2.1200000000000
     5           002d+0*t673+2.893018475247871d-2*gammaaa*t362*t569-9.09
     6           0168198861294d-2*t135*t245)*t68+4.614740560724604d-3*t1
     7           22*t133*t291*t68+t648+t645+t644+t643+t642+t641+t638+t63
     8           7+t636-1.5625d-2*gammaaa*t124*t126*t272*t47-3.5859375d-
     9           2*gammaaa*t124*t249*t47+t141*t271+3.5859375d-2*gammaaa*
     :           t122*t123*t124
              t675 = 5.46875d-3*t668*t71+t335+t334+t333+t332
              t676 = 1.0d+0*t367*t72*wght
              t677 = 6.306450194351938d-2*t129*t60*t84*t85*t90
              t678 = 6.817939552087132d-3*gammaaa*t129*t58*t84*t90*t92
              t679 = 5.405528738015947d-2*t278*t63*t8
              t680 = -5.405528738015947d-2*t279*t60*t8*t90
              t681 = -5.843948187503255d-3*gammaaa*t128*t279*t58*t90
              t682 = -5.405528738015947d-2*t129*t8*t89*t90
              t683 = 1.0811057476031893d-1*t129*t181*t60*t8*t94
              t684 = 1.168789637500651d-2*gammaaa*t128*t129*t181*t58*t94
              t685 = t69*(6.218138173930978d-2*t343*t431*t95-3.109069086
     1           965489d-2*t171*t348*t95+3.109069086965489d-2*t83*(-1.46
     2           09870468758138d-3*t128*t58*t90*t94-6.486634485619136d-1
     3           *gammaaa*t345*t441*t60*t8*t94+3.1589629871025054d-4*gam
     4           maaa*t181*t196*t60*t61*t94-1.0811057476031893d-1*gammaa
     5           a*t60*t8*t90*(9.398228254244201d-2*t128*t56*t82*t93-3.4
     6           08969776043565d-3*t61*t84*t92)-1.704484888021783d-3*t58
     7           *t63*t84*t92-1.5794814935512527d-4*gammaaa*t196*t61*t89
     8           *t90+1.8427284091431279d-4*gammaaa*t462*t60*t61*t84*t90
     9           -2.1622114952063787d-1*gammaaa*t129*t278*t8*t90+2.16221
     :           14952063787d-1*gammaaa*t181*t345*t8*t89-2.5225800777407
     ;           753d-1*gammaaa*t181*t345*t60*t84*t85+4.3244229904127574
     <           d-1*gammaaa*t129*t181*t279*t60*t8+t684+t683+t682+t681+t
     =           680+t679+t678+t677)-6.218138173930978d-2*t130*t171*t280
     >           )
              t686 = -2.6901651040714963d-5*t113*t132*t290*t291*t68
              t687 = -1.1300853418936997d-4*t122*t354*t355*t68
              t688 = 6.200785359250782d-3
              t689 = 1/rhoa**6.333333333333333d+0
              t690 = 2.2601706837873994d-4*t47*t68*t688*t689
              t691 = -1.8581545715067177d-4*t123*t124*t242*t350*t91
              t692 = 1.8581545715067177d-4*t113*t123*t124*t352*t91
              t693 = -8.608528333028789d-4*t113*t124*t132*t296*t297*t91
              t694 = 6.922110841086906d-3*gammaaa*t122*t124*t245*t300
              t695 = 1.7305277102717265d-3*gammaaa*t122*t124*t245*t359
              t696 = -1.494140625d-3*t122*t124*t126
              t697 = -1.1953125d-2*gammaaa*t124*t126*t289
              t698 = 2.5746978376432955d-4*t123*t124*t171*t343*t91
              t699 = -2.5746978376432955d-4*t123*t124*t348*t83*t91
              t700 = 3.875490849531738d-4
              t701 = 1/rhoa**8.333333333333334d+0
              t702 = 7.232546188119678d-3*t124*t47*t700*t701*t91
              t703 = -6.922110841086905d-2*gammaaa*t124*t296*t297*t47
              t704 = 6.922110841086906d-3*gammaaa*t124*t297*t300*t47
              t705 = -3.461055420543453d-3*gammaaa*t124*t297*t363*t47
              t706 = -4.0378979906340284d-3*gammaaa*t124*t290*t297*t47
              t707 = 2.9882812499999994d-3*t123*t124*t47
              t708 = 7.75098169906347d-4
              t709 = -3.616273094059839d-3*t124*t701*t708*t91
              t710 = 2.768844336434762d-2*gammaaa*t124*t297*t300
              t711 = 4.0378979906340284d-3*gammaaa*t124*t290*t297
              t712 = -1.03515625d-3*t123*t124
              t713 = t364*t96
              t714 = 2*t136*t281
              t715 = -1.1953125d-2*t68*(1.5545345434827443d-2*t113*(-2.1
     1           622114952063792d-1*gammaaa*t118*t42*t8*(1.2029732165432
     2           584d+1*t112*t119*t128*t38-4.363481313335766d-1*t43*t84*
     3           t92)-2.181740656667883d-1*t40*t45*t84*t92+2.18174065666
     4           7883d-1*gammaaa*t118*t131*t40*t84*t92-1.009032031096310
     5           4d+0*gammaaa*t239*t351*t42*t84*t85+1.0090320310963104d+
     6           0*t118*t131*t42*t84*t85+4.7173847274064107d-2*gammaaa*t
     7           118*t42*t43*t462*t84-1.2973268971238278d+0*gammaaa*t120
     8           *t351*t42*t494*t8+4.3244229904127585d-1*t286*t45*t8+8.6
     9           48845980825517d-1*gammaaa*t131*t239*t287*t42*t8-4.32442
     :           29904127585d-1*t118*t287*t42*t8+8.648845980825517d-1*t1
     ;           20*t131*t239*t42*t8+4.3244229904127585d-1*gammaaa*t117*
     <           t239*t351*t8-4.3244229904127585d-1*gammaaa*t118*t131*t2
     =           86*t8-4.3244229904127585d-1*t117*t118*t131*t8+4.0434726
     >           234912094d-2*gammaaa*t120*t196*t239*t42*t43-2.021736311
     ?           7456047d-2*gammaaa*t117*t118*t196*t43-9.350317100005212
     @           d-2*gammaaa*t118*t128*t287*t40+1.8700634200010424d-1*ga
     1           mmaaa*t120*t128*t131*t239*t40-9.350317100005212d-2*t118
     2           *t120*t128*t40)+3.1090690869654886d-2*t121*t350*t495-1.
     3           5545345434827443d-2*t121*t242*t352-3.1090690869654886d-
     4           2*t132*t242*t288)+6.218138173930978d-2*t130*t303*t83+t7
     5           14+t713+t66*(t712+t711+t710+t709-1.0547463191007862d-3*
     6           t354*t68*t689+8.075795981268057d-3*gammaaa*t124*t297*t3
     7           59)+t707+t706+t705+t704+t703+t702+t699+t698+t697+t696+t
     8           695+t694+t693+t692+t691+t690+9.417377849114162d-4*t354*
     9           t47*t68*t689+t687+t686+t685-9.290772857533588d-5*t113*t
     :           12*t352*t68+9.290772857533588d-5*t12*t242*t350*t68-3.58
     ;           6886805428662d-5*t113*t132*t133*t291*t68+1.730527710271
     <           7265d-3*t133*t134*t289*t68-6.34526827099633d-3*gammaaa*
     =           t124*t297*t359*t47+9.290772857533588d-5*gammaaa*t113*t1
     >           23*t124*t132
              t716 = 2.0d+0*rhoa*t127*t367*wght
              t717 = 2.0d+0*t137*t138*wght
              t718 = -3.0761718749999994d-3*gammaaa*t144*t249*t70
              t719 = 2.0507812499999997d-3*gammaaa*t123*t125*t144
              t720 = -8.203124999999999d-3*t137*t144*t249*t91
              t721 = -8.203124999999999d-3*gammaaa*t126*t13*t367*t68
              t722 = 8.203124999999999d-3*t12*t13*t305*t68
              t723 = -4.1015624999999994d-3*t126*t13*t137*t68
              t724 = 1.0d+0*t371*t70*wght
              t725 = 2.0d+0*rhoa*t125*t371*wght
              t726 = t69*(6.218138173930978d-2*t130*t140*t431*t95-3.1090
     1           69086965489d-2*t171*t372*t95+3.109069086965489d-2*t83*(
     2           -2.9219740937516275d-3*t128*t58*t90*t94-6.4866344856191
     3           36d-1*gammaaa*t129*t139*t441*t60*t8*t94+5.4055287380159
     4           47d-2*t139*t181*t60*t8*t94+6.317925974205011d-4*gammaaa
     5           *t181*t196*t60*t61*t94+5.843948187503255d-3*gammaaa*t12
     6           8*t139*t181*t58*t94-1.0811057476031893d-1*gammaaa*t60*t
     7           8*t90*(1.8796456508488402d-1*t128*t56*t82*t93-6.8179395
     8           5208713d-3*t61*t84*t92)+3.408969776043566d-3*gammaaa*t1
     9           39*t58*t84*t90*t92-3.408969776043566d-3*t58*t63*t84*t92
     :           -2.7027643690079733d-2*t139*t8*t89*t90-3.15896298710250
     ;           54d-4*gammaaa*t196*t61*t89*t90+3.153225097175969d-2*t13
     <           9*t60*t84*t85*t90+3.6854568182862557d-4*gammaaa*t462*t6
     =           0*t61*t84*t90-2.7027643690079733d-2*t318*t60*t8*t90-1.0
     >           811057476031893d-1*gammaaa*t129*t317*t8*t90-1.081105747
     ?           6031893d-1*gammaaa*t139*t278*t8*t90-2.9219740937516275d
     @           -3*gammaaa*t128*t318*t58*t90+2.1622114952063787d-1*gamm
     1           aaa*t129*t139*t181*t8*t89-2.5225800777407753d-1*gammaaa
     2           *t129*t139*t181*t60*t84*t85+2.7027643690079733d-2*t317*
     3           t63*t8+2.1622114952063787d-1*gammaaa*t129*t181*t318*t60
     4           *t8+2.1622114952063787d-1*gammaaa*t139*t181*t279*t60*t8
     5           +t684+t683+t682+t681+t680+t679+t678+t677)-3.10906908696
     6           5489d-2*t130*t171*t319-3.109069086965489d-2*t140*t171*t
     7           280)
              t727 = 2.6901651040714963d-5*t113*t132*t290*t291*t68
              t728 = 2.2601706837873994d-4*t122*t354*t355*t68
              t729 = -4.520341367574799d-4*t47*t68*t688*t689
              t730 = 8.608528333028789d-4*t113*t124*t132*t296*t297*t91
              t731 = -2.98828125d-3*t122*t124*t126
              t732 = -2.5746978376432955d-4*t123*t124*t372*t83*t91
              t733 = 2.5746978376432955d-4*t123*t124*t130*t140*t171*t91
              t734 = -1.4465092376239355d-2*t124*t47*t700*t701*t91
              t735 = 5.976562499999999d-3*t123*t124*t47
              t736 = 7.232546188119678d-3*t124*t701*t708*t91
              t737 = -2.0703125d-3*t123*t124
              t738 = 3.109069086965489d-2*t130*t328*t83
              t739 = t136*t320
              t740 = t141*t281
              t741 = t380*t96+3.109069086965489d-2*t140*t303*t83+t740+t7
     1           39+t738+t66*(t737+t736+1.6574585014440926d-3*t354*t68*t
     2           689-9.229481121449208d-3*gammaaa*t124*t297*t359+8.07579
     3           5981268057d-3*gammaaa*t124*t290*t297)+t735+t734+t733+t7
     4           32+t731+t730+t729+t728+t727+t726+t697-1.431441433065352
     5           4d-3*t354*t47*t68*t689+8.967217013571658d-6*t113*t132*t
     6           133*t291*t68-1.7305277102717265d-3*t133*t134*t289*t68-6
     7           .922110841086906d-3*gammaaa*t124*t297*t363*t47+1.269053
     8           654199266d-2*gammaaa*t124*t297*t359*t47-1.3844221682173
     9           81d-2*gammaaa*t124*t297*t300*t47+2.7688443364347626d-2*
     :           gammaaa*t124*t296*t297*t47-8.075795981268057d-3*gammaaa
     ;           *t124*t290*t297*t47+3.461055420543453d-3*gammaaa*t122*t
     <           124*t245*t359-1.384422168217381d-2*gammaaa*t122*t124*t2
     =           45*t300+9.290772857533587d-5*gammaaa*t113*t123*t124*t13
     >           2
              t742 = 2.0d+0*rhoa*t138*t331*wght
              t743 = 1.0d+0*t138*t142*wght
              t744 = 1.0d+0*t137*t143*wght
              t745 = -6.152343749999999d-3*gammaaa*t144*t249*t70
              t746 = 4.1015624999999994d-3*gammaaa*t123*t125*t144
              t747 = -4.1015624999999994d-3*t142*t144*t249*t91
              t748 = 4.1015624999999994d-3*t12*t13*t331*t68
              t749 = -2.0507812499999997d-3*t126*t13*t142*t68
              t750 = 2.0d+0*rhoa*t137*t336*wght
              t751 = 5.768425700905754d-4*gammaaa*t124*t297*t359*t47
              t752 = 1.153685140181151d-3*gammaaa*t124*t297*t359
              t753 = 3.109069086965489d-2*t130*t339*t83+3.10906908696548
     1           9d-2*t130*t303*t83+t66*(t752+t712+t711+t710+t709-6.0271
     2           21823433064d-4*t354*t68*t689)+t751+t714+t713+t707+t706+
     3           t705+t704+t702+t699+t698+t696+t695+t694+t693+t690+4.897
     4           036481539364d-4*t354*t47*t68*t689+t687+t686+t685-2.2418
     5           04253392914d-5*t113*t132*t133*t291*t68+8.65263855135863
     6           1d-4*t133*t134*t289*t68-6.922110841086906d-2*gammaaa*t1
     7           24*t296*t297*t47-5.9765625d-3*gammaaa*t124*t126*t289+1.
     8           8581545715067174d-4*gammaaa*t113*t123*t124*t132
              t754 = t392*t96+t69*(6.218138173930978d-2*t389*t431*t95-3.
     1           109069086965489d-2*t171*t391*t95+3.109069086965489d-2*t
     2           83*(-5.843948187503255d-3*t128*t58*t90*t94-6.4866344856
     3           19136d-1*gammaaa*t390*t441*t60*t8*t94+2.162211495206378
     4           7d-1*t139*t181*t60*t8*t94+1.2635851948410023d-3*gammaaa
     5           *t181*t196*t60*t61*t94+2.337579275001302d-2*gammaaa*t12
     6           8*t139*t181*t58*t94-1.0811057476031893d-1*gammaaa*t60*t
     7           8*t90*(3.7592913016976803d-1*t128*t56*t82*t93-1.3635879
     8           10417426d-2*t61*t84*t92)+1.3635879104174264d-2*gammaaa*
     9           t139*t58*t84*t90*t92-6.817939552087132d-3*t58*t63*t84*t
     :           92-1.0811057476031893d-1*t139*t8*t89*t90-6.317925974205
     ;           011d-4*gammaaa*t196*t61*t89*t90+1.2612900388703877d-1*t
     <           139*t60*t84*t85*t90+7.370913636572511d-4*gammaaa*t462*t
     =           60*t61*t84*t90-1.0811057476031893d-1*t318*t60*t8*t90-2.
     >           1622114952063787d-1*gammaaa*t139*t317*t8*t90-1.16878963
     ?           7500651d-2*gammaaa*t128*t318*t58*t90+2.1622114952063787
     @           d-1*gammaaa*t181*t390*t8*t89-2.5225800777407753d-1*gamm
     1           aaa*t181*t390*t60*t84*t85+1.0811057476031893d-1*t317*t6
     2           3*t8+4.3244229904127574d-1*gammaaa*t139*t181*t318*t60*t
     3           8)-6.218138173930978d-2*t140*t171*t319)+t66*(-1.4465092
     4           376239355d-2*t124*t701*t708*t91-2.4108487293732256d-3*t
     5           354*t68*t689-1.8458962242898416d-2*gammaaa*t124*t297*t3
     6           59-1.1075377345739049d-1*gammaaa*t124*t297*t300-9.22948
     7           1121449208d-3*gammaaa*t124*t290*t297-4.140625d-3*t123*t
     8           124)-2.5746978376432955d-4*t123*t124*t391*t83*t91+2.893
     9           018475247871d-2*t124*t47*t700*t701*t91+2.57469783764329
     :           55d-4*t123*t124*t171*t389*t91+6.218138173930978d-2*t140
     ;           *t328*t83+9.040682735149598d-4*t47*t68*t688*t689+1.9588
     <           145926157458d-3*t354*t47*t68*t689-4.520341367574799d-4*
     =           t122*t354*t355*t68+1.384422168217381d-2*gammaaa*t124*t2
     >           97*t363*t47+1.153685140181151d-2*gammaaa*t124*t297*t359
     ?           *t47-2.768844336434762d-2*gammaaa*t124*t297*t300*t47+2.
     @           768844336434762d-1*gammaaa*t124*t296*t297*t47+9.2294811
     1           21449208d-3*gammaaa*t124*t290*t297*t47+1.19531249999999
     2           98d-2*t123*t124*t47-6.922110841086906d-3*gammaaa*t122*t
     3           124*t245*t359+2*t141*t320-2.768844336434762d-2*gammaaa*
     4           t122*t124*t245*t300-5.9765625d-3*t122*t124*t126
              t755 = t379+t378-1.384422168217381d-2*gammaaa*t124*t245*t3
     1           63+3.461055420543453d-3*gammaaa*t124*t245*t290
              t756 = t66*t755-6.922110841086906d-3*gammaaa*t124*t245*t35
     1           9*t47+2.768844336434762d-2*gammaaa*t124*t245*t300*t47+t
     2           382+t381+t377+t376+t375+t374+t373+t357
              t757 = t755*t96+3.109069086965489d-2*t140*t339*t83+t740+t7
     1           39+t738+t66*(t737+t736+7.53390227929133d-4*t354*t68*t68
     2           9+2.307370280362302d-3*gammaaa*t124*t297*t359-4.6147405
     3           60724604d-3*gammaaa*t124*t290*t297)+t735+t734+t733+t732
     4           +t731+t730+t729+t728+t727+t726-5.27373159550393d-4*t354
     5           *t47*t68*t689+3.5868868054286623d-5*t113*t132*t133*t291
     6           *t68+6.922110841086906d-3*gammaaa*t124*t297*t363*t47-5.
     7           768425700905754d-3*gammaaa*t124*t297*t359*t47+1.3844221
     8           68217381d-2*gammaaa*t124*t297*t300*t47-2.76884433643476
     9           26d-2*gammaaa*t124*t296*t297*t47+4.614740560724604d-3*g
     :           ammaaa*t124*t290*t297*t47-3.461055420543453d-3*gammaaa*
     ;           t122*t124*t245*t359+1.384422168217381d-2*gammaaa*t122*t
     <           124*t245*t300+2.787231857260077d-4*gammaaa*t113*t123*t1
     =           24*t132
              t758 = 8.203124999999999d-3*t12*t13*t341*t68
              t759 = 5.46875d-3*t71*t756+t385+t384+t370
              t760 = 6.218138173930978d-2*t130*t339*t83+t66*(t752+t712+t
     1           710+t709-1.506780455858266d-4*t354*t68*t689+5.768425700
     2           905755d-4*gammaaa*t124*t290*t297)+t751+t714+t713+t707+t
     3           705+t704+t703+t702+t699+t698+t696+t695+t694+t693+t692+t
     4           691+t690+3.766951139645663d-5*t354*t47*t68*t689+t687+t6
     5           86+t685+9.290772857533588d-5*t113*t12*t352*t68-9.290772
     6           857533588d-5*t12*t242*t350*t68-8.967217013571656d-6*t11
     7           3*t132*t133*t291*t68-5.768425700905755d-4*gammaaa*t124*
     8           t290*t297*t47+2.787231857260076d-4*gammaaa*t113*t123*t1
     9           24*t132
              t761 = 6.218138173930978d-2*t130**3*t431*t69
              t762 = 1/t7**8.0d+0
              t763 = 3.109069086965489d-2*t69*t83*(-1.2806898906833467d-
     1           5*gammaaa*t762*t90*t93-1.1846111201634398d-4*t196*t60*t
     2           61*t90-4.3829611406274405d-3*t128*t129*t58*t90-6.486634
     3           485619136d-1*gammaaa*t129**3*t441*t60*t8+1.621658621404
     4           784d-1*t181*t345*t60*t8+9.476888961307518d-4*gammaaa*t1
     5           29*t181*t196*t60*t61+1.7531844562509763d-2*gammaaa*t128
     6           *t181*t345*t58)
              t764 = -9.327207260896466d-2*t130*t171*t348*t69
              t765 = 1/rhoa**8
              t766 = 6.918551883675513d-8*t47*t68*t765
              t767 = 4.3042641665143944d-4*gammaaa*t113*t124*t132*t245*t
     1           300
              t768 = 5.380330208142993d-5*gammaaa*t113*t124*t132*t245*t3
     1           59
              t769 = -3.616273094059839d-3*gammaaa*t124*t47*t569*t708
              t770 = 3.1003926796253883d-3
              t771 = -4.520341367574799d-4*gammaaa*t124*t47*t569*t770
              t772 = 1.0383166261630358d-2*t124*t245*t300*t47
              t773 = 1.5501963398126942d-3
              t774 = t66*(1.8081365470299196d-3*gammaaa*t124*t569*t773-6
     1           .918551883675513d-8*t68*t765+2.2601706837873994d-4*gamm
     2           aaa*t124*t569*t688-5.191583130815179d-3*t124*t245*t363)
              t775 = 9.327207260896466d-2*t130*t364*t83
              t776 = -9.327207260896466d-2*t136*t171*t343
              t777 = 9.327207260896466d-2*t136*t348*t83
              t778 = -1.8581545715067177d-4*t113*t68*(-1.297326897123827
     1           8d+0*gammaaa*t131**3*t42*t494*t8+1.2973268971238278d+0*
     2           t239*t351*t42*t8-1.3114264480597482d-2*gammaaa*t118*t11
     3           9*t762+1.2130417870473628d-1*gammaaa*t131*t196*t239*t42
     4           *t43-6.065208935236814d-2*t118*t196*t42*t43+2.805095130
     5           0015636d-1*gammaaa*t128*t239*t351*t40-2.805095130001563
     6           6d-1*t118*t128*t131*t40)+t777+t776+t775+t774+t772+t771+
     7           t769+t768+t767+t766+t764+t763+t761-3.7163091430134354d-
     8           4*t132**3*t495*t68-5.27027010317179d-6*t113*t132*t354*t
     9           355*t68+5.574463714520154d-4*t132*t242*t352*t68+4.03524
     :           7656107245d-5*t113*t133*t134*t352*t68-4.035247656107245
     ;           d-5*t133*t134*t242*t350*t68-2.787231857260076d-4*gammaa
     <           a*t113*t124*t126*t352+2.787231857260076d-4*gammaaa*t124
     =           *t126*t242*t350-6.968079643150192d-5*t113*t124*t126*t13
     >           2
              t779 = 5.126953124999999d-4*t123*t144*t70
              t780 = 6.152343749999999d-3*gammaaa*t123*t137*t144
              t781 = 1.2635851948410023d-3*gammaaa*t129*t181*t196*t60*t6
     1           1
              t782 = -5.843948187503255d-3*t128*t129*t58*t90
              t783 = 3.109069086965489d-2*t69*t83*(-2.5613797813666933d-
     1           5*gammaaa*t762*t90*t93-2.3692222403268795d-4*t196*t60*t
     2           61*t90-1.4609870468758138d-3*t128*t139*t58*t90-6.486634
     3           485619136d-1*gammaaa*t139*t345*t441*t60*t8+1.0811057476
     4           031893d-1*t181*t345*t60*t8+1.0811057476031893d-1*t129*t
     5           139*t181*t60*t8+t782+t781+3.1589629871025054d-4*gammaaa
     6           *t139*t181*t196*t60*t61+1.168789637500651d-2*gammaaa*t1
     7           28*t181*t345*t58+1.168789637500651d-2*gammaaa*t128*t129
     8           *t139*t181*t58)
              t784 = -6.218138173930978d-2*t130*t171*t372*t69
              t785 = 6.218138173930978d-2*t140*t343*t431*t69
              t786 = -3.109069086965489d-2*t140*t171*t348*t69
              t787 = 7.027026804229052d-6*t113*t132*t354*t355*t68
              t788 = -1.3837103767351028d-7*t47*t68*t765
              t789 = -4.3042641665143944d-4*gammaaa*t113*t124*t132*t245*
     1           t300
              t790 = -9.290772857533588d-5*t113*t124*t126*t132
              t791 = 6.922110841086906d-3*t124*t245*t300*t47
              t792 = 1.3837103767351028d-7*t68*t765
              t793 = -3.461055420543453d-3*t124*t245*t363
              t794 = 3.109069086965489d-2*t140*t364*t83
              t795 = 6.218138173930978d-2*t136*t372*t83
              t796 = -6.218138173930978d-2*t130*t136*t140*t171
              t797 = -3.109069086965489d-2*t141*t171*t343
              t798 = 3.109069086965489d-2*t141*t348*t83
              t799 = 6.218138173930978d-2*t130*t380*t83+t798+t797+t796+t
     1           795+t794+t66*(t793+t792-3.616273094059839d-3*gammaaa*t1
     2           24*t569*t773+4.520341367574799d-4*gammaaa*t124*t569*t68
     3           8)+t791+t790+t789+t788+t787+t786+t785+t784+t783-9.04068
     4           2735149598d-4*gammaaa*t124*t47*t569*t770+7.232546188119
     5           678d-3*gammaaa*t124*t47*t569*t708-2.6901651040714963d-5
     6           *t113*t133*t134*t352*t68+2.6901651040714963d-5*t133*t13
     7           4*t242*t350*t68+1.0760660416285986d-4*gammaaa*t113*t124
     8           *t132*t245*t359-1.8581545715067177d-4*gammaaa*t113*t124
     9           *t126*t352+1.8581545715067177d-4*gammaaa*t124*t126*t242
     :           *t350
              t800 = 1.0253906249999999d-3*t123*t144*t70
              t801 = 8.203124999999999d-3*gammaaa*t123*t137*t144
              t802 = 2.0507812499999997d-3*gammaaa*t123*t142*t144
              t803 = t777+t776+t775+t774+t772+t771+t769+t768+t767+t766+t
     1           764+t763+t761-5.270270103171789d-6*t113*t132*t354*t355*
     2           t68+1.3450825520357482d-5*t113*t133*t134*t352*t68-1.345
     3           0825520357482d-5*t133*t134*t242*t350*t68-9.290772857533
     4           588d-5*gammaaa*t113*t124*t126*t352+9.290772857533588d-5
     5           *gammaaa*t124*t126*t242*t350-6.968079643150191d-5*t113*
     6           t124*t126*t132
              t804 = 8.203124999999999d-3*t12*t13*t387*t68
              t805 = 3.109069086965489d-2*t69*t83*(-5.122759562733387d-5
     1           *gammaaa*t762*t90*t93-4.738444480653759d-4*t196*t60*t61
     2           *t90-5.843948187503255d-3*t128*t139*t58*t90-6.486634485
     3           619136d-1*gammaaa*t129*t390*t441*t60*t8+5.4055287380159
     4           47d-2*t181*t390*t60*t8+2.1622114952063787d-1*t129*t139*
     5           t181*t60*t8+t782+t781+1.2635851948410023d-3*gammaaa*t13
     6           9*t181*t196*t60*t61+5.843948187503255d-3*gammaaa*t128*t
     7           181*t390*t58+2.337579275001302d-2*gammaaa*t128*t129*t13
     8           9*t181*t58)+3.109069086965489d-2*t130*t392*t83+3.109069
     9           086965489d-2*t136*t391*t83+6.218138173930978d-2*t140*t3
     :           80*t83+6.218138173930978d-2*t141*t372*t83+t790+t789+1.8
     ;           081365470299196d-3*gammaaa*t124*t47*t569*t770+t66*(-2.7
     <           674207534702056d-7*t68*t765-9.040682735149598d-4*gammaa
     =           a*t124*t569*t688+6.922110841086906d-3*t124*t245*t363)+2
     >           .7674207534702056d-7*t47*t68*t765+6.218138173930978d-2*
     ?           t130*t389*t431*t69-3.109069086965489d-2*t130*t171*t391*
     @           t69-6.218138173930978d-2*t140*t171*t372*t69-7.027026804
     1           229052d-6*t113*t132*t354*t355*t68-1.3844221682173813d-2
     2           *t124*t245*t300*t47-3.109069086965489d-2*t136*t171*t389
     3           -1.0760660416285986d-4*gammaaa*t113*t124*t132*t245*t359
     4           -6.218138173930978d-2*t130*t140*t141*t171
              t806 = 3.109069086965489d-2*t130*t755*t83+3.10906908696548
     1           9d-2*t130*t380*t83+t798+t797+t796+t795+t794+t66*(t793+t
     2           792-4.520341367574799d-4*gammaaa*t124*t569*t688)+t791+t
     3           790+t788+t787+t786+t785+t784+t783+9.040682735149598d-4*
     4           gammaaa*t124*t47*t569*t770-5.380330208142993d-5*gammaaa
     5           *t113*t124*t132*t245*t359+2.1521320832571972d-4*gammaaa
     6           *t113*t124*t132*t245*t300
              t807 = 3.109069086965489d-2*t69*t83*(-1.0245519125466773d-
     1           4*gammaaa*t762*t90*t93-9.476888961307518d-4*t196*t60*t6
     2           1*t90-1.7531844562509763d-2*t128*t139*t58*t90-6.4866344
     3           85619136d-1*gammaaa*t139**3*t441*t60*t8+3.2433172428095
     4           68d-1*t181*t390*t60*t8+3.7907555845230073d-3*gammaaa*t1
     5           39*t181*t196*t60*t61+3.5063689125019526d-2*gammaaa*t128
     6           *t181*t390*t58)+9.327207260896466d-2*t140*t392*t83+9.32
     7           7207260896466d-2*t141*t391*t83+t66*(1.4465092376239355d
     8           -2*gammaaa*t124*t569*t773+5.534841506940411d-7*t68*t765
     9           +1.8081365470299196d-3*gammaaa*t124*t569*t688+4.1532665
     :           046521433d-2*t124*t245*t363)-3.616273094059839d-3*gamma
     ;           aa*t124*t47*t569*t770-5.534841506940411d-7*t47*t68*t765
     <           -2.893018475247871d-2*gammaaa*t124*t47*t569*t708+6.2181
     =           38173930978d-2*t140**3*t431*t69-9.327207260896466d-2*t1
     >           40*t171*t391*t69-8.306533009304287d-2*t124*t245*t300*t4
     ?           7-9.327207260896466d-2*t141*t171*t389
              t808 = 1.6562500000000002d-2*t123*t144*t91*t96
              t809 = t66*(6.922110841086906d-3*t144*t256*t290*t578-1.921
     1           875d-2*t144*t249*t91)+3.5859374999999993d-2*t144*t249*t
     2           47*t91+1.5625d-2*t126*t144*t246*t47*t91+1.1953125d-2*t1
     3           26*t144*t244*t91-8.28125d-3*t126*t144*t204*t91-1.195312
     4           4999999998d-2*t122*t123*t144*t91+t808
              t810 = 2.0d+0*t125*t146*wght
              t811 = 2.0d+0*t127*t145*wght
              t812 = -2.0507812499999997d-2*t256*t257*t399*t70
              t813 = 1.6406249999999997d-2*t125*t249*t256*t399
              t814 = 8.203124999999999d-3*t144*t145*t256*t257
              t815 = -4.1015624999999994d-3*gammaaa*t123*t124*t68*t70
              t816 = 8.203124999999999d-3*gammaaa*t124*t125*t126*t68
              t817 = 8.203124999999999d-3*gammaaa*t123*t13*t145*t68
              t818 = 2.0d+0*rhoa*t70*(t817+t816+t815+t814+t813+t812+5.46
     1           875d-3*t71*t809-1.6406249999999997d-2*gammaaa*t126*t13*
     2           t398*t68-8.203124999999999d-3*gammaaa*t12*t124*t253*t68
     3           )*wght+2.0d+0*rhoa*t72*t809*wght+2.0d+0*t398*t72*wght+2
     4           .0d+0*t404*t70*wght+4.0d+0*rhoa*t125*t404*wght+4.0d+0*r
     5           hoa*t127*t398*wght+2.0d+0*rhoa*t145*t261*wght+2.0d+0*rh
     6           oa*t146*t253*wght+t811+t810
              t819 = -2.3906249999999996d-2*t123*t144*t47*t91+t397+t396+
     1           t395
              t820 = t66*(-5.625000000000001d-3*t144*t249*t91-6.92211084
     1           1086906d-3*t144*t256*t290*t578)+1.5625d-2*t126*t144*t27
     2           2*t47*t91+3.5859375d-2*t144*t249*t47*t91-8.28125d-3*t12
     3           6*t144*t271*t91-3.5859375d-2*t122*t123*t144*t91+t808
              t821 = 5.46875d-3*t71*t819+t403+t402+t401+t400
              t822 = -6.922110841086906d-3*t122*t144*t245*t363*t91
              t823 = 5.9765625d-3*gammaaa*t122*t126*t144
              t824 = 2.5746978376432955d-4*t123*t130*t144*t83*t91
              t825 = -8.28125d-3*t126*t144*t281*t91
              t826 = 1.1075377345739049d-1*t144*t297*t47*t577*t91
              t827 = 1.384422168217381d-2*t144*t297*t300*t47*t91
              t828 = -6.922110841086906d-3*t144*t297*t363*t47*t91
              t829 = -1.1953124999999998d-2*gammaaa*t123*t144*t47
              t830 = -5.537688672869524d-2*t144*t296*t297*t91
              t831 = 4.140625d-3*gammaaa*t123*t144
              t832 = t406*t96
              t833 = t66*(-1.6151591962536113d-2*t144*t297*t359*t91+t831
     1           +t830)+1.6151591962536113d-2*t144*t297*t359*t47*t91+1.1
     2           953125d-2*t126*t144*t289*t91-9.290772857533587d-5*t113*
     3           t123*t132*t144*t91+t832+t829+t828+t827+t826+t825+t824+t
     4           823+t822
              t834 = 1.0d+0*t407*t72*wght
              t835 = 1.0d+0*t137*t146*wght
              t836 = 2.0d+0*rhoa*t127*t407*wght
              t837 = 2.0d+0*rhoa*t138*t398*wght
              t838 = 1.0d+0*t138*t145*wght
              t839 = 2.0d+0*rhoa*t137*t404*wght
              t840 = 1.0d+0*t408*t70*wght
              t841 = 2.0d+0*rhoa*t125*t408*wght
              t842 = 8.203124999999999d-3*t249*t399*t70*t91
              t843 = -4.1015624999999994d-3*t123*t125*t399*t91
              t844 = 8.203124999999999d-3*t137*t249*t256*t399
              t845 = -4.1015624999999994d-3*t144*t145*t249*t91
              t846 = 1.0253906249999999d-3*t124*t126*t68*t70
              t847 = -2.0507812499999997d-3*t12*t124*t125*t68
              t848 = 4.1015624999999994d-3*gammaaa*t124*t126*t137*t68
              t849 = 4.1015624999999994d-3*t12*t13*t398*t68
              t850 = -2.0507812499999997d-3*t126*t13*t145*t68
              t851 = -8.203124999999999d-3*gammaaa*t126*t13*t407*t68
              t852 = 2.0d+0*rhoa*t70*(t851+t850+t849+t848+t847+t846+t845
     1           +t844+t843+t842+5.46875d-3*t71*t833-8.203124999999999d-
     2           3*gammaaa*t12*t124*t305*t68)*wght+2.0d+0*rhoa*t72*t833*
     3           wght+2.0d+0*rhoa*t145*t314*wght+2.0d+0*rhoa*t146*t305*w
     4           ght+t841+t840+t839+t838+t837+t836+t835+t834
              t853 = t410*t96+t66*(1.8458962242898416d-2*t144*t297*t359*
     1           t91+1.1075377345739049d-1*t144*t296*t297*t91+8.28125d-3
     2           *gammaaa*t123*t144)+2.5746978376432955d-4*t123*t140*t14
     3           4*t83*t91-2.2150754691478097d-1*t144*t297*t47*t577*t91+
     4           1.384422168217381d-2*t144*t297*t363*t47*t91-1.845896224
     5           2898416d-2*t144*t297*t359*t47*t91-2.768844336434762d-2*
     6           t144*t297*t300*t47*t91+1.384422168217381d-2*t122*t144*t
     7           245*t363*t91-8.28125d-3*t126*t144*t320*t91-2.3906249999
     8           999996d-2*gammaaa*t123*t144*t47+1.1953125d-2*gammaaa*t1
     9           22*t126*t144
              t854 = 2.0d+0*rhoa*t70*(1.6406249999999997d-2*t249*t399*t7
     1           0*t91-8.203124999999999d-3*t123*t125*t399*t91-8.2031249
     2           99999999d-3*t144*t145*t249*t91+5.46875d-3*t71*t853+2.05
     3           07812499999997d-3*t124*t126*t68*t70-8.203124999999999d-
     4           3*gammaaa*t126*t13*t411*t68+8.203124999999999d-3*t12*t1
     5           3*t398*t68-8.203124999999999d-3*gammaaa*t12*t124*t331*t
     6           68-4.1015624999999994d-3*t126*t13*t145*t68+4.1015624999
     7           999994d-3*gammaaa*t124*t126*t142*t68-4.1015624999999994
     8           d-3*t12*t124*t125*t68+8.203124999999999d-3*t142*t249*t2
     9           56*t399)*wght+2.0d+0*rhoa*t72*t853*wght+1.0d+0*t411*t72
     :           *wght+1.0d+0*t412*t70*wght+2.0d+0*rhoa*t125*t412*wght+2
     ;           .0d+0*rhoa*t127*t411*wght+2.0d+0*rhoa*t142*t404*wght+2.
     <           0d+0*rhoa*t143*t398*wght+2.0d+0*rhoa*t145*t336*wght+2.0
     =           d+0*rhoa*t146*t331*wght+1.0d+0*t142*t146*wght+1.0d+0*t1
     >           43*t145*wght
              t855 = t66*(-2.307370280362302d-3*t144*t297*t359*t91+t831+
     1           t830)+2.307370280362302d-3*t144*t297*t359*t47*t91-2.787
     2           231857260076d-4*t113*t123*t132*t144*t91+t832+t829+t828+
     3           t827+t826+t825+t824+t823+t822
              t856 = 2.0d+0*rhoa*t70*(5.46875d-3*t71*t855+t851+t850+t849
     1           +t848+t847+t846+t845+t844+t843+t842-8.203124999999999d-
     2           3*gammaaa*t12*t124*t341*t68)*wght+2.0d+0*rhoa*t72*t855*
     3           wght+2.0d+0*rhoa*t145*t342*wght+2.0d+0*rhoa*t146*t341*w
     4           ght+t841+t840+t839+t838+t837+t836+t835+t834
              t857 = -2.1521320832571972d-4*t113*t132*t144*t245*t363*t91
              t858 = 1.8581545715067177d-4*gammaaa*t113*t126*t132*t144
              t859 = 2.5746978376432955d-4*t126*t144*t171*t343*t91
              t860 = -2.5746978376432955d-4*t126*t144*t348*t83*t91
              t861 = 1.8081365470299196d-3*t144*t47*t569*t773*t91
              t862 = -5.537688672869524d-2*gammaaa*t144*t245*t296*t47
              t863 = 2.98828125d-3*t126*t144*t47
              t864 = t66*(-9.040682735149598d-4*t144*t569*t770*t91+2.768
     1           844336434762d-2*gammaaa*t144*t245*t300-1.03515625d-3*t1
     2           26*t144)
              t865 = 6.218138173930978d-2*t130*t406*t83
              t866 = 1.8581545715067177d-4*t113*t126*t144*t352*t91-1.858
     1           1545715067177d-4*t126*t144*t242*t350*t91+t865+t864+t863
     2           +t862+t861+t860+t859+t858+t857
              t867 = 4.0d+0*rhoa*t138*t407*wght
              t868 = 4.0d+0*rhoa*t137*t408*wght
              t869 = -3.0761718749999994d-3*gammaaa*t123*t399*t70
              t870 = -8.203124999999999d-3*t123*t137*t399*t91
              t871 = 2.0507812499999997d-3*gammaaa*t123*t144*t145
              t872 = -4.1015624999999994d-3*t12*t124*t137*t68
              t873 = 8.203124999999999d-3*t12*t13*t407*t68
              t874 = 2.0d+0*rhoa*t70*(t873+t872+t871+t870+t869+5.46875d-
     1           3*t71*t866-8.203124999999999d-3*gammaaa*t12*t124*t367*t
     2           68)*wght+2.0d+0*rhoa*t72*t866*wght+2.0d+0*rhoa*t145*t37
     3           1*wght+2.0d+0*rhoa*t146*t367*wght+t868+t867
              t875 = t66*(1.8081365470299196d-3*t144*t569*t770*t91-2.070
     1           3125d-3*t126*t144)-2.5746978376432955d-4*t126*t144*t372
     2           *t83*t91-3.616273094059839d-3*t144*t47*t569*t773*t91+2.
     3           1521320832571972d-4*t113*t132*t144*t245*t363*t91+2.5746
     4           978376432955d-4*t126*t130*t140*t144*t171*t91+t858+3.109
     5           069086965489d-2*t130*t410*t83+3.109069086965489d-2*t140
     6           *t406*t83+5.9765625d-3*t126*t144*t47
              t876 = 2.0d+0*rhoa*t70*(-4.1015624999999994d-3*t123*t142*t
     1           399*t91+5.46875d-3*t71*t875+t873+t872+t870-6.1523437499
     2           99999d-3*gammaaa*t123*t399*t70+4.1015624999999994d-3*t1
     3           2*t13*t411*t68-8.203124999999999d-3*gammaaa*t12*t124*t3
     4           83*t68-2.0507812499999997d-3*t12*t124*t142*t68+4.101562
     5           4999999994d-3*gammaaa*t123*t144*t145)*wght+2.0d+0*rhoa*
     6           t72*t875*wght+2.0d+0*rhoa*t137*t412*wght+2.0d+0*rhoa*t1
     7           38*t411*wght+2.0d+0*rhoa*t142*t408*wght+2.0d+0*rhoa*t14
     8           3*t407*wght+2.0d+0*rhoa*t145*t386*wght+2.0d+0*rhoa*t146
     9           *t383*wght
              t877 = t865+t864+t863+t862+t861+t860+t859+t858+t857
              t878 = t66*(-3.616273094059839d-3*t144*t569*t770*t91-1.107
     1           5377345739049d-1*gammaaa*t144*t245*t300-4.140625d-3*t12
     2           6*t144)-2.5746978376432955d-4*t126*t144*t391*t83*t91+7.
     3           232546188119678d-3*t144*t47*t569*t773*t91+2.57469783764
     4           32955d-4*t126*t144*t171*t389*t91+6.218138173930978d-2*t
     5           140*t410*t83+2.2150754691478097d-1*gammaaa*t144*t245*t2
     6           96*t47+1.1953125d-2*t126*t144*t47
              t879 = 7.171875d-2*t126*t414*t47*t91-2.484375d-2*t126*t414
     1           *t66*t91
              t880 = 2.0d+0*rhoa*t70*(-2.8710937499999994d-2*t123*t256*t
     1           70/taua**6+5.46875d-3*t71*t879-1.2304687499999997d-2*ga
     2           mmaaa*t12*t399*t68*t70-2.4609374999999994d-2*gammaaa*t1
     3           2*t124*t413*t68+2.4609374999999994d-2*gammaaa*t12*t144*
     4           t145*t68+2.4609374999999994d-2*t123*t145*t256*t414)*wgh
     5           t+2.0d+0*rhoa*t72*t879*wght+6.0d+0*rhoa*t145*t415*wght+
     6           6.0d+0*rhoa*t146*t413*wght
              fnc(iq) = 2.0d+0*rhoa*t48*(5.46875d-3*t14**3.0d+0*t48+1.0d
     1           +0)*wght+fnc(iq)
              Amat(iq,D1_RA) = 1.0d+0*t70*t72*wght+2.0d+0*rhoa*t125*t72*
     1           wght+2.0d+0*rhoa*t127*t70*wght+Amat(iq,D1_RA)
              Cmat(iq,D1_GAA) = 2.0d+0*rhoa*t137*t72*wght+2.0d+0*rhoa*t1
     1           38*t70*wght+Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = 2.0d+0*rhoa*t142*t72*wght+2.0d+0*rhoa*t1
     1           43*t70*wght+Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = 2.0d+0*rhoa*t145*t72*wght+2.0d+0*rhoa*t14
     1           6*t70*wght+Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t253*t72*wght+2.0d+0*rhoa
     1           *t261*t70*wght+t255+t254+t147+Amat2(iq,D2_RA_RA)
              Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t274*t72*wght+2.0d+0*rhoa
     1           *t275*t70*wght+t255+t254+t147+Amat2(iq,D2_RA_RB)
              Cmat2(iq,D2_RA_GAA) = 2.0d+0*rhoa*t305*t72*wght+2.0d+0*rho
     1           a*t314*t70*wght+t309+t308+t307+t306+Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = 2.0d+0*rhoa*t331*t72*wght+1.0d+0*t14
     1           2*t72*wght+2.0d+0*rhoa*t336*t70*wght+1.0d+0*t143*t70*wg
     2           ht+2.0d+0*rhoa*t125*t143*wght+2.0d+0*rhoa*t127*t142*wgh
     3           t+Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = 2.0d+0*rhoa*t341*t72*wght+2.0d+0*rho
     1           a*t342*t70*wght+t309+t308+t307+t306+Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = 2.0d+0*rhoa*t367*t72*wght+2.0d+0*rh
     1           oa*t371*t70*wght+t368+Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = 2.0d+0*rhoa*t383*t72*wght+2.0d+0*rh
     1           oa*t386*t70*wght+2.0d+0*rhoa*t137*t143*wght+2.0d+0*rhoa
     2           *t138*t142*wght+Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = 2.0d+0*rhoa*t387*t72*wght+2.0d+0*rh
     1           oa*t388*t70*wght+t368+Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = 2.0d+0*rhoa*t393*t72*wght+2.0d+0*rh
     1           oa*t394*t70*wght+4.0d+0*rhoa*t142*t143*wght+Cmat2(iq,D2
     2           _GAB_GAB)
              Mmat2(iq,D2_RA_TA) = t405+Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = t405+Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = t409+Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = t409+Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = 2.0d+0*rhoa*t411*t72*wght+2.0d+0*rho
     1           a*t412*t70*wght+2.0d+0*rhoa*t142*t146*wght+2.0d+0*rhoa*
     2           t143*t145*wght+Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = t416+Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = t416+Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = 2.0d+0*rhoa*t500*t72*wght+3.0d+0*t
     1           253*t72*wght+2.0d+0*rhoa*t70*(5.46875d-3*t500*t71-2.460
     2           9374999999994d-2*gammaaa*t126*t13*t253*t68+t505+t504+t5
     3           03+t502)*wght+3.0d+0*t261*t70*wght+6.0d+0*rhoa*t125*t26
     4           1*wght+6.0d+0*rhoa*t127*t253*wght+t501+Amat3(iq,D3_RA_R
     5           A_RA)
              Amat3(iq,D3_RA_RA_RB) = 2.0d+0*rhoa*t521*t72*wght+2.0d+0*t
     1           274*t72*wght+1.0d+0*t253*t72*wght+2.0d+0*rhoa*t70*(5.46
     2           875d-3*t521*t71-1.6406249999999997d-2*gammaaa*t126*t13*
     3           t274*t68-8.203124999999999d-3*gammaaa*t126*t13*t253*t68
     4           +t505+t504+t503+t502)*wght+2.0d+0*t275*t70*wght+1.0d+0*
     5           t261*t70*wght+4.0d+0*rhoa*t125*t275*wght+4.0d+0*rhoa*t1
     6           27*t274*wght+2.0d+0*rhoa*t125*t261*wght+2.0d+0*rhoa*t12
     7           7*t253*wght+t501+Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = 2.0d+0*rhoa*t590*t72*wght+2.0d+0*
     1           t305*t72*wght+2.0d+0*rhoa*t70*(5.46875d-3*t590*t71-1.64
     2           06249999999997d-2*gammaaa*t126*t13*t305*t68+t601+t600+t
     3           599+t598+t597+t596+t595)*wght+2.0d+0*t314*t70*wght+4.0d
     4           +0*rhoa*t125*t314*wght+4.0d+0*rhoa*t127*t305*wght+t594+
     5           t593+t592+t591+Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = 2.0d+0*rhoa*t649*t72*wght+2.0d+0*
     1           t331*t72*wght+2.0d+0*rhoa*t70*(5.46875d-3*t649*t71-1.64
     2           06249999999997d-2*gammaaa*t126*t13*t331*t68+8.203124999
     3           999999d-3*t12*t13*t253*t68+t657+t656+t655+t654+t653+t65
     4           2)*wght+2.0d+0*t336*t70*wght+4.0d+0*rhoa*t125*t336*wght
     5           +4.0d+0*rhoa*t127*t331*wght+2.0d+0*rhoa*t142*t261*wght+
     6           2.0d+0*rhoa*t143*t253*wght+t651+t650+Cmat3(iq,D3_RA_RA_
     7           GAB)
              Cmat3(iq,D3_RA_RA_GBB) = 2.0d+0*rhoa*t659*t72*wght+2.0d+0*
     1           t341*t72*wght+2.0d+0*rhoa*t70*(5.46875d-3*t659*t71-1.64
     2           06249999999997d-2*gammaaa*t126*t13*t341*t68+t601+t600+t
     3           599+t598+t597+t596+t595)*wght+2.0d+0*t342*t70*wght+4.0d
     4           +0*rhoa*t125*t342*wght+4.0d+0*rhoa*t127*t341*wght+t594+
     5           t593+t592+t591+Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = 2.0d+0*rhoa*t666*t72*wght+1.0d+0*
     1           t660*t72*wght+1.0d+0*t305*t72*wght+2.0d+0*rhoa*t70*(5.4
     2           6875d-3*t666*t71-8.203124999999999d-3*gammaaa*t126*t13*
     3           t660*t68-8.203124999999999d-3*gammaaa*t126*t13*t305*t68
     4           +4.1015624999999994d-3*t12*t13*t274*t68+t601+t599+t598+
     5           t597+t596+t595)*wght+1.0d+0*t667*t70*wght+1.0d+0*t314*t
     6           70*wght+2.0d+0*rhoa*t125*t667*wght+2.0d+0*rhoa*t127*t66
     7           0*wght+2.0d+0*rhoa*t125*t314*wght+2.0d+0*rhoa*t127*t305
     8           *wght+2.0d+0*rhoa*t137*t275*wght+2.0d+0*rhoa*t138*t274*
     9           wght+t592+t591+Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = 2.0d+0*rhoa*t674*t72*wght+1.0d+0*
     1           t668*t72*wght+1.0d+0*t331*t72*wght+2.0d+0*rhoa*t70*(5.4
     2           6875d-3*t674*t71-8.203124999999999d-3*gammaaa*t126*t13*
     3           t668*t68-8.203124999999999d-3*gammaaa*t126*t13*t331*t68
     4           +8.203124999999999d-3*t12*t13*t274*t68+t657+t656+t655+t
     5           654+t653+t652)*wght+1.0d+0*t675*t70*wght+1.0d+0*t336*t7
     6           0*wght+2.0d+0*rhoa*t125*t675*wght+2.0d+0*rhoa*t127*t668
     7           *wght+2.0d+0*rhoa*t125*t336*wght+2.0d+0*rhoa*t127*t331*
     8           wght+2.0d+0*rhoa*t142*t275*wght+2.0d+0*rhoa*t143*t274*w
     9           ght+t651+t650+Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = 2.0d+0*rhoa*t70*(t723+t722+t721+
     1           t720+t719+t718+5.46875d-3*t71*t715)*wght+2.0d+0*rhoa*t7
     2           15*t72*wght+4.0d+0*rhoa*t137*t314*wght+4.0d+0*rhoa*t138
     3           *t305*wght+t725+t724+t717+t716+t676+Cmat3(iq,D3_RA_GAA_
     4           GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = 2.0d+0*rhoa*t70*(t749+t748+t747+
     1           t746+t745+5.46875d-3*t71*t741+t723+t722+t720-8.20312499
     2           9999999d-3*gammaaa*t126*t13*t383*t68)*wght+2.0d+0*rhoa*
     3           t72*t741*wght+1.0d+0*t383*t72*wght+1.0d+0*t386*t70*wght
     4           +2.0d+0*rhoa*t125*t386*wght+2.0d+0*rhoa*t127*t383*wght+
     5           2.0d+0*rhoa*t142*t314*wght+2.0d+0*rhoa*t143*t305*wght+t
     6           750+t744+t743+t742+Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = 2.0d+0*rhoa*t70*(5.46875d-3*t71*
     1           t753+t723+t720+t719+t718-8.203124999999999d-3*gammaaa*t
     2           126*t13*t387*t68+4.1015624999999994d-3*t12*t13*t341*t68
     3           +4.1015624999999994d-3*t12*t13*t305*t68)*wght+2.0d+0*rh
     4           oa*t72*t753*wght+1.0d+0*t387*t72*wght+1.0d+0*t388*t70*w
     5           ght+2.0d+0*rhoa*t125*t388*wght+2.0d+0*rhoa*t127*t387*wg
     6           ht+2.0d+0*rhoa*t137*t342*wght+2.0d+0*rhoa*t138*t341*wgh
     7           t+2.0d+0*rhoa*t137*t314*wght+2.0d+0*rhoa*t138*t305*wght
     8           +t717+Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = 2.0d+0*rhoa*t70*(-1.640624999999
     1           9997d-2*t142*t144*t249*t91+5.46875d-3*t71*t754-1.230468
     2           7499999997d-2*gammaaa*t144*t249*t70-8.203124999999999d-
     3           3*gammaaa*t126*t13*t393*t68+1.6406249999999997d-2*t12*t
     4           13*t331*t68-8.203124999999999d-3*t126*t13*t142*t68+8.20
     5           3124999999999d-3*gammaaa*t123*t125*t144)*wght+2.0d+0*rh
     6           oa*t72*t754*wght+1.0d+0*t393*t72*wght+1.0d+0*t394*t70*w
     7           ght+2.0d+0*rhoa*t125*t394*wght+2.0d+0*rhoa*t127*t393*wg
     8           ht+4.0d+0*rhoa*t142*t336*wght+4.0d+0*rhoa*t143*t331*wgh
     9           t+2.0d+0*t142*t143*wght+Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = 1.0d+0*t70*t759*wght+2.0d+0*rhoa
     1           *t125*t759*wght+2.0d+0*rhoa*t70*(t758+5.46875d-3*t71*t7
     2           57-8.203124999999999d-3*gammaaa*t126*t13*t68*t756+t749+
     3           t748+t747+t746+t745+t723+t720)*wght+2.0d+0*rhoa*t72*t75
     4           7*wght+1.0d+0*t72*t756*wght+2.0d+0*rhoa*t127*t756*wght+
     5           2.0d+0*rhoa*t142*t342*wght+2.0d+0*rhoa*t143*t341*wght+t
     6           750+t744+t743+t742+Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = 2.0d+0*rhoa*t70*(5.46875d-3*t71*
     1           t760+t758+t723+t721+t720+t719+t718)*wght+2.0d+0*rhoa*t7
     2           2*t760*wght+4.0d+0*rhoa*t137*t342*wght+4.0d+0*rhoa*t138
     3           *t341*wght+t725+t724+t717+t716+t676+Cmat3(iq,D3_RA_GBB_
     4           GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = 2.0d+0*rhoa*t70*(t780+t779+5.46
     1           875d-3*t71*t778+1.2304687499999997d-2*t12*t13*t367*t68)
     2           *wght+2.0d+0*rhoa*t72*t778*wght+6.0d+0*rhoa*t137*t371*w
     3           ght+6.0d+0*rhoa*t138*t367*wght+Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = 2.0d+0*rhoa*t70*(t802+t801+t800
     1           +5.46875d-3*t71*t799+8.203124999999999d-3*t12*t13*t383*
     2           t68+8.203124999999999d-3*t12*t13*t367*t68)*wght+2.0d+0*
     3           rhoa*t72*t799*wght+4.0d+0*rhoa*t137*t386*wght+4.0d+0*rh
     4           oa*t138*t383*wght+2.0d+0*rhoa*t142*t371*wght+2.0d+0*rho
     5           a*t143*t367*wght+Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = 2.0d+0*rhoa*t70*(t804+5.46875d-
     1           3*t71*t803+t780+t779+4.1015624999999994d-3*t12*t13*t367
     2           *t68)*wght+2.0d+0*rhoa*t72*t803*wght+4.0d+0*rhoa*t137*t
     3           388*wght+4.0d+0*rhoa*t138*t387*wght+2.0d+0*rhoa*t137*t3
     4           71*wght+2.0d+0*rhoa*t138*t367*wght+Cmat3(iq,D3_GAA_GAA_
     5           GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = 2.0d+0*rhoa*t70*(5.46875d-3*t71
     1           *t805+t801+2.0507812499999997d-3*t123*t144*t70+4.101562
     2           4999999994d-3*t12*t13*t393*t68+1.6406249999999997d-2*t1
     3           2*t13*t383*t68+8.203124999999999d-3*gammaaa*t123*t142*t
     4           144)*wght+2.0d+0*rhoa*t72*t805*wght+2.0d+0*rhoa*t137*t3
     5           94*wght+2.0d+0*rhoa*t138*t393*wght+4.0d+0*rhoa*t142*t38
     6           6*wght+4.0d+0*rhoa*t143*t383*wght+Cmat3(iq,D3_GAA_GAB_G
     7           AB)
              Cmat3(iq,D3_GAA_GAB_GBB) = 2.0d+0*rhoa*t70*(5.46875d-3*t71
     1           *t806+t804+t802+t801+t800+4.1015624999999994d-3*t12*t13
     2           *t68*t756+4.1015624999999994d-3*t12*t13*t383*t68)*wght+
     3           2.0d+0*rhoa*t72*t806*wght+2.0d+0*rhoa*t137*t759*wght+2.
     4           0d+0*rhoa*t138*t756*wght+2.0d+0*rhoa*t142*t388*wght+2.0
     5           d+0*rhoa*t143*t387*wght+2.0d+0*rhoa*t137*t386*wght+2.0d
     6           +0*rhoa*t138*t383*wght+Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = 2.0d+0*rhoa*t70*(5.46875d-3*t71
     1           *t807+4.1015624999999994d-3*t123*t144*t70+2.46093749999
     2           99994d-2*t12*t13*t393*t68+2.4609374999999994d-2*gammaaa
     3           *t123*t142*t144)*wght+2.0d+0*rhoa*t72*t807*wght+6.0d+0*
     4           rhoa*t142*t394*wght+6.0d+0*rhoa*t143*t393*wght+Cmat3(iq
     5           ,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = t818+Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = t818+Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = 1.0d+0*t70*t821*wght+2.0d+0*rhoa*t
     1           125*t821*wght+2.0d+0*rhoa*t70*(5.46875d-3*t71*t820-8.20
     2           3124999999999d-3*gammaaa*t126*t13*t68*t819+t817+t816+t8
     3           15+t814+t813+t812-8.203124999999999d-3*gammaaa*t126*t13
     4           *t398*t68-8.203124999999999d-3*gammaaa*t12*t124*t274*t6
     5           8)*wght+2.0d+0*rhoa*t72*t820*wght+1.0d+0*t72*t819*wght+
     6           2.0d+0*rhoa*t127*t819*wght+1.0d+0*t398*t72*wght+1.0d+0*
     7           t404*t70*wght+2.0d+0*rhoa*t125*t404*wght+2.0d+0*rhoa*t1
     8           27*t398*wght+2.0d+0*rhoa*t145*t275*wght+2.0d+0*rhoa*t14
     9           6*t274*wght+t811+t810+Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = t852+Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = t852+Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = t854+Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = t854+Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = t856+Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = t856+Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = t874+Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = t874+Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = t876+Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = t876+Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = 2.0d+0*rhoa*t70*(5.46875d-3*t71*
     1           t877+t873+t872+t871+t870+t869-8.203124999999999d-3*gamm
     2           aaa*t12*t124*t387*t68)*wght+2.0d+0*rhoa*t72*t877*wght+2
     3           .0d+0*rhoa*t145*t388*wght+2.0d+0*rhoa*t146*t387*wght+t8
     4           68+t867+Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = 2.0d+0*rhoa*t70*(-1.640624999999
     1           9997d-2*t123*t142*t399*t91+5.46875d-3*t71*t878-1.230468
     2           7499999997d-2*gammaaa*t123*t399*t70+1.6406249999999997d
     3           -2*t12*t13*t411*t68-8.203124999999999d-3*gammaaa*t12*t1
     4           24*t393*t68-8.203124999999999d-3*t12*t124*t142*t68+8.20
     5           3124999999999d-3*gammaaa*t123*t144*t145)*wght+2.0d+0*rh
     6           oa*t72*t878*wght+4.0d+0*rhoa*t142*t412*wght+4.0d+0*rhoa
     7           *t143*t411*wght+2.0d+0*rhoa*t145*t394*wght+2.0d+0*rhoa*
     8           t146*t393*wght+Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = t880+Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = t880+Mmat3(iq,D3_TA_TA_TB)
            else 
              t1 = 1/rhoa**1.6666666666666669d+0
              t2 = 1/(3.291061569204112d-52*t1+1.0d+0)**4.0d+0
              t3 = rhoa**3.333333333333333d-1
              t4 = t3**5.0d-1
              t5 = 1/t4
              t6 = 1.530901310039024d-2*t5+1.0465751434d-1
              t7 = 7.876233178997433d-1*t5*t6+1.9269083139d-1
              t8 = 7.876233178997433d-1*t5*t7+4.3896648423d-1
              t9 = 1/t8
              t10 = 1.269642451250142d+0*t4*t9+1.0d+0
              t11 = log(t10)
              t12 = 1/t3
              t13 = 1.2746961887000874d-1*t12+1.0d+0
              t14 = 2.4141993114533214d-2*t5+1.0186556948d-1
              t15 = 7.876233178997433d-1*t14*t5+2.2308199064d-1
              t16 = 7.876233178997433d-1*t15*t5+4.7231125998d-1
              t17 = 1/t16
              t18 = 1.269642451250142d+0*t17*t4+1.0d+0
              t19 = log(t18)
              t20 = 1.325688999052018d-1*t12+1.0d+0
              t21 = 1.3212998810398843d-2*t5+2.9729725188d-2
              t22 = 7.876233178997433d-1*t21*t5+1.2236585478d-1
              t23 = 7.876233178997433d-1*t22*t5+3.497952466d-1
              t24 = 1/t23
              t25 = 1.269642451250142d+0*t24*t4+1.0d+0
              t26 = log(t25)
              t27 = 6.901399211255826d-2*t12+1.0d+0
              t28 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t19*t20-3.10907d-2*t11*t13)-3.37738d-2*t26*t
     2           27)+3.37738d-2*t26*t27)-6.21814d-2*t19*t20
              t29 = rhoa**1.1666666666666667d+0
              t30 = 1/t29**2.0d+0
              t31 = exp(-6.432793688582967d+1*t28)
              t32 = t31-1.0d+0
              t33 = 1/t32
              t34 = 8.648845980825518d-51*rhoa*t30*t33
              t35 = t34+1.0d+0
              t36 = (rhoa*t30)**2.0d+0
              t37 = 1/t32**2.0d+0
              t38 = 7.480253680004171d-101*t36*t37+t34+1.0d+0
              t39 = 1/t38
              t40 = 8.648845980825518d-51*rhoa*t30*t35*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t28
              t42 = log(1.4251254664507676d+0*t4/(7.016926042943223d-1*t
     1           5*(7.016926042943223d-1*(2.150807071909054d-2*t5+1.0186
     2           556948d-1)*t5+2.2308199064d-1)+4.7231125998d-1)+1.0d+0)
              t43 = 1.0522000558389215d-1*t12+1.0d+0
              t44 = exp(2.0000005873362642d+0*t42*t43)-1.0d+0
              t45 = 2.1622114952063787d-51*rhoa*t30/t44
              t46 = (3.3125000000000004d-2*t2+1.0d+0)*(3.109069086965489
     1           d-2*log(2.1622114952063787d-51*rhoa*t30*(t45+1.0d+0)/(t
     2           45+4.6751585500026027d-102*t36/t44**2.0d+0+1.0d+0)+1.0d
     3           +0)-6.21814d-2*t42*t43)-6.25d-2*(5.3d-1*t2+1.0d+0)*t41
              t47 = 1.5749013123685918d-1
              t48 = 2.0896938388186886d-51*t1*t47+1.0d+0
              t49 = 1/t48**4.0d+0
              t50 = 5.3d-1*t49+1.0d+0
              t51 = 3.312500000000001d-2*t49+1.0d+0
              t52 = 2.1508070719090538d-2*t5+1.0186556948d-1
              t53 = 7.016926042943222d-1*t5*t52+2.2308199064d-1
              t54 = 7.016926042943222d-1*t5*t53+4.7231125998d-1
              t55 = 1/t54
              t56 = 1.425125466450768d+0*t4*t55+1.0d+0
              t57 = log(t56)
              t58 = 1.0522000558389213d-1*t12+1.0d+0
              t59 = exp(2.0000005873362642d+0*t57*t58)
              t60 = t59-1.0d+0
              t61 = 1/t60
              t62 = 2.162211495206379d-51*rhoa*t30*t61
              t63 = t62+1.0d+0
              t64 = 1/t60**2.0d+0
              t65 = 4.6751585500026044d-102*t36*t64+t62+1.0d+0
              t66 = 1/t65
              t67 = 2.162211495206379d-51*rhoa*t30*t63*t66+1.0d+0
              t68 = log(t67)
              t69 = 3.109069086965489d-2*t68-6.21814d-2*t57*t58
              t70 = t51*t69-6.250000000000001d-2*t41*t50
              t71 = 4.375000000000001d-2*t70+1.0d+0
              t72 = 1/rhoa**1.3333333333333333d+0
              t73 = 1/t10
              t74 = 1/t8**2
              t75 = rhoa**1.3333333333333336d+0
              t76 = 1/t75
              t77 = 1/t4**3
              t78 = 1/rhoa**6.666666666666667d-1
              t79 = -1.3127055298329054d-1*t6*t77*t78-2.0096226153166658
     1           d-3*t76
              t80 = 7.876233178997433d-1*t5*t79-1.3127055298329054d-1*t7
     1           *t77*t78
              t81 = 2.11607075208357d-1*t5*t78*t9-1.269642451250142d+0*t
     1           4*t74*t80
              t82 = 1/t18
              t83 = 1/t16**2
              t84 = -1.3127055298329054d-1*t14*t77*t78-3.169132786263567
     1           d-3*t76
              t85 = 7.876233178997433d-1*t5*t84-1.3127055298329054d-1*t1
     1           5*t77*t78
              t86 = 2.11607075208357d-1*t17*t5*t78-1.269642451250142d+0*
     1           t4*t83*t85
              t87 = 1/t25
              t88 = 1/t23**2
              t89 = -1.3127055298329054d-1*t21*t77*t78-1.734477660408616
     1           2d-3*t76
              t90 = 7.876233178997433d-1*t5*t89-1.3127055298329054d-1*t2
     1           2*t77*t78
              t91 = 2.11607075208357d-1*t24*t5*t78-1.269642451250142d+0*
     1           t4*t88*t90
              t92 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t27*t87*t9
     1           1+1.709920934161365d+0*(6.21814d-2*t20*t82*t86-3.10907d
     2           -2*t13*t73*t81-2.747773264188438d-3*t19*t72+1.321039893
     3           1339265d-3*t11*t72)+7.769549222703733d-4*t26*t72)+3.377
     4           38d-2*t27*t87*t91-7.769549222703733d-4*t26*t72)-6.21814
     5           d-2*t20*t82*t86+2.747773264188438d-3*t19*t72
              t93 = 1/t40
              t94 = 1/t29**3.0d+0
              t95 = -2.018064062192621d-50*t29*t33*t94
              t96 = 8.648845980825518d-51*t30*t33
              t97 = 1/t32**2
              t98 = 5.563624183898056d-49*rhoa*t30*t31*t92*t97
              t99 = t98+t96+t95
              t100 = 1/t38**2
              t101 = t30-2.3333333333333334d+0*t29*t94
              t102 = 1/t32**3.0d+0
              t103 = t98+t96+t95+9.623785732346068d-99*t102*t31*t36*t92+
     1           1.4960507360008343d-100*rhoa*t101*t30*t37
              t104 = 8.648845980825518d-51*rhoa*t30*t39*t99-2.0180640621
     1           92621d-50*t29*t35*t39*t94+8.648845980825518d-51*t30*t35
     2           *t39-8.648845980825518d-51*rhoa*t100*t103*t30*t35
              t105 = 1.5545345434827443d-2*t104*t93+1.0d+0*t92
              t106 = 1/t56
              t107 = 1/t54**2
              t108 = -5.847438369119352d-2*t52*t77*t78-1.257671179685424
     1           2d-3*t76
              t109 = 7.016926042943222d-1*t108*t5-5.847438369119352d-2*t
     1           53*t77*t78
              t110 = 1.1876045553756398d-1*t5*t55*t78-1.425125466450768d
     1           +0*t107*t109*t4
              t111 = 1.090454542535705d-3*t57*t72-6.21814d-2*t106*t110*t
     1           58
              t112 = 1/t67
              t113 = -2.5225800777407753d-51*t29*t61*t94
              t114 = 1.0811057476031895d-51*t30*t61
              t115 = 1/t60**2
              t116 = 6.954530229872565d-50*rhoa*t111*t115*t30*t59
              t117 = t116+t114+t113
              t118 = 1/t65**2
              t119 = 7.937005259840997d-51*t30-1.8519678939628997d-50*t2
     1           9*t94
              t120 = 1/t60**3.0d+0
              t121 = 5.890330668744275d-52*rhoa*t119*t30*t64+3.007433041
     1           3581446d-100*t111*t120*t36*t59+t116+t114+t113
              t122 = -2.5225800777407753d-51*t29*t63*t66*t94+1.081105747
     1           6031895d-51*t30*t63*t66+2.162211495206379d-51*rhoa*t117
     2           *t30*t66-2.162211495206379d-51*rhoa*t118*t121*t30*t63
              t123 = 3.109069086965489d-2*t112*t122+1.0d+0*t111
              t124 = 7.874506561842959d-2
              t125 = 1/rhoa**2.6666666666666666d+0
              t126 = 1.0448469194093443d-51*t125*t47-5.572516903516502d-
     1           51*t124*t125
              t127 = 1/t48**5.0d+0
              t128 = -1.3250000000000003d-1*t126*t127*t69+t123*t51-3.125
     1           0000000000006d-2*t105*t50+1.3250000000000003d-1*t126*t1
     2           27*t41
              t129 = t128**2
              t130 = 1.7500000000000004d-1*rhoa*t129*wght
              t131 = 2.0d+0*t128*t71*wght
              t132 = 8.750000000000002d-2*t128*t70*wght
              t133 = 1.3250000000000003d-1*t105*t126*t127
              t134 = 1/rhoa
              t135 = 1/rhoa**2.333333333333333d+0
              t136 = 1/t10**2
              t137 = t81**2
              t138 = 1/t8**3
              t139 = t80**2
              t140 = 1/rhoa**2.3333333333333334d+0
              t141 = 1/rhoa**1.6666666666666669d+0
              t142 = 1/t4**5
              t143 = 8.751370198886037d-2*t141*t6*t77+6.563527649164527d
     1           -2*t142*t6*t76+3.0144339229749983d-3*t140
              t144 = -2.625411059665811d-1*t77*t78*t79+8.751370198886037
     1           d-2*t141*t7*t77+6.563527649164527d-2*t142*t7*t76+7.8762
     2           33178997433d-1*t143*t5
              t145 = -3.52678458680595d-2*t76*t77*t9-1.4107138347223802d
     1           -1*t141*t5*t9-4.23214150416714d-1*t5*t74*t78*t80-1.2696
     2           42451250142d+0*t144*t4*t74+2.539284902500284d+0*t138*t1
     3           39*t4
              t146 = 1/t18**2
              t147 = t86**2
              t148 = 1/t16**3
              t149 = t85**2
              t150 = 8.751370198886037d-2*t14*t141*t77+6.563527649164527
     1           d-2*t14*t142*t76+4.753699179395351d-3*t140
              t151 = -2.625411059665811d-1*t77*t78*t84+8.751370198886037
     1           d-2*t141*t15*t77+6.563527649164527d-2*t142*t15*t76+7.87
     2           6233178997433d-1*t150*t5
              t152 = -4.23214150416714d-1*t5*t78*t83*t85-1.2696424512501
     1           42d+0*t151*t4*t83-3.52678458680595d-2*t17*t76*t77-1.410
     2           7138347223802d-1*t141*t17*t5+2.539284902500284d+0*t148*
     3           t149*t4
              t153 = 1/t25**2
              t154 = t91**2
              t155 = 1/t23**3
              t156 = t90**2
              t157 = 8.751370198886037d-2*t141*t21*t77+6.563527649164527
     1           d-2*t142*t21*t76+2.601716490612924d-3*t140
              t158 = -2.625411059665811d-1*t77*t78*t89+8.751370198886037
     1           d-2*t141*t22*t77+6.563527649164527d-2*t142*t22*t76+7.87
     2           6233178997433d-1*t157*t5
              t159 = -4.23214150416714d-1*t5*t78*t88*t90-1.2696424512501
     1           42d+0*t158*t4*t88-3.52678458680595d-2*t24*t76*t77-1.410
     2           7138347223802d-1*t141*t24*t5+2.539284902500284d+0*t155*
     3           t156*t4
              t160 = 5.848223622634643d-1*(1.0d+0*(1.5539098445407465d-3
     1           *t72*t87*t91-3.37738d-2*t159*t27*t87+1.709920934161365d
     2           +0*(-5.495546528376876d-3*t72*t82*t86+6.21814d-2*t152*t
     3           20*t82+2.642079786267853d-3*t72*t73*t81-3.10907d-2*t13*
     4           t145*t73-6.21814d-2*t146*t147*t20+3.663697685584584d-3*
     5           t135*t19+3.10907d-2*t13*t136*t137-1.7613865241785687d-3
     6           *t11*t135)+3.37738d-2*t153*t154*t27-1.0359398963604977d
     7           -3*t135*t26)-1.5539098445407465d-3*t72*t87*t91+3.37738d
     8           -2*t159*t27*t87-3.37738d-2*t153*t154*t27+1.035939896360
     9           4977d-3*t135*t26)+5.495546528376876d-3*t72*t82*t86-6.21
     :           814d-2*t152*t20*t82+6.21814d-2*t146*t147*t20-3.66369768
     ;           5584584d-3*t135*t19
              t161 = 1/t29**4.0d+0
              t162 = rhoa**1.6666666666666674d-1
              t163 = t92**2
              t164 = exp(-1.2865587377165935d+2*t28)
              t165 = 1/t32**3
              t166 = 7.157929307165395d-47*rhoa*t163*t164*t165*t30
              t167 = 7.063224217674173d-50*t161*t33*t75
              t168 = -4.372472134750679d-50*t162*t33*t94
              t169 = -2.5963579524857594d-48*t29*t31*t92*t94*t97
              t170 = 1.1127248367796111d-48*t30*t31*t92*t97
              t171 = -3.5789646535826974d-47*rhoa*t163*t30*t31*t97
              t172 = 5.563624183898056d-49*rhoa*t160*t30*t31*t97
              t173 = t172+t171+t170+t169+t168+t167+t166
              t174 = 1/t32**4.0d+0
              t175 = 8.166666666666668d+0*t161*t75-5.055555555555556d+0*
     1           t162*t94
              t176 = t101**2
              t177 = 3.8495142929384274d-98*rhoa*t101*t102*t30*t31*t92+1
     1           .4960507360008343d-100*rhoa*t175*t30*t37+1.496050736000
     2           8343d-100*t176*t37-6.19078281193106d-97*t102*t163*t31*t
     3           36+9.623785732346068d-99*t102*t160*t31*t36+1.8572348435
     4           79318d-96*t163*t164*t174*t36+t172+t171+t170+t169+t168+t
     5           167+t166
              t178 = 1/t38**3
              t179 = t103**2
              t180 = -4.036128124385242d-50*t29*t39*t94*t99+1.7297691961
     1           651035d-50*t30*t39*t99-1.7297691961651035d-50*rhoa*t100
     2           *t103*t30*t99-4.372472134750679d-50*t162*t35*t39*t94+4.
     3           036128124385242d-50*t100*t103*t29*t35*t94+7.06322421767
     4           4173d-50*t161*t35*t39*t75+8.648845980825518d-51*rhoa*t1
     5           73*t30*t39+1.7297691961651035d-50*rhoa*t178*t179*t30*t3
     6           5-8.648845980825518d-51*rhoa*t100*t177*t30*t35-1.729769
     7           1961651035d-50*t100*t103*t30*t35
              t181 = 1/t40**2
              t182 = 1.5545345434827443d-2*t180*t93-1.5545345434827443d-
     1           2*t104**2*t181+1.0d+0*t160
              t183 = -2.6500000000000007d-1*t123*t126*t127
              t184 = t126**2
              t185 = 1/t48**6.0d+0
              t186 = 1.0600000000000001d+1*t184*t185
              t187 = 3.937253280921477d-2
              t188 = 1/rhoa**3.6666666666666664d+0
              t189 = 2.0432561979560507d-50*t187*t188
              t190 = -5.572516903516502d-51*t124*t188
              t191 = 5.804705107829684d-52*t188*t47+t190+t189
              t192 = 1/rhoa**2
              t193 = 4.35d-1*t192*t49-2.1200000000000002d+0*t127*t191+t1
     1           86
              t194 = 6.625000000000003d-1*t184*t185
              t195 = 2.718750000000001d-2*t192*t49+t194-1.32500000000000
     1           03d-1*t127*t191
              t196 = -7.269696950238034d-4*t135*t57
              t197 = 1.1771443702974158d-2*t5+2.9729725188d-2
              t198 = 7.016926042943222d-1*t197*t5+1.2236585478d-1
              t199 = 7.016926042943222d-1*t198*t5+3.497952466d-1
              t200 = 1/t199
              t201 = 1.425125466450768d+0*t200*t4+1.0d+0
              t202 = log(t201)
              t203 = 5.477644184000001d-2*t12+1.0d+0
              t204 = 2.18090908507141d-3*t106*t110*t72
              t205 = 1/t56**2
              t206 = t110**2
              t207 = 6.21814d-2*t205*t206*t58
              t208 = 1/t54**3
              t209 = t109**2
              t210 = 1.949146123039784d-2*t141*t52*t77+1.461859592279837
     1           5d-2*t142*t52*t76+9.432533847640683d-4*t140
              t211 = -1.1694876738238703d-1*t108*t77*t78+1.9491461230397
     1           84d-2*t141*t53*t77+1.4618595922798375d-2*t142*t53*t76+7
     2           .016926042943222d-1*t210*t5
              t212 = -2.3752091107512796d-1*t107*t109*t5*t78-9.896704628
     1           130328d-3*t55*t76*t77-3.9586818512521327d-2*t141*t5*t55
     2           -1.425125466450768d+0*t107*t211*t4+2.850250932901536d+0
     3           *t208*t209*t4
              t213 = -6.21814d-2*t106*t212*t58
              t214 = t213+t207+t204+8.443450000000001d-3*t192*t202*t203+
     1           t196
              t215 = 1/t67**2
              t216 = -3.109069086965489d-2*t122**2*t215
              t217 = 4.4145151360463564d-51*t161*t63*t66*t75
              t218 = -2.732795084219174d-51*t162*t63*t66*t94
              t219 = -5.045160155481551d-51*t117*t29*t66*t94
              t220 = 2.162211495206379d-51*t117*t30*t66
              t221 = 5.045160155481551d-51*t118*t121*t29*t63*t94
              t222 = -2.162211495206379d-51*t118*t121*t30*t63
              t223 = -4.324422990412758d-51*rhoa*t117*t118*t121*t30
              t224 = 1/t65**3
              t225 = t121**2
              t226 = 4.324422990412758d-51*rhoa*t224*t225*t30*t63
              t227 = 4.4145151360463564d-51*t161*t61*t75
              t228 = -2.732795084219174d-51*t162*t61*t94
              t229 = 2.4024572168959757d-52*t134*t30*t61
              t230 = -1.6227237203035988d-49*t111*t115*t29*t59*t94
              t231 = 6.954530229872565d-50*t111*t115*t30*t59
              t232 = t111**2
              t233 = -2.2368529084891842d-48*rhoa*t115*t232*t30*t59
              t234 = 3.3333343122271053d-1*t192*t57*t58-3.21639684429148
     1           3d+1*t214
              t235 = -2.162211495206379d-51*rhoa*t115*t234*t30*t59
              t236 = 1/t60**3
              t237 = exp(4.0000011746725284d+0*t57*t58)
              t238 = 4.4737058169783683d-48*rhoa*t232*t236*t237*t30
              t239 = t238+t235+t233+t231+t230+t229+t228+t227
              t240 = 3.240943814435074d-50*t161*t75-2.0062985517931411d-
     1           50*t162*t94
              t241 = 5.890330668744274d-52*rhoa*t240*t30*t64
              t242 = t119**2
              t243 = 3.710675800196128d-2*t242*t64
              t244 = 7.578256389912968d-50*rhoa*t111*t119*t120*t30*t59
              t245 = -9.673098143642272d-99*t120*t232*t36*t59
              t246 = 1/t60**4.0d+0
              t247 = 1.0389241222228007d-102*t192*t36*t64-9.350317100005
     1           209d-102*t120*t234*t36*t59+2.901929443092682d-98*t232*t
     2           237*t246*t36+t245+t244+t243+t241+t238+t235+t233+t231+t2
     3           30+t229+t228+t227
              t248 = 2.4024572168959757d-52*t134*t30*t63*t66+2.162211495
     1           206379d-51*rhoa*t239*t30*t66-2.162211495206379d-51*rhoa
     2           *t118*t247*t30*t63+t226+t223+t222+t221+t220+t219+t218+t
     3           217
              t249 = -5.181781811609147d-3*t192*t68+3.109069086965489d-2
     1           *t112*t248+t216+1.0d+0*t214
              t250 = t195*t69+t249*t51-3.1250000000000006d-2*t182*t50-3.
     1           1250000000000006d-2*t105*t134*t50-6.250000000000001d-2*
     2           t193*t41+t183+t133
              t251 = -5.804705107829683d-52*t188*t47+t190+t189
              t252 = -4.35d-1*t192*t49-2.1200000000000002d+0*t127*t251+t
     1           186
              t253 = -2.718750000000001d-2*t192*t49-1.3250000000000003d-
     1           1*t127*t251+t194
              t254 = t213+t207+t204-8.44345d-3*t192*t202*t203+t196
              t255 = -2.4024572168959762d-52*t134*t30*t61
              t256 = -3.3333343122271064d-1*t192*t57*t58-3.2163968442914
     1           83d+1*t254
              t257 = -2.162211495206379d-51*rhoa*t115*t256*t30*t59
              t258 = t257+t255+t238+t233+t231+t230+t228+t227
              t259 = -1.038924122222801d-102*t192*t36*t64-9.350317100005
     1           209d-102*t120*t256*t36*t59+2.901929443092681d-98*t232*t
     2           237*t246*t36+t257+t255+t245+t244+t243+t241+t238+t233+t2
     3           31+t230+t228+t227
              t260 = -2.4024572168959762d-52*t134*t30*t63*t66+2.16221149
     1           5206379d-51*rhoa*t258*t30*t66-2.162211495206379d-51*rho
     2           a*t118*t259*t30*t63+t226+t223+t222+t221+t220+t219+t218+
     3           t217
              t261 = 5.181781811609147d-3*t192*t68+3.109069086965489d-2*
     1           t112*t260+1.0d+0*t254+t216
              t262 = t253*t69+t261*t51+3.1250000000000006d-2*t105*t134*t
     1           50-6.250000000000001d-2*t252*t41+t183+t133
              t263 = 2.6250000000000007d-1*t129*wght
              t264 = 1/rhoa**3.333333333333333d+0
              t265 = 1/rhoa**3.3333333333333337d+0
              t266 = 1/rhoa**2.666666666666667d+0
              t267 = 1/t4**7
              t268 = 1/rhoa**2.0d+0
              t269 = 1/t18**3
              t270 = t86**3
              t271 = -7.617854707500852d+0*t4*t85**3/t16**4+1.0580353760
     1           417849d-1*t76*t77*t83*t85+4.2321415041671406d-1*t141*t5
     2           *t83*t85+7.617854707500852d+0*t148*t151*t4*t85-1.269642
     3           451250142d+0*t4*t83*(2.625411059665811d-1*t141*t77*t84+
     4           1.9690582947493582d-1*t142*t76*t84-3.9381165894987163d-
     5           1*t150*t77*t78+7.876233178997433d-1*t5*(-1.458561699814
     6           3394d-1*t14*t266*t77-5.469606374303773d-2*t14*t267*t268
     7           -1.1708185015918181d-2*t265-1.3127055298329054d-1*t14*t
     8           140*t142)-1.4585616998143394d-1*t15*t266*t77-5.46960637
     9           4303773d-2*t15*t267*t268-1.3127055298329054d-1*t140*t14
     :           2*t15)-6.34821225625071d-1*t151*t5*t78*t83+1.2696424512
     ;           50142d+0*t148*t149*t5*t78+7.053569173611901d-2*t140*t17
     <           *t77+2.3511897245373004d-1*t17*t266*t5+1.76339229340297
     =           5d-2*t142*t17*t268
              t272 = 1/t25**3
              t273 = t91**3
              t274 = -7.617854707500852d+0*t4*t90**3/t23**4+1.0580353760
     1           417849d-1*t76*t77*t88*t90+4.2321415041671406d-1*t141*t5
     2           *t88*t90+7.617854707500852d+0*t155*t158*t4*t90-1.269642
     3           451250142d+0*t4*t88*(2.625411059665811d-1*t141*t77*t89+
     4           1.9690582947493582d-1*t142*t76*t89-3.9381165894987163d-
     5           1*t157*t77*t78+7.876233178997433d-1*t5*(-1.458561699814
     6           3394d-1*t21*t266*t77-5.469606374303773d-2*t21*t267*t268
     7           -6.407931356509611d-3*t265-1.3127055298329054d-1*t140*t
     8           142*t21)-1.4585616998143394d-1*t22*t266*t77-5.469606374
     9           303773d-2*t22*t267*t268-1.3127055298329054d-1*t140*t142
     :           *t22)-6.34821225625071d-1*t158*t5*t78*t88+1.26964245125
     ;           0142d+0*t155*t156*t5*t78+7.053569173611901d-2*t140*t24*
     <           t77+2.3511897245373004d-1*t24*t266*t5+1.763392293402975
     =           d-2*t142*t24*t268
              t275 = 5.848223622634643d-1*(1.0d+0*(-3.107819689081493d-3
     1           *t135*t87*t91+1.013214d-1*t153*t159*t27*t91+1.709920934
     2           161365d+0*(-3.10907d-2*t13*t73*(7.053569173611901d-2*t1
     3           40*t77*t9+2.3511897245373004d-1*t266*t5*t9+1.7633922934
     4           02975d-2*t142*t268*t9-7.617854707500852d+0*t4*t80**3/t8
     5           **4+1.0580353760417849d-1*t74*t76*t77*t80+4.23214150416
     6           71406d-1*t141*t5*t74*t80+7.617854707500852d+0*t138*t144
     7           *t4*t80-1.269642451250142d+0*t4*t74*(2.625411059665811d
     8           -1*t141*t77*t79+1.9690582947493582d-1*t142*t76*t79-3.93
     9           81165894987163d-1*t143*t77*t78+7.876233178997433d-1*t5*
     :           (-1.4585616998143394d-1*t266*t6*t77-5.469606374303773d-
     ;           2*t267*t268*t6-1.3127055298329054d-1*t140*t142*t6-7.424
     <           439106586571d-3*t265)-1.4585616998143394d-1*t266*t7*t77
     =           -5.469606374303773d-2*t267*t268*t7-1.3127055298329054d-
     >           1*t140*t142*t7)-6.34821225625071d-1*t144*t5*t74*t78+1.2
     ?           69642451250142d+0*t138*t139*t5*t78)+1.0991093056753751d
     @           -2*t135*t82*t86-1.865442d-1*t146*t152*t20*t86-8.2433197
     1           92565315d-3*t152*t72*t82+6.21814d-2*t20*t271*t82-6.2181
     2           4d-2*t13*t81**3/t10**3-5.284159572535706d-3*t135*t73*t8
     3           1+9.327209999999999d-2*t13*t136*t145*t81+3.963119679401
     4           78d-3*t145*t72*t73+8.243319792565315d-3*t146*t147*t72-3
     5           .96311967940178d-3*t136*t137*t72+1.243628d-1*t20*t269*t
     6           270-8.548627933030694d-3*t19*t264+4.1099018897499934d-3
     7           *t11*t264)+2.33086476681112d-3*t159*t72*t87-3.37738d-2*
     8           t27*t274*t87-2.33086476681112d-3*t153*t154*t72-6.75476d
     9           -2*t27*t272*t273+2.4171930915078277d-3*t26*t264)+3.1078
     :           19689081493d-3*t135*t87*t91-1.013214d-1*t153*t159*t27*t
     ;           91-2.33086476681112d-3*t159*t72*t87+3.37738d-2*t27*t274
     <           *t87+2.33086476681112d-3*t153*t154*t72+6.75476d-2*t27*t
     =           272*t273-2.4171930915078277d-3*t26*t264)-1.099109305675
     >           3751d-2*t135*t82*t86+1.865442d-1*t146*t152*t20*t86+8.24
     ?           3319792565315d-3*t152*t72*t82-6.21814d-2*t20*t271*t82-8
     @           .243319792565315d-3*t146*t147*t72-1.243628d-1*t20*t269*
     1           t270+8.548627933030694d-3*t19*t264
              t276 = rhoa**1.5000000000000002d+0
              t277 = 1/t29**5.0d+0
              t278 = rhoa**3.333333333333335d-1
              t279 = 1/rhoa**8.333333333333333d-1
              t280 = t92**3
              t281 = exp(-1.92983810657489d+2*t28)
              t282 = 1.381364474113698d-44*rhoa*t280*t281*t30/t32**4
              t283 = -5.010550515015777d-46*t163*t164*t165*t29*t94
              t284 = 2.1473787921496185d-46*t163*t164*t165*t30
              t285 = -1.381364474113698d-44*rhoa*t164*t165*t280*t30
              t286 = 2.1473787921496185d-46*rhoa*t160*t164*t165*t30*t92
              t287 = -3.296171301581281d-49*t276*t277*t33
              t288 = 2.472128476185961d-49*t161*t278*t33
              t289 = -7.287453557917802d-51*t279*t33*t94
              t290 = 1.3630879250550237d-47*t161*t31*t75*t92*t97
              t291 = -8.438163345578719d-48*t162*t31*t92*t94*t97
              t292 = 2.5052752575078885d-46*t163*t29*t31*t94*t97
              t293 = -3.894536928728639d-48*t160*t29*t31*t94*t97
              t294 = -1.0736893960748092d-46*t163*t30*t31*t97
              t295 = 1.6690872551694166d-48*t160*t30*t31*t97
              t296 = 2.30227412352283d-45*rhoa*t280*t30*t31*t97
              t297 = -1.0736893960748092d-46*rhoa*t160*t30*t31*t92*t97
              t298 = 5.563624183898056d-49*rhoa*t275*t30*t31*t97
              t299 = t126**3
              t300 = 1/t48**7.0d+0
              t301 = -6.36d+1*t299*t300
              t302 = 1/rhoa**4.666666666666667d+0
              t303 = -1.8771240061386418d-51*t302
              t304 = -8.707057661744514d-52*t302*t47+t303+3.064884296934
     1           0756d-50*t187*t302-4.6437640862637475d-51*t124*t302
              t305 = 1/rhoa**3
              t306 = -3.975000000000001d+0*t299*t300
              t307 = 8.48131310861104d-4*t264*t57
              t308 = -2.1809090850714105d-3*t106*t110*t135
              t309 = 3.37738d-2*t203*(1.1876045553756398d-1*t200*t5*t78-
     1           1.425125466450768d+0*t4*(7.016926042943222d-1*t5*(-5.84
     2           7438369119352d-2*t197*t77*t78-6.883279156869946d-4*t76)
     3           -5.847438369119352d-2*t198*t77*t78)/t199**2)/t201-3.083
     4           347652359653d-4*t202*t72
              t310 = -3.2713636276071156d-3*t205*t206*t72
              t311 = 3.2713636276071156d-3*t106*t212*t72
              t312 = -1.243628d-1*t110**3*t58/t56**3
              t313 = 1.865442d-1*t110*t205*t212*t58
              t314 = -6.21814d-2*t106*t58*(-1.425125466450768d+0*t107*t4
     1           *(-1.7542315107358056d-1*t210*t77*t78+7.016926042943222
     2           d-1*t5*(-1.6242884358664864d-2*t266*t52*t77-6.091081634
     3           499322d-3*t267*t268*t52-1.4618595922798375d-2*t140*t142
     4           *t52-1.161599075681677d-3*t265)-1.6242884358664864d-2*t
     5           266*t53*t77+5.847438369119352d-2*t108*t141*t77+4.385578
     6           776839513d-2*t108*t142*t76-6.091081634499322d-3*t267*t2
     7           68*t53-1.4618595922798375d-2*t140*t142*t53)-3.562813666
     8           1269194d-1*t107*t211*t5*t78+7.125627332253839d-1*t208*t
     9           209*t5*t78+2.969011388439098d-2*t107*t109*t76*t77+9.896
     :           70462813033d-3*t140*t55*t77+3.29890154271011d-2*t266*t5
     ;           *t55+2.474176157032582d-3*t142*t268*t55-8.5507527987046
     <           06d+0*t109**3*t4/t54**4+1.1876045553756398d-1*t107*t109
     =           *t141*t5+8.550752798704606d+0*t109*t208*t211*t4)
              t315 = t314+t313+t312+t311+t310+7.500000000000002d-1*t192*
     1           t309+t308+t307-2.533035d-2*t202*t203*t305
              t316 = 6.218138173930978d-2*t122**3/t67**3
              t317 = -1.0300535317441502d-50*t276*t277*t63*t66
              t318 = 7.725401488081126d-51*t161*t278*t63*t66
              t319 = 1.324354540813907d-50*t117*t161*t66*t75
              t320 = -1.324354540813907d-50*t118*t121*t161*t63*t75
              t321 = -6.486634485619137d-51*t117*t118*t121*t30
              t322 = 6.486634485619137d-51*t224*t225*t30*t63
              t323 = 1.2973268971238275d-50*rhoa*t117*t224*t225*t30
              t324 = -1.2973268971238275d-50*rhoa*t121**3*t30*t63/t65**4
              t325 = -1.0300535317441502d-50*t276*t277*t61
              t326 = 7.725401488081126d-51*t161*t278*t61
              t327 = -1.0685929495985227d-51*t279*t61*t94
              t328 = -3.603685825343967d-52*t192*t30*t61
              t329 = 4.259649765796947d-49*t111*t115*t161*t59*t75
              t330 = -2.6369260454933485d-49*t111*t115*t162*t59*t94
              t331 = 7.828985179712145d-48*t115*t232*t29*t59*t94
              t332 = 7.567740233222326d-51*t115*t234*t29*t59*t94
              t333 = -3.355279362733776d-48*t115*t232*t30*t59
              t334 = 2.3181767432908545d-50*t111*t115*t134*t30*t59
              t335 = -3.2433172428095686d-51*t115*t234*t30*t59
              t336 = t111**3
              t337 = 7.194606636008837d-47*rhoa*t115*t30*t336*t59
              t338 = -1.0000002936681321d+0*t305*t57*t58-3.2163968442914
     1           83d+1*t315-1.608198422145741d+1*t111*t192
              t339 = -2.162211495206379d-51*rhoa*t115*t30*t338*t59
              t340 = 2.0863590689617698d-49*rhoa*t111*t115*t234*t30*t59
              t341 = -1.565797035942429d-47*t232*t236*t237*t29*t94
              t342 = 6.710558725467552d-48*t232*t236*t237*t30
              t343 = -4.316763981605302d-46*rhoa*t236*t237*t30*t336
              t344 = -4.1727181379235395d-49*rhoa*t111*t234*t236*t237*t3
     1           0
              t345 = exp(6.000001762008792d+0*t57*t58)
              t346 = 4.316763981605302d-46*rhoa*t30*t336*t345/t60**4
              t347 = 5.890330668744274d-52*rhoa*t30*t64*(-1.671915459827
     1           618d-51*t279*t94+5.67165167526138d-50*t161*t278-7.56220
     2           2233681841d-50*t276*t277)
              t348 = -6.872052446868319d-52*t240*t29*t64*t94
              t349 = 2.945165334372137d-52*t240*t30*t64
              t350 = 7.421351600392256d-2*t119*t240*t64
              t351 = 1.1367384584869454d-49*rhoa*t111*t120*t240*t30*t59
              t352 = -4.420649560782565d-50*t111*t119*t120*t29*t59*t94
              t353 = 1.894564097478242d-50*t111*t119*t120*t30*t59
              t354 = -3.6562019906621757d-48*rhoa*t119*t120*t232*t30*t59
              t355 = 4.7740023735758397d+0*t111*t120*t242*t59
              t356 = 3.1112522343732807d-97*t120*t336*t36*t59
              t357 = 1.0968605971986528d-47*rhoa*t119*t232*t237*t246*t30
              t358 = -2.800127010935952d-96*t237*t246*t336*t36
              t359 = 1/t60**5.0d+0
              t360 = -3.1250000000000006d-2*t50*(1.5545345434827443d-2*t
     1           93*(-1.3117416404252039d-49*t162*t39*t94*t99+1.21083843
     2           73155726d-49*t100*t103*t29*t94*t99+2.118967265302252d-4
     3           9*t161*t39*t75*t99+5.189307588495311d-50*rhoa*t178*t179
     4           *t30*t99-2.5946537942476555d-50*rhoa*t100*t177*t30*t99-
     5           5.189307588495311d-50*t100*t103*t30*t99-8.6488459808255
     6           18d-51*rhoa*t100*t30*t35*(1.4960507360008343d-100*rhoa*
     7           t30*t37*(-8.425925925925931d-1*t279*t94+2.8583333333333
     8           34d+1*t161*t278-3.8111111111111123d+1*t276*t277)-4.4911
     9           000084281655d-98*t101*t102*t29*t31*t92*t94-3.4907850506
     :           686133d-100*t175*t29*t37*t94-1.8572348435793182d-96*t10
     ;           2*t160*t31*t36*t92+5.571704530737954d-96*t160*t164*t174
     <           *t36*t92+5.774271439407641d-98*rhoa*t102*t175*t30*t31*t
     =           92+1.9247571464692137d-98*t101*t102*t30*t31*t92+3.84951
     >           42929384274d-98*t102*t176*t31*t92+1.4960507360008343d-1
     ?           00*t175*t30*t37+2.9921014720016686d-100*t101*t175*t37+4
     @           .7788834319973644d-94*t280*t281*t36/t32**5.0d+0+3.98240
     1           2859997804d-95*t102*t280*t31*t36+9.623785732346068d-99*
     2           t102*t275*t31*t36-3.584162573998023d-94*t164*t174*t280*
     3           t36-3.7144696871586363d-96*rhoa*t101*t102*t163*t30*t31+
     4           5.774271439407641d-98*rhoa*t101*t102*t160*t30*t31+1.114
     5           3409061475908d-95*rhoa*t101*t163*t164*t174*t30+t298+t29
     6           7+t296+t295+t294+t293+t292+t291+t290+t289+t288+t287+t28
     7           6+t285+t284+t283+t282)-7.287453557917802d-51*t279*t35*t
     8           39*t94-6.054192186577863d-50*t173*t29*t39*t94-1.2108384
     9           373155726d-49*t178*t179*t29*t35*t94+6.054192186577863d-
     :           50*t100*t177*t29*t35*t94+1.3117416404252039d-49*t100*t1
     ;           03*t162*t35*t94-2.118967265302252d-49*t100*t103*t161*t3
     <           5*t75+2.472128476185961d-49*t161*t278*t35*t39-3.2961713
     =           01581281d-49*t276*t277*t35*t39+8.648845980825518d-51*rh
     >           oa*(t298+t297+t296+t295+t294+t293+t292+t291+t290+t289+t
     ?           288+t287+t286+t285+t284+t283+t282)*t30*t39+2.5946537942
     @           476555d-50*t173*t30*t39-5.189307588495311d-50*rhoa*t103
     1           **3*t30*t35/t38**4+5.189307588495311d-50*t178*t179*t30*
     2           t35+5.189307588495311d-50*rhoa*t103*t177*t178*t30*t35-2
     3           .5946537942476555d-50*t100*t177*t30*t35-2.5946537942476
     4           555d-50*rhoa*t100*t103*t173*t30)+3.1090690869654886d-2*
     5           t104**3/t40**3+1.0d+0*t275-4.6636036304482326d-2*t104*t
     6           180*t181)+t51*(3.109069086965489d-2*t112*(-1.0685929495
     7           985227d-51*t279*t63*t66*t94-7.567740233222326d-51*t239*
     8           t29*t66*t94-8.198385252657522d-51*t117*t162*t66*t94+7.5
     9           67740233222326d-51*t118*t247*t29*t63*t94-1.513548046644
     :           4654d-50*t224*t225*t29*t63*t94+8.198385252657522d-51*t1
     ;           18*t121*t162*t63*t94+1.5135480466444654d-50*t117*t118*t
     <           121*t29*t94-3.603685825343967d-52*t192*t30*t63*t66+2.16
     =           2211495206379d-51*rhoa*t30*(t346+t344+t343+t342+t341+t3
     >           40+t339+t337+t335+t334+t333+t332+t331+t330+t329+t328+t3
     ?           27+t326+t325)*t66+3.2433172428095686d-51*t239*t30*t66+7
     @           .207371650687928d-52*t117*t134*t30*t66-2.16221149520637
     1           9d-51*rhoa*t118*t30*t63*(-3.1167723666684033d-102*t305*
     2           t36*t64+3.926887112496181d-52*t119*t134*t30*t64-9.35031
     3           7100005209d-102*t120*t338*t36*t59+9.022299124074433d-10
     4           0*t111*t120*t234*t36*t59+2.004955360905429d-100*t111*t1
     5           20*t192*t36*t59-3.5341984012465644d-51*rhoa*t119*t120*t
     6           234*t30*t59+3.7335026812479366d-96*t336*t345*t359*t36-2
     7           .70668973722233d-99*t111*t234*t237*t246*t36+t358+t357+t
     8           356+t355+t354+t353+t352+t351+t350+t349+t348+t347+t346+t
     9           344+t343+t342+t341+t340+t339+t337+t335+t334+t333+t332+t
     :           331+t330+t329+t328+t327+t326+t325)+1.2973268971238275d-
     ;           50*rhoa*t121*t224*t247*t30*t63-3.2433172428095686d-51*t
     <           118*t247*t30*t63-7.207371650687928d-52*t118*t121*t134*t
     =           30*t63+t324+t323+t322+t321+t320+t319+t318+t317-6.486634
     >           485619137d-51*rhoa*t117*t118*t247*t30-6.486634485619137
     ?           d-51*rhoa*t118*t121*t239*t30)+1.5545345434827446d-2*t30
     @           5*t68+t316+1.0d+0*t315-9.327207260896466d-2*t122*t215*t
     1           248-1.5545345434827443d-2*t112*t122*t192)+(-8.15625d-2*
     2           t305*t49+t306-1.3250000000000003d-1*t127*t304-3.2625000
     3           00000001d-1*t126*t127*t192+1.9875000000000004d+0*t126*t
     4           185*t191)*t69+4.687500000000001d-2*t105*t192*t50-4.6875
     5           00000000001d-2*t134*t182*t50-6.250000000000001d-2*t41*(
     6           -1.305d+0*t305*t49-2.1200000000000002d+0*t127*t304+t301
     7           -5.22d+0*t126*t127*t192+3.18d+1*t126*t185*t191)-3.97500
     8           0000000001d-1*t126*t127*t249+3*t123*t195-9.375000000000
     9           002d-2*t105*t193+1.9875000000000007d-1*t126*t127*t182+1
     :           .9875000000000007d-1*t105*t126*t127*t134
              t361 = 2.902352553914842d-52*t302*t47+t303+3.0648842969340
     1           76d-50*t187*t302+1.5479213620879162d-51*t124*t302
              t362 = t314+t313+t312+t311+t310-2.4999999999999994d-1*t192
     1           *t309+t308+t307+8.44345d-3*t202*t203*t305
              t363 = 5.255375161959935d-53*t279*t61*t94
              t364 = 1.2012286084479885d-52*t192*t30*t61
              t365 = 4.2596497657969457d-49*t111*t115*t161*t59*t75
              t366 = 5.045160155481551d-51*t115*t256*t29*t59*t94
              t367 = 2.5225800777407753d-51*t115*t234*t29*t59*t94
              t368 = -3.3552793627337757d-48*t115*t232*t30*t59
              t369 = -7.727255810969519d-51*t111*t115*t134*t30*t59
              t370 = -2.162211495206379d-51*t115*t256*t30*t59
              t371 = -1.0811057476031895d-51*t115*t234*t30*t59
              t372 = 3.333334312227107d-1*t305*t57*t58-3.216396844291483
     1           d+1*t362+5.360661407152473d+0*t111*t192
              t373 = -2.162211495206379d-51*rhoa*t115*t30*t372*t59
              t374 = 1.3909060459745132d-49*rhoa*t111*t115*t256*t30*t59
              t375 = 6.954530229872565d-50*rhoa*t111*t115*t234*t30*t59
              t376 = 6.710558725467551d-48*t232*t236*t237*t30
              t377 = -2.7818120919490263d-49*rhoa*t111*t236*t237*t256*t3
     1           0
              t378 = -1.3909060459745132d-49*rhoa*t111*t234*t236*t237*t3
     1           0
              t379 = t51*(3.109069086965489d-2*t112*(5.255375161959935d-
     1           53*t279*t63*t66*t94-5.045160155481551d-51*t258*t29*t66*
     2           t94-2.5225800777407753d-51*t239*t29*t66*t94-8.198385252
     3           657521d-51*t117*t162*t66*t94+5.045160155481551d-51*t118
     4           *t259*t29*t63*t94+2.5225800777407753d-51*t118*t247*t29*
     5           t63*t94-1.513548046644465d-50*t224*t225*t29*t63*t94+8.1
     6           98385252657521d-51*t118*t121*t162*t63*t94+1.51354804664
     7           4465d-50*t117*t118*t121*t29*t94+1.2012286084479885d-52*
     8           t192*t30*t63*t66+2.162211495206379d-51*rhoa*t30*(t378+t
     9           377+t376+t375+t374+t373+t371+t370+t369+t368+t367+t366+t
     :           365+t364+t363+t346+t343+t341+t337+t331+t330+t326+t325)*
     ;           t66+2.162211495206379d-51*t258*t30*t66+1.08110574760318
     <           95d-51*t239*t30*t66-2.402457216895977d-52*t117*t134*t30
     =           *t66-2.162211495206379d-51*rhoa*t118*t30*t63*(1.0389241
     >           222228011d-102*t305*t36*t64-1.3089623708320608d-52*t119
     ?           *t134*t30*t64-9.350317100005209d-102*t120*t36*t372*t59+
     @           6.014866082716289d-100*t111*t120*t256*t36*t59+3.0074330
     1           413581446d-100*t111*t120*t234*t36*t59-6.683184536351433
     2           d-101*t111*t120*t192*t36*t59-2.3561322674977095d-51*rho
     3           a*t119*t120*t256*t30*t59-1.1780661337488549d-51*rhoa*t1
     4           19*t120*t234*t30*t59+t378+t377+t376+t375+t374+t373+t371
     5           +t370+t369+t368+t367+t366+t365+t364+t363+3.733502681247
     6           936d-96*t336*t345*t359*t36-1.8044598248148866d-99*t111*
     7           t237*t246*t256*t36-9.022299124074433d-100*t111*t234*t23
     8           7*t246*t36+t358+t357+t356+t355+t354+t353+t352+t351+t350
     9           +t349+t348+t347+t346+t343+t341+t337+t331+t330+t326+t325
     :           )+8.648845980825516d-51*rhoa*t121*t224*t259*t30*t63-2.1
     ;           62211495206379d-51*t118*t259*t30*t63+4.324422990412758d
     <           -51*rhoa*t121*t224*t247*t30*t63-1.0811057476031895d-51*
     =           t118*t247*t30*t63+2.402457216895977d-52*t118*t121*t134*
     >           t30*t63+t324+t323+t322+t321+t320+t319+t318+t317-4.32442
     ?           2990412758d-51*rhoa*t117*t118*t259*t30-4.32442299041275
     @           8d-51*rhoa*t118*t121*t258*t30-2.162211495206379d-51*rho
     1           a*t117*t118*t247*t30-2.162211495206379d-51*rhoa*t118*t1
     2           21*t239*t30)-5.18178181160915d-3*t305*t68+1.0d+0*t362+t
     3           316-6.218138173930978d-2*t122*t215*t260-3.1090690869654
     4           89d-2*t122*t215*t248+5.181781811609149d-3*t112*t122*t19
     5           2)+(2.718750000000001d-2*t305*t49-1.3250000000000003d-1
     6           *t127*t361+t306+1.3250000000000006d+0*t126*t185*t251+1.
     7           0875000000000003d-1*t126*t127*t192+6.625000000000003d-1
     8           *t126*t185*t191)*t69+3.469446951953614d-18*t305*t41*t50
     9           -1.5625000000000003d-2*t105*t192*t50+1.5625000000000003
     :           d-2*t134*t182*t50-6.250000000000001d-2*t41*(4.35d-1*t30
     ;           5*t49-2.1200000000000002d+0*t127*t361+t301+2.1200000000
     <           000002d+1*t126*t185*t251+1.74d+0*t126*t127*t192+1.06000
     =           00000000001d+1*t126*t185*t191)-2.6500000000000007d-1*t1
     >           26*t127*t261+2*t123*t253-6.250000000000001d-2*t105*t252
     ?           -1.3250000000000003d-1*t126*t127*t249+t123*t195-3.12500
     @           00000000006d-2*t105*t193+6.625000000000002d-2*t126*t127
     1           *t182-6.625000000000002d-2*t105*t126*t127*t134
              fnc(iq) = 2.0d+0*rhoa*(4.375d-2*t46+1.0d+0)*t46*wght+fnc(i
     1           q)
              Amat(iq,D1_RA) = 1.0d+0*t70*t71*wght+2.0d+0*rhoa*t128*t71*
     1           wght+8.750000000000002d-2*rhoa*t128*t70*wght+Amat(iq,D1
     2           _RA)
              Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)
              Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
              Mmat(iq,D1_TA) = Mmat(iq,D1_TA)
              Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t250*t71*wght+8.750000000
     1           000002d-2*rhoa*t250*t70*wght+t132+t131+t130+Amat2(iq,D2
     2           _RA_RA)
              Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t262*t71*wght+8.750000000
     1           000002d-2*rhoa*t262*t70*wght+t132+t131+t130+Amat2(iq,D2
     2           _RA_RB)
              Cmat2(iq,D2_RA_GAA) = Cmat2(iq,D2_RA_GAA)
              Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
              Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
              Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)
              Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
              Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
              Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
              Mmat2(iq,D2_RA_TA) = Mmat2(iq,D2_RA_TA)
              Mmat2(iq,D2_RA_TB) = Mmat2(iq,D2_RA_TB)
              Mmat2(iq,D2_GAA_TA) = Mmat2(iq,D2_GAA_TA)
              Mmat2(iq,D2_GAA_TB) = Mmat2(iq,D2_GAA_TB)
              Mmat2(iq,D2_GAB_TA) = Mmat2(iq,D2_GAB_TA)
              Mmat2(iq,D2_TA_TA) = Mmat2(iq,D2_TA_TA)
              Mmat2(iq,D2_TA_TB) = Mmat2(iq,D2_TA_TB)
              Amat3(iq,D3_RA_RA_RA) = 2.0d+0*rhoa*t360*t71*wght+3.0d+0*t
     1           250*t71*wght+8.750000000000002d-2*rhoa*t360*t70*wght+1.
     2           3125000000000003d-1*t250*t70*wght+5.250000000000001d-1*
     3           rhoa*t128*t250*wght+t263+Amat3(iq,D3_RA_RA_RA)
              Amat3(iq,D3_RA_RA_RB) = 2.0d+0*rhoa*t379*t71*wght+2.0d+0*t
     1           262*t71*wght+1.0d+0*t250*t71*wght+8.750000000000002d-2*
     2           rhoa*t379*t70*wght+8.750000000000002d-2*t262*t70*wght+4
     3           .375000000000001d-2*t250*t70*wght+3.500000000000001d-1*
     4           rhoa*t128*t262*wght+1.7500000000000004d-1*rhoa*t128*t25
     5           0*wght+t263+Amat3(iq,D3_RA_RA_RB)
              Cmat3(iq,D3_RA_RA_GAA) = Cmat3(iq,D3_RA_RA_GAA)
              Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
              Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
              Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
              Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
              Cmat3(iq,D3_RA_GAA_GAA) = Cmat3(iq,D3_RA_GAA_GAA)
              Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
              Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
              Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
              Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
              Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
              Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)
              Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
              Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
              Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
              Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
              Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
              Mmat3(iq,D3_RA_RA_TA) = Mmat3(iq,D3_RA_RA_TA)
              Mmat3(iq,D3_RA_RA_TB) = Mmat3(iq,D3_RA_RA_TB)
              Mmat3(iq,D3_RA_RB_TA) = Mmat3(iq,D3_RA_RB_TA)
              Mmat3(iq,D3_RA_GAA_TA) = Mmat3(iq,D3_RA_GAA_TA)
              Mmat3(iq,D3_RA_GAA_TB) = Mmat3(iq,D3_RA_GAA_TB)
              Mmat3(iq,D3_RA_GAB_TA) = Mmat3(iq,D3_RA_GAB_TA)
              Mmat3(iq,D3_RA_GAB_TB) = Mmat3(iq,D3_RA_GAB_TB)
              Mmat3(iq,D3_RA_GBB_TA) = Mmat3(iq,D3_RA_GBB_TA)
              Mmat3(iq,D3_RA_GBB_TB) = Mmat3(iq,D3_RA_GBB_TB)
              Mmat3(iq,D3_GAA_GAA_TA) = Mmat3(iq,D3_GAA_GAA_TA)
              Mmat3(iq,D3_GAA_GAA_TB) = Mmat3(iq,D3_GAA_GAA_TB)
              Mmat3(iq,D3_GAA_GAB_TA) = Mmat3(iq,D3_GAA_GAB_TA)
              Mmat3(iq,D3_GAA_GAB_TB) = Mmat3(iq,D3_GAA_GAB_TB)
              Mmat3(iq,D3_GAA_GBB_TA) = Mmat3(iq,D3_GAA_GBB_TA)
              Mmat3(iq,D3_GAB_GAB_TA) = Mmat3(iq,D3_GAB_GAB_TA)
              Mmat3(iq,D3_TA_TA_TA) = Mmat3(iq,D3_TA_TA_TA)
              Mmat3(iq,D3_TA_TA_TB) = Mmat3(iq,D3_TA_TA_TB)
            endif 
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          taua    = tau(iq,T_A) 
          taub    = tau(iq,T_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            if (taua.gt.tol_rho.and.taub.gt.tol_rho) then 
              t1 = rhob+rhoa
              t2 = rhoa**3.333333333333333d-1
              t3 = t2**5.0d-1
              t4 = 1/t3
              t5 = 1.530901310039024d-2*t4+1.0465751434d-1
              t6 = 7.876233178997433d-1*t4*t5+1.9269083139d-1
              t7 = 7.876233178997433d-1*t4*t6+4.3896648423d-1
              t8 = 1/t7
              t9 = 1.269642451250142d+0*t3*t8+1.0d+0
              t10 = log(t9)
              t11 = 1/t2
              t12 = 1.2746961887000874d-1*t11+1.0d+0
              t13 = 2.4141993114533214d-2*t4+1.0186556948d-1
              t14 = 7.876233178997433d-1*t13*t4+2.2308199064d-1
              t15 = 7.876233178997433d-1*t14*t4+4.7231125998d-1
              t16 = 1/t15
              t17 = 1.269642451250142d+0*t16*t3+1.0d+0
              t18 = log(t17)
              t19 = 1.325688999052018d-1*t11+1.0d+0
              t20 = 1.3212998810398843d-2*t4+2.9729725188d-2
              t21 = 7.876233178997433d-1*t20*t4+1.2236585478d-1
              t22 = 7.876233178997433d-1*t21*t4+3.497952466d-1
              t23 = 1/t22
              t24 = 1.269642451250142d+0*t23*t3+1.0d+0
              t25 = log(t24)
              t26 = 6.901399211255826d-2*t11+1.0d+0
              t27 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t18*t19-3.10907d-2*t10*t12)-3.37738d-2*t25*t
     2           26)+3.37738d-2*t25*t26)-6.21814d-2*t18*t19
              t28 = rhoa**1.1666666666666667d+0
              t29 = 1/t28**2.0d+0
              t30 = exp(-6.432793688582967d+1*t27)
              t31 = t30-1.0d+0
              t32 = 1/t31
              t33 = 2.1622114952063792d-1*gammaaa*t29*t32
              t34 = t33+1.0d+0
              t35 = gammaaa*t29
              t36 = t35**2.0d+0
              t37 = 1/t31**2.0d+0
              t38 = 4.675158550002606d-2*t36*t37+t33+1.0d+0
              t39 = 1/t38
              t40 = 2.1622114952063792d-1*gammaaa*t29*t34*t39+1.0d+0
              t41 = 1.5545345434827443d-2*log(t40)+1.0d+0*t27
              t42 = 1/t1
              t43 = rhoa-rhob
              t44 = t42*t43
              t45 = t44**2.0d+0
              t46 = t44**4.0d+0
              t47 = 5.0d-1*t46+8.7d-1*t45+2.2599999999999998d+0*t44**6.0
     1           d+0+5.3d-1
              t48 = 1/t1**2.6666666666666666d+0
              t49 = 1.0d+0-t42*t43
              t50 = t44+1.0d+0
              t51 = 1/t50**1.333333333333333d+0+1/t49**1.333333333333333
     1           d+0
              t52 = t49**2
              t53 = t50**2
              t54 = gammabb*t53+gammaaa*t52-2.0d+0*gammaab*t49*t50
              t55 = 1.3060586492616802d-2*t48*t51*t54+1.0d+0
              t56 = 1/t55**4.0d+0
              t57 = t47*t56+1.0d+0
              t58 = gammabb+2.0d+0*gammaab+gammaaa
              t59 = taub+taua
              t60 = 1/t59
              t61 = t42*t58*t60
              t62 = t61**2.0d+0
              t63 = rhob**3.333333333333333d-1
              t64 = t63**5.0d-1
              t65 = 1/t64
              t66 = 1.530901310039024d-2*t65+1.0465751434d-1
              t67 = 7.876233178997433d-1*t65*t66+1.9269083139d-1
              t68 = 7.876233178997433d-1*t65*t67+4.3896648423d-1
              t69 = 1/t68
              t70 = 1.269642451250142d+0*t64*t69+1.0d+0
              t71 = log(t70)
              t72 = 1/t63
              t73 = 1.2746961887000874d-1*t72+1.0d+0
              t74 = 2.4141993114533214d-2*t65+1.0186556948d-1
              t75 = 7.876233178997433d-1*t65*t74+2.2308199064d-1
              t76 = 7.876233178997433d-1*t65*t75+4.7231125998d-1
              t77 = 1/t76
              t78 = 1.269642451250142d+0*t64*t77+1.0d+0
              t79 = log(t78)
              t80 = 1.325688999052018d-1*t72+1.0d+0
              t81 = 1.3212998810398843d-2*t65+2.9729725188d-2
              t82 = 7.876233178997433d-1*t65*t81+1.2236585478d-1
              t83 = 7.876233178997433d-1*t65*t82+3.497952466d-1
              t84 = 1/t83
              t85 = 1.269642451250142d+0*t64*t84+1.0d+0
              t86 = log(t85)
              t87 = 6.901399211255826d-2*t72+1.0d+0
              t88 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(
     1           6.21814d-2*t79*t80-3.10907d-2*t71*t73)-3.37738d-2*t86*t
     2           87)+3.37738d-2*t86*t87)-6.21814d-2*t79*t80
              t89 = rhob**1.1666666666666667d+0
              t90 = 1/t89**2.0d+0
              t91 = exp(-6.432793688582967d+1*t88)
              t92 = t91-1.0d+0
              t93 = 1/t92
              t94 = 2.1622114952063792d-1*gammabb*t90*t93
              t95 = t94+1.0d+0
              t96 = gammabb*t90
              t97 = t96**2.0d+0
              t98 = 1/t92**2.0d+0
              t99 = 4.675158550002606d-2*t97*t98+t94+1.0d+0
              t100 = 1/t99
              t101 = 2.1622114952063792d-1*gammabb*t100*t90*t95+1.0d+0
              t102 = 1.0d+0*t88+1.5545345434827443d-2*log(t101)
              t103 = t1**3.333333333333333d-1
              t104 = 1/t103
              t105 = 1.325688999052018d-1*t104+1.0d+0
              t106 = t103**5.0d-1
              t107 = 1/t106
              t108 = 2.4141993114533214d-2*t107+1.0186556948d-1
              t109 = 7.876233178997433d-1*t107*t108+2.2308199064d-1
              t110 = 7.876233178997433d-1*t107*t109+4.7231125998d-1
              t111 = 1/t110
              t112 = 1.269642451250142d+0*t106*t111+1.0d+0
              t113 = log(t112)
              t114 = t49**1.3333333333333333d+0
              t115 = t50**1.3333333333333333d+0
              t116 = 1.923661050931536d+0*t115+1.923661050931536d+0*t114
     1           -3.847322101863072d+0
              t117 = 6.901399211255826d-2*t104+1.0d+0
              t118 = 1.3212998810398843d-2*t107+2.9729725188d-2
              t119 = 7.876233178997433d-1*t107*t118+1.2236585478d-1
              t120 = 7.876233178997433d-1*t107*t119+3.497952466d-1
              t121 = 1/t120
              t122 = 1.269642451250142d+0*t106*t121+1.0d+0
              t123 = log(t122)
              t124 = t43**4
              t125 = 1/t1**4
              t126 = 1.2746961887000874d-1*t104+1.0d+0
              t127 = 1.530901310039024d-2*t107+1.0465751434d-1
              t128 = 7.876233178997433d-1*t107*t127+1.9269083139d-1
              t129 = 7.876233178997433d-1*t107*t128+4.3896648423d-1
              t130 = 1/t129
              t131 = 1.269642451250142d+0*t106*t130+1.0d+0
              t132 = log(t131)
              t133 = 1.709920934161365d+0*(6.21814d-2*t105*t113-3.10907d
     1           -2*t126*t132)-3.37738d-2*t117*t123
              t134 = t124*t125*t133+3.37738d-2*t117*t123
              t135 = 5.848223622634648d-1*t116*t134-6.21814d-2*t105*t113
              t136 = t49**6.666666666666666d-1
              t137 = t50**6.666666666666666d-1
              t138 = 5.0d-1*t137+5.0d-1*t136
              t139 = t138**3.0d+0
              t140 = t1**1.1666666666666667d+0
              t141 = 1/t140**2.0d+0
              t142 = t138**2.0d+0
              t143 = 1/t142
              t144 = 1/t139
              t145 = exp(-3.216396844291483d+1*t135*t144)
              t146 = t145-1.0d+0
              t147 = 1/t146
              t148 = 1.3621078885675922d-1*t141*t143*t147*t58
              t149 = t148+1.0d+0
              t150 = 1/t138**4.0d+0
              t151 = t141*t58
              t152 = t151**2.0d+0
              t153 = 1/t146**2.0d+0
              t154 = 1.855337900098064d-2*t150*t152*t153+t148+1.0d+0
              t155 = 1/t154
              t156 = 1.3621078885675922d-1*t141*t143*t149*t155*t58+1.0d+
     1           0
              t157 = log(t156)
              t158 = 3.109069086965489d-2*t139*t157+1.0d+0*t135
              t159 = 1.5625d-2*t47*t56*t62+1.0d+0
              t160 = -1.5625d-2*rhoa*t41*t42*t57*t62-1.5625d-2*rhob*t102
     1           *t42*t57*t62+t158*t159
              t161 = t61**3.0d+0
              t162 = 5.46875d-3*t160*t161+1.0d+0
              t163 = 1/t1**3
              t164 = 3.125d-2*rhoa*t163*t41*t57*t58*t60*t61
              t165 = 3.125d-2*rhob*t102*t163*t57*t58*t60*t61
              t166 = 1/t1**2
              t167 = t166*t43
              t168 = -t42
              t169 = t168+t167
              t170 = -t166*t43
              t171 = t42+t170
              t172 = 2*gammabb*t171*t50-2.0d+0*gammaab*t169*t50-2.0d+0*g
     1           ammaab*t171*t49+2*gammaaa*t169*t49
              t173 = 1/t49**2.333333333333333d+0
              t174 = 1/t50**2.333333333333333d+0
              t175 = -1.333333333333333d+0*t171*t174-1.333333333333333d+
     1           0*t169*t173
              t176 = 1/t1**3.6666666666666664d+0
              t177 = -3.482823064697814d-2*t176*t51*t54
              t178 = 1.3060586492616802d-2*t175*t48*t54+1.30605864926168
     1           02d-2*t172*t48*t51+t177
              t179 = 1/t55**5.0d+0
              t180 = t44**3.0d+0
              t181 = t44**5.0d+0
              t182 = 1.74d+0*t171*t44+1.356d+1*t171*t181+2.0d+0*t171*t18
     1           0
              t183 = t182*t56-4.0d+0*t178*t179*t47
              t184 = 1.5625d-2*rhoa*t166*t41*t57*t62
              t185 = 1/rhoa**1.3333333333333333d+0
              t186 = 1/t9
              t187 = 1/t7**2
              t188 = 1/rhoa**1.3333333333333336d+0
              t189 = 1/t3**3
              t190 = 1/rhoa**6.666666666666667d-1
              t191 = -1.3127055298329054d-1*t189*t190*t5-2.0096226153166
     1           658d-3*t188
              t192 = 7.876233178997433d-1*t191*t4-1.3127055298329054d-1*
     1           t189*t190*t6
              t193 = 2.11607075208357d-1*t190*t4*t8-1.269642451250142d+0
     1           *t187*t192*t3
              t194 = 1/t17
              t195 = 1/t15**2
              t196 = -1.3127055298329054d-1*t13*t189*t190-3.169132786263
     1           567d-3*t188
              t197 = 7.876233178997433d-1*t196*t4-1.3127055298329054d-1*
     1           t14*t189*t190
              t198 = 2.11607075208357d-1*t16*t190*t4-1.269642451250142d+
     1           0*t195*t197*t3
              t199 = 1/t24
              t200 = 1/t22**2
              t201 = -1.3127055298329054d-1*t189*t190*t20-1.734477660408
     1           6162d-3*t188
              t202 = 7.876233178997433d-1*t201*t4-1.3127055298329054d-1*
     1           t189*t190*t21
              t203 = 2.11607075208357d-1*t190*t23*t4-1.269642451250142d+
     1           0*t200*t202*t3
              t204 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t199*t203
     1           *t26+7.769549222703733d-4*t185*t25+1.709920934161365d+0
     2           *(6.21814d-2*t19*t194*t198-3.10907d-2*t12*t186*t193-2.7
     3           47773264188438d-3*t18*t185+1.3210398931339265d-3*t10*t1
     4           85))+3.37738d-2*t199*t203*t26-7.769549222703733d-4*t185
     5           *t25)-6.21814d-2*t19*t194*t198+2.747773264188438d-3*t18
     6           *t185
              t205 = 1/t40
              t206 = rhoa**1.6666666666666674d-1
              t207 = 1/t28**3.0d+0
              t208 = -5.045160155481552d-1*gammaaa*t206*t207*t32
              t209 = 1/t31**2
              t210 = 1.3909060459745137d+1*gammaaa*t204*t209*t29*t30
              t211 = t210+t208
              t212 = 1/t38**2
              t213 = 1/t31**3.0d+0
              t214 = -2.181740656667883d-1*gammaaa*t206*t207*t35*t37+6.0
     1           14866082716293d+0*t204*t213*t30*t36+t210+t208
              t215 = -5.045160155481552d-1*gammaaa*t206*t207*t34*t39+2.1
     1           622114952063792d-1*gammaaa*t211*t29*t39-2.1622114952063
     2           792d-1*gammaaa*t212*t214*t29*t34
              t216 = 1.5545345434827443d-2*t205*t215+1.0d+0*t204
              t217 = 1.5625d-2*rhob*t102*t166*t57*t62
              t218 = -3.125d-2*t166*t47*t56*t58*t60*t61
              t219 = 1.5625d-2*t182*t56*t62-6.25d-2*t178*t179*t47*t62+t2
     1           18
              t220 = 1/t1**1.3333333333333336d+0
              t221 = 1/t1**6.666666666666667d-1
              t222 = 1/t106**3
              t223 = -1.3127055298329054d-1*t108*t221*t222-3.16913278626
     1           3567d-3*t220
              t224 = 7.876233178997433d-1*t107*t223-1.3127055298329054d-
     1           1*t109*t221*t222
              t225 = 1/t110**2
              t226 = 2.11607075208357d-1*t107*t111*t221-1.26964245125014
     1           2d+0*t106*t224*t225
              t227 = 1/t112
              t228 = -6.21814d-2*t105*t226*t227
              t229 = 1/t1**1.3333333333333333d+0
              t230 = 2.747773264188438d-3*t113*t229
              t231 = -1.3127055298329054d-1*t118*t221*t222-1.73447766040
     1           86162d-3*t220
              t232 = 7.876233178997433d-1*t107*t231-1.3127055298329054d-
     1           1*t119*t221*t222
              t233 = 1/t120**2
              t234 = 2.11607075208357d-1*t107*t121*t221-1.26964245125014
     1           2d+0*t106*t232*t233
              t235 = 1/t122
              t236 = 3.37738d-2*t117*t234*t235
              t237 = -7.769549222703733d-4*t123*t229
              t238 = -1.3127055298329054d-1*t127*t221*t222-2.00962261531
     1           66658d-3*t220
              t239 = 7.876233178997433d-1*t107*t238-1.3127055298329054d-
     1           1*t128*t221*t222
              t240 = 1/t129**2
              t241 = 2.11607075208357d-1*t107*t130*t221-1.26964245125014
     1           2d+0*t106*t239*t240
              t242 = 1/t131
              t243 = 1.709920934161365d+0*(-3.10907d-2*t126*t241*t242+1.
     1           3210398931339265d-3*t132*t229-2.747773264188438d-3*t113
     2           *t229+6.21814d-2*t105*t226*t227)-3.37738d-2*t117*t234*t
     3           235+7.769549222703733d-4*t123*t229
              t244 = t124*t125*t243
              t245 = 1/t1**5
              t246 = -4*t124*t133*t245
              t247 = t43**3
              t248 = 4*t125*t133*t247+t246+t244+t237+t236
              t249 = t49**3.333333333333333d-1
              t250 = t50**3.333333333333333d-1
              t251 = 2.564881401242048d+0*t171*t250+2.564881401242048d+0
     1           *t169*t249
              t252 = 5.848223622634648d-1*t134*t251+5.848223622634648d-1
     1           *t116*t248+t230+t228
              t253 = 1/t156
              t254 = 1/t249
              t255 = 1/t250
              t256 = 3.333333333333333d-1*t171*t255+3.333333333333333d-1
     1           *t169*t254
              t257 = t1**1.6666666666666674d-1
              t258 = 1/t140**3.0d+0
              t259 = -3.1782517399910487d-1*t143*t149*t155*t257*t258*t58
              t260 = -2.7242157771351844d-1*t141*t144*t147*t256*t58
              t261 = -3.1782517399910487d-1*t143*t147*t257*t258*t58
              t262 = 1/t146**2
              t263 = 9.649190532874448d+1*t135*t150*t256-3.2163968442914
     1           83d+1*t144*t252
              t264 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t58
              t265 = t264+t261+t260
              t266 = 1/t154**2
              t267 = -8.658243533790966d-2*t150*t151*t153*t257*t258*t58
              t268 = 1/t138**5.0d+0
              t269 = 1/t146**3.0d+0
              t270 = -3.710675800196128d-2*t145*t150*t152*t263*t269-7.42
     1           1351600392256d-2*t152*t153*t256*t268+t267+t264+t261+t26
     2           0
              t271 = -1.3621078885675922d-1*t141*t143*t149*t266*t270*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t265*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t256*t58+t259
              t272 = 3.109069086965489d-2*t139*t253*t271+9.3272072608964
     1           66d-2*t142*t157*t256+1.0d+0*t252
              t273 = -1.5625d-2*t41*t42*t57*t62-1.5625d-2*rhoa*t216*t42*
     1           t57*t62-1.5625d-2*rhoa*t183*t41*t42*t62-1.5625d-2*rhob*
     2           t102*t183*t42*t62+t159*t272+t158*t219+t217+t184+t165+t1
     3           64
              t274 = -1.6406249999999997d-2*t160*t166*t58*t60*t62
              t275 = t274+5.46875d-3*t161*t273
              t276 = 1.0d+0*t160*t162*wght
              t277 = t170+t168
              t278 = t42+t167
              t279 = -2.0d+0*gammaab*t278*t50+2*gammabb*t277*t50+2*gamma
     1           aa*t278*t49-2.0d+0*gammaab*t277*t49
              t280 = -1.333333333333333d+0*t173*t278-1.333333333333333d+
     1           0*t174*t277
              t281 = 1.3060586492616802d-2*t280*t48*t54+1.30605864926168
     1           02d-2*t279*t48*t51+t177
              t282 = 1.74d+0*t277*t44+1.356d+1*t181*t277+2.0d+0*t180*t27
     1           7
              t283 = t282*t56-4.0d+0*t179*t281*t47
              t284 = 1/rhob**1.3333333333333333d+0
              t285 = 1/t70
              t286 = 1/t68**2
              t287 = 1/rhob**1.3333333333333336d+0
              t288 = 1/t64**3
              t289 = 1/rhob**6.666666666666667d-1
              t290 = -1.3127055298329054d-1*t288*t289*t66-2.009622615316
     1           6658d-3*t287
              t291 = 7.876233178997433d-1*t290*t65-1.3127055298329054d-1
     1           *t288*t289*t67
              t292 = 2.11607075208357d-1*t289*t65*t69-1.269642451250142d
     1           +0*t286*t291*t64
              t293 = 1/t78
              t294 = 1/t76**2
              t295 = -1.3127055298329054d-1*t288*t289*t74-3.169132786263
     1           567d-3*t287
              t296 = 7.876233178997433d-1*t295*t65-1.3127055298329054d-1
     1           *t288*t289*t75
              t297 = 2.11607075208357d-1*t289*t65*t77-1.269642451250142d
     1           +0*t294*t296*t64
              t298 = 1/t85
              t299 = 1/t83**2
              t300 = -1.3127055298329054d-1*t288*t289*t81-1.734477660408
     1           6162d-3*t287
              t301 = 7.876233178997433d-1*t300*t65-1.3127055298329054d-1
     1           *t288*t289*t82
              t302 = 2.11607075208357d-1*t289*t65*t84-1.269642451250142d
     1           +0*t299*t301*t64
              t303 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t298*t302
     1           *t87+7.769549222703733d-4*t284*t86+1.709920934161365d+0
     2           *(6.21814d-2*t293*t297*t80-2.747773264188438d-3*t284*t7
     3           9-3.10907d-2*t285*t292*t73+1.3210398931339265d-3*t284*t
     4           71))+3.37738d-2*t298*t302*t87-7.769549222703733d-4*t284
     5           *t86)-6.21814d-2*t293*t297*t80+2.747773264188438d-3*t28
     6           4*t79
              t304 = 1/t101
              t305 = rhob**1.6666666666666674d-1
              t306 = 1/t89**3.0d+0
              t307 = -5.045160155481552d-1*gammabb*t305*t306*t93
              t308 = 1/t92**2
              t309 = 1.3909060459745137d+1*gammabb*t303*t308*t90*t91
              t310 = t309+t307
              t311 = 1/t99**2
              t312 = 1/t92**3.0d+0
              t313 = -2.181740656667883d-1*gammabb*t305*t306*t96*t98+6.0
     1           14866082716293d+0*t303*t312*t91*t97+t309+t307
              t314 = -2.1622114952063792d-1*gammabb*t311*t313*t90*t95-5.
     1           045160155481552d-1*gammabb*t100*t305*t306*t95+2.1622114
     2           952063792d-1*gammabb*t100*t310*t90
              t315 = 1.5545345434827443d-2*t304*t314+1.0d+0*t303
              t316 = 1.5625d-2*t282*t56*t62-6.25d-2*t179*t281*t47*t62+t2
     1           18
              t317 = -4*t125*t133*t247+t246+t244+t237+t236
              t318 = 2.564881401242048d+0*t249*t278+2.564881401242048d+0
     1           *t250*t277
              t319 = 5.848223622634648d-1*t134*t318+5.848223622634648d-1
     1           *t116*t317+t230+t228
              t320 = 3.333333333333333d-1*t254*t278+3.333333333333333d-1
     1           *t255*t277
              t321 = -2.7242157771351844d-1*t141*t144*t147*t320*t58
              t322 = 9.649190532874448d+1*t135*t150*t320-3.2163968442914
     1           83d+1*t144*t319
              t323 = -1.3621078885675922d-1*t141*t143*t145*t262*t322*t58
              t324 = t323+t321+t261
              t325 = t323-3.710675800196128d-2*t145*t150*t152*t269*t322+
     1           t321-7.421351600392256d-2*t152*t153*t268*t320+t267+t261
              t326 = -1.3621078885675922d-1*t141*t143*t149*t266*t325*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t324*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t320*t58+t259
              t327 = 3.109069086965489d-2*t139*t253*t326+9.3272072608964
     1           66d-2*t142*t157*t320+1.0d+0*t319
              t328 = -1.5625d-2*rhob*t315*t42*t57*t62-1.5625d-2*t102*t42
     1           *t57*t62-1.5625d-2*rhoa*t283*t41*t42*t62-1.5625d-2*rhob
     2           *t102*t283*t42*t62+t159*t327+t158*t316+t217+t184+t165+t
     3           164
              t329 = 5.46875d-3*t161*t328+t274
              t330 = -3.125d-2*rhoa*t166*t41*t57*t60*t61
              t331 = -3.125d-2*rhob*t102*t166*t57*t60*t61
              t332 = 9.350317100005212d-2*t29*t35*t37+2.1622114952063792
     1           d-1*t29*t32
              t333 = 1/t28**4.0d+0
              t334 = 2.1622114952063792d-1*t29*t34*t39+4.675158550002606
     1           d-2*gammaaa*t32*t333*t39-2.1622114952063792d-1*gammaaa*
     2           t212*t29*t332*t34
              t335 = 3.125d-2*t42*t47*t56*t60*t61
              t336 = t335-8.162866557885502d-4*t179*t47*t48*t51*t52*t62
              t337 = 3.710675800196128d-2*t141*t150*t151*t153+1.36210788
     1           85675922d-1*t141*t143*t147
              t338 = 1/t140**4.0d+0
              t339 = 1.855337900098064d-2*t147*t150*t155*t338*t58-1.3621
     1           078885675922d-1*t141*t143*t149*t266*t337*t58+1.36210788
     2           85675922d-1*t141*t143*t149*t155
              t340 = 3.109069086965489d-2*t139*t159*t253*t339
              t341 = -2.4289602241917876d-4*rhoa*t205*t334*t42*t57*t62+8
     1           .162866557885502d-4*rhoa*t176*t179*t41*t47*t51*t52*t62+
     2           8.162866557885502d-4*rhob*t102*t176*t179*t47*t51*t52*t6
     3           2+t340+t158*t336+t331+t330
              t342 = 1.6406249999999997d-2*t160*t42*t60*t62
              t343 = t342+5.46875d-3*t161*t341
              t344 = 1.6325733115771002d-3*t179*t47*t48*t49*t50*t51*t62+
     1           6.25d-2*t42*t47*t56*t60*t61
              t345 = 7.421351600392256d-2*t141*t150*t151*t153+2.72421577
     1           71351844d-1*t141*t143*t147
              t346 = -1.3621078885675922d-1*t141*t143*t149*t266*t345*t58
     1           +3.710675800196128d-2*t147*t150*t155*t338*t58+2.7242157
     2           771351844d-1*t141*t143*t149*t155
              t347 = -1.6325733115771002d-3*rhoa*t176*t179*t41*t47*t49*t
     1           50*t51*t62-1.6325733115771002d-3*rhob*t102*t176*t179*t4
     2           7*t49*t50*t51*t62-6.25d-2*rhoa*t166*t41*t57*t60*t61-6.2
     3           5d-2*rhob*t102*t166*t57*t60*t61+3.109069086965489d-2*t1
     4           39*t159*t253*t346+t158*t344
              t348 = 3.2812499999999994d-2*t160*t42*t60*t62+5.46875d-3*t
     1           161*t347
              t349 = 9.350317100005212d-2*t90*t96*t98+2.1622114952063792
     1           d-1*t90*t93
              t350 = 1/t89**4.0d+0
              t351 = -2.1622114952063792d-1*gammabb*t311*t349*t90*t95+2.
     1           1622114952063792d-1*t100*t90*t95+4.675158550002606d-2*g
     2           ammabb*t100*t350*t93
              t352 = t335-8.162866557885502d-4*t179*t47*t48*t51*t53*t62
              t353 = -2.4289602241917876d-4*rhob*t304*t351*t42*t57*t62+8
     1           .162866557885502d-4*rhoa*t176*t179*t41*t47*t51*t53*t62+
     2           8.162866557885502d-4*rhob*t102*t176*t179*t47*t51*t53*t6
     3           2+t158*t352+t340+t331+t330
              t354 = 5.46875d-3*t161*t353+t342
              t355 = 1/t59**2
              t356 = 3.125d-2*rhoa*t166*t355*t41*t57*t58*t61+3.125d-2*rh
     1           ob*t102*t166*t355*t57*t58*t61-3.125d-2*t158*t355*t42*t4
     2           7*t56*t58*t61
              t357 = 5.46875d-3*t161*t356-1.6406249999999997d-2*t160*t35
     1           5*t42*t58*t62
              t358 = 1.0d+0*t1*t160*t357*wght+1.0d+0*t1*t162*t356*wght
              t359 = t58**2
              t360 = -1.25d-1*rhoa*t245*t355*t359*t41*t57
              t361 = -1.25d-1*rhob*t102*t245*t355*t359*t57
              t362 = 3.125d-2*rhoa*t163*t183*t41*t58*t60*t61
              t363 = -3.125d-2*rhoa*t125*t41*t57*t58*t60*t61
              t364 = 3.125d-2*rhoa*t163*t216*t57*t58*t60*t61
              t365 = 3.125d-2*t163*t41*t57*t58*t60*t61
              t366 = 3.125d-2*rhob*t102*t163*t183*t58*t60*t61
              t367 = -3.125d-2*rhob*t102*t125*t57*t58*t60*t61
              t368 = -3.125d-2*rhoa*t163*t41*t57*t62
              t369 = 1/rhoa**2.333333333333333d+0
              t370 = 1/t9**2
              t371 = t193**2
              t372 = 1/t7**3
              t373 = t192**2
              t374 = 1/rhoa**2.3333333333333334d+0
              t375 = 1/rhoa**1.6666666666666669d+0
              t376 = 1/t3**5
              t377 = 6.563527649164527d-2*t188*t376*t5+8.751370198886037
     1           d-2*t189*t375*t5+3.0144339229749983d-3*t374
              t378 = 6.563527649164527d-2*t188*t376*t6+8.751370198886037
     1           d-2*t189*t375*t6+7.876233178997433d-1*t377*t4-2.6254110
     2           59665811d-1*t189*t190*t191
              t379 = -1.4107138347223802d-1*t375*t4*t8-3.52678458680595d
     1           -2*t188*t189*t8-4.23214150416714d-1*t187*t190*t192*t4-1
     2           .269642451250142d+0*t187*t3*t378+2.539284902500284d+0*t
     3           3*t372*t373
              t380 = 1/t17**2
              t381 = t198**2
              t382 = 1/t15**3
              t383 = t197**2
              t384 = 6.563527649164527d-2*t13*t188*t376+8.75137019888603
     1           7d-2*t13*t189*t375+4.753699179395351d-3*t374
              t385 = 7.876233178997433d-1*t384*t4+6.563527649164527d-2*t
     1           14*t188*t376+8.751370198886037d-2*t14*t189*t375-2.62541
     2           1059665811d-1*t189*t190*t196
              t386 = -1.4107138347223802d-1*t16*t375*t4-4.23214150416714
     1           d-1*t190*t195*t197*t4-1.269642451250142d+0*t195*t3*t385
     2           +2.539284902500284d+0*t3*t382*t383-3.52678458680595d-2*
     3           t16*t188*t189
              t387 = 1/t24**2
              t388 = t203**2
              t389 = 1/t22**3
              t390 = t202**2
              t391 = 6.563527649164527d-2*t188*t20*t376+8.75137019888603
     1           7d-2*t189*t20*t375+2.601716490612924d-3*t374
              t392 = 7.876233178997433d-1*t391*t4+6.563527649164527d-2*t
     1           188*t21*t376+8.751370198886037d-2*t189*t21*t375-2.62541
     2           1059665811d-1*t189*t190*t201
              t393 = -1.4107138347223802d-1*t23*t375*t4-4.23214150416714
     1           d-1*t190*t200*t202*t4-1.269642451250142d+0*t200*t3*t392
     2           +2.539284902500284d+0*t3*t389*t390-3.52678458680595d-2*
     3           t188*t189*t23
              t394 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t199*t26*
     1           t393+3.37738d-2*t26*t387*t388+1.709920934161365d+0*(6.2
     2           1814d-2*t19*t194*t386-6.21814d-2*t19*t380*t381-3.10907d
     3           -2*t12*t186*t379+3.10907d-2*t12*t370*t371+3.66369768558
     4           4584d-3*t18*t369-1.7613865241785687d-3*t10*t369-5.49554
     5           6528376876d-3*t185*t194*t198+2.642079786267853d-3*t185*
     6           t186*t193)-1.0359398963604977d-3*t25*t369+1.55390984454
     7           07465d-3*t185*t199*t203)+3.37738d-2*t199*t26*t393-3.377
     8           38d-2*t26*t387*t388+1.0359398963604977d-3*t25*t369-1.55
     9           39098445407465d-3*t185*t199*t203)-6.21814d-2*t19*t194*t
     :           386+6.21814d-2*t19*t380*t381-3.663697685584584d-3*t18*t
     ;           369+5.495546528376876d-3*t185*t194*t198
              t395 = rhoa**3.333333333333335d-1
              t396 = 1/rhoa**8.333333333333333d-1
              t397 = t204**2
              t398 = exp(-1.2865587377165935d+2*t27)
              t399 = 1/t31**3
              t400 = 1.7894823267913484d+3*gammaaa*t29*t397*t398*t399
              t401 = 1.765806054418543d+0*gammaaa*t32*t333*t395
              t402 = -8.408600259135923d-2*gammaaa*t207*t32*t396
              t403 = -6.490894881214397d+1*gammaaa*t204*t206*t207*t209*t
     1           30
              t404 = -8.947411633956742d+2*gammaaa*t209*t29*t30*t397
              t405 = 1.3909060459745137d+1*gammaaa*t209*t29*t30*t394
              t406 = t405+t404+t403+t402+t401+t400
              t407 = 1/t31**4.0d+0
              t408 = gammaaa**2
              t409 = 1/t28**6.0d+0
              t410 = 1/t28**5.0d+0
              t411 = -3.6362344277798064d-2*t37*t396*t408*t410-2.8069375
     1           05267603d+1*t204*t206*t213*t30*t408*t410+1.272682049722
     2           9316d+0*t37*t395*t408*t409+1.1607717772370736d+3*t36*t3
     3           97*t398*t407+t405+t404+t403+t402+t401+t400-3.8692392574
     4           56912d+2*t213*t30*t36*t397+6.014866082716293d+0*t213*t3
     5           0*t36*t394-2.806937505267603d+1*gammaaa*t204*t206*t207*
     6           t213*t30*t35
              t412 = 1/t38**3
              t413 = t214**2
              t414 = 4.3244229904127585d-1*gammaaa*t29*t34*t412*t413-2.1
     1           622114952063792d-1*gammaaa*t212*t29*t34*t411+2.16221149
     2           52063792d-1*gammaaa*t29*t39*t406-8.408600259135923d-2*g
     3           ammaaa*t207*t34*t39*t396+1.765806054418543d+0*gammaaa*t
     4           333*t34*t39*t395-1.0090320310963104d+0*gammaaa*t206*t20
     5           7*t211*t39+1.0090320310963104d+0*gammaaa*t206*t207*t212
     6           *t214*t34-4.3244229904127585d-1*gammaaa*t211*t212*t214*
     7           t29
              t415 = 1/t40**2
              t416 = t215**2
              t417 = -1.5545345434827443d-2*t415*t416+1.5545345434827443
     1           d-2*t205*t414+1.0d+0*t394
              t418 = t178**2
              t419 = 1/t55**6.0d+0
              t420 = 2*t163*t43
              t421 = -2*t166
              t422 = t421+t420
              t423 = -2*t163*t43
              t424 = 2*t166
              t425 = t424+t423
              t426 = t169**2
              t427 = t171**2
              t428 = -2.0d+0*gammaab*t425*t50+2*gammabb*t422*t50+2*gamma
     1           aa*t425*t49-2.0d+0*gammaab*t422*t49+2*gammabb*t427+2*ga
     2           mmaaa*t426-4.0d+0*gammaab*t169*t171
              t429 = 1/t49**3.333333333333333d+0
              t430 = 1/t50**3.333333333333333d+0
              t431 = 3.11111111111111d+0*t427*t430+3.11111111111111d+0*t
     1           426*t429-1.333333333333333d+0*t173*t425-1.3333333333333
     2           33d+0*t174*t422
              t432 = 1/t1**4.666666666666667d+0
              t433 = 1.2770351237225316d-1*t432*t51*t54
              t434 = 1.3060586492616802d-2*t431*t48*t54-6.96564612939562
     1           8d-2*t175*t176*t54+1.3060586492616802d-2*t428*t48*t51-6
     2           .965646129395628d-2*t172*t176*t51+2.6121172985233604d-2
     3           *t172*t175*t48+t433
              t435 = 6.779999999999999d+1*t427*t46+6.0d+0*t427*t45+1.74d
     1           +0*t42*t422*t43+1.74d+0*t427+1.356d+1*t181*t422+2.0d+0*
     2           t180*t422
              t436 = t435*t56-4.0d+0*t179*t434*t47+2.0d+1*t418*t419*t47-
     1           8.0d+0*t178*t179*t182
              t437 = -3.125d-2*rhob*t102*t163*t57*t62
              t438 = t226**2
              t439 = 1/t112**2
              t440 = 6.21814d-2*t105*t438*t439
              t441 = t224**2
              t442 = 1/t110**3
              t443 = 1/t1**2.3333333333333334d+0
              t444 = 1/t106**5
              t445 = 1/t1**1.6666666666666669d+0
              t446 = 8.751370198886037d-2*t108*t222*t445+6.5635276491645
     1           27d-2*t108*t220*t444+4.753699179395351d-3*t443
              t447 = 7.876233178997433d-1*t107*t446+8.751370198886037d-2
     1           *t109*t222*t445+6.563527649164527d-2*t109*t220*t444-2.6
     2           25411059665811d-1*t221*t222*t223
              t448 = -1.269642451250142d+0*t106*t225*t447-1.410713834722
     1           3802d-1*t107*t111*t445+2.539284902500284d+0*t106*t441*t
     2           442-4.23214150416714d-1*t107*t221*t224*t225-3.526784586
     3           80595d-2*t111*t220*t222
              t449 = -6.21814d-2*t105*t227*t448
              t450 = 5.495546528376876d-3*t226*t227*t229
              t451 = 1/t1**2.333333333333333d+0
              t452 = -3.663697685584584d-3*t113*t451
              t453 = t234**2
              t454 = 1/t122**2
              t455 = -3.37738d-2*t117*t453*t454
              t456 = t232**2
              t457 = 1/t120**3
              t458 = 8.751370198886037d-2*t118*t222*t445+6.5635276491645
     1           27d-2*t118*t220*t444+2.601716490612924d-3*t443
              t459 = 7.876233178997433d-1*t107*t458+8.751370198886037d-2
     1           *t119*t222*t445+6.563527649164527d-2*t119*t220*t444-2.6
     2           25411059665811d-1*t221*t222*t231
              t460 = -1.269642451250142d+0*t106*t233*t459+2.539284902500
     1           284d+0*t106*t456*t457-1.4107138347223802d-1*t107*t121*t
     2           445-4.23214150416714d-1*t107*t221*t232*t233-3.526784586
     3           80595d-2*t121*t220*t222
              t461 = 3.37738d-2*t117*t235*t460
              t462 = -1.5539098445407465d-3*t229*t234*t235
              t463 = 1.0359398963604977d-3*t123*t451
              t464 = t241**2
              t465 = 1/t131**2
              t466 = t239**2
              t467 = 1/t129**3
              t468 = 8.751370198886037d-2*t127*t222*t445+6.5635276491645
     1           27d-2*t127*t220*t444+3.0144339229749983d-3*t443
              t469 = 7.876233178997433d-1*t107*t468+8.751370198886037d-2
     1           *t128*t222*t445+6.563527649164527d-2*t128*t220*t444-2.6
     2           25411059665811d-1*t221*t222*t238
              t470 = -1.269642451250142d+0*t106*t240*t469+2.539284902500
     1           284d+0*t106*t466*t467-1.4107138347223802d-1*t107*t130*t
     2           445-4.23214150416714d-1*t107*t221*t239*t240-3.526784586
     3           80595d-2*t130*t220*t222
              t471 = 1.709920934161365d+0*(-3.10907d-2*t126*t242*t470+3.
     1           10907d-2*t126*t464*t465-1.7613865241785687d-3*t132*t451
     2           +3.663697685584584d-3*t113*t451+6.21814d-2*t105*t227*t4
     3           48-6.21814d-2*t105*t438*t439+2.642079786267853d-3*t229*
     4           t241*t242-5.495546528376876d-3*t226*t227*t229)-3.37738d
     5           -2*t117*t235*t460+3.37738d-2*t117*t453*t454-1.035939896
     6           3604977d-3*t123*t451+1.5539098445407465d-3*t229*t234*t2
     7           35
              t472 = t124*t125*t471
              t473 = -8*t124*t243*t245
              t474 = 1/t1**6
              t475 = 20*t124*t133*t474
              t476 = t43**2
              t477 = 12*t125*t133*t476
              t478 = t477+t475+t473+t472+t463+t462+t461+t455-32*t133*t24
     1           5*t247+8*t125*t243*t247
              t479 = 1/t136
              t480 = 1/t137
              t481 = 8.549604670806825d-1*t427*t480+8.549604670806825d-1
     1           *t426*t479+2.564881401242048d+0*t249*t425+2.56488140124
     2           2048d+0*t250*t422
              t482 = 5.848223622634648d-1*t134*t481+5.848223622634648d-1
     1           *t116*t478+t452+t450+t449+t440+1.1696447245269297d+0*t2
     2           48*t251
              t483 = t256**2
              t484 = 1/t114
              t485 = 1/t115
              t486 = -1.111111111111111d-1*t427*t485-1.111111111111111d-
     1           1*t426*t484+3.333333333333333d-1*t254*t425+3.3333333333
     2           33333d-1*t255*t422
              t487 = t1**3.333333333333335d-1
              t488 = 1.1123881089968671d+0*t143*t149*t155*t338*t487*t58
              t489 = 1/t1**8.333333333333333d-1
              t490 = -5.297086233318417d-2*t143*t149*t155*t258*t489*t58
              t491 = 8.172647331405554d-1*t141*t147*t150*t483*t58
              t492 = -2.7242157771351844d-1*t141*t144*t147*t486*t58
              t493 = 1.2713006959964196d+0*t144*t147*t256*t257*t258*t58
              t494 = 1.1123881089968671d+0*t143*t147*t338*t487*t58
              t495 = -5.297086233318417d-2*t143*t147*t258*t489*t58
              t496 = 9.649190532874448d+1*t135*t150*t486-3.8596762131497
     1           79d+2*t135*t268*t483-3.216396844291483d+1*t144*t482+1.9
     2           298381065748896d+2*t150*t252*t256
              t497 = -1.3621078885675922d-1*t141*t143*t145*t262*t496*t58
              t498 = 5.448431554270369d-1*t141*t144*t145*t256*t262*t263*
     1           t58
              t499 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t263*
     1           t58
              t500 = exp(-6.432793688582966d+1*t135*t144)
              t501 = 1/t146**3
              t502 = t263**2
              t503 = 2.7242157771351844d-1*t141*t143*t500*t501*t502*t58
              t504 = -1.3621078885675922d-1*t141*t143*t145*t262*t502*t58
              t505 = t504+t503+t499+t498+t497+t495+t494+t493+t492+t491
              t506 = 3.4632974135163863d-1*t151*t153*t256*t257*t258*t268
     1           *t58
              t507 = 1/t140**5.0d+0
              t508 = 1/t140**6.0d+0
              t509 = 5.050642061378063d-1*t150*t153*t359*t487*t508
              t510 = -1.4430405889651615d-2*t150*t153*t359*t489*t507
              t511 = 1/t138**6.0d+0
              t512 = 1.7316487067581932d-1*t145*t150*t151*t257*t258*t263
     1           *t269*t58
              t513 = 1/t146**4.0d+0
              t514 = 1.1132027400588385d-1*t150*t152*t500*t502*t513+t512
     1           +3.710675800196128d-1*t152*t153*t483*t511+t510+t509+1.7
     2           316487067581932d-1*t145*t150*t257*t263*t269*t359*t507+3
     3           .4632974135163863d-1*t153*t256*t257*t268*t359*t507+t506
     4           +t504+t503-3.710675800196128d-2*t145*t150*t152*t269*t50
     5           2+t499+t498+t497-3.710675800196128d-2*t145*t150*t152*t2
     6           69*t496+t495+t494+t493+t492+t491-7.421351600392256d-2*t
     7           152*t153*t268*t486+2.9685406401569026d-1*t145*t152*t256
     8           *t263*t268*t269
              t515 = 1/t154**3
              t516 = t270**2
              t517 = 2.7242157771351844d-1*t141*t143*t149*t515*t516*t58-
     1           1.3621078885675922d-1*t141*t143*t149*t266*t514*t58+1.36
     2           21078885675922d-1*t141*t143*t155*t505*t58-2.72421577713
     3           51844d-1*t141*t144*t149*t155*t486*t58+8.172647331405554
     4           d-1*t141*t149*t150*t155*t483*t58-2.7242157771351844d-1*
     5           t141*t143*t265*t266*t270*t58+6.356503479982097d-1*t143*
     6           t149*t257*t258*t266*t270*t58+5.448431554270369d-1*t141*
     7           t144*t149*t256*t266*t270*t58-6.356503479982097d-1*t143*
     8           t155*t257*t258*t265*t58-5.448431554270369d-1*t141*t144*
     9           t155*t256*t265*t58+1.2713006959964196d+0*t144*t149*t155
     :           *t256*t257*t258*t58+t490+t488
              t518 = 1/t156**2
              t519 = t271**2
              t520 = -3.109069086965489d-2*t139*t518*t519+3.109069086965
     1           489d-2*t139*t253*t517+9.327207260896466d-2*t142*t157*t4
     2           86+1.8654414521792934d-1*t138*t157*t483+1.0d+0*t482+1.8
     3           654414521792934d-1*t142*t253*t256*t271
              t521 = 9.375d-2*t125*t355*t359*t47*t56
              t522 = 1.25d-1*t166*t178*t179*t47*t58*t60*t61
              t523 = -3.125d-2*t166*t182*t56*t58*t60*t61
              t524 = 1.5625d-2*t435*t56*t62-6.25d-2*t179*t434*t47*t62+3.
     1           125d-1*t418*t419*t47*t62-1.25d-1*t178*t179*t182*t62-3.1
     2           25d-2*t163*t182*t355*t359*t56+t523+t522+t521+1.25d-1*t1
     3           63*t178*t179*t355*t359*t47
              t525 = -1.5625d-2*rhoa*t417*t42*t57*t62-3.125d-2*t216*t42*
     1           t57*t62+3.125d-2*t166*t41*t57*t62+3.125d-2*rhoa*t166*t2
     2           16*t57*t62-1.5625d-2*rhoa*t41*t42*t436*t62-1.5625d-2*rh
     3           ob*t102*t42*t436*t62-3.125d-2*t183*t41*t42*t62-3.125d-2
     4           *rhoa*t183*t216*t42*t62+3.125d-2*rhoa*t166*t183*t41*t62
     5           +3.125d-2*rhob*t102*t166*t183*t62+3.125d-2*t125*t355*t3
     6           59*t41*t57+3.125d-2*rhoa*t125*t216*t355*t359*t57+t158*t
     7           524+t159*t520+t437+3.125d-2*rhoa*t125*t183*t355*t359*t4
     8           1+t368+t367+t366+t365+t364+t363+t362+t361+t360+3.125d-2
     9           *rhob*t102*t125*t183*t355*t359+2*t219*t272
              t526 = 3.2812499999999994d-2*t125*t160*t355*t359*t61
              t527 = 3.2812499999999994d-2*t160*t163*t58*t60*t62
              t528 = -3.2812499999999994d-2*t166*t273*t58*t60*t62+t527+t
     1           526+5.46875d-3*t161*t525
              t529 = 3.125d-2*rhoa*t125*t283*t355*t359*t41
              t530 = 3.125d-2*rhob*t125*t315*t355*t359*t57
              t531 = 3.125d-2*rhob*t102*t125*t283*t355*t359
              t532 = 3.125d-2*t102*t125*t355*t359*t57
              t533 = 4*gammabb*t163*t43*t50+4.0d+0*gammaab*t163*t43*t50-
     1           4.0d+0*gammaab*t163*t43*t49-4*gammaaa*t163*t43*t49-2.0d
     2           +0*gammaab*t171*t278+2*gammaaa*t169*t278+2*gammabb*t171
     3           *t277-2.0d+0*gammaab*t169*t277
              t534 = 3.11111111111111d+0*t171*t277*t430-2.66666666666666
     1           6d+0*t163*t174*t43+2.666666666666666d+0*t163*t173*t43+3
     2           .11111111111111d+0*t169*t278*t429
              t535 = 1.3060586492616802d-2*t48*t534*t54-3.48282306469781
     1           4d-2*t176*t280*t54-3.482823064697814d-2*t175*t176*t54+1
     2           .3060586492616802d-2*t48*t51*t533-3.482823064697814d-2*
     3           t176*t279*t51-3.482823064697814d-2*t172*t176*t51+1.3060
     4           586492616802d-2*t172*t280*t48+1.3060586492616802d-2*t17
     5           5*t279*t48+t433
              t536 = 3.48d+0*t125*t476+6.779999999999999d+1*t171*t277*t4
     1           6+6.0d+0*t171*t277*t45+2.712d+1*t163*t181*t43+4.0d+0*t1
     2           63*t180*t43+1.74d+0*t171*t277
              t537 = t536*t56-4.0d+0*t179*t47*t535+2.0d+1*t178*t281*t419
     1           *t47-4.0d+0*t178*t179*t282-4.0d+0*t179*t182*t281
              t538 = 1.25d-1*t163*t179*t281*t355*t359*t47
              t539 = -3.125d-2*t163*t282*t355*t359*t56
              t540 = 1.5625d-2*t536*t56*t62-6.25d-2*t179*t47*t535*t62+3.
     1           125d-1*t178*t281*t419*t47*t62-6.25d-2*t178*t179*t282*t6
     2           2-6.25d-2*t179*t182*t281*t62+t539+t538+t523+t522+t521
              t541 = -12*t125*t133*t476+t475+t473+t472+t463+t462+t461+t4
     1           55
              t542 = 8.549604670806825d-1*t171*t277*t480+8.5496046708068
     1           25d-1*t169*t278*t479+5.129762802484096d+0*t163*t250*t43
     2           -5.129762802484096d+0*t163*t249*t43
              t543 = 5.848223622634648d-1*t134*t542+5.848223622634648d-1
     1           *t116*t541+t452+t450+t449+t440+5.848223622634648d-1*t24
     2           8*t318+5.848223622634648d-1*t251*t317
              t544 = -1.111111111111111d-1*t171*t277*t485-1.111111111111
     1           111d-1*t169*t278*t484+6.666666666666666d-1*t163*t255*t4
     2           3-6.666666666666666d-1*t163*t254*t43
              t545 = 8.172647331405554d-1*t141*t147*t150*t256*t320*t58
              t546 = -2.7242157771351844d-1*t141*t144*t147*t544*t58
              t547 = 6.356503479982097d-1*t144*t147*t257*t258*t320*t58
              t548 = 6.356503479982097d-1*t144*t147*t256*t257*t258*t58
              t549 = 9.649190532874448d+1*t135*t150*t544-3.2163968442914
     1           83d+1*t144*t543-3.859676213149779d+2*t135*t256*t268*t32
     2           0+9.649190532874448d+1*t150*t252*t320+9.649190532874448
     3           d+1*t150*t256*t319
              t550 = -1.3621078885675922d-1*t141*t143*t145*t262*t549*t58
              t551 = 2.7242157771351844d-1*t141*t144*t145*t256*t262*t322
     1           *t58
              t552 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t322
     1           *t58
              t553 = 2.7242157771351844d-1*t141*t144*t145*t262*t263*t320
     1           *t58
              t554 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t263
     1           *t58
              t555 = 2.7242157771351844d-1*t141*t143*t263*t322*t500*t501
     1           *t58
              t556 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t32
     1           2*t58
              t557 = t556+t555+t554+t553+t552+t551+t550+t548+t547+t546+t
     1           545+t495+t494
              t558 = 3.4632974135163863d-1*t153*t257*t268*t320*t359*t507
              t559 = 1.7316487067581932d-1*t145*t150*t257*t269*t322*t359
     1           *t507
              t560 = t559+t558+t556+t555+t554+t553+t552+t551+t550-3.7106
     1           75800196128d-2*t145*t150*t152*t269*t549+t548+t547+t546+
     2           t545-7.421351600392256d-2*t152*t153*t268*t544+1.1132027
     3           400588385d-1*t150*t152*t263*t322*t500*t513+t512+3.71067
     4           5800196128d-1*t152*t153*t256*t320*t511+t510+t509+t506+t
     5           495+t494+1.4842703200784513d-1*t145*t152*t256*t268*t269
     6           *t322-3.710675800196128d-2*t145*t150*t152*t263*t269*t32
     7           2+1.4842703200784513d-1*t145*t152*t263*t268*t269*t320
              t561 = -1.3621078885675922d-1*t141*t143*t149*t266*t560*t58
     1           +1.3621078885675922d-1*t141*t143*t155*t557*t58-2.724215
     2           7771351844d-1*t141*t144*t149*t155*t544*t58+2.7242157771
     3           351844d-1*t141*t143*t149*t270*t325*t515*t58-1.362107888
     4           5675922d-1*t141*t143*t265*t266*t325*t58+3.1782517399910
     5           487d-1*t143*t149*t257*t258*t266*t325*t58+2.724215777135
     6           1844d-1*t141*t144*t149*t256*t266*t325*t58-1.36210788856
     7           75922d-1*t141*t143*t266*t270*t324*t58-3.178251739991048
     8           7d-1*t143*t155*t257*t258*t324*t58-2.7242157771351844d-1
     9           *t141*t144*t155*t256*t324*t58+2.7242157771351844d-1*t14
     :           1*t144*t149*t266*t270*t320*t58-2.7242157771351844d-1*t1
     ;           41*t144*t155*t265*t320*t58+6.356503479982097d-1*t144*t1
     <           49*t155*t257*t258*t320*t58+8.172647331405554d-1*t141*t1
     =           49*t150*t155*t256*t320*t58+3.1782517399910487d-1*t143*t
     >           149*t257*t258*t266*t270*t58-3.1782517399910487d-1*t143*
     ?           t155*t257*t258*t265*t58+6.356503479982097d-1*t144*t149*
     @           t155*t256*t257*t258*t58+t490+t488
              t562 = 3.109069086965489d-2*t139*t253*t561+9.3272072608964
     1           66d-2*t142*t157*t544+1.0d+0*t543-3.109069086965489d-2*t
     2           139*t271*t326*t518+9.327207260896466d-2*t142*t253*t256*
     3           t326+9.327207260896466d-2*t142*t253*t271*t320+1.8654414
     4           521792934d-1*t138*t157*t256*t320
              t563 = 1.5625d-2*t166*t41*t57*t62+1.5625d-2*rhob*t166*t315
     1           *t57*t62+1.5625d-2*rhoa*t166*t216*t57*t62+1.5625d-2*t10
     2           2*t166*t57*t62-1.5625d-2*rhoa*t41*t42*t537*t62-1.5625d-
     3           2*rhob*t102*t42*t537*t62-1.5625d-2*t283*t41*t42*t62-1.5
     4           625d-2*rhob*t183*t315*t42*t62-1.5625d-2*rhoa*t216*t283*
     5           t42*t62-1.5625d-2*t102*t183*t42*t62+1.5625d-2*rhoa*t166
     6           *t283*t41*t62+1.5625d-2*rhoa*t166*t183*t41*t62+1.5625d-
     7           2*rhob*t102*t166*t283*t62+1.5625d-2*rhob*t102*t166*t183
     8           *t62+t159*t562+t158*t540+t532+t531+t530+t529+t437+t368+
     9           t367+t366+t365+t364+t363+t362+t361+t360+t219*t327+t272*
     :           t316
              t564 = -1.6406249999999997d-2*t166*t328*t58*t60*t62-1.6406
     1           249999999997d-2*t166*t273*t58*t60*t62+5.46875d-3*t161*t
     2           563+t527+t526
              t565 = t281**2
              t566 = t423+t421
              t567 = t424+t420
              t568 = t277**2
              t569 = t278**2
              t570 = 2*gammaaa*t569+2*gammabb*t568+2*gammabb*t50*t567-2.
     1           0d+0*gammaab*t49*t567-2.0d+0*gammaab*t50*t566+2*gammaaa
     2           *t49*t566-4.0d+0*gammaab*t277*t278
              t571 = 3.11111111111111d+0*t429*t569+3.11111111111111d+0*t
     1           430*t568-1.333333333333333d+0*t174*t567-1.3333333333333
     2           33d+0*t173*t566
              t572 = 1.3060586492616802d-2*t48*t54*t571+1.30605864926168
     1           02d-2*t48*t51*t570-6.965646129395628d-2*t176*t280*t54-6
     2           .965646129395628d-2*t176*t279*t51+2.6121172985233604d-2
     3           *t279*t280*t48+t433
              t573 = 6.779999999999999d+1*t46*t568+6.0d+0*t45*t568+1.74d
     1           +0*t568+1.74d+0*t42*t43*t567+1.356d+1*t181*t567+2.0d+0*
     2           t180*t567
              t574 = t56*t573-4.0d+0*t179*t47*t572+2.0d+1*t419*t47*t565-
     1           8.0d+0*t179*t281*t282
              t575 = 1/rhob**2.333333333333333d+0
              t576 = 1/t70**2
              t577 = t292**2
              t578 = 1/t68**3
              t579 = t291**2
              t580 = 1/rhob**2.3333333333333334d+0
              t581 = 1/rhob**1.6666666666666669d+0
              t582 = 1/t64**5
              t583 = 6.563527649164527d-2*t287*t582*t66+8.75137019888603
     1           7d-2*t288*t581*t66+3.0144339229749983d-3*t580
              t584 = 6.563527649164527d-2*t287*t582*t67+8.75137019888603
     1           7d-2*t288*t581*t67+7.876233178997433d-1*t583*t65-2.6254
     2           11059665811d-1*t288*t289*t290
              t585 = -1.4107138347223802d-1*t581*t65*t69-3.5267845868059
     1           5d-2*t287*t288*t69-4.23214150416714d-1*t286*t289*t291*t
     2           65-1.269642451250142d+0*t286*t584*t64+2.539284902500284
     3           d+0*t578*t579*t64
              t586 = 1/t78**2
              t587 = t297**2
              t588 = 1/t76**3
              t589 = t296**2
              t590 = 6.563527649164527d-2*t287*t582*t74+8.75137019888603
     1           7d-2*t288*t581*t74+4.753699179395351d-3*t580
              t591 = 6.563527649164527d-2*t287*t582*t75+8.75137019888603
     1           7d-2*t288*t581*t75+7.876233178997433d-1*t590*t65-2.6254
     2           11059665811d-1*t288*t289*t295
              t592 = -1.4107138347223802d-1*t581*t65*t77-3.5267845868059
     1           5d-2*t287*t288*t77-4.23214150416714d-1*t289*t294*t296*t
     2           65-1.269642451250142d+0*t294*t591*t64+2.539284902500284
     3           d+0*t588*t589*t64
              t593 = 1/t85**2
              t594 = t302**2
              t595 = 1/t83**3
              t596 = t301**2
              t597 = 6.563527649164527d-2*t287*t582*t81+8.75137019888603
     1           7d-2*t288*t581*t81+2.601716490612924d-3*t580
              t598 = 6.563527649164527d-2*t287*t582*t82+8.75137019888603
     1           7d-2*t288*t581*t82+7.876233178997433d-1*t597*t65-2.6254
     2           11059665811d-1*t288*t289*t300
              t599 = -1.4107138347223802d-1*t581*t65*t84-3.5267845868059
     1           5d-2*t287*t288*t84-4.23214150416714d-1*t289*t299*t301*t
     2           65-1.269642451250142d+0*t299*t598*t64+2.539284902500284
     3           d+0*t595*t596*t64
              t600 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t298*t599
     1           *t87+3.37738d-2*t593*t594*t87-1.0359398963604977d-3*t57
     2           5*t86+1.709920934161365d+0*(6.21814d-2*t293*t592*t80-6.
     3           21814d-2*t586*t587*t80+3.663697685584584d-3*t575*t79-3.
     4           10907d-2*t285*t585*t73+3.10907d-2*t576*t577*t73-1.76138
     5           65241785687d-3*t575*t71-5.495546528376876d-3*t284*t293*
     6           t297+2.642079786267853d-3*t284*t285*t292)+1.55390984454
     7           07465d-3*t284*t298*t302)+3.37738d-2*t298*t599*t87-3.377
     8           38d-2*t593*t594*t87+1.0359398963604977d-3*t575*t86-1.55
     9           39098445407465d-3*t284*t298*t302)-6.21814d-2*t293*t592*
     :           t80+6.21814d-2*t586*t587*t80-3.663697685584584d-3*t575*
     ;           t79+5.495546528376876d-3*t284*t293*t297
              t601 = rhob**3.333333333333335d-1
              t602 = 1/rhob**8.333333333333333d-1
              t603 = t303**2
              t604 = exp(-1.2865587377165935d+2*t88)
              t605 = 1/t92**3
              t606 = 1.7894823267913484d+3*gammabb*t603*t604*t605*t90
              t607 = 1.765806054418543d+0*gammabb*t350*t601*t93
              t608 = -8.408600259135923d-2*gammabb*t306*t602*t93
              t609 = -6.490894881214397d+1*gammabb*t303*t305*t306*t308*t
     1           91
              t610 = -8.947411633956742d+2*gammabb*t308*t603*t90*t91
              t611 = 1.3909060459745137d+1*gammabb*t308*t600*t90*t91
              t612 = t611+t610+t609+t608+t607+t606
              t613 = 1/t92**4.0d+0
              t614 = gammabb**2
              t615 = 1/t89**6.0d+0
              t616 = 1/t89**5.0d+0
              t617 = -3.6362344277798064d-2*t602*t614*t616*t98+1.2726820
     1           497229316d+0*t601*t614*t615*t98-3.869239257456912d+2*t3
     2           12*t603*t91*t97+6.014866082716293d+0*t312*t600*t91*t97+
     3           1.1607717772370736d+3*t603*t604*t613*t97-2.806937505267
     4           603d+1*gammabb*t303*t305*t306*t312*t91*t96-2.8069375052
     5           67603d+1*t303*t305*t312*t614*t616*t91+t611+t610+t609+t6
     6           08+t607+t606
              t618 = 1/t99**3
              t619 = t313**2
              t620 = 4.3244229904127585d-1*gammabb*t618*t619*t90*t95-2.1
     1           622114952063792d-1*gammabb*t311*t617*t90*t95-8.40860025
     2           9135923d-2*gammabb*t100*t306*t602*t95+1.765806054418543
     3           d+0*gammabb*t100*t350*t601*t95+1.0090320310963104d+0*ga
     4           mmabb*t305*t306*t311*t313*t95+2.1622114952063792d-1*gam
     5           mabb*t100*t612*t90-4.3244229904127585d-1*gammabb*t310*t
     6           311*t313*t90-1.0090320310963104d+0*gammabb*t100*t305*t3
     7           06*t310
              t621 = 1/t101**2
              t622 = t314**2
              t623 = -1.5545345434827443d-2*t621*t622+1.5545345434827443
     1           d-2*t304*t620+1.0d+0*t600
              t624 = 1.5625d-2*t56*t573*t62-6.25d-2*t179*t47*t572*t62+3.
     1           125d-1*t419*t47*t565*t62-1.25d-1*t179*t281*t282*t62-3.1
     2           25d-2*t166*t282*t56*t58*t60*t61+1.25d-1*t166*t179*t281*
     3           t47*t58*t60*t61+t539+t538+t521
              t625 = t477+t475+t473+t472+t463+t462+t461+t455+32*t133*t24
     1           5*t247-8*t125*t243*t247
              t626 = 8.549604670806825d-1*t479*t569+8.549604670806825d-1
     1           *t480*t568+2.564881401242048d+0*t250*t567+2.56488140124
     2           2048d+0*t249*t566
              t627 = 5.848223622634648d-1*t134*t626+5.848223622634648d-1
     1           *t116*t625+t452+t450+t449+t440+1.1696447245269297d+0*t3
     2           17*t318
              t628 = t320**2
              t629 = -1.111111111111111d-1*t484*t569-1.111111111111111d-
     1           1*t485*t568+3.333333333333333d-1*t255*t567+3.3333333333
     2           33333d-1*t254*t566
              t630 = 8.172647331405554d-1*t141*t147*t150*t58*t628
              t631 = -2.7242157771351844d-1*t141*t144*t147*t58*t629
              t632 = 1.2713006959964196d+0*t144*t147*t257*t258*t320*t58
              t633 = 9.649190532874448d+1*t135*t150*t629-3.8596762131497
     1           79d+2*t135*t268*t628-3.216396844291483d+1*t144*t627+1.9
     2           298381065748896d+2*t150*t319*t320
              t634 = -1.3621078885675922d-1*t141*t143*t145*t262*t58*t633
              t635 = 5.448431554270369d-1*t141*t144*t145*t262*t320*t322*
     1           t58
              t636 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t322*
     1           t58
              t637 = t322**2
              t638 = 2.7242157771351844d-1*t141*t143*t500*t501*t58*t637
              t639 = -1.3621078885675922d-1*t141*t143*t145*t262*t58*t637
              t640 = t639+t638+t636+t635+t634+t632+t631+t630+t495+t494
              t641 = t639+t638+1.1132027400588385d-1*t150*t152*t500*t513
     1           *t637-3.710675800196128d-2*t145*t150*t152*t269*t637+t63
     2           6+t635+t634-3.710675800196128d-2*t145*t150*t152*t269*t6
     3           33+t632+t631+t630-7.421351600392256d-2*t152*t153*t268*t
     4           629+3.710675800196128d-1*t152*t153*t511*t628+1.73164870
     5           67581932d-1*t145*t150*t151*t257*t258*t269*t322*t58+3.46
     6           32974135163863d-1*t151*t153*t257*t258*t268*t320*t58+t55
     7           9+t558+t510+t509+t495+t494+2.9685406401569026d-1*t145*t
     8           152*t268*t269*t320*t322
              t642 = t325**2
              t643 = 2.7242157771351844d-1*t141*t143*t149*t515*t58*t642-
     1           1.3621078885675922d-1*t141*t143*t149*t266*t58*t641+1.36
     2           21078885675922d-1*t141*t143*t155*t58*t640-2.72421577713
     3           51844d-1*t141*t144*t149*t155*t58*t629+8.172647331405554
     4           d-1*t141*t149*t150*t155*t58*t628-2.7242157771351844d-1*
     5           t141*t143*t266*t324*t325*t58+5.448431554270369d-1*t141*
     6           t144*t149*t266*t320*t325*t58+6.356503479982097d-1*t143*
     7           t149*t257*t258*t266*t325*t58-5.448431554270369d-1*t141*
     8           t144*t155*t320*t324*t58-6.356503479982097d-1*t143*t155*
     9           t257*t258*t324*t58+1.2713006959964196d+0*t144*t149*t155
     :           *t257*t258*t320*t58+t490+t488
              t644 = t326**2
              t645 = -3.109069086965489d-2*t139*t518*t644+3.109069086965
     1           489d-2*t139*t253*t643+9.327207260896466d-2*t142*t157*t6
     2           29+1.8654414521792934d-1*t138*t157*t628+1.0d+0*t627+1.8
     3           654414521792934d-1*t142*t253*t320*t326
              t646 = t159*t645+t158*t624-1.5625d-2*rhob*t42*t57*t62*t623
     1           -1.5625d-2*rhoa*t41*t42*t574*t62-1.5625d-2*rhob*t102*t4
     2           2*t574*t62-3.125d-2*t315*t42*t57*t62+3.125d-2*rhob*t166
     3           *t315*t57*t62+3.125d-2*t102*t166*t57*t62-3.125d-2*rhob*
     4           t283*t315*t42*t62-3.125d-2*t102*t283*t42*t62+3.125d-2*r
     5           hoa*t166*t283*t41*t62+3.125d-2*rhob*t102*t166*t283*t62+
     6           3.125d-2*rhob*t163*t315*t57*t58*t60*t61+3.125d-2*t102*t
     7           163*t57*t58*t60*t61+3.125d-2*rhoa*t163*t283*t41*t58*t60
     8           *t61+3.125d-2*rhob*t102*t163*t283*t58*t60*t61+t532+t531
     9           +t530+t529+t437+t368+t367+t363+t361+t360+2*t316*t327
              t647 = 5.46875d-3*t161*t646-3.2812499999999994d-2*t166*t32
     1           8*t58*t60*t62+t527+t526
              t648 = -1.6406249999999997d-2*t166*t341*t58*t60*t62
              t649 = 1/t1**6.666666666666667d+0
              t650 = -1.6325733115771002d-3*rhoa*t179*t355*t359*t41*t47*
     1           t51*t52*t649
              t651 = 4.8579204483835753d-4*rhoa*t125*t205*t334*t355*t359
     1           *t57
              t652 = 6.25d-2*rhoa*t125*t355*t41*t57*t58
              t653 = -1.6325733115771002d-3*rhob*t102*t179*t355*t359*t47
     1           *t51*t52*t649
              t654 = 6.25d-2*rhob*t102*t125*t355*t57*t58
              t655 = -3.125d-2*rhoa*t166*t183*t41*t60*t61
              t656 = 3.125d-2*rhoa*t163*t41*t57*t60*t61
              t657 = -3.125d-2*rhoa*t166*t216*t57*t60*t61
              t658 = -3.125d-2*t166*t41*t57*t60*t61
              t659 = -3.125d-2*rhob*t102*t166*t183*t60*t61
              t660 = 3.125d-2*rhob*t102*t163*t57*t60*t61
              t661 = -8.162866557885502d-4*rhoa*t179*t41*t432*t47*t51*t5
     1           2*t62
              t662 = -3.482823064697814d-2*t176*t51*t52
              t663 = t662+1.3060586492616802d-2*t175*t48*t52+2.612117298
     1           5233604d-2*t169*t48*t49*t51
              t664 = -4.0d+0*t179*t47*t663+2.6121172985233604d-1*t178*t4
     1           19*t47*t48*t51*t52-5.224234597046721d-2*t179*t182*t48*t
     2           51*t52
              t665 = 2.4289602241917876d-4*rhoa*t166*t205*t334*t57*t62
              t666 = -5.045160155481552d-1*t206*t207*t32
              t667 = 1.3909060459745137d+1*t204*t209*t29*t30
              t668 = t667+t666
              t669 = t667+t666-4.363481313335766d-1*gammaaa*t206*t37*t41
     1           0+1.2029732165432584d+1*t204*t213*t29*t30*t35
              t670 = -2.1622114952063792d-1*gammaaa*t212*t29*t34*t669+2.
     1           1622114952063792d-1*gammaaa*t29*t39*t668+4.324422990412
     2           7585d-1*gammaaa*t214*t29*t332*t34*t412-1.09087032833394
     3           15d-1*gammaaa*t206*t32*t39*t410-5.045160155481552d-1*t2
     4           06*t207*t34*t39+2.1622114952063792d-1*t211*t29*t39+5.04
     5           5160155481552d-1*gammaaa*t206*t207*t212*t332*t34-2.1622
     6           114952063792d-1*t212*t214*t29*t34-4.675158550002606d-2*
     7           gammaaa*t212*t214*t32*t333-2.1622114952063792d-1*gammaa
     8           a*t211*t212*t29*t332
              t671 = 1.5545345434827443d-2*t205*t670-1.5545345434827443d
     1           -2*t215*t334*t415
              t672 = -8.162866557885502d-4*rhob*t102*t179*t432*t47*t51*t
     1           52*t62
              t673 = 1/t1**5.666666666666667d+0
              t674 = 1.6325733115771002d-3*t179*t355*t359*t47*t51*t52*t6
     1           73
              t675 = -6.25d-2*t163*t355*t47*t56*t58
              t676 = -1.25d-1*t178*t179*t42*t47*t60*t61
              t677 = 3.125d-2*t182*t42*t56*t60*t61
              t678 = t677+t676+t675+t674-6.25d-2*t179*t47*t62*t663+4.081
     1           4332789427504d-3*t178*t419*t47*t48*t51*t52*t62-8.162866
     2           557885502d-4*t179*t182*t48*t51*t52*t62
              t679 = 3.109069086965489d-2*t139*t219*t253*t339
              t680 = 3.1782517399910487d-1*t143*t149*t257*t258*t266*t337
     1           *t58
              t681 = -3.1782517399910487d-1*t143*t149*t155*t257*t258
              t682 = -4.3291217668954834d-2*t147*t150*t155*t257*t507*t58
              t683 = -2.7242157771351844d-1*t141*t144*t147*t256
              t684 = -3.1782517399910487d-1*t143*t147*t257*t258
              t685 = -1.3621078885675922d-1*t141*t143*t145*t262*t263
              t686 = t685+t684+t683
              t687 = -1.7316487067581932d-1*t150*t153*t257*t507*t58
              t688 = t687+t685+t684+t683-7.421351600392256d-2*t141*t145*
     1           t150*t151*t263*t269-1.4842703200784513d-1*t141*t151*t15
     2           3*t256*t268
              t689 = -1.3621078885675922d-1*t141*t143*t149*t266*t58*t688
     1           +1.3621078885675922d-1*t141*t143*t155*t58*t686+t682+t68
     2           1+t680+2.7242157771351844d-1*t141*t143*t149*t270*t337*t
     3           515*t58-1.855337900098064d-2*t147*t150*t266*t270*t338*t
     4           58-3.710675800196128d-2*t147*t155*t256*t268*t338*t58-1.
     5           3621078885675922d-1*t141*t143*t265*t266*t337*t58+2.7242
     6           157771351844d-1*t141*t144*t149*t256*t266*t337*t58-1.362
     7           1078885675922d-1*t141*t143*t149*t266*t270+1.36210788856
     8           75922d-1*t141*t143*t155*t265-2.7242157771351844d-1*t141
     9           *t144*t149*t155*t256
              t690 = 3.109069086965489d-2*t139*t253*t689-3.1090690869654
     1           89d-2*t139*t271*t339*t518+9.327207260896466d-2*t142*t25
     2           3*t256*t339
              t691 = t159*t690
              t692 = t691+t679+t158*t678+t672-1.5625d-2*rhoa*t42*t57*t62
     1           *t671+t665-1.5625d-2*rhoa*t41*t42*t62*t664-1.5625d-2*rh
     2           ob*t102*t42*t62*t664+t661+t660+t659+t658+t657+t656+t655
     3           +t654+t653+t652+t651+t650-2.4289602241917876d-4*t205*t3
     4           34*t42*t57*t62+8.162866557885502d-4*t176*t179*t41*t47*t
     5           51*t52*t62+8.162866557885502d-4*rhoa*t176*t179*t216*t47
     6           *t51*t52*t62-2.4289602241917876d-4*rhoa*t183*t205*t334*
     7           t42*t62+t272*t336
              t693 = 1.6406249999999997d-2*t273*t42*t60*t62
              t694 = -3.2812499999999994d-2*t160*t163*t355*t58*t61
              t695 = -1.6406249999999997d-2*t160*t166*t60*t62
              t696 = t695+t694+t693+5.46875d-3*t161*t692+t648
              t697 = 1.0d+0*t160*t343*wght
              t698 = 1.0d+0*t162*t341*wght
              t699 = -1.6406249999999997d-2*t166*t347*t58*t60*t62
              t700 = 3.2651466231542003d-3*rhoa*t179*t355*t359*t41*t47*t
     1           49*t50*t51*t649
              t701 = 1.25d-1*rhoa*t125*t355*t41*t57*t58
              t702 = 3.2651466231542003d-3*rhob*t102*t179*t355*t359*t47*
     1           t49*t50*t51*t649
              t703 = 1.25d-1*rhob*t102*t125*t355*t57*t58
              t704 = 6.25d-2*rhoa*t163*t41*t57*t60*t61
              t705 = 6.25d-2*rhob*t102*t163*t57*t60*t61
              t706 = 1.6325733115771002d-3*rhoa*t179*t41*t432*t47*t49*t5
     1           0*t51*t62
              t707 = 6.965646129395628d-2*t176*t49*t50*t51
              t708 = -2.0d+0*t169*t50-2.0d+0*t171*t49
              t709 = 1.3060586492616802d-2*t48*t51*t708+t707-2.612117298
     1           5233604d-2*t175*t48*t49*t50
              t710 = -4.0d+0*t179*t47*t709-5.224234597046721d-1*t178*t41
     1           9*t47*t48*t49*t50*t51+1.0448469194093442d-1*t179*t182*t
     2           48*t49*t50*t51
              t711 = 1.6325733115771002d-3*rhob*t102*t179*t432*t47*t49*t
     1           50*t51*t62
              t712 = -3.2651466231542003d-3*t179*t355*t359*t47*t49*t50*t
     1           51*t673
              t713 = -1.25d-1*t163*t355*t47*t56*t58
              t714 = t713+t712-6.25d-2*t179*t47*t62*t709-8.1628665578855
     1           01d-3*t178*t419*t47*t48*t49*t50*t51*t62+1.6325733115771
     2           002d-3*t179*t182*t48*t49*t50*t51*t62+6.25d-2*t182*t42*t
     3           56*t60*t61-2.5d-1*t178*t179*t42*t47*t60*t61
              t715 = 3.1782517399910487d-1*t143*t149*t257*t258*t266*t345
     1           *t58
              t716 = -6.356503479982097d-1*t143*t149*t155*t257*t258
              t717 = -8.658243533790967d-2*t147*t150*t155*t257*t507*t58
              t718 = -5.448431554270369d-1*t141*t144*t147*t256
              t719 = -6.356503479982097d-1*t143*t147*t257*t258
              t720 = -2.7242157771351844d-1*t141*t143*t145*t262*t263
              t721 = t720+t719+t718
              t722 = -3.4632974135163863d-1*t150*t153*t257*t507*t58
              t723 = t722+t720+t719+t718-1.4842703200784513d-1*t141*t145
     1           *t150*t151*t263*t269-2.9685406401569026d-1*t141*t151*t1
     2           53*t256*t268
              t724 = -1.3621078885675922d-1*t141*t143*t149*t266*t58*t723
     1           +1.3621078885675922d-1*t141*t143*t155*t58*t721+t717+t71
     2           6+t715+2.7242157771351844d-1*t141*t143*t149*t270*t345*t
     3           515*t58-1.3621078885675922d-1*t141*t143*t265*t266*t345*
     4           t58+2.7242157771351844d-1*t141*t144*t149*t256*t266*t345
     5           *t58-3.710675800196128d-2*t147*t150*t266*t270*t338*t58-
     6           7.421351600392256d-2*t147*t155*t256*t268*t338*t58-2.724
     7           2157771351844d-1*t141*t143*t149*t266*t270+2.72421577713
     8           51844d-1*t141*t143*t155*t265-5.448431554270369d-1*t141*
     9           t144*t149*t155*t256
              t725 = 3.109069086965489d-2*t139*t253*t724-3.1090690869654
     1           89d-2*t139*t271*t346*t518+9.327207260896466d-2*t142*t25
     2           3*t256*t346
              t726 = t159*t725+t158*t714+t711-1.5625d-2*rhoa*t41*t42*t62
     1           *t710-1.5625d-2*rhob*t102*t42*t62*t710+t706+t705+t704+t
     2           703+t702+t701+t700-1.6325733115771002d-3*t176*t179*t41*
     3           t47*t49*t50*t51*t62-1.6325733115771002d-3*rhoa*t176*t17
     4           9*t216*t47*t49*t50*t51*t62-6.25d-2*t166*t41*t57*t60*t61
     5           -6.25d-2*rhoa*t166*t216*t57*t60*t61-6.25d-2*rhoa*t166*t
     6           183*t41*t60*t61-6.25d-2*rhob*t102*t166*t183*t60*t61+3.1
     7           09069086965489d-2*t139*t219*t253*t346+t272*t344
              t727 = -6.562499999999999d-2*t160*t163*t355*t58*t61
              t728 = -3.2812499999999994d-2*t160*t166*t60*t62
              t729 = t728+t727+5.46875d-3*t161*t726+t699+3.2812499999999
     1           994d-2*t273*t42*t60*t62
              t730 = 1.0d+0*t160*t348*wght
              t731 = 1.0d+0*t162*t347*wght
              t732 = -1.6406249999999997d-2*t166*t353*t58*t60*t62
              t733 = -1.6325733115771002d-3*rhoa*t179*t355*t359*t41*t47*
     1           t51*t53*t649
              t734 = 4.8579204483835753d-4*rhob*t125*t304*t351*t355*t359
     1           *t57
              t735 = -1.6325733115771002d-3*rhob*t102*t179*t355*t359*t47
     1           *t51*t53*t649
              t736 = -8.162866557885502d-4*rhoa*t179*t41*t432*t47*t51*t5
     1           3*t62
              t737 = -3.482823064697814d-2*t176*t51*t53
              t738 = t737+1.3060586492616802d-2*t175*t48*t53+2.612117298
     1           5233604d-2*t171*t48*t50*t51
              t739 = -4.0d+0*t179*t47*t738+2.6121172985233604d-1*t178*t4
     1           19*t47*t48*t51*t53-5.224234597046721d-2*t179*t182*t48*t
     2           51*t53
              t740 = 2.4289602241917876d-4*rhob*t166*t304*t351*t57*t62
              t741 = -8.162866557885502d-4*rhob*t102*t179*t432*t47*t51*t
     1           53*t62
              t742 = 1.6325733115771002d-3*t179*t355*t359*t47*t51*t53*t6
     1           73
              t743 = t742-6.25d-2*t179*t47*t62*t738+t677+t676+t675+4.081
     1           4332789427504d-3*t178*t419*t47*t48*t51*t53*t62-8.162866
     2           557885502d-4*t179*t182*t48*t51*t53*t62
              t744 = t158*t743+t741+t740-1.5625d-2*rhoa*t41*t42*t62*t739
     1           -1.5625d-2*rhob*t102*t42*t62*t739+t736+t735+t734+t733+t
     2           691+t679+t660+t659+t658+t657+t656+t655+t654+t652+8.1628
     3           66557885502d-4*t176*t179*t41*t47*t51*t53*t62+8.16286655
     4           7885502d-4*rhoa*t176*t179*t216*t47*t51*t53*t62-2.428960
     5           2241917876d-4*rhob*t183*t304*t351*t42*t62+t272*t352
              t745 = 5.46875d-3*t161*t744+t732+t695+t694+t693
              t746 = 1.0d+0*t160*t354*wght
              t747 = 1.0d+0*t162*t353*wght
              t748 = -3.125d-2*rhoa*t166*t283*t41*t60*t61
              t749 = -3.125d-2*rhob*t166*t315*t57*t60*t61
              t750 = -3.125d-2*rhob*t102*t166*t283*t60*t61
              t751 = -3.125d-2*t102*t166*t57*t60*t61
              t752 = t662+1.3060586492616802d-2*t280*t48*t52+2.612117298
     1           5233604d-2*t278*t48*t49*t51
              t753 = -4.0d+0*t179*t47*t752+2.6121172985233604d-1*t281*t4
     1           19*t47*t48*t51*t52-5.224234597046721d-2*t179*t282*t48*t
     2           51*t52
              t754 = -1.25d-1*t179*t281*t42*t47*t60*t61
              t755 = 3.125d-2*t282*t42*t56*t60*t61
              t756 = t755+t754-6.25d-2*t179*t47*t62*t752+t675+t674+4.081
     1           4332789427504d-3*t281*t419*t47*t48*t51*t52*t62-8.162866
     2           557885502d-4*t179*t282*t48*t51*t52*t62
              t757 = 3.109069086965489d-2*t139*t253*t316*t339
              t758 = -2.7242157771351844d-1*t141*t144*t147*t320
              t759 = -1.3621078885675922d-1*t141*t143*t145*t262*t322
              t760 = t759+t758+t684
              t761 = t759+t758+t687+t684-7.421351600392256d-2*t141*t145*
     1           t150*t151*t269*t322-1.4842703200784513d-1*t141*t151*t15
     2           3*t268*t320
              t762 = -1.3621078885675922d-1*t141*t143*t149*t266*t58*t761
     1           +1.3621078885675922d-1*t141*t143*t155*t58*t760+t682+t68
     2           1+t680+2.7242157771351844d-1*t141*t143*t149*t325*t337*t
     3           515*t58-1.855337900098064d-2*t147*t150*t266*t325*t338*t
     4           58-3.710675800196128d-2*t147*t155*t268*t320*t338*t58-1.
     5           3621078885675922d-1*t141*t143*t266*t324*t337*t58+2.7242
     6           157771351844d-1*t141*t144*t149*t266*t320*t337*t58-1.362
     7           1078885675922d-1*t141*t143*t149*t266*t325+1.36210788856
     8           75922d-1*t141*t143*t155*t324-2.7242157771351844d-1*t141
     9           *t144*t149*t155*t320
              t763 = 3.109069086965489d-2*t139*t253*t762-3.1090690869654
     1           89d-2*t139*t326*t339*t518+9.327207260896466d-2*t142*t25
     2           3*t320*t339
              t764 = t159*t763
              t765 = t764+t757+t158*t756-1.5625d-2*rhoa*t41*t42*t62*t753
     1           -1.5625d-2*rhob*t102*t42*t62*t753+t751+t750+t749+t748+t
     2           672+t665+t661+t660+t656+t654+t653+t652+t651+t650+8.1628
     3           66557885502d-4*rhob*t176*t179*t315*t47*t51*t52*t62+8.16
     4           2866557885502d-4*t102*t176*t179*t47*t51*t52*t62-2.42896
     5           02241917876d-4*rhoa*t205*t283*t334*t42*t62+t327*t336
              t766 = 1.6406249999999997d-2*t328*t42*t60*t62
              t767 = t766+5.46875d-3*t161*t765+t695+t694+t648
              t768 = -2.0d+0*t278*t50-2.0d+0*t277*t49
              t769 = 1.3060586492616802d-2*t48*t51*t768+t707-2.612117298
     1           5233604d-2*t280*t48*t49*t50
              t770 = -4.0d+0*t179*t47*t769-5.224234597046721d-1*t281*t41
     1           9*t47*t48*t49*t50*t51+1.0448469194093442d-1*t179*t282*t
     2           48*t49*t50*t51
              t771 = -6.25d-2*t179*t47*t62*t769+t713+t712-8.162866557885
     1           501d-3*t281*t419*t47*t48*t49*t50*t51*t62+1.632573311577
     2           1002d-3*t179*t282*t48*t49*t50*t51*t62+6.25d-2*t282*t42*
     3           t56*t60*t61-2.5d-1*t179*t281*t42*t47*t60*t61
              t772 = -5.448431554270369d-1*t141*t144*t147*t320
              t773 = -2.7242157771351844d-1*t141*t143*t145*t262*t322
              t774 = t773+t772+t719
              t775 = t773+t772+t722+t719-1.4842703200784513d-1*t141*t145
     1           *t150*t151*t269*t322-2.9685406401569026d-1*t141*t151*t1
     2           53*t268*t320
              t776 = -1.3621078885675922d-1*t141*t143*t149*t266*t58*t775
     1           +1.3621078885675922d-1*t141*t143*t155*t58*t774+t717+t71
     2           6+t715+2.7242157771351844d-1*t141*t143*t149*t325*t345*t
     3           515*t58-1.3621078885675922d-1*t141*t143*t266*t324*t345*
     4           t58+2.7242157771351844d-1*t141*t144*t149*t266*t320*t345
     5           *t58-3.710675800196128d-2*t147*t150*t266*t325*t338*t58-
     6           7.421351600392256d-2*t147*t155*t268*t320*t338*t58-2.724
     7           2157771351844d-1*t141*t143*t149*t266*t325+2.72421577713
     8           51844d-1*t141*t143*t155*t324-5.448431554270369d-1*t141*
     9           t144*t149*t155*t320
              t777 = 3.109069086965489d-2*t139*t253*t776-3.1090690869654
     1           89d-2*t139*t326*t346*t518+9.327207260896466d-2*t142*t25
     2           3*t320*t346
              t778 = t159*t777+t158*t771-1.5625d-2*rhoa*t41*t42*t62*t770
     1           -1.5625d-2*rhob*t102*t42*t62*t770+t711+t706+t705+t704+t
     2           703+t702+t701+t700-1.6325733115771002d-3*rhob*t176*t179
     3           *t315*t47*t49*t50*t51*t62-1.6325733115771002d-3*t102*t1
     4           76*t179*t47*t49*t50*t51*t62-6.25d-2*rhob*t166*t315*t57*
     5           t60*t61-6.25d-2*t102*t166*t57*t60*t61-6.25d-2*rhoa*t166
     6           *t283*t41*t60*t61-6.25d-2*rhob*t102*t166*t283*t60*t61+3
     7           .109069086965489d-2*t139*t253*t316*t346+t327*t344
              t779 = 5.46875d-3*t161*t778+t728+t727+t699+3.2812499999999
     1           994d-2*t328*t42*t60*t62
              t780 = t737+1.3060586492616802d-2*t280*t48*t53+2.612117298
     1           5233604d-2*t277*t48*t50*t51
              t781 = -4.0d+0*t179*t47*t780+2.6121172985233604d-1*t281*t4
     1           19*t47*t48*t51*t53-5.224234597046721d-2*t179*t282*t48*t
     2           51*t53
              t782 = -5.045160155481552d-1*t305*t306*t93
              t783 = 1.3909060459745137d+1*t303*t308*t90*t91
              t784 = t783+t782
              t785 = -4.363481313335766d-1*gammabb*t305*t616*t98+1.20297
     1           32165432584d+1*t303*t312*t90*t91*t96+t783+t782
              t786 = -2.1622114952063792d-1*gammabb*t311*t785*t90*t95+4.
     1           3244229904127585d-1*gammabb*t313*t349*t618*t90*t95-2.16
     2           22114952063792d-1*t311*t313*t90*t95+5.045160155481552d-
     3           1*gammabb*t305*t306*t311*t349*t95-5.045160155481552d-1*
     4           t100*t305*t306*t95-1.0908703283339415d-1*gammabb*t100*t
     5           305*t616*t93-4.675158550002606d-2*gammabb*t311*t313*t35
     6           0*t93+2.1622114952063792d-1*gammabb*t100*t784*t90-2.162
     7           2114952063792d-1*gammabb*t310*t311*t349*t90+2.162211495
     8           2063792d-1*t100*t310*t90
              t787 = 1.5545345434827443d-2*t304*t786-1.5545345434827443d
     1           -2*t314*t351*t621
              t788 = -6.25d-2*t179*t47*t62*t780+t755+t754+t742+t675+4.08
     1           14332789427504d-3*t281*t419*t47*t48*t51*t53*t62-8.16286
     2           6557885502d-4*t179*t282*t48*t51*t53*t62
              t789 = t158*t788-1.5625d-2*rhob*t42*t57*t62*t787-1.5625d-2
     1           *rhoa*t41*t42*t62*t781-1.5625d-2*rhob*t102*t42*t62*t781
     2           +t764+t757+t751+t750+t749+t748+t741+t740+t736+t735+t734
     3           +t733+t660+t656+t654+t652-2.4289602241917876d-4*t304*t3
     4           51*t42*t57*t62+8.162866557885502d-4*rhob*t176*t179*t315
     5           *t47*t51*t53*t62+8.162866557885502d-4*t102*t176*t179*t4
     6           7*t51*t53*t62-2.4289602241917876d-4*rhob*t283*t304*t351
     7           *t42*t62+t327*t352
              t790 = 5.46875d-3*t161*t789+t766+t732+t695+t694
              t791 = -3.125d-2*rhoa*t163*t355*t41*t57
              t792 = -3.125d-2*rhob*t102*t163*t355*t57
              t793 = 1.6325733115771002d-3*rhoa*t179*t41*t432*t47*t51*t5
     1           2*t60*t61
              t794 = -4.8579204483835753d-4*rhoa*t166*t205*t334*t57*t60*
     1           t61
              t795 = 1.6325733115771002d-3*rhob*t102*t179*t432*t47*t51*t
     1           52*t60*t61
              t796 = 1/t1**6.333333333333333d+0
              t797 = t49**4
              t798 = t51**2
              t799 = t334**2
              t800 = t332**2
              t801 = 4.3244229904127585d-1*gammaaa*t29*t34*t412*t800-2.0
     1           217363117456047d-2*gammaaa*t212*t34*t37*t409+9.35031710
     2           0005212d-2*t32*t333*t39-4.3244229904127585d-1*t212*t29*
     3           t332*t34-9.350317100005212d-2*gammaaa*t212*t32*t332*t33
     4           3
              t802 = 3.125d-2*t166*t355*t47*t56
              t803 = -1.6325733115771002d-3*t176*t179*t47*t51*t52*t60*t6
     1           1
              t804 = 1/t1**5.333333333333333d+0
              t805 = 5.330591235347639d-5*t419*t47*t62*t797*t798*t804+t8
     1           03+t802-1.6325733115771002d-3*t179*t355*t432*t47*t51*t5
     2           2*t58
              t806 = t339**2
              t807 = -3.109069086965489d-2*t139*t159*t518*t806
              t808 = t337**2
              t809 = -2.7242157771351844d-1*t141*t143*t149*t266*t337
              t810 = -3.710675800196128d-2*t147*t150*t266*t337*t338*t58
              t811 = t810+t809+2.7242157771351844d-1*t141*t143*t149*t515
     1           *t58*t808-5.054340779364009d-3*t149*t153*t266*t508*t511
     2           *t58+3.710675800196128d-2*t147*t150*t155*t338
              t812 = 3.109069086965489d-2*t139*t159*t253*t811
              t813 = t812+t807+t158*t805-2.4289602241917876d-4*rhoa*t205
     1           *t42*t57*t62*t801+2.4289602241917876d-4*rhoa*t415*t42*t
     2           57*t62*t799-5.330591235347639d-5*rhoa*t41*t419*t47*t62*
     3           t796*t797*t798-5.330591235347639d-5*rhob*t102*t419*t47*
     4           t62*t796*t797*t798+t795+t794+t793+t792+t791+1.632573311
     5           5771002d-3*rhoa*t179*t355*t41*t47*t51*t52*t58*t673+1.63
     6           25733115771002d-3*rhob*t102*t179*t355*t47*t51*t52*t58*t
     7           673+2.5378916076146196d-5*rhoa*t176*t179*t205*t334*t47*
     8           t51*t52*t62-4.8579204483835753d-4*rhoa*t163*t205*t334*t
     9           355*t57*t58+6.218138173930978d-2*t139*t253*t336*t339
              t814 = 3.2812499999999994d-2*t341*t42*t60*t62
              t815 = 3.2812499999999994d-2*t160*t166*t355*t61
              t816 = t815+t814+5.46875d-3*t161*t813
              t817 = 1.6406249999999997d-2*t347*t42*t60*t62
              t818 = -6.25d-2*rhoa*t163*t355*t41*t57
              t819 = -6.25d-2*rhob*t102*t163*t355*t57
              t820 = t49**3
              t821 = 6.25d-2*t166*t355*t47*t56
              t822 = t821-1.066118247069528d-4*t419*t47*t50*t62*t798*t80
     1           4*t820-3.2651466231542003d-3*t176*t179*t47*t51*t52*t60*
     2           t61+3.2651466231542003d-3*t179*t355*t432*t47*t49*t50*t5
     3           1*t58
              t823 = 3.109069086965489d-2*t139*t253*t339*t344
              t824 = t810+t809+2.7242157771351844d-1*t141*t143*t149*t337
     1           *t345*t515*t58-1.0108681558728018d-2*t149*t153*t266*t50
     2           8*t511*t58-1.855337900098064d-2*t147*t150*t266*t338*t34
     3           5*t58-1.3621078885675922d-1*t141*t143*t149*t266*t345+7.
     4           421351600392256d-2*t147*t150*t155*t338
              t825 = 3.109069086965489d-2*t139*t159*t253*t824
              t826 = -3.109069086965489d-2*t139*t159*t339*t346*t518
              t827 = t826+t825+t823+t158*t822+1.066118247069528d-4*rhoa*
     1           t41*t419*t47*t50*t62*t796*t798*t820+1.066118247069528d-
     2           4*rhob*t102*t419*t47*t50*t62*t796*t798*t820+t819+t818-3
     3           .2651466231542003d-3*rhoa*t179*t355*t41*t47*t49*t50*t51
     4           *t58*t673-3.2651466231542003d-3*rhob*t102*t179*t355*t47
     5           *t49*t50*t51*t58*t673-2.5378916076146196d-5*rhoa*t176*t
     6           179*t205*t334*t47*t49*t50*t51*t62-9.715840896767151d-4*
     7           rhoa*t166*t205*t334*t57*t60*t61+3.2651466231542003d-3*r
     8           hoa*t179*t41*t432*t47*t51*t52*t60*t61+3.265146623154200
     9           3d-3*rhob*t102*t179*t432*t47*t51*t52*t60*t61+3.10906908
     :           6965489d-2*t139*t253*t336*t346
              t828 = 6.562499999999999d-2*t160*t166*t355*t61
              t829 = t828+5.46875d-3*t161*t827+t817+t814
              t830 = 1.6325733115771002d-3*rhoa*t179*t355*t41*t47*t51*t5
     1           3*t58*t673
              t831 = -4.8579204483835753d-4*rhob*t163*t304*t351*t355*t57
     1           *t58
              t832 = 1.6325733115771002d-3*rhob*t102*t179*t355*t47*t51*t
     1           53*t58*t673
              t833 = -1.6325733115771002d-3*t179*t355*t432*t47*t51*t53*t
     1           58
              t834 = t833+5.330591235347639d-5*t419*t47*t52*t53*t62*t798
     1           *t804+t803+t802
              t835 = t158*t834+t832+t831+t830+t812+t807-5.33059123534763
     1           9d-5*rhoa*t41*t419*t47*t52*t53*t62*t796*t798-5.33059123
     2           5347639d-5*rhob*t102*t419*t47*t52*t53*t62*t796*t798+t79
     3           5+t794+t793+t792+t791+1.2689458038073098d-5*rhoa*t176*t
     4           179*t205*t334*t47*t51*t53*t62+1.2689458038073098d-5*rho
     5           b*t176*t179*t304*t351*t47*t51*t52*t62+3.109069086965489
     6           d-2*t139*t253*t339*t352+3.109069086965489d-2*t139*t253*
     7           t336*t339
              t836 = 5.46875d-3*t161*t835+t815+1.6406249999999997d-2*t35
     1           3*t42*t60*t62+1.6406249999999997d-2*t341*t42*t60*t62
              t837 = 2.132236494139056d-4*t419*t47*t52*t53*t62*t798*t804
     1           +6.530293246308401d-3*t176*t179*t47*t49*t50*t51*t60*t61
     2           +6.530293246308401d-3*t179*t355*t432*t47*t49*t50*t51*t5
     3           8+1.25d-1*t166*t355*t47*t56
              t838 = t346**2
              t839 = t345**2
              t840 = 2.7242157771351844d-1*t141*t143*t149*t515*t58*t839-
     1           2.0217363117456036d-2*t149*t153*t266*t508*t511*t58-7.42
     2           1351600392256d-2*t147*t150*t266*t338*t345*t58-5.4484315
     3           54270369d-1*t141*t143*t149*t266*t345+1.4842703200784513
     4           d-1*t147*t150*t155*t338
              t841 = 3.109069086965489d-2*t139*t159*t253*t840-3.10906908
     1           6965489d-2*t139*t159*t518*t838+t158*t837-2.132236494139
     2           056d-4*rhoa*t41*t419*t47*t52*t53*t62*t796*t798-2.132236
     3           494139056d-4*rhob*t102*t419*t47*t52*t53*t62*t796*t798-6
     4           .530293246308401d-3*rhoa*t179*t355*t41*t47*t49*t50*t51*
     5           t58*t673-6.530293246308401d-3*rhob*t102*t179*t355*t47*t
     6           49*t50*t51*t58*t673-6.530293246308401d-3*rhoa*t179*t41*
     7           t432*t47*t49*t50*t51*t60*t61-6.530293246308401d-3*rhob*
     8           t102*t179*t432*t47*t49*t50*t51*t60*t61-1.25d-1*rhoa*t16
     9           3*t355*t41*t57-1.25d-1*rhob*t102*t163*t355*t57+6.218138
     :           173930978d-2*t139*t253*t344*t346
              t842 = 5.46875d-3*t161*t841+6.562499999999999d-2*t347*t42*
     1           t60*t62+1.3124999999999998d-1*t160*t166*t355*t61
              t843 = 3.2812499999999994d-2*t353*t42*t60*t62
              t844 = t50**3
              t845 = -1.066118247069528d-4*t419*t47*t49*t62*t798*t804*t8
     1           44+t821+3.2651466231542003d-3*t176*t179*t47*t49*t50*t51
     2           *t60*t61-3.2651466231542003d-3*t179*t355*t432*t47*t51*t
     3           53*t58
              t846 = t158*t845+1.066118247069528d-4*rhoa*t41*t419*t47*t4
     1           9*t62*t796*t798*t844+1.066118247069528d-4*rhob*t102*t41
     2           9*t47*t49*t62*t796*t798*t844+t826+t825+t823+t819+t818+3
     3           .2651466231542003d-3*rhoa*t179*t355*t41*t47*t51*t53*t58
     4           *t673+3.2651466231542003d-3*rhob*t102*t179*t355*t47*t51
     5           *t53*t58*t673-2.5378916076146196d-5*rhob*t176*t179*t304
     6           *t351*t47*t49*t50*t51*t62-3.2651466231542003d-3*rhoa*t1
     7           79*t41*t432*t47*t49*t50*t51*t60*t61-3.2651466231542003d
     8           -3*rhob*t102*t179*t432*t47*t49*t50*t51*t60*t61-9.715840
     9           896767151d-4*rhob*t163*t304*t351*t355*t57*t58+3.1090690
     :           86965489d-2*t139*t253*t346*t352
              t847 = 5.46875d-3*t161*t846+t843+t828+t817
              t848 = t50**4
              t849 = t351**2
              t850 = t349**2
              t851 = -2.0217363117456047d-2*gammabb*t311*t615*t95*t98+4.
     1           3244229904127585d-1*gammabb*t618*t850*t90*t95-4.3244229
     2           904127585d-1*t311*t349*t90*t95-9.350317100005212d-2*gam
     3           mabb*t311*t349*t350*t93+9.350317100005212d-2*t100*t350*
     4           t93
              t852 = 5.330591235347639d-5*t419*t47*t62*t798*t804*t848+t8
     1           33+t802-1.6325733115771002d-3*t176*t179*t47*t51*t53*t60
     2           *t61
              t853 = t158*t852-2.4289602241917876d-4*rhob*t304*t42*t57*t
     1           62*t851+2.4289602241917876d-4*rhob*t42*t57*t62*t621*t84
     2           9-5.330591235347639d-5*rhoa*t41*t419*t47*t62*t796*t798*
     3           t848-5.330591235347639d-5*rhob*t102*t419*t47*t62*t796*t
     4           798*t848+t832+t831+t830+t812+t807+t792+t791+2.537891607
     5           6146196d-5*rhob*t176*t179*t304*t351*t47*t51*t53*t62-4.8
     6           579204483835753d-4*rhob*t166*t304*t351*t57*t60*t61+1.63
     7           25733115771002d-3*rhoa*t179*t41*t432*t47*t51*t53*t60*t6
     8           1+1.6325733115771002d-3*rhob*t102*t179*t432*t47*t51*t53
     9           *t60*t61+6.218138173930978d-2*t139*t253*t339*t352
              t854 = 5.46875d-3*t161*t853+t843+t815
              t855 = -1.6406249999999997d-2*t166*t356*t58*t60*t62
              t856 = 1/t59**3
              t857 = -6.25d-2*rhoa*t125*t359*t41*t57*t856
              t858 = -6.25d-2*rhob*t102*t125*t359*t57*t856
              t859 = -3.125d-2*rhoa*t163*t355*t41*t57*t58*t61
              t860 = -3.125d-2*rhob*t102*t163*t355*t57*t58*t61
              t861 = 6.25d-2*t163*t359*t47*t56*t856
              t862 = t861-3.125d-2*t182*t355*t42*t56*t58*t61+1.25d-1*t17
     1           8*t179*t355*t42*t47*t58*t61
              t863 = t158*t862+t860+t859+t858+t857+3.125d-2*t166*t355*t4
     1           1*t57*t58*t61+3.125d-2*rhoa*t166*t216*t355*t57*t58*t61-
     2           3.125d-2*t272*t355*t42*t47*t56*t58*t61+3.125d-2*rhoa*t1
     3           66*t183*t355*t41*t58*t61+3.125d-2*rhob*t102*t166*t183*t
     4           355*t58*t61
              t864 = 3.2812499999999994d-2*t160*t163*t359*t61*t856
              t865 = 1.6406249999999997d-2*t160*t166*t355*t58*t62
              t866 = t865+t864+5.46875d-3*t161*t863+t855-1.6406249999999
     1           997d-2*t273*t355*t42*t58*t62
              t867 = 1.0d+0*t160*t357*wght
              t868 = 1.0d+0*t162*t356*wght
              t869 = 1.0d+0*t1*t160*t866*wght+1.0d+0*t1*t162*t863*wght+1
     1           .0d+0*t1*t273*t357*wght+1.0d+0*t1*t275*t356*wght+t868+t
     2           867
              t870 = t861-3.125d-2*t282*t355*t42*t56*t58*t61+1.25d-1*t17
     1           9*t281*t355*t42*t47*t58*t61
              t871 = t158*t870+t860+t859+t858+t857+3.125d-2*rhob*t166*t3
     1           15*t355*t57*t58*t61+3.125d-2*t102*t166*t355*t57*t58*t61
     2           -3.125d-2*t327*t355*t42*t47*t56*t58*t61+3.125d-2*rhoa*t
     3           166*t283*t355*t41*t58*t61+3.125d-2*rhob*t102*t166*t283*
     4           t355*t58*t61
              t872 = 5.46875d-3*t161*t871+t865+t864+t855-1.6406249999999
     1           997d-2*t328*t355*t42*t58*t62
              t873 = 1.0d+0*t1*t160*t872*wght+1.0d+0*t1*t162*t871*wght+1
     1           .0d+0*t1*t328*t357*wght+1.0d+0*t1*t329*t356*wght+t868+t
     2           867
              t874 = 1.6406249999999997d-2*t356*t42*t60*t62
              t875 = 6.25d-2*rhoa*t163*t41*t57*t58*t856
              t876 = 6.25d-2*rhob*t102*t163*t57*t58*t856
              t877 = -9.715840896767153d-4*t139*t253*t339*t355*t42*t47*t
     1           56*t58*t61
              t878 = -6.25d-2*t166*t47*t56*t58*t856
              t879 = t878+1.6325733115771002d-3*t176*t179*t355*t47*t51*t
     1           52*t58*t61
              t880 = t158*t879+t877+t876+t875+4.8579204483835753d-4*rhoa
     1           *t166*t205*t334*t355*t57*t58*t61-1.6325733115771002d-3*
     2           rhoa*t179*t355*t41*t432*t47*t51*t52*t58*t61-1.632573311
     3           5771002d-3*rhob*t102*t179*t355*t432*t47*t51*t52*t58*t61
              t881 = -3.2812499999999994d-2*t160*t166*t58*t61*t856
              t882 = -1.6406249999999997d-2*t160*t355*t42*t62
              t883 = t882+t881+5.46875d-3*t161*t880+t874-1.6406249999999
     1           997d-2*t341*t355*t42*t58*t62
              t884 = 1.0d+0*t1*t160*t883*wght+1.0d+0*t1*t162*t880*wght+1
     1           .0d+0*t1*t341*t357*wght+1.0d+0*t1*t343*t356*wght
              t885 = -1.25d-1*t166*t47*t56*t58*t856-3.2651466231542003d-
     1           3*t176*t179*t355*t47*t49*t50*t51*t58*t61
              t886 = t158*t885+1.25d-1*rhoa*t163*t41*t57*t58*t856+1.25d-
     1           1*rhob*t102*t163*t57*t58*t856-9.715840896767153d-4*t139
     2           *t253*t346*t355*t42*t47*t56*t58*t61+3.2651466231542003d
     3           -3*rhoa*t179*t355*t41*t432*t47*t49*t50*t51*t58*t61+3.26
     4           51466231542003d-3*rhob*t102*t179*t355*t432*t47*t49*t50*
     5           t51*t58*t61
              t887 = 5.46875d-3*t161*t886-6.562499999999999d-2*t160*t166
     1           *t58*t61*t856+3.2812499999999994d-2*t356*t42*t60*t62-1.
     2           6406249999999997d-2*t347*t355*t42*t58*t62-3.28124999999
     3           99994d-2*t160*t355*t42*t62
              t888 = 1.0d+0*t1*t160*t887*wght+1.0d+0*t1*t162*t886*wght+1
     1           .0d+0*t1*t347*t357*wght+1.0d+0*t1*t348*t356*wght
              t889 = t878+1.6325733115771002d-3*t176*t179*t355*t47*t51*t
     1           53*t58*t61
              t890 = t158*t889+t877+t876+t875+4.8579204483835753d-4*rhob
     1           *t166*t304*t351*t355*t57*t58*t61-1.6325733115771002d-3*
     2           rhoa*t179*t355*t41*t432*t47*t51*t53*t58*t61-1.632573311
     3           5771002d-3*rhob*t102*t179*t355*t432*t47*t51*t53*t58*t61
              t891 = 5.46875d-3*t161*t890+t882+t881+t874-1.6406249999999
     1           997d-2*t353*t355*t42*t58*t62
              t892 = 1.0d+0*t1*t160*t891*wght+1.0d+0*t1*t162*t890*wght+1
     1           .0d+0*t1*t353*t357*wght+1.0d+0*t1*t354*t356*wght
              t893 = 1/t59**4
              t894 = -9.375d-2*rhoa*t163*t359*t41*t57*t893-9.375d-2*rhob
     1           *t102*t163*t359*t57*t893+9.375d-2*t158*t166*t359*t47*t5
     2           6*t893
              t895 = 5.46875d-3*t161*t894+3.2812499999999994d-2*t160*t16
     1           6*t359*t61*t893+3.2812499999999994d-2*t160*t42*t58*t62*
     2           t856-3.2812499999999994d-2*t355*t356*t42*t58*t62
              t896 = 1.0d+0*t1*t160*t895*wght+1.0d+0*t1*t162*t894*wght+2
     1           .0d+0*t1*t356*t357*wght
              t897 = 7.8125d-1*rhoa*t355*t359*t41*t474*t57
              t898 = 7.8125d-1*rhob*t102*t355*t359*t474*t57
              t899 = -6.25d-2*rhoa*t125*t183*t41*t58*t60*t61
              t900 = 6.25d-2*rhoa*t163*t183*t216*t58*t60*t61
              t901 = 6.25d-2*t163*t183*t41*t58*t60*t61
              t902 = 6.25d-2*rhoa*t245*t41*t57*t58*t60*t61
              t903 = -6.25d-2*rhoa*t125*t216*t57*t58*t60*t61
              t904 = -6.25d-2*t125*t41*t57*t58*t60*t61
              t905 = 6.25d-2*t163*t216*t57*t58*t60*t61
              t906 = 3.125d-2*rhoa*t163*t417*t57*t58*t60*t61
              t907 = 3.125d-2*rhoa*t163*t41*t436*t58*t60*t61
              t908 = -6.25d-2*rhob*t102*t125*t183*t58*t60*t61
              t909 = 6.25d-2*rhob*t102*t245*t57*t58*t60*t61
              t910 = 3.125d-2*rhob*t102*t163*t436*t58*t60*t61
              t911 = 9.375d-2*rhoa*t125*t41*t57*t62
              t912 = 1/rhoa**3.333333333333333d+0
              t913 = 1/rhoa**3.3333333333333337d+0
              t914 = 1/rhoa**2.666666666666667d+0
              t915 = 1/t3**7
              t916 = 1/rhoa**2.0d+0
              t917 = 1/t17**3
              t918 = t198**3
              t919 = -1.269642451250142d+0*t195*t3*(7.876233178997433d-1
     1           *t4*(-5.469606374303773d-2*t13*t915*t916-1.458561699814
     2           3394d-1*t13*t189*t914-1.1708185015918181d-2*t913-1.3127
     3           055298329054d-1*t13*t374*t376)-5.469606374303773d-2*t14
     4           *t915*t916-1.4585616998143394d-1*t14*t189*t914-3.938116
     5           5894987163d-1*t189*t190*t384-1.3127055298329054d-1*t14*
     6           t374*t376+1.9690582947493582d-1*t188*t196*t376+2.625411
     7           059665811d-1*t189*t196*t375)+1.763392293402975d-2*t16*t
     8           376*t916+2.3511897245373004d-1*t16*t4*t914-6.3482122562
     9           5071d-1*t190*t195*t385*t4+1.269642451250142d+0*t190*t38
     :           2*t383*t4+4.2321415041671406d-1*t195*t197*t375*t4+7.617
     ;           854707500852d+0*t197*t3*t382*t385+7.053569173611901d-2*
     <           t16*t189*t374-7.617854707500852d+0*t197**3*t3/t15**4+1.
     =           0580353760417849d-1*t188*t189*t195*t197
              t920 = 1/t24**3
              t921 = t203**3
              t922 = -1.269642451250142d+0*t200*t3*(7.876233178997433d-1
     1           *t4*(-5.469606374303773d-2*t20*t915*t916-1.458561699814
     2           3394d-1*t189*t20*t914-6.407931356509611d-3*t913-1.31270
     3           55298329054d-1*t20*t374*t376)-5.469606374303773d-2*t21*
     4           t915*t916-1.4585616998143394d-1*t189*t21*t914-3.9381165
     5           894987163d-1*t189*t190*t391-1.3127055298329054d-1*t21*t
     6           374*t376+1.9690582947493582d-1*t188*t201*t376+2.6254110
     7           59665811d-1*t189*t201*t375)+1.763392293402975d-2*t23*t3
     8           76*t916+2.3511897245373004d-1*t23*t4*t914-6.34821225625
     9           071d-1*t190*t200*t392*t4+1.269642451250142d+0*t190*t389
     :           *t390*t4+4.2321415041671406d-1*t200*t202*t375*t4+7.6178
     ;           54707500852d+0*t202*t3*t389*t392+7.053569173611901d-2*t
     <           189*t23*t374-7.617854707500852d+0*t202**3*t3/t22**4+1.0
     =           580353760417849d-1*t188*t189*t200*t202
              t923 = 5.848223622634643d-1*(1.0d+0*(-3.37738d-2*t199*t26*
     1           t922-6.75476d-2*t26*t920*t921+1.709920934161365d+0*(6.2
     2           1814d-2*t19*t194*t919+1.243628d-1*t19*t917*t918-3.10907
     3           d-2*t12*t186*(-1.269642451250142d+0*t187*t3*(7.87623317
     4           8997433d-1*t4*(-5.469606374303773d-2*t5*t915*t916-1.458
     5           5616998143394d-1*t189*t5*t914-7.424439106586571d-3*t913
     6           -1.3127055298329054d-1*t374*t376*t5)-5.469606374303773d
     7           -2*t6*t915*t916-1.4585616998143394d-1*t189*t6*t914-1.31
     8           27055298329054d-1*t374*t376*t6-3.9381165894987163d-1*t1
     9           89*t190*t377+1.9690582947493582d-1*t188*t191*t376+2.625
     :           411059665811d-1*t189*t191*t375)+1.763392293402975d-2*t3
     ;           76*t8*t916+2.3511897245373004d-1*t4*t8*t914+7.053569173
     <           611901d-2*t189*t374*t8-7.617854707500852d+0*t192**3*t3/
     =           t7**4-6.34821225625071d-1*t187*t190*t378*t4+4.232141504
     >           1671406d-1*t187*t192*t375*t4+1.269642451250142d+0*t190*
     ?           t372*t373*t4+7.617854707500852d+0*t192*t3*t372*t378+1.0
     @           580353760417849d-1*t187*t188*t189*t192)-8.5486279330306
     1           94d-3*t18*t912+4.1099018897499934d-3*t10*t912-6.21814d-
     2           2*t12*t193**3/t9**3-1.865442d-1*t19*t198*t380*t386-8.24
     3           3319792565315d-3*t185*t194*t386+8.243319792565315d-3*t1
     4           85*t380*t381+9.327209999999999d-2*t12*t193*t370*t379+3.
     5           96311967940178d-3*t185*t186*t379-3.96311967940178d-3*t1
     6           85*t370*t371+1.0991093056753751d-2*t194*t198*t369-5.284
     7           159572535706d-3*t186*t193*t369)+2.4171930915078277d-3*t
     8           25*t912+1.013214d-1*t203*t26*t387*t393+2.33086476681112
     9           d-3*t185*t199*t393-2.33086476681112d-3*t185*t387*t388-3
     :           .107819689081493d-3*t199*t203*t369)+3.37738d-2*t199*t26
     ;           *t922+6.75476d-2*t26*t920*t921-2.4171930915078277d-3*t2
     <           5*t912-1.013214d-1*t203*t26*t387*t393-2.33086476681112d
     =           -3*t185*t199*t393+2.33086476681112d-3*t185*t387*t388+3.
     >           107819689081493d-3*t199*t203*t369)-6.21814d-2*t19*t194*
     ?           t919-1.243628d-1*t19*t917*t918+8.548627933030694d-3*t18
     @           *t912+1.865442d-1*t19*t198*t380*t386+8.243319792565315d
     1           -3*t185*t194*t386-8.243319792565315d-3*t185*t380*t381-1
     2           .0991093056753751d-2*t194*t198*t369
              t924 = rhoa**5.000000000000002d-1
              t925 = 1/rhoa**6.666666666666665d-1
              t926 = 1/rhoa**1.8333333333333332d+0
              t927 = t204**3
              t928 = exp(-1.92983810657489d+2*t27)
              t929 = 3.453411185284245d+5*gammaaa*t29*t927*t928/t31**4
              t930 = -1.252637628753944d+4*gammaaa*t206*t207*t397*t398*t
     1           399
              t931 = -3.453411185284245d+5*gammaaa*t29*t398*t399*t927
              t932 = 5.368446980374045d+3*gammaaa*t204*t29*t394*t398*t39
     1           9
              t933 = -8.240428253953201d+0*gammaaa*t32*t410*t924
              t934 = 8.829030272092719d-1*gammaaa*t32*t333*t925
              t935 = 7.007166882613269d-2*gammaaa*t207*t32*t926
              t936 = 3.4077198126375585d+2*gammaaa*t204*t209*t30*t333*t3
     1           95
              t937 = -1.6227237203036002d+1*gammaaa*t204*t207*t209*t30*t
     1           396
              t938 = 6.263188143769719d+3*gammaaa*t206*t207*t209*t30*t39
     1           7
              t939 = -9.736342321821596d+1*gammaaa*t206*t207*t209*t30*t3
     1           94
              t940 = 5.755685308807075d+4*gammaaa*t209*t29*t30*t927
              t941 = -2.6842234901870227d+3*gammaaa*t204*t209*t29*t30*t3
     1           94
              t942 = 1.3909060459745137d+1*gammaaa*t209*t29*t30*t923
              t943 = 1/t28**7.0d+0
              t944 = 1/t38**4
              t945 = 1/t40**3
              t946 = t178**3
              t947 = 1/t55**7.0d+0
              t948 = 6*t125*t43
              t949 = -6*t163
              t950 = t949+t948
              t951 = -6*t125*t43
              t952 = 6*t163
              t953 = t952+t951
              t954 = t169**3
              t955 = 1/t49**4.333333333333333d+0
              t956 = t171**3
              t957 = 1/t50**4.333333333333333d+0
              t958 = -5.959497244038482d-1*t51*t54*t673
              t959 = t958+1.3060586492616802d-2*t48*t54*(-1.037037037037
     1           0365d+1*t956*t957-1.0370370370370365d+1*t954*t955-1.333
     2           333333333333d+0*t174*t953-1.333333333333333d+0*t173*t95
     3           0+9.333333333333329d+0*t171*t422*t430+9.333333333333329
     4           d+0*t169*t425*t429)+1.3060586492616802d-2*t48*t51*(2*ga
     5           mmabb*t50*t953-2.0d+0*gammaab*t49*t953-2.0d+0*gammaab*t
     6           50*t950+2*gammaaa*t49*t950-6.0d+0*gammaab*t171*t425+6*g
     7           ammaaa*t169*t425+6*gammabb*t171*t422-6.0d+0*gammaab*t16
     8           9*t422)+3.8311053711675946d-1*t175*t432*t54-1.044846919
     9           4093442d-1*t176*t431*t54+3.8311053711675946d-1*t172*t43
     :           2*t51-1.0448469194093442d-1*t176*t428*t51+3.91817594778
     ;           5041d-2*t172*t431*t48+3.918175947785041d-2*t175*t428*t4
     <           8-2.0896938388186884d-1*t172*t175*t176
              t960 = -1.74d+0*t166*t422*t43
              t961 = t960+1.2d+1*t44*t956+2.712d+2*t180*t956+1.74d+0*t42
     1           *t43*t953+1.356d+1*t181*t953+2.0d+0*t180*t953+2.0339999
     2           999999997d+2*t171*t422*t46+1.8d+1*t171*t422*t45+1.74d+0
     3           *t42*t422+3.48d+0*t171*t422
              t962 = t56*t961-4.0d+0*t179*t47*t959-1.2d+2*t47*t946*t947+
     1           6.0d+1*t178*t419*t434*t47-1.2d+1*t178*t179*t435-1.2d+1*
     2           t179*t182*t434+6.0d+1*t182*t418*t419
              t963 = 9.375d-2*rhob*t102*t125*t57*t62
              t964 = t226**3
              t965 = 1/t112**3
              t966 = -1.243628d-1*t105*t964*t965
              t967 = 1.865442d-1*t105*t226*t439*t448
              t968 = -8.243319792565315d-3*t229*t438*t439
              t969 = 1/t1**3.3333333333333337d+0
              t970 = 1/t1**2.0d+0
              t971 = 1/t106**7
              t972 = 1/t1**2.666666666666667d+0
              t973 = -1.269642451250142d+0*t106*t225*(7.876233178997433d
     1           -1*t107*(-1.4585616998143394d-1*t108*t222*t972-5.469606
     2           374303773d-2*t108*t970*t971-1.1708185015918181d-2*t969-
     3           1.3127055298329054d-1*t108*t443*t444)-1.458561699814339
     4           4d-1*t109*t222*t972-5.469606374303773d-2*t109*t970*t971
     5           -3.9381165894987163d-1*t221*t222*t446+2.625411059665811
     6           d-1*t222*t223*t445-1.3127055298329054d-1*t109*t443*t444
     7           +1.9690582947493582d-1*t220*t223*t444)+2.35118972453730
     8           04d-1*t107*t111*t972+1.763392293402975d-2*t111*t444*t97
     9           0+7.617854707500852d+0*t106*t224*t442*t447-6.3482122562
     :           5071d-1*t107*t221*t225*t447+4.2321415041671406d-1*t107*
     ;           t224*t225*t445+7.053569173611901d-2*t111*t222*t443+1.26
     <           9642451250142d+0*t107*t221*t441*t442+1.0580353760417849
     =           d-1*t220*t222*t224*t225-7.617854707500852d+0*t106*t224*
     >           *3/t110**4
              t974 = -6.21814d-2*t105*t227*t973
              t975 = 8.243319792565315d-3*t227*t229*t448
              t976 = -1.0991093056753751d-2*t226*t227*t451
              t977 = 1/t1**3.333333333333333d+0
              t978 = 8.548627933030694d-3*t113*t977
              t979 = 1/t49**1.6666666666666669d+0
              t980 = 1/t50**1.6666666666666669d+0
              t981 = t234**3
              t982 = 1/t122**3
              t983 = 6.75476d-2*t117*t981*t982
              t984 = -1.013214d-1*t117*t234*t454*t460
              t985 = 2.33086476681112d-3*t229*t453*t454
              t986 = -1.269642451250142d+0*t106*t233*(7.876233178997433d
     1           -1*t107*(-1.4585616998143394d-1*t118*t222*t972-5.469606
     2           374303773d-2*t118*t970*t971-6.407931356509611d-3*t969-1
     3           .3127055298329054d-1*t118*t443*t444)-1.4585616998143394
     4           d-1*t119*t222*t972-5.469606374303773d-2*t119*t970*t971-
     5           3.9381165894987163d-1*t221*t222*t458+2.625411059665811d
     6           -1*t222*t231*t445-1.3127055298329054d-1*t119*t443*t444+
     7           1.9690582947493582d-1*t220*t231*t444)+2.351189724537300
     8           4d-1*t107*t121*t972+1.763392293402975d-2*t121*t444*t970
     9           +7.617854707500852d+0*t106*t232*t457*t459-6.34821225625
     :           071d-1*t107*t221*t233*t459+1.269642451250142d+0*t107*t2
     ;           21*t456*t457+4.2321415041671406d-1*t107*t232*t233*t445+
     <           7.053569173611901d-2*t121*t222*t443+1.0580353760417849d
     =           -1*t220*t222*t232*t233-7.617854707500852d+0*t106*t232**
     >           3/t120**4
              t987 = 3.37738d-2*t117*t235*t986
              t988 = -2.33086476681112d-3*t229*t235*t460
              t989 = 3.107819689081493d-3*t234*t235*t451
              t990 = -2.4171930915078277d-3*t123*t977
              t991 = t124*t125*(-3.37738d-2*t117*t235*t986-6.75476d-2*t1
     1           17*t981*t982+1.709920934161365d+0*(4.1099018897499934d-
     2           3*t132*t977-8.548627933030694d-3*t113*t977+6.21814d-2*t
     3           105*t227*t973-3.10907d-2*t126*t242*(-1.269642451250142d
     4           +0*t106*t240*(7.876233178997433d-1*t107*(-1.45856169981
     5           43394d-1*t127*t222*t972-5.469606374303773d-2*t127*t970*
     6           t971-7.424439106586571d-3*t969-1.3127055298329054d-1*t1
     7           27*t443*t444)-1.4585616998143394d-1*t128*t222*t972-5.46
     8           9606374303773d-2*t128*t970*t971-3.9381165894987163d-1*t
     9           221*t222*t468+2.625411059665811d-1*t222*t238*t445-1.312
     :           7055298329054d-1*t128*t443*t444+1.9690582947493582d-1*t
     ;           220*t238*t444)+2.3511897245373004d-1*t107*t130*t972+1.7
     <           63392293402975d-2*t130*t444*t970+7.617854707500852d+0*t
     =           106*t239*t467*t469-6.34821225625071d-1*t107*t221*t240*t
     >           469+1.269642451250142d+0*t107*t221*t466*t467+4.23214150
     ?           41671406d-1*t107*t239*t240*t445+7.053569173611901d-2*t1
     @           30*t222*t443+1.0580353760417849d-1*t220*t222*t239*t240-
     1           7.617854707500852d+0*t106*t239**3/t129**4)+1.243628d-1*
     2           t105*t964*t965+9.327209999999999d-2*t126*t241*t465*t470
     3           +3.96311967940178d-3*t229*t242*t470-3.96311967940178d-3
     4           *t229*t464*t465-5.284159572535706d-3*t241*t242*t451+1.0
     5           991093056753751d-2*t226*t227*t451-1.865442d-1*t105*t226
     6           *t439*t448-8.243319792565315d-3*t227*t229*t448+8.243319
     7           792565315d-3*t229*t438*t439-6.21814d-2*t126*t241**3/t13
     8           1**3)+2.4171930915078277d-3*t123*t977+1.013214d-1*t117*
     9           t234*t454*t460+2.33086476681112d-3*t229*t235*t460-2.330
     :           86476681112d-3*t229*t453*t454-3.107819689081493d-3*t234
     ;           *t235*t451)
              t992 = -12*t124*t245*t471
              t993 = 60*t124*t243*t474
              t994 = 36*t125*t243*t476
              t995 = -120*t124*t133/t1**7
              t996 = -144*t133*t245*t476
              t997 = 24*t125*t133*t43
              t998 = 5.848223622634648d-1*t116*(t997+t996+t995+t994+t993
     1           +t992+t991+t990+t989+t988+t987+t985+t984+t983+240*t133*
     2           t247*t474+12*t125*t247*t471-96*t243*t245*t247)+5.848223
     3           622634648d-1*t134*(-5.69973644720455d-1*t956*t980-5.699
     4           73644720455d-1*t954*t979+2.564881401242048d+0*t250*t953
     5           +2.564881401242048d+0*t249*t950+2.5648814012420473d+0*t
     6           171*t422*t480+2.5648814012420473d+0*t169*t425*t479)+t97
     7           8+t976+t975+t974+t968+t967+t966+1.7544670867903944d+0*t
     8           248*t481+1.7544670867903944d+0*t251*t478
              t999 = t256**3
              t1000 = 1/t49**2.3333333333333334d+0
              t1001 = 1/t50**2.3333333333333334d+0
              t1002 = 1.4814814814814814d-1*t1001*t956+1.481481481481481
     1           4d-1*t1000*t954+3.333333333333333d-1*t255*t953+3.333333
     2           333333333d-1*t254*t950-3.333333333333333d-1*t171*t422*t
     3           485-3.333333333333333d-1*t169*t425*t484
              t1003 = t1**5.000000000000002d-1
              t1004 = -5.191144508652046d+0*t1003*t143*t149*t155*t507*t5
     1           8
              t1005 = 1/t1**6.666666666666665d-1
              t1006 = 5.561940544984338d-1*t1005*t143*t149*t155*t338*t58
              t1007 = 1/t1**1.8333333333333332d+0
              t1008 = 4.414238527765347d-2*t1007*t143*t149*t155*t258*t58
              t1009 = -3.2690589325622216d+0*t141*t147*t268*t58*t999
              t1010 = 2.4517941994216663d+0*t141*t147*t150*t256*t486*t58
              t1011 = -5.720853131983887d+0*t147*t150*t257*t258*t483*t58
              t1012 = -2.7242157771351844d-1*t1002*t141*t144*t147*t58
              t1013 = 1.906951043994629d+0*t144*t147*t257*t258*t486*t58
              t1014 = -6.674328653981203d+0*t144*t147*t256*t338*t487*t58
              t1015 = 3.1782517399910504d-1*t144*t147*t256*t258*t489*t58
              t1016 = -5.191144508652046d+0*t1003*t143*t147*t507*t58
              t1017 = 5.561940544984338d-1*t1005*t143*t147*t338*t58
              t1018 = 4.414238527765347d-2*t1007*t143*t147*t258*t58
              t1019 = 8.172647331405554d-1*t141*t144*t145*t256*t262*t496
     1           *t58
              t1020 = 9.534755219973146d-1*t143*t145*t257*t258*t262*t496
     1           *t58
              t1021 = -2.4517941994216663d+0*t141*t145*t150*t262*t263*t4
     1           83*t58
              t1022 = 8.172647331405554d-1*t141*t144*t145*t262*t263*t486
     1           *t58
              t1023 = -3.813902087989258d+0*t144*t145*t256*t257*t258*t26
     1           2*t263*t58
              t1024 = -3.3371643269906015d+0*t143*t145*t262*t263*t338*t4
     1           87*t58
              t1025 = 1.5891258699955252d-1*t143*t145*t258*t262*t263*t48
     1           9*t58
              t1026 = 8.172647331405554d-1*t141*t143*t263*t496*t500*t501
     1           *t58
              t1027 = -4.086323665702777d-1*t141*t143*t145*t262*t263*t49
     1           6*t58
              t1028 = 1.9298381065748896d+2*t135*t150*t256-6.43279368858
     1           2966d+1*t144*t252
              t1029 = 2.7242157771351844d-1*t1028*t141*t143*t500*t501*t5
     1           02*t58
              t1030 = 1.9298381065748896d+3*t135*t511*t999-3.21639684429
     1           1483d+1*t144*t998-1.1579028639449339d+3*t135*t256*t268*
     2           t486+2.8947571598623345d+2*t150*t252*t486-1.15790286394
     3           49339d+3*t252*t268*t483+2.8947571598623345d+2*t150*t256
     4           *t482+9.649190532874448d+1*t1002*t135*t150
              t1031 = -1.3621078885675922d-1*t1030*t141*t143*t145*t262*t
     1           58
              t1032 = -1.6345294662811108d+0*t141*t144*t256*t500*t501*t5
     1           02*t58
              t1033 = -1.906951043994629d+0*t143*t257*t258*t500*t501*t50
     1           2*t58
              t1034 = 8.172647331405554d-1*t141*t144*t145*t256*t262*t502
     1           *t58
              t1035 = 9.534755219973146d-1*t143*t145*t257*t258*t262*t502
     1           *t58
              t1036 = t263**3
              t1037 = 2.7242157771351844d-1*t1036*t141*t143*t500*t501*t5
     1           8
              t1038 = 1/t146**4
              t1039 = -8.172647331405554d-1*t1036*t1038*t141*t143*t145*t
     1           500*t58
              t1040 = -1.3621078885675922d-1*t1036*t141*t143*t145*t262*t
     1           58
              t1041 = -1.7316487067581932d+0*t151*t153*t257*t258*t483*t5
     1           11*t58
              t1042 = 3.4632974135163863d-1*t151*t153*t257*t258*t268*t48
     1           6*t58
              t1043 = 1/t140**7.0d+0
              t1044 = -3.5354494429646444d+0*t1003*t1043*t150*t153*t359
              t1045 = 2.525321030689033d-1*t1005*t150*t153*t359*t508
              t1046 = 1.2025338241376346d-2*t1007*t150*t153*t359*t507
              t1047 = 1/t138**7.0d+0
              t1048 = 1.7316487067581932d-1*t145*t150*t151*t257*t258*t26
     1           9*t496*t58
              t1049 = -1.3853189654065545d+0*t145*t151*t256*t257*t258*t2
     1           63*t268*t269*t58
              t1050 = -5.19494612027458d-1*t150*t151*t257*t258*t500*t502
     1           *t513*t58
              t1051 = 1.7316487067581932d-1*t145*t150*t151*t257*t258*t26
     1           9*t502*t58
              t1052 = exp(-9.649190532874448d+1*t135*t144)
              t1053 = 1/t146**5.0d+0
              t1054 = 1/t154**4
              t1055 = 1/t156**3
              t1056 = -3.75d-1*t245*t355*t359*t47*t56
              t1057 = -6.25d-1*t166*t418*t419*t47*t58*t60*t61
              t1058 = 1.25d-1*t166*t179*t434*t47*t58*t60*t61
              t1059 = 2.5d-1*t166*t178*t179*t182*t58*t60*t61
              t1060 = -3.125d-2*t166*t435*t56*t58*t60*t61
              t1061 = t159*(3.109069086965489d-2*t139*t253*(-1.362107888
     1           5675922d-1*t141*t143*t149*t266*t58*(-2.226405480117677d
     2           +0*t1047*t152*t153*t999-1.0389892240549159d+0*t150*t257
     3           *t359*t500*t502*t507*t513-1.3358432880706061d+0*t152*t2
     4           56*t268*t500*t502*t513+1.1132027400588385d-1*t1028*t150
     5           *t152*t500*t502*t513+3.3396082201765154d-1*t150*t152*t2
     6           63*t496*t500*t513+1.1132027400588385d-1*t1036*t150*t152
     7           *t500*t513-3.4632974135163863d+0*t153*t257*t359*t483*t5
     8           07*t511+1.1132027400588385d+0*t152*t153*t256*t486*t511-
     9           2.226405480117677d+0*t145*t152*t263*t269*t483*t511-3.03
     :           0385236826838d+0*t145*t150*t263*t269*t359*t487*t508-6.0
     ;           60770473653676d+0*t153*t256*t268*t359*t487*t508+3.46329
     <           74135163863d-1*t145*t150*t257*t269*t359*t502*t507+3.463
     =           2974135163863d-1*t145*t150*t257*t269*t359*t496*t507+8.6
     >           5824353379097d-2*t145*t150*t263*t269*t359*t489*t507+1.7
     ?           31648706758194d-1*t153*t256*t268*t359*t489*t507+6.92659
     @           4827032773d-1*t153*t257*t268*t359*t486*t507-2.770637930
     1           813109d+0*t145*t256*t257*t263*t268*t269*t359*t507+4.452
     2           810960235354d-1*t145*t152*t256*t268*t269*t502+4.4528109
     3           60235354d-1*t145*t152*t256*t268*t269*t496-1.11320274005
     4           88385d-1*t145*t150*t152*t263*t269*t496+4.45281096023535
     5           4d-1*t145*t152*t263*t268*t269*t486-3.710675800196128d-2
     6           *t1036*t145*t150*t152*t269-3.710675800196128d-2*t1030*t
     7           145*t150*t152*t269-7.421351600392256d-2*t1002*t152*t153
     8           *t268-4.452810960235354d-1*t1036*t1052*t1053*t150*t152+
     9           t1051+t1050+t1049+t1048+t1046+t1045+t1044+t1042+t1041+t
     :           1040+t1039+t1037+t1035+t1034+t1033+t1032+t1031+t1029+t1
     ;           027+t1026+t1025+t1024+t1023+t1022+t1021+t1020+t1019+t10
     <           18+t1017+t1016+t1015+t1014+t1013+t1012+t1011+t1010+t100
     =           9)-3.2690589325622216d+0*t141*t149*t155*t268*t58*t999+8
     >           .172647331405554d-1*t141*t143*t265*t515*t516*t58-1.9069
     ?           51043994629d+0*t143*t149*t257*t258*t515*t516*t58-1.6345
     @           294662811108d+0*t141*t144*t149*t256*t515*t516*t58+8.172
     1           647331405554d-1*t141*t143*t149*t270*t514*t515*t58-4.086
     2           323665702777d-1*t141*t143*t265*t266*t514*t58+9.53475521
     3           9973146d-1*t143*t149*t257*t258*t266*t514*t58+8.17264733
     4           1405554d-1*t141*t144*t149*t256*t266*t514*t58-4.08632366
     5           5702777d-1*t141*t143*t266*t270*t505*t58-9.5347552199731
     6           46d-1*t143*t155*t257*t258*t505*t58-8.172647331405554d-1
     7           *t141*t144*t155*t256*t505*t58+1.5891258699955252d-1*t14
     8           3*t149*t258*t266*t270*t489*t58-1.5891258699955252d-1*t1
     9           43*t155*t258*t265*t489*t58+3.1782517399910504d-1*t144*t
     :           149*t155*t256*t258*t489*t58-3.3371643269906015d+0*t143*
     ;           t149*t266*t270*t338*t487*t58+3.3371643269906015d+0*t143
     <           *t155*t265*t338*t487*t58-6.674328653981203d+0*t144*t149
     =           *t155*t256*t338*t487*t58+8.172647331405554d-1*t141*t144
     >           *t149*t266*t270*t486*t58-8.172647331405554d-1*t141*t144
     ?           *t155*t265*t486*t58+1.906951043994629d+0*t144*t149*t155
     @           *t257*t258*t486*t58+2.4517941994216663d+0*t141*t149*t15
     1           0*t155*t256*t486*t58-2.4517941994216663d+0*t141*t149*t1
     2           50*t266*t270*t483*t58+2.4517941994216663d+0*t141*t150*t
     3           155*t265*t483*t58-5.720853131983887d+0*t149*t150*t155*t
     4           257*t258*t483*t58-8.172647331405554d-1*t1054*t141*t143*
     5           t149*t270**3*t58+1.906951043994629d+0*t143*t257*t258*t2
     6           65*t266*t270*t58+1.6345294662811108d+0*t141*t144*t256*t
     7           265*t266*t270*t58-3.813902087989258d+0*t144*t149*t256*t
     8           257*t258*t266*t270*t58+3.813902087989258d+0*t144*t155*t
     9           256*t257*t258*t265*t58-2.7242157771351844d-1*t1002*t141
     :           *t144*t149*t155*t58+1.3621078885675922d-1*(t1040+t1039+
     ;           t1037+t1035+t1034+t1033+t1032+t1031+t1029+t1027+t1026+t
     <           1025+t1024+t1023+t1022+t1021+t1020+t1019+t1018+t1017+t1
     =           016+t1015+t1014+t1013+t1012+t1011+t1010+t1009)*t141*t14
     >           3*t155*t58+t1008+t1006+t1004)+1.8654414521792934d-1*t15
     ?           7*t999+1.0d+0*t998-2.7981621782689403d-1*t142*t256*t518
     @           *t519-9.327207260896466d-2*t139*t271*t517*t518+2.798162
     1           1782689403d-1*t142*t253*t256*t517+2.7981621782689403d-1
     2           *t142*t253*t271*t486+5.596324356537881d-1*t138*t157*t25
     3           6*t486+5.596324356537881d-1*t138*t253*t271*t483+6.21813
     4           8173930978d-2*t1055*t139*t271**3+9.327207260896466d-2*t
     5           1002*t142*t157)+t963-1.5625d-2*rhoa*t41*t42*t62*t962-1.
     6           5625d-2*rhob*t102*t42*t62*t962+t158*(1.5625d-2*t56*t62*
     7           t961-6.25d-2*t179*t47*t62*t959-1.875d+0*t47*t62*t946*t9
     8           47+9.375d-1*t178*t419*t434*t47*t62-1.875d-1*t178*t179*t
     9           435*t62-1.875d-1*t179*t182*t434*t62+9.375d-1*t182*t418*
     :           t419*t62-6.25d-2*t163*t355*t359*t435*t56+2.8125d-1*t125
     ;           *t182*t355*t359*t56+2.5d-1*t163*t179*t355*t359*t434*t47
     <           -1.25d+0*t163*t355*t359*t418*t419*t47-1.125d+0*t125*t17
     =           8*t179*t355*t359*t47+5.0d-1*t163*t178*t179*t182*t355*t3
     >           59+t1060+t1059+t1058+t1057+t1056)-1.5625d-2*rhoa*t42*t5
     ?           7*t62*(3.1090690869654886d-2*t215**3*t945+1.55453454348
     @           27443d-2*t205*(-1.2973268971238278d+0*gammaaa*t214**3*t
     1           29*t34*t944-2.1622114952063792d-1*gammaaa*t212*t29*t34*
     2           (-8.908774348060522d+0*t37*t408*t924*t943+t942+t941+t94
     3           0+t939+t938+t937+t936+t935+t934+t933+t932+t931+t930+t92
     4           9+2.9868021449983523d+5*t36*t927*t928/t31**5.0d+0-2.240
     5           1016087487644d+5*t36*t398*t407*t927+2.4890017874986267d
     6           +4*t213*t30*t36*t927+3.030195356483172d-2*t37*t408*t410
     7           *t926+6.363410248614662d-1*t37*t408*t409*t925+6.0148660
     8           82716293d+0*t213*t30*t36*t923-1.0833869920879355d+4*t20
     9           6*t397*t398*t407*t408*t410+3.6112899736264514d+3*t206*t
     :           213*t30*t397*t408*t410-1.4034687526338024d+1*t204*t213*
     ;           t30*t396*t408*t410-5.613875010535206d+1*t206*t213*t30*t
     <           394*t408*t410+4.912140634218306d+2*t204*t213*t30*t395*t
     =           408*t409-5.416934960439678d+3*gammaaa*t206*t207*t35*t39
     >           7*t398*t407+3.482315331711221d+3*t204*t36*t394*t398*t40
     ?           7+1.8056449868132257d+3*gammaaa*t206*t207*t213*t30*t35*
     @           t397-1.1607717772370736d+3*t204*t213*t30*t36*t394-2.806
     1           937505267603d+1*gammaaa*t206*t207*t213*t30*t35*t394)+2.
     2           1622114952063792d-1*gammaaa*t29*t39*(t942+t941+t940+t93
     3           9+t938+t937+t936+t935+t934+t933+t932+t931+t930+t929)+7.
     4           007166882613269d-2*gammaaa*t207*t34*t39*t926+8.82903027
     5           2092719d-1*gammaaa*t333*t34*t39*t925-8.240428253953201d
     6           +0*gammaaa*t34*t39*t410*t924-3.027096093288931d+0*gamma
     7           aa*t206*t207*t34*t412*t413+1.2973268971238278d+0*gammaa
     8           a*t211*t29*t412*t413+1.2973268971238278d+0*gammaaa*t214
     9           *t29*t34*t411*t412+1.5135480466444656d+0*gammaaa*t206*t
     :           207*t212*t34*t411-6.486634485619138d-1*gammaaa*t211*t21
     ;           2*t29*t411-1.5135480466444656d+0*gammaaa*t206*t207*t39*
     <           t406-6.486634485619138d-1*gammaaa*t212*t214*t29*t406-2.
     =           522580077740777d-1*gammaaa*t207*t211*t39*t396+2.5225800
     >           77740777d-1*gammaaa*t207*t212*t214*t34*t396+5.297418163
     ?           255629d+0*gammaaa*t211*t333*t39*t395-5.297418163255629d
     @           +0*gammaaa*t212*t214*t333*t34*t395+3.027096093288931d+0
     1           *gammaaa*t206*t207*t211*t212*t214)+1.0d+0*t923-4.663603
     2           6304482326d-2*t215*t414*t415)+t911+t910+t909+t908+t907+
     3           t906+t905+t904+t903+t902+t901+t900+t899+t898+t897-4.687
     4           5d-2*t417*t42*t57*t62+4.6875d-2*rhoa*t166*t417*t57*t62-
     5           9.375d-2*t163*t41*t57*t62+9.375d-2*t166*t216*t57*t62-9.
     6           375d-2*rhoa*t163*t216*t57*t62-4.6875d-2*t41*t42*t436*t6
     7           2-4.6875d-2*rhoa*t216*t42*t436*t62+4.6875d-2*rhoa*t166*
     8           t41*t436*t62+4.6875d-2*rhob*t102*t166*t436*t62-4.6875d-
     9           2*rhoa*t183*t417*t42*t62-9.375d-2*t183*t216*t42*t62+9.3
     :           75d-2*t166*t183*t41*t62-9.375d-2*rhoa*t163*t183*t41*t62
     ;           +9.375d-2*rhoa*t166*t183*t216*t62-9.375d-2*rhob*t102*t1
     <           63*t183*t62+6.25d-2*rhoa*t125*t355*t359*t417*t57-4.0625
     =           d-1*t245*t355*t359*t41*t57-4.0625d-1*rhoa*t216*t245*t35
     >           5*t359*t57+1.25d-1*t125*t216*t355*t359*t57+3*t272*t524+
     ?           3*t219*t520+6.25d-2*rhoa*t125*t355*t359*t41*t436+6.25d-
     @           2*rhob*t102*t125*t355*t359*t436-4.0625d-1*rhoa*t183*t24
     1           5*t355*t359*t41+1.25d-1*t125*t183*t355*t359*t41-4.0625d
     2           -1*rhob*t102*t183*t245*t355*t359+1.25d-1*rhoa*t125*t183
     3           *t216*t355*t359
              t1062 = t58**3
              t1063 = 6.562499999999999d-2*t125*t273*t355*t359*t61
              t1064 = -1.6406249999999997d-1*t1062*t160*t474*t856
              t1065 = -6.562499999999999d-2*t160*t245*t355*t359*t61
              t1066 = -9.843749999999998d-2*t125*t160*t58*t60*t62
              t1067 = 2.0d+0*t160*t564*wght
              t1068 = 2.0d+0*t273*t329*wght
              t1069 = 2.0d+0*t275*t328*wght
              t1070 = 2.0d+0*t162*t563*wght
              t1071 = 3.125d-2*rhoa*t166*t41*t537*t62
              t1072 = 3.125d-2*rhoa*t166*t216*t283*t62
              t1073 = 3.125d-2*t166*t283*t41*t62
              t1074 = -6.965646129395628d-2*t172*t176*t280
              t1075 = -6.965646129395628d-2*t175*t176*t279
              t1076 = -6.965646129395628d-2*t176*t51*t533
              t1077 = t948-2*t163
              t1078 = t951+2*t163
              t1079 = -6.965646129395628d-2*t176*t534*t54
              t1080 = t958+1.3060586492616802d-2*t48*t54*(-1.03703703703
     1           70365d+1*t277*t427*t957-1.0370370370370365d+1*t278*t426
     2           *t955+1.244444444444444d+1*t163*t171*t43*t430+3.1111111
     3           1111111d+0*t277*t422*t430-1.244444444444444d+1*t163*t16
     4           9*t429*t43+3.11111111111111d+0*t278*t425*t429-1.3333333
     5           33333333d+0*t1078*t174-1.333333333333333d+0*t1077*t173)
     6           +1.2770351237225316d-1*t280*t432*t54+2.5540702474450633
     7           d-1*t175*t432*t54-3.482823064697814d-2*t176*t431*t54+2.
     8           6121172985233604d-2*t172*t48*t534+2.6121172985233604d-2
     9           *t175*t48*t533+1.3060586492616802d-2*t48*(2*gammabb*t10
     :           78*t50-2.0d+0*gammaab*t1077*t50-2.0d+0*gammaab*t1078*t4
     ;           9+2*gammaaa*t1077*t49+8*gammabb*t163*t171*t43+8.0d+0*ga
     <           mmaab*t163*t171*t43-8.0d+0*gammaab*t163*t169*t43-8*gamm
     =           aaa*t163*t169*t43+2*gammaaa*t278*t425-2.0d+0*gammaab*t2
     >           77*t425-2.0d+0*gammaab*t278*t422+2*gammabb*t277*t422)*t
     ?           51+1.2770351237225316d-1*t279*t432*t51+2.55407024744506
     @           33d-1*t172*t432*t51-3.482823064697814d-2*t176*t428*t51+
     1           1.3060586492616802d-2*t279*t431*t48+1.3060586492616802d
     2           -2*t280*t428*t48-6.965646129395628d-2*t172*t175*t176+t1
     3           079+t1076+t1075+t1074
              t1081 = t960+2.712d+2*t163*t171*t43*t46+6.779999999999999d
     1           +1*t277*t422*t46+2.4d+1*t163*t171*t43*t45+6.0d+0*t277*t
     2           422*t45+1.2d+1*t277*t427*t44+1.74d+0*t1078*t42*t43+6.96
     3           d+0*t163*t171*t43+2.712d+2*t180*t277*t427-1.74d+0*t42*t
     4           422+1.356d+1*t1078*t181+2.0d+0*t1078*t180
              t1082 = -1.2d+2*t281*t418*t47*t947+t1081*t56-8.0d+0*t178*t
     1           179*t536+4.0d+1*t178*t419*t47*t535-8.0d+0*t179*t182*t53
     2           5+2.0d+1*t281*t419*t434*t47-4.0d+0*t1080*t179*t47-4.0d+
     3           0*t179*t281*t435-4.0d+0*t179*t282*t434+2.0d+1*t282*t418
     4           *t419+4.0d+1*t178*t182*t281*t419
              t1083 = 3.125d-2*rhob*t166*t183*t315*t62
              t1084 = 3.125d-2*t102*t166*t183*t62
              t1085 = 3.125d-2*rhob*t102*t166*t537*t62
              t1086 = -12*t125*t243*t476
              t1087 = 48*t133*t245*t476
              t1088 = -24*t125*t133*t43
              t1089 = 5.848223622634648d-1*t116*(t995+t993+t992+t991+t99
     1           0+t989+t988+t987+t985+t984+t983+80*t133*t247*t474+4*t12
     2           5*t247*t471-32*t243*t245*t247+t1088+t1087+t1086)+5.8482
     3           23622634648d-1*t134*(-5.69973644720455d-1*t277*t427*t98
     4           0-5.69973644720455d-1*t278*t426*t979+3.41984186832273d+
     5           0*t163*t171*t43*t480+8.549604670806825d-1*t277*t422*t48
     6           0-3.41984186832273d+0*t163*t169*t43*t479+8.549604670806
     7           825d-1*t278*t425*t479+2.564881401242048d+0*t1078*t250+2
     8           .564881401242048d+0*t1077*t249)+t978+t976+t975+t974+t96
     9           8+t967+t966+1.1696447245269297d+0*t248*t542+1.169644724
     :           5269297d+0*t251*t541+5.848223622634648d-1*t317*t481+5.8
     ;           48223622634648d-1*t318*t478
              t1090 = -3.813902087989258d+0*t149*t150*t155*t256*t257*t25
     1           8*t320*t58
              t1091 = 1.2713006959964196d+0*t144*t149*t155*t257*t258*t54
     1           4*t58
              t1092 = -4.444444444444444d-1*t163*t171*t43*t485-1.1111111
     1           11111111d-1*t277*t422*t485+4.444444444444444d-1*t163*t1
     2           69*t43*t484-1.111111111111111d-1*t278*t425*t484+1.48148
     3           14814814814d-1*t1001*t277*t427+1.4814814814814814d-1*t1
     4           000*t278*t426+3.333333333333333d-1*t1078*t255+3.3333333
     5           33333333d-1*t1077*t254
              t1093 = 1.2713006959964196d+0*t144*t155*t256*t257*t258*t32
     1           4*t58
              t1094 = -1.2713006959964196d+0*t144*t149*t256*t257*t258*t2
     1           66*t325*t58
              t1095 = 1.2713006959964196d+0*t144*t155*t257*t258*t265*t32
     1           0*t58
              t1096 = 6.356503479982097d-1*t143*t257*t258*t265*t266*t325
     1           *t58
              t1097 = -1.2713006959964196d+0*t144*t149*t257*t258*t266*t2
     1           70*t320*t58
              t1098 = 6.356503479982097d-1*t143*t257*t258*t266*t270*t324
     1           *t58
              t1099 = -1.2713006959964196d+0*t143*t149*t257*t258*t270*t3
     1           25*t515*t58
              t1100 = -6.356503479982097d-1*t143*t155*t257*t258*t557*t58
              t1101 = 6.356503479982097d-1*t143*t149*t257*t258*t266*t560
     1           *t58
              t1102 = -3.2690589325622216d+0*t141*t147*t268*t320*t483*t5
     1           8
              t1103 = 8.172647331405554d-1*t141*t147*t150*t320*t486*t58
              t1104 = 1.6345294662811108d+0*t141*t147*t150*t256*t544*t58
              t1105 = -3.813902087989258d+0*t147*t150*t256*t257*t258*t32
     1           0*t58
              t1106 = -1.9069510439946294d+0*t147*t150*t257*t258*t483*t5
     1           8
              t1107 = 1.2713006959964196d+0*t144*t147*t257*t258*t544*t58
              t1108 = -2.7242157771351844d-1*t1092*t141*t144*t147*t58
              t1109 = 6.356503479982097d-1*t144*t147*t257*t258*t486*t58
              t1110 = -2.2247762179937342d+0*t144*t147*t320*t338*t487*t5
     1           8
              t1111 = 1.0594172466636834d-1*t144*t147*t258*t320*t489*t58
              t1112 = -4.4495524359874683d+0*t144*t147*t256*t338*t487*t5
     1           8
              t1113 = 2.1188344933273667d-1*t144*t147*t256*t258*t489*t58
              t1114 = 5.448431554270369d-1*t141*t144*t145*t256*t262*t549
     1           *t58
              t1115 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t549
     1           *t58
              t1116 = 2.7242157771351844d-1*t141*t144*t145*t262*t320*t49
     1           6*t58
              t1117 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t49
     1           6*t58
              t1118 = -8.172647331405554d-1*t141*t145*t150*t262*t322*t48
     1           3*t58
              t1119 = 2.7242157771351844d-1*t141*t144*t145*t262*t322*t48
     1           6*t58
              t1120 = -1.2713006959964196d+0*t144*t145*t256*t257*t258*t2
     1           62*t322*t58
              t1121 = -1.1123881089968671d+0*t143*t145*t262*t322*t338*t4
     1           87*t58
              t1122 = 5.297086233318417d-2*t143*t145*t258*t262*t322*t489
     1           *t58
              t1123 = 2.7242157771351844d-1*t141*t143*t322*t496*t500*t50
     1           1*t58
              t1124 = -1.3621078885675922d-1*t141*t143*t145*t262*t322*t4
     1           96*t58
              t1125 = -1.6345294662811108d+0*t141*t145*t150*t256*t262*t2
     1           63*t320*t58
              t1126 = 5.448431554270369d-1*t141*t144*t145*t262*t263*t544
     1           *t58
              t1127 = -1.2713006959964196d+0*t144*t145*t257*t258*t262*t2
     1           63*t320*t58
              t1128 = -1.2713006959964196d+0*t144*t145*t256*t257*t258*t2
     1           62*t263*t58
              t1129 = -2.2247762179937342d+0*t143*t145*t262*t263*t338*t4
     1           87*t58
              t1130 = 1.0594172466636834d-1*t143*t145*t258*t262*t263*t48
     1           9*t58
              t1131 = 5.448431554270369d-1*t141*t143*t263*t500*t501*t549
     1           *t58
              t1132 = -2.7242157771351844d-1*t141*t143*t145*t262*t263*t5
     1           49*t58
              t1133 = -1.0896863108540737d+0*t141*t144*t256*t263*t322*t5
     1           00*t501*t58
              t1134 = -1.2713006959964196d+0*t143*t257*t258*t263*t322*t5
     1           00*t501*t58
              t1135 = 5.448431554270369d-1*t141*t144*t145*t256*t262*t263
     1           *t322*t58
              t1136 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t263
     1           *t322*t58
              t1137 = -7.719352426299558d+2*t135*t256*t268*t544+1.929838
     1           1065748896d+2*t150*t252*t544+1.9298381065748896d+2*t150
     2           *t256*t543+1.9298381065748896d+3*t135*t320*t483*t511-3.
     3           859676213149779d+2*t135*t268*t320*t486+9.64919053287444
     4           8d+1*t150*t319*t486-3.859676213149779d+2*t268*t319*t483
     5           +9.649190532874448d+1*t150*t320*t482-7.719352426299558d
     6           +2*t252*t256*t268*t320+9.649190532874448d+1*t1092*t135*
     7           t150-3.216396844291483d+1*t1089*t144
              t1138 = -1.3621078885675922d-1*t1137*t141*t143*t145*t262*t
     1           58
              t1139 = -5.448431554270369d-1*t141*t144*t320*t500*t501*t50
     1           2*t58
              t1140 = -6.356503479982097d-1*t143*t257*t258*t500*t501*t50
     1           2*t58
              t1141 = 2.7242157771351844d-1*t141*t144*t145*t262*t320*t50
     1           2*t58
              t1142 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t50
     1           2*t58
              t1143 = 2.7242157771351844d-1*t141*t143*t322*t500*t501*t50
     1           2*t58
              t1144 = -8.172647331405554d-1*t1038*t141*t143*t145*t322*t5
     1           00*t502*t58
              t1145 = -1.3621078885675922d-1*t141*t143*t145*t262*t322*t5
     1           02*t58
              t1146 = 1.9298381065748896d+2*t135*t150*t320-6.43279368858
     1           2966d+1*t144*t319
              t1147 = 2.7242157771351844d-1*t1146*t141*t143*t500*t501*t5
     1           02*t58
              t1148 = t963+t158*(-1.875d+0*t281*t418*t47*t62*t947+1.5625
     1           d-2*t1081*t56*t62-1.25d-1*t178*t179*t536*t62+6.25d-1*t1
     2           78*t419*t47*t535*t62-1.25d-1*t179*t182*t535*t62+3.125d-
     3           1*t281*t419*t434*t47*t62-6.25d-2*t1080*t179*t47*t62-6.2
     4           5d-2*t179*t281*t435*t62-6.25d-2*t179*t282*t434*t62+3.12
     5           5d-1*t282*t418*t419*t62+6.25d-1*t178*t182*t281*t419*t62
     6           -6.25d-2*t163*t355*t359*t536*t56+9.375d-2*t125*t282*t35
     7           5*t359*t56+1.875d-1*t125*t182*t355*t359*t56+2.5d-1*t163
     8           *t179*t355*t359*t47*t535-1.25d+0*t163*t178*t281*t355*t3
     9           59*t419*t47-3.75d-1*t125*t179*t281*t355*t359*t47-7.5d-1
     :           *t125*t178*t179*t355*t359*t47+2.5d-1*t163*t178*t179*t28
     ;           2*t355*t359+2.5d-1*t163*t179*t182*t281*t355*t359+t1060+
     <           t1059+t1058+t1057+t1056)+t911+t910+t909+t908+t907+t906+
     =           t905+t904+t903+t902+t901+t900+t899+t898+t897+1.5625d-2*
     >           rhoa*t166*t417*t57*t62-6.25d-2*t163*t41*t57*t62-3.125d-
     ?           2*rhob*t163*t315*t57*t62+3.125d-2*t166*t216*t57*t62-6.2
     @           5d-2*rhoa*t163*t216*t57*t62-3.125d-2*t102*t163*t57*t62-
     1           3.125d-2*t41*t42*t537*t62-3.125d-2*rhoa*t216*t42*t537*t
     2           62-1.5625d-2*rhob*t315*t42*t436*t62-1.5625d-2*t102*t42*
     3           t436*t62+1.5625d-2*rhoa*t166*t41*t436*t62+1.5625d-2*rho
     4           b*t102*t166*t436*t62-1.5625d-2*rhoa*t283*t417*t42*t62-1
     5           .5625d-2*rhoa*t1082*t41*t42*t62-3.125d-2*t216*t283*t42*
     6           t62-1.5625d-2*rhob*t102*t1082*t42*t62-3.125d-2*rhoa*t16
     7           3*t283*t41*t62+3.125d-2*t166*t183*t41*t62-6.25d-2*rhoa*
     8           t163*t183*t41*t62-3.125d-2*rhob*t102*t163*t283*t62+3.12
     9           5d-2*rhoa*t166*t183*t216*t62-6.25d-2*rhob*t102*t163*t18
     :           3*t62+t159*(3.109069086965489d-2*t139*t253*(5.448431554
     ;           270369d-1*t141*t143*t149*t270*t515*t560*t58-2.724215777
     <           1351844d-1*t141*t143*t265*t266*t560*t58+5.4484315542703
     =           69d-1*t141*t144*t149*t256*t266*t560*t58-2.7242157771351
     >           844d-1*t141*t143*t266*t270*t557*t58-5.448431554270369d-
     ?           1*t141*t144*t155*t256*t557*t58-1.3621078885675922d-1*t1
     @           41*t143*t149*t266*(2.226405480117677d-1*t150*t152*t263*
     1           t500*t513*t549+3.4632974135163863d-1*t145*t150*t257*t26
     2           9*t359*t507*t549+2.9685406401569026d-1*t145*t152*t256*t
     3           268*t269*t549-7.421351600392256d-2*t145*t150*t152*t263*
     4           t269*t549+7.421351600392256d-1*t152*t153*t256*t511*t544
     5           +6.926594827032773d-1*t153*t257*t268*t359*t507*t544+2.9
     6           685406401569026d-1*t145*t152*t263*t268*t269*t544-1.0389
     7           892240549159d+0*t150*t257*t263*t322*t359*t500*t507*t513
     8           +1.1132027400588385d-1*t150*t152*t322*t500*t502*t513-4.
     9           452810960235354d-1*t152*t268*t320*t500*t502*t513+1.1132
     :           027400588385d-1*t1146*t150*t152*t500*t502*t513+1.113202
     ;           7400588385d-1*t150*t152*t322*t496*t500*t513-8.905621920
     <           470708d-1*t152*t256*t263*t268*t322*t500*t513-3.46329741
     =           35163863d+0*t153*t256*t257*t320*t359*t507*t511+3.710675
     >           800196128d-1*t152*t153*t320*t486*t511-7.421351600392256
     ?           d-1*t145*t152*t269*t322*t483*t511-1.4842703200784513d+0
     @           *t145*t152*t256*t263*t269*t320*t511-1.0101284122756127d
     1           +0*t145*t150*t269*t322*t359*t487*t508-2.020256824551225
     2           3d+0*t153*t268*t320*t359*t487*t508-2.0202568245512253d+
     3           0*t145*t150*t263*t269*t359*t487*t508-4.0405136491024507
     4           d+0*t153*t256*t268*t359*t487*t508+2.886081177930323d-2*
     5           t145*t150*t269*t322*t359*t489*t507+5.772162355860646d-2
     6           *t153*t268*t320*t359*t489*t507+5.772162355860646d-2*t14
     7           5*t150*t263*t269*t359*t489*t507+1.1544324711721293d-1*t
     8           153*t256*t268*t359*t489*t507-1.3853189654065545d+0*t145
     9           *t256*t257*t268*t269*t322*t359*t507+3.4632974135163863d
     :           -1*t145*t150*t257*t263*t269*t322*t359*t507-1.3853189654
     ;           065545d+0*t145*t257*t263*t268*t269*t320*t359*t507-3.710
     <           675800196128d-2*t145*t150*t152*t269*t322*t502-4.4528109
     =           60235354d-1*t1052*t1053*t150*t152*t322*t502+1.484270320
     >           0784513d-1*t145*t152*t268*t269*t320*t502-3.710675800196
     ?           128d-2*t145*t150*t152*t269*t322*t496+1.4842703200784513
     @           d-1*t145*t152*t268*t269*t320*t496+1.4842703200784513d-1
     1           *t145*t152*t268*t269*t322*t486-2.226405480117677d+0*t10
     2           47*t152*t153*t320*t483+2.9685406401569026d-1*t145*t152*
     3           t256*t263*t268*t269*t322-3.710675800196128d-2*t1137*t14
     4           5*t150*t152*t269-7.421351600392256d-2*t1092*t152*t153*t
     5           268+t1147+t1145+t1144+t1143+t1142+t1141+t1140+t1139+t11
     6           38+t1136+t1135+t1134+t1133+t1132+t1131+t1130+t1129+t112
     7           8+t1127+t1126+t1125+t1124+t1123+t1122+t1121+t1120+t1119
     8           +t1118+t1117+t1116+t1115+t1114+t1113+t1112+t1111+t1110+
     9           t1109+t1108+t1107+t1106+t1105+t1104+t1103+t1102+t1051+t
     :           1050+t1049+t1048+t1046+t1045+t1044+t1042+t1041+t1018+t1
     ;           017+t1016)*t58+5.448431554270369d-1*t141*t144*t149*t266
     <           *t270*t544*t58-5.448431554270369d-1*t141*t144*t155*t265
     =           *t544*t58+1.6345294662811108d+0*t141*t149*t150*t155*t25
     >           6*t544*t58+2.7242157771351844d-1*t141*t143*t324*t515*t5
     ?           16*t58-5.448431554270369d-1*t141*t144*t149*t320*t515*t5
     @           16*t58-6.356503479982097d-1*t143*t149*t257*t258*t515*t5
     1           16*t58-8.172647331405554d-1*t1054*t141*t143*t149*t325*t
     2           516*t58+2.7242157771351844d-1*t141*t143*t149*t325*t514*
     3           t515*t58+5.448431554270369d-1*t141*t143*t265*t270*t325*
     4           t515*t58-1.0896863108540737d+0*t141*t144*t149*t256*t270
     5           *t325*t515*t58-1.3621078885675922d-1*t141*t143*t266*t32
     6           4*t514*t58+2.7242157771351844d-1*t141*t144*t149*t266*t3
     7           20*t514*t58+3.1782517399910487d-1*t143*t149*t257*t258*t
     8           266*t514*t58-1.3621078885675922d-1*t141*t143*t266*t325*
     9           t505*t58-2.7242157771351844d-1*t141*t144*t155*t320*t505
     :           *t58-3.1782517399910487d-1*t143*t155*t257*t258*t505*t58
     ;           +5.297086233318417d-2*t143*t149*t258*t266*t325*t489*t58
     <           -5.297086233318417d-2*t143*t155*t258*t324*t489*t58+1.05
     =           94172466636834d-1*t144*t149*t155*t258*t320*t489*t58+1.0
     >           594172466636834d-1*t143*t149*t258*t266*t270*t489*t58-1.
     ?           0594172466636834d-1*t143*t155*t258*t265*t489*t58+2.1188
     @           344933273667d-1*t144*t149*t155*t256*t258*t489*t58-1.112
     1           3881089968671d+0*t143*t149*t266*t325*t338*t487*t58+1.11
     2           23881089968671d+0*t143*t155*t324*t338*t487*t58-2.224776
     3           2179937342d+0*t144*t149*t155*t320*t338*t487*t58-2.22477
     4           62179937342d+0*t143*t149*t266*t270*t338*t487*t58+2.2247
     5           762179937342d+0*t143*t155*t265*t338*t487*t58-4.44955243
     6           59874683d+0*t144*t149*t155*t256*t338*t487*t58+2.7242157
     7           771351844d-1*t141*t144*t149*t266*t325*t486*t58-2.724215
     8           7771351844d-1*t141*t144*t155*t324*t486*t58+8.1726473314
     9           05554d-1*t141*t149*t150*t155*t320*t486*t58+6.3565034799
     :           82097d-1*t144*t149*t155*t257*t258*t486*t58-8.1726473314
     ;           05554d-1*t141*t149*t150*t266*t325*t483*t58+8.1726473314
     <           05554d-1*t141*t150*t155*t324*t483*t58-3.269058932562221
     =           6d+0*t141*t149*t155*t268*t320*t483*t58-1.90695104399462
     >           94d+0*t149*t150*t155*t257*t258*t483*t58+5.4484315542703
     ?           69d-1*t141*t144*t256*t265*t266*t325*t58+5.4484315542703
     @           69d-1*t141*t144*t256*t266*t270*t324*t58+5.4484315542703
     1           69d-1*t141*t144*t265*t266*t270*t320*t58-1.6345294662811
     2           108d+0*t141*t149*t150*t256*t266*t270*t320*t58+1.6345294
     3           662811108d+0*t141*t150*t155*t256*t265*t320*t58+6.356503
     4           479982097d-1*t143*t257*t258*t265*t266*t270*t58-1.271300
     5           6959964196d+0*t144*t149*t256*t257*t258*t266*t270*t58+1.
     6           2713006959964196d+0*t144*t155*t256*t257*t258*t265*t58-2
     7           .7242157771351844d-1*t1092*t141*t144*t149*t155*t58+1.36
     8           21078885675922d-1*(t1147+t1145+t1144+t1143+t1142+t1141+
     9           t1140+t1139+t1138+t1136+t1135+t1134+t1133+t1132+t1131+t
     :           1130+t1129+t1128+t1127+t1126+t1125+t1124+t1123+t1122+t1
     ;           121+t1120+t1119+t1118+t1117+t1116+t1115+t1114+t1113+t11
     <           12+t1111+t1110+t1109+t1108+t1107+t1106+t1105+t1104+t110
     =           3+t1102+t1018+t1017+t1016)*t141*t143*t155*t58+t1101+t11
     >           00+t1099+t1098+t1097+t1096+t1095+t1094+t1093+t1091+t109
     ?           0+t1008+t1006+t1004)-6.218138173930978d-2*t139*t271*t51
     @           8*t561+1.8654414521792934d-1*t142*t253*t256*t561+1.8654
     1           414521792934d-1*t142*t253*t271*t544+3.7308829043585867d
     2           -1*t138*t157*t256*t544-9.327207260896466d-2*t142*t320*t
     3           518*t519+6.218138173930978d-2*t1055*t139*t326*t519-3.10
     4           9069086965489d-2*t139*t326*t517*t518-1.8654414521792934
     5           d-1*t142*t256*t271*t326*t518+9.327207260896466d-2*t142*
     6           t253*t320*t517+9.327207260896466d-2*t142*t253*t326*t486
     7           +1.8654414521792934d-1*t138*t157*t320*t486+1.8654414521
     8           792934d-1*t138*t253*t326*t483+1.8654414521792934d-1*t15
     9           7*t320*t483+3.7308829043585867d-1*t138*t253*t256*t271*t
     :           320+9.327207260896466d-2*t1092*t142*t157+1.0d+0*t1089)-
     ;           2.5d-1*t245*t355*t359*t41*t57-1.5625d-1*rhob*t245*t315*
     <           t355*t359*t57-2.5d-1*rhoa*t216*t245*t355*t359*t57-1.562
     =           5d-1*t102*t245*t355*t359*t57+2*t219*t562+2*t272*t540+6.
     >           25d-2*rhoa*t125*t355*t359*t41*t537+6.25d-2*rhob*t102*t1
     ?           25*t355*t359*t537+t327*t524+t316*t520-1.5625d-1*rhoa*t2
     @           45*t283*t355*t359*t41+6.25d-2*t125*t283*t355*t359*t41-2
     1           .5d-1*rhoa*t183*t245*t355*t359*t41+6.25d-2*rhob*t125*t1
     2           83*t315*t355*t359-1.5625d-1*rhob*t102*t245*t283*t355*t3
     3           59+6.25d-2*rhoa*t125*t216*t283*t355*t359-2.5d-1*rhob*t1
     4           02*t183*t245*t355*t359+6.25d-2*t102*t125*t183*t355*t359
     5           +t1085+t1084+t1083+t1073+t1072+t1071
              t1149 = -3.2812499999999994d-2*t166*t563*t58*t60*t62
              t1150 = 3.2812499999999994d-2*t1062*t245*t328*t856
              t1151 = t958+1.3060586492616802d-2*t48*t54*(-1.03703703703
     1           70365d+1*t171*t568*t957-1.0370370370370365d+1*t169*t569
     2           *t955+3.11111111111111d+0*t171*t430*t567+3.111111111111
     3           11d+0*t169*t429*t566+1.244444444444444d+1*t163*t277*t43
     4           *t430-1.244444444444444d+1*t163*t278*t429*t43+7.9999999
     5           99999998d+0*t125*t174*t43-7.999999999999998d+0*t125*t17
     6           3*t43+2.666666666666666d+0*t163*t174-2.666666666666666d
     7           +0*t163*t173)-3.482823064697814d-2*t176*t54*t571+1.3060
     8           586492616802d-2*t172*t48*t571-3.482823064697814d-2*t176
     9           *t51*t570+1.3060586492616802d-2*t175*t48*t570+1.3060586
     :           492616802d-2*t48*t51*(2*gammabb*t171*t567-2.0d+0*gammaa
     ;           b*t169*t567-2.0d+0*gammaab*t171*t566+2*gammaaa*t169*t56
     <           6-12*gammabb*t125*t43*t50-1.2d+1*gammaab*t125*t43*t50-4
     =           *gammabb*t163*t50-4.0d+0*gammaab*t163*t50+1.2d+1*gammaa
     >           b*t125*t43*t49+12*gammaaa*t125*t43*t49+4.0d+0*gammaab*t
     ?           163*t49+4*gammaaa*t163*t49-8.0d+0*gammaab*t163*t278*t43
     @           -8*gammaaa*t163*t278*t43+8*gammabb*t163*t277*t43+8.0d+0
     1           *gammaab*t163*t277*t43)+2.5540702474450633d-1*t280*t432
     2           *t54+1.2770351237225316d-1*t175*t432*t54+2.612117298523
     3           3604d-2*t279*t48*t534+2.6121172985233604d-2*t280*t48*t5
     4           33+2.5540702474450633d-1*t279*t432*t51+1.27703512372253
     5           16d-1*t172*t432*t51-6.965646129395628d-2*t176*t279*t280
     6           +t1079+t1076+t1075+t1074
              t1152 = 1.2d+1*t171*t44*t568+2.712d+2*t171*t180*t568+6.779
     1           999999999999d+1*t171*t46*t567+6.0d+0*t171*t45*t567+1.74
     2           d+0*t171*t567-1.392d+1*t245*t476+2.712d+2*t163*t277*t43
     3           *t46+2.4d+1*t163*t277*t43*t45+3.48d+0*t163*t277*t43-8.1
     4           35999999999999d+1*t125*t181*t43-1.2d+1*t125*t180*t43-6.
     5           96d+0*t125*t43-2.712d+1*t163*t181-4.0d+0*t163*t180
              t1153 = -1.2d+2*t178*t47*t565*t947-4.0d+0*t178*t179*t573+2
     1           .0d+1*t178*t419*t47*t572-4.0d+0*t179*t182*t572+2.0d+1*t
     2           182*t419*t565+t1152*t56-8.0d+0*t179*t281*t536+4.0d+1*t2
     3           81*t419*t47*t535-8.0d+0*t179*t282*t535-4.0d+0*t1151*t17
     4           9*t47+4.0d+1*t178*t281*t282*t419
              t1154 = 5.848223622634648d-1*t116*(t997+t995+t993+t992+t99
     1           1+t990+t989+t988+t987+t985+t984+t983-80*t133*t247*t474-
     2           4*t125*t247*t471+32*t243*t245*t247+t1087+t1086)+5.84822
     3           3622634648d-1*t134*(-5.69973644720455d-1*t171*t568*t980
     4           -5.69973644720455d-1*t169*t569*t979+8.549604670806825d-
     5           1*t171*t480*t567+8.549604670806825d-1*t169*t479*t566+3.
     6           41984186832273d+0*t163*t277*t43*t480-3.41984186832273d+
     7           0*t163*t278*t43*t479-1.5389288407452287d+1*t125*t250*t4
     8           3+1.5389288407452287d+1*t125*t249*t43-5.129762802484096
     9           d+0*t163*t250+5.129762802484096d+0*t163*t249)+t978+t976
     :           +t975+t974+t968+t967+t966+5.848223622634648d-1*t248*t62
     ;           6+5.848223622634648d-1*t251*t625+1.1696447245269297d+0*
     <           t317*t542+1.1696447245269297d+0*t318*t541
              t1155 = 1.4814814814814814d-1*t1000*t169*t569+1.4814814814
     1           814814d-1*t1001*t171*t568-1.111111111111111d-1*t171*t48
     2           5*t567-1.111111111111111d-1*t169*t484*t566-4.4444444444
     3           44444d-1*t163*t277*t43*t485+4.444444444444444d-1*t163*t
     4           278*t43*t484-2.0d+0*t125*t255*t43+2.0d+0*t125*t254*t43-
     5           6.666666666666666d-1*t163*t255+6.666666666666666d-1*t16
     6           3*t254
              t1156 = -3.2690589325622216d+0*t141*t147*t256*t268*t58*t62
     1           8
              t1157 = 1.6345294662811108d+0*t141*t147*t150*t320*t544*t58
              t1158 = 8.172647331405554d-1*t141*t147*t150*t256*t58*t629
              t1159 = -1.906951043994629d+0*t147*t150*t257*t258*t58*t628
              t1160 = -2.7242157771351844d-1*t1155*t141*t144*t147*t58
              t1161 = 6.356503479982097d-1*t144*t147*t257*t258*t58*t629
              t1162 = -4.4495524359874683d+0*t144*t147*t320*t338*t487*t5
     1           8
              t1163 = 2.1188344933273667d-1*t144*t147*t258*t320*t489*t58
              t1164 = -2.2247762179937342d+0*t144*t147*t256*t338*t487*t5
     1           8
              t1165 = 1.0594172466636834d-1*t144*t147*t256*t258*t489*t58
              t1166 = 5.448431554270369d-1*t141*t144*t145*t262*t320*t549
     1           *t58
              t1167 = 2.7242157771351844d-1*t141*t144*t145*t256*t262*t58
     1           *t633
              t1168 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t58
     1           *t633
              t1169 = -1.6345294662811108d+0*t141*t145*t150*t256*t262*t3
     1           20*t322*t58
              t1170 = 5.448431554270369d-1*t141*t144*t145*t262*t322*t544
     1           *t58
              t1171 = -1.2713006959964196d+0*t144*t145*t257*t258*t262*t3
     1           20*t322*t58
              t1172 = -2.2247762179937342d+0*t143*t145*t262*t322*t338*t4
     1           87*t58
              t1173 = 1.0594172466636834d-1*t143*t145*t258*t262*t322*t48
     1           9*t58
              t1174 = 5.448431554270369d-1*t141*t143*t322*t500*t501*t549
     1           *t58
              t1175 = -2.7242157771351844d-1*t141*t143*t145*t262*t322*t5
     1           49*t58
              t1176 = -8.172647331405554d-1*t141*t145*t150*t262*t263*t58
     1           *t628
              t1177 = 2.7242157771351844d-1*t141*t144*t145*t262*t263*t58
     1           *t629
              t1178 = -1.1123881089968671d+0*t143*t145*t262*t263*t338*t4
     1           87*t58
              t1179 = 5.297086233318417d-2*t143*t145*t258*t262*t263*t489
     1           *t58
              t1180 = 2.7242157771351844d-1*t141*t143*t263*t500*t501*t58
     1           *t633
              t1181 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t5
     1           8*t633
              t1182 = -1.0896863108540737d+0*t141*t144*t263*t320*t322*t5
     1           00*t501*t58
              t1183 = 5.448431554270369d-1*t141*t144*t145*t262*t263*t320
     1           *t322*t58
              t1184 = 2.7242157771351844d-1*t1146*t141*t143*t263*t322*t5
     1           00*t501*t58
              t1185 = 2.7242157771351844d-1*t141*t143*t263*t500*t501*t58
     1           *t637
              t1186 = -8.172647331405554d-1*t1038*t141*t143*t145*t263*t5
     1           00*t58*t637
              t1187 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t5
     1           8*t637
              t1188 = -3.859676213149779d+2*t135*t256*t268*t629+9.649190
     1           532874448d+1*t150*t252*t629+1.9298381065748896d+3*t135*
     2           t256*t511*t628-3.859676213149779d+2*t252*t268*t628+9.64
     3           9190532874448d+1*t150*t256*t627-7.719352426299558d+2*t1
     4           35*t268*t320*t544+1.9298381065748896d+2*t150*t319*t544+
     5           1.9298381065748896d+2*t150*t320*t543-7.719352426299558d
     6           +2*t256*t268*t319*t320+9.649190532874448d+1*t1155*t135*
     7           t150-3.216396844291483d+1*t1154*t144
              t1189 = -1.3621078885675922d-1*t1188*t141*t143*t145*t262*t
     1           58
              t1190 = -5.448431554270369d-1*t141*t144*t256*t500*t501*t58
     1           *t637
              t1191 = -6.356503479982097d-1*t143*t257*t258*t500*t501*t58
     1           *t637
              t1192 = 2.7242157771351844d-1*t141*t144*t145*t256*t262*t58
     1           *t637
              t1193 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t58
     1           *t637
              t1194 = t963+t158*(-1.875d+0*t178*t47*t565*t62*t947-6.25d-
     1           2*t178*t179*t573*t62+3.125d-1*t178*t419*t47*t572*t62-6.
     2           25d-2*t179*t182*t572*t62+3.125d-1*t182*t419*t565*t62+1.
     3           5625d-2*t1152*t56*t62-1.25d-1*t179*t281*t536*t62+6.25d-
     4           1*t281*t419*t47*t535*t62-1.25d-1*t179*t282*t535*t62-6.2
     5           5d-2*t1151*t179*t47*t62+6.25d-1*t178*t281*t282*t419*t62
     6           -3.125d-2*t166*t536*t56*t58*t60*t61+1.25d-1*t166*t179*t
     7           47*t535*t58*t60*t61-6.25d-1*t166*t178*t281*t419*t47*t58
     8           *t60*t61+1.25d-1*t166*t178*t179*t282*t58*t60*t61+1.25d-
     9           1*t166*t179*t182*t281*t58*t60*t61-3.125d-2*t163*t355*t3
     :           59*t56*t573+1.25d-1*t163*t179*t355*t359*t47*t572-6.25d-
     ;           1*t163*t355*t359*t419*t47*t565-3.125d-2*t163*t355*t359*
     <           t536*t56+1.875d-1*t125*t282*t355*t359*t56+9.375d-2*t125
     =           *t182*t355*t359*t56+1.25d-1*t163*t179*t355*t359*t47*t53
     >           5-6.25d-1*t163*t178*t281*t355*t359*t419*t47-7.5d-1*t125
     ?           *t179*t281*t355*t359*t47-3.75d-1*t125*t178*t179*t355*t3
     @           59*t47+2.5d-1*t163*t179*t281*t282*t355*t359+1.25d-1*t16
     1           3*t178*t179*t282*t355*t359+1.25d-1*t163*t179*t182*t281*
     2           t355*t359+t1056)+t911+t909+t902+t898+t897+t219*t645+t15
     3           9*(-9.327207260896466d-2*t142*t256*t518*t644+6.21813817
     4           3930978d-2*t1055*t139*t271*t644-3.109069086965489d-2*t1
     5           39*t271*t518*t643+9.327207260896466d-2*t142*t253*t256*t
     6           643+3.109069086965489d-2*t139*t253*(2.7242157771351844d
     7           -1*t141*t143*t265*t515*t58*t642-6.356503479982097d-1*t1
     8           43*t149*t257*t258*t515*t58*t642-5.448431554270369d-1*t1
     9           41*t144*t149*t256*t515*t58*t642-8.172647331405554d-1*t1
     :           054*t141*t143*t149*t270*t58*t642+2.7242157771351844d-1*
     ;           t141*t143*t149*t270*t515*t58*t641-1.3621078885675922d-1
     <           *t141*t143*t265*t266*t58*t641+3.1782517399910487d-1*t14
     =           3*t149*t257*t258*t266*t58*t641+2.7242157771351844d-1*t1
     >           41*t144*t149*t256*t266*t58*t641-1.3621078885675922d-1*t
     ?           141*t143*t266*t270*t58*t640-3.1782517399910487d-1*t143*
     @           t155*t257*t258*t58*t640-2.7242157771351844d-1*t141*t144
     1           *t155*t256*t58*t640-1.3621078885675922d-1*t141*t143*t14
     2           9*t266*t58*(-5.19494612027458d-1*t150*t257*t359*t500*t5
     3           07*t513*t637-4.452810960235354d-1*t152*t256*t268*t500*t
     4           513*t637+1.1132027400588385d-1*t150*t152*t263*t500*t513
     5           *t637+1.7316487067581932d-1*t145*t150*t257*t269*t359*t5
     6           07*t637+1.4842703200784513d-1*t145*t152*t256*t268*t269*
     7           t637-3.710675800196128d-2*t145*t150*t152*t263*t269*t637
     8           -4.452810960235354d-1*t1052*t1053*t150*t152*t263*t637+1
     9           .1132027400588385d-1*t150*t152*t263*t500*t513*t633+1.73
     :           16487067581932d-1*t145*t150*t257*t269*t359*t507*t633+1.
     ;           4842703200784513d-1*t145*t152*t256*t268*t269*t633-3.710
     <           675800196128d-2*t145*t150*t152*t263*t269*t633+3.7106758
     =           00196128d-1*t152*t153*t256*t511*t629+3.4632974135163863
     >           d-1*t153*t257*t268*t359*t507*t629+1.4842703200784513d-1
     ?           *t145*t152*t263*t268*t269*t629-1.7316487067581932d+0*t1
     @           53*t257*t359*t507*t511*t628-7.421351600392256d-1*t145*t
     1           152*t263*t269*t511*t628-2.226405480117677d+0*t1047*t152
     2           *t153*t256*t628+1.7316487067581932d-1*t145*t150*t151*t2
     3           57*t258*t269*t549*t58+3.4632974135163863d-1*t151*t153*t
     4           257*t258*t268*t544*t58-5.19494612027458d-1*t150*t151*t2
     5           57*t258*t263*t322*t500*t513*t58-1.7316487067581932d+0*t
     6           151*t153*t256*t257*t258*t320*t511*t58-6.926594827032773
     7           d-1*t145*t151*t256*t257*t258*t268*t269*t322*t58+1.73164
     8           87067581932d-1*t145*t150*t151*t257*t258*t263*t269*t322*
     9           t58-6.926594827032773d-1*t145*t151*t257*t258*t263*t268*
     :           t269*t320*t58+2.226405480117677d-1*t150*t152*t322*t500*
     ;           t513*t549+1.7316487067581932d-1*t145*t150*t257*t269*t35
     <           9*t507*t549-7.421351600392256d-2*t145*t150*t152*t269*t3
     =           22*t549+2.9685406401569026d-1*t145*t152*t268*t269*t320*
     >           t549+7.421351600392256d-1*t152*t153*t320*t511*t544+3.46
     ?           32974135163863d-1*t153*t257*t268*t359*t507*t544+2.96854
     @           06401569026d-1*t145*t152*t268*t269*t322*t544-5.19494612
     1           027458d-1*t150*t257*t263*t322*t359*t500*t507*t513-8.905
     2           621920470708d-1*t152*t263*t268*t320*t322*t500*t513+1.11
     3           32027400588385d-1*t1146*t150*t152*t263*t322*t500*t513-1
     4           .7316487067581932d+0*t153*t256*t257*t320*t359*t507*t511
     5           -1.4842703200784513d+0*t145*t152*t256*t269*t320*t322*t5
     6           11-2.0202568245512253d+0*t145*t150*t269*t322*t359*t487*
     7           t508-4.0405136491024507d+0*t153*t268*t320*t359*t487*t50
     8           8-1.0101284122756127d+0*t145*t150*t263*t269*t359*t487*t
     9           508-2.0202568245512253d+0*t153*t256*t268*t359*t487*t508
     :           +5.772162355860646d-2*t145*t150*t269*t322*t359*t489*t50
     ;           7+1.1544324711721293d-1*t153*t268*t320*t359*t489*t507+2
     <           .886081177930323d-2*t145*t150*t263*t269*t359*t489*t507+
     =           5.772162355860646d-2*t153*t256*t268*t359*t489*t507-1.38
     >           53189654065545d+0*t145*t257*t268*t269*t320*t322*t359*t5
     ?           07-6.926594827032773d-1*t145*t256*t257*t268*t269*t322*t
     @           359*t507+1.7316487067581932d-1*t145*t150*t257*t263*t269
     1           *t322*t359*t507-6.926594827032773d-1*t145*t257*t263*t26
     2           8*t269*t320*t359*t507+2.9685406401569026d-1*t145*t152*t
     3           263*t268*t269*t320*t322-3.710675800196128d-2*t1188*t145
     4           *t150*t152*t269-7.421351600392256d-2*t1155*t152*t153*t2
     5           68+t1193+t1192+t1191+t1190+t1189+t1187+t1186+t1185+t118
     6           4+t1183+t1182+t1181+t1180+t1179+t1178+t1177+t1176+t1175
     7           +t1174+t1173+t1172+t1171+t1170+t1169+t1168+t1167+t1166+
     8           t1165+t1164+t1163+t1162+t1161+t1160+t1159+t1158+t1157+t
     9           1156+t1136+t1134+t1127+t1120+t1115+t1107+t1105+t1046+t1
     :           045+t1044+t1018+t1017+t1016)+2.7242157771351844d-1*t141
     ;           *t144*t149*t266*t270*t58*t629-2.7242157771351844d-1*t14
     <           1*t144*t155*t265*t58*t629+6.356503479982097d-1*t144*t14
     =           9*t155*t257*t258*t58*t629+8.172647331405554d-1*t141*t14
     >           9*t150*t155*t256*t58*t629-8.172647331405554d-1*t141*t14
     ?           9*t150*t266*t270*t58*t628-3.2690589325622216d+0*t141*t1
     @           49*t155*t256*t268*t58*t628+8.172647331405554d-1*t141*t1
     1           50*t155*t265*t58*t628-1.906951043994629d+0*t149*t150*t1
     2           55*t257*t258*t58*t628+5.448431554270369d-1*t141*t143*t1
     3           49*t325*t515*t560*t58-2.7242157771351844d-1*t141*t143*t
     4           266*t324*t560*t58+5.448431554270369d-1*t141*t144*t149*t
     5           266*t320*t560*t58-2.7242157771351844d-1*t141*t143*t266*
     6           t325*t557*t58-5.448431554270369d-1*t141*t144*t155*t320*
     7           t557*t58+5.448431554270369d-1*t141*t144*t149*t266*t325*
     8           t544*t58-5.448431554270369d-1*t141*t144*t155*t324*t544*
     9           t58+1.6345294662811108d+0*t141*t149*t150*t155*t320*t544
     :           *t58+5.448431554270369d-1*t141*t143*t270*t324*t325*t515
     ;           *t58-1.0896863108540737d+0*t141*t144*t149*t270*t320*t32
     <           5*t515*t58+1.0594172466636834d-1*t143*t149*t258*t266*t3
     =           25*t489*t58-1.0594172466636834d-1*t143*t155*t258*t324*t
     >           489*t58+2.1188344933273667d-1*t144*t149*t155*t258*t320*
     ?           t489*t58+5.297086233318417d-2*t143*t149*t258*t266*t270*
     @           t489*t58-5.297086233318417d-2*t143*t155*t258*t265*t489*
     1           t58+1.0594172466636834d-1*t144*t149*t155*t256*t258*t489
     2           *t58-2.2247762179937342d+0*t143*t149*t266*t325*t338*t48
     3           7*t58+2.2247762179937342d+0*t143*t155*t324*t338*t487*t5
     4           8-4.4495524359874683d+0*t144*t149*t155*t320*t338*t487*t
     5           58-1.1123881089968671d+0*t143*t149*t266*t270*t338*t487*
     6           t58+1.1123881089968671d+0*t143*t155*t265*t338*t487*t58-
     7           2.2247762179937342d+0*t144*t149*t155*t256*t338*t487*t58
     8           +6.356503479982097d-1*t143*t257*t258*t266*t324*t325*t58
     9           +5.448431554270369d-1*t141*t144*t256*t266*t324*t325*t58
     :           +5.448431554270369d-1*t141*t144*t265*t266*t320*t325*t58
     ;           -1.2713006959964196d+0*t144*t149*t257*t258*t266*t320*t3
     <           25*t58-1.6345294662811108d+0*t141*t149*t150*t256*t266*t
     =           320*t325*t58+5.448431554270369d-1*t141*t144*t266*t270*t
     >           320*t324*t58+1.2713006959964196d+0*t144*t155*t257*t258*
     ?           t320*t324*t58+1.6345294662811108d+0*t141*t150*t155*t256
     @           *t320*t324*t58-2.7242157771351844d-1*t1155*t141*t144*t1
     1           49*t155*t58+1.3621078885675922d-1*(t1193+t1192+t1191+t1
     2           190+t1189+t1187+t1186+t1185+t1184+t1183+t1182+t1181+t11
     3           80+t1179+t1178+t1177+t1176+t1175+t1174+t1173+t1172+t117
     4           1+t1170+t1169+t1168+t1167+t1166+t1165+t1164+t1163+t1162
     5           +t1161+t1160+t1159+t1158+t1157+t1156+t1136+t1134+t1127+
     6           t1120+t1115+t1107+t1105+t1018+t1017+t1016)*t141*t143*t1
     7           55*t58+t1101+t1100+t1099+t1098+t1097+t1096+t1095+t1094+
     8           t1093+t1091+t1090+t1008+t1006+t1004)+9.327207260896466d
     9           -2*t142*t253*t271*t629+1.8654414521792934d-1*t138*t157*
     :           t256*t629+1.8654414521792934d-1*t138*t253*t271*t628+1.8
     ;           654414521792934d-1*t157*t256*t628-6.218138173930978d-2*
     <           t139*t326*t518*t561+1.8654414521792934d-1*t142*t253*t32
     =           0*t561+1.8654414521792934d-1*t142*t253*t326*t544+3.7308
     >           829043585867d-1*t138*t157*t320*t544-1.8654414521792934d
     ?           -1*t142*t271*t320*t326*t518+3.7308829043585867d-1*t138*
     @           t253*t256*t320*t326+9.327207260896466d-2*t1155*t142*t15
     1           7+1.0d+0*t1154)+t272*t624+1.5625d-2*rhob*t166*t57*t62*t
     2           623-1.5625d-2*rhob*t183*t42*t62*t623+3.125d-2*rhob*t125
     3           *t355*t359*t57*t623-1.5625d-2*t41*t42*t574*t62-1.5625d-
     4           2*rhoa*t216*t42*t574*t62+1.5625d-2*rhoa*t166*t41*t574*t
     5           62+1.5625d-2*rhob*t102*t166*t574*t62-3.125d-2*t163*t41*
     6           t57*t62+3.125d-2*t166*t315*t57*t62-6.25d-2*rhob*t163*t3
     7           15*t57*t62-3.125d-2*rhoa*t163*t216*t57*t62-6.25d-2*t102
     8           *t163*t57*t62-3.125d-2*rhob*t315*t42*t537*t62-3.125d-2*
     9           t102*t42*t537*t62-1.5625d-2*rhoa*t1153*t41*t42*t62-3.12
     :           5d-2*t183*t315*t42*t62-1.5625d-2*rhob*t102*t1153*t42*t6
     ;           2-6.25d-2*rhoa*t163*t283*t41*t62-3.125d-2*rhoa*t163*t18
     <           3*t41*t62+3.125d-2*rhob*t166*t283*t315*t62+3.125d-2*t10
     =           2*t166*t283*t62-6.25d-2*rhob*t102*t163*t283*t62-3.125d-
     >           2*rhob*t102*t163*t183*t62-3.125d-2*t125*t41*t57*t58*t60
     ?           *t61-3.125d-2*rhob*t125*t315*t57*t58*t60*t61-3.125d-2*r
     @           hoa*t125*t216*t57*t58*t60*t61-3.125d-2*t102*t125*t57*t5
     1           8*t60*t61+3.125d-2*rhoa*t163*t41*t537*t58*t60*t61+3.125
     2           d-2*rhob*t102*t163*t537*t58*t60*t61+3.125d-2*t163*t283*
     3           t41*t58*t60*t61-3.125d-2*rhoa*t125*t283*t41*t58*t60*t61
     4           -3.125d-2*rhoa*t125*t183*t41*t58*t60*t61+3.125d-2*rhob*
     5           t163*t183*t315*t58*t60*t61+3.125d-2*rhoa*t163*t216*t283
     6           *t58*t60*t61-3.125d-2*rhob*t102*t125*t283*t58*t60*t61+3
     7           .125d-2*t102*t163*t183*t58*t60*t61-3.125d-2*rhob*t102*t
     8           125*t183*t58*t60*t61+3.125d-2*rhoa*t125*t355*t359*t41*t
     9           574+3.125d-2*rhob*t102*t125*t355*t359*t574-1.25d-1*t245
     :           *t355*t359*t41*t57-2.8125d-1*rhob*t245*t315*t355*t359*t
     ;           57+6.25d-2*t125*t315*t355*t359*t57-1.25d-1*rhoa*t216*t2
     <           45*t355*t359*t57-2.8125d-1*t102*t245*t355*t359*t57+2*t3
     =           16*t562+2*t327*t540+3.125d-2*rhoa*t125*t355*t359*t41*t5
     >           37+3.125d-2*rhob*t102*t125*t355*t359*t537-2.8125d-1*rho
     ?           a*t245*t283*t355*t359*t41+3.125d-2*t125*t283*t355*t359*
     @           t41-1.25d-1*rhoa*t183*t245*t355*t359*t41+6.25d-2*rhob*t
     1           125*t283*t315*t355*t359+3.125d-2*rhob*t125*t183*t315*t3
     2           55*t359-2.8125d-1*rhob*t102*t245*t283*t355*t359+3.125d-
     3           2*rhoa*t125*t216*t283*t355*t359+6.25d-2*t102*t125*t283*
     4           t355*t359-1.25d-1*rhob*t102*t183*t245*t355*t359+3.125d-
     5           2*t102*t125*t183*t355*t359+t1085+t1084+t1083+t1073+t107
     6           2+t1071
              t1195 = t281**3
              t1196 = t951+t949
              t1197 = t952+t948
              t1198 = t278**3
              t1199 = t277**3
              t1200 = t958+1.3060586492616802d-2*t48*t54*(-1.03703703703
     1           70365d+1*t1199*t957-1.0370370370370365d+1*t1198*t955+9.
     2           333333333333329d+0*t277*t430*t567+9.333333333333329d+0*
     3           t278*t429*t566-1.333333333333333d+0*t1196*t174-1.333333
     4           333333333d+0*t1197*t173)-1.0448469194093442d-1*t176*t54
     5           *t571+3.918175947785041d-2*t279*t48*t571-1.044846919409
     6           3442d-1*t176*t51*t570+3.918175947785041d-2*t280*t48*t57
     7           0+1.3060586492616802d-2*t48*t51*(-6.0d+0*gammaab*t278*t
     8           567+6*gammabb*t277*t567+6*gammaaa*t278*t566-6.0d+0*gamm
     9           aab*t277*t566-2.0d+0*gammaab*t1197*t50+2*gammabb*t1196*
     :           t50+2*gammaaa*t1197*t49-2.0d+0*gammaab*t1196*t49)+3.831
     ;           1053711675946d-1*t280*t432*t54+3.8311053711675946d-1*t2
     <           79*t432*t51-2.0896938388186884d-1*t176*t279*t280
              t1201 = 2.0339999999999997d+2*t277*t46*t567+1.8d+1*t277*t4
     1           5*t567-1.74d+0*t166*t43*t567-1.74d+0*t42*t567+3.48d+0*t
     2           277*t567+1.2d+1*t1199*t44+1.74d+0*t1196*t42*t43+1.356d+
     3           1*t1196*t181+2.712d+2*t1199*t180+2.0d+0*t1196*t180
              t1202 = -1.2d+2*t1195*t47*t947-1.2d+1*t179*t281*t573+6.0d+
     1           1*t281*t419*t47*t572-1.2d+1*t179*t282*t572+6.0d+1*t282*
     2           t419*t565+t1201*t56-4.0d+0*t1200*t179*t47
              t1203 = 1/rhob**3.333333333333333d+0
              t1204 = 1/rhob**3.3333333333333337d+0
              t1205 = 1/rhob**2.666666666666667d+0
              t1206 = 1/t64**7
              t1207 = 1/rhob**2.0d+0
              t1208 = 1/t78**3
              t1209 = t297**3
              t1210 = 2.3511897245373004d-1*t1205*t65*t77+1.763392293402
     1           975d-2*t1207*t582*t77+7.053569173611901d-2*t288*t580*t7
     2           7-7.617854707500852d+0*t296**3*t64/t76**4-1.26964245125
     3           0142d+0*t294*t64*(-1.3127055298329054d-1*t580*t582*t75-
     4           1.4585616998143394d-1*t1205*t288*t75-5.469606374303773d
     5           -2*t1206*t1207*t75+7.876233178997433d-1*t65*(-1.3127055
     6           298329054d-1*t580*t582*t74-1.4585616998143394d-1*t1205*
     7           t288*t74-5.469606374303773d-2*t1206*t1207*t74-1.1708185
     8           015918181d-2*t1204)-3.9381165894987163d-1*t288*t289*t59
     9           0+1.9690582947493582d-1*t287*t295*t582+2.62541105966581
     :           1d-1*t288*t295*t581)-6.34821225625071d-1*t289*t294*t591
     ;           *t65+1.269642451250142d+0*t289*t588*t589*t65+4.23214150
     <           41671406d-1*t294*t296*t581*t65+7.617854707500852d+0*t29
     =           6*t588*t591*t64+1.0580353760417849d-1*t287*t288*t294*t2
     >           96
              t1211 = 1/t85**3
              t1212 = t302**3
              t1213 = 2.3511897245373004d-1*t1205*t65*t84+1.763392293402
     1           975d-2*t1207*t582*t84+7.053569173611901d-2*t288*t580*t8
     2           4-7.617854707500852d+0*t301**3*t64/t83**4-1.26964245125
     3           0142d+0*t299*t64*(-1.3127055298329054d-1*t580*t582*t82-
     4           1.4585616998143394d-1*t1205*t288*t82-5.469606374303773d
     5           -2*t1206*t1207*t82+7.876233178997433d-1*t65*(-1.3127055
     6           298329054d-1*t580*t582*t81-1.4585616998143394d-1*t1205*
     7           t288*t81-5.469606374303773d-2*t1206*t1207*t81-6.4079313
     8           56509611d-3*t1204)-3.9381165894987163d-1*t288*t289*t597
     9           +1.9690582947493582d-1*t287*t300*t582+2.625411059665811
     :           d-1*t288*t300*t581)-6.34821225625071d-1*t289*t299*t598*
     ;           t65+1.269642451250142d+0*t289*t595*t596*t65+4.232141504
     <           1671406d-1*t299*t301*t581*t65+7.617854707500852d+0*t301
     =           *t595*t598*t64+1.0580353760417849d-1*t287*t288*t299*t30
     >           1
              t1214 = 5.848223622634643d-1*(1.0d+0*(1.013214d-1*t302*t59
     1           3*t599*t87-3.37738d-2*t1213*t298*t87-6.75476d-2*t1211*t
     2           1212*t87+2.4171930915078277d-3*t1203*t86+1.709920934161
     3           365d+0*(-1.865442d-1*t297*t586*t592*t80+6.21814d-2*t121
     4           0*t293*t80+1.243628d-1*t1208*t1209*t80-8.54862793303069
     5           4d-3*t1203*t79-6.21814d-2*t292**3*t73/t70**3-3.10907d-2
     6           *t285*(2.3511897245373004d-1*t1205*t65*t69+1.7633922934
     7           02975d-2*t1207*t582*t69+7.053569173611901d-2*t288*t580*
     8           t69-7.617854707500852d+0*t291**3*t64/t68**4-1.269642451
     9           250142d+0*t286*t64*(-1.3127055298329054d-1*t580*t582*t6
     :           7-1.4585616998143394d-1*t1205*t288*t67-5.46960637430377
     ;           3d-2*t1206*t1207*t67+7.876233178997433d-1*t65*(-1.31270
     <           55298329054d-1*t580*t582*t66-1.4585616998143394d-1*t120
     =           5*t288*t66-5.469606374303773d-2*t1206*t1207*t66-7.42443
     >           9106586571d-3*t1204)-3.9381165894987163d-1*t288*t289*t5
     ?           83+1.9690582947493582d-1*t287*t290*t582+2.6254110596658
     @           11d-1*t288*t290*t581)-6.34821225625071d-1*t286*t289*t58
     1           4*t65+4.2321415041671406d-1*t286*t291*t581*t65+1.269642
     2           451250142d+0*t289*t578*t579*t65+7.617854707500852d+0*t2
     3           91*t578*t584*t64+1.0580353760417849d-1*t286*t287*t288*t
     4           291)*t73+9.327209999999999d-2*t292*t576*t585*t73+4.1099
     5           018897499934d-3*t1203*t71-8.243319792565315d-3*t284*t29
     6           3*t592+8.243319792565315d-3*t284*t586*t587+3.9631196794
     7           0178d-3*t284*t285*t585-3.96311967940178d-3*t284*t576*t5
     8           77+1.0991093056753751d-2*t293*t297*t575-5.2841595725357
     9           06d-3*t285*t292*t575)+2.33086476681112d-3*t284*t298*t59
     :           9-2.33086476681112d-3*t284*t593*t594-3.107819689081493d
     ;           -3*t298*t302*t575)-1.013214d-1*t302*t593*t599*t87+3.377
     <           38d-2*t1213*t298*t87+6.75476d-2*t1211*t1212*t87-2.41719
     =           30915078277d-3*t1203*t86-2.33086476681112d-3*t284*t298*
     >           t599+2.33086476681112d-3*t284*t593*t594+3.1078196890814
     ?           93d-3*t298*t302*t575)+1.865442d-1*t297*t586*t592*t80-6.
     @           21814d-2*t1210*t293*t80-1.243628d-1*t1208*t1209*t80+8.5
     1           48627933030694d-3*t1203*t79+8.243319792565315d-3*t284*t
     2           293*t592-8.243319792565315d-3*t284*t586*t587-1.09910930
     3           56753751d-2*t293*t297*t575
              t1215 = rhob**5.000000000000002d-1
              t1216 = 1/rhob**6.666666666666665d-1
              t1217 = 1/rhob**1.8333333333333332d+0
              t1218 = t303**3
              t1219 = exp(-1.92983810657489d+2*t88)
              t1220 = 3.453411185284245d+5*gammabb*t1218*t1219*t90/t92**
     1           4
              t1221 = -1.252637628753944d+4*gammabb*t305*t306*t603*t604*
     1           t605
              t1222 = -3.453411185284245d+5*gammabb*t1218*t604*t605*t90
              t1223 = 5.368446980374045d+3*gammabb*t303*t600*t604*t605*t
     1           90
              t1224 = -8.240428253953201d+0*gammabb*t1215*t616*t93
              t1225 = 8.829030272092719d-1*gammabb*t1216*t350*t93
              t1226 = 7.007166882613269d-2*gammabb*t1217*t306*t93
              t1227 = 3.4077198126375585d+2*gammabb*t303*t308*t350*t601*
     1           t91
              t1228 = -1.6227237203036002d+1*gammabb*t303*t306*t308*t602
     1           *t91
              t1229 = 6.263188143769719d+3*gammabb*t305*t306*t308*t603*t
     1           91
              t1230 = -9.736342321821596d+1*gammabb*t305*t306*t308*t600*
     1           t91
              t1231 = 5.755685308807075d+4*gammabb*t1218*t308*t90*t91
              t1232 = -2.6842234901870227d+3*gammabb*t303*t308*t600*t90*
     1           t91
              t1233 = 1.3909060459745137d+1*gammabb*t1214*t308*t90*t91
              t1234 = 1/t89**7.0d+0
              t1235 = 1/t99**4
              t1236 = 1/t101**3
              t1237 = 5.848223622634648d-1*t116*(t996+t995+t994+t993+t99
     1           2+t991+t990+t989+t988+t987+t985+t984+t983-240*t133*t247
     2           *t474-12*t125*t247*t471+96*t243*t245*t247+t1088)+5.8482
     3           23622634648d-1*t134*(-5.69973644720455d-1*t1199*t980-5.
     4           69973644720455d-1*t1198*t979+2.5648814012420473d+0*t277
     5           *t480*t567+2.5648814012420473d+0*t278*t479*t566+2.56488
     6           1401242048d+0*t1196*t250+2.564881401242048d+0*t1197*t24
     7           9)+t978+t976+t975+t974+t968+t967+t966+1.754467086790394
     8           4d+0*t317*t626+1.7544670867903944d+0*t318*t625
              t1238 = t320**3
              t1239 = -3.333333333333333d-1*t277*t485*t567-3.33333333333
     1           3333d-1*t278*t484*t566+3.333333333333333d-1*t1196*t255+
     2           3.333333333333333d-1*t1197*t254+1.4814814814814814d-1*t
     3           1001*t1199+1.4814814814814814d-1*t1000*t1198
              t1240 = -3.2690589325622216d+0*t1238*t141*t147*t268*t58
              t1241 = 2.4517941994216663d+0*t141*t147*t150*t320*t58*t629
              t1242 = -5.720853131983887d+0*t147*t150*t257*t258*t58*t628
              t1243 = -2.7242157771351844d-1*t1239*t141*t144*t147*t58
              t1244 = 1.906951043994629d+0*t144*t147*t257*t258*t58*t629
              t1245 = -6.674328653981203d+0*t144*t147*t320*t338*t487*t58
              t1246 = 3.1782517399910504d-1*t144*t147*t258*t320*t489*t58
              t1247 = 8.172647331405554d-1*t141*t144*t145*t262*t320*t58*
     1           t633
              t1248 = 9.534755219973146d-1*t143*t145*t257*t258*t262*t58*
     1           t633
              t1249 = -2.4517941994216663d+0*t141*t145*t150*t262*t322*t5
     1           8*t628
              t1250 = 8.172647331405554d-1*t141*t144*t145*t262*t322*t58*
     1           t629
              t1251 = -3.813902087989258d+0*t144*t145*t257*t258*t262*t32
     1           0*t322*t58
              t1252 = -3.3371643269906015d+0*t143*t145*t262*t322*t338*t4
     1           87*t58
              t1253 = 1.5891258699955252d-1*t143*t145*t258*t262*t322*t48
     1           9*t58
              t1254 = 8.172647331405554d-1*t141*t143*t322*t500*t501*t58*
     1           t633
              t1255 = -4.086323665702777d-1*t141*t143*t145*t262*t322*t58
     1           *t633
              t1256 = 2.7242157771351844d-1*t1146*t141*t143*t500*t501*t5
     1           8*t637
              t1257 = -1.1579028639449339d+3*t135*t268*t320*t629+2.89475
     1           71598623345d+2*t150*t319*t629-1.1579028639449339d+3*t26
     2           8*t319*t628+2.8947571598623345d+2*t150*t320*t627+1.9298
     3           381065748896d+3*t1238*t135*t511+9.649190532874448d+1*t1
     4           239*t135*t150-3.216396844291483d+1*t1237*t144
              t1258 = -1.3621078885675922d-1*t1257*t141*t143*t145*t262*t
     1           58
              t1259 = -1.6345294662811108d+0*t141*t144*t320*t500*t501*t5
     1           8*t637
              t1260 = -1.906951043994629d+0*t143*t257*t258*t500*t501*t58
     1           *t637
              t1261 = 8.172647331405554d-1*t141*t144*t145*t262*t320*t58*
     1           t637
              t1262 = 9.534755219973146d-1*t143*t145*t257*t258*t262*t58*
     1           t637
              t1263 = t322**3
              t1264 = 2.7242157771351844d-1*t1263*t141*t143*t500*t501*t5
     1           8
              t1265 = -8.172647331405554d-1*t1038*t1263*t141*t143*t145*t
     1           500*t58
              t1266 = -1.3621078885675922d-1*t1263*t141*t143*t145*t262*t
     1           58
              t1267 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2
     1           *t304*(-2.1622114952063792d-1*gammabb*t311*t90*t95*(3.0
     2           30195356483172d-2*t1217*t614*t616*t98+6.363410248614662
     3           d-1*t1216*t614*t615*t98-8.908774348060522d+0*t1215*t123
     4           4*t614*t98+2.9868021449983523d+5*t1218*t1219*t97/t92**5
     5           .0d+0-1.1607717772370736d+3*t303*t312*t600*t91*t97+2.48
     6           90017874986267d+4*t1218*t312*t91*t97+6.014866082716293d
     7           +0*t1214*t312*t91*t97+3.482315331711221d+3*t303*t600*t6
     8           04*t613*t97-2.2401016087487644d+5*t1218*t604*t613*t97+1
     9           .8056449868132257d+3*gammabb*t305*t306*t312*t603*t91*t9
     :           6-2.806937505267603d+1*gammabb*t305*t306*t312*t600*t91*
     ;           t96-5.416934960439678d+3*gammabb*t305*t306*t603*t604*t6
     <           13*t96+3.6112899736264514d+3*t305*t312*t603*t614*t616*t
     =           91-1.4034687526338024d+1*t303*t312*t602*t614*t616*t91-5
     >           .613875010535206d+1*t305*t312*t600*t614*t616*t91+4.9121
     ?           40634218306d+2*t303*t312*t601*t614*t615*t91-1.083386992
     @           0879355d+4*t305*t603*t604*t613*t614*t616+t1233+t1232+t1
     1           231+t1230+t1229+t1228+t1227+t1226+t1225+t1224+t1223+t12
     2           22+t1221+t1220)+1.2973268971238278d+0*gammabb*t313*t617
     3           *t618*t90*t95-1.2973268971238278d+0*gammabb*t1235*t313*
     4           *3*t90*t95-3.027096093288931d+0*gammabb*t305*t306*t618*
     5           t619*t95+1.5135480466444656d+0*gammabb*t305*t306*t311*t
     6           617*t95-8.240428253953201d+0*gammabb*t100*t1215*t616*t9
     7           5+2.522580077740777d-1*gammabb*t306*t311*t313*t602*t95-
     8           5.297418163255629d+0*gammabb*t311*t313*t350*t601*t95+8.
     9           829030272092719d-1*gammabb*t100*t1216*t350*t95+7.007166
     :           882613269d-2*gammabb*t100*t1217*t306*t95+1.297326897123
     ;           8278d+0*gammabb*t310*t618*t619*t90-6.486634485619138d-1
     <           *gammabb*t310*t311*t617*t90-6.486634485619138d-1*gammab
     =           b*t311*t313*t612*t90+2.1622114952063792d-1*gammabb*t100
     >           *(t1233+t1232+t1231+t1230+t1229+t1228+t1227+t1226+t1225
     ?           +t1224+t1223+t1222+t1221+t1220)*t90-1.5135480466444656d
     @           +0*gammabb*t100*t305*t306*t612-2.522580077740777d-1*gam
     1           mabb*t100*t306*t310*t602+5.297418163255629d+0*gammabb*t
     2           100*t310*t350*t601+3.027096093288931d+0*gammabb*t305*t3
     3           06*t310*t311*t313)-4.6636036304482326d-2*t314*t620*t621
     4           +3.1090690869654886d-2*t1236*t314**3+1.0d+0*t1214)+t963
     5           +t158*(-1.875d+0*t1195*t47*t62*t947-1.875d-1*t179*t281*
     6           t573*t62+9.375d-1*t281*t419*t47*t572*t62-1.875d-1*t179*
     7           t282*t572*t62+9.375d-1*t282*t419*t565*t62+1.5625d-2*t12
     8           01*t56*t62-6.25d-2*t1200*t179*t47*t62-3.125d-2*t166*t56
     9           *t573*t58*t60*t61+1.25d-1*t166*t179*t47*t572*t58*t60*t6
     :           1-6.25d-1*t166*t419*t47*t565*t58*t60*t61+2.5d-1*t166*t1
     ;           79*t281*t282*t58*t60*t61-6.25d-2*t163*t355*t359*t56*t57
     <           3+2.5d-1*t163*t179*t355*t359*t47*t572-1.25d+0*t163*t355
     =           *t359*t419*t47*t565+2.8125d-1*t125*t282*t355*t359*t56-1
     >           .125d+0*t125*t179*t281*t355*t359*t47+5.0d-1*t163*t179*t
     ?           281*t282*t355*t359+t1056)+t911+t909+t902+t898+t897+3*t3
     @           16*t645+t159*(-2.7981621782689403d-1*t142*t320*t518*t64
     1           4-9.327207260896466d-2*t139*t326*t518*t643+2.7981621782
     2           689403d-1*t142*t253*t320*t643+3.109069086965489d-2*t139
     3           *t253*(8.172647331405554d-1*t141*t143*t324*t515*t58*t64
     4           2-1.6345294662811108d+0*t141*t144*t149*t320*t515*t58*t6
     5           42-1.906951043994629d+0*t143*t149*t257*t258*t515*t58*t6
     6           42+8.172647331405554d-1*t141*t143*t149*t325*t515*t58*t6
     7           41-4.086323665702777d-1*t141*t143*t266*t324*t58*t641+8.
     8           172647331405554d-1*t141*t144*t149*t266*t320*t58*t641+9.
     9           534755219973146d-1*t143*t149*t257*t258*t266*t58*t641-4.
     :           086323665702777d-1*t141*t143*t266*t325*t58*t640-8.17264
     ;           7331405554d-1*t141*t144*t155*t320*t58*t640-9.5347552199
     <           73146d-1*t143*t155*t257*t258*t58*t640-1.362107888567592
     =           2d-1*t141*t143*t149*t266*t58*(-5.19494612027458d-1*t150
     >           *t151*t257*t258*t500*t513*t58*t637+1.7316487067581932d-
     ?           1*t145*t150*t151*t257*t258*t269*t58*t637-1.038989224054
     @           9159d+0*t150*t257*t359*t500*t507*t513*t637-1.3358432880
     1           706061d+0*t152*t268*t320*t500*t513*t637+1.1132027400588
     2           385d-1*t1146*t150*t152*t500*t513*t637+3.463297413516386
     3           3d-1*t145*t150*t257*t269*t359*t507*t637+4.4528109602353
     4           54d-1*t145*t152*t268*t269*t320*t637+1.7316487067581932d
     5           -1*t145*t150*t151*t257*t258*t269*t58*t633+3.33960822017
     6           65154d-1*t150*t152*t322*t500*t513*t633+3.46329741351638
     7           63d-1*t145*t150*t257*t269*t359*t507*t633-1.113202740058
     8           8385d-1*t145*t150*t152*t269*t322*t633+4.452810960235354
     9           d-1*t145*t152*t268*t269*t320*t633+3.4632974135163863d-1
     :           *t151*t153*t257*t258*t268*t58*t629+1.1132027400588385d+
     ;           0*t152*t153*t320*t511*t629+6.926594827032773d-1*t153*t2
     <           57*t268*t359*t507*t629+4.452810960235354d-1*t145*t152*t
     =           268*t269*t322*t629-1.7316487067581932d+0*t151*t153*t257
     >           *t258*t511*t58*t628-3.4632974135163863d+0*t153*t257*t35
     ?           9*t507*t511*t628-2.226405480117677d+0*t145*t152*t269*t3
     @           22*t511*t628-1.3853189654065545d+0*t145*t151*t257*t258*
     1           t268*t269*t320*t322*t58+1.1132027400588385d-1*t1263*t15
     2           0*t152*t500*t513-3.030385236826838d+0*t145*t150*t269*t3
     3           22*t359*t487*t508-6.060770473653676d+0*t153*t268*t320*t
     4           359*t487*t508+8.65824353379097d-2*t145*t150*t269*t322*t
     5           359*t489*t507+1.731648706758194d-1*t153*t268*t320*t359*
     6           t489*t507-2.770637930813109d+0*t145*t257*t268*t269*t320
     7           *t322*t359*t507-3.710675800196128d-2*t1263*t145*t150*t1
     8           52*t269-3.710675800196128d-2*t1257*t145*t150*t152*t269-
     9           7.421351600392256d-2*t1239*t152*t153*t268-2.22640548011
     :           7677d+0*t1047*t1238*t152*t153-4.452810960235354d-1*t105
     ;           2*t1053*t1263*t150*t152+t1266+t1265+t1264+t1262+t1261+t
     <           1260+t1259+t1258+t1256+t1255+t1254+t1253+t1252+t1251+t1
     =           250+t1249+t1248+t1247+t1246+t1245+t1244+t1243+t1242+t12
     >           41+t1240+t1046+t1045+t1044+t1018+t1017+t1016)+8.1726473
     ?           31405554d-1*t141*t144*t149*t266*t325*t58*t629-8.1726473
     @           31405554d-1*t141*t144*t155*t324*t58*t629+2.451794199421
     1           6663d+0*t141*t149*t150*t155*t320*t58*t629+1.90695104399
     2           4629d+0*t144*t149*t155*t257*t258*t58*t629-2.45179419942
     3           16663d+0*t141*t149*t150*t266*t325*t58*t628+2.4517941994
     4           216663d+0*t141*t150*t155*t324*t58*t628-5.72085313198388
     5           7d+0*t149*t150*t155*t257*t258*t58*t628+1.58912586999552
     6           52d-1*t143*t149*t258*t266*t325*t489*t58-1.5891258699955
     7           252d-1*t143*t155*t258*t324*t489*t58+3.1782517399910504d
     8           -1*t144*t149*t155*t258*t320*t489*t58-3.3371643269906015
     9           d+0*t143*t149*t266*t325*t338*t487*t58+3.337164326990601
     :           5d+0*t143*t155*t324*t338*t487*t58-6.674328653981203d+0*
     ;           t144*t149*t155*t320*t338*t487*t58-8.172647331405554d-1*
     <           t1054*t141*t143*t149*t325**3*t58+1.6345294662811108d+0*
     =           t141*t144*t266*t320*t324*t325*t58+1.906951043994629d+0*
     >           t143*t257*t258*t266*t324*t325*t58-3.813902087989258d+0*
     ?           t144*t149*t257*t258*t266*t320*t325*t58+3.81390208798925
     @           8d+0*t144*t155*t257*t258*t320*t324*t58-3.26905893256222
     1           16d+0*t1238*t141*t149*t155*t268*t58-2.7242157771351844d
     2           -1*t1239*t141*t144*t149*t155*t58+1.3621078885675922d-1*
     3           (t1266+t1265+t1264+t1262+t1261+t1260+t1259+t1258+t1256+
     4           t1255+t1254+t1253+t1252+t1251+t1250+t1249+t1248+t1247+t
     5           1246+t1245+t1244+t1243+t1242+t1241+t1240+t1018+t1017+t1
     6           016)*t141*t143*t155*t58+t1008+t1006+t1004)+2.7981621782
     7           689403d-1*t142*t253*t326*t629+5.596324356537881d-1*t138
     8           *t157*t320*t629+5.596324356537881d-1*t138*t253*t326*t62
     9           8+6.218138173930978d-2*t1055*t139*t326**3+9.32720726089
     :           6466d-2*t1239*t142*t157+1.8654414521792934d-1*t1238*t15
     ;           7+1.0d+0*t1237)+3*t327*t624-4.6875d-2*t42*t57*t62*t623+
     <           4.6875d-2*rhob*t166*t57*t62*t623-4.6875d-2*rhob*t283*t4
     =           2*t62*t623+3.125d-2*rhob*t163*t57*t58*t60*t61*t623+6.25
     >           d-2*rhob*t125*t355*t359*t57*t623-4.6875d-2*rhob*t315*t4
     ?           2*t574*t62-4.6875d-2*t102*t42*t574*t62+4.6875d-2*rhoa*t
     @           166*t41*t574*t62+4.6875d-2*rhob*t102*t166*t574*t62+9.37
     1           5d-2*t166*t315*t57*t62-9.375d-2*rhob*t163*t315*t57*t62-
     2           9.375d-2*t102*t163*t57*t62-1.5625d-2*rhoa*t1202*t41*t42
     3           *t62-9.375d-2*t283*t315*t42*t62-1.5625d-2*rhob*t102*t12
     4           02*t42*t62-9.375d-2*rhoa*t163*t283*t41*t62+9.375d-2*rho
     5           b*t166*t283*t315*t62+9.375d-2*t102*t166*t283*t62-9.375d
     6           -2*rhob*t102*t163*t283*t62+3.125d-2*rhoa*t163*t41*t574*
     7           t58*t60*t61+3.125d-2*rhob*t102*t163*t574*t58*t60*t61+6.
     8           25d-2*t163*t315*t57*t58*t60*t61-6.25d-2*rhob*t125*t315*
     9           t57*t58*t60*t61-6.25d-2*t102*t125*t57*t58*t60*t61-6.25d
     :           -2*rhoa*t125*t283*t41*t58*t60*t61+6.25d-2*rhob*t163*t28
     ;           3*t315*t58*t60*t61+6.25d-2*t102*t163*t283*t58*t60*t61-6
     <           .25d-2*rhob*t102*t125*t283*t58*t60*t61+6.25d-2*rhoa*t12
     =           5*t355*t359*t41*t574+6.25d-2*rhob*t102*t125*t355*t359*t
     >           574-4.0625d-1*rhob*t245*t315*t355*t359*t57+1.25d-1*t125
     ?           *t315*t355*t359*t57-4.0625d-1*t102*t245*t355*t359*t57-4
     @           .0625d-1*rhoa*t245*t283*t355*t359*t41+1.25d-1*rhob*t125
     1           *t283*t315*t355*t359-4.0625d-1*rhob*t102*t245*t283*t355
     2           *t359+1.25d-1*t102*t125*t283*t355*t359
              t1268 = 1/t1**7.666666666666667d+0
              t1269 = 8.162866557885501d-3*rhoa*t1268*t179*t355*t359*t41
     1           *t47*t51*t52
              t1270 = 1.25d-1*rhoa*t125*t183*t355*t41*t58
              t1271 = -2.428960224191788d-3*rhoa*t205*t245*t334*t355*t35
     1           9*t57
              t1272 = -3.125d-1*rhoa*t245*t355*t41*t57*t58
              t1273 = 1.25d-1*rhoa*t125*t216*t355*t57*t58
              t1274 = 1.25d-1*t125*t355*t41*t57*t58
              t1275 = 8.162866557885501d-3*rhob*t102*t1268*t179*t355*t35
     1           9*t47*t51*t52
              t1276 = 1.25d-1*rhob*t102*t125*t183*t355*t58
              t1277 = -3.125d-1*rhob*t102*t245*t355*t57*t58
              t1278 = 6.25d-2*rhoa*t163*t183*t41*t60*t61
              t1279 = -6.25d-2*rhoa*t166*t183*t216*t60*t61
              t1280 = -6.25d-2*t166*t183*t41*t60*t61
              t1281 = -6.25d-2*rhoa*t125*t41*t57*t60*t61
              t1282 = 6.25d-2*rhoa*t163*t216*t57*t60*t61
              t1283 = 6.25d-2*t163*t41*t57*t60*t61
              t1284 = -6.25d-2*t166*t216*t57*t60*t61
              t1285 = -3.125d-2*rhoa*t166*t417*t57*t60*t61
              t1286 = -3.125d-2*rhoa*t166*t41*t436*t60*t61
              t1287 = 6.25d-2*rhob*t102*t163*t183*t60*t61
              t1288 = -6.25d-2*rhob*t102*t125*t57*t60*t61
              t1289 = -3.125d-2*rhob*t102*t166*t436*t60*t61
              t1290 = 1.6325733115771002d-3*rhoa*t179*t41*t47*t51*t52*t6
     1           2*t673
              t1291 = 1.2770351237225316d-1*t432*t51*t52
              t1292 = 1.3060586492616802d-2*t431*t48*t52-6.9656461293956
     1           28d-2*t175*t176*t52+1.3060586492616802d-2*t48*(2*t425*t
     2           49+2*t426)*t51-1.3931292258791256d-1*t169*t176*t49*t51+
     3           5.224234597046721d-2*t169*t175*t48*t49+t1291
              t1293 = -1.5672703791140163d+0*t418*t47*t48*t51*t52*t947+4
     1           .0d+1*t178*t419*t47*t663-8.0d+0*t179*t182*t663+2.612117
     2           2985233604d-1*t419*t434*t47*t48*t51*t52-5.2242345970467
     3           21d-2*t179*t435*t48*t51*t52+5.224234597046721d-1*t178*t
     4           182*t419*t48*t51*t52-4.0d+0*t1292*t179*t47
              t1294 = -4.8579204483835753d-4*rhoa*t163*t205*t334*t57*t62
              t1295 = 1.7894823267913484d+3*t29*t397*t398*t399
              t1296 = 1.765806054418543d+0*t32*t333*t395
              t1297 = -8.408600259135923d-2*t207*t32*t396
              t1298 = -6.490894881214397d+1*t204*t206*t207*t209*t30
              t1299 = -8.947411633956742d+2*t209*t29*t30*t397
              t1300 = 1.3909060459745137d+1*t209*t29*t30*t394
              t1301 = 1.6325733115771002d-3*rhob*t102*t179*t47*t51*t52*t
     1           62*t673
              t1302 = -4.897719934731301d-3*t179*t355*t359*t47*t51*t52*t
     1           649
              t1303 = 5.0d-1*t163*t178*t179*t355*t47*t58
              t1304 = -1.25d-1*t163*t182*t355*t56*t58
              t1305 = 1.875d-1*t125*t355*t47*t56*t58
              t1306 = 6.25d-1*t418*t419*t42*t47*t60*t61
              t1307 = -1.25d-1*t179*t42*t434*t47*t60*t61
              t1308 = -2.5d-1*t178*t179*t182*t42*t60*t61
              t1309 = 3.125d-2*t42*t435*t56*t60*t61
              t1310 = 2*t219*t690
              t1311 = -1.1123881089968671d+0*t143*t149*t266*t337*t338*t4
     1           87*t58
              t1312 = 5.297086233318417d-2*t143*t149*t258*t266*t337*t489
     1           *t58
              t1313 = 1.2713006959964196d+0*t144*t149*t155*t256*t257*t25
     1           8
              t1314 = 1.1123881089968671d+0*t143*t149*t155*t338*t487
              t1315 = -5.297086233318417d-2*t143*t149*t155*t258*t489
              t1316 = 1.7316487067581934d-1*t147*t155*t256*t257*t268*t50
     1           7*t58
              t1317 = 1.515192618413419d-1*t147*t150*t155*t487*t508*t58
              t1318 = -7.215202944825808d-3*t147*t150*t155*t489*t507*t58
              t1319 = -6.356503479982097d-1*t143*t155*t257*t258*t265
              t1320 = 6.356503479982097d-1*t143*t149*t257*t258*t266*t270
              t1321 = 8.658243533790967d-2*t147*t150*t257*t266*t270*t507
     1           *t58
              t1322 = 8.172647331405554d-1*t141*t147*t150*t483
              t1323 = -2.7242157771351844d-1*t141*t144*t147*t486
              t1324 = 1.2713006959964196d+0*t144*t147*t256*t257*t258
              t1325 = 1.1123881089968671d+0*t143*t147*t338*t487
              t1326 = -5.297086233318417d-2*t143*t147*t258*t489
              t1327 = -1.3621078885675922d-1*t141*t143*t145*t262*t496
              t1328 = 5.448431554270369d-1*t141*t144*t145*t256*t262*t263
              t1329 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t263
              t1330 = 2.7242157771351844d-1*t141*t143*t500*t501*t502
              t1331 = -1.3621078885675922d-1*t141*t143*t145*t262*t502
              t1332 = 1.3853189654065545d+0*t153*t256*t257*t268*t507*t58
              t1333 = 1.0101284122756127d+0*t150*t153*t487*t508*t58
              t1334 = -2.886081177930323d-2*t150*t153*t489*t507*t58
              t1335 = 6.926594827032773d-1*t145*t150*t257*t263*t269*t507
     1           *t58
              t1336 = t159*(-6.218138173930978d-2*t139*t271*t518*t689+1.
     1           8654414521792934d-1*t142*t253*t256*t689+3.1090690869654
     2           89d-2*t139*t253*(5.448431554270369d-1*t141*t143*t149*t2
     3           70*t515*t58*t688-2.7242157771351844d-1*t141*t143*t265*t
     4           266*t58*t688+6.356503479982097d-1*t143*t149*t257*t258*t
     5           266*t58*t688+5.448431554270369d-1*t141*t144*t149*t256*t
     6           266*t58*t688-2.7242157771351844d-1*t141*t143*t266*t270*
     7           t58*t686-6.356503479982097d-1*t143*t155*t257*t258*t58*t
     8           686-5.448431554270369d-1*t141*t144*t155*t256*t58*t686+3
     9           .710675800196128d-2*t147*t150*t338*t515*t516*t58-8.1726
     :           47331405554d-1*t1054*t141*t143*t149*t337*t516*t58+2.724
     ;           2157771351844d-1*t141*t143*t149*t337*t514*t515*t58+5.44
     <           8431554270369d-1*t141*t143*t265*t270*t337*t515*t58-1.27
     =           13006959964196d+0*t143*t149*t257*t258*t270*t337*t515*t5
     >           8-1.0896863108540737d+0*t141*t144*t149*t256*t270*t337*t
     ?           515*t58-1.855337900098064d-2*t147*t150*t266*t338*t514*t
     @           58-1.3621078885675922d-1*t141*t143*t149*t266*(2.2264054
     1           80117677d-1*t141*t150*t151*t500*t502*t513+7.42135160039
     2           2256d-1*t141*t151*t153*t483*t511-7.421351600392256d-2*t
     3           141*t145*t150*t151*t269*t502-7.421351600392256d-2*t141*
     4           t145*t150*t151*t269*t496-1.4842703200784513d-1*t141*t15
     5           1*t153*t268*t486+5.937081280313805d-1*t141*t145*t151*t2
     6           56*t263*t268*t269+t1335+t1334+t1333+t1332+t1331+t1330+t
     7           1329+t1328+t1327+t1326+t1325+t1324+t1323+t1322)*t58+1.1
     8           132027400588386d-1*t147*t155*t338*t483*t511*t58-1.36210
     9           78885675922d-1*t141*t143*t266*t337*t505*t58-3.710675800
     :           196128d-2*t147*t155*t268*t338*t486*t58+2.72421577713518
     ;           44d-1*t141*t144*t149*t266*t337*t486*t58-8.1726473314055
     <           54d-1*t141*t149*t150*t266*t337*t483*t58+7.4213516003922
     =           56d-2*t147*t256*t266*t268*t270*t338*t58+6.3565034799820
     >           97d-1*t143*t257*t258*t265*t266*t337*t58+5.4484315542703
     ?           69d-1*t141*t144*t256*t265*t266*t337*t58-1.2713006959964
     @           196d+0*t144*t149*t256*t257*t258*t266*t337*t58+1.3621078
     1           885675922d-1*(t1331+t1330+t1329+t1328+t1327+t1326+t1325
     2           +t1324+t1323+t1322)*t141*t143*t155*t58+2.72421577713518
     3           44d-1*t141*t143*t149*t515*t516-1.3621078885675922d-1*t1
     4           41*t143*t149*t266*t514+1.3621078885675922d-1*t141*t143*
     5           t155*t505-2.7242157771351844d-1*t141*t144*t149*t155*t48
     6           6+8.172647331405554d-1*t141*t149*t150*t155*t483-2.72421
     7           57771351844d-1*t141*t143*t265*t266*t270+5.4484315542703
     8           69d-1*t141*t144*t149*t256*t266*t270-5.448431554270369d-
     9           1*t141*t144*t155*t256*t265+t1321+t1320+t1319+t1318+t131
     :           7+t1316+t1315+t1314+t1313+t1312+t1311)+6.21813817393097
     ;           8d-2*t1055*t139*t339*t519-3.109069086965489d-2*t139*t33
     <           9*t517*t518-1.8654414521792934d-1*t142*t256*t271*t339*t
     =           518+9.327207260896466d-2*t142*t253*t339*t486+1.86544145
     >           21792934d-1*t138*t253*t339*t483)
              t1337 = 3.109069086965489d-2*t139*t253*t339*t524
              t1338 = t158*(-2.4488599673656505d-2*t418*t47*t48*t51*t52*
     1           t62*t947-1.6325733115771002d-2*t178*t355*t359*t419*t47*
     2           t51*t52*t673+3.2651466231542003d-3*t179*t182*t355*t359*
     3           t51*t52*t673+6.25d-1*t178*t419*t47*t62*t663-1.25d-1*t17
     4           9*t182*t62*t663+2.5d-1*t163*t179*t355*t359*t47*t663+4.0
     5           814332789427504d-3*t419*t434*t47*t48*t51*t52*t62-8.1628
     6           66557885502d-4*t179*t435*t48*t51*t52*t62+8.162866557885
     7           501d-3*t178*t182*t419*t48*t51*t52*t62-6.25d-2*t1292*t17
     8           9*t47*t62+t1309+t1308+t1307+t1306+t1305+t1304+t1303+t13
     9           02)-1.5625d-2*rhoa*t42*t57*t62*(3.1090690869654886d-2*t
     :           334*t416*t945+1.5545345434827443d-2*t205*(-1.2973268971
     ;           238278d+0*gammaaa*t29*t332*t34*t413*t944+8.648845980825
     <           517d-1*gammaaa*t214*t29*t34*t412*t669+1.009032031096310
     =           4d+0*gammaaa*t206*t207*t212*t34*t669-4.3244229904127585
     >           d-1*gammaaa*t211*t212*t29*t669-1.0090320310963104d+0*ga
     ?           mmaaa*t206*t207*t39*t668-4.3244229904127585d-1*gammaaa*
     @           t212*t214*t29*t668+4.3244229904127585d-1*t29*t34*t412*t
     1           413+9.350317100005212d-2*gammaaa*t32*t333*t412*t413+4.3
     2           244229904127585d-1*gammaaa*t29*t332*t34*t411*t412-2.018
     3           0640621926207d+0*gammaaa*t206*t207*t214*t332*t34*t412+8
     4           .648845980825517d-1*gammaaa*t211*t214*t29*t332*t412-2.1
     5           622114952063792d-1*t212*t29*t34*t411-4.675158550002606d
     6           -2*gammaaa*t212*t32*t333*t411-2.1622114952063792d-1*gam
     7           maaa*t212*t29*t34*(-7.272468855559613d-2*gammaaa*t37*t3
     8           96*t410-1.1227750021070412d+2*gammaaa*t204*t206*t213*t3
     9           0*t410+2.545364099445863d+0*gammaaa*t37*t395*t409+2.321
     :           5435544741472d+3*t29*t35*t397*t398*t407-7.7384785149138
     ;           24d+2*t213*t29*t30*t35*t397+1.2029732165432584d+1*t213*
     <           t29*t30*t35*t394+t1300+t1299+t1298+t1297+t1296+t1295)-1
     =           .8181172138899032d-2*gammaaa*t32*t39*t396*t410+2.181740
     >           656667883d-1*gammaaa*t206*t212*t214*t32*t410+3.81804614
     ?           9168795d-1*gammaaa*t32*t39*t395*t409+2.1622114952063792
     @           d-1*t29*t39*t406-2.1622114952063792d-1*gammaaa*t212*t29
     1           *t332*t406-8.408600259135923d-2*t207*t34*t39*t396+8.408
     2           600259135923d-2*gammaaa*t207*t212*t332*t34*t396+1.76580
     3           6054418543d+0*t333*t34*t39*t395-1.765806054418543d+0*ga
     4           mmaaa*t212*t332*t333*t34*t395+2.1622114952063792d-1*gam
     5           maaa*(t1300+t1299+t1298+t1297+t1296+t1295)*t29*t39-1.00
     6           90320310963104d+0*t206*t207*t211*t39+1.0090320310963104
     7           d+0*t206*t207*t212*t214*t34+1.0090320310963104d+0*gamma
     8           aa*t206*t207*t211*t212*t332-4.3244229904127585d-1*t211*
     9           t212*t214*t29)-3.1090690869654886d-2*t215*t415*t670-1.5
     :           545345434827443d-2*t334*t414*t415)+2*t272*t678-3.125d-2
     ;           *t42*t57*t62*t671+3.125d-2*rhoa*t166*t57*t62*t671-3.125
     <           d-2*rhoa*t183*t42*t62*t671+6.25d-2*rhoa*t125*t355*t359*
     =           t57*t671-3.125d-2*t41*t42*t62*t664-3.125d-2*rhoa*t216*t
     >           42*t62*t664+3.125d-2*rhoa*t166*t41*t62*t664+3.125d-2*rh
     ?           ob*t102*t166*t62*t664+6.25d-2*rhoa*t125*t355*t359*t41*t
     @           664+6.25d-2*rhob*t102*t125*t355*t359*t664-3.26514662315
     1           42003d-3*t179*t355*t359*t41*t47*t51*t52*t649-3.26514662
     2           31542003d-3*rhoa*t179*t216*t355*t359*t47*t51*t52*t649+4
     3           .8579204483835753d-4*t166*t205*t334*t57*t62-1.632573311
     4           5771002d-3*t179*t41*t432*t47*t51*t52*t62-1.632573311577
     5           1002d-3*rhoa*t179*t216*t432*t47*t51*t52*t62+8.162866557
     6           885502d-4*rhoa*t176*t179*t417*t47*t51*t52*t62+1.6325733
     7           115771002d-3*t176*t179*t216*t47*t51*t52*t62-2.428960224
     8           1917876d-4*rhoa*t205*t334*t42*t436*t62-1.5625d-2*rhoa*t
     9           1293*t41*t42*t62-4.8579204483835753d-4*t183*t205*t334*t
     :           42*t62-1.5625d-2*rhob*t102*t1293*t42*t62+4.857920448383
     ;           5753d-4*rhoa*t166*t183*t205*t334*t62+9.715840896767151d
     <           -4*t125*t205*t334*t355*t359*t57+t336*t520+9.71584089676
     =           7151d-4*rhoa*t125*t183*t205*t334*t355*t359+t1337+t1336+
     >           t1310+t1301+t1294+t1290+t1289+t1288+t1287+t1286+t1285+t
     ?           1284+t1283+t1282+t1281+t1280+t1279+t1278+t1277+t1276+t1
     @           275+t1274+t1273+t1272+t1271+t1270+t1269
              t1339 = 3.2812499999999994d-2*t1062*t245*t341*t856
              t1340 = 3.2812499999999994d-2*t163*t341*t58*t60*t62
              t1341 = -6.562499999999999d-2*t163*t273*t355*t58*t61
              t1342 = -3.2812499999999994d-2*t166*t273*t60*t62
              t1343 = 9.843749999999998d-2*t160*t245*t359*t856
              t1344 = 6.562499999999999d-2*t125*t160*t355*t58*t61
              t1345 = 3.2812499999999994d-2*t160*t163*t60*t62
              t1346 = 1.6406249999999997d-2*t42*t525*t60*t62
              t1347 = -1.6325733115771002d-2*rhoa*t1268*t179*t355*t359*t
     1           41*t47*t49*t50*t51
              t1348 = -6.25d-1*rhoa*t245*t355*t41*t57*t58
              t1349 = -1.6325733115771002d-2*rhob*t102*t1268*t179*t355*t
     1           359*t47*t49*t50*t51
              t1350 = -6.25d-1*rhob*t102*t245*t355*t57*t58
              t1351 = -1.25d-1*rhoa*t125*t41*t57*t60*t61
              t1352 = -1.25d-1*rhob*t102*t125*t57*t60*t61
              t1353 = -3.2651466231542003d-3*rhoa*t179*t41*t47*t49*t50*t
     1           51*t62*t673
              t1354 = -2.5540702474450633d-1*t432*t49*t50*t51
              t1355 = -6.965646129395628d-2*t176*t51*t708+2.612117298523
     1           3604d-2*t175*t48*t708+1.3060586492616802d-2*t48*(-2.0d+
     2           0*t425*t50-2.0d+0*t422*t49-4.0d+0*t169*t171)*t51-2.6121
     3           172985233604d-2*t431*t48*t49*t50+1.3931292258791256d-1*
     4           t175*t176*t49*t50+t1354
              t1356 = 3.1345407582280327d+0*t418*t47*t48*t49*t50*t51*t94
     1           7+4.0d+1*t178*t419*t47*t709-8.0d+0*t179*t182*t709-5.224
     2           234597046721d-1*t419*t434*t47*t48*t49*t50*t51+1.0448469
     3           194093442d-1*t179*t435*t48*t49*t50*t51-1.04484691940934
     4           42d+0*t178*t182*t419*t48*t49*t50*t51-4.0d+0*t1355*t179*
     5           t47
              t1357 = -3.2651466231542003d-3*rhob*t102*t179*t47*t49*t50*
     1           t51*t62*t673
              t1358 = 9.795439869462602d-3*t179*t355*t359*t47*t49*t50*t5
     1           1*t649
              t1359 = 3.75d-1*t125*t355*t47*t56*t58
              t1360 = -1.1123881089968671d+0*t143*t149*t266*t338*t345*t4
     1           87*t58
              t1361 = 5.297086233318417d-2*t143*t149*t258*t266*t345*t489
     1           *t58
              t1362 = 2.2247762179937342d+0*t143*t149*t155*t338*t487
              t1363 = -1.0594172466636834d-1*t143*t149*t155*t258*t489
              t1364 = 3.030385236826838d-1*t147*t150*t155*t487*t508*t58
              t1365 = -1.4430405889651615d-2*t147*t150*t155*t489*t507*t5
     1           8
              t1366 = 1.6345294662811108d+0*t141*t147*t150*t483
              t1367 = -5.448431554270369d-1*t141*t144*t147*t486
              t1368 = 2.542601391992839d+0*t144*t147*t256*t257*t258
              t1369 = 2.2247762179937342d+0*t143*t147*t338*t487
              t1370 = -1.0594172466636834d-1*t143*t147*t258*t489
              t1371 = -2.7242157771351844d-1*t141*t143*t145*t262*t496
              t1372 = 1.0896863108540737d+0*t141*t144*t145*t256*t262*t26
     1           3
              t1373 = 1.2713006959964196d+0*t143*t145*t257*t258*t262*t26
     1           3
              t1374 = 5.448431554270369d-1*t141*t143*t500*t501*t502
              t1375 = -2.7242157771351844d-1*t141*t143*t145*t262*t502
              t1376 = 2.0202568245512253d+0*t150*t153*t487*t508*t58
              t1377 = -5.772162355860646d-2*t150*t153*t489*t507*t58
              t1378 = t158*(4.897719934731301d-2*t418*t47*t48*t49*t50*t5
     1           1*t62*t947+6.25d-1*t178*t419*t47*t62*t709-1.25d-1*t179*
     2           t182*t62*t709+2.5d-1*t163*t179*t355*t359*t47*t709+3.265
     3           1466231542003d-2*t178*t355*t359*t419*t47*t49*t50*t51*t6
     4           73-6.530293246308401d-3*t179*t182*t355*t359*t49*t50*t51
     5           *t673-8.162866557885501d-3*t419*t434*t47*t48*t49*t50*t5
     6           1*t62+1.6325733115771002d-3*t179*t435*t48*t49*t50*t51*t
     7           62-1.6325733115771002d-2*t178*t182*t419*t48*t49*t50*t51
     8           *t62-6.25d-2*t1355*t179*t47*t62+6.25d-2*t42*t435*t56*t6
     9           0*t61-2.5d-1*t179*t42*t434*t47*t60*t61+1.25d+0*t418*t41
     :           9*t42*t47*t60*t61-5.0d-1*t178*t179*t182*t42*t60*t61-2.5
     ;           d-1*t163*t182*t355*t56*t58+1.0d+0*t163*t178*t179*t355*t
     <           47*t58+t1359+t1358)+2*t219*t725+t159*(-6.21813817393097
     =           8d-2*t139*t271*t518*t724+1.8654414521792934d-1*t142*t25
     >           3*t256*t724+3.109069086965489d-2*t139*t253*(5.448431554
     ?           270369d-1*t141*t143*t149*t270*t515*t58*t723-2.724215777
     @           1351844d-1*t141*t143*t265*t266*t58*t723+6.3565034799820
     1           97d-1*t143*t149*t257*t258*t266*t58*t723+5.4484315542703
     2           69d-1*t141*t144*t149*t256*t266*t58*t723-2.7242157771351
     3           844d-1*t141*t143*t266*t270*t58*t721-6.356503479982097d-
     4           1*t143*t155*t257*t258*t58*t721-5.448431554270369d-1*t14
     5           1*t144*t155*t256*t58*t721-1.3621078885675922d-1*t141*t1
     6           43*t149*t266*t58*(1.3853189654065545d+0*t145*t150*t257*
     7           t263*t269*t507*t58+2.770637930813109d+0*t153*t256*t257*
     8           t268*t507*t58+4.452810960235354d-1*t141*t150*t151*t500*
     9           t502*t513+1.4842703200784513d+0*t141*t151*t153*t483*t51
     :           1-1.4842703200784513d-1*t141*t145*t150*t151*t269*t502-1
     ;           .4842703200784513d-1*t141*t145*t150*t151*t269*t496-2.96
     <           85406401569026d-1*t141*t151*t153*t268*t486+1.1874162560
     =           62761d+0*t141*t145*t151*t256*t263*t268*t269+t1377+t1376
     >           +t1375+t1374+t1373+t1372+t1371+t1370+t1369+t1368+t1367+
     ?           t1366)+7.421351600392256d-2*t147*t150*t338*t515*t516*t5
     @           8-8.172647331405554d-1*t1054*t141*t143*t149*t345*t516*t
     1           58+2.7242157771351844d-1*t141*t143*t149*t345*t514*t515*
     2           t58+5.448431554270369d-1*t141*t143*t265*t270*t345*t515*
     3           t58-1.2713006959964196d+0*t143*t149*t257*t258*t270*t345
     4           *t515*t58-1.0896863108540737d+0*t141*t144*t149*t256*t27
     5           0*t345*t515*t58-3.710675800196128d-2*t147*t150*t266*t33
     6           8*t514*t58+2.2264054801176772d-1*t147*t155*t338*t483*t5
     7           11*t58+1.7316487067581934d-1*t147*t150*t257*t266*t270*t
     8           507*t58+3.463297413516387d-1*t147*t155*t256*t257*t268*t
     9           507*t58-1.3621078885675922d-1*t141*t143*t266*t345*t505*
     :           t58+2.7242157771351844d-1*t141*t144*t149*t266*t345*t486
     ;           *t58-7.421351600392256d-2*t147*t155*t268*t338*t486*t58-
     <           8.172647331405554d-1*t141*t149*t150*t266*t345*t483*t58+
     =           6.356503479982097d-1*t143*t257*t258*t265*t266*t345*t58+
     >           5.448431554270369d-1*t141*t144*t256*t265*t266*t345*t58-
     ?           1.2713006959964196d+0*t144*t149*t256*t257*t258*t266*t34
     @           5*t58+1.4842703200784513d-1*t147*t256*t266*t268*t270*t3
     1           38*t58+1.3621078885675922d-1*(t1375+t1374+t1373+t1372+t
     2           1371+t1370+t1369+t1368+t1367+t1366)*t141*t143*t155*t58+
     3           5.448431554270369d-1*t141*t143*t149*t515*t516-2.7242157
     4           771351844d-1*t141*t143*t149*t266*t514+2.724215777135184
     5           4d-1*t141*t143*t155*t505-5.448431554270369d-1*t141*t144
     6           *t149*t155*t486+1.6345294662811108d+0*t141*t149*t150*t1
     7           55*t483-5.448431554270369d-1*t141*t143*t265*t266*t270+1
     8           .2713006959964196d+0*t143*t149*t257*t258*t266*t270+1.08
     9           96863108540737d+0*t141*t144*t149*t256*t266*t270-1.27130
     :           06959964196d+0*t143*t155*t257*t258*t265-1.0896863108540
     ;           737d+0*t141*t144*t155*t256*t265+2.542601391992839d+0*t1
     <           44*t149*t155*t256*t257*t258+t1365+t1364+t1363+t1362+t13
     =           61+t1360)+6.218138173930978d-2*t1055*t139*t346*t519-3.1
     >           09069086965489d-2*t139*t346*t517*t518-1.865441452179293
     ?           4d-1*t142*t256*t271*t346*t518+9.327207260896466d-2*t142
     @           *t253*t346*t486+1.8654414521792934d-1*t138*t253*t346*t4
     1           83)+2*t272*t714-3.125d-2*t41*t42*t62*t710-3.125d-2*rhoa
     2           *t216*t42*t62*t710+3.125d-2*rhoa*t166*t41*t62*t710+3.12
     3           5d-2*rhob*t102*t166*t62*t710+6.25d-2*rhoa*t125*t355*t35
     4           9*t41*t710+6.25d-2*rhob*t102*t125*t355*t359*t710+6.5302
     5           93246308401d-3*t179*t355*t359*t41*t47*t49*t50*t51*t649+
     6           6.530293246308401d-3*rhoa*t179*t216*t355*t359*t47*t49*t
     7           50*t51*t649+3.2651466231542003d-3*t179*t41*t432*t47*t49
     8           *t50*t51*t62+3.2651466231542003d-3*rhoa*t179*t216*t432*
     9           t47*t49*t50*t51*t62-1.6325733115771002d-3*rhoa*t176*t17
     :           9*t417*t47*t49*t50*t51*t62-3.2651466231542003d-3*t176*t
     ;           179*t216*t47*t49*t50*t51*t62-1.5625d-2*rhoa*t1356*t41*t
     <           42*t62-1.5625d-2*rhob*t102*t1356*t42*t62-6.25d-2*rhoa*t
     =           166*t417*t57*t60*t61+1.25d-1*t163*t41*t57*t60*t61-1.25d
     >           -1*t166*t216*t57*t60*t61+1.25d-1*rhoa*t163*t216*t57*t60
     ?           *t61-6.25d-2*rhoa*t166*t41*t436*t60*t61-6.25d-2*rhob*t1
     @           02*t166*t436*t60*t61-1.25d-1*t166*t183*t41*t60*t61+1.25
     1           d-1*rhoa*t163*t183*t41*t60*t61-1.25d-1*rhoa*t166*t183*t
     2           216*t60*t61+1.25d-1*rhob*t102*t163*t183*t60*t61+2.5d-1*
     3           t125*t355*t41*t57*t58+2.5d-1*rhoa*t125*t216*t355*t57*t5
     4           8+2.5d-1*rhoa*t125*t183*t355*t41*t58+2.5d-1*rhob*t102*t
     5           125*t183*t355*t58+3.109069086965489d-2*t139*t253*t346*t
     6           524+t344*t520+t1357+t1353+t1352+t1351+t1350+t1349+t1348
     7           +t1347
              t1379 = 3.2812499999999994d-2*t1062*t245*t347*t856
              t1380 = 3.2812499999999994d-2*t163*t347*t58*t60*t62
              t1381 = 1.9687499999999997d-1*t160*t245*t359*t856
              t1382 = 1.3124999999999998d-1*t125*t160*t355*t58*t61
              t1383 = 6.562499999999999d-2*t160*t163*t60*t62
              t1384 = 8.162866557885501d-3*rhoa*t1268*t179*t355*t359*t41
     1           *t47*t51*t53
              t1385 = -2.428960224191788d-3*rhob*t245*t304*t351*t355*t35
     1           9*t57
              t1386 = 8.162866557885501d-3*rhob*t102*t1268*t179*t355*t35
     1           9*t47*t51*t53
              t1387 = 1.6325733115771002d-3*rhoa*t179*t41*t47*t51*t53*t6
     1           2*t673
              t1388 = 1.2770351237225316d-1*t432*t51*t53
              t1389 = 1.3060586492616802d-2*t431*t48*t53-6.9656461293956
     1           28d-2*t175*t176*t53+1.3060586492616802d-2*t48*(2*t422*t
     2           50+2*t427)*t51-1.3931292258791256d-1*t171*t176*t50*t51+
     3           5.224234597046721d-2*t171*t175*t48*t50+t1388
              t1390 = -1.5672703791140163d+0*t418*t47*t48*t51*t53*t947+4
     1           .0d+1*t178*t419*t47*t738-8.0d+0*t179*t182*t738+2.612117
     2           2985233604d-1*t419*t434*t47*t48*t51*t53-5.2242345970467
     3           21d-2*t179*t435*t48*t51*t53+5.224234597046721d-1*t178*t
     4           182*t419*t48*t51*t53-4.0d+0*t1389*t179*t47
              t1391 = -4.8579204483835753d-4*rhob*t163*t304*t351*t57*t62
              t1392 = 1.6325733115771002d-3*rhob*t102*t179*t47*t51*t53*t
     1           62*t673
              t1393 = -4.897719934731301d-3*t179*t355*t359*t47*t51*t53*t
     1           649
              t1394 = t158*(-2.4488599673656505d-2*t418*t47*t48*t51*t53*
     1           t62*t947+6.25d-1*t178*t419*t47*t62*t738-1.25d-1*t179*t1
     2           82*t62*t738+2.5d-1*t163*t179*t355*t359*t47*t738-1.63257
     3           33115771002d-2*t178*t355*t359*t419*t47*t51*t53*t673+3.2
     4           651466231542003d-3*t179*t182*t355*t359*t51*t53*t673+4.0
     5           814332789427504d-3*t419*t434*t47*t48*t51*t53*t62-8.1628
     6           66557885502d-4*t179*t435*t48*t51*t53*t62+8.162866557885
     7           501d-3*t178*t182*t419*t48*t51*t53*t62-6.25d-2*t1389*t17
     8           9*t47*t62+t1393+t1309+t1308+t1307+t1306+t1305+t1304+t13
     9           03)+2*t272*t743-3.125d-2*t41*t42*t62*t739-3.125d-2*rhoa
     :           *t216*t42*t62*t739+3.125d-2*rhoa*t166*t41*t62*t739+3.12
     ;           5d-2*rhob*t102*t166*t62*t739+6.25d-2*rhoa*t125*t355*t35
     <           9*t41*t739+6.25d-2*rhob*t102*t125*t355*t359*t739-3.2651
     =           466231542003d-3*t179*t355*t359*t41*t47*t51*t53*t649-3.2
     >           651466231542003d-3*rhoa*t179*t216*t355*t359*t47*t51*t53
     ?           *t649-1.6325733115771002d-3*t179*t41*t432*t47*t51*t53*t
     @           62-1.6325733115771002d-3*rhoa*t179*t216*t432*t47*t51*t5
     1           3*t62+8.162866557885502d-4*rhoa*t176*t179*t417*t47*t51*
     2           t53*t62+1.6325733115771002d-3*t176*t179*t216*t47*t51*t5
     3           3*t62-2.4289602241917876d-4*rhob*t304*t351*t42*t436*t62
     4           -1.5625d-2*rhoa*t1390*t41*t42*t62-1.5625d-2*rhob*t102*t
     5           1390*t42*t62+4.8579204483835753d-4*rhob*t166*t183*t304*
     6           t351*t62+t352*t520+9.715840896767151d-4*rhob*t125*t183*
     7           t304*t351*t355*t359+t1392+t1391+t1387+t1386+t1385+t1384
     8           +t1337+t1336+t1310+t1289+t1288+t1287+t1286+t1285+t1284+
     9           t1283+t1282+t1281+t1280+t1279+t1278+t1277+t1276+t1274+t
     :           1273+t1272+t1270
              t1395 = 3.2812499999999994d-2*t1062*t245*t353*t856
              t1396 = 3.2812499999999994d-2*t163*t353*t58*t60*t62
              t1397 = 6.25d-2*rhoa*t125*t183*t355*t41*t58
              t1398 = 6.25d-2*rhoa*t125*t283*t355*t41*t58
              t1399 = 6.25d-2*rhoa*t125*t216*t355*t57*t58
              t1400 = 6.25d-2*t125*t355*t41*t57*t58
              t1401 = 6.25d-2*rhob*t125*t315*t355*t57*t58
              t1402 = 6.25d-2*rhob*t102*t125*t183*t355*t58
              t1403 = 6.25d-2*rhob*t102*t125*t283*t355*t58
              t1404 = 6.25d-2*t102*t125*t355*t57*t58
              t1405 = 3.125d-2*rhoa*t163*t183*t41*t60*t61
              t1406 = -3.125d-2*rhoa*t166*t41*t537*t60*t61
              t1407 = 3.125d-2*rhoa*t163*t283*t41*t60*t61
              t1408 = -3.125d-2*rhoa*t166*t216*t283*t60*t61
              t1409 = -3.125d-2*t166*t283*t41*t60*t61
              t1410 = 3.125d-2*rhoa*t163*t216*t57*t60*t61
              t1411 = 3.125d-2*t163*t41*t57*t60*t61
              t1412 = -3.125d-2*rhob*t166*t183*t315*t60*t61
              t1413 = 3.125d-2*rhob*t163*t315*t57*t60*t61
              t1414 = 3.125d-2*rhob*t102*t163*t183*t60*t61
              t1415 = -3.125d-2*t102*t166*t183*t60*t61
              t1416 = -3.125d-2*rhob*t102*t166*t537*t60*t61
              t1417 = 3.125d-2*rhob*t102*t163*t283*t60*t61
              t1418 = 3.125d-2*t102*t163*t57*t60*t61
              t1419 = 1.3060586492616802d-2*t48*t52*t534-3.4828230646978
     1           14d-2*t176*t280*t52-3.482823064697814d-2*t175*t176*t52+
     2           1.3060586492616802d-2*t48*(2*t169*t278-4*t163*t43*t49)*
     3           t51-6.965646129395628d-2*t176*t278*t49*t51-6.9656461293
     4           95628d-2*t169*t176*t49*t51+2.6121172985233604d-2*t169*t
     5           280*t48*t49+2.6121172985233604d-2*t175*t278*t48*t49+t12
     6           91
              t1420 = -1.5672703791140163d+0*t178*t281*t47*t48*t51*t52*t
     1           947+2.0d+1*t178*t419*t47*t752-4.0d+0*t179*t182*t752+2.0
     2           d+1*t281*t419*t47*t663-4.0d+0*t179*t282*t663-5.22423459
     3           7046721d-2*t179*t48*t51*t52*t536+2.6121172985233604d-1*
     4           t419*t47*t48*t51*t52*t535+2.6121172985233604d-1*t178*t2
     5           82*t419*t48*t51*t52+2.6121172985233604d-1*t182*t281*t41
     6           9*t48*t51*t52-4.0d+0*t1419*t179*t47
              t1421 = 2.5d-1*t163*t179*t281*t355*t47*t58
              t1422 = 2.5d-1*t163*t178*t179*t355*t47*t58
              t1423 = -6.25d-2*t163*t182*t355*t56*t58
              t1424 = -6.25d-2*t163*t282*t355*t56*t58
              t1425 = 6.25d-1*t178*t281*t419*t42*t47*t60*t61
              t1426 = -1.25d-1*t179*t42*t47*t535*t60*t61
              t1427 = -1.25d-1*t179*t182*t281*t42*t60*t61
              t1428 = -1.25d-1*t178*t179*t282*t42*t60*t61
              t1429 = 3.125d-2*t42*t536*t56*t60*t61
              t1430 = t219*t763
              t1431 = 3.109069086965489d-2*t139*t253*t339*t540
              t1432 = t316*t690
              t1433 = 8.172647331405554d-1*t141*t147*t150*t256*t320
              t1434 = -2.7242157771351844d-1*t141*t144*t147*t544
              t1435 = 6.356503479982097d-1*t144*t147*t257*t258*t320
              t1436 = 6.356503479982097d-1*t144*t147*t256*t257*t258
              t1437 = -1.3621078885675922d-1*t141*t143*t145*t262*t549
              t1438 = 2.7242157771351844d-1*t141*t144*t145*t256*t262*t32
     1           2
              t1439 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t32
     1           2
              t1440 = 2.7242157771351844d-1*t141*t144*t145*t262*t263*t32
     1           0
              t1441 = 3.1782517399910487d-1*t143*t145*t257*t258*t262*t26
     1           3
              t1442 = 2.7242157771351844d-1*t141*t143*t263*t322*t500*t50
     1           1
              t1443 = -1.3621078885675922d-1*t141*t143*t145*t262*t263*t3
     1           22
              t1444 = t159*(-3.109069086965489d-2*t139*t271*t518*t762+9.
     1           327207260896466d-2*t142*t253*t256*t762+3.10906908696548
     2           9d-2*t139*t253*(2.7242157771351844d-1*t141*t143*t149*t2
     3           70*t515*t58*t761-1.3621078885675922d-1*t141*t143*t265*t
     4           266*t58*t761+3.1782517399910487d-1*t143*t149*t257*t258*
     5           t266*t58*t761+2.7242157771351844d-1*t141*t144*t149*t256
     6           *t266*t58*t761-1.3621078885675922d-1*t141*t143*t266*t27
     7           0*t58*t760-3.1782517399910487d-1*t143*t155*t257*t258*t5
     8           8*t760-2.7242157771351844d-1*t141*t144*t155*t256*t58*t7
     9           60+2.7242157771351844d-1*t141*t143*t149*t325*t515*t58*t
     :           688-1.3621078885675922d-1*t141*t143*t266*t324*t58*t688+
     ;           2.7242157771351844d-1*t141*t144*t149*t266*t320*t58*t688
     <           +3.1782517399910487d-1*t143*t149*t257*t258*t266*t58*t68
     =           8-1.3621078885675922d-1*t141*t143*t266*t325*t58*t686-2.
     >           7242157771351844d-1*t141*t144*t155*t320*t58*t686-3.1782
     ?           517399910487d-1*t143*t155*t257*t258*t58*t686-1.36210788
     @           85675922d-1*t141*t143*t149*t266*t58*(3.4632974135163863
     1           d-1*t145*t150*t257*t269*t322*t507*t58+6.926594827032773
     2           d-1*t153*t257*t268*t320*t507*t58+3.4632974135163863d-1*
     3           t145*t150*t257*t263*t269*t507*t58+6.926594827032773d-1*
     4           t153*t256*t257*t268*t507*t58-7.421351600392256d-2*t141*
     5           t145*t150*t151*t269*t549-1.4842703200784513d-1*t141*t15
     6           1*t153*t268*t544+2.226405480117677d-1*t141*t150*t151*t2
     7           63*t322*t500*t513+7.421351600392256d-1*t141*t151*t153*t
     8           256*t320*t511+2.9685406401569026d-1*t141*t145*t151*t256
     9           *t268*t269*t322-7.421351600392256d-2*t141*t145*t150*t15
     :           1*t263*t269*t322+2.9685406401569026d-1*t141*t145*t151*t
     ;           263*t268*t269*t320+t1443+t1442+t1441+t1440+t1439+t1438+
     <           t1437+t1436+t1435+t1434+t1433+t1334+t1333+t1326+t1325)+
     =           2.7242157771351844d-1*t141*t143*t149*t337*t515*t560*t58
     >           -1.855337900098064d-2*t147*t150*t266*t338*t560*t58-1.36
     ?           21078885675922d-1*t141*t143*t266*t337*t557*t58-3.710675
     @           800196128d-2*t147*t155*t268*t338*t544*t58+2.72421577713
     1           51844d-1*t141*t144*t149*t266*t337*t544*t58+3.7106758001
     2           96128d-2*t147*t150*t270*t325*t338*t515*t58+2.7242157771
     3           351844d-1*t141*t143*t265*t325*t337*t515*t58-6.356503479
     4           982097d-1*t143*t149*t257*t258*t325*t337*t515*t58-5.4484
     5           31554270369d-1*t141*t144*t149*t256*t325*t337*t515*t58+2
     6           .7242157771351844d-1*t141*t143*t270*t324*t337*t515*t58-
     7           5.448431554270369d-1*t141*t144*t149*t270*t320*t337*t515
     8           *t58-6.356503479982097d-1*t143*t149*t257*t258*t270*t337
     9           *t515*t58+1.1132027400588386d-1*t147*t155*t256*t320*t33
     :           8*t511*t58+4.3291217668954834d-2*t147*t150*t257*t266*t3
     ;           25*t507*t58+8.658243533790967d-2*t147*t155*t257*t268*t3
     <           20*t507*t58+4.3291217668954834d-2*t147*t150*t257*t266*t
     =           270*t507*t58+8.658243533790967d-2*t147*t155*t256*t257*t
     >           268*t507*t58+3.710675800196128d-2*t147*t256*t266*t268*t
     ?           325*t338*t58+3.710675800196128d-2*t147*t266*t268*t270*t
     @           320*t338*t58-8.172647331405554d-1*t1054*t141*t143*t149*
     1           t270*t325*t337*t58+3.1782517399910487d-1*t143*t257*t258
     2           *t266*t324*t337*t58+2.7242157771351844d-1*t141*t144*t25
     3           6*t266*t324*t337*t58+2.7242157771351844d-1*t141*t144*t2
     4           65*t266*t320*t337*t58-6.356503479982097d-1*t144*t149*t2
     5           57*t258*t266*t320*t337*t58-8.172647331405554d-1*t141*t1
     6           49*t150*t256*t266*t320*t337*t58+3.1782517399910487d-1*t
     7           143*t257*t258*t265*t266*t337*t58-6.356503479982097d-1*t
     8           144*t149*t256*t257*t258*t266*t337*t58+1.362107888567592
     9           2d-1*t141*t143*(t1443+t1442+t1441+t1440+t1439+t1438+t14
     :           37+t1436+t1435+t1434+t1433+t1326+t1325)*t155*t58-1.3621
     ;           078885675922d-1*t141*t143*t149*t266*t560+1.362107888567
     <           5922d-1*t141*t143*t155*t557-2.7242157771351844d-1*t141*
     =           t144*t149*t155*t544+2.7242157771351844d-1*t141*t143*t14
     >           9*t270*t325*t515-1.3621078885675922d-1*t141*t143*t265*t
     ?           266*t325+3.1782517399910487d-1*t143*t149*t257*t258*t266
     @           *t325+2.7242157771351844d-1*t141*t144*t149*t256*t266*t3
     1           25-1.3621078885675922d-1*t141*t143*t266*t270*t324-3.178
     2           2517399910487d-1*t143*t155*t257*t258*t324-2.72421577713
     3           51844d-1*t141*t144*t155*t256*t324+2.7242157771351844d-1
     4           *t141*t144*t149*t266*t270*t320-2.7242157771351844d-1*t1
     5           41*t144*t155*t265*t320+6.356503479982097d-1*t144*t149*t
     6           155*t257*t258*t320+8.172647331405554d-1*t141*t149*t150*
     7           t155*t256*t320+3.1782517399910487d-1*t143*t149*t257*t25
     8           8*t266*t270-3.1782517399910487d-1*t143*t155*t257*t258*t
     9           265+6.356503479982097d-1*t144*t149*t155*t256*t257*t258+
     :           t1318+t1317+t1315+t1314+t1312+t1311)-3.109069086965489d
     ;           -2*t139*t326*t518*t689+9.327207260896466d-2*t142*t253*t
     <           320*t689-3.109069086965489d-2*t139*t339*t518*t561+9.327
     =           207260896466d-2*t142*t253*t339*t544-9.327207260896466d-
     >           2*t142*t256*t326*t339*t518-9.327207260896466d-2*t142*t2
     ?           71*t320*t339*t518+6.218138173930978d-2*t1055*t139*t271*
     @           t326*t339+1.8654414521792934d-1*t138*t253*t256*t320*t33
     1           9)
              t1445 = t158*(-2.4488599673656505d-2*t178*t281*t47*t48*t51
     1           *t52*t62*t947+3.125d-1*t178*t419*t47*t62*t752-6.25d-2*t
     2           179*t182*t62*t752+1.25d-1*t163*t179*t355*t359*t47*t752-
     3           8.162866557885501d-3*t281*t355*t359*t419*t47*t51*t52*t6
     4           73-8.162866557885501d-3*t178*t355*t359*t419*t47*t51*t52
     5           *t673+1.6325733115771002d-3*t179*t282*t355*t359*t51*t52
     6           *t673+1.6325733115771002d-3*t179*t182*t355*t359*t51*t52
     7           *t673+3.125d-1*t281*t419*t47*t62*t663-6.25d-2*t179*t282
     8           *t62*t663+1.25d-1*t163*t179*t355*t359*t47*t663-8.162866
     9           557885502d-4*t179*t48*t51*t52*t536*t62+4.08143327894275
     :           04d-3*t419*t47*t48*t51*t52*t535*t62+4.0814332789427504d
     ;           -3*t178*t282*t419*t48*t51*t52*t62+4.0814332789427504d-3
     <           *t182*t281*t419*t48*t51*t52*t62-6.25d-2*t1419*t179*t47*
     =           t62+t1429+t1428+t1427+t1426+t1425+t1424+t1423+t1422+t14
     >           21+t1305+t1302)+t272*t756-1.5625d-2*t41*t42*t62*t753-1.
     ?           5625d-2*rhoa*t216*t42*t62*t753+1.5625d-2*rhoa*t166*t41*
     @           t62*t753+1.5625d-2*rhob*t102*t166*t62*t753+3.125d-2*rho
     1           a*t125*t355*t359*t41*t753+3.125d-2*rhob*t102*t125*t355*
     2           t359*t753+t327*t678+1.5625d-2*rhoa*t166*t57*t62*t671-1.
     3           5625d-2*rhoa*t283*t42*t62*t671+3.125d-2*rhoa*t125*t355*
     4           t359*t57*t671-1.5625d-2*rhob*t315*t42*t62*t664-1.5625d-
     5           2*t102*t42*t62*t664+1.5625d-2*rhoa*t166*t41*t62*t664+1.
     6           5625d-2*rhob*t102*t166*t62*t664+3.125d-2*rhoa*t125*t355
     7           *t359*t41*t664+3.125d-2*rhob*t102*t125*t355*t359*t664-1
     8           .6325733115771002d-3*t179*t355*t359*t41*t47*t51*t52*t64
     9           9-1.6325733115771002d-3*rhob*t179*t315*t355*t359*t47*t5
     :           1*t52*t649-1.6325733115771002d-3*rhoa*t179*t216*t355*t3
     ;           59*t47*t51*t52*t649-1.6325733115771002d-3*t102*t179*t35
     <           5*t359*t47*t51*t52*t649+2.4289602241917876d-4*t166*t205
     =           *t334*t57*t62-2.4289602241917876d-4*rhoa*t205*t334*t42*
     >           t537*t62-8.162866557885502d-4*t179*t41*t432*t47*t51*t52
     ?           *t62-8.162866557885502d-4*rhob*t179*t315*t432*t47*t51*t
     @           52*t62-8.162866557885502d-4*rhoa*t179*t216*t432*t47*t51
     1           *t52*t62-8.162866557885502d-4*t102*t179*t432*t47*t51*t5
     2           2*t62-1.5625d-2*rhoa*t1420*t41*t42*t62-2.42896022419178
     3           76d-4*t205*t283*t334*t42*t62-1.5625d-2*rhob*t102*t1420*
     4           t42*t62+2.4289602241917876d-4*rhoa*t166*t205*t283*t334*
     5           t62+2.4289602241917876d-4*rhoa*t166*t183*t205*t334*t62+
     6           4.8579204483835753d-4*t125*t205*t334*t355*t359*t57+t336
     7           *t562+4.8579204483835753d-4*rhoa*t125*t205*t283*t334*t3
     8           55*t359+4.8579204483835753d-4*rhoa*t125*t183*t205*t334*
     9           t355*t359+t1444+t1432+t1431+t1430+t1418+t1417+t1416+t14
     :           15+t1414+t1413+t1412+t1411+t1410+t1409+t1408+t1407+t140
     ;           6+t1405+t1404+t1403+t1402+t1401+t1400+t1399+t1398+t1397
     <           +t1301+t1294+t1290+t1288+t1281+t1277+t1275+t1272+t1271+
     =           t1269
              t1446 = 1.6406249999999997d-2*t42*t563*t60*t62
              t1447 = -3.2812499999999994d-2*t163*t328*t355*t58*t61
              t1448 = -1.6406249999999997d-2*t166*t328*t60*t62
              t1449 = -3.2812499999999994d-2*t163*t273*t355*t58*t61
              t1450 = -1.6406249999999997d-2*t166*t273*t60*t62
              t1451 = 1.25d-1*rhoa*t125*t283*t355*t41*t58
              t1452 = 1.25d-1*rhob*t125*t315*t355*t57*t58
              t1453 = 1.25d-1*rhob*t102*t125*t283*t355*t58
              t1454 = 1.25d-1*t102*t125*t355*t57*t58
              t1455 = 6.25d-2*rhoa*t163*t283*t41*t60*t61
              t1456 = 6.25d-2*rhob*t163*t315*t57*t60*t61
              t1457 = 6.25d-2*rhob*t102*t163*t283*t60*t61
              t1458 = 6.25d-2*t102*t163*t57*t60*t61
              t1459 = -3.482823064697814d-2*t176*t51*t768+1.306058649261
     1           6802d-2*t175*t48*t768-3.482823064697814d-2*t176*t51*t70
     2           8+1.3060586492616802d-2*t280*t48*t708-2.612117298523360
     3           4d-2*t48*t49*t50*t534+1.3060586492616802d-2*t48*(4.0d+0
     4           *t163*t43*t50-4.0d+0*t163*t43*t49-2.0d+0*t171*t278-2.0d
     5           +0*t169*t277)*t51+6.965646129395628d-2*t176*t280*t49*t5
     6           0+6.965646129395628d-2*t175*t176*t49*t50+t1354
              t1460 = 3.1345407582280327d+0*t178*t281*t47*t48*t49*t50*t5
     1           1*t947+2.0d+1*t178*t419*t47*t769-4.0d+0*t179*t182*t769+
     2           2.0d+1*t281*t419*t47*t709-4.0d+0*t179*t282*t709+1.04484
     3           69194093442d-1*t179*t48*t49*t50*t51*t536-5.224234597046
     4           721d-1*t419*t47*t48*t49*t50*t51*t535-5.224234597046721d
     5           -1*t178*t282*t419*t48*t49*t50*t51-5.224234597046721d-1*
     6           t182*t281*t419*t48*t49*t50*t51-4.0d+0*t1459*t179*t47
              t1461 = 5.0d-1*t163*t179*t281*t355*t47*t58
              t1462 = -1.25d-1*t163*t282*t355*t56*t58
              t1463 = 1.2713006959964196d+0*t144*t149*t155*t257*t258*t32
     1           0
              t1464 = 1.7316487067581934d-1*t147*t155*t257*t268*t320*t50
     1           7*t58
              t1465 = -6.356503479982097d-1*t143*t155*t257*t258*t324
              t1466 = 6.356503479982097d-1*t143*t149*t257*t258*t266*t325
              t1467 = 8.658243533790967d-2*t147*t150*t257*t266*t325*t507
     1           *t58
              t1468 = 1.6345294662811108d+0*t141*t147*t150*t256*t320
              t1469 = -5.448431554270369d-1*t141*t144*t147*t544
              t1470 = 1.2713006959964196d+0*t144*t147*t257*t258*t320
              t1471 = -2.7242157771351844d-1*t141*t143*t145*t262*t549
              t1472 = 5.448431554270369d-1*t141*t144*t145*t256*t262*t322
              t1473 = 6.356503479982097d-1*t143*t145*t257*t258*t262*t322
              t1474 = 5.448431554270369d-1*t141*t144*t145*t262*t263*t320
              t1475 = 5.448431554270369d-1*t141*t143*t263*t322*t500*t501
              t1476 = -2.7242157771351844d-1*t141*t143*t145*t262*t263*t3
     1           22
              t1477 = 1.3853189654065545d+0*t153*t257*t268*t320*t507*t58
              t1478 = 6.926594827032773d-1*t145*t150*t257*t269*t322*t507
     1           *t58
              t1479 = t158*(4.897719934731301d-2*t178*t281*t47*t48*t49*t
     1           50*t51*t62*t947+3.125d-1*t178*t419*t47*t62*t769-6.25d-2
     2           *t179*t182*t62*t769+1.25d-1*t163*t179*t355*t359*t47*t76
     3           9+3.125d-1*t281*t419*t47*t62*t709-6.25d-2*t179*t282*t62
     4           *t709+1.25d-1*t163*t179*t355*t359*t47*t709+1.6325733115
     5           771002d-2*t281*t355*t359*t419*t47*t49*t50*t51*t673+1.63
     6           25733115771002d-2*t178*t355*t359*t419*t47*t49*t50*t51*t
     7           673-3.2651466231542003d-3*t179*t282*t355*t359*t49*t50*t
     8           51*t673-3.2651466231542003d-3*t179*t182*t355*t359*t49*t
     9           50*t51*t673+1.6325733115771002d-3*t179*t48*t49*t50*t51*
     :           t536*t62-8.162866557885501d-3*t419*t47*t48*t49*t50*t51*
     ;           t535*t62-8.162866557885501d-3*t178*t282*t419*t48*t49*t5
     <           0*t51*t62-8.162866557885501d-3*t182*t281*t419*t48*t49*t
     =           50*t51*t62-6.25d-2*t1459*t179*t47*t62+6.25d-2*t42*t536*
     >           t56*t60*t61-2.5d-1*t179*t42*t47*t535*t60*t61+1.25d+0*t1
     ?           78*t281*t419*t42*t47*t60*t61-2.5d-1*t178*t179*t282*t42*
     @           t60*t61-2.5d-1*t179*t182*t281*t42*t60*t61+t1462+t1461+t
     1           1359+t1358+t1304+t1303)+t219*t777+t159*(-3.109069086965
     2           489d-2*t139*t271*t518*t776+9.327207260896466d-2*t142*t2
     3           53*t256*t776+3.109069086965489d-2*t139*t253*(2.72421577
     4           71351844d-1*t141*t143*t149*t270*t515*t58*t775-1.3621078
     5           885675922d-1*t141*t143*t265*t266*t58*t775+3.17825173999
     6           10487d-1*t143*t149*t257*t258*t266*t58*t775+2.7242157771
     7           351844d-1*t141*t144*t149*t256*t266*t58*t775-1.362107888
     8           5675922d-1*t141*t143*t266*t270*t58*t774-3.1782517399910
     9           487d-1*t143*t155*t257*t258*t58*t774-2.7242157771351844d
     :           -1*t141*t144*t155*t256*t58*t774+2.7242157771351844d-1*t
     ;           141*t143*t149*t325*t515*t58*t723-1.3621078885675922d-1*
     <           t141*t143*t266*t324*t58*t723+2.7242157771351844d-1*t141
     =           *t144*t149*t266*t320*t58*t723+3.1782517399910487d-1*t14
     >           3*t149*t257*t258*t266*t58*t723-1.3621078885675922d-1*t1
     ?           41*t143*t266*t325*t58*t721-2.7242157771351844d-1*t141*t
     @           144*t155*t320*t58*t721-3.1782517399910487d-1*t143*t155*
     1           t257*t258*t58*t721+2.7242157771351844d-1*t141*t143*t149
     2           *t345*t515*t560*t58-3.710675800196128d-2*t147*t150*t266
     3           *t338*t560*t58-1.3621078885675922d-1*t141*t143*t266*t34
     4           5*t557*t58-1.3621078885675922d-1*t141*t143*t149*t266*(-
     5           1.4842703200784513d-1*t141*t145*t150*t151*t269*t549-2.9
     6           685406401569026d-1*t141*t151*t153*t268*t544+4.452810960
     7           235354d-1*t141*t150*t151*t263*t322*t500*t513+1.48427032
     8           00784513d+0*t141*t151*t153*t256*t320*t511+5.93708128031
     9           3805d-1*t141*t145*t151*t256*t268*t269*t322-1.4842703200
     :           784513d-1*t141*t145*t150*t151*t263*t269*t322+5.93708128
     ;           0313805d-1*t141*t145*t151*t263*t268*t269*t320+t1478+t14
     <           77+t1476+t1475+t1474+t1473+t1472+t1471+t1470+t1469+t146
     =           8+t1377+t1376+t1370+t1369+t1335+t1332+t1329+t1324)*t58+
     >           2.7242157771351844d-1*t141*t144*t149*t266*t345*t544*t58
     ?           -7.421351600392256d-2*t147*t155*t268*t338*t544*t58+2.72
     @           42157771351844d-1*t141*t143*t265*t325*t345*t515*t58-6.3
     1           56503479982097d-1*t143*t149*t257*t258*t325*t345*t515*t5
     2           8-5.448431554270369d-1*t141*t144*t149*t256*t325*t345*t5
     3           15*t58+2.7242157771351844d-1*t141*t143*t270*t324*t345*t
     4           515*t58-5.448431554270369d-1*t141*t144*t149*t270*t320*t
     5           345*t515*t58-6.356503479982097d-1*t143*t149*t257*t258*t
     6           270*t345*t515*t58+7.421351600392256d-2*t147*t150*t270*t
     7           325*t338*t515*t58+2.2264054801176772d-1*t147*t155*t256*
     8           t320*t338*t511*t58-8.172647331405554d-1*t1054*t141*t143
     9           *t149*t270*t325*t345*t58+3.1782517399910487d-1*t143*t25
     :           7*t258*t266*t324*t345*t58+2.7242157771351844d-1*t141*t1
     ;           44*t256*t266*t324*t345*t58+2.7242157771351844d-1*t141*t
     <           144*t265*t266*t320*t345*t58-6.356503479982097d-1*t144*t
     =           149*t257*t258*t266*t320*t345*t58-8.172647331405554d-1*t
     >           141*t149*t150*t256*t266*t320*t345*t58+3.178251739991048
     ?           7d-1*t143*t257*t258*t265*t266*t345*t58-6.35650347998209
     @           7d-1*t144*t149*t256*t257*t258*t266*t345*t58+7.421351600
     1           392256d-2*t147*t256*t266*t268*t325*t338*t58+7.421351600
     2           392256d-2*t147*t266*t268*t270*t320*t338*t58+1.362107888
     3           5675922d-1*t141*t143*(t1476+t1475+t1474+t1473+t1472+t14
     4           71+t1470+t1469+t1468+t1370+t1369+t1329+t1324)*t155*t58-
     5           2.7242157771351844d-1*t141*t143*t149*t266*t560+2.724215
     6           7771351844d-1*t141*t143*t155*t557-5.448431554270369d-1*
     7           t141*t144*t149*t155*t544+5.448431554270369d-1*t141*t143
     8           *t149*t270*t325*t515-2.7242157771351844d-1*t141*t143*t2
     9           65*t266*t325+5.448431554270369d-1*t141*t144*t149*t256*t
     :           266*t325-2.7242157771351844d-1*t141*t143*t266*t270*t324
     ;           -5.448431554270369d-1*t141*t144*t155*t256*t324+5.448431
     <           554270369d-1*t141*t144*t149*t266*t270*t320-5.4484315542
     =           70369d-1*t141*t144*t155*t265*t320+1.6345294662811108d+0
     >           *t141*t149*t150*t155*t256*t320+t1467+t1466+t1465+t1464+
     ?           t1463+t1365+t1364+t1363+t1362+t1361+t1360+t1321+t1320+t
     @           1319+t1316+t1313)-3.109069086965489d-2*t139*t326*t518*t
     1           724+9.327207260896466d-2*t142*t253*t320*t724-3.10906908
     2           6965489d-2*t139*t346*t518*t561+9.327207260896466d-2*t14
     3           2*t253*t346*t544-9.327207260896466d-2*t142*t256*t326*t3
     4           46*t518-9.327207260896466d-2*t142*t271*t320*t346*t518+6
     5           .218138173930978d-2*t1055*t139*t271*t326*t346+1.8654414
     6           521792934d-1*t138*t253*t256*t320*t346)+t272*t771-1.5625
     7           d-2*t41*t42*t62*t770-1.5625d-2*rhoa*t216*t42*t62*t770+1
     8           .5625d-2*rhoa*t166*t41*t62*t770+1.5625d-2*rhob*t102*t16
     9           6*t62*t770+3.125d-2*rhoa*t125*t355*t359*t41*t770+3.125d
     :           -2*rhob*t102*t125*t355*t359*t770+t316*t725+t327*t714-1.
     ;           5625d-2*rhob*t315*t42*t62*t710-1.5625d-2*t102*t42*t62*t
     <           710+1.5625d-2*rhoa*t166*t41*t62*t710+1.5625d-2*rhob*t10
     =           2*t166*t62*t710+3.125d-2*rhoa*t125*t355*t359*t41*t710+3
     >           .125d-2*rhob*t102*t125*t355*t359*t710+3.265146623154200
     ?           3d-3*t179*t355*t359*t41*t47*t49*t50*t51*t649+3.26514662
     @           31542003d-3*rhob*t179*t315*t355*t359*t47*t49*t50*t51*t6
     1           49+3.2651466231542003d-3*rhoa*t179*t216*t355*t359*t47*t
     2           49*t50*t51*t649+3.2651466231542003d-3*t102*t179*t355*t3
     3           59*t47*t49*t50*t51*t649+1.6325733115771002d-3*t179*t41*
     4           t432*t47*t49*t50*t51*t62+1.6325733115771002d-3*rhob*t17
     5           9*t315*t432*t47*t49*t50*t51*t62+1.6325733115771002d-3*r
     6           hoa*t179*t216*t432*t47*t49*t50*t51*t62+1.63257331157710
     7           02d-3*t102*t179*t432*t47*t49*t50*t51*t62-1.5625d-2*rhoa
     8           *t1460*t41*t42*t62-1.5625d-2*rhob*t102*t1460*t42*t62-6.
     9           25d-2*rhoa*t166*t41*t537*t60*t61-6.25d-2*rhob*t102*t166
     :           *t537*t60*t61-6.25d-2*t166*t283*t41*t60*t61-6.25d-2*rho
     ;           b*t166*t183*t315*t60*t61-6.25d-2*rhoa*t166*t216*t283*t6
     <           0*t61-6.25d-2*t102*t166*t183*t60*t61+t344*t562+3.109069
     =           086965489d-2*t139*t253*t346*t540+t1458+t1457+t1456+t145
     >           5+t1454+t1453+t1452+t1451+t1357+t1353+t1352+t1351+t1350
     ?           +t1349+t1348+t1347+t1287+t1283+t1282+t1278+t1276+t1274+
     @           t1273+t1270
              t1480 = -6.562499999999999d-2*t163*t328*t355*t58*t61
              t1481 = -3.2812499999999994d-2*t166*t328*t60*t62
              t1482 = 1.3060586492616802d-2*t48*t53*t534-3.4828230646978
     1           14d-2*t176*t280*t53-3.482823064697814d-2*t175*t176*t53+
     2           1.3060586492616802d-2*t48*(4*t163*t43*t50+2*t171*t277)*
     3           t51-6.965646129395628d-2*t176*t277*t50*t51-6.9656461293
     4           95628d-2*t171*t176*t50*t51+2.6121172985233604d-2*t171*t
     5           280*t48*t50+2.6121172985233604d-2*t175*t277*t48*t50+t13
     6           88
              t1483 = -1.5672703791140163d+0*t178*t281*t47*t48*t51*t53*t
     1           947+2.0d+1*t178*t419*t47*t780-4.0d+0*t179*t182*t780+2.0
     2           d+1*t281*t419*t47*t738-4.0d+0*t179*t282*t738-5.22423459
     3           7046721d-2*t179*t48*t51*t53*t536+2.6121172985233604d-1*
     4           t419*t47*t48*t51*t53*t535+2.6121172985233604d-1*t178*t2
     5           82*t419*t48*t51*t53+2.6121172985233604d-1*t182*t281*t41
     6           9*t48*t51*t53-4.0d+0*t1482*t179*t47
              t1484 = t158*(-2.4488599673656505d-2*t178*t281*t47*t48*t51
     1           *t53*t62*t947+3.125d-1*t178*t419*t47*t62*t780-6.25d-2*t
     2           179*t182*t62*t780+1.25d-1*t163*t179*t355*t359*t47*t780+
     3           3.125d-1*t281*t419*t47*t62*t738-6.25d-2*t179*t282*t62*t
     4           738+1.25d-1*t163*t179*t355*t359*t47*t738-8.162866557885
     5           501d-3*t281*t355*t359*t419*t47*t51*t53*t673-8.162866557
     6           885501d-3*t178*t355*t359*t419*t47*t51*t53*t673+1.632573
     7           3115771002d-3*t179*t282*t355*t359*t51*t53*t673+1.632573
     8           3115771002d-3*t179*t182*t355*t359*t51*t53*t673-8.162866
     9           557885502d-4*t179*t48*t51*t53*t536*t62+4.08143327894275
     :           04d-3*t419*t47*t48*t51*t53*t535*t62+4.0814332789427504d
     ;           -3*t178*t282*t419*t48*t51*t53*t62+4.0814332789427504d-3
     <           *t182*t281*t419*t48*t51*t53*t62-6.25d-2*t1482*t179*t47*
     =           t62+t1429+t1428+t1427+t1426+t1425+t1424+t1423+t1422+t14
     >           21+t1393+t1305)+t272*t788+1.5625d-2*rhob*t166*t57*t62*t
     ?           787-1.5625d-2*rhob*t183*t42*t62*t787+3.125d-2*rhob*t125
     @           *t355*t359*t57*t787-1.5625d-2*t41*t42*t62*t781-1.5625d-
     1           2*rhoa*t216*t42*t62*t781+1.5625d-2*rhoa*t166*t41*t62*t7
     2           81+1.5625d-2*rhob*t102*t166*t62*t781+3.125d-2*rhoa*t125
     3           *t355*t359*t41*t781+3.125d-2*rhob*t102*t125*t355*t359*t
     4           781+t327*t743-1.5625d-2*rhob*t315*t42*t62*t739-1.5625d-
     5           2*t102*t42*t62*t739+1.5625d-2*rhoa*t166*t41*t62*t739+1.
     6           5625d-2*rhob*t102*t166*t62*t739+3.125d-2*rhoa*t125*t355
     7           *t359*t41*t739+3.125d-2*rhob*t102*t125*t355*t359*t739-1
     8           .6325733115771002d-3*t179*t355*t359*t41*t47*t51*t53*t64
     9           9-1.6325733115771002d-3*rhob*t179*t315*t355*t359*t47*t5
     :           1*t53*t649-1.6325733115771002d-3*rhoa*t179*t216*t355*t3
     ;           59*t47*t51*t53*t649-1.6325733115771002d-3*t102*t179*t35
     <           5*t359*t47*t51*t53*t649+2.4289602241917876d-4*t166*t304
     =           *t351*t57*t62-2.4289602241917876d-4*rhob*t304*t351*t42*
     >           t537*t62-8.162866557885502d-4*t179*t41*t432*t47*t51*t53
     ?           *t62-8.162866557885502d-4*rhob*t179*t315*t432*t47*t51*t
     @           53*t62-8.162866557885502d-4*rhoa*t179*t216*t432*t47*t51
     1           *t53*t62-8.162866557885502d-4*t102*t179*t432*t47*t51*t5
     2           3*t62-1.5625d-2*rhoa*t1483*t41*t42*t62-2.42896022419178
     3           76d-4*t183*t304*t351*t42*t62-1.5625d-2*rhob*t102*t1483*
     4           t42*t62+2.4289602241917876d-4*rhob*t166*t283*t304*t351*
     5           t62+2.4289602241917876d-4*rhob*t166*t183*t304*t351*t62+
     6           4.8579204483835753d-4*t125*t304*t351*t355*t359*t57+t352
     7           *t562+4.8579204483835753d-4*rhob*t125*t283*t304*t351*t3
     8           55*t359+4.8579204483835753d-4*rhob*t125*t183*t304*t351*
     9           t355*t359+t1444+t1432+t1431+t1430+t1418+t1417+t1416+t14
     :           15+t1414+t1413+t1412+t1411+t1410+t1409+t1408+t1407+t140
     ;           6+t1405+t1404+t1403+t1402+t1401+t1400+t1399+t1398+t1397
     <           +t1392+t1391+t1387+t1386+t1385+t1384+t1288+t1281+t1277+
     =           t1272
              t1485 = -3.125d-2*rhoa*t166*t41*t574*t60*t61
              t1486 = -6.25d-2*rhob*t166*t283*t315*t60*t61
              t1487 = -6.25d-2*t166*t315*t57*t60*t61
              t1488 = -3.125d-2*rhob*t166*t57*t60*t61*t623
              t1489 = -3.125d-2*rhob*t102*t166*t574*t60*t61
              t1490 = -6.25d-2*t102*t166*t283*t60*t61
              t1491 = 1.3060586492616802d-2*t48*t52*t571+1.3060586492616
     1           802d-2*t48*t51*(2*t569+2*t49*t566)-6.965646129395628d-2
     2           *t176*t280*t52-1.3931292258791256d-1*t176*t278*t49*t51+
     3           5.224234597046721d-2*t278*t280*t48*t49+t1291
              t1492 = -1.5672703791140163d+0*t47*t48*t51*t52*t565*t947+4
     1           .0d+1*t281*t419*t47*t752-8.0d+0*t179*t282*t752-5.224234
     2           597046721d-2*t179*t48*t51*t52*t573+2.6121172985233604d-
     3           1*t419*t47*t48*t51*t52*t572+5.224234597046721d-1*t281*t
     4           282*t419*t48*t51*t52-4.0d+0*t1491*t179*t47
              t1493 = 6.25d-1*t419*t42*t47*t565*t60*t61
              t1494 = -1.25d-1*t179*t42*t47*t572*t60*t61
              t1495 = -2.5d-1*t179*t281*t282*t42*t60*t61
              t1496 = 3.125d-2*t42*t56*t573*t60*t61
              t1497 = 3.109069086965489d-2*t139*t253*t339*t624
              t1498 = 2*t316*t763
              t1499 = 8.172647331405554d-1*t141*t147*t150*t628
              t1500 = -2.7242157771351844d-1*t141*t144*t147*t629
              t1501 = -1.3621078885675922d-1*t141*t143*t145*t262*t633
              t1502 = 5.448431554270369d-1*t141*t144*t145*t262*t320*t322
              t1503 = 2.7242157771351844d-1*t141*t143*t500*t501*t637
              t1504 = -1.3621078885675922d-1*t141*t143*t145*t262*t637
              t1505 = t159*(-6.218138173930978d-2*t139*t326*t518*t762+1.
     1           8654414521792934d-1*t142*t253*t320*t762+3.1090690869654
     2           89d-2*t139*t253*(5.448431554270369d-1*t141*t143*t149*t3
     3           25*t515*t58*t761-2.7242157771351844d-1*t141*t143*t266*t
     4           324*t58*t761+5.448431554270369d-1*t141*t144*t149*t266*t
     5           320*t58*t761+6.356503479982097d-1*t143*t149*t257*t258*t
     6           266*t58*t761-2.7242157771351844d-1*t141*t143*t266*t325*
     7           t58*t760-5.448431554270369d-1*t141*t144*t155*t320*t58*t
     8           760-6.356503479982097d-1*t143*t155*t257*t258*t58*t760+3
     9           .710675800196128d-2*t147*t150*t338*t515*t58*t642-8.1726
     :           47331405554d-1*t1054*t141*t143*t149*t337*t58*t642+2.724
     ;           2157771351844d-1*t141*t143*t149*t515*t642+2.72421577713
     <           51844d-1*t141*t143*t149*t337*t515*t58*t641-1.8553379000
     =           98064d-2*t147*t150*t266*t338*t58*t641-1.362107888567592
     >           2d-1*t141*t143*t149*t266*t641-1.3621078885675922d-1*t14
     ?           1*t143*t266*t337*t58*t640+1.3621078885675922d-1*t141*t1
     @           43*t155*t640-1.3621078885675922d-1*t141*t143*t149*t266*
     1           t58*(2.226405480117677d-1*t141*t150*t151*t500*t513*t637
     2           -7.421351600392256d-2*t141*t145*t150*t151*t269*t637-7.4
     3           21351600392256d-2*t141*t145*t150*t151*t269*t633-1.48427
     4           03200784513d-1*t141*t151*t153*t268*t629+7.4213516003922
     5           56d-1*t141*t151*t153*t511*t628+5.937081280313805d-1*t14
     6           1*t145*t151*t268*t269*t320*t322+t1504+t1503+t1502+t1501
     7           +t1500+t1499+t1478+t1477+t1473+t1470+t1334+t1333+t1326+
     8           t1325)-3.710675800196128d-2*t147*t155*t268*t338*t58*t62
     9           9+2.7242157771351844d-1*t141*t144*t149*t266*t337*t58*t6
     :           29-2.7242157771351844d-1*t141*t144*t149*t155*t629+1.113
     ;           2027400588386d-1*t147*t155*t338*t511*t58*t628-8.1726473
     <           31405554d-1*t141*t149*t150*t266*t337*t58*t628+8.1726473
     =           31405554d-1*t141*t149*t150*t155*t628+5.448431554270369d
     >           -1*t141*t143*t324*t325*t337*t515*t58-1.0896863108540737
     ?           d+0*t141*t144*t149*t320*t325*t337*t515*t58-1.2713006959
     @           964196d+0*t143*t149*t257*t258*t325*t337*t515*t58+7.4213
     1           51600392256d-2*t147*t266*t268*t320*t325*t338*t58+5.4484
     2           31554270369d-1*t141*t144*t266*t320*t324*t337*t58+6.3565
     3           03479982097d-1*t143*t257*t258*t266*t324*t337*t58-1.2713
     4           006959964196d+0*t144*t149*t257*t258*t266*t320*t337*t58+
     5           1.3621078885675922d-1*t141*t143*(t1504+t1503+t1502+t150
     6           1+t1500+t1499+t1473+t1470+t1326+t1325)*t155*t58-2.72421
     7           57771351844d-1*t141*t143*t266*t324*t325+5.4484315542703
     8           69d-1*t141*t144*t149*t266*t320*t325-5.448431554270369d-
     9           1*t141*t144*t155*t320*t324+t1467+t1466+t1465+t1464+t146
     :           3+t1318+t1317+t1315+t1314+t1312+t1311)+6.21813817393097
     ;           8d-2*t1055*t139*t339*t644-3.109069086965489d-2*t139*t33
     <           9*t518*t643+9.327207260896466d-2*t142*t253*t339*t629+1.
     =           8654414521792934d-1*t138*t253*t339*t628-1.8654414521792
     >           934d-1*t142*t320*t326*t339*t518)
              t1506 = t158*(-2.4488599673656505d-2*t47*t48*t51*t52*t565*
     1           t62*t947+6.25d-1*t281*t419*t47*t62*t752-1.25d-1*t179*t2
     2           82*t62*t752+2.5d-1*t163*t179*t355*t359*t47*t752-1.63257
     3           33115771002d-2*t281*t355*t359*t419*t47*t51*t52*t673+3.2
     4           651466231542003d-3*t179*t282*t355*t359*t51*t52*t673-8.1
     5           62866557885502d-4*t179*t48*t51*t52*t573*t62+4.081433278
     6           9427504d-3*t419*t47*t48*t51*t52*t572*t62+8.162866557885
     7           501d-3*t281*t282*t419*t48*t51*t52*t62-6.25d-2*t1491*t17
     8           9*t47*t62+t1496+t1495+t1494+t1493+t1462+t1461+t1305+t13
     9           02)+2*t327*t756-3.125d-2*rhob*t315*t42*t62*t753-3.125d-
     :           2*t102*t42*t62*t753+3.125d-2*rhoa*t166*t41*t62*t753+3.1
     ;           25d-2*rhob*t102*t166*t62*t753+6.25d-2*rhoa*t125*t355*t3
     <           59*t41*t753+6.25d-2*rhob*t102*t125*t355*t359*t753-3.265
     =           1466231542003d-3*rhob*t179*t315*t355*t359*t47*t51*t52*t
     >           649-3.2651466231542003d-3*t102*t179*t355*t359*t47*t51*t
     ?           52*t649+t336*t645+8.162866557885502d-4*rhob*t176*t179*t
     @           47*t51*t52*t62*t623-2.4289602241917876d-4*rhoa*t205*t33
     1           4*t42*t574*t62-1.6325733115771002d-3*rhob*t179*t315*t43
     2           2*t47*t51*t52*t62-1.6325733115771002d-3*t102*t179*t432*
     3           t47*t51*t52*t62+1.6325733115771002d-3*t176*t179*t315*t4
     4           7*t51*t52*t62-1.5625d-2*rhoa*t1492*t41*t42*t62-1.5625d-
     5           2*rhob*t102*t1492*t42*t62+4.8579204483835753d-4*rhoa*t1
     6           66*t205*t283*t334*t62+9.715840896767151d-4*rhoa*t125*t2
     7           05*t283*t334*t355*t359+t1505+t1498+t1497+t1490+t1489+t1
     8           488+t1487+t1486+t1485+t1458+t1457+t1456+t1455+t1454+t14
     9           53+t1452+t1451+t1301+t1294+t1290+t1288+t1281+t1277+t127
     :           5+t1272+t1271+t1269
              t1507 = 1.6406249999999997d-2*t42*t60*t62*t646
              t1508 = -6.965646129395628d-2*t176*t51*t768+2.612117298523
     1           3604d-2*t280*t48*t768-2.6121172985233604d-2*t48*t49*t50
     2           *t571+1.3060586492616802d-2*t48*t51*(-2.0d+0*t49*t567-2
     3           .0d+0*t50*t566-4.0d+0*t277*t278)+1.3931292258791256d-1*
     4           t176*t280*t49*t50+t1354
              t1509 = 3.1345407582280327d+0*t47*t48*t49*t50*t51*t565*t94
     1           7+4.0d+1*t281*t419*t47*t769-8.0d+0*t179*t282*t769+1.044
     2           8469194093442d-1*t179*t48*t49*t50*t51*t573-5.2242345970
     3           46721d-1*t419*t47*t48*t49*t50*t51*t572-1.04484691940934
     4           42d+0*t281*t282*t419*t48*t49*t50*t51-4.0d+0*t1508*t179*
     5           t47
              t1510 = 1.6345294662811108d+0*t141*t147*t150*t628
              t1511 = -5.448431554270369d-1*t141*t144*t147*t629
              t1512 = 2.542601391992839d+0*t144*t147*t257*t258*t320
              t1513 = -2.7242157771351844d-1*t141*t143*t145*t262*t633
              t1514 = 1.0896863108540737d+0*t141*t144*t145*t262*t320*t32
     1           2
              t1515 = 1.2713006959964196d+0*t143*t145*t257*t258*t262*t32
     1           2
              t1516 = 5.448431554270369d-1*t141*t143*t500*t501*t637
              t1517 = -2.7242157771351844d-1*t141*t143*t145*t262*t637
              t1518 = t158*(4.897719934731301d-2*t47*t48*t49*t50*t51*t56
     1           5*t62*t947+6.25d-1*t281*t419*t47*t62*t769-1.25d-1*t179*
     2           t282*t62*t769+2.5d-1*t163*t179*t355*t359*t47*t769+3.265
     3           1466231542003d-2*t281*t355*t359*t419*t47*t49*t50*t51*t6
     4           73-6.530293246308401d-3*t179*t282*t355*t359*t49*t50*t51
     5           *t673+1.6325733115771002d-3*t179*t48*t49*t50*t51*t573*t
     6           62-8.162866557885501d-3*t419*t47*t48*t49*t50*t51*t572*t
     7           62-1.6325733115771002d-2*t281*t282*t419*t48*t49*t50*t51
     8           *t62-6.25d-2*t1508*t179*t47*t62+6.25d-2*t42*t56*t573*t6
     9           0*t61-2.5d-1*t179*t42*t47*t572*t60*t61+1.25d+0*t419*t42
     :           *t47*t565*t60*t61-5.0d-1*t179*t281*t282*t42*t60*t61-2.5
     ;           d-1*t163*t282*t355*t56*t58+1.0d+0*t163*t179*t281*t355*t
     <           47*t58+t1359+t1358)+2*t316*t777+t159*(-6.21813817393097
     =           8d-2*t139*t326*t518*t776+1.8654414521792934d-1*t142*t25
     >           3*t320*t776+3.109069086965489d-2*t139*t253*(5.448431554
     ?           270369d-1*t141*t143*t149*t325*t515*t58*t775-2.724215777
     @           1351844d-1*t141*t143*t266*t324*t58*t775+5.4484315542703
     1           69d-1*t141*t144*t149*t266*t320*t58*t775+6.3565034799820
     2           97d-1*t143*t149*t257*t258*t266*t58*t775-2.7242157771351
     3           844d-1*t141*t143*t266*t325*t58*t774-5.448431554270369d-
     4           1*t141*t144*t155*t320*t58*t774-6.356503479982097d-1*t14
     5           3*t155*t257*t258*t58*t774+7.421351600392256d-2*t147*t15
     6           0*t338*t515*t58*t642-8.172647331405554d-1*t1054*t141*t1
     7           43*t149*t345*t58*t642+5.448431554270369d-1*t141*t143*t1
     8           49*t515*t642+2.7242157771351844d-1*t141*t143*t149*t345*
     9           t515*t58*t641-3.710675800196128d-2*t147*t150*t266*t338*
     :           t58*t641-2.7242157771351844d-1*t141*t143*t149*t266*t641
     ;           -1.3621078885675922d-1*t141*t143*t266*t345*t58*t640+2.7
     <           242157771351844d-1*t141*t143*t155*t640-1.36210788856759
     =           22d-1*t141*t143*t149*t266*t58*(4.452810960235354d-1*t14
     >           1*t150*t151*t500*t513*t637-1.4842703200784513d-1*t141*t
     ?           145*t150*t151*t269*t637-1.4842703200784513d-1*t141*t145
     @           *t150*t151*t269*t633-2.9685406401569026d-1*t141*t151*t1
     1           53*t268*t629+1.4842703200784513d+0*t141*t151*t153*t511*
     2           t628+1.3853189654065545d+0*t145*t150*t257*t269*t322*t50
     3           7*t58+2.770637930813109d+0*t153*t257*t268*t320*t507*t58
     4           +1.187416256062761d+0*t141*t145*t151*t268*t269*t320*t32
     5           2+t1517+t1516+t1515+t1514+t1513+t1512+t1511+t1510+t1377
     6           +t1376+t1370+t1369)+2.7242157771351844d-1*t141*t144*t14
     7           9*t266*t345*t58*t629-7.421351600392256d-2*t147*t155*t26
     8           8*t338*t58*t629-5.448431554270369d-1*t141*t144*t149*t15
     9           5*t629+2.2264054801176772d-1*t147*t155*t338*t511*t58*t6
     :           28-8.172647331405554d-1*t141*t149*t150*t266*t345*t58*t6
     ;           28+1.6345294662811108d+0*t141*t149*t150*t155*t628+5.448
     <           431554270369d-1*t141*t143*t324*t325*t345*t515*t58-1.089
     =           6863108540737d+0*t141*t144*t149*t320*t325*t345*t515*t58
     >           -1.2713006959964196d+0*t143*t149*t257*t258*t325*t345*t5
     ?           15*t58+1.7316487067581934d-1*t147*t150*t257*t266*t325*t
     @           507*t58+3.463297413516387d-1*t147*t155*t257*t268*t320*t
     1           507*t58+5.448431554270369d-1*t141*t144*t266*t320*t324*t
     2           345*t58+6.356503479982097d-1*t143*t257*t258*t266*t324*t
     3           345*t58-1.2713006959964196d+0*t144*t149*t257*t258*t266*
     4           t320*t345*t58+1.4842703200784513d-1*t147*t266*t268*t320
     5           *t325*t338*t58+1.3621078885675922d-1*t141*t143*(t1517+t
     6           1516+t1515+t1514+t1513+t1512+t1511+t1510+t1370+t1369)*t
     7           155*t58-5.448431554270369d-1*t141*t143*t266*t324*t325+1
     8           .0896863108540737d+0*t141*t144*t149*t266*t320*t325+1.27
     9           13006959964196d+0*t143*t149*t257*t258*t266*t325-1.08968
     :           63108540737d+0*t141*t144*t155*t320*t324-1.2713006959964
     ;           196d+0*t143*t155*t257*t258*t324+2.542601391992839d+0*t1
     <           44*t149*t155*t257*t258*t320+t1365+t1364+t1363+t1362+t13
     =           61+t1360)+6.218138173930978d-2*t1055*t139*t346*t644-3.1
     >           09069086965489d-2*t139*t346*t518*t643+9.327207260896466
     ?           d-2*t142*t253*t346*t629+1.8654414521792934d-1*t138*t253
     @           *t346*t628-1.8654414521792934d-1*t142*t320*t326*t346*t5
     1           18)+2*t327*t771-3.125d-2*rhob*t315*t42*t62*t770-3.125d-
     2           2*t102*t42*t62*t770+3.125d-2*rhoa*t166*t41*t62*t770+3.1
     3           25d-2*rhob*t102*t166*t62*t770+6.25d-2*rhoa*t125*t355*t3
     4           59*t41*t770+6.25d-2*rhob*t102*t125*t355*t359*t770+6.530
     5           293246308401d-3*rhob*t179*t315*t355*t359*t47*t49*t50*t5
     6           1*t649+6.530293246308401d-3*t102*t179*t355*t359*t47*t49
     7           *t50*t51*t649+t344*t645+3.109069086965489d-2*t139*t253*
     8           t346*t624-1.6325733115771002d-3*rhob*t176*t179*t47*t49*
     9           t50*t51*t62*t623-6.25d-2*rhob*t166*t57*t60*t61*t623+3.2
     :           651466231542003d-3*rhob*t179*t315*t432*t47*t49*t50*t51*
     ;           t62+3.2651466231542003d-3*t102*t179*t432*t47*t49*t50*t5
     <           1*t62-3.2651466231542003d-3*t176*t179*t315*t47*t49*t50*
     =           t51*t62-1.5625d-2*rhoa*t1509*t41*t42*t62-1.5625d-2*rhob
     >           *t102*t1509*t42*t62-6.25d-2*rhoa*t166*t41*t574*t60*t61-
     ?           6.25d-2*rhob*t102*t166*t574*t60*t61-1.25d-1*t166*t315*t
     @           57*t60*t61+1.25d-1*rhob*t163*t315*t57*t60*t61+1.25d-1*t
     1           102*t163*t57*t60*t61+1.25d-1*rhoa*t163*t283*t41*t60*t61
     2           -1.25d-1*rhob*t166*t283*t315*t60*t61-1.25d-1*t102*t166*
     3           t283*t60*t61+1.25d-1*rhob*t102*t163*t283*t60*t61+2.5d-1
     4           *rhob*t125*t315*t355*t57*t58+2.5d-1*t102*t125*t355*t57*
     5           t58+2.5d-1*rhoa*t125*t283*t355*t41*t58+2.5d-1*rhob*t102
     6           *t125*t283*t355*t58+t1357+t1353+t1352+t1351+t1350+t1349
     7           +t1348+t1347
              t1519 = 1.3060586492616802d-2*t48*t53*t571+1.3060586492616
     1           802d-2*t48*t51*(2*t568+2*t50*t567)-6.965646129395628d-2
     2           *t176*t280*t53-1.3931292258791256d-1*t176*t277*t50*t51+
     3           5.224234597046721d-2*t277*t280*t48*t50+t1388
              t1520 = -1.5672703791140163d+0*t47*t48*t51*t53*t565*t947+4
     1           .0d+1*t281*t419*t47*t780-8.0d+0*t179*t282*t780-5.224234
     2           597046721d-2*t179*t48*t51*t53*t573+2.6121172985233604d-
     3           1*t419*t47*t48*t51*t53*t572+5.224234597046721d-1*t281*t
     4           282*t419*t48*t51*t53-4.0d+0*t1519*t179*t47
              t1521 = 1.7894823267913484d+3*t603*t604*t605*t90
              t1522 = 1.765806054418543d+0*t350*t601*t93
              t1523 = -8.408600259135923d-2*t306*t602*t93
              t1524 = -6.490894881214397d+1*t303*t305*t306*t308*t91
              t1525 = -8.947411633956742d+2*t308*t603*t90*t91
              t1526 = 1.3909060459745137d+1*t308*t600*t90*t91
              t1527 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2
     1           *t304*(-2.1622114952063792d-1*gammabb*t311*t90*t95*(-7.
     2           272468855559613d-2*gammabb*t602*t616*t98+2.545364099445
     3           863d+0*gammabb*t601*t615*t98-7.738478514913824d+2*t312*
     4           t603*t90*t91*t96+1.2029732165432584d+1*t312*t600*t90*t9
     5           1*t96+2.3215435544741472d+3*t603*t604*t613*t90*t96-1.12
     6           27750021070412d+2*gammabb*t303*t305*t312*t616*t91+t1526
     7           +t1525+t1524+t1523+t1522+t1521)+8.648845980825517d-1*ga
     8           mmabb*t313*t618*t785*t90*t95+4.3244229904127585d-1*t618
     9           *t619*t90*t95-1.2973268971238278d+0*gammabb*t1235*t349*
     :           t619*t90*t95+4.3244229904127585d-1*gammabb*t349*t617*t6
     ;           18*t90*t95-2.1622114952063792d-1*t311*t617*t90*t95+1.00
     <           90320310963104d+0*gammabb*t305*t306*t311*t785*t95-2.018
     =           0640621926207d+0*gammabb*t305*t306*t313*t349*t618*t95+8
     >           .408600259135923d-2*gammabb*t306*t311*t349*t602*t95-8.4
     ?           08600259135923d-2*t100*t306*t602*t95-1.765806054418543d
     @           +0*gammabb*t311*t349*t350*t601*t95+1.765806054418543d+0
     1           *t100*t350*t601*t95+1.0090320310963104d+0*t305*t306*t31
     2           1*t313*t95+9.350317100005212d-2*gammabb*t350*t618*t619*
     3           t93-4.675158550002606d-2*gammabb*t311*t350*t617*t93-1.8
     4           181172138899032d-2*gammabb*t100*t602*t616*t93+2.1817406
     5           56667883d-1*gammabb*t305*t311*t313*t616*t93+3.818046149
     6           168795d-1*gammabb*t100*t601*t615*t93-4.3244229904127585
     7           d-1*gammabb*t310*t311*t785*t90-4.3244229904127585d-1*ga
     8           mmabb*t311*t313*t784*t90+8.648845980825517d-1*gammabb*t
     9           310*t313*t349*t618*t90-2.1622114952063792d-1*gammabb*t3
     :           11*t349*t612*t90+2.1622114952063792d-1*t100*t612*t90-4.
     ;           3244229904127585d-1*t310*t311*t313*t90+2.16221149520637
     <           92d-1*gammabb*t100*(t1526+t1525+t1524+t1523+t1522+t1521
     =           )*t90-1.0090320310963104d+0*gammabb*t100*t305*t306*t784
     >           +1.0090320310963104d+0*gammabb*t305*t306*t310*t311*t349
     ?           -1.0090320310963104d+0*t100*t305*t306*t310)-3.109069086
     @           9654886d-2*t314*t621*t786+3.1090690869654886d-2*t1236*t
     1           351*t622-1.5545345434827443d-2*t351*t620*t621)+t158*(-2
     2           .4488599673656505d-2*t47*t48*t51*t53*t565*t62*t947+6.25
     3           d-1*t281*t419*t47*t62*t780-1.25d-1*t179*t282*t62*t780+2
     4           .5d-1*t163*t179*t355*t359*t47*t780-1.6325733115771002d-
     5           2*t281*t355*t359*t419*t47*t51*t53*t673+3.26514662315420
     6           03d-3*t179*t282*t355*t359*t51*t53*t673-8.16286655788550
     7           2d-4*t179*t48*t51*t53*t573*t62+4.0814332789427504d-3*t4
     8           19*t47*t48*t51*t53*t572*t62+8.162866557885501d-3*t281*t
     9           282*t419*t48*t51*t53*t62-6.25d-2*t1519*t179*t47*t62+t14
     :           96+t1495+t1494+t1493+t1462+t1461+t1393+t1305)+2*t327*t7
     ;           88-3.125d-2*t42*t57*t62*t787+3.125d-2*rhob*t166*t57*t62
     <           *t787-3.125d-2*rhob*t283*t42*t62*t787+6.25d-2*rhob*t125
     =           *t355*t359*t57*t787-3.125d-2*rhob*t315*t42*t62*t781-3.1
     >           25d-2*t102*t42*t62*t781+3.125d-2*rhoa*t166*t41*t62*t781
     ?           +3.125d-2*rhob*t102*t166*t62*t781+6.25d-2*rhoa*t125*t35
     @           5*t359*t41*t781+6.25d-2*rhob*t102*t125*t355*t359*t781-3
     1           .2651466231542003d-3*rhob*t179*t315*t355*t359*t47*t51*t
     2           53*t649-3.2651466231542003d-3*t102*t179*t355*t359*t47*t
     3           51*t53*t649+t352*t645+8.162866557885502d-4*rhob*t176*t1
     4           79*t47*t51*t53*t62*t623-2.4289602241917876d-4*rhob*t304
     5           *t351*t42*t574*t62+4.8579204483835753d-4*t166*t304*t351
     6           *t57*t62-1.6325733115771002d-3*rhob*t179*t315*t432*t47*
     7           t51*t53*t62-1.6325733115771002d-3*t102*t179*t432*t47*t5
     8           1*t53*t62+1.6325733115771002d-3*t176*t179*t315*t47*t51*
     9           t53*t62-1.5625d-2*rhoa*t1520*t41*t42*t62-4.857920448383
     :           5753d-4*t283*t304*t351*t42*t62-1.5625d-2*rhob*t102*t152
     ;           0*t42*t62+4.8579204483835753d-4*rhob*t166*t283*t304*t35
     <           1*t62+9.715840896767151d-4*t125*t304*t351*t355*t359*t57
     =           +9.715840896767151d-4*rhob*t125*t283*t304*t351*t355*t35
     >           9+t1505+t1498+t1497+t1490+t1489+t1488+t1487+t1486+t1485
     ?           +t1458+t1457+t1456+t1455+t1454+t1453+t1452+t1451+t1392+
     @           t1391+t1387+t1386+t1385+t1384+t1288+t1281+t1277+t1272
              t1528 = -1.6406249999999997d-2*t166*t58*t60*t62*t813
              t1529 = -3.2812499999999994d-2*t125*t341*t359*t856
              t1530 = -3.2812499999999994d-2*t163*t341*t355*t58*t61
              t1531 = -3.2812499999999994d-2*t166*t341*t60*t62
              t1532 = 3.2812499999999994d-2*t42*t60*t62*t692
              t1533 = 1/t1**9.333333333333333d+0
              t1534 = 1.066118247069528d-4*rhoa*t1533*t355*t359*t41*t419
     1           *t47*t797*t798
              t1535 = -5.075783215229239d-5*rhoa*t179*t205*t334*t355*t35
     1           9*t47*t51*t52*t649
              t1536 = -8.162866557885501d-3*rhoa*t179*t355*t41*t47*t51*t
     1           52*t58*t649
              t1537 = -3.125d-2*rhoa*t163*t183*t355*t41
              t1538 = -4.8579204483835753d-4*rhoa*t125*t355*t359*t415*t5
     1           7*t799
              t1539 = 4.8579204483835753d-4*rhoa*t125*t205*t355*t359*t57
     1           *t801
              t1540 = 2.428960224191788d-3*rhoa*t125*t205*t334*t355*t57*
     1           t58
              t1541 = 9.375d-2*rhoa*t125*t355*t41*t57
              t1542 = -3.125d-2*rhoa*t163*t216*t355*t57
              t1543 = -3.125d-2*t163*t355*t41*t57
              t1544 = 1.066118247069528d-4*rhob*t102*t1533*t355*t359*t41
     1           9*t47*t797*t798
              t1545 = -8.162866557885501d-3*rhob*t102*t179*t355*t47*t51*
     1           t52*t58*t649
              t1546 = -3.125d-2*rhob*t102*t163*t183*t355
              t1547 = 9.375d-2*rhob*t102*t125*t355*t57
              t1548 = -1.6325733115771002d-3*rhoa*t179*t41*t47*t51*t52*t
     1           60*t61*t673
              t1549 = 1.6325733115771002d-3*rhoa*t179*t216*t432*t47*t51*
     1           t52*t60*t61
              t1550 = 1.6325733115771002d-3*t179*t41*t432*t47*t51*t52*t6
     1           0*t61
              t1551 = -3.125d-2*rhoa*t166*t41*t60*t61*t664
              t1552 = -4.8579204483835753d-4*rhoa*t166*t183*t205*t334*t6
     1           0*t61
              t1553 = 4.8579204483835753d-4*rhoa*t163*t205*t334*t57*t60*
     1           t61
              t1554 = -4.8579204483835753d-4*t166*t205*t334*t57*t60*t61
              t1555 = -3.125d-2*rhoa*t166*t57*t60*t61*t671
              t1556 = -1.6325733115771002d-3*rhob*t102*t179*t47*t51*t52*
     1           t60*t61*t673
              t1557 = -3.125d-2*rhob*t102*t166*t60*t61*t664
              t1558 = 1/t1**7.333333333333333d+0
              t1559 = 5.330591235347639d-5*rhoa*t1558*t41*t419*t47*t62*t
     1           797*t798
              t1560 = -2.0469470343734936d-2*t178*t47*t797*t798*t804*t94
     1           7+3.4115783906224895d-3*t182*t419*t797*t798*t804+5.2242
     2           34597046721d-1*t419*t47*t48*t51*t52*t663
              t1561 = -2.5378916076146196d-5*rhoa*t179*t205*t334*t432*t4
     1           7*t51*t52*t62
              t1562 = -2.4289602241917876d-4*rhoa*t166*t415*t57*t62*t799
              t1563 = 2.4289602241917876d-4*rhoa*t166*t205*t57*t62*t801
              t1564 = 5.330591235347639d-5*rhob*t102*t1558*t419*t47*t62*
     1           t797*t798
              t1565 = 1/t1**8.333333333333334d+0
              t1566 = -1.066118247069528d-4*t1565*t355*t359*t419*t47*t79
     1           7*t798
              t1567 = 6.530293246308401d-3*t179*t355*t47*t51*t52*t58*t67
     1           3
              t1568 = -1.25d-1*t166*t178*t179*t355*t47
              t1569 = 3.125d-2*t166*t182*t355*t56
              t1570 = -6.25d-2*t163*t355*t47*t56
              t1571 = 8.162866557885501d-3*t176*t178*t419*t47*t51*t52*t6
     1           0*t61
              t1572 = -1.6325733115771002d-3*t176*t179*t182*t51*t52*t60*
     1           t61
              t1573 = -1.25d-1*t179*t42*t47*t60*t61*t663
              t1574 = -3.109069086965489d-2*t139*t219*t518*t806
              t1575 = 3.109069086965489d-2*t139*t219*t253*t811
              t1576 = -6.356503479982097d-1*t143*t149*t257*t258*t515*t58
     1           *t808
              t1577 = 5.448431554270369d-1*t141*t144*t149*t256*t266*t337
              t1578 = 6.356503479982097d-1*t143*t149*t257*t258*t266*t337
              t1579 = 1.1793461818516023d-2*t1043*t149*t153*t257*t266*t5
     1           11*t58
              t1580 = 7.421351600392256d-2*t147*t256*t266*t268*t337*t338
     1           *t58
              t1581 = 8.658243533790967d-2*t147*t150*t257*t266*t337*t507
     1           *t58
              t1582 = -8.658243533790967d-2*t147*t150*t155*t257*t507
              t1583 = -1.7316487067581932d-1*t150*t153*t257*t507
              t1584 = 2.7242157771351844d-1*t141*t143*t155*t686
              t1585 = -2.7242157771351844d-1*t141*t143*t149*t266*t688
              t1586 = -3.710675800196128d-2*t147*t150*t266*t338*t58*t688
              t1587 = -2.7242157771351844d-1*t141*t143*t265*t266*t337
              t1588 = 5.448431554270369d-1*t141*t143*t149*t270*t337*t515
              t1589 = 7.421351600392256d-2*t147*t150*t270*t337*t338*t515
     1           *t58
              t1590 = t159*(-3.109069086965489d-2*t139*t271*t518*t811+9.
     1           327207260896466d-2*t142*t253*t256*t811+3.10906908696548
     2           9d-2*t139*t253*(2.7242157771351844d-1*t141*t143*t265*t5
     3           15*t58*t808-5.448431554270369d-1*t141*t144*t149*t256*t5
     4           15*t58*t808-8.172647331405554d-1*t1054*t141*t143*t149*t
     5           270*t58*t808+5.448431554270369d-1*t141*t143*t149*t337*t
     6           515*t58*t688-2.7242157771351844d-1*t141*t143*t266*t337*
     7           t58*t686+1.0108681558728018d-2*t149*t153*t270*t508*t511
     8           *t515*t58-5.054340779364009d-3*t153*t265*t266*t508*t511
     9           *t58+1.0108681558728018d-2*t1047*t149*t153*t256*t266*t5
     :           08*t58-1.3621078885675922d-1*t141*t143*t149*t266*(-7.42
     ;           1351600392256d-2*t145*t150*t263*t269*t338-1.48427032007
     <           84513d-1*t153*t256*t268*t338+t1583)*t58-3.7106758001961
     =           28d-2*t147*t150*t266*t270*t338-7.421351600392256d-2*t14
     >           7*t155*t256*t268*t338+t1589+t1588+t1587+t1586+t1585+t15
     ?           84+t1582+t1581+t1580+t1579+t1578+t1577+t1576)-9.3272072
     @           60896466d-2*t142*t256*t518*t806+6.218138173930978d-2*t1
     1           055*t139*t271*t806-6.218138173930978d-2*t139*t339*t518*
     2           t689)
              t1591 = t158*(-3.198354741208584d-4*t178*t47*t62*t797*t798
     1           *t804*t947+5.330591235347639d-5*t182*t419*t62*t797*t798
     2           *t804+8.162866557885501d-3*t419*t47*t48*t51*t52*t62*t66
     3           3-1.25d-1*t166*t179*t355*t47*t58*t663+8.162866557885501
     4           d-3*t178*t355*t419*t432*t47*t51*t52*t58-1.6325733115771
     5           002d-3*t179*t182*t355*t432*t51*t52*t58+t1573+t1572+t157
     6           1+t1570+t1569+t1568+t1567+t1566)-1.5625d-2*rhoa*t42*t57
     7           *t62*(3.1090690869654886d-2*t215*t799*t945+1.5545345434
     8           827443d-2*t205*(-1.2973268971238278d+0*gammaaa*t214*t29
     9           *t34*t800*t944+4.7173847274064107d-2*gammaaa*t206*t212*
     :           t34*t37*t943-1.0090320310963104d+0*gammaaa*t206*t207*t3
     ;           4*t412*t800+4.3244229904127585d-1*gammaaa*t211*t29*t412
     <           *t800+8.648845980825517d-1*gammaaa*t29*t332*t34*t412*t6
     =           69-4.3244229904127585d-1*t212*t29*t34*t669-9.3503171000
     >           05212d-2*gammaaa*t212*t32*t333*t669+4.3244229904127585d
     ?           -1*t29*t39*t668-4.3244229904127585d-1*gammaaa*t212*t29*
     @           t332*t668+4.0434726234912094d-2*gammaaa*t214*t34*t37*t4
     1           09*t412+8.648845980825517d-1*t214*t29*t332*t34*t412+1.8
     2           700634200010424d-1*gammaaa*t214*t32*t332*t333*t412-2.16
     3           22114952063792d-1*gammaaa*t212*t29*t34*(1.2029732165432
     4           584d+1*t204*t213*t30*t333-4.363481313335766d-1*t206*t37
     5           *t410)-2.181740656667883d-1*t206*t32*t39*t410+2.1817406
     6           56667883d-1*gammaaa*t206*t212*t32*t332*t410-2.021736311
     7           7456047d-2*gammaaa*t211*t212*t37*t409+1.009032031096310
     8           4d+0*t206*t207*t212*t332*t34-9.350317100005212d-2*t212*
     9           t214*t32*t333-4.3244229904127585d-1*t211*t212*t29*t332)
     :           -1.5545345434827443d-2*t215*t415*t801-3.109069086965488
     ;           6d-2*t334*t415*t670)+t272*t805-2.4289602241917876d-4*t2
     <           05*t42*t57*t62*t801-2.4289602241917876d-4*rhoa*t183*t20
     =           5*t42*t62*t801+2.4289602241917876d-4*t415*t42*t57*t62*t
     >           799+2.4289602241917876d-4*rhoa*t183*t415*t42*t62*t799-5
     ?           .330591235347639d-5*t41*t419*t47*t62*t796*t797*t798-5.3
     @           30591235347639d-5*rhoa*t216*t419*t47*t62*t796*t797*t798
     1           +2*t336*t690+6.218138173930978d-2*t139*t253*t339*t678+1
     2           .6325733115771002d-3*t179*t355*t41*t47*t51*t52*t58*t673
     3           +1.6325733115771002d-3*rhoa*t179*t216*t355*t47*t51*t52*
     4           t58*t673+1.6325733115771002d-3*rhoa*t176*t179*t47*t51*t
     5           52*t62*t671-3.125d-2*rhoa*t163*t355*t57*t58*t671-4.8579
     6           204483835753d-4*rhoa*t205*t334*t42*t62*t664-3.125d-2*rh
     7           oa*t163*t355*t41*t58*t664-3.125d-2*rhob*t102*t163*t355*
     8           t58*t664+2.5378916076146196d-5*t176*t179*t205*t334*t47*
     9           t51*t52*t62-1.5625d-2*rhoa*t1560*t41*t42*t62-1.5625d-2*
     :           rhob*t102*t1560*t42*t62-4.8579204483835753d-4*t163*t205
     ;           *t334*t355*t57*t58-4.8579204483835753d-4*rhoa*t163*t183
     <           *t205*t334*t355*t58+t1590+t1575+t1574+t1564+t1563+t1562
     =           +t1561+t1559+t1557+t1556+t1555+t1554+t1553+t1552+t1551+
     >           t1550+t1549+t1548+t1547+t1546+t1545+t1544+t1543+t1542+t
     ?           1541+t1540+t1539+t1538+t1537+t1536+t1535+t1534
              t1592 = 3.2812499999999994d-2*t166*t273*t355*t61
              t1593 = -6.562499999999999d-2*t125*t160*t58*t856
              t1594 = -3.2812499999999994d-2*t160*t163*t355*t61
              t1595 = 1.0d+0*t160*t816*wght
              t1596 = 2.0d+0*t341*t343*wght
              t1597 = 1.0d+0*t162*t813*wght
              t1598 = -6.562499999999999d-2*t163*t341*t355*t58*t61
              t1599 = -3.2812499999999994d-2*t125*t347*t359*t856
              t1600 = -1.6406249999999997d-2*t166*t347*t60*t62
              t1601 = -1.6406249999999997d-2*t166*t58*t60*t62*t827
              t1602 = 1.6406249999999997d-2*t42*t60*t62*t726
              t1603 = -2.132236494139056d-4*rhoa*t1533*t355*t359*t41*t41
     1           9*t47*t50*t798*t820
              t1604 = 5.075783215229239d-5*rhoa*t179*t205*t334*t355*t359
     1           *t47*t49*t50*t51*t649
              t1605 = 9.795439869462602d-3*rhoa*t179*t355*t41*t47*t49*t5
     1           0*t51*t58*t649
              t1606 = -6.530293246308401d-3*rhoa*t179*t355*t41*t47*t51*t
     1           52*t58*t649
              t1607 = -6.25d-2*rhoa*t163*t183*t355*t41
              t1608 = 1.9431681793534303d-3*rhoa*t125*t205*t334*t355*t57
     1           *t58
              t1609 = 1.875d-1*rhoa*t125*t355*t41*t57
              t1610 = -6.25d-2*rhoa*t163*t216*t355*t57
              t1611 = -6.25d-2*t163*t355*t41*t57
              t1612 = -2.132236494139056d-4*rhob*t102*t1533*t355*t359*t4
     1           19*t47*t50*t798*t820
              t1613 = 9.795439869462602d-3*rhob*t102*t179*t355*t47*t49*t
     1           50*t51*t58*t649
              t1614 = -6.530293246308401d-3*rhob*t102*t179*t355*t47*t51*
     1           t52*t58*t649
              t1615 = -6.25d-2*rhob*t102*t163*t183*t355
              t1616 = 1.875d-1*rhob*t102*t125*t355*t57
              t1617 = -3.2651466231542003d-3*rhoa*t179*t41*t47*t51*t52*t
     1           60*t61*t673
              t1618 = 9.715840896767151d-4*rhoa*t163*t205*t334*t57*t60*t
     1           61
              t1619 = -3.2651466231542003d-3*rhob*t102*t179*t47*t51*t52*
     1           t60*t61*t673
              t1620 = -1.066118247069528d-4*rhoa*t1558*t41*t419*t47*t50*
     1           t62*t798*t820
              t1621 = 4.093894068746987d-2*t178*t47*t50*t798*t804*t820*t
     1           947-6.823156781244979d-3*t182*t419*t50*t798*t804*t820+2
     2           .6121172985233604d-1*t419*t47*t48*t51*t52*t709-5.224234
     3           597046721d-1*t419*t47*t48*t49*t50*t51*t663
              t1622 = 2.5378916076146196d-5*rhoa*t179*t205*t334*t432*t47
     1           *t49*t50*t51*t62
              t1623 = -1.066118247069528d-4*rhob*t102*t1558*t419*t47*t50
     1           *t62*t798*t820
              t1624 = 2.132236494139056d-4*t1565*t355*t359*t419*t47*t50*
     1           t798*t820
              t1625 = -6.530293246308401d-3*t179*t355*t47*t49*t50*t51*t5
     1           8*t673
              t1626 = -2.5d-1*t166*t178*t179*t355*t47
              t1627 = 6.25d-2*t166*t182*t355*t56
              t1628 = -1.25d-1*t163*t355*t47*t56
              t1629 = t344*t690
              t1630 = 3.109069086965489d-2*t139*t253*t339*t714
              t1631 = 3.109069086965489d-2*t139*t219*t253*t824
              t1632 = -3.109069086965489d-2*t139*t219*t339*t346*t518
              t1633 = -6.356503479982097d-1*t143*t149*t257*t258*t337*t34
     1           5*t515*t58
              t1634 = 3.1782517399910487d-1*t143*t149*t257*t258*t266*t34
     1           5
              t1635 = 2.3586923637032045d-2*t1043*t149*t153*t257*t266*t5
     1           11*t58
              t1636 = 4.3291217668954834d-2*t147*t150*t257*t266*t345*t50
     1           7*t58
              t1637 = -1.7316487067581934d-1*t147*t150*t155*t257*t507
              t1638 = -3.4632974135163863d-1*t150*t153*t257*t507
              t1639 = t159*(-3.109069086965489d-2*t139*t271*t518*t824+9.
     1           327207260896466d-2*t142*t253*t256*t824-3.10906908696548
     2           9d-2*t139*t339*t518*t724+3.109069086965489d-2*t139*t253
     3           *(2.7242157771351844d-1*t141*t143*t149*t337*t515*t58*t7
     4           23-1.855337900098064d-2*t147*t150*t266*t338*t58*t723-1.
     5           3621078885675922d-1*t141*t143*t149*t266*t723-1.36210788
     6           85675922d-1*t141*t143*t266*t337*t58*t721+1.362107888567
     7           5922d-1*t141*t143*t155*t721+2.7242157771351844d-1*t141*
     8           t143*t149*t345*t515*t58*t688-1.3621078885675922d-1*t141
     9           *t143*t266*t345*t58*t686+2.0217363117456036d-2*t149*t15
     :           3*t270*t508*t511*t515*t58+3.710675800196128d-2*t147*t15
     ;           0*t270*t338*t345*t515*t58+2.7242157771351844d-1*t141*t1
     <           43*t265*t337*t345*t515*t58-5.448431554270369d-1*t141*t1
     =           44*t149*t256*t337*t345*t515*t58-1.0108681558728018d-2*t
     >           153*t265*t266*t508*t511*t58+2.0217363117456036d-2*t1047
     ?           *t149*t153*t256*t266*t508*t58+3.710675800196128d-2*t147
     @           *t256*t266*t268*t338*t345*t58-8.172647331405554d-1*t105
     1           4*t141*t143*t149*t270*t337*t345*t58-1.3621078885675922d
     2           -1*t141*t143*t149*t266*(-1.4842703200784513d-1*t145*t15
     3           0*t263*t269*t338-2.9685406401569026d-1*t153*t256*t268*t
     4           338+t1638)*t58+2.7242157771351844d-1*t141*t143*t149*t27
     5           0*t345*t515-1.3621078885675922d-1*t141*t143*t265*t266*t
     6           345+2.7242157771351844d-1*t141*t144*t149*t256*t266*t345
     7           -7.421351600392256d-2*t147*t150*t266*t270*t338-1.484270
     8           3200784513d-1*t147*t155*t256*t268*t338+t1637+t1636+t163
     9           5+t1634+t1633+t1589+t1588+t1587+t1586+t1585+t1584+t1581
     :           +t1580+t1578+t1577)-3.109069086965489d-2*t139*t346*t518
     ;           *t689-9.327207260896466d-2*t142*t256*t339*t346*t518+6.2
     <           18138173930978d-2*t1055*t139*t271*t339*t346)
              t1640 = t158*(6.396709482417168d-4*t178*t47*t50*t62*t798*t
     1           804*t820*t947-1.066118247069528d-4*t182*t419*t50*t62*t7
     2           98*t804*t820+4.0814332789427504d-3*t419*t47*t48*t51*t52
     3           *t62*t709-1.25d-1*t166*t179*t355*t47*t58*t709-8.1628665
     4           57885501d-3*t419*t47*t48*t49*t50*t51*t62*t663-2.5d-1*t1
     5           79*t42*t47*t60*t61*t663+1.6325733115771002d-2*t176*t178
     6           *t419*t47*t51*t52*t60*t61-3.2651466231542003d-3*t176*t1
     7           79*t182*t51*t52*t60*t61-1.6325733115771002d-2*t178*t355
     8           *t419*t432*t47*t49*t50*t51*t58+3.2651466231542003d-3*t1
     9           79*t182*t355*t432*t49*t50*t51*t58+t1628+t1627+t1626+t16
     :           25+t1624+t1567)+t272*t822+1.066118247069528d-4*t41*t419
     ;           *t47*t50*t62*t796*t798*t820+1.066118247069528d-4*rhoa*t
     <           216*t419*t47*t50*t62*t796*t798*t820+t336*t725-2.4289602
     =           241917876d-4*rhoa*t205*t334*t42*t62*t710-3.125d-2*rhoa*
     >           t163*t355*t41*t58*t710-3.125d-2*rhob*t102*t163*t355*t58
     ?           *t710+3.109069086965489d-2*t139*t253*t346*t678-3.265146
     @           6231542003d-3*t179*t355*t41*t47*t49*t50*t51*t58*t673-3.
     1           2651466231542003d-3*rhoa*t179*t216*t355*t47*t49*t50*t51
     2           *t58*t673-1.6325733115771002d-3*rhoa*t176*t179*t47*t49*
     3           t50*t51*t62*t671-6.25d-2*rhoa*t166*t57*t60*t61*t671-6.2
     4           5d-2*rhoa*t166*t41*t60*t61*t664-6.25d-2*rhob*t102*t166*
     5           t60*t61*t664-2.5378916076146196d-5*t176*t179*t205*t334*
     6           t47*t49*t50*t51*t62-1.5625d-2*rhoa*t1621*t41*t42*t62-1.
     7           5625d-2*rhob*t102*t1621*t42*t62-9.715840896767151d-4*t1
     8           66*t205*t334*t57*t60*t61+3.2651466231542003d-3*t179*t41
     9           *t432*t47*t51*t52*t60*t61+3.2651466231542003d-3*rhoa*t1
     :           79*t216*t432*t47*t51*t52*t60*t61-9.715840896767151d-4*r
     ;           hoa*t166*t183*t205*t334*t60*t61+t1639+t1632+t1631+t1630
     <           +t1629+t1623+t1622+t1620+t1619+t1618+t1617+t1616+t1615+
     =           t1614+t1613+t1612+t1611+t1610+t1609+t1608+t1607+t1606+t
     >           1605+t1604+t1603
              t1641 = 6.562499999999999d-2*t166*t273*t355*t61
              t1642 = -1.3124999999999998d-1*t125*t160*t58*t856
              t1643 = -6.562499999999999d-2*t160*t163*t355*t61
              t1644 = 1.0d+0*t160*t829*wght
              t1645 = 1.0d+0*t343*t347*wght
              t1646 = 1.0d+0*t341*t348*wght
              t1647 = 1.0d+0*t162*t827*wght
              t1648 = -1.6406249999999997d-2*t166*t58*t60*t62*t835
              t1649 = -1.6406249999999997d-2*t166*t341*t60*t62
              t1650 = -3.2812499999999994d-2*t125*t353*t359*t856
              t1651 = -1.6406249999999997d-2*t166*t353*t60*t62
              t1652 = 1.066118247069528d-4*rhoa*t1533*t355*t359*t41*t419
     1           *t47*t52*t53*t798
              t1653 = -3.2651466231542003d-3*rhoa*t179*t355*t41*t47*t51*
     1           t52*t58*t649
              t1654 = -2.5378916076146196d-5*rhoa*t179*t205*t334*t355*t3
     1           59*t47*t51*t53*t649
              t1655 = -4.897719934731301d-3*rhoa*t179*t355*t41*t47*t51*t
     1           53*t58*t649
              t1656 = 1.6325733115771002d-3*rhoa*t179*t216*t355*t47*t51*
     1           t53*t58*t673
              t1657 = 1.6325733115771002d-3*t179*t355*t41*t47*t51*t53*t5
     1           8*t673
              t1658 = -3.125d-2*rhoa*t163*t355*t41*t58*t739
              t1659 = 9.715840896767151d-4*rhoa*t125*t205*t334*t355*t57*
     1           t58
              t1660 = -2.5378916076146196d-5*rhob*t179*t304*t351*t355*t3
     1           59*t47*t51*t52*t649
              t1661 = -4.8579204483835753d-4*rhob*t163*t183*t304*t351*t3
     1           55*t58
              t1662 = 1.4573761345150726d-3*rhob*t125*t304*t351*t355*t57
     1           *t58
              t1663 = 1.066118247069528d-4*rhob*t102*t1533*t355*t359*t41
     1           9*t47*t52*t53*t798
              t1664 = -3.2651466231542003d-3*rhob*t102*t179*t355*t47*t51
     1           *t52*t58*t649
              t1665 = -4.897719934731301d-3*rhob*t102*t179*t355*t47*t51*
     1           t53*t58*t649
              t1666 = -3.125d-2*rhob*t102*t163*t355*t58*t739
              t1667 = 5.330591235347639d-5*rhoa*t1558*t41*t419*t47*t52*t
     1           53*t62*t798
              t1668 = -2.0469470343734936d-2*t178*t47*t52*t53*t798*t804*
     1           t947+3.4115783906224895d-3*t182*t419*t52*t53*t798*t804+
     2           2.6121172985233604d-1*t419*t47*t48*t51*t52*t738+2.61211
     3           72985233604d-1*t419*t47*t48*t51*t53*t663
              t1669 = -1.2689458038073098d-5*rhoa*t179*t205*t334*t432*t4
     1           7*t51*t53*t62
              t1670 = -1.2689458038073098d-5*rhob*t179*t304*t351*t432*t4
     1           7*t51*t52*t62
              t1671 = 5.330591235347639d-5*rhob*t102*t1558*t419*t47*t52*
     1           t53*t62*t798
              t1672 = 8.162866557885501d-3*t178*t355*t419*t432*t47*t51*t
     1           53*t58
              t1673 = -1.066118247069528d-4*t1565*t355*t359*t419*t47*t52
     1           *t53*t798
              t1674 = -1.6325733115771002d-3*t179*t182*t355*t432*t51*t53
     1           *t58
              t1675 = 3.2651466231542003d-3*t179*t355*t47*t51*t52*t58*t6
     1           73
              t1676 = 3.2651466231542003d-3*t179*t355*t47*t51*t53*t58*t6
     1           73
              t1677 = -1.25d-1*t166*t179*t355*t47*t58*t738
              t1678 = t158*(-3.198354741208584d-4*t178*t47*t52*t53*t62*t
     1           798*t804*t947+5.330591235347639d-5*t182*t419*t52*t53*t6
     2           2*t798*t804+4.0814332789427504d-3*t419*t47*t48*t51*t52*
     3           t62*t738+4.0814332789427504d-3*t419*t47*t48*t51*t53*t62
     4           *t663+t1677+t1676+t1675+t1674+t1673+t1672+t1573+t1572+t
     5           1571+t1570+t1569+t1568)+t272*t834-5.330591235347639d-5*
     6           t41*t419*t47*t52*t53*t62*t796*t798-5.330591235347639d-5
     7           *rhoa*t216*t419*t47*t52*t53*t62*t796*t798+3.10906908696
     8           5489d-2*t139*t253*t339*t743-2.4289602241917876d-4*rhoa*
     9           t205*t334*t42*t62*t739+t352*t690+t336*t690+3.1090690869
     :           65489d-2*t139*t253*t339*t678+8.162866557885502d-4*rhoa*
     ;           t176*t179*t47*t51*t53*t62*t671-2.4289602241917876d-4*rh
     <           ob*t304*t351*t42*t62*t664+1.2689458038073098d-5*t176*t1
     =           79*t205*t334*t47*t51*t53*t62-1.5625d-2*rhoa*t1668*t41*t
     >           42*t62-1.5625d-2*rhob*t102*t1668*t42*t62+t1671+t1670+t1
     ?           669+t1667+t1666+t1665+t1664+t1663+t1662+t1661+t1660+t16
     @           59+t1658+t1657+t1656+t1655+t1654+t1653+t1652+t1590+t157
     1           5+t1574+t1557+t1556+t1555+t1554+t1553+t1552+t1551+t1550
     2           +t1549+t1548+t1547+t1546+t1543+t1542+t1541+t1537
              t1679 = 1.0d+0*t160*t836*wght
              t1680 = 1.0d+0*t343*t353*wght
              t1681 = 1.0d+0*t341*t354*wght
              t1682 = 1.0d+0*t162*t835*wght
              t1683 = -1.6406249999999997d-2*t166*t58*t60*t62*t841
              t1684 = -6.562499999999999d-2*t125*t347*t359*t856
              t1685 = -6.562499999999999d-2*t163*t347*t355*t58*t61
              t1686 = -6.562499999999999d-2*t166*t347*t60*t62
              t1687 = 4.264472988278112d-4*rhoa*t1533*t355*t359*t41*t419
     1           *t47*t52*t53*t798
              t1688 = 3.2651466231542003d-2*rhoa*t179*t355*t41*t47*t49*t
     1           50*t51*t58*t649
              t1689 = 3.75d-1*rhoa*t125*t355*t41*t57
              t1690 = 4.264472988278112d-4*rhob*t102*t1533*t355*t359*t41
     1           9*t47*t52*t53*t798
              t1691 = 3.2651466231542003d-2*rhob*t102*t179*t355*t47*t49*
     1           t50*t51*t58*t649
              t1692 = 3.75d-1*rhob*t102*t125*t355*t57
              t1693 = 6.530293246308401d-3*rhoa*t179*t41*t47*t49*t50*t51
     1           *t60*t61*t673
              t1694 = 6.530293246308401d-3*rhob*t102*t179*t47*t49*t50*t5
     1           1*t60*t61*t673
              t1695 = 2.132236494139056d-4*rhoa*t1558*t41*t419*t47*t52*t
     1           53*t62*t798
              t1696 = -8.187788137493974d-2*t178*t47*t52*t53*t798*t804*t
     1           947+1.364631356248996d-2*t182*t419*t52*t53*t798*t804-1.
     2           0448469194093442d+0*t419*t47*t48*t49*t50*t51*t709
              t1697 = 2.132236494139056d-4*rhob*t102*t1558*t419*t47*t52*
     1           t53*t62*t798
              t1698 = -4.264472988278112d-4*t1565*t355*t359*t419*t47*t52
     1           *t53*t798
              t1699 = -2.6121172985233604d-2*t179*t355*t47*t49*t50*t51*t
     1           58*t673
              t1700 = -2.5d-1*t163*t355*t47*t56
              t1701 = -6.356503479982097d-1*t143*t149*t257*t258*t515*t58
     1           *t839
              t1702 = 1.2713006959964196d+0*t143*t149*t257*t258*t266*t34
     1           5
              t1703 = 4.717384727406409d-2*t1043*t149*t153*t257*t266*t51
     1           1*t58
              t1704 = 1.7316487067581934d-1*t147*t150*t257*t266*t345*t50
     1           7*t58
              t1705 = -3.463297413516387d-1*t147*t150*t155*t257*t507
              t1706 = -6.926594827032773d-1*t150*t153*t257*t507
              t1707 = t158*(-1.2793418964834335d-3*t178*t47*t52*t53*t62*
     1           t798*t804*t947+2.132236494139056d-4*t182*t419*t52*t53*t
     2           62*t798*t804-1.6325733115771002d-2*t419*t47*t48*t49*t50
     3           *t51*t62*t709-2.5d-1*t179*t42*t47*t60*t61*t709-2.5d-1*t
     4           166*t179*t355*t47*t58*t709-3.2651466231542003d-2*t176*t
     5           178*t419*t47*t49*t50*t51*t60*t61+6.530293246308401d-3*t
     6           176*t179*t182*t49*t50*t51*t60*t61-3.2651466231542003d-2
     7           *t178*t355*t419*t432*t47*t49*t50*t51*t58+6.530293246308
     8           401d-3*t179*t182*t355*t432*t49*t50*t51*t58+1.25d-1*t166
     9           *t182*t355*t56-5.0d-1*t166*t178*t179*t355*t47+t1700+t16
     :           99+t1698)+t159*(-3.109069086965489d-2*t139*t271*t518*t8
     ;           40+9.327207260896466d-2*t142*t253*t256*t840+3.109069086
     <           965489d-2*t139*t253*(2.7242157771351844d-1*t141*t143*t2
     =           65*t515*t58*t839-5.448431554270369d-1*t141*t144*t149*t2
     >           56*t515*t58*t839-8.172647331405554d-1*t1054*t141*t143*t
     ?           149*t270*t58*t839+5.448431554270369d-1*t141*t143*t149*t
     @           345*t515*t58*t723-7.421351600392256d-2*t147*t150*t266*t
     1           338*t58*t723-5.448431554270369d-1*t141*t143*t149*t266*t
     2           723-2.7242157771351844d-1*t141*t143*t266*t345*t58*t721+
     3           5.448431554270369d-1*t141*t143*t155*t721+4.043472623491
     4           207d-2*t149*t153*t270*t508*t511*t515*t58+1.484270320078
     5           4513d-1*t147*t150*t270*t338*t345*t515*t58-2.02173631174
     6           56036d-2*t153*t265*t266*t508*t511*t58+4.043472623491207
     7           d-2*t1047*t149*t153*t256*t266*t508*t58+1.48427032007845
     8           13d-1*t147*t256*t266*t268*t338*t345*t58-1.3621078885675
     9           922d-1*t141*t143*t149*t266*(-2.9685406401569026d-1*t145
     :           *t150*t263*t269*t338-5.937081280313805d-1*t153*t256*t26
     ;           8*t338+t1706)*t58+1.0896863108540737d+0*t141*t143*t149*
     <           t270*t345*t515-5.448431554270369d-1*t141*t143*t265*t266
     =           *t345+1.0896863108540737d+0*t141*t144*t149*t256*t266*t3
     >           45-1.4842703200784513d-1*t147*t150*t266*t270*t338-2.968
     ?           5406401569026d-1*t147*t155*t256*t268*t338+t1705+t1704+t
     @           1703+t1702+t1701)-9.327207260896466d-2*t142*t256*t518*t
     1           838+6.218138173930978d-2*t1055*t139*t271*t838-6.2181381
     2           73930978d-2*t139*t346*t518*t724)+3.109069086965489d-2*t
     3           139*t219*t253*t840-3.109069086965489d-2*t139*t219*t518*
     4           t838+t272*t837-2.132236494139056d-4*t41*t419*t47*t52*t5
     5           3*t62*t796*t798-2.132236494139056d-4*rhoa*t216*t419*t47
     6           *t52*t53*t62*t796*t798+2*t344*t725+6.218138173930978d-2
     7           *t139*t253*t346*t714-6.25d-2*rhoa*t166*t41*t60*t61*t710
     8           -6.25d-2*rhob*t102*t166*t60*t61*t710-6.25d-2*rhoa*t163*
     9           t355*t41*t58*t710-6.25d-2*rhob*t102*t163*t355*t58*t710-
     :           6.530293246308401d-3*t179*t355*t41*t47*t49*t50*t51*t58*
     ;           t673-6.530293246308401d-3*rhoa*t179*t216*t355*t47*t49*t
     <           50*t51*t58*t673-1.5625d-2*rhoa*t1696*t41*t42*t62-1.5625
     =           d-2*rhob*t102*t1696*t42*t62-6.530293246308401d-3*t179*t
     >           41*t432*t47*t49*t50*t51*t60*t61-6.530293246308401d-3*rh
     ?           oa*t179*t216*t432*t47*t49*t50*t51*t60*t61-1.25d-1*t163*
     @           t355*t41*t57-1.25d-1*rhoa*t163*t216*t355*t57-1.25d-1*rh
     1           oa*t163*t183*t355*t41-1.25d-1*rhob*t102*t163*t183*t355+
     2           t1697+t1695+t1694+t1693+t1692+t1691+t1690+t1689+t1688+t
     3           1687
              t1708 = -2.6249999999999996d-1*t125*t160*t58*t856
              t1709 = -1.3124999999999998d-1*t160*t163*t355*t61
              t1710 = 1.0d+0*t160*t842*wght
              t1711 = 2.0d+0*t347*t348*wght
              t1712 = 1.0d+0*t162*t841*wght
              t1713 = -6.562499999999999d-2*t125*t353*t359*t856
              t1714 = -3.2812499999999994d-2*t166*t353*t60*t62
              t1715 = -3.2812499999999994d-2*t163*t347*t355*t58*t61
              t1716 = -1.6406249999999997d-2*t166*t58*t60*t62*t846
              t1717 = 3.2812499999999994d-2*t42*t60*t62*t744
              t1718 = -2.132236494139056d-4*rhoa*t1533*t355*t359*t41*t41
     1           9*t47*t49*t798*t844
              t1719 = 6.530293246308401d-3*rhoa*t179*t355*t41*t47*t49*t5
     1           0*t51*t58*t649
              t1720 = -9.795439869462602d-3*rhoa*t179*t355*t41*t47*t51*t
     1           53*t58*t649
              t1721 = 5.075783215229239d-5*rhob*t179*t304*t351*t355*t359
     1           *t47*t49*t50*t51*t649
              t1722 = 2.9147522690301453d-3*rhob*t125*t304*t351*t355*t57
     1           *t58
              t1723 = -2.132236494139056d-4*rhob*t102*t1533*t355*t359*t4
     1           19*t47*t49*t798*t844
              t1724 = 6.530293246308401d-3*rhob*t102*t179*t355*t47*t49*t
     1           50*t51*t58*t649
              t1725 = -9.795439869462602d-3*rhob*t102*t179*t355*t47*t51*
     1           t53*t58*t649
              t1726 = 3.2651466231542003d-3*rhoa*t179*t41*t47*t49*t50*t5
     1           1*t60*t61*t673
              t1727 = 3.2651466231542003d-3*rhob*t102*t179*t47*t49*t50*t
     1           51*t60*t61*t673
              t1728 = -1.066118247069528d-4*rhoa*t1558*t41*t419*t47*t49*
     1           t62*t798*t844
              t1729 = 4.093894068746987d-2*t178*t47*t49*t798*t804*t844*t
     1           947-6.823156781244979d-3*t182*t419*t49*t798*t804*t844-5
     2           .224234597046721d-1*t419*t47*t48*t49*t50*t51*t738+2.612
     3           1172985233604d-1*t419*t47*t48*t51*t53*t709
              t1730 = 2.5378916076146196d-5*rhob*t179*t304*t351*t432*t47
     1           *t49*t50*t51*t62
              t1731 = -1.066118247069528d-4*rhob*t102*t1558*t419*t47*t49
     1           *t62*t798*t844
              t1732 = 2.132236494139056d-4*t1565*t355*t359*t419*t47*t49*
     1           t798*t844
              t1733 = 6.530293246308401d-3*t179*t355*t47*t51*t53*t58*t67
     1           3
              t1734 = t158*(6.396709482417168d-4*t178*t47*t49*t62*t798*t
     1           804*t844*t947-1.066118247069528d-4*t182*t419*t49*t62*t7
     2           98*t804*t844-8.162866557885501d-3*t419*t47*t48*t49*t50*
     3           t51*t62*t738-2.5d-1*t166*t179*t355*t47*t58*t738+4.08143
     4           32789427504d-3*t419*t47*t48*t51*t53*t62*t709-1.25d-1*t1
     5           79*t42*t47*t60*t61*t709-1.6325733115771002d-2*t176*t178
     6           *t419*t47*t49*t50*t51*t60*t61+3.2651466231542003d-3*t17
     7           6*t179*t182*t49*t50*t51*t60*t61+1.6325733115771002d-2*t
     8           178*t355*t419*t432*t47*t51*t53*t58-3.2651466231542003d-
     9           3*t179*t182*t355*t432*t51*t53*t58+t1733+t1732+t1628+t16
     :           27+t1626+t1625)+t272*t845+1.066118247069528d-4*t41*t419
     ;           *t47*t49*t62*t796*t798*t844+1.066118247069528d-4*rhoa*t
     <           216*t419*t47*t49*t62*t796*t798*t844+3.109069086965489d-
     =           2*t139*t253*t346*t743-6.25d-2*rhoa*t163*t355*t41*t58*t7
     >           39-6.25d-2*rhob*t102*t163*t355*t58*t739+t352*t725-2.428
     ?           9602241917876d-4*rhob*t304*t351*t42*t62*t710-3.125d-2*r
     @           hoa*t166*t41*t60*t61*t710-3.125d-2*rhob*t102*t166*t60*t
     1           61*t710+3.2651466231542003d-3*t179*t355*t41*t47*t51*t53
     2           *t58*t673+3.2651466231542003d-3*rhoa*t179*t216*t355*t47
     3           *t51*t53*t58*t673-1.5625d-2*rhoa*t1729*t41*t42*t62-1.56
     4           25d-2*rhob*t102*t1729*t42*t62-3.2651466231542003d-3*t17
     5           9*t41*t432*t47*t49*t50*t51*t60*t61-3.2651466231542003d-
     6           3*rhoa*t179*t216*t432*t47*t49*t50*t51*t60*t61-9.7158408
     7           96767151d-4*rhob*t163*t183*t304*t351*t355*t58+t1731+t17
     8           30+t1728+t1727+t1726+t1725+t1724+t1723+t1722+t1721+t172
     9           0+t1719+t1718+t1639+t1632+t1631+t1630+t1629+t1616+t1615
     :           +t1611+t1610+t1609+t1607
              t1735 = 1.0d+0*t160*t847*wght
              t1736 = 1.0d+0*t347*t354*wght
              t1737 = 1.0d+0*t348*t353*wght
              t1738 = 1.0d+0*t162*t846*wght
              t1739 = -1.6406249999999997d-2*t166*t58*t60*t62*t853
              t1740 = -3.2812499999999994d-2*t163*t353*t355*t58*t61
              t1741 = 1.066118247069528d-4*rhoa*t1533*t355*t359*t41*t419
     1           *t47*t798*t848
              t1742 = -8.162866557885501d-3*rhoa*t179*t355*t41*t47*t51*t
     1           53*t58*t649
              t1743 = -4.8579204483835753d-4*rhob*t125*t355*t359*t57*t62
     1           1*t849
              t1744 = 4.8579204483835753d-4*rhob*t125*t304*t355*t359*t57
     1           *t851
              t1745 = -5.075783215229239d-5*rhob*t179*t304*t351*t355*t35
     1           9*t47*t51*t53*t649
              t1746 = 2.428960224191788d-3*rhob*t125*t304*t351*t355*t57*
     1           t58
              t1747 = 1.066118247069528d-4*rhob*t102*t1533*t355*t359*t41
     1           9*t47*t798*t848
              t1748 = -8.162866557885501d-3*rhob*t102*t179*t355*t47*t51*
     1           t53*t58*t649
              t1749 = -1.6325733115771002d-3*rhoa*t179*t41*t47*t51*t53*t
     1           60*t61*t673
              t1750 = 4.8579204483835753d-4*rhob*t163*t304*t351*t57*t60*
     1           t61
              t1751 = -1.6325733115771002d-3*rhob*t102*t179*t47*t51*t53*
     1           t60*t61*t673
              t1752 = 5.330591235347639d-5*rhoa*t1558*t41*t419*t47*t62*t
     1           798*t848
              t1753 = -2.0469470343734936d-2*t178*t47*t798*t804*t848*t94
     1           7+3.4115783906224895d-3*t182*t419*t798*t804*t848+5.2242
     2           34597046721d-1*t419*t47*t48*t51*t53*t738
              t1754 = -2.4289602241917876d-4*rhob*t166*t57*t62*t621*t849
              t1755 = 2.4289602241917876d-4*rhob*t166*t304*t57*t62*t851
              t1756 = -2.5378916076146196d-5*rhob*t179*t304*t351*t432*t4
     1           7*t51*t53*t62
              t1757 = 5.330591235347639d-5*rhob*t102*t1558*t419*t47*t62*
     1           t798*t848
              t1758 = -1.066118247069528d-4*t1565*t355*t359*t419*t47*t79
     1           8*t848
              t1759 = t158*(-3.198354741208584d-4*t178*t47*t62*t798*t804
     1           *t848*t947+5.330591235347639d-5*t182*t419*t62*t798*t804
     2           *t848+8.162866557885501d-3*t419*t47*t48*t51*t53*t62*t73
     3           8-1.25d-1*t179*t42*t47*t60*t61*t738+8.162866557885501d-
     4           3*t176*t178*t419*t47*t51*t53*t60*t61-1.6325733115771002
     5           d-3*t176*t179*t182*t51*t53*t60*t61+t1758+t1733+t1677+t1
     6           674+t1672+t1570+t1569+t1568)+t272*t852-2.42896022419178
     7           76d-4*rhob*t183*t304*t42*t62*t851+2.4289602241917876d-4
     8           *rhob*t183*t42*t62*t621*t849-5.330591235347639d-5*t41*t
     9           419*t47*t62*t796*t798*t848-5.330591235347639d-5*rhoa*t2
     :           16*t419*t47*t62*t796*t798*t848+6.218138173930978d-2*t13
     ;           9*t253*t339*t743-4.8579204483835753d-4*rhob*t304*t351*t
     <           42*t62*t739-3.125d-2*rhoa*t166*t41*t60*t61*t739-3.125d-
     =           2*rhob*t102*t166*t60*t61*t739+2*t352*t690-1.5625d-2*rho
     >           a*t1753*t41*t42*t62-1.5625d-2*rhob*t102*t1753*t42*t62+1
     ?           .6325733115771002d-3*t179*t41*t432*t47*t51*t53*t60*t61+
     @           1.6325733115771002d-3*rhoa*t179*t216*t432*t47*t51*t53*t
     1           60*t61-4.8579204483835753d-4*rhob*t166*t183*t304*t351*t
     2           60*t61+t1757+t1756+t1755+t1754+t1752+t1751+t1750+t1749+
     3           t1748+t1747+t1746+t1745+t1744+t1743+t1742+t1741+t1666+t
     4           1661+t1658+t1657+t1656+t1590+t1575+t1574+t1547+t1546+t1
     5           543+t1542+t1541+t1537
              t1760 = 1.0d+0*t160*t854*wght
              t1761 = 2.0d+0*t353*t354*wght
              t1762 = 1.0d+0*t162*t853*wght
              t1763 = 3.2812499999999994d-2*t42*t60*t62*t765
              t1764 = -3.125d-2*rhoa*t163*t283*t355*t41
              t1765 = -3.125d-2*rhob*t163*t315*t355*t57
              t1766 = -3.125d-2*rhob*t102*t163*t283*t355
              t1767 = -3.125d-2*t102*t163*t355*t57
              t1768 = -3.125d-2*rhoa*t166*t41*t60*t61*t753
              t1769 = -4.8579204483835753d-4*rhoa*t166*t205*t283*t334*t6
     1           0*t61
              t1770 = 1.6325733115771002d-3*rhob*t179*t315*t432*t47*t51*
     1           t52*t60*t61
              t1771 = 1.6325733115771002d-3*t102*t179*t432*t47*t51*t52*t
     1           60*t61
              t1772 = -3.125d-2*rhob*t102*t166*t60*t61*t753
              t1773 = -2.0469470343734936d-2*t281*t47*t797*t798*t804*t94
     1           7+3.4115783906224895d-3*t282*t419*t797*t798*t804+5.2242
     2           34597046721d-1*t419*t47*t48*t51*t52*t752
              t1774 = -1.25d-1*t166*t179*t281*t355*t47
              t1775 = 3.125d-2*t166*t282*t355*t56
              t1776 = 8.162866557885501d-3*t176*t281*t419*t47*t51*t52*t6
     1           0*t61
              t1777 = -1.6325733115771002d-3*t176*t179*t282*t51*t52*t60*
     1           t61
              t1778 = -1.25d-1*t179*t42*t47*t60*t61*t752
              t1779 = -3.109069086965489d-2*t139*t316*t518*t806
              t1780 = 3.109069086965489d-2*t139*t253*t316*t811
              t1781 = 5.448431554270369d-1*t141*t144*t149*t266*t320*t337
              t1782 = 7.421351600392256d-2*t147*t266*t268*t320*t337*t338
     1           *t58
              t1783 = 2.7242157771351844d-1*t141*t143*t155*t760
              t1784 = -2.7242157771351844d-1*t141*t143*t149*t266*t761
              t1785 = -3.710675800196128d-2*t147*t150*t266*t338*t58*t761
              t1786 = -2.7242157771351844d-1*t141*t143*t266*t324*t337
              t1787 = 5.448431554270369d-1*t141*t143*t149*t325*t337*t515
              t1788 = 7.421351600392256d-2*t147*t150*t325*t337*t338*t515
     1           *t58
              t1789 = t159*(-3.109069086965489d-2*t139*t326*t518*t811+9.
     1           327207260896466d-2*t142*t253*t320*t811+3.10906908696548
     2           9d-2*t139*t253*(2.7242157771351844d-1*t141*t143*t324*t5
     3           15*t58*t808-5.448431554270369d-1*t141*t144*t149*t320*t5
     4           15*t58*t808-8.172647331405554d-1*t1054*t141*t143*t149*t
     5           325*t58*t808+5.448431554270369d-1*t141*t143*t149*t337*t
     6           515*t58*t761-2.7242157771351844d-1*t141*t143*t266*t337*
     7           t58*t760+1.0108681558728018d-2*t149*t153*t325*t508*t511
     8           *t515*t58-5.054340779364009d-3*t153*t266*t324*t508*t511
     9           *t58+1.0108681558728018d-2*t1047*t149*t153*t266*t320*t5
     :           08*t58-1.3621078885675922d-1*t141*t143*t149*t266*(-7.42
     ;           1351600392256d-2*t145*t150*t269*t322*t338-1.48427032007
     <           84513d-1*t153*t268*t320*t338+t1583)*t58-3.7106758001961
     =           28d-2*t147*t150*t266*t325*t338-7.421351600392256d-2*t14
     >           7*t155*t268*t320*t338+t1788+t1787+t1786+t1785+t1784+t17
     ?           83+t1782+t1781+t1582+t1581+t1579+t1578+t1576)-9.3272072
     @           60896466d-2*t142*t320*t518*t806+6.218138173930978d-2*t1
     1           055*t139*t326*t806-6.218138173930978d-2*t139*t339*t518*
     2           t762)
              t1790 = t158*(-3.198354741208584d-4*t281*t47*t62*t797*t798
     1           *t804*t947+5.330591235347639d-5*t282*t419*t62*t797*t798
     2           *t804+8.162866557885501d-3*t419*t47*t48*t51*t52*t62*t75
     3           2-1.25d-1*t166*t179*t355*t47*t58*t752+8.162866557885501
     4           d-3*t281*t355*t419*t432*t47*t51*t52*t58-1.6325733115771
     5           002d-3*t179*t282*t355*t432*t51*t52*t58+t1778+t1777+t177
     6           6+t1775+t1774+t1570+t1567+t1566)+t327*t805-2.4289602241
     7           917876d-4*rhoa*t205*t283*t42*t62*t801+2.428960224191787
     8           6d-4*rhoa*t283*t415*t42*t62*t799-5.330591235347639d-5*r
     9           hob*t315*t419*t47*t62*t796*t797*t798-5.330591235347639d
     :           -5*t102*t419*t47*t62*t796*t797*t798+2*t336*t763+6.21813
     ;           8173930978d-2*t139*t253*t339*t756-4.8579204483835753d-4
     <           *rhoa*t205*t334*t42*t62*t753-3.125d-2*rhoa*t163*t355*t4
     =           1*t58*t753-3.125d-2*rhob*t102*t163*t355*t58*t753+1.6325
     >           733115771002d-3*rhob*t179*t315*t355*t47*t51*t52*t58*t67
     ?           3+1.6325733115771002d-3*t102*t179*t355*t47*t51*t52*t58*
     @           t673-1.5625d-2*rhoa*t1773*t41*t42*t62-1.5625d-2*rhob*t1
     1           02*t1773*t42*t62-4.8579204483835753d-4*rhoa*t163*t205*t
     2           283*t334*t355*t58+t1789+t1780+t1779+t1772+t1771+t1770+t
     3           1769+t1768+t1767+t1766+t1765+t1764+t1564+t1563+t1562+t1
     4           561+t1559+t1556+t1553+t1548+t1547+t1545+t1544+t1541+t15
     5           40+t1539+t1538+t1536+t1535+t1534
              t1791 = 3.2812499999999994d-2*t166*t328*t355*t61
              t1792 = 1.6406249999999997d-2*t42*t60*t62*t778
              t1793 = -6.25d-2*rhoa*t163*t283*t355*t41
              t1794 = -6.25d-2*rhob*t163*t315*t355*t57
              t1795 = -6.25d-2*rhob*t102*t163*t283*t355
              t1796 = -6.25d-2*t102*t163*t355*t57
              t1797 = 4.093894068746987d-2*t281*t47*t50*t798*t804*t820*t
     1           947-6.823156781244979d-3*t282*t419*t50*t798*t804*t820+2
     2           .6121172985233604d-1*t419*t47*t48*t51*t52*t769-5.224234
     3           597046721d-1*t419*t47*t48*t49*t50*t51*t752
              t1798 = -2.5d-1*t166*t179*t281*t355*t47
              t1799 = 6.25d-2*t166*t282*t355*t56
              t1800 = t344*t763
              t1801 = 3.109069086965489d-2*t139*t253*t339*t771
              t1802 = 3.109069086965489d-2*t139*t253*t316*t824
              t1803 = -3.109069086965489d-2*t139*t316*t339*t346*t518
              t1804 = t159*(-3.109069086965489d-2*t139*t326*t518*t824+9.
     1           327207260896466d-2*t142*t253*t320*t824-3.10906908696548
     2           9d-2*t139*t339*t518*t776+3.109069086965489d-2*t139*t253
     3           *(2.7242157771351844d-1*t141*t143*t149*t337*t515*t58*t7
     4           75-1.855337900098064d-2*t147*t150*t266*t338*t58*t775-1.
     5           3621078885675922d-1*t141*t143*t149*t266*t775-1.36210788
     6           85675922d-1*t141*t143*t266*t337*t58*t774+1.362107888567
     7           5922d-1*t141*t143*t155*t774+2.7242157771351844d-1*t141*
     8           t143*t149*t345*t515*t58*t761-1.3621078885675922d-1*t141
     9           *t143*t266*t345*t58*t760+2.0217363117456036d-2*t149*t15
     :           3*t325*t508*t511*t515*t58+3.710675800196128d-2*t147*t15
     ;           0*t325*t338*t345*t515*t58+2.7242157771351844d-1*t141*t1
     <           43*t324*t337*t345*t515*t58-5.448431554270369d-1*t141*t1
     =           44*t149*t320*t337*t345*t515*t58-1.0108681558728018d-2*t
     >           153*t266*t324*t508*t511*t58+2.0217363117456036d-2*t1047
     ?           *t149*t153*t266*t320*t508*t58+3.710675800196128d-2*t147
     @           *t266*t268*t320*t338*t345*t58-8.172647331405554d-1*t105
     1           4*t141*t143*t149*t325*t337*t345*t58-1.3621078885675922d
     2           -1*t141*t143*t149*t266*(-1.4842703200784513d-1*t145*t15
     3           0*t269*t322*t338-2.9685406401569026d-1*t153*t268*t320*t
     4           338+t1638)*t58+2.7242157771351844d-1*t141*t143*t149*t32
     5           5*t345*t515-1.3621078885675922d-1*t141*t143*t266*t324*t
     6           345+2.7242157771351844d-1*t141*t144*t149*t266*t320*t345
     7           -7.421351600392256d-2*t147*t150*t266*t325*t338-1.484270
     8           3200784513d-1*t147*t155*t268*t320*t338+t1788+t1787+t178
     9           6+t1785+t1784+t1783+t1782+t1781+t1637+t1636+t1635+t1634
     :           +t1633+t1581+t1578)-3.109069086965489d-2*t139*t346*t518
     ;           *t762-9.327207260896466d-2*t142*t320*t339*t346*t518+6.2
     <           18138173930978d-2*t1055*t139*t326*t339*t346)
              t1805 = t158*(6.396709482417168d-4*t281*t47*t50*t62*t798*t
     1           804*t820*t947-1.066118247069528d-4*t282*t419*t50*t62*t7
     2           98*t804*t820+4.0814332789427504d-3*t419*t47*t48*t51*t52
     3           *t62*t769-1.25d-1*t166*t179*t355*t47*t58*t769-8.1628665
     4           57885501d-3*t419*t47*t48*t49*t50*t51*t62*t752-2.5d-1*t1
     5           79*t42*t47*t60*t61*t752+1.6325733115771002d-2*t176*t281
     6           *t419*t47*t51*t52*t60*t61-3.2651466231542003d-3*t176*t1
     7           79*t282*t51*t52*t60*t61-1.6325733115771002d-2*t281*t355
     8           *t419*t432*t47*t49*t50*t51*t58+3.2651466231542003d-3*t1
     9           79*t282*t355*t432*t49*t50*t51*t58+t1799+t1798+t1628+t16
     :           25+t1624+t1567)+t327*t822+1.066118247069528d-4*rhob*t31
     ;           5*t419*t47*t50*t62*t796*t798*t820+1.066118247069528d-4*
     <           t102*t419*t47*t50*t62*t796*t798*t820+t336*t777-2.428960
     =           2241917876d-4*rhoa*t205*t334*t42*t62*t770-3.125d-2*rhoa
     >           *t163*t355*t41*t58*t770-3.125d-2*rhob*t102*t163*t355*t5
     ?           8*t770+3.109069086965489d-2*t139*t253*t346*t756-6.25d-2
     @           *rhoa*t166*t41*t60*t61*t753-6.25d-2*rhob*t102*t166*t60*
     1           t61*t753-3.2651466231542003d-3*rhob*t179*t315*t355*t47*
     2           t49*t50*t51*t58*t673-3.2651466231542003d-3*t102*t179*t3
     3           55*t47*t49*t50*t51*t58*t673-1.5625d-2*rhoa*t1797*t41*t4
     4           2*t62-1.5625d-2*rhob*t102*t1797*t42*t62+3.2651466231542
     5           003d-3*rhob*t179*t315*t432*t47*t51*t52*t60*t61+3.265146
     6           6231542003d-3*t102*t179*t432*t47*t51*t52*t60*t61-9.7158
     7           40896767151d-4*rhoa*t166*t205*t283*t334*t60*t61+t1804+t
     8           1803+t1802+t1801+t1800+t1796+t1795+t1794+t1793+t1623+t1
     9           622+t1620+t1619+t1618+t1617+t1616+t1614+t1613+t1612+t16
     :           09+t1608+t1606+t1605+t1604+t1603
              t1806 = 6.562499999999999d-2*t166*t328*t355*t61
              t1807 = -3.125d-2*rhoa*t163*t355*t41*t58*t781
              t1808 = -4.8579204483835753d-4*rhob*t163*t283*t304*t351*t3
     1           55*t58
              t1809 = -4.8579204483835753d-4*t163*t304*t351*t355*t57*t58
              t1810 = 1.6325733115771002d-3*rhob*t179*t315*t355*t47*t51*
     1           t53*t58*t673
              t1811 = -3.125d-2*rhob*t163*t355*t57*t58*t787
              t1812 = 1.6325733115771002d-3*t102*t179*t355*t47*t51*t53*t
     1           58*t673
              t1813 = -3.125d-2*rhob*t102*t163*t355*t58*t781
              t1814 = -2.0469470343734936d-2*t281*t47*t52*t53*t798*t804*
     1           t947+3.4115783906224895d-3*t282*t419*t52*t53*t798*t804+
     2           2.6121172985233604d-1*t419*t47*t48*t51*t52*t780+2.61211
     3           72985233604d-1*t419*t47*t48*t51*t53*t752
              t1815 = 8.162866557885501d-3*t281*t355*t419*t432*t47*t51*t
     1           53*t58
              t1816 = -1.6325733115771002d-3*t179*t282*t355*t432*t51*t53
     1           *t58
              t1817 = -1.25d-1*t166*t179*t355*t47*t58*t780
              t1818 = t158*(-3.198354741208584d-4*t281*t47*t52*t53*t62*t
     1           798*t804*t947+5.330591235347639d-5*t282*t419*t52*t53*t6
     2           2*t798*t804+4.0814332789427504d-3*t419*t47*t48*t51*t52*
     3           t62*t780+4.0814332789427504d-3*t419*t47*t48*t51*t53*t62
     4           *t752+t1817+t1816+t1815+t1778+t1777+t1776+t1775+t1774+t
     5           1676+t1675+t1673+t1570)+t327*t834-5.330591235347639d-5*
     6           rhob*t315*t419*t47*t52*t53*t62*t796*t798-5.330591235347
     7           639d-5*t102*t419*t47*t52*t53*t62*t796*t798+3.1090690869
     8           65489d-2*t139*t253*t339*t788+8.162866557885502d-4*rhob*
     9           t176*t179*t47*t51*t52*t62*t787-2.4289602241917876d-4*rh
     :           oa*t205*t334*t42*t62*t781+t352*t763+t336*t763+3.1090690
     ;           86965489d-2*t139*t253*t339*t756-2.4289602241917876d-4*r
     <           hob*t304*t351*t42*t62*t753+1.2689458038073098d-5*t176*t
     =           179*t304*t351*t47*t51*t52*t62-1.5625d-2*rhoa*t1814*t41*
     >           t42*t62-1.5625d-2*rhob*t102*t1814*t42*t62+t1813+t1812+t
     ?           1811+t1810+t1809+t1808+t1807+t1789+t1780+t1779+t1772+t1
     @           771+t1770+t1769+t1768+t1767+t1766+t1765+t1764+t1671+t16
     1           70+t1669+t1667+t1665+t1664+t1663+t1662+t1660+t1659+t165
     2           5+t1654+t1653+t1652+t1556+t1553+t1548+t1547+t1541
              t1819 = -8.187788137493974d-2*t281*t47*t52*t53*t798*t804*t
     1           947+1.364631356248996d-2*t282*t419*t52*t53*t798*t804-1.
     2           0448469194093442d+0*t419*t47*t48*t49*t50*t51*t769
              t1820 = t158*(-1.2793418964834335d-3*t281*t47*t52*t53*t62*
     1           t798*t804*t947+2.132236494139056d-4*t282*t419*t52*t53*t
     2           62*t798*t804-1.6325733115771002d-2*t419*t47*t48*t49*t50
     3           *t51*t62*t769-2.5d-1*t179*t42*t47*t60*t61*t769-2.5d-1*t
     4           166*t179*t355*t47*t58*t769-3.2651466231542003d-2*t176*t
     5           281*t419*t47*t49*t50*t51*t60*t61+6.530293246308401d-3*t
     6           176*t179*t282*t49*t50*t51*t60*t61-3.2651466231542003d-2
     7           *t281*t355*t419*t432*t47*t49*t50*t51*t58+6.530293246308
     8           401d-3*t179*t282*t355*t432*t49*t50*t51*t58+1.25d-1*t166
     9           *t282*t355*t56-5.0d-1*t166*t179*t281*t355*t47+t1700+t16
     :           99+t1698)+t159*(-3.109069086965489d-2*t139*t326*t518*t8
     ;           40+9.327207260896466d-2*t142*t253*t320*t840+3.109069086
     <           965489d-2*t139*t253*(2.7242157771351844d-1*t141*t143*t3
     =           24*t515*t58*t839-5.448431554270369d-1*t141*t144*t149*t3
     >           20*t515*t58*t839-8.172647331405554d-1*t1054*t141*t143*t
     ?           149*t325*t58*t839+5.448431554270369d-1*t141*t143*t149*t
     @           345*t515*t58*t775-7.421351600392256d-2*t147*t150*t266*t
     1           338*t58*t775-5.448431554270369d-1*t141*t143*t149*t266*t
     2           775-2.7242157771351844d-1*t141*t143*t266*t345*t58*t774+
     3           5.448431554270369d-1*t141*t143*t155*t774+4.043472623491
     4           207d-2*t149*t153*t325*t508*t511*t515*t58+1.484270320078
     5           4513d-1*t147*t150*t325*t338*t345*t515*t58-2.02173631174
     6           56036d-2*t153*t266*t324*t508*t511*t58+4.043472623491207
     7           d-2*t1047*t149*t153*t266*t320*t508*t58+1.48427032007845
     8           13d-1*t147*t266*t268*t320*t338*t345*t58-1.3621078885675
     9           922d-1*t141*t143*t149*t266*(-2.9685406401569026d-1*t145
     :           *t150*t269*t322*t338-5.937081280313805d-1*t153*t268*t32
     ;           0*t338+t1706)*t58+1.0896863108540737d+0*t141*t143*t149*
     <           t325*t345*t515-5.448431554270369d-1*t141*t143*t266*t324
     =           *t345+1.0896863108540737d+0*t141*t144*t149*t266*t320*t3
     >           45-1.4842703200784513d-1*t147*t150*t266*t325*t338-2.968
     ?           5406401569026d-1*t147*t155*t268*t320*t338+t1705+t1704+t
     @           1703+t1702+t1701)-9.327207260896466d-2*t142*t320*t518*t
     1           838+6.218138173930978d-2*t1055*t139*t326*t838-6.2181381
     2           73930978d-2*t139*t346*t518*t776)+3.109069086965489d-2*t
     3           139*t253*t316*t840-3.109069086965489d-2*t139*t316*t518*
     4           t838+t327*t837-2.132236494139056d-4*rhob*t315*t419*t47*
     5           t52*t53*t62*t796*t798-2.132236494139056d-4*t102*t419*t4
     6           7*t52*t53*t62*t796*t798+2*t344*t777+6.218138173930978d-
     7           2*t139*t253*t346*t771-6.25d-2*rhoa*t166*t41*t60*t61*t77
     8           0-6.25d-2*rhob*t102*t166*t60*t61*t770-6.25d-2*rhoa*t163
     9           *t355*t41*t58*t770-6.25d-2*rhob*t102*t163*t355*t58*t770
     :           -6.530293246308401d-3*rhob*t179*t315*t355*t47*t49*t50*t
     ;           51*t58*t673-6.530293246308401d-3*t102*t179*t355*t47*t49
     <           *t50*t51*t58*t673-1.5625d-2*rhoa*t1819*t41*t42*t62-1.56
     =           25d-2*rhob*t102*t1819*t42*t62-6.530293246308401d-3*rhob
     >           *t179*t315*t432*t47*t49*t50*t51*t60*t61-6.5302932463084
     ?           01d-3*t102*t179*t432*t47*t49*t50*t51*t60*t61-1.25d-1*rh
     @           ob*t163*t315*t355*t57-1.25d-1*t102*t163*t355*t57-1.25d-
     1           1*rhoa*t163*t283*t355*t41-1.25d-1*rhob*t102*t163*t283*t
     2           355+t1697+t1695+t1694+t1693+t1692+t1691+t1690+t1689+t16
     3           88+t1687
              t1821 = 3.2812499999999994d-2*t42*t60*t62*t789
              t1822 = 4.093894068746987d-2*t281*t47*t49*t798*t804*t844*t
     1           947-6.823156781244979d-3*t282*t419*t49*t798*t804*t844-5
     2           .224234597046721d-1*t419*t47*t48*t49*t50*t51*t780+2.612
     3           1172985233604d-1*t419*t47*t48*t51*t53*t769
              t1823 = t158*(6.396709482417168d-4*t281*t47*t49*t62*t798*t
     1           804*t844*t947-1.066118247069528d-4*t282*t419*t49*t62*t7
     2           98*t804*t844-8.162866557885501d-3*t419*t47*t48*t49*t50*
     3           t51*t62*t780-2.5d-1*t166*t179*t355*t47*t58*t780+4.08143
     4           32789427504d-3*t419*t47*t48*t51*t53*t62*t769-1.25d-1*t1
     5           79*t42*t47*t60*t61*t769-1.6325733115771002d-2*t176*t281
     6           *t419*t47*t49*t50*t51*t60*t61+3.2651466231542003d-3*t17
     7           6*t179*t282*t49*t50*t51*t60*t61+1.6325733115771002d-2*t
     8           281*t355*t419*t432*t47*t51*t53*t58-3.2651466231542003d-
     9           3*t179*t282*t355*t432*t51*t53*t58+t1799+t1798+t1733+t17
     :           32+t1628+t1625)+t327*t845+1.066118247069528d-4*rhob*t31
     ;           5*t419*t47*t49*t62*t796*t798*t844+1.066118247069528d-4*
     <           t102*t419*t47*t49*t62*t796*t798*t844+3.109069086965489d
     =           -2*t139*t253*t346*t788-1.6325733115771002d-3*rhob*t176*
     >           t179*t47*t49*t50*t51*t62*t787-6.25d-2*rhob*t163*t355*t5
     ?           7*t58*t787-6.25d-2*rhoa*t163*t355*t41*t58*t781-6.25d-2*
     @           rhob*t102*t163*t355*t58*t781+t352*t777-2.42896022419178
     1           76d-4*rhob*t304*t351*t42*t62*t770-3.125d-2*rhoa*t166*t4
     2           1*t60*t61*t770-3.125d-2*rhob*t102*t166*t60*t61*t770+3.2
     3           651466231542003d-3*rhob*t179*t315*t355*t47*t51*t53*t58*
     4           t673+3.2651466231542003d-3*t102*t179*t355*t47*t51*t53*t
     5           58*t673-2.5378916076146196d-5*t176*t179*t304*t351*t47*t
     6           49*t50*t51*t62-1.5625d-2*rhoa*t1822*t41*t42*t62-1.5625d
     7           -2*rhob*t102*t1822*t42*t62-3.2651466231542003d-3*rhob*t
     8           179*t315*t432*t47*t49*t50*t51*t60*t61-3.265146623154200
     9           3d-3*t102*t179*t432*t47*t49*t50*t51*t60*t61-9.715840896
     :           767151d-4*t163*t304*t351*t355*t57*t58-9.715840896767151
     ;           d-4*rhob*t163*t283*t304*t351*t355*t58+t1804+t1803+t1802
     <           +t1801+t1800+t1796+t1795+t1794+t1793+t1731+t1730+t1728+
     =           t1727+t1726+t1725+t1724+t1723+t1722+t1721+t1720+t1719+t
     >           1718+t1616+t1609
              t1824 = -2.0469470343734936d-2*t281*t47*t798*t804*t848*t94
     1           7+3.4115783906224895d-3*t282*t419*t798*t804*t848+5.2242
     2           34597046721d-1*t419*t47*t48*t51*t53*t780
              t1825 = -1.5625d-2*rhob*t42*t57*t62*(1.5545345434827443d-2
     1           *t304*(-2.1622114952063792d-1*gammabb*t311*t90*t95*(1.2
     2           029732165432584d+1*t303*t312*t350*t91-4.363481313335766
     3           d-1*t305*t616*t98)+4.0434726234912094d-2*gammabb*t313*t
     4           615*t618*t95*t98+4.7173847274064107d-2*gammabb*t1234*t3
     5           05*t311*t95*t98-2.0217363117456047d-2*gammabb*t310*t311
     6           *t615*t98-1.2973268971238278d+0*gammabb*t1235*t313*t850
     7           *t90*t95+8.648845980825517d-1*gammabb*t349*t618*t785*t9
     8           0*t95-4.3244229904127585d-1*t311*t785*t90*t95+8.6488459
     9           80825517d-1*t313*t349*t618*t90*t95-1.0090320310963104d+
     :           0*gammabb*t305*t306*t618*t850*t95+1.0090320310963104d+0
     ;           *t305*t306*t311*t349*t95-9.350317100005212d-2*gammabb*t
     <           311*t350*t785*t93+1.8700634200010424d-1*gammabb*t313*t3
     =           49*t350*t618*t93+2.181740656667883d-1*gammabb*t305*t311
     >           *t349*t616*t93-2.181740656667883d-1*t100*t305*t616*t93-
     ?           9.350317100005212d-2*t311*t313*t350*t93+4.3244229904127
     @           585d-1*gammabb*t310*t618*t850*t90-4.3244229904127585d-1
     1           *gammabb*t311*t349*t784*t90+4.3244229904127585d-1*t100*
     2           t784*t90-4.3244229904127585d-1*t310*t311*t349*t90)-1.55
     3           45345434827443d-2*t314*t621*t851+3.1090690869654886d-2*
     4           t1236*t314*t849-3.1090690869654886d-2*t351*t621*t786)+t
     5           158*(-3.198354741208584d-4*t281*t47*t62*t798*t804*t848*
     6           t947+5.330591235347639d-5*t282*t419*t62*t798*t804*t848+
     7           8.162866557885501d-3*t419*t47*t48*t51*t53*t62*t780-1.25
     8           d-1*t179*t42*t47*t60*t61*t780+8.162866557885501d-3*t176
     9           *t281*t419*t47*t51*t53*t60*t61-1.6325733115771002d-3*t1
     :           76*t179*t282*t51*t53*t60*t61+t1817+t1816+t1815+t1775+t1
     ;           774+t1758+t1733+t1570)+t327*t852-2.4289602241917876d-4*
     <           t304*t42*t57*t62*t851-2.4289602241917876d-4*rhob*t283*t
     =           304*t42*t62*t851+2.4289602241917876d-4*t42*t57*t62*t621
     >           *t849+2.4289602241917876d-4*rhob*t283*t42*t62*t621*t849
     ?           -5.330591235347639d-5*rhob*t315*t419*t47*t62*t796*t798*
     @           t848-5.330591235347639d-5*t102*t419*t47*t62*t796*t798*t
     1           848+6.218138173930978d-2*t139*t253*t339*t788+1.63257331
     2           15771002d-3*rhob*t176*t179*t47*t51*t53*t62*t787-3.125d-
     3           2*rhob*t166*t57*t60*t61*t787-4.8579204483835753d-4*rhob
     4           *t304*t351*t42*t62*t781-3.125d-2*rhoa*t166*t41*t60*t61*
     5           t781-3.125d-2*rhob*t102*t166*t60*t61*t781+2*t352*t763+2
     6           .5378916076146196d-5*t176*t179*t304*t351*t47*t51*t53*t6
     7           2-1.5625d-2*rhoa*t1824*t41*t42*t62-1.5625d-2*rhob*t102*
     8           t1824*t42*t62-4.8579204483835753d-4*t166*t304*t351*t57*
     9           t60*t61+1.6325733115771002d-3*rhob*t179*t315*t432*t47*t
     :           51*t53*t60*t61+1.6325733115771002d-3*t102*t179*t432*t47
     ;           *t51*t53*t60*t61-4.8579204483835753d-4*rhob*t166*t283*t
     <           304*t351*t60*t61+t1813+t1812+t1811+t1810+t1809+t1808+t1
     =           807+t1789+t1780+t1779+t1767+t1766+t1765+t1764+t1757+t17
     >           56+t1755+t1754+t1752+t1751+t1750+t1749+t1748+t1747+t174
     ?           6+t1745+t1744+t1743+t1742+t1741+t1547+t1541
              t1826 = 6.562499999999999d-2*t166*t341*t355*t61
              t1827 = -1.066118247069528d-4*rhoa*t1558*t41*t419*t47*t60*
     1           t61*t797*t798
              t1828 = 5.075783215229239d-5*rhoa*t179*t205*t334*t432*t47*
     1           t51*t52*t60*t61
              t1829 = 4.8579204483835753d-4*rhoa*t166*t415*t57*t60*t61*t
     1           799
              t1830 = -4.8579204483835753d-4*rhoa*t166*t205*t57*t60*t61*
     1           t801
              t1831 = -1.066118247069528d-4*rhob*t102*t1558*t419*t47*t60
     1           *t61*t797*t798
              t1832 = 1/t1**9
              t1833 = t49**6
              t1834 = t51**3
              t1835 = 1.066118247069528d-4*t419*t47*t60*t61*t796*t797*t7
     1           98
              t1836 = 1/t1**8
              t1837 = 6.218138173930978d-2*t1055*t139*t159*t339**3
              t1838 = 1/t140**8.0d+0
              t1839 = 1/t138**8.0d+0
              t1840 = 3.109069086965489d-2*t139*t159*t253*(1.11320274005
     1           88385d-1*t147*t150*t338*t515*t58*t808+8.172647331405554
     2           d-1*t141*t143*t149*t515*t808+3.0326044676184055d-2*t149
     3           *t153*t337*t508*t511*t515*t58-8.172647331405554d-1*t105
     4           4*t141*t143*t149*t337**3*t58-2.0653672341241763d-3*t183
     5           8*t1839*t266*t269*t58-1.5163022338092028d-2*t149*t153*t
     6           266*t508*t511-1.1132027400588385d-1*t147*t150*t266*t337
     7           *t338)
              t1841 = -9.327207260896466d-2*t139*t159*t339*t518*t811
              t1842 = t158*(-4.1772388731625737d-6*t1833*t1834*t1836*t47
     1           *t62*t947+2.132236494139056d-4*t1558*t355*t419*t47*t58*
     2           t797*t798-4.897719934731301d-3*t179*t355*t432*t47*t51*t
     3           52+t1835)+4.1772388731625737d-6*rhoa*t1832*t1833*t1834*
     4           t41*t47*t62*t947+4.1772388731625737d-6*rhob*t102*t1832*
     5           t1833*t1834*t47*t62*t947-4.8579204483835753d-4*rhoa*t33
     6           4**3*t42*t57*t62*t945-2.4289602241917876d-4*rhoa*t205*t
     7           42*t57*t62*(-1.2973268971238278d+0*gammaaa*t29*t332**3*
     8           t34*t944+1.2973268971238278d+0*t29*t34*t412*t800+2.8050
     9           951300015636d-1*gammaaa*t32*t333*t412*t800+1.2130417870
     :           473628d-1*gammaaa*t332*t34*t37*t409*t412-6.065208935236
     ;           814d-2*t212*t34*t37*t409-2.8050951300015636d-1*t212*t32
     <           *t332*t333-1.3114264480597482d-2*gammaaa*t212*t213/t28*
     =           *8.0d+0)+9.327207260896466d-2*t139*t253*t336*t811-9.327
     >           207260896466d-2*t139*t336*t518*t806+9.327207260896466d-
     ?           2*t139*t253*t339*t805+7.286880672575363d-4*rhoa*t334*t4
     @           15*t42*t57*t62*t801+3.806837411421929d-5*rhoa*t176*t179
     1           *t205*t47*t51*t52*t62*t801-9.715840896767151d-4*rhoa*t1
     2           63*t205*t355*t57*t58*t801-3.806837411421929d-5*rhoa*t17
     3           6*t179*t415*t47*t51*t52*t62*t799+9.715840896767151d-4*r
     4           hoa*t163*t355*t415*t57*t58*t799-2.485976463760278d-6*rh
     5           oa*t205*t334*t419*t47*t62*t796*t797*t798-2.132236494139
     6           056d-4*rhoa*t1565*t355*t41*t419*t47*t58*t797*t798-2.132
     7           236494139056d-4*rhob*t102*t1565*t355*t419*t47*t58*t797*
     8           t798+1.0151566430458478d-4*rhoa*t179*t205*t334*t355*t47
     9           *t51*t52*t58*t673+4.897719934731301d-3*rhoa*t179*t355*t
     :           41*t47*t51*t52*t673+4.897719934731301d-3*rhob*t102*t179
     ;           *t355*t47*t51*t52*t673-1.4573761345150726d-3*rhoa*t163*
     <           t205*t334*t355*t57+t1841+t1840+t1837+t1831+t1830+t1829+
     =           t1828+t1827
              t1843 = 3.2812499999999994d-2*t160*t163*t856
              t1844 = 1.3124999999999998d-1*t166*t341*t355*t61
              t1845 = 4.264472988278112d-4*rhoa*t1565*t355*t41*t419*t47*
     1           t50*t58*t798*t820
              t1846 = -1.0151566430458478d-4*rhoa*t179*t205*t334*t355*t4
     1           7*t49*t50*t51*t58*t673
              t1847 = -3.2651466231542003d-3*rhoa*t179*t355*t41*t47*t49*
     1           t50*t51*t673
              t1848 = 6.530293246308401d-3*rhoa*t179*t355*t41*t47*t51*t5
     1           2*t673
              t1849 = -1.9431681793534303d-3*rhoa*t163*t205*t334*t355*t5
     1           7
              t1850 = 4.264472988278112d-4*rhob*t102*t1565*t355*t419*t47
     1           *t50*t58*t798*t820
              t1851 = -3.2651466231542003d-3*rhob*t102*t179*t355*t47*t49
     1           *t50*t51*t673
              t1852 = 6.530293246308401d-3*rhob*t102*t179*t355*t47*t51*t
     1           52*t673
              t1853 = t49**5
              t1854 = -4.264472988278112d-4*t1558*t355*t419*t47*t50*t58*
     1           t798*t820
              t1855 = 3.2651466231542003d-3*t179*t355*t432*t47*t49*t50*t
     1           51
              t1856 = -6.530293246308401d-3*t179*t355*t432*t47*t51*t52
              t1857 = -3.109069086965489d-2*t139*t344*t518*t806
              t1858 = 3.109069086965489d-2*t139*t253*t344*t811
              t1859 = 4.043472623491207d-2*t149*t153*t337*t508*t511*t515
     1           *t58
              t1860 = -1.4842703200784513d-1*t147*t150*t266*t337*t338
              t1861 = 3.109069086965489d-2*t139*t159*t253*(7.42135160039
     1           2256d-2*t147*t150*t338*t515*t58*t808-8.172647331405554d
     2           -1*t1054*t141*t143*t149*t345*t58*t808+5.4484315