//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataboxedge

import "time"

// ARMBaseModel - Represents the base class for all object models.
type ARMBaseModel struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// Addon - Role Addon
type Addon struct {
	// REQUIRED; Addon type.
	Kind *AddonType

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Addon
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetAddon implements the AddonClassification interface for type Addon.
func (a *Addon) GetAddon() *Addon { return a }

// AddonList - Collection of all the Role addon on the Azure Stack Edge device.
type AddonList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The Value.
	Value []AddonClassification
}

// Address - The shipping address of the customer.
type Address struct {
	// REQUIRED; The country name.
	Country *string

	// The address line1.
	AddressLine1 *string

	// The address line2.
	AddressLine2 *string

	// The address line3.
	AddressLine3 *string

	// The city name.
	City *string

	// The postal code.
	PostalCode *string

	// The state name.
	State *string
}

// Alert on the data box edge/gateway device.
type Alert struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Properties of alert.
	Properties *AlertProperties

	// READ-ONLY; Metadata pertaining to creation and last modification of Alert
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// AlertErrorDetails - Error details for the alert.
type AlertErrorDetails struct {
	// READ-ONLY; Error code.
	ErrorCode *string

	// READ-ONLY; Error Message.
	ErrorMessage *string

	// READ-ONLY; Number of occurrences.
	Occurrences *int32
}

// AlertList - Collection of alerts.
type AlertList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The value.
	Value []*Alert
}

// AlertProperties - Properties of alert.
type AlertProperties struct {
	// READ-ONLY; Alert type.
	AlertType *string

	// READ-ONLY; UTC time when the alert appeared.
	AppearedAtDateTime *time.Time

	// READ-ONLY; Alert details.
	DetailedInformation map[string]*string

	// READ-ONLY; Error details of the alert.
	ErrorDetails *AlertErrorDetails

	// READ-ONLY; Alert recommendation.
	Recommendation *string

	// READ-ONLY; Severity of the alert.
	Severity *AlertSeverity

	// READ-ONLY; Alert title.
	Title *string
}

// ArcAddon - Arc Addon.
type ArcAddon struct {
	// REQUIRED; Addon type.
	Kind *AddonType

	// REQUIRED; Properties specific to Arc addon.
	Properties *ArcAddonProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Addon
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetAddon implements the AddonClassification interface for type ArcAddon.
func (a *ArcAddon) GetAddon() *Addon {
	return &Addon{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ArcAddonProperties - Arc addon properties.
type ArcAddonProperties struct {
	// REQUIRED; Arc resource group name
	ResourceGroupName *string

	// REQUIRED; Arc resource location
	ResourceLocation *string

	// REQUIRED; Arc resource Name
	ResourceName *string

	// REQUIRED; Arc resource subscription Id
	SubscriptionID *string

	// READ-ONLY; Host OS supported by the Arc addon.
	HostPlatform *PlatformType

	// READ-ONLY; Platform where the runtime is hosted.
	HostPlatformType *HostPlatformType

	// READ-ONLY; Addon Provisioning State
	ProvisioningState *AddonState

	// READ-ONLY; Arc resource version
	Version *string
}

// AsymmetricEncryptedSecret - Represent the secrets intended for encryption with asymmetric key pair.
type AsymmetricEncryptedSecret struct {
	// REQUIRED; The algorithm used to encrypt "Value".
	EncryptionAlgorithm *EncryptionAlgorithm

	// REQUIRED; The value of the secret.
	Value *string

	// Thumbprint certificate used to encrypt \"Value\". If the value is unencrypted, it will be null.
	EncryptionCertThumbprint *string
}

// Authentication mechanism for IoT devices.
type Authentication struct {
	// Symmetric key for authentication.
	SymmetricKey *SymmetricKey
}

// AzureContainerInfo - Azure container mapping of the endpoint.
type AzureContainerInfo struct {
	// REQUIRED; Container name (Based on the data format specified, this represents the name of Azure Files/Page blob/Block blob).
	ContainerName *string

	// REQUIRED; Storage format used for the file represented by the share.
	DataFormat *AzureContainerDataFormat

	// REQUIRED; ID of the storage account credential used to access storage.
	StorageAccountCredentialID *string
}

// BandwidthSchedule - The bandwidth schedule details.
type BandwidthSchedule struct {
	// REQUIRED; The properties of the bandwidth schedule.
	Properties *BandwidthScheduleProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of BandwidthSchedule
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// BandwidthScheduleProperties - The properties of the bandwidth schedule.
type BandwidthScheduleProperties struct {
	// REQUIRED; The days of the week when this schedule is applicable.
	Days []*DayOfWeek

	// REQUIRED; The bandwidth rate in Mbps.
	RateInMbps *int32

	// REQUIRED; The start time of the schedule in UTC.
	Start *string

	// REQUIRED; The stop time of the schedule in UTC.
	Stop *string
}

// BandwidthSchedulesList - The collection of bandwidth schedules.
type BandwidthSchedulesList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of bandwidth schedules.
	Value []*BandwidthSchedule
}

// ClientAccessRight - The mapping between a particular client IP and the type of access client has on the NFS share.
type ClientAccessRight struct {
	// REQUIRED; Type of access to be allowed for the client.
	AccessPermission *ClientPermissionType

	// REQUIRED; IP of the client.
	Client *string
}

// CloudEdgeManagementRole - The preview of Virtual Machine Cloud Management from the Azure supports deploying and managing
// VMs on your Azure Stack Edge device from Azure Portal. For more information, refer to:
// https://docs.microsoft.com/en-us/azure/databox-online/azure-stack-edge-gpu-virtual-machine-overview By using this feature,
// you agree to the preview legal terms. See the
// https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/ for additional details.
type CloudEdgeManagementRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes

	// Properties specific to CloudEdgeManagementRole role.
	Properties *CloudEdgeManagementRoleProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetRole implements the RoleClassification interface for type CloudEdgeManagementRole.
func (c *CloudEdgeManagementRole) GetRole() *Role {
	return &Role{
		ID:         c.ID,
		Kind:       c.Kind,
		Name:       c.Name,
		SystemData: c.SystemData,
		Type:       c.Type,
	}
}

// CloudEdgeManagementRoleProperties - CloudEdgeManagement Role properties.
type CloudEdgeManagementRoleProperties struct {
	// REQUIRED; Role status.
	RoleStatus *RoleStatus

	// READ-ONLY; Edge Profile of the resource
	EdgeProfile *EdgeProfile

	// READ-ONLY; Local Edge Management Status
	LocalManagementStatus *RoleStatus
}

// ClusterCapacityViewData - Cluster Compute Data.
type ClusterCapacityViewData struct {
	// The FQDN of the cluster.
	Fqdn *string

	// The cluster's GPU capacity.
	GpuCapacity *ClusterGpuCapacity

	// The last time at which the ClusterCapacityViewData was set.
	LastRefreshedTime *time.Time

	// The cluster's memory capacity.
	MemoryCapacity *ClusterMemoryCapacity

	// The total # of vCPUs provisioned by non-HPN VM per appliance.
	TotalProvisionedNonHpnCores *int64
}

// ClusterGpuCapacity - Cluster GPU Data.
type ClusterGpuCapacity struct {
	// The free GPU units count in the cluster.
	GpuFreeUnitsCount *int32

	// The GPU units count reserved for failover in the cluster.
	GpuReservedForFailoverUnitsCount *int32

	// The total GPU units count in the cluster.
	GpuTotalUnitsCount *int32

	// The cluster GPU Type.
	GpuType *string

	// The used GPU units count in the cluster.
	GpuUsedUnitsCount *int32
}

// ClusterMemoryCapacity - NodeCapacityInfo defines the required information to determine the placement of a VM.
type ClusterMemoryCapacity struct {
	// The failover memory in the cluster in MB.
	ClusterFailoverMemoryMb *float64

	// The fragmentation memory in the cluster in MB.
	ClusterFragmentationMemoryMb *float64

	// The free memory in the cluster in MB.
	ClusterFreeMemoryMb *float64

	// The memory reserved for Hyper-V in the cluster in MB.
	ClusterHypervReserveMemoryMb *float64

	// The memory of the Infra VM in the cluster in MB.
	ClusterInfraVMMemoryMb *float64

	// The memory used by VMs in the cluster in MB.
	ClusterMemoryUsedByVMsMb *float64

	// The non-failover memory in the cluster in MB.
	ClusterNonFailoverVMMb *float64

	// The total memory in the cluster in MB.
	ClusterTotalMemoryMb *float64

	// The used memory in the cluster in MB.
	ClusterUsedMemoryMb *float64
}

// ClusterStorageViewData - Cluster Storage Data.
type ClusterStorageViewData struct {
	// The available or free storage on the cluster in MB.
	ClusterFreeStorageMb *float64

	// Total storage on the cluster in MB.
	ClusterTotalStorageMb *float64
}

// CniConfig - Cni configuration
type CniConfig struct {
	// READ-ONLY; Pod Subnet
	PodSubnet *string

	// READ-ONLY; Service subnet
	ServiceSubnet *string

	// READ-ONLY; Cni type
	Type *string

	// READ-ONLY; Cni version
	Version *string
}

// ComputeResource - Compute infrastructure Resource
type ComputeResource struct {
	// REQUIRED; Memory in GB
	MemoryInGB *int64

	// REQUIRED; Processor count
	ProcessorCount *int32
}

// ContactDetails - Contains all the contact details of the customer.
type ContactDetails struct {
	// REQUIRED; The name of the company.
	CompanyName *string

	// REQUIRED; The contact person name.
	ContactPerson *string

	// REQUIRED; The email list.
	EmailList []*string

	// REQUIRED; The phone number.
	Phone *string
}

// Container - Represents a container on the Data Box Edge/Gateway device.
type Container struct {
	// REQUIRED; The container properties.
	Properties *ContainerProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Container
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// ContainerList - Collection of all the containers on the Data Box Edge/Gateway device.
type ContainerList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of containers.
	Value []*Container
}

// ContainerProperties - The container properties.
type ContainerProperties struct {
	// REQUIRED; DataFormat for Container
	DataFormat *AzureContainerDataFormat

	// READ-ONLY; Current status of the container.
	ContainerStatus *ContainerStatus

	// READ-ONLY; The UTC time when container got created.
	CreatedDateTime *time.Time

	// READ-ONLY; Details of the refresh job on this container.
	RefreshDetails *RefreshDetails
}

// DCAccessCode - DC Access code in the case of Self Managed Shipping.
type DCAccessCode struct {
	// DCAccessCode properties.
	Properties *DCAccessCodeProperties
}

// DCAccessCodeProperties - DCAccessCode Properties.
type DCAccessCodeProperties struct {
	// DCAccess Code for the Self Managed shipment.
	AuthCode *string
}

// DataResidency - Wraps data-residency related information for edge-resource and this should be used with ARM layer.
type DataResidency struct {
	// DataResidencyType enum
	Type *DataResidencyType
}

// Device - The Data Box Edge/Gateway device.
type Device struct {
	// REQUIRED; The location of the device. This is a supported and registered Azure geographical region (for example, West US,
	// East US, or Southeast Asia). The geographical region of a device cannot be changed once
	// it is created, but if an identical geographical region is specified on update, the request will succeed.
	Location *string

	// The etag for the devices.
	Etag *string

	// Msi identity of the resource
	Identity *ResourceIdentity

	// The properties of the Data Box Edge/Gateway device.
	Properties *DeviceProperties

	// The SKU type.
	SKU *SKUInfo

	// The list of tags that describe the device. These tags can be used to view and group this device (across resource groups).
	Tags map[string]*string

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The kind of the device.
	Kind *DataBoxEdgeDeviceKind

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; DataBoxEdge Resource
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// DeviceCapacityInfo - Object for Capturing DeviceCapacityInfo
type DeviceCapacityInfo struct {
	// The device capacity properties.
	Properties *DeviceCapacityInfoProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to device capacity info.
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// DeviceCapacityInfoProperties - The properties of Device Capacity Info
type DeviceCapacityInfoProperties struct {
	// Cluster capacity data for compute resources (Memory and GPU).
	ClusterComputeCapacityInfo *ClusterCapacityViewData

	// Cluster capacity data for storage resources (CSV).
	ClusterStorageCapacityInfo *ClusterStorageViewData

	// The dictionary of individual node names and node capacities in the cluster.
	NodeCapacityInfos map[string]*HostCapacity

	// Timestamp of request in UTC
	TimeStamp *time.Time
}

// DeviceCapacityRequestInfo - Object for Capturing DeviceCapacityRequestInfo
type DeviceCapacityRequestInfo struct {
	// REQUIRED; The properties of the Device Capacity Request.
	Properties *DeviceCapacityRequestInfoProperties
}

// DeviceCapacityRequestInfoProperties - Properties of Device Capacity Request Info containing VM's to be checked and their
// corresponding results.
type DeviceCapacityRequestInfoProperties struct {
	// REQUIRED; Array containing the sizes of the VMs for checking if its feasible to create them on the appliance.
	VMPlacementQuery [][]*string

	// Array of the VMs of the sizes in VmSizes can be provisioned on the appliance.
	VMPlacementResults []*VMPlacementRequestResult
}

// DeviceExtendedInfo - The extended Info of the Data Box Edge/Gateway device.
type DeviceExtendedInfo struct {
	// The extended info properties.
	Properties *DeviceExtendedInfoProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of DataBoxEdgeDevice
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// DeviceExtendedInfoPatch - The Data Box Edge/Gateway device extended info patch.
type DeviceExtendedInfoPatch struct {
	// The name for Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyName *string

	// The version of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyVersion *string

	// The Key Vault ARM Id for client secrets
	ClientSecretStoreID *string

	// The url to access the Client Key Vault
	ClientSecretStoreURL *string

	// For changing or to initiate the resync to key-vault set the status to KeyVaultSyncPending, rest of the status will not
	// be applicable.
	SyncStatus *KeyVaultSyncStatus
}

// DeviceExtendedInfoProperties - The properties of the Data Box Edge/Gateway device extended info.
type DeviceExtendedInfoProperties struct {
	// The name of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyName *string

	// The version of Channel Integrity Key stored in the Client Key Vault
	ChannelIntegrityKeyVersion *string

	// The Key Vault ARM Id for client secrets
	ClientSecretStoreID *string

	// The url to access the Client Key Vault
	ClientSecretStoreURL *string

	// The public part of the encryption certificate. Client uses this to encrypt any secret.
	EncryptionKey *string

	// The digital signature of encrypted certificate.
	EncryptionKeyThumbprint *string

	// Key vault sync status
	KeyVaultSyncStatus *KeyVaultSyncStatus

	// READ-ONLY; The Container for cloud witness in the storage account.
	CloudWitnessContainerName *string

	// READ-ONLY; The Cloud Witness Storage account name.
	CloudWitnessStorageAccountName *string

	// READ-ONLY; The Azure service endpoint of the cloud witness storage account.
	CloudWitnessStorageEndpoint *string

	// READ-ONLY; Cluster Witness Type
	ClusterWitnessType *ClusterWitnessType

	// READ-ONLY; Device secrets, will be returned only with ODataFilter $expand=deviceSecrets
	DeviceSecrets map[string]*Secret

	// READ-ONLY; The witness location of file share.
	FileShareWitnessLocation *string

	// READ-ONLY; The username of file share.
	FileShareWitnessUsername *string

	// READ-ONLY; The Resource ID of the Resource.
	ResourceKey *string
}

// DeviceList - The collection of Data Box Edge/Gateway devices.
type DeviceList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of Data Box Edge/Gateway devices.
	Value []*Device
}

// DevicePatch - The Data Box Edge/Gateway device patch.
type DevicePatch struct {
	// Msi identity of the resource
	Identity *ResourceIdentity

	// The properties associated with the Data Box Edge/Gateway resource
	Properties *DevicePropertiesPatch

	// The tags attached to the Data Box Edge/Gateway resource.
	Tags map[string]*string
}

// DeviceProperties - The properties of the Data Box Edge/Gateway device.
type DeviceProperties struct {
	// The details of data-residency related properties for this resource
	DataResidency *DataResidency

	// READ-ONLY; Type of compute roles configured.
	ConfiguredRoleTypes []*RoleTypes

	// READ-ONLY; The Data Box Edge/Gateway device culture.
	Culture *string

	// READ-ONLY; The status of the Data Box Edge/Gateway device.
	DataBoxEdgeDeviceStatus *DataBoxEdgeDeviceStatus

	// READ-ONLY; The Description of the Data Box Edge/Gateway device.
	Description *string

	// READ-ONLY; The device software version number of the device (eg: 1.2.18105.6).
	DeviceHcsVersion *string

	// READ-ONLY; The Data Box Edge/Gateway device local capacity in MB.
	DeviceLocalCapacity *int64

	// READ-ONLY; The Data Box Edge/Gateway device model.
	DeviceModel *string

	// READ-ONLY; The Data Box Edge/Gateway device software version.
	DeviceSoftwareVersion *string

	// READ-ONLY; The type of the Data Box Edge/Gateway device.
	DeviceType *DeviceType

	// READ-ONLY; The details of Edge Profile for this resource
	EdgeProfile *EdgeProfile

	// READ-ONLY; The Data Box Edge/Gateway device name.
	FriendlyName *string

	// READ-ONLY; The description of the Data Box Edge/Gateway device model.
	ModelDescription *string

	// READ-ONLY; The number of nodes in the cluster.
	NodeCount *int32

	// READ-ONLY; The details of the move operation on this resource.
	ResourceMoveDetails *ResourceMoveDetails

	// READ-ONLY; The Serial Number of Data Box Edge/Gateway device.
	SerialNumber *string

	// READ-ONLY; DataBoxEdge Device Properties
	SystemData *SystemData

	// READ-ONLY; The Data Box Edge/Gateway device timezone.
	TimeZone *string
}

// DevicePropertiesPatch - The Data Box Edge/Gateway device properties patch.
type DevicePropertiesPatch struct {
	// Edge Profile property of the Data Box Edge/Gateway device
	EdgeProfile *EdgeProfilePatch
}

// DiagnosticProactiveLogCollectionSettings - The diagnostic proactive log collection settings of a device.
type DiagnosticProactiveLogCollectionSettings struct {
	// REQUIRED; Properties of the diagnostic proactive log collection settings.
	Properties *ProactiveLogCollectionSettingsProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of DiagnosticProactiveLogCollectionSettings
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// DiagnosticRemoteSupportSettings - The remote support settings of a device.
type DiagnosticRemoteSupportSettings struct {
	// REQUIRED; Properties of the remote support settings.
	Properties *DiagnosticRemoteSupportSettingsProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Represents resource creation and updation time
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// DiagnosticRemoteSupportSettingsProperties - The properties of remote support settings.
type DiagnosticRemoteSupportSettingsProperties struct {
	// Remote support settings list according to the RemoteApplicationType
	RemoteSupportSettingsList []*RemoteSupportSettings
}

// EdgeProfile - Details about Edge Profile for the resource
type EdgeProfile struct {
	// Edge Profile Subscription
	Subscription *EdgeProfileSubscription
}

// EdgeProfilePatch - The Data Box Edge/Gateway Edge Profile patch.
type EdgeProfilePatch struct {
	// The Data Box Edge/Gateway Edge Profile Subscription patch
	Subscription *EdgeProfileSubscriptionPatch
}

// EdgeProfileSubscription - Subscription details for the Edge Profile
type EdgeProfileSubscription struct {
	// ARM ID of the subscription
	ID               *string
	Properties       *SubscriptionProperties
	RegistrationDate *string

	// Edge Subscription Registration ID
	RegistrationID *string
	State          *SubscriptionState
	SubscriptionID *string
}

// EdgeProfileSubscriptionPatch - The Data Box Edge/Gateway Edge Profile Subscription patch.
type EdgeProfileSubscriptionPatch struct {
	// The path ID that uniquely identifies the subscription of the edge profile.
	ID *string
}

// EtcdInfo - Etcd configuration
type EtcdInfo struct {
	// READ-ONLY; Etcd type
	Type *string

	// READ-ONLY; Etcd version
	Version *string
}

// FileEventTrigger - Trigger details.
type FileEventTrigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType

	// REQUIRED; File trigger properties.
	Properties *FileTriggerProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Trigger
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetTrigger implements the TriggerClassification interface for type FileEventTrigger.
func (f *FileEventTrigger) GetTrigger() *Trigger {
	return &Trigger{
		ID:         f.ID,
		Kind:       f.Kind,
		Name:       f.Name,
		SystemData: f.SystemData,
		Type:       f.Type,
	}
}

// FileSourceInfo - File source details.
type FileSourceInfo struct {
	// REQUIRED; File share ID.
	ShareID *string
}

// FileTriggerProperties - File trigger properties.
type FileTriggerProperties struct {
	// REQUIRED; Role sink info.
	SinkInfo *RoleSinkInfo

	// REQUIRED; File event source details.
	SourceInfo *FileSourceInfo

	// A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger
	// is intended for certain specific IoT modules in the device, the tag can be the
	// name or the image URL of the module.
	CustomContextTag *string
}

// GenerateCertResponse - Used in activation key generation flow.
type GenerateCertResponse struct {
	// Gets or sets expiry time in UTC
	ExpiryTimeInUTC *string

	// Gets or sets base64 encoded private part of the certificate, needed to form the activation key
	PrivateKey *string

	// Gets or sets base64 encoded certificate raw data, this is the public part needed to be uploaded to cert vault
	PublicKey *string
}

// HostCapacity - Host Capacity Data.
type HostCapacity struct {
	// The available amount of GPUs on the host to use after accounting for GPUS used by reservations on the host.
	AvailableGpuCount *int32

	// The available memory on the host accounting for VM placement size and any host VM reservations.
	EffectiveAvailableMemoryMbOnHost *int64

	// The GPU type of the VM.
	GpuType *string

	// The name of the host.
	HostName *string

	// The numa nodes information for Hpn VMs.
	NumaNodesData []*NumaNodeData

	// The VM used memory per VmId.
	VMUsedMemory map[string]*VMMemory
}

// IPv4Config - Details related to the IPv4 address configuration.
type IPv4Config struct {
	// READ-ONLY; The IPv4 gateway of the network adapter.
	Gateway *string

	// READ-ONLY; The IPv4 address of the network adapter.
	IPAddress *string

	// READ-ONLY; The IPv4 subnet of the network adapter.
	Subnet *string
}

// IPv6Config - Details related to the IPv6 address configuration.
type IPv6Config struct {
	// READ-ONLY; The IPv6 gateway of the network adapter.
	Gateway *string

	// READ-ONLY; The IPv6 address of the network adapter.
	IPAddress *string

	// READ-ONLY; The IPv6 prefix of the network adapter.
	PrefixLength *int32
}

// ImageRepositoryCredential - Image repository credential.
type ImageRepositoryCredential struct {
	// REQUIRED; Image repository url (e.g.: mcr.microsoft.com).
	ImageRepositoryURL *string

	// REQUIRED; Repository user name.
	UserName *string

	// Repository user password.
	Password *AsymmetricEncryptedSecret
}

// IoTAddon - IoT Addon.
type IoTAddon struct {
	// REQUIRED; Addon type.
	Kind *AddonType

	// REQUIRED; Properties specific to IOT addon.
	Properties *IoTAddonProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Addon
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetAddon implements the AddonClassification interface for type IoTAddon.
func (i *IoTAddon) GetAddon() *Addon {
	return &Addon{
		ID:         i.ID,
		Kind:       i.Kind,
		Name:       i.Name,
		SystemData: i.SystemData,
		Type:       i.Type,
	}
}

// IoTAddonProperties - IoT addon properties.
type IoTAddonProperties struct {
	// REQUIRED; IoT device metadata to which appliance needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo

	// REQUIRED; IoT edge device to which the IoT Addon needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo

	// READ-ONLY; Host OS supported by the IoT addon.
	HostPlatform *PlatformType

	// READ-ONLY; Platform where the runtime is hosted.
	HostPlatformType *HostPlatformType

	// READ-ONLY; Addon Provisioning State
	ProvisioningState *AddonState

	// READ-ONLY; Version of IoT running on the appliance.
	Version *string
}

// IoTDeviceInfo - Metadata of IoT device/IoT Edge device to be configured.
type IoTDeviceInfo struct {
	// REQUIRED; ID of the IoT device/edge device.
	DeviceID *string

	// REQUIRED; Host name for the IoT hub associated to the device.
	IoTHostHub *string

	// Encrypted IoT device/IoT edge device connection string.
	Authentication *Authentication

	// Id for the IoT hub associated to the device.
	IoTHostHubID *string
}

// IoTEdgeAgentInfo - IoT edge agent details is optional, this will be used for download system Agent module while bootstrapping
// IoT Role if specified.
type IoTEdgeAgentInfo struct {
	// REQUIRED; Name of the IoT edge agent image.
	ImageName *string

	// REQUIRED; Image Tag.
	Tag *string

	// Image repository details.
	ImageRepository *ImageRepositoryCredential
}

// IoTRole - Compute role.
type IoTRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes

	// Properties specific to IoT role.
	Properties *IoTRoleProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetRole implements the RoleClassification interface for type IoTRole.
func (i *IoTRole) GetRole() *Role {
	return &Role{
		ID:         i.ID,
		Kind:       i.Kind,
		Name:       i.Name,
		SystemData: i.SystemData,
		Type:       i.Type,
	}
}

// IoTRoleProperties - IoT role properties.
type IoTRoleProperties struct {
	// REQUIRED; Host OS supported by the IoT role.
	HostPlatform *PlatformType

	// REQUIRED; IoT device metadata to which data box edge device needs to be connected.
	IoTDeviceDetails *IoTDeviceInfo

	// REQUIRED; IoT edge device to which the IoT role needs to be configured.
	IoTEdgeDeviceDetails *IoTDeviceInfo

	// REQUIRED; Role status.
	RoleStatus *RoleStatus

	// Resource allocation
	ComputeResource *ComputeResource

	// Iot edge agent details to download the agent and bootstrap iot runtime.
	IoTEdgeAgentInfo *IoTEdgeAgentInfo

	// Mount points of shares in role(s).
	ShareMappings []*MountPointMap

	// READ-ONLY; Platform where the Iot runtime is hosted.
	HostPlatformType *HostPlatformType
}

// Job - A device job.
type Job struct {
	// READ-ONLY; The UTC date and time at which the job completed.
	EndTime *time.Time

	// READ-ONLY; The error details.
	Error *JobErrorDetails

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The name of the object.
	Name *string

	// READ-ONLY; The percentage of the job that is complete.
	PercentComplete *int32

	// READ-ONLY; The properties of the job.
	Properties *JobProperties

	// READ-ONLY; The UTC date and time at which the job started.
	StartTime *time.Time

	// READ-ONLY; The current status of the job.
	Status *JobStatus

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// JobErrorDetails - The job error information containing the list of job errors.
type JobErrorDetails struct {
	// READ-ONLY; The code intended for programmatic access.
	Code *string

	// READ-ONLY; The error details.
	ErrorDetails []*JobErrorItem

	// READ-ONLY; The message that describes the error in detail.
	Message *string
}

// JobErrorItem - The job error items.
type JobErrorItem struct {
	// READ-ONLY; The code intended for programmatic access.
	Code *string

	// READ-ONLY; The message that describes the error in detail.
	Message *string

	// READ-ONLY; The recommended actions.
	Recommendations []*string
}

// JobProperties - The properties for the job.
type JobProperties struct {
	// If only subfolders need to be refreshed, then the subfolder path inside the share or container. (The path is empty if there
	// are no subfolders.)
	Folder *string

	// READ-ONLY; Current stage of the update operation.
	CurrentStage *UpdateOperationStage

	// READ-ONLY; The download progress.
	DownloadProgress *UpdateDownloadProgress

	// READ-ONLY; Local share/remote container relative path to the error manifest file of the refresh.
	ErrorManifestFile *string

	// READ-ONLY; The install progress.
	InstallProgress *UpdateInstallProgress

	// READ-ONLY; The type of the job.
	JobType *JobType

	// READ-ONLY; ARM ID of the entity that was refreshed.
	RefreshedEntityID *string

	// READ-ONLY; Total number of errors encountered during the refresh process.
	TotalRefreshErrors *int32
}

// KubernetesClusterInfo - Kubernetes cluster configuration
type KubernetesClusterInfo struct {
	// REQUIRED; Kubernetes cluster version
	Version *string

	// READ-ONLY; Etcd configuration
	EtcdInfo *EtcdInfo

	// READ-ONLY; Kubernetes cluster nodes
	Nodes []*NodeInfo
}

// KubernetesIPConfiguration - Kubernetes node IP configuration
type KubernetesIPConfiguration struct {
	// IP address of the Kubernetes node.
	IPAddress *string

	// READ-ONLY; Port of the Kubernetes node.
	Port *string
}

// KubernetesRole - The limited preview of Kubernetes Cluster Management from the Azure supports:
// 1. Using a simple turn-key option in Azure Portal, deploy a Kubernetes cluster on your Azure Stack Edge device.
// 2. Configure Kubernetes cluster running on your device with Arc enabled Kubernetes with a click of a button in the Azure
// Portal. Azure Arc enables organizations to view, manage, and govern their
// on-premises Kubernetes clusters using the Azure Portal, command line tools, and APIs.
// 3. Easily configure Persistent Volumes using SMB and NFS shares for storing container data. For more information, refer
// to the document here:
// https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8-Cloud-Management-20210323.pdf
// Or Demo:
// https://databoxupdatepackages.blob.core.windows.net/documentation/Microsoft-Azure-Stack-Edge-K8S-Cloud-Management-20210323.mp4
// By using this feature, you agree to the preview legal terms. See the
// https://azure.microsoft.com/en-us/support/legal/preview-supplemental-terms/
type KubernetesRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes

	// Properties specific to Kubernetes role.
	Properties *KubernetesRoleProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetRole implements the RoleClassification interface for type KubernetesRole.
func (k *KubernetesRole) GetRole() *Role {
	return &Role{
		ID:         k.ID,
		Kind:       k.Kind,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KubernetesRoleCompute - Kubernetes role compute resource
type KubernetesRoleCompute struct {
	// REQUIRED; VM profile
	VMProfile *string

	// READ-ONLY; Memory in bytes
	MemoryInBytes *int64

	// READ-ONLY; Processor count
	ProcessorCount *int32
}

// KubernetesRoleNetwork - Kubernetes role network resource
type KubernetesRoleNetwork struct {
	// READ-ONLY; Cni configuration
	CniConfig *CniConfig

	// READ-ONLY; Load balancer configuration
	LoadBalancerConfig *LoadBalancerConfig
}

// KubernetesRoleProperties - Kubernetes role properties.
type KubernetesRoleProperties struct {
	// REQUIRED; Host OS supported by the Kubernetes role.
	HostPlatform *PlatformType

	// REQUIRED; Kubernetes cluster configuration
	KubernetesClusterInfo *KubernetesClusterInfo

	// REQUIRED; Kubernetes role resources
	KubernetesRoleResources *KubernetesRoleResources

	// REQUIRED; Role status.
	RoleStatus *RoleStatus

	// READ-ONLY; Platform where the runtime is hosted.
	HostPlatformType *HostPlatformType

	// READ-ONLY; State of Kubernetes deployment
	ProvisioningState *KubernetesState
}

// KubernetesRoleResources - Kubernetes role resources
type KubernetesRoleResources struct {
	// REQUIRED; Kubernetes role compute resource
	Compute *KubernetesRoleCompute

	// Kubernetes role storage resource
	Storage *KubernetesRoleStorage

	// READ-ONLY; Kubernetes role network resource
	Network *KubernetesRoleNetwork
}

// KubernetesRoleStorage - Kubernetes role storage resource
type KubernetesRoleStorage struct {
	// Mount points of shares in role(s).
	Endpoints []*MountPointMap

	// READ-ONLY; Kubernetes storage class info.
	StorageClasses []*KubernetesRoleStorageClassInfo
}

// KubernetesRoleStorageClassInfo - Kubernetes storage class info.
type KubernetesRoleStorageClassInfo struct {
	// READ-ONLY; Storage class name.
	Name *string

	// READ-ONLY; If provisioned storage is posix compliant.
	PosixCompliant *PosixComplianceStatus

	// READ-ONLY; Storage class type.
	Type *string
}

// LoadBalancerConfig - Load balancer configuration
type LoadBalancerConfig struct {
	// READ-ONLY; Load balancer type
	Type *string

	// READ-ONLY; Load balancer version
	Version *string
}

// MECRole - MEC role.
type MECRole struct {
	// REQUIRED; Role type.
	Kind *RoleTypes

	// Properties specific to MEC role.
	Properties *MECRoleProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetRole implements the RoleClassification interface for type MECRole.
func (m *MECRole) GetRole() *Role {
	return &Role{
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MECRoleProperties - MEC role properties.
type MECRoleProperties struct {
	// REQUIRED; Role status.
	RoleStatus *RoleStatus

	// Activation key of the MEC.
	ConnectionString *AsymmetricEncryptedSecret

	// Controller Endpoint.
	ControllerEndpoint *string

	// Unique Id of the Resource.
	ResourceUniqueID *string
}

// MetricConfiguration - Metric configuration.
type MetricConfiguration struct {
	// REQUIRED; Host name for the IoT hub associated to the device.
	CounterSets []*MetricCounterSet

	// REQUIRED; The Resource ID on which the metrics should be pushed.
	ResourceID *string

	// The MDM account to which the counters should be pushed.
	MdmAccount *string

	// The MDM namespace to which the counters should be pushed. This is required if MDMAccount is specified
	MetricNameSpace *string
}

// MetricCounter - The metric counter
type MetricCounter struct {
	// REQUIRED; The counter name.
	Name *string

	// The additional dimensions to be added to metric.
	AdditionalDimensions []*MetricDimension

	// The dimension filter.
	DimensionFilter []*MetricDimension

	// The instance from which counter should be collected.
	Instance *string
}

// MetricCounterSet - The metric counter set
type MetricCounterSet struct {
	// REQUIRED; The counters that should be collected in this set.
	Counters []*MetricCounter
}

// MetricDimension - The metric dimension
type MetricDimension struct {
	// REQUIRED; The dimension value.
	SourceName *string

	// REQUIRED; The dimension type.
	SourceType *string
}

// MetricDimensionV1 - Metric Dimension v1.
type MetricDimensionV1 struct {
	// Display name of the metrics dimension.
	DisplayName *string

	// Name of the metrics dimension.
	Name *string

	// To be exported to shoe box.
	ToBeExportedForShoebox *bool
}

// MetricSpecificationV1 - Metric specification version 1.
type MetricSpecificationV1 struct {
	// Metric aggregation type.
	AggregationType *MetricAggregationType

	// Metric category.
	Category *MetricCategory

	// Metric dimensions, other than default dimension which is resource.
	Dimensions []*MetricDimensionV1

	// Description of the metric to be displayed.
	DisplayDescription *string

	// Display name of the metric.
	DisplayName *string

	// Set true to fill the gaps with zero.
	FillGapWithZero *bool

	// Name of the metric.
	Name *string

	// Resource name override.
	ResourceIDDimensionNameOverride *string

	// Support metric aggregation type.
	SupportedAggregationTypes []*MetricAggregationType

	// Support granularity of metrics.
	SupportedTimeGrainTypes []*TimeGrain

	// Metric units.
	Unit *MetricUnit
}

// MonitoringMetricConfiguration - The metric setting details for the role
type MonitoringMetricConfiguration struct {
	// REQUIRED; The metric setting properties.
	Properties *MonitoringMetricConfigurationProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of MonitoringConfiguration
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// MonitoringMetricConfigurationList - Collection of metric configurations.
type MonitoringMetricConfigurationList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of metric configurations.
	Value []*MonitoringMetricConfiguration
}

// MonitoringMetricConfigurationProperties - Metrics properties
type MonitoringMetricConfigurationProperties struct {
	// REQUIRED; The metrics configuration details
	MetricConfigurations []*MetricConfiguration
}

// MountPointMap - The share mount point.
type MountPointMap struct {
	// REQUIRED; ID of the share mounted to the role VM.
	ShareID *string

	// READ-ONLY; Mount point for the share.
	MountPoint *string

	// READ-ONLY; Mounting type.
	MountType *MountType

	// READ-ONLY; ID of the role to which share is mounted.
	RoleID *string

	// READ-ONLY; Role type.
	RoleType *RoleTypes
}

// MoveRequest - Resource Move details
type MoveRequest struct {
	// REQUIRED; List of resources to be moved
	Resources []*string

	// REQUIRED; Target resource group ARMId
	TargetResourceGroup *string
}

// NetworkAdapter - Represents the networkAdapter on a device.
type NetworkAdapter struct {
	// Value indicating whether this adapter has DHCP enabled.
	DhcpStatus *NetworkAdapterDHCPStatus

	// Value indicating whether this adapter is RDMA capable.
	RdmaStatus *NetworkAdapterRDMAStatus

	// READ-ONLY; Instance ID of network adapter.
	AdapterID *string

	// READ-ONLY; Hardware position of network adapter.
	AdapterPosition *NetworkAdapterPosition

	// READ-ONLY; The list of DNS Servers of the device.
	DNSServers []*string

	// READ-ONLY; The IPv4 configuration of the network adapter.
	IPv4Configuration *IPv4Config

	// READ-ONLY; The IPv6 configuration of the network adapter.
	IPv6Configuration *IPv6Config

	// READ-ONLY; The IPv6 local address.
	IPv6LinkLocalAddress *string

	// READ-ONLY; Logical index of the adapter.
	Index *int32

	// READ-ONLY; Hardware label for the adapter.
	Label *string

	// READ-ONLY; Link speed.
	LinkSpeed *int64

	// READ-ONLY; MAC address.
	MacAddress *string

	// READ-ONLY; Network adapter name.
	NetworkAdapterName *string

	// READ-ONLY; Node ID of the network adapter.
	NodeID *string

	// READ-ONLY; Value indicating whether this adapter is valid.
	Status *NetworkAdapterStatus
}

// NetworkAdapterPosition - The network adapter position.
type NetworkAdapterPosition struct {
	// READ-ONLY; The network group.
	NetworkGroup *NetworkGroup

	// READ-ONLY; The port.
	Port *int32
}

// NetworkSettings - The network settings of a device.
type NetworkSettings struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; The properties of network settings of a device.
	Properties *NetworkSettingsProperties

	// READ-ONLY; Metadata pertaining to creation and last modification of NetworkSettings
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// NetworkSettingsProperties - The properties of network settings.
type NetworkSettingsProperties struct {
	// READ-ONLY; The network adapter list on the device.
	NetworkAdapters []*NetworkAdapter
}

// Node - Represents a single node in a Data box Edge/Gateway device Gateway devices, standalone Edge devices and a single
// node cluster Edge device will all have 1 node Multi-node Edge devices will have more
// than 1 nodes
type Node struct {
	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; The properties of the node
	Properties *NodeProperties

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// NodeInfo - Kubernetes node info
type NodeInfo struct {
	// IP Configuration of the Kubernetes node.
	IPConfiguration []*KubernetesIPConfiguration

	// READ-ONLY; Node name.
	Name *string

	// READ-ONLY; Node type - Master/Worker
	Type *KubernetesNodeType
}

// NodeList - Collection of Nodes.
type NodeList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of Nodes.
	Value []*Node
}

// NodeProperties - This class represents the nodes in a highly available cluster
type NodeProperties struct {
	// READ-ONLY; Serial number of the Chassis
	NodeChassisSerialNumber *string

	// READ-ONLY; Display Name of the individual node
	NodeDisplayName *string

	// READ-ONLY; Friendly software version name that is currently installed on the node
	NodeFriendlySoftwareVersion *string

	// READ-ONLY; HCS version that is currently installed on the node
	NodeHcsVersion *string

	// READ-ONLY; Guid instance id of the node
	NodeInstanceID *string

	// READ-ONLY; Serial number of the individual node
	NodeSerialNumber *string

	// READ-ONLY; The current status of the individual node
	NodeStatus *NodeStatus
}

// NumaNodeData - NUMA node data.
type NumaNodeData struct {
	// The effective available memory on the NUMA node in MB.
	EffectiveAvailableMemoryInMb *int64

	// The free VCPU indices for the Hpn VMs.
	FreeVCPUIndexesForHpn []*int32

	// The logical cores per core count.
	LogicalCoreCountPerCore *int32

	// The NUMA node index.
	NumaNodeIndex *int32

	// The total memory on the NUMA node.
	TotalMemoryInMb *int64

	// The VCPU indices for Hpn VMs
	VCPUIndexesForHpn []*int32

	// The VCPU indices for the root.
	VCPUIndexesForRoot []*int32
}

// Operations.
type Operation struct {
	// Properties displayed for the operation.
	Display *OperationDisplay

	// Is data action.
	IsDataAction *bool

	// Name of the operation.
	Name *string

	// Origin of the operation.
	Origin *string

	// Operation properties.
	Properties *OperationProperties
}

// OperationDisplay - Operation display properties.
type OperationDisplay struct {
	// Description of the operation to be performed.
	Description *string

	// Operation to be performed on the resource.
	Operation *string

	// Provider name.
	Provider *string

	// The type of resource in which the operation is performed.
	Resource *string
}

// OperationProperties - Operation properties.
type OperationProperties struct {
	// Service specification.
	ServiceSpecification *ServiceSpecification
}

// OperationsList - The list of operations used for the discovery of available provider operations.
type OperationsList struct {
	// REQUIRED; The value.
	Value []*Operation

	// Link to the next set of results.
	NextLink *string
}

// Order - The order details.
type Order struct {
	// The order properties.
	Properties *OrderProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; It specify the order api version.
	Kind *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Order
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// OrderList - List of order entities.
type OrderList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of orders.
	Value []*Order
}

// OrderProperties - Order properties.
type OrderProperties struct {
	// REQUIRED; The contact details.
	ContactInformation *ContactDetails

	// ShipmentType of the order
	ShipmentType *ShipmentType

	// The shipping address.
	ShippingAddress *Address

	// READ-ONLY; Current status of the order.
	CurrentStatus *OrderStatus

	// READ-ONLY; Tracking information for the package delivered to the customer whether it has an original or a replacement device.
	DeliveryTrackingInfo []*TrackingInfo

	// READ-ONLY; List of status changes in the order.
	OrderHistory []*OrderStatus

	// READ-ONLY; It specify the order resource id.
	OrderID *string

	// READ-ONLY; Tracking information for the package returned from the customer whether it has an original or a replacement
	// device.
	ReturnTrackingInfo []*TrackingInfo

	// READ-ONLY; Serial number of the device.
	SerialNumber *string
}

// OrderStatus - Represents a single status change.
type OrderStatus struct {
	// REQUIRED; Status of the order as per the allowed status types.
	Status *OrderState

	// Comments related to this status change.
	Comments *string

	// READ-ONLY; Dictionary to hold generic information which is not stored by the already existing properties
	AdditionalOrderDetails map[string]*string

	// READ-ONLY; Tracking information related to the state in the ordering flow
	TrackingInformation *TrackingInfo

	// READ-ONLY; Time of status update.
	UpdateDateTime *time.Time
}

// PeriodicTimerEventTrigger - Trigger details.
type PeriodicTimerEventTrigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType

	// REQUIRED; Periodic timer trigger properties.
	Properties *PeriodicTimerProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Trigger
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetTrigger implements the TriggerClassification interface for type PeriodicTimerEventTrigger.
func (p *PeriodicTimerEventTrigger) GetTrigger() *Trigger {
	return &Trigger{
		ID:         p.ID,
		Kind:       p.Kind,
		Name:       p.Name,
		SystemData: p.SystemData,
		Type:       p.Type,
	}
}

// PeriodicTimerProperties - Periodic timer trigger properties.
type PeriodicTimerProperties struct {
	// REQUIRED; Role Sink information.
	SinkInfo *RoleSinkInfo

	// REQUIRED; Periodic timer details.
	SourceInfo *PeriodicTimerSourceInfo

	// A custom context tag typically used to correlate the trigger against its usage. For example, if a periodic timer trigger
	// is intended for certain specific IoT modules in the device, the tag can be the
	// name or the image URL of the module.
	CustomContextTag *string
}

// PeriodicTimerSourceInfo - Periodic timer event source.
type PeriodicTimerSourceInfo struct {
	// REQUIRED; Periodic frequency at which timer event needs to be raised. Supports daily, hourly, minutes, and seconds.
	Schedule *string

	// REQUIRED; The time of the day that results in a valid trigger. Schedule is computed with reference to the time specified
	// upto seconds. If timezone is not specified the time will considered to be in device
	// timezone. The value will always be returned as UTC time.
	StartTime *time.Time

	// Topic where periodic events are published to IoT device.
	Topic *string
}

// ProactiveLogCollectionSettingsProperties - The properties of proactive log collection settings.
type ProactiveLogCollectionSettingsProperties struct {
	// REQUIRED; Proactive diagnostic collection consent flag
	UserConsent *ProactiveDiagnosticsConsent
}

// RawCertificateData - Raw Certificate Data.
type RawCertificateData struct {
	// REQUIRED; The base64 encoded certificate raw data.
	Certificate *string

	// The authentication type.
	AuthenticationType *AuthenticationType
}

// RefreshDetails - Fields for tracking refresh job on the share or container.
type RefreshDetails struct {
	// Indicates the relative path of the error xml for the last refresh job on this particular share or container, if any. This
	// could be a failed job or a successful job.
	ErrorManifestFile *string

	// If a refresh job is currently in progress on this share or container, this field indicates the ARM resource ID of that
	// job. The field is empty if no job is in progress.
	InProgressRefreshJobID *string

	// Indicates the completed time for the last refresh job on this particular share or container, if any.This could be a failed
	// job or a successful job.
	LastCompletedRefreshJobTimeInUTC *time.Time

	// Indicates the id of the last refresh job on this particular share or container,if any. This could be a failed job or a
	// successful job.
	LastJob *string
}

// RemoteSupportSettings - RemoteApplicationType for which remote support settings is being modified
type RemoteSupportSettings struct {
	// Access level allowed for this remote application type
	AccessLevel *AccessLevel

	// Expiration time stamp
	ExpirationTimeStampInUTC *time.Time

	// Remote application type
	RemoteApplicationType *RemoteApplicationType
}

// ResourceIdentity - Msi identity details of the resource
type ResourceIdentity struct {
	// Identity type
	Type *MsiIdentityType

	// READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string

	// READ-ONLY; Home Tenant Id
	TenantID *string
}

// ResourceMoveDetails - Fields for tracking resource move
type ResourceMoveDetails struct {
	// Denotes whether move operation is in progress
	OperationInProgress *ResourceMoveStatus

	// Denotes the timeout of the operation to finish
	OperationInProgressLockTimeoutInUTC *time.Time
}

// Role - Compute role.
type Role struct {
	// REQUIRED; Role type.
	Kind *RoleTypes

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Role
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetRole implements the RoleClassification interface for type Role.
func (r *Role) GetRole() *Role { return r }

// RoleList - Collection of all the roles on the Data Box Edge device.
type RoleList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The Value.
	Value []RoleClassification
}

// RoleSinkInfo - Compute role against which events will be raised.
type RoleSinkInfo struct {
	// REQUIRED; Compute role ID.
	RoleID *string
}

// SKU - The Sku information.
type SKU struct {
	// READ-ONLY; The API versions in which Sku is available.
	APIVersions []*string

	// READ-ONLY; Links to the next set of results
	Availability *SKUAvailability

	// READ-ONLY; The capability info of the SKU.
	Capabilities []*SKUCapability

	// READ-ONLY; The pricing info of the Sku.
	Costs []*SKUCost

	// READ-ONLY; The Sku family.
	Family *string

	// READ-ONLY; The Sku kind.
	Kind *string

	// READ-ONLY; Availability of the Sku for the location/zone/site.
	LocationInfo []*SKULocationInfo

	// READ-ONLY; Availability of the Sku for the region.
	Locations []*string

	// READ-ONLY; The Sku name.
	Name *SKUName

	// READ-ONLY; The type of the resource.
	ResourceType *string

	// READ-ONLY; List of Shipment Types supported by this SKU
	ShipmentTypes []*ShipmentType

	// READ-ONLY; Sku can be signed up by customer or not.
	SignupOption *SKUSignupOption

	// READ-ONLY; The Sku kind.
	Size *string

	// READ-ONLY; The Sku tier.
	Tier *SKUTier

	// READ-ONLY; Availability of the Sku as preview/stable.
	Version *SKUVersion
}

// SKUCapability - The metadata to describe the capability.
type SKUCapability struct {
	// READ-ONLY; An invariant to describe the feature.
	Name *string

	// READ-ONLY; An invariant if the feature is measured by quantity.
	Value *string
}

// SKUCost - The metadata for retrieving price info.
type SKUCost struct {
	// READ-ONLY; The extended unit.
	ExtendedUnit *string

	// READ-ONLY; Used for querying price from commerce.
	MeterID *string

	// READ-ONLY; The cost quantity.
	Quantity *int64
}

// SKUInfo - The SKU type.
type SKUInfo struct {
	// SKU name.
	Name *SKUName

	// The SKU tier. This is based on the SKU name.
	Tier *SKUTier
}

// SKUList - List of SKU Information objects.
type SKUList struct {
	// READ-ONLY; Links to the next set of results
	NextLink *string

	// READ-ONLY; List of ResourceType Sku
	Value []*SKU
}

// SKULocationInfo - The location info.
type SKULocationInfo struct {
	// READ-ONLY; The location.
	Location *string

	// READ-ONLY; The sites.
	Sites []*string

	// READ-ONLY; The zones.
	Zones []*string
}

// Secret - Holds device secret either as a KeyVault reference or as an encrypted value.
type Secret struct {
	// Encrypted (using device public key) secret value.
	EncryptedSecret *AsymmetricEncryptedSecret

	// Id of the Key-Vault where secret is stored (ex: secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
	KeyVaultID *string
}

// SecuritySettings - The security settings of a device.
type SecuritySettings struct {
	// REQUIRED; Properties of the security settings.
	Properties *SecuritySettingsProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// SecuritySettingsProperties - The properties of security settings.
type SecuritySettingsProperties struct {
	// REQUIRED; Device administrator password as an encrypted string (encrypted using RSA PKCS #1) is used to sign into the local
	// web UI of the device. The Actual password should have at least 8 characters that are a
	// combination of uppercase, lowercase, numeric, and special characters.
	DeviceAdminPassword *AsymmetricEncryptedSecret
}

// ServiceSpecification - Service specification.
type ServiceSpecification struct {
	// Metric specification as defined by shoebox.
	MetricSpecifications []*MetricSpecificationV1
}

// Share - Represents a share on the Data Box Edge/Gateway device.
type Share struct {
	// REQUIRED; The share properties.
	Properties *ShareProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Share
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// ShareAccessRight - Specifies the mapping between this particular user and the type of access he has on shares on this device.
type ShareAccessRight struct {
	// REQUIRED; Type of access to be allowed on the share for this user.
	AccessType *ShareAccessType

	// REQUIRED; The share ID.
	ShareID *string
}

// ShareList - Collection of all the shares on the Data Box Edge/Gateway device.
type ShareList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of shares.
	Value []*Share
}

// ShareProperties - The share properties.
type ShareProperties struct {
	// REQUIRED; Access protocol to be used by the share.
	AccessProtocol *ShareAccessProtocol

	// REQUIRED; Current monitoring status of the share.
	MonitoringStatus *MonitoringStatus

	// REQUIRED; Current status of the share.
	ShareStatus *ShareStatus

	// Azure container mapping for the share.
	AzureContainerInfo *AzureContainerInfo

	// List of IP addresses and corresponding access rights on the share(required for NFS protocol).
	ClientAccessRights []*ClientAccessRight

	// Data policy of the share.
	DataPolicy *DataPolicy

	// Description for the share.
	Description *string

	// Details of the refresh job on this share.
	RefreshDetails *RefreshDetails

	// Mapping of users and corresponding access rights on the share (required for SMB protocol).
	UserAccessRights []*UserAccessRight

	// READ-ONLY; Share mount point to the role.
	ShareMappings []*MountPointMap
}

// StorageAccount - Represents a Storage Account on the Data Box Edge/Gateway device.
type StorageAccount struct {
	// REQUIRED; The Storage Account properties.
	Properties *StorageAccountProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of StorageAccount
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// StorageAccountCredential - The storage account credential.
type StorageAccountCredential struct {
	// REQUIRED; The storage account credential properties.
	Properties *StorageAccountCredentialProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of StorageAccountCredential
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// StorageAccountCredentialList - The collection of storage account credentials.
type StorageAccountCredentialList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The value.
	Value []*StorageAccountCredential
}

// StorageAccountCredentialProperties - The storage account credential properties.
type StorageAccountCredentialProperties struct {
	// REQUIRED; Type of storage accessed on the storage account.
	AccountType *AccountType

	// REQUIRED; Alias for the storage account.
	Alias *string

	// REQUIRED; Signifies whether SSL needs to be enabled or not.
	SSLStatus *SSLStatus

	// Encrypted storage key.
	AccountKey *AsymmetricEncryptedSecret

	// Blob end point for private clouds.
	BlobDomainName *string

	// Connection string for the storage account. Use this string if username and account key are not specified.
	ConnectionString *string

	// Id of the storage account.
	StorageAccountID *string

	// Username for the storage account.
	UserName *string
}

// StorageAccountList - Collection of all the Storage Accounts on the Data Box Edge/Gateway device.
type StorageAccountList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of storageAccounts.
	Value []*StorageAccount
}

// StorageAccountProperties - The storage account properties.
type StorageAccountProperties struct {
	// REQUIRED; Data policy of the storage Account.
	DataPolicy *DataPolicy

	// Description for the storage Account.
	Description *string

	// Storage Account Credential Id
	StorageAccountCredentialID *string

	// Current status of the storage account
	StorageAccountStatus *StorageAccountStatus

	// READ-ONLY; BlobEndpoint of Storage Account
	BlobEndpoint *string

	// READ-ONLY; The Container Count. Present only for Storage Accounts with DataPolicy set to Cloud.
	ContainerCount *int32
}

type SubscriptionProperties struct {
	LocationPlacementID *string
	QuotaID             *string
	RegisteredFeatures  []*SubscriptionRegisteredFeatures
	SerializedDetails   *string
	TenantID            *string
}

type SubscriptionRegisteredFeatures struct {
	Name  *string
	State *string
}

// SupportPackageRequestProperties - The share properties.
type SupportPackageRequestProperties struct {
	// Type of files, which need to be included in the logs This will contain the type of logs (Default/DefaultWithDumps/None/All/DefaultWithArchived)
	// or a comma separated list of log types that are required
	Include *string

	// Start of the timespan of the log collection
	MaximumTimeStamp *time.Time

	// MinimumTimeStamp from where logs need to be collected
	MinimumTimeStamp *time.Time
}

// SymmetricKey - Symmetric key for authentication.
type SymmetricKey struct {
	// Connection string based on the symmetric key.
	ConnectionString *AsymmetricEncryptedSecret
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TrackingInfo - Tracking courier information.
type TrackingInfo struct {
	// Name of the carrier used in the delivery.
	CarrierName *string

	// Serial number of the device being tracked.
	SerialNumber *string

	// Tracking ID of the shipment.
	TrackingID *string

	// Tracking URL of the shipment.
	TrackingURL *string
}

// Trigger details.
type Trigger struct {
	// REQUIRED; Trigger Kind.
	Kind *TriggerEventType

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of Trigger
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// GetTrigger implements the TriggerClassification interface for type Trigger.
func (t *Trigger) GetTrigger() *Trigger { return t }

// TriggerList - Collection of all trigger on the data box edge device.
type TriggerList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of triggers.
	Value []TriggerClassification
}

// TriggerSupportPackageRequest - The request object for trigger support package.
type TriggerSupportPackageRequest struct {
	// REQUIRED; The TriggerSupportPackageRequest properties.
	Properties *SupportPackageRequestProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// UpdateDetails - Update Specific attributes
type UpdateDetails struct {
	// Estimated Install Time for the update
	EstimatedInstallTimeInMins *int32

	// Friendly Version Number
	FriendlyVersionNumber *string

	// Impact of Installing an updateType
	InstallationImpact *InstallationImpact

	// Indicates if updates are available and at least one of the updates needs a reboot.
	RebootBehavior *InstallRebootBehavior

	// Status of the update.
	Status *UpdateStatus

	// Target Version number
	TargetVersion *string

	// Size of the update(In Bytes)
	UpdateSize *float64

	// Title of the Update
	UpdateTitle *string

	// Type of the Update
	UpdateType *UpdateType
}

// UpdateDownloadProgress - Details about the download progress of update.
type UpdateDownloadProgress struct {
	// READ-ONLY; The download phase.
	DownloadPhase *DownloadPhase

	// READ-ONLY; Number of updates downloaded.
	NumberOfUpdatesDownloaded *int32

	// READ-ONLY; Number of updates to download.
	NumberOfUpdatesToDownload *int32

	// READ-ONLY; Percentage of completion.
	PercentComplete *int32

	// READ-ONLY; Total bytes downloaded.
	TotalBytesDownloaded *float64

	// READ-ONLY; Total bytes to download.
	TotalBytesToDownload *float64
}

// UpdateInstallProgress - Progress details during installation of updates.
type UpdateInstallProgress struct {
	// READ-ONLY; Number of updates installed.
	NumberOfUpdatesInstalled *int32

	// READ-ONLY; Number of updates to install.
	NumberOfUpdatesToInstall *int32

	// READ-ONLY; Percentage completed.
	PercentComplete *int32
}

// UpdateSummary - Details about ongoing updates and availability of updates on the device.
type UpdateSummary struct {
	// The device update information summary.
	Properties *UpdateSummaryProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of UpdateSummary
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// UpdateSummaryProperties - The device update information summary.
type UpdateSummaryProperties struct {
	// The last time when a scan was done on the device.
	DeviceLastScannedDateTime *time.Time

	// The current version of the device in format: 1.2.17312.13.",
	DeviceVersionNumber *string

	// The current version of the device in text format.
	FriendlyDeviceVersionName *string

	// The time when the last scan job was completed (success/cancelled/failed) on the appliance.
	LastCompletedScanJobDateTime *time.Time

	// The time when the Last Install job was completed successfully on the appliance
	LastSuccessfulInstallJobDateTime *time.Time

	// Time when the last scan job is successfully completed.
	LastSuccessfulScanJobTime *time.Time

	// READ-ONLY; The job ID of the download job in progress.
	InProgressDownloadJobID *string

	// READ-ONLY; The time when the currently running download (if any) started.
	InProgressDownloadJobStartedDateTime *time.Time

	// READ-ONLY; The job ID of the install job in progress.
	InProgressInstallJobID *string

	// READ-ONLY; The time when the currently running install (if any) started.
	InProgressInstallJobStartedDateTime *time.Time

	// READ-ONLY; The time when the last Download job was completed (success/cancelled/failed) on the appliance.
	LastCompletedDownloadJobDateTime *time.Time

	// READ-ONLY; JobId of the last ran download job.(Can be success/cancelled/failed)
	LastCompletedDownloadJobID *string

	// READ-ONLY; The time when the last Install job was completed (success/cancelled/failed) on the appliance.
	LastCompletedInstallJobDateTime *time.Time

	// READ-ONLY; JobId of the last ran install job.(Can be success/cancelled/failed)
	LastCompletedInstallJobID *string

	// READ-ONLY; JobStatus of the last ran download job.
	LastDownloadJobStatus *JobStatus

	// READ-ONLY; JobStatus of the last ran install job.
	LastInstallJobStatus *JobStatus

	// READ-ONLY; The current update operation.
	OngoingUpdateOperation *UpdateOperation

	// READ-ONLY; Indicates if updates are available and at least one of the updates needs a reboot.
	RebootBehavior *InstallRebootBehavior

	// READ-ONLY; The number of updates available for the current device version as per the last device scan.
	TotalNumberOfUpdatesAvailable *int32

	// READ-ONLY; The total number of items pending download.
	TotalNumberOfUpdatesPendingDownload *int32

	// READ-ONLY; The total number of items pending install.
	TotalNumberOfUpdatesPendingInstall *int32

	// READ-ONLY; The total time in Minutes
	TotalTimeInMinutes *int32

	// READ-ONLY; The total size of updates available for download in bytes.
	TotalUpdateSizeInBytes *float64

	// READ-ONLY; The list of updates available for install.
	UpdateTitles []*string

	// READ-ONLY; The list of updates available for install.
	Updates []*UpdateDetails
}

// UploadCertificateRequest - The upload certificate request.
type UploadCertificateRequest struct {
	// REQUIRED; The Base 64 encoded certificate raw data.
	Properties *RawCertificateData
}

// UploadCertificateResponse - The upload registration certificate response.
type UploadCertificateResponse struct {
	// Specifies authentication type.
	AuthType *AuthenticationType

	// READ-ONLY; Identifier of the target resource that is the recipient of the requested token.
	AADAudience *string

	// READ-ONLY; Azure Active Directory tenant authority.
	AADAuthority *string

	// READ-ONLY; Azure Active Directory tenant ID.
	AADTenantID *string

	// READ-ONLY; The azure management endpoint audience.
	AzureManagementEndpointAudience *string

	// READ-ONLY; The resource ID of the Data Box Edge/Gateway device.
	ResourceID *string

	// READ-ONLY; Azure Active Directory service principal client ID.
	ServicePrincipalClientID *string

	// READ-ONLY; Azure Active Directory service principal object ID.
	ServicePrincipalObjectID *string
}

// User - Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.
type User struct {
	// REQUIRED; The storage account credential properties.
	Properties *UserProperties

	// READ-ONLY; The path ID that uniquely identifies the object.
	ID *string

	// READ-ONLY; The object name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of User
	SystemData *SystemData

	// READ-ONLY; The hierarchical type of the object.
	Type *string
}

// UserAccessRight - The mapping between a particular user and the access type on the SMB share.
type UserAccessRight struct {
	// REQUIRED; Type of access to be allowed for the user.
	AccessType *ShareAccessType

	// REQUIRED; User ID (already existing in the device).
	UserID *string
}

// UserList - Collection of users.
type UserList struct {
	// READ-ONLY; Link to the next set of results.
	NextLink *string

	// READ-ONLY; The list of users.
	Value []*User
}

// UserProperties - The user properties.
type UserProperties struct {
	// REQUIRED; Type of the user.
	UserType *UserType

	// The password details.
	EncryptedPassword *AsymmetricEncryptedSecret

	// READ-ONLY; List of shares that the user has rights on. This field should not be specified during user creation.
	ShareAccessRights []*ShareAccessRight
}

// VMMemory - VmMemory Data.
type VMMemory struct {
	// The current memory used by the virtual machine.
	CurrentMemoryUsageMB *int64

	// The total amount of RAM in the virtual machine, as seen by the guest operating system. For a virtual machine with dynamic
	// memory enabled, this represents the initial memory available at startup.
	StartupMemoryMB *int64
}

// VMPlacementRequestResult - List of VM sizes being checked for creation on appliance along with corresponding result.
type VMPlacementRequestResult struct {
	// Boolean value indicating if the VM(s) in VmSize can be created.
	IsFeasible *bool

	// Localized message to be displayed to the user to explain the check result.
	Message *string

	// MessageCode indicating reason for success or failure.
	MessageCode *string

	// List of VM sizes being checked.
	VMSize []*string
}
