//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcosmos

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GraphResourcesClient contains the methods for the GraphResources group.
// Don't use this type directly, use NewGraphResourcesClient() instead.
type GraphResourcesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewGraphResourcesClient creates a new instance of GraphResourcesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGraphResourcesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*GraphResourcesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GraphResourcesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateUpdateGraph - Create or update an Azure Cosmos DB Graph.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-03-15-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - accountName - Cosmos DB database account name.
//   - graphName - Cosmos DB graph resource name.
//   - createUpdateGraphParameters - The parameters to provide for the current graph.
//   - options - GraphResourcesClientBeginCreateUpdateGraphOptions contains the optional parameters for the GraphResourcesClient.BeginCreateUpdateGraph
//     method.
func (client *GraphResourcesClient) BeginCreateUpdateGraph(ctx context.Context, resourceGroupName string, accountName string, graphName string, createUpdateGraphParameters GraphResourceCreateUpdateParameters, options *GraphResourcesClientBeginCreateUpdateGraphOptions) (*runtime.Poller[GraphResourcesClientCreateUpdateGraphResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createUpdateGraph(ctx, resourceGroupName, accountName, graphName, createUpdateGraphParameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GraphResourcesClientCreateUpdateGraphResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GraphResourcesClientCreateUpdateGraphResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateUpdateGraph - Create or update an Azure Cosmos DB Graph.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-03-15-preview
func (client *GraphResourcesClient) createUpdateGraph(ctx context.Context, resourceGroupName string, accountName string, graphName string, createUpdateGraphParameters GraphResourceCreateUpdateParameters, options *GraphResourcesClientBeginCreateUpdateGraphOptions) (*http.Response, error) {
	var err error
	const operationName = "GraphResourcesClient.BeginCreateUpdateGraph"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createUpdateGraphCreateRequest(ctx, resourceGroupName, accountName, graphName, createUpdateGraphParameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createUpdateGraphCreateRequest creates the CreateUpdateGraph request.
func (client *GraphResourcesClient) createUpdateGraphCreateRequest(ctx context.Context, resourceGroupName string, accountName string, graphName string, createUpdateGraphParameters GraphResourceCreateUpdateParameters, options *GraphResourcesClientBeginCreateUpdateGraphOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if graphName == "" {
		return nil, errors.New("parameter graphName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{graphName}", url.PathEscape(graphName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-03-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, createUpdateGraphParameters); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDeleteGraphResource - Deletes an existing Azure Cosmos DB Graph Resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-03-15-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - accountName - Cosmos DB database account name.
//   - graphName - Cosmos DB graph resource name.
//   - options - GraphResourcesClientBeginDeleteGraphResourceOptions contains the optional parameters for the GraphResourcesClient.BeginDeleteGraphResource
//     method.
func (client *GraphResourcesClient) BeginDeleteGraphResource(ctx context.Context, resourceGroupName string, accountName string, graphName string, options *GraphResourcesClientBeginDeleteGraphResourceOptions) (*runtime.Poller[GraphResourcesClientDeleteGraphResourceResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteGraphResource(ctx, resourceGroupName, accountName, graphName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GraphResourcesClientDeleteGraphResourceResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GraphResourcesClientDeleteGraphResourceResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// DeleteGraphResource - Deletes an existing Azure Cosmos DB Graph Resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-03-15-preview
func (client *GraphResourcesClient) deleteGraphResource(ctx context.Context, resourceGroupName string, accountName string, graphName string, options *GraphResourcesClientBeginDeleteGraphResourceOptions) (*http.Response, error) {
	var err error
	const operationName = "GraphResourcesClient.BeginDeleteGraphResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteGraphResourceCreateRequest(ctx, resourceGroupName, accountName, graphName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteGraphResourceCreateRequest creates the DeleteGraphResource request.
func (client *GraphResourcesClient) deleteGraphResourceCreateRequest(ctx context.Context, resourceGroupName string, accountName string, graphName string, options *GraphResourcesClientBeginDeleteGraphResourceOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if graphName == "" {
		return nil, errors.New("parameter graphName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{graphName}", url.PathEscape(graphName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-03-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// GetGraph - Gets the Graph resource under an existing Azure Cosmos DB database account with the provided name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-03-15-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - accountName - Cosmos DB database account name.
//   - graphName - Cosmos DB graph resource name.
//   - options - GraphResourcesClientGetGraphOptions contains the optional parameters for the GraphResourcesClient.GetGraph method.
func (client *GraphResourcesClient) GetGraph(ctx context.Context, resourceGroupName string, accountName string, graphName string, options *GraphResourcesClientGetGraphOptions) (GraphResourcesClientGetGraphResponse, error) {
	var err error
	const operationName = "GraphResourcesClient.GetGraph"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getGraphCreateRequest(ctx, resourceGroupName, accountName, graphName, options)
	if err != nil {
		return GraphResourcesClientGetGraphResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GraphResourcesClientGetGraphResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GraphResourcesClientGetGraphResponse{}, err
	}
	resp, err := client.getGraphHandleResponse(httpResp)
	return resp, err
}

// getGraphCreateRequest creates the GetGraph request.
func (client *GraphResourcesClient) getGraphCreateRequest(ctx context.Context, resourceGroupName string, accountName string, graphName string, options *GraphResourcesClientGetGraphOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if graphName == "" {
		return nil, errors.New("parameter graphName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{graphName}", url.PathEscape(graphName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-03-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getGraphHandleResponse handles the GetGraph response.
func (client *GraphResourcesClient) getGraphHandleResponse(resp *http.Response) (GraphResourcesClientGetGraphResponse, error) {
	result := GraphResourcesClientGetGraphResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GraphResourceGetResults); err != nil {
		return GraphResourcesClientGetGraphResponse{}, err
	}
	return result, nil
}

// NewListGraphsPager - Lists the graphs under an existing Azure Cosmos DB database account.
//
// Generated from API version 2023-03-15-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - accountName - Cosmos DB database account name.
//   - options - GraphResourcesClientListGraphsOptions contains the optional parameters for the GraphResourcesClient.NewListGraphsPager
//     method.
func (client *GraphResourcesClient) NewListGraphsPager(resourceGroupName string, accountName string, options *GraphResourcesClientListGraphsOptions) *runtime.Pager[GraphResourcesClientListGraphsResponse] {
	return runtime.NewPager(runtime.PagingHandler[GraphResourcesClientListGraphsResponse]{
		More: func(page GraphResourcesClientListGraphsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *GraphResourcesClientListGraphsResponse) (GraphResourcesClientListGraphsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GraphResourcesClient.NewListGraphsPager")
			req, err := client.listGraphsCreateRequest(ctx, resourceGroupName, accountName, options)
			if err != nil {
				return GraphResourcesClientListGraphsResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return GraphResourcesClientListGraphsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return GraphResourcesClientListGraphsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listGraphsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listGraphsCreateRequest creates the ListGraphs request.
func (client *GraphResourcesClient) listGraphsCreateRequest(ctx context.Context, resourceGroupName string, accountName string, options *GraphResourcesClientListGraphsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-03-15-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listGraphsHandleResponse handles the ListGraphs response.
func (client *GraphResourcesClient) listGraphsHandleResponse(resp *http.Response) (GraphResourcesClientListGraphsResponse, error) {
	result := GraphResourcesClientListGraphsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GraphResourcesListResult); err != nil {
		return GraphResourcesClientListGraphsResponse{}, err
	}
	return result, nil
}
