/* Generated by  */

#include "../core/settings.h"

#include <winpr/assert.h>
#include <freerdp/settings.h>
#include <freerdp/log.h>

#define TAG FREERDP_TAG("common.settings")

static void free_string(char** current, BOOL cleanup)
{
	if (cleanup)
	{
		if (*current)
			memset(*current, 0, strlen(*current));
		free(*current);
		(*current) = NULL;
	}
}

static BOOL alloc_empty_string(char** current, const char* next, size_t next_len)
{
	if (!next && (next_len > 0))
	{
		*current = calloc(next_len, 1);
		return (*current != NULL);
	}
	return FALSE;
}

static BOOL update_string_copy_(char** current, const char* next, size_t next_len, BOOL cleanup)
{
	free_string(current, cleanup);

	if (alloc_empty_string(current, next, next_len))
		return TRUE;

	*current = (next ? strndup(next, next_len) : NULL);
	return !next || (*current != NULL);
}

static BOOL update_string_(char** current, char* next, size_t next_len)
{
	free_string(current, TRUE);

	if (alloc_empty_string(current, next, next_len))
		return TRUE;

	*current = next;
	return !next || (*current != NULL);
}

BOOL freerdp_settings_get_bool(WINPR_ATTR_UNUSED const rdpSettings* settings,
                               WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Bool id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_AadSecurity:
			return settings->AadSecurity;

		case FreeRDP_AllowCacheWaitingList:
			return settings->AllowCacheWaitingList;

		case FreeRDP_AllowDesktopComposition:
			return settings->AllowDesktopComposition;

		case FreeRDP_AllowFontSmoothing:
			return settings->AllowFontSmoothing;

		case FreeRDP_AllowUnanouncedOrdersFromServer:
			return settings->AllowUnanouncedOrdersFromServer;

		case FreeRDP_AltSecFrameMarkerSupport:
			return settings->AltSecFrameMarkerSupport;

		case FreeRDP_AsyncChannels:
			return settings->AsyncChannels;

		case FreeRDP_AsyncUpdate:
			return settings->AsyncUpdate;

		case FreeRDP_AudioCapture:
			return settings->AudioCapture;

		case FreeRDP_AudioPlayback:
			return settings->AudioPlayback;

		case FreeRDP_Authentication:
			return settings->Authentication;

		case FreeRDP_AuthenticationOnly:
			return settings->AuthenticationOnly;

		case FreeRDP_AutoAcceptCertificate:
			return settings->AutoAcceptCertificate;

		case FreeRDP_AutoDenyCertificate:
			return settings->AutoDenyCertificate;

		case FreeRDP_AutoLogonEnabled:
			return settings->AutoLogonEnabled;

		case FreeRDP_AutoReconnectionEnabled:
			return settings->AutoReconnectionEnabled;

		case FreeRDP_AutoReconnectionPacketSupported:
			return settings->AutoReconnectionPacketSupported;

		case FreeRDP_BitmapCacheEnabled:
			return settings->BitmapCacheEnabled;

		case FreeRDP_BitmapCachePersistEnabled:
			return settings->BitmapCachePersistEnabled;

		case FreeRDP_BitmapCacheV3Enabled:
			return settings->BitmapCacheV3Enabled;

		case FreeRDP_BitmapCompressionDisabled:
			return settings->BitmapCompressionDisabled;

		case FreeRDP_CertificateCallbackPreferPEM:
			return settings->CertificateCallbackPreferPEM;

		case FreeRDP_CompressionEnabled:
			return settings->CompressionEnabled;

		case FreeRDP_ConnectChildSession:
			return settings->ConnectChildSession;

		case FreeRDP_ConsoleSession:
			return settings->ConsoleSession;

		case FreeRDP_CredentialsFromStdin:
			return settings->CredentialsFromStdin;

		case FreeRDP_DeactivateClientDecoding:
			return settings->DeactivateClientDecoding;

		case FreeRDP_Decorations:
			return settings->Decorations;

		case FreeRDP_DesktopResize:
			return settings->DesktopResize;

		case FreeRDP_DeviceRedirection:
			return settings->DeviceRedirection;

		case FreeRDP_DisableCredentialsDelegation:
			return settings->DisableCredentialsDelegation;

		case FreeRDP_DisableCtrlAltDel:
			return settings->DisableCtrlAltDel;

		case FreeRDP_DisableCursorBlinking:
			return settings->DisableCursorBlinking;

		case FreeRDP_DisableCursorShadow:
			return settings->DisableCursorShadow;

		case FreeRDP_DisableFullWindowDrag:
			return settings->DisableFullWindowDrag;

		case FreeRDP_DisableMenuAnims:
			return settings->DisableMenuAnims;

		case FreeRDP_DisableRemoteAppCapsCheck:
			return settings->DisableRemoteAppCapsCheck;

		case FreeRDP_DisableThemes:
			return settings->DisableThemes;

		case FreeRDP_DisableWallpaper:
			return settings->DisableWallpaper;

		case FreeRDP_DrawAllowColorSubsampling:
			return settings->DrawAllowColorSubsampling;

		case FreeRDP_DrawAllowDynamicColorFidelity:
			return settings->DrawAllowDynamicColorFidelity;

		case FreeRDP_DrawAllowSkipAlpha:
			return settings->DrawAllowSkipAlpha;

		case FreeRDP_DrawGdiPlusCacheEnabled:
			return settings->DrawGdiPlusCacheEnabled;

		case FreeRDP_DrawGdiPlusEnabled:
			return settings->DrawGdiPlusEnabled;

		case FreeRDP_DrawNineGridEnabled:
			return settings->DrawNineGridEnabled;

		case FreeRDP_DumpRemoteFx:
			return settings->DumpRemoteFx;

		case FreeRDP_DynamicDaylightTimeDisabled:
			return settings->DynamicDaylightTimeDisabled;

		case FreeRDP_DynamicResolutionUpdate:
			return settings->DynamicResolutionUpdate;

		case FreeRDP_EmbeddedWindow:
			return settings->EmbeddedWindow;

		case FreeRDP_EnableWindowsKey:
			return settings->EnableWindowsKey;

		case FreeRDP_EncomspVirtualChannel:
			return settings->EncomspVirtualChannel;

		case FreeRDP_ExtSecurity:
			return settings->ExtSecurity;

		case FreeRDP_ExternalCertificateManagement:
			return settings->ExternalCertificateManagement;

		case FreeRDP_FIPSMode:
			return settings->FIPSMode;

		case FreeRDP_FastPathInput:
			return settings->FastPathInput;

		case FreeRDP_FastPathOutput:
			return settings->FastPathOutput;

		case FreeRDP_ForceEncryptedCsPdu:
			return settings->ForceEncryptedCsPdu;

		case FreeRDP_ForceMultimon:
			return settings->ForceMultimon;

		case FreeRDP_FrameMarkerCommandEnabled:
			return settings->FrameMarkerCommandEnabled;

		case FreeRDP_Fullscreen:
			return settings->Fullscreen;

		case FreeRDP_GatewayArmTransport:
			return settings->GatewayArmTransport;

		case FreeRDP_GatewayAvdUseTenantid:
			return settings->GatewayAvdUseTenantid;

		case FreeRDP_GatewayBypassLocal:
			return settings->GatewayBypassLocal;

		case FreeRDP_GatewayEnabled:
			return settings->GatewayEnabled;

		case FreeRDP_GatewayHttpExtAuthSspiNtlm:
			return settings->GatewayHttpExtAuthSspiNtlm;

		case FreeRDP_GatewayHttpTransport:
			return settings->GatewayHttpTransport;

		case FreeRDP_GatewayHttpUseWebsockets:
			return settings->GatewayHttpUseWebsockets;

		case FreeRDP_GatewayIgnoreRedirectionPolicy:
			return settings->GatewayIgnoreRedirectionPolicy;

		case FreeRDP_GatewayRpcTransport:
			return settings->GatewayRpcTransport;

		case FreeRDP_GatewayUdpTransport:
			return settings->GatewayUdpTransport;

		case FreeRDP_GatewayUseSameCredentials:
			return settings->GatewayUseSameCredentials;

		case FreeRDP_GfxAVC444:
			return settings->GfxAVC444;

		case FreeRDP_GfxAVC444v2:
			return settings->GfxAVC444v2;

		case FreeRDP_GfxH264:
			return settings->GfxH264;

		case FreeRDP_GfxPlanar:
			return settings->GfxPlanar;

		case FreeRDP_GfxProgressive:
			return settings->GfxProgressive;

		case FreeRDP_GfxProgressiveV2:
			return settings->GfxProgressiveV2;

		case FreeRDP_GfxSendQoeAck:
			return settings->GfxSendQoeAck;

		case FreeRDP_GfxSmallCache:
			return settings->GfxSmallCache;

		case FreeRDP_GfxSuspendFrameAck:
			return settings->GfxSuspendFrameAck;

		case FreeRDP_GfxThinClient:
			return settings->GfxThinClient;

		case FreeRDP_GrabKeyboard:
			return settings->GrabKeyboard;

		case FreeRDP_GrabMouse:
			return settings->GrabMouse;

		case FreeRDP_HasExtendedMouseEvent:
			return settings->HasExtendedMouseEvent;

		case FreeRDP_HasHorizontalWheel:
			return settings->HasHorizontalWheel;

		case FreeRDP_HasMonitorAttributes:
			return settings->HasMonitorAttributes;

		case FreeRDP_HasQoeEvent:
			return settings->HasQoeEvent;

		case FreeRDP_HasRelativeMouseEvent:
			return settings->HasRelativeMouseEvent;

		case FreeRDP_HiDefRemoteApp:
			return settings->HiDefRemoteApp;

		case FreeRDP_IPv6Enabled:
			return settings->IPv6Enabled;

		case FreeRDP_IgnoreCertificate:
			return settings->IgnoreCertificate;

		case FreeRDP_IgnoreInvalidDevices:
			return settings->IgnoreInvalidDevices;

		case FreeRDP_JpegCodec:
			return settings->JpegCodec;

		case FreeRDP_KerberosRdgIsProxy:
			return settings->KerberosRdgIsProxy;

		case FreeRDP_ListMonitors:
			return settings->ListMonitors;

		case FreeRDP_LocalConnection:
			return settings->LocalConnection;

		case FreeRDP_LogonErrors:
			return settings->LogonErrors;

		case FreeRDP_LogonNotify:
			return settings->LogonNotify;

		case FreeRDP_LongCredentialsSupported:
			return settings->LongCredentialsSupported;

		case FreeRDP_LyncRdpMode:
			return settings->LyncRdpMode;

		case FreeRDP_MaximizeShell:
			return settings->MaximizeShell;

		case FreeRDP_MouseAttached:
			return settings->MouseAttached;

		case FreeRDP_MouseHasWheel:
			return settings->MouseHasWheel;

		case FreeRDP_MouseMotion:
			return settings->MouseMotion;

		case FreeRDP_MouseUseRelativeMove:
			return settings->MouseUseRelativeMove;

		case FreeRDP_MstscCookieMode:
			return settings->MstscCookieMode;

		case FreeRDP_MultiTouchGestures:
			return settings->MultiTouchGestures;

		case FreeRDP_MultiTouchInput:
			return settings->MultiTouchInput;

		case FreeRDP_NSCodec:
			return settings->NSCodec;

		case FreeRDP_NSCodecAllowDynamicColorFidelity:
			return settings->NSCodecAllowDynamicColorFidelity;

		case FreeRDP_NSCodecAllowSubsampling:
			return settings->NSCodecAllowSubsampling;

		case FreeRDP_NegotiateSecurityLayer:
			return settings->NegotiateSecurityLayer;

		case FreeRDP_NetworkAutoDetect:
			return settings->NetworkAutoDetect;

		case FreeRDP_NlaSecurity:
			return settings->NlaSecurity;

		case FreeRDP_NoBitmapCompressionHeader:
			return settings->NoBitmapCompressionHeader;

		case FreeRDP_OldLicenseBehaviour:
			return settings->OldLicenseBehaviour;

		case FreeRDP_PasswordIsSmartcardPin:
			return settings->PasswordIsSmartcardPin;

		case FreeRDP_PercentScreenUseHeight:
			return settings->PercentScreenUseHeight;

		case FreeRDP_PercentScreenUseWidth:
			return settings->PercentScreenUseWidth;

		case FreeRDP_PlayRemoteFx:
			return settings->PlayRemoteFx;

		case FreeRDP_PreferIPv6OverIPv4:
			return settings->PreferIPv6OverIPv4;

		case FreeRDP_PrintReconnectCookie:
			return settings->PrintReconnectCookie;

		case FreeRDP_PromptForCredentials:
			return settings->PromptForCredentials;

		case FreeRDP_RdpSecurity:
			return settings->RdpSecurity;

		case FreeRDP_RdstlsSecurity:
			return settings->RdstlsSecurity;

		case FreeRDP_RedirectClipboard:
			return settings->RedirectClipboard;

		case FreeRDP_RedirectDrives:
			return settings->RedirectDrives;

		case FreeRDP_RedirectHomeDrive:
			return settings->RedirectHomeDrive;

		case FreeRDP_RedirectParallelPorts:
			return settings->RedirectParallelPorts;

		case FreeRDP_RedirectPrinters:
			return settings->RedirectPrinters;

		case FreeRDP_RedirectSerialPorts:
			return settings->RedirectSerialPorts;

		case FreeRDP_RedirectSmartCards:
			return settings->RedirectSmartCards;

		case FreeRDP_RedirectWebAuthN:
			return settings->RedirectWebAuthN;

		case FreeRDP_RefreshRect:
			return settings->RefreshRect;

		case FreeRDP_RemdeskVirtualChannel:
			return settings->RemdeskVirtualChannel;

		case FreeRDP_RemoteAppLanguageBarSupported:
			return settings->RemoteAppLanguageBarSupported;

		case FreeRDP_RemoteApplicationMode:
			return settings->RemoteApplicationMode;

		case FreeRDP_RemoteAssistanceMode:
			return settings->RemoteAssistanceMode;

		case FreeRDP_RemoteAssistanceRequestControl:
			return settings->RemoteAssistanceRequestControl;

		case FreeRDP_RemoteConsoleAudio:
			return settings->RemoteConsoleAudio;

		case FreeRDP_RemoteCredentialGuard:
			return settings->RemoteCredentialGuard;

		case FreeRDP_RemoteFxCodec:
			return settings->RemoteFxCodec;

		case FreeRDP_RemoteFxImageCodec:
			return settings->RemoteFxImageCodec;

		case FreeRDP_RemoteFxOnly:
			return settings->RemoteFxOnly;

		case FreeRDP_RestrictedAdminModeRequired:
			return settings->RestrictedAdminModeRequired;

		case FreeRDP_RestrictedAdminModeSupported:
			return settings->RestrictedAdminModeSupported;

		case FreeRDP_SaltedChecksum:
			return settings->SaltedChecksum;

		case FreeRDP_SendPreconnectionPdu:
			return settings->SendPreconnectionPdu;

		case FreeRDP_ServerLicenseRequired:
			return settings->ServerLicenseRequired;

		case FreeRDP_ServerMode:
			return settings->ServerMode;

		case FreeRDP_SmartSizing:
			return settings->SmartSizing;

		case FreeRDP_SmartcardEmulation:
			return settings->SmartcardEmulation;

		case FreeRDP_SmartcardLogon:
			return settings->SmartcardLogon;

		case FreeRDP_SoftwareGdi:
			return settings->SoftwareGdi;

		case FreeRDP_SoundBeepsEnabled:
			return settings->SoundBeepsEnabled;

		case FreeRDP_SpanMonitors:
			return settings->SpanMonitors;

		case FreeRDP_SupportAsymetricKeys:
			return settings->SupportAsymetricKeys;

		case FreeRDP_SupportDisplayControl:
			return settings->SupportDisplayControl;

		case FreeRDP_SupportDynamicChannels:
			return settings->SupportDynamicChannels;

		case FreeRDP_SupportDynamicTimeZone:
			return settings->SupportDynamicTimeZone;

		case FreeRDP_SupportEchoChannel:
			return settings->SupportEchoChannel;

		case FreeRDP_SupportEdgeActionV1:
			return settings->SupportEdgeActionV1;

		case FreeRDP_SupportEdgeActionV2:
			return settings->SupportEdgeActionV2;

		case FreeRDP_SupportErrorInfoPdu:
			return settings->SupportErrorInfoPdu;

		case FreeRDP_SupportGeometryTracking:
			return settings->SupportGeometryTracking;

		case FreeRDP_SupportGraphicsPipeline:
			return settings->SupportGraphicsPipeline;

		case FreeRDP_SupportHeartbeatPdu:
			return settings->SupportHeartbeatPdu;

		case FreeRDP_SupportMonitorLayoutPdu:
			return settings->SupportMonitorLayoutPdu;

		case FreeRDP_SupportMultitransport:
			return settings->SupportMultitransport;

		case FreeRDP_SupportSSHAgentChannel:
			return settings->SupportSSHAgentChannel;

		case FreeRDP_SupportSkipChannelJoin:
			return settings->SupportSkipChannelJoin;

		case FreeRDP_SupportStatusInfoPdu:
			return settings->SupportStatusInfoPdu;

		case FreeRDP_SupportVideoOptimized:
			return settings->SupportVideoOptimized;

		case FreeRDP_SuppressOutput:
			return settings->SuppressOutput;

		case FreeRDP_SurfaceCommandsEnabled:
			return settings->SurfaceCommandsEnabled;

		case FreeRDP_SurfaceFrameMarkerEnabled:
			return settings->SurfaceFrameMarkerEnabled;

		case FreeRDP_SuspendInput:
			return settings->SuspendInput;

		case FreeRDP_SynchronousDynamicChannels:
			return settings->SynchronousDynamicChannels;

		case FreeRDP_SynchronousStaticChannels:
			return settings->SynchronousStaticChannels;

		case FreeRDP_TcpKeepAlive:
			return settings->TcpKeepAlive;

		case FreeRDP_TlsSecurity:
			return settings->TlsSecurity;

		case FreeRDP_ToggleFullscreen:
			return settings->ToggleFullscreen;

		case FreeRDP_TransportDump:
			return settings->TransportDump;

		case FreeRDP_TransportDumpReplay:
			return settings->TransportDumpReplay;

		case FreeRDP_TransportDumpReplayNodelay:
			return settings->TransportDumpReplayNodelay;

		case FreeRDP_UnicodeInput:
			return settings->UnicodeInput;

		case FreeRDP_UnmapButtons:
			return settings->UnmapButtons;

		case FreeRDP_UseCommonStdioCallbacks:
			return settings->UseCommonStdioCallbacks;

		case FreeRDP_UseMultimon:
			return settings->UseMultimon;

		case FreeRDP_UseRdpSecurityLayer:
			return settings->UseRdpSecurityLayer;

		case FreeRDP_UsingSavedCredentials:
			return settings->UsingSavedCredentials;

		case FreeRDP_VideoDisable:
			return settings->VideoDisable;

		case FreeRDP_VmConnectMode:
			return settings->VmConnectMode;

		case FreeRDP_WaitForOutputBufferFlush:
			return settings->WaitForOutputBufferFlush;

		case FreeRDP_Workarea:
			return settings->Workarea;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return FALSE;
	}
}

BOOL freerdp_settings_set_bool(WINPR_ATTR_UNUSED rdpSettings* settings,
                               WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Bool id, BOOL val)
{
	union
	{
		void* v;
		const void* cv;
		BOOL c;
		const BOOL cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.c = val;

	switch (id)
	{
		case FreeRDP_AadSecurity:
			settings->AadSecurity = cnv.c;
			break;

		case FreeRDP_AllowCacheWaitingList:
			settings->AllowCacheWaitingList = cnv.c;
			break;

		case FreeRDP_AllowDesktopComposition:
			settings->AllowDesktopComposition = cnv.c;
			break;

		case FreeRDP_AllowFontSmoothing:
			settings->AllowFontSmoothing = cnv.c;
			break;

		case FreeRDP_AllowUnanouncedOrdersFromServer:
			settings->AllowUnanouncedOrdersFromServer = cnv.c;
			break;

		case FreeRDP_AltSecFrameMarkerSupport:
			settings->AltSecFrameMarkerSupport = cnv.c;
			break;

		case FreeRDP_AsyncChannels:
			settings->AsyncChannels = cnv.c;
			break;

		case FreeRDP_AsyncUpdate:
			settings->AsyncUpdate = cnv.c;
			break;

		case FreeRDP_AudioCapture:
			settings->AudioCapture = cnv.c;
			break;

		case FreeRDP_AudioPlayback:
			settings->AudioPlayback = cnv.c;
			break;

		case FreeRDP_Authentication:
			settings->Authentication = cnv.c;
			break;

		case FreeRDP_AuthenticationOnly:
			settings->AuthenticationOnly = cnv.c;
			break;

		case FreeRDP_AutoAcceptCertificate:
			settings->AutoAcceptCertificate = cnv.c;
			break;

		case FreeRDP_AutoDenyCertificate:
			settings->AutoDenyCertificate = cnv.c;
			break;

		case FreeRDP_AutoLogonEnabled:
			settings->AutoLogonEnabled = cnv.c;
			break;

		case FreeRDP_AutoReconnectionEnabled:
			settings->AutoReconnectionEnabled = cnv.c;
			break;

		case FreeRDP_AutoReconnectionPacketSupported:
			settings->AutoReconnectionPacketSupported = cnv.c;
			break;

		case FreeRDP_BitmapCacheEnabled:
			settings->BitmapCacheEnabled = cnv.c;
			break;

		case FreeRDP_BitmapCachePersistEnabled:
			settings->BitmapCachePersistEnabled = cnv.c;
			break;

		case FreeRDP_BitmapCacheV3Enabled:
			settings->BitmapCacheV3Enabled = cnv.c;
			break;

		case FreeRDP_BitmapCompressionDisabled:
			settings->BitmapCompressionDisabled = cnv.c;
			break;

		case FreeRDP_CertificateCallbackPreferPEM:
			settings->CertificateCallbackPreferPEM = cnv.c;
			break;

		case FreeRDP_CompressionEnabled:
			settings->CompressionEnabled = cnv.c;
			break;

		case FreeRDP_ConnectChildSession:
			settings->ConnectChildSession = cnv.c;
			break;

		case FreeRDP_ConsoleSession:
			settings->ConsoleSession = cnv.c;
			break;

		case FreeRDP_CredentialsFromStdin:
			settings->CredentialsFromStdin = cnv.c;
			break;

		case FreeRDP_DeactivateClientDecoding:
			settings->DeactivateClientDecoding = cnv.c;
			break;

		case FreeRDP_Decorations:
			settings->Decorations = cnv.c;
			break;

		case FreeRDP_DesktopResize:
			settings->DesktopResize = cnv.c;
			break;

		case FreeRDP_DeviceRedirection:
			settings->DeviceRedirection = cnv.c;
			break;

		case FreeRDP_DisableCredentialsDelegation:
			settings->DisableCredentialsDelegation = cnv.c;
			break;

		case FreeRDP_DisableCtrlAltDel:
			settings->DisableCtrlAltDel = cnv.c;
			break;

		case FreeRDP_DisableCursorBlinking:
			settings->DisableCursorBlinking = cnv.c;
			break;

		case FreeRDP_DisableCursorShadow:
			settings->DisableCursorShadow = cnv.c;
			break;

		case FreeRDP_DisableFullWindowDrag:
			settings->DisableFullWindowDrag = cnv.c;
			break;

		case FreeRDP_DisableMenuAnims:
			settings->DisableMenuAnims = cnv.c;
			break;

		case FreeRDP_DisableRemoteAppCapsCheck:
			settings->DisableRemoteAppCapsCheck = cnv.c;
			break;

		case FreeRDP_DisableThemes:
			settings->DisableThemes = cnv.c;
			break;

		case FreeRDP_DisableWallpaper:
			settings->DisableWallpaper = cnv.c;
			break;

		case FreeRDP_DrawAllowColorSubsampling:
			settings->DrawAllowColorSubsampling = cnv.c;
			break;

		case FreeRDP_DrawAllowDynamicColorFidelity:
			settings->DrawAllowDynamicColorFidelity = cnv.c;
			break;

		case FreeRDP_DrawAllowSkipAlpha:
			settings->DrawAllowSkipAlpha = cnv.c;
			break;

		case FreeRDP_DrawGdiPlusCacheEnabled:
			settings->DrawGdiPlusCacheEnabled = cnv.c;
			break;

		case FreeRDP_DrawGdiPlusEnabled:
			settings->DrawGdiPlusEnabled = cnv.c;
			break;

		case FreeRDP_DrawNineGridEnabled:
			settings->DrawNineGridEnabled = cnv.c;
			break;

		case FreeRDP_DumpRemoteFx:
			settings->DumpRemoteFx = cnv.c;
			break;

		case FreeRDP_DynamicDaylightTimeDisabled:
			settings->DynamicDaylightTimeDisabled = cnv.c;
			break;

		case FreeRDP_DynamicResolutionUpdate:
			settings->DynamicResolutionUpdate = cnv.c;
			break;

		case FreeRDP_EmbeddedWindow:
			settings->EmbeddedWindow = cnv.c;
			break;

		case FreeRDP_EnableWindowsKey:
			settings->EnableWindowsKey = cnv.c;
			break;

		case FreeRDP_EncomspVirtualChannel:
			settings->EncomspVirtualChannel = cnv.c;
			break;

		case FreeRDP_ExtSecurity:
			settings->ExtSecurity = cnv.c;
			break;

		case FreeRDP_ExternalCertificateManagement:
			settings->ExternalCertificateManagement = cnv.c;
			break;

		case FreeRDP_FIPSMode:
			settings->FIPSMode = cnv.c;
			break;

		case FreeRDP_FastPathInput:
			settings->FastPathInput = cnv.c;
			break;

		case FreeRDP_FastPathOutput:
			settings->FastPathOutput = cnv.c;
			break;

		case FreeRDP_ForceEncryptedCsPdu:
			settings->ForceEncryptedCsPdu = cnv.c;
			break;

		case FreeRDP_ForceMultimon:
			settings->ForceMultimon = cnv.c;
			break;

		case FreeRDP_FrameMarkerCommandEnabled:
			settings->FrameMarkerCommandEnabled = cnv.c;
			break;

		case FreeRDP_Fullscreen:
			settings->Fullscreen = cnv.c;
			break;

		case FreeRDP_GatewayArmTransport:
			settings->GatewayArmTransport = cnv.c;
			break;

		case FreeRDP_GatewayAvdUseTenantid:
			settings->GatewayAvdUseTenantid = cnv.c;
			break;

		case FreeRDP_GatewayBypassLocal:
			settings->GatewayBypassLocal = cnv.c;
			break;

		case FreeRDP_GatewayEnabled:
			settings->GatewayEnabled = cnv.c;
			break;

		case FreeRDP_GatewayHttpExtAuthSspiNtlm:
			settings->GatewayHttpExtAuthSspiNtlm = cnv.c;
			break;

		case FreeRDP_GatewayHttpTransport:
			settings->GatewayHttpTransport = cnv.c;
			break;

		case FreeRDP_GatewayHttpUseWebsockets:
			settings->GatewayHttpUseWebsockets = cnv.c;
			break;

		case FreeRDP_GatewayIgnoreRedirectionPolicy:
			settings->GatewayIgnoreRedirectionPolicy = cnv.c;
			break;

		case FreeRDP_GatewayRpcTransport:
			settings->GatewayRpcTransport = cnv.c;
			break;

		case FreeRDP_GatewayUdpTransport:
			settings->GatewayUdpTransport = cnv.c;
			break;

		case FreeRDP_GatewayUseSameCredentials:
			settings->GatewayUseSameCredentials = cnv.c;
			break;

		case FreeRDP_GfxAVC444:
			settings->GfxAVC444 = cnv.c;
			break;

		case FreeRDP_GfxAVC444v2:
			settings->GfxAVC444v2 = cnv.c;
			break;

		case FreeRDP_GfxH264:
			settings->GfxH264 = cnv.c;
			break;

		case FreeRDP_GfxPlanar:
			settings->GfxPlanar = cnv.c;
			break;

		case FreeRDP_GfxProgressive:
			settings->GfxProgressive = cnv.c;
			break;

		case FreeRDP_GfxProgressiveV2:
			settings->GfxProgressiveV2 = cnv.c;
			break;

		case FreeRDP_GfxSendQoeAck:
			settings->GfxSendQoeAck = cnv.c;
			break;

		case FreeRDP_GfxSmallCache:
			settings->GfxSmallCache = cnv.c;
			break;

		case FreeRDP_GfxSuspendFrameAck:
			settings->GfxSuspendFrameAck = cnv.c;
			break;

		case FreeRDP_GfxThinClient:
			settings->GfxThinClient = cnv.c;
			break;

		case FreeRDP_GrabKeyboard:
			settings->GrabKeyboard = cnv.c;
			break;

		case FreeRDP_GrabMouse:
			settings->GrabMouse = cnv.c;
			break;

		case FreeRDP_HasExtendedMouseEvent:
			settings->HasExtendedMouseEvent = cnv.c;
			break;

		case FreeRDP_HasHorizontalWheel:
			settings->HasHorizontalWheel = cnv.c;
			break;

		case FreeRDP_HasMonitorAttributes:
			settings->HasMonitorAttributes = cnv.c;
			break;

		case FreeRDP_HasQoeEvent:
			settings->HasQoeEvent = cnv.c;
			break;

		case FreeRDP_HasRelativeMouseEvent:
			settings->HasRelativeMouseEvent = cnv.c;
			break;

		case FreeRDP_HiDefRemoteApp:
			settings->HiDefRemoteApp = cnv.c;
			break;

		case FreeRDP_IPv6Enabled:
			settings->IPv6Enabled = cnv.c;
			break;

		case FreeRDP_IgnoreCertificate:
			settings->IgnoreCertificate = cnv.c;
			break;

		case FreeRDP_IgnoreInvalidDevices:
			settings->IgnoreInvalidDevices = cnv.c;
			break;

		case FreeRDP_JpegCodec:
			settings->JpegCodec = cnv.c;
			break;

		case FreeRDP_KerberosRdgIsProxy:
			settings->KerberosRdgIsProxy = cnv.c;
			break;

		case FreeRDP_ListMonitors:
			settings->ListMonitors = cnv.c;
			break;

		case FreeRDP_LocalConnection:
			settings->LocalConnection = cnv.c;
			break;

		case FreeRDP_LogonErrors:
			settings->LogonErrors = cnv.c;
			break;

		case FreeRDP_LogonNotify:
			settings->LogonNotify = cnv.c;
			break;

		case FreeRDP_LongCredentialsSupported:
			settings->LongCredentialsSupported = cnv.c;
			break;

		case FreeRDP_LyncRdpMode:
			settings->LyncRdpMode = cnv.c;
			break;

		case FreeRDP_MaximizeShell:
			settings->MaximizeShell = cnv.c;
			break;

		case FreeRDP_MouseAttached:
			settings->MouseAttached = cnv.c;
			break;

		case FreeRDP_MouseHasWheel:
			settings->MouseHasWheel = cnv.c;
			break;

		case FreeRDP_MouseMotion:
			settings->MouseMotion = cnv.c;
			break;

		case FreeRDP_MouseUseRelativeMove:
			settings->MouseUseRelativeMove = cnv.c;
			break;

		case FreeRDP_MstscCookieMode:
			settings->MstscCookieMode = cnv.c;
			break;

		case FreeRDP_MultiTouchGestures:
			settings->MultiTouchGestures = cnv.c;
			break;

		case FreeRDP_MultiTouchInput:
			settings->MultiTouchInput = cnv.c;
			break;

		case FreeRDP_NSCodec:
			settings->NSCodec = cnv.c;
			break;

		case FreeRDP_NSCodecAllowDynamicColorFidelity:
			settings->NSCodecAllowDynamicColorFidelity = cnv.c;
			break;

		case FreeRDP_NSCodecAllowSubsampling:
			settings->NSCodecAllowSubsampling = cnv.c;
			break;

		case FreeRDP_NegotiateSecurityLayer:
			settings->NegotiateSecurityLayer = cnv.c;
			break;

		case FreeRDP_NetworkAutoDetect:
			settings->NetworkAutoDetect = cnv.c;
			break;

		case FreeRDP_NlaSecurity:
			settings->NlaSecurity = cnv.c;
			break;

		case FreeRDP_NoBitmapCompressionHeader:
			settings->NoBitmapCompressionHeader = cnv.c;
			break;

		case FreeRDP_OldLicenseBehaviour:
			settings->OldLicenseBehaviour = cnv.c;
			break;

		case FreeRDP_PasswordIsSmartcardPin:
			settings->PasswordIsSmartcardPin = cnv.c;
			break;

		case FreeRDP_PercentScreenUseHeight:
			settings->PercentScreenUseHeight = cnv.c;
			break;

		case FreeRDP_PercentScreenUseWidth:
			settings->PercentScreenUseWidth = cnv.c;
			break;

		case FreeRDP_PlayRemoteFx:
			settings->PlayRemoteFx = cnv.c;
			break;

		case FreeRDP_PreferIPv6OverIPv4:
			settings->PreferIPv6OverIPv4 = cnv.c;
			break;

		case FreeRDP_PrintReconnectCookie:
			settings->PrintReconnectCookie = cnv.c;
			break;

		case FreeRDP_PromptForCredentials:
			settings->PromptForCredentials = cnv.c;
			break;

		case FreeRDP_RdpSecurity:
			settings->RdpSecurity = cnv.c;
			break;

		case FreeRDP_RdstlsSecurity:
			settings->RdstlsSecurity = cnv.c;
			break;

		case FreeRDP_RedirectClipboard:
			settings->RedirectClipboard = cnv.c;
			break;

		case FreeRDP_RedirectDrives:
			settings->RedirectDrives = cnv.c;
			break;

		case FreeRDP_RedirectHomeDrive:
			settings->RedirectHomeDrive = cnv.c;
			break;

		case FreeRDP_RedirectParallelPorts:
			settings->RedirectParallelPorts = cnv.c;
			break;

		case FreeRDP_RedirectPrinters:
			settings->RedirectPrinters = cnv.c;
			break;

		case FreeRDP_RedirectSerialPorts:
			settings->RedirectSerialPorts = cnv.c;
			break;

		case FreeRDP_RedirectSmartCards:
			settings->RedirectSmartCards = cnv.c;
			break;

		case FreeRDP_RedirectWebAuthN:
			settings->RedirectWebAuthN = cnv.c;
			break;

		case FreeRDP_RefreshRect:
			settings->RefreshRect = cnv.c;
			break;

		case FreeRDP_RemdeskVirtualChannel:
			settings->RemdeskVirtualChannel = cnv.c;
			break;

		case FreeRDP_RemoteAppLanguageBarSupported:
			settings->RemoteAppLanguageBarSupported = cnv.c;
			break;

		case FreeRDP_RemoteApplicationMode:
			settings->RemoteApplicationMode = cnv.c;
			break;

		case FreeRDP_RemoteAssistanceMode:
			settings->RemoteAssistanceMode = cnv.c;
			break;

		case FreeRDP_RemoteAssistanceRequestControl:
			settings->RemoteAssistanceRequestControl = cnv.c;
			break;

		case FreeRDP_RemoteConsoleAudio:
			settings->RemoteConsoleAudio = cnv.c;
			break;

		case FreeRDP_RemoteCredentialGuard:
			settings->RemoteCredentialGuard = cnv.c;
			break;

		case FreeRDP_RemoteFxCodec:
			settings->RemoteFxCodec = cnv.c;
			break;

		case FreeRDP_RemoteFxImageCodec:
			settings->RemoteFxImageCodec = cnv.c;
			break;

		case FreeRDP_RemoteFxOnly:
			settings->RemoteFxOnly = cnv.c;
			break;

		case FreeRDP_RestrictedAdminModeRequired:
			settings->RestrictedAdminModeRequired = cnv.c;
			break;

		case FreeRDP_RestrictedAdminModeSupported:
			settings->RestrictedAdminModeSupported = cnv.c;
			break;

		case FreeRDP_SaltedChecksum:
			settings->SaltedChecksum = cnv.c;
			break;

		case FreeRDP_SendPreconnectionPdu:
			settings->SendPreconnectionPdu = cnv.c;
			break;

		case FreeRDP_ServerLicenseRequired:
			settings->ServerLicenseRequired = cnv.c;
			break;

		case FreeRDP_ServerMode:
			settings->ServerMode = cnv.c;
			break;

		case FreeRDP_SmartSizing:
			settings->SmartSizing = cnv.c;
			break;

		case FreeRDP_SmartcardEmulation:
			settings->SmartcardEmulation = cnv.c;
			break;

		case FreeRDP_SmartcardLogon:
			settings->SmartcardLogon = cnv.c;
			break;

		case FreeRDP_SoftwareGdi:
			settings->SoftwareGdi = cnv.c;
			break;

		case FreeRDP_SoundBeepsEnabled:
			settings->SoundBeepsEnabled = cnv.c;
			break;

		case FreeRDP_SpanMonitors:
			settings->SpanMonitors = cnv.c;
			break;

		case FreeRDP_SupportAsymetricKeys:
			settings->SupportAsymetricKeys = cnv.c;
			break;

		case FreeRDP_SupportDisplayControl:
			settings->SupportDisplayControl = cnv.c;
			break;

		case FreeRDP_SupportDynamicChannels:
			settings->SupportDynamicChannels = cnv.c;
			break;

		case FreeRDP_SupportDynamicTimeZone:
			settings->SupportDynamicTimeZone = cnv.c;
			break;

		case FreeRDP_SupportEchoChannel:
			settings->SupportEchoChannel = cnv.c;
			break;

		case FreeRDP_SupportEdgeActionV1:
			settings->SupportEdgeActionV1 = cnv.c;
			break;

		case FreeRDP_SupportEdgeActionV2:
			settings->SupportEdgeActionV2 = cnv.c;
			break;

		case FreeRDP_SupportErrorInfoPdu:
			settings->SupportErrorInfoPdu = cnv.c;
			break;

		case FreeRDP_SupportGeometryTracking:
			settings->SupportGeometryTracking = cnv.c;
			break;

		case FreeRDP_SupportGraphicsPipeline:
			settings->SupportGraphicsPipeline = cnv.c;
			break;

		case FreeRDP_SupportHeartbeatPdu:
			settings->SupportHeartbeatPdu = cnv.c;
			break;

		case FreeRDP_SupportMonitorLayoutPdu:
			settings->SupportMonitorLayoutPdu = cnv.c;
			break;

		case FreeRDP_SupportMultitransport:
			settings->SupportMultitransport = cnv.c;
			break;

		case FreeRDP_SupportSSHAgentChannel:
			settings->SupportSSHAgentChannel = cnv.c;
			break;

		case FreeRDP_SupportSkipChannelJoin:
			settings->SupportSkipChannelJoin = cnv.c;
			break;

		case FreeRDP_SupportStatusInfoPdu:
			settings->SupportStatusInfoPdu = cnv.c;
			break;

		case FreeRDP_SupportVideoOptimized:
			settings->SupportVideoOptimized = cnv.c;
			break;

		case FreeRDP_SuppressOutput:
			settings->SuppressOutput = cnv.c;
			break;

		case FreeRDP_SurfaceCommandsEnabled:
			settings->SurfaceCommandsEnabled = cnv.c;
			break;

		case FreeRDP_SurfaceFrameMarkerEnabled:
			settings->SurfaceFrameMarkerEnabled = cnv.c;
			break;

		case FreeRDP_SuspendInput:
			settings->SuspendInput = cnv.c;
			break;

		case FreeRDP_SynchronousDynamicChannels:
			settings->SynchronousDynamicChannels = cnv.c;
			break;

		case FreeRDP_SynchronousStaticChannels:
			settings->SynchronousStaticChannels = cnv.c;
			break;

		case FreeRDP_TcpKeepAlive:
			settings->TcpKeepAlive = cnv.c;
			break;

		case FreeRDP_TlsSecurity:
			settings->TlsSecurity = cnv.c;
			break;

		case FreeRDP_ToggleFullscreen:
			settings->ToggleFullscreen = cnv.c;
			break;

		case FreeRDP_TransportDump:
			settings->TransportDump = cnv.c;
			break;

		case FreeRDP_TransportDumpReplay:
			settings->TransportDumpReplay = cnv.c;
			break;

		case FreeRDP_TransportDumpReplayNodelay:
			settings->TransportDumpReplayNodelay = cnv.c;
			break;

		case FreeRDP_UnicodeInput:
			settings->UnicodeInput = cnv.c;
			break;

		case FreeRDP_UnmapButtons:
			settings->UnmapButtons = cnv.c;
			break;

		case FreeRDP_UseCommonStdioCallbacks:
			settings->UseCommonStdioCallbacks = cnv.c;
			break;

		case FreeRDP_UseMultimon:
			settings->UseMultimon = cnv.c;
			break;

		case FreeRDP_UseRdpSecurityLayer:
			settings->UseRdpSecurityLayer = cnv.c;
			break;

		case FreeRDP_UsingSavedCredentials:
			settings->UsingSavedCredentials = cnv.c;
			break;

		case FreeRDP_VideoDisable:
			settings->VideoDisable = cnv.c;
			break;

		case FreeRDP_VmConnectMode:
			settings->VmConnectMode = cnv.c;
			break;

		case FreeRDP_WaitForOutputBufferFlush:
			settings->WaitForOutputBufferFlush = cnv.c;
			break;

		case FreeRDP_Workarea:
			settings->Workarea = cnv.c;
			break;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

UINT16 freerdp_settings_get_uint16(WINPR_ATTR_UNUSED const rdpSettings* settings,
                                   WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_UInt16 id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_CapsGeneralCompressionLevel:
			return settings->CapsGeneralCompressionLevel;

		case FreeRDP_CapsGeneralCompressionTypes:
			return settings->CapsGeneralCompressionTypes;

		case FreeRDP_CapsProtocolVersion:
			return settings->CapsProtocolVersion;

		case FreeRDP_CapsRemoteUnshareFlag:
			return settings->CapsRemoteUnshareFlag;

		case FreeRDP_CapsUpdateCapabilityFlag:
			return settings->CapsUpdateCapabilityFlag;

		case FreeRDP_DesktopOrientation:
			return settings->DesktopOrientation;

		case FreeRDP_OrderSupportFlags:
			return settings->OrderSupportFlags;

		case FreeRDP_OrderSupportFlagsEx:
			return settings->OrderSupportFlagsEx;

		case FreeRDP_ProxyPort:
			return settings->ProxyPort;

		case FreeRDP_SupportedColorDepths:
			return settings->SupportedColorDepths;

		case FreeRDP_TLSMaxVersion:
			return settings->TLSMaxVersion;

		case FreeRDP_TLSMinVersion:
			return settings->TLSMinVersion;

		case FreeRDP_TextANSICodePage:
			return settings->TextANSICodePage;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return 0;
	}
}

BOOL freerdp_settings_set_uint16(WINPR_ATTR_UNUSED rdpSettings* settings,
                                 WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_UInt16 id, UINT16 val)
{
	union
	{
		void* v;
		const void* cv;
		UINT16 c;
		const UINT16 cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.c = val;

	switch (id)
	{
		case FreeRDP_CapsGeneralCompressionLevel:
			settings->CapsGeneralCompressionLevel = cnv.c;
			break;

		case FreeRDP_CapsGeneralCompressionTypes:
			settings->CapsGeneralCompressionTypes = cnv.c;
			break;

		case FreeRDP_CapsProtocolVersion:
			settings->CapsProtocolVersion = cnv.c;
			break;

		case FreeRDP_CapsRemoteUnshareFlag:
			settings->CapsRemoteUnshareFlag = cnv.c;
			break;

		case FreeRDP_CapsUpdateCapabilityFlag:
			settings->CapsUpdateCapabilityFlag = cnv.c;
			break;

		case FreeRDP_DesktopOrientation:
			settings->DesktopOrientation = cnv.c;
			break;

		case FreeRDP_OrderSupportFlags:
			settings->OrderSupportFlags = cnv.c;
			break;

		case FreeRDP_OrderSupportFlagsEx:
			settings->OrderSupportFlagsEx = cnv.c;
			break;

		case FreeRDP_ProxyPort:
			settings->ProxyPort = cnv.c;
			break;

		case FreeRDP_SupportedColorDepths:
			settings->SupportedColorDepths = cnv.c;
			break;

		case FreeRDP_TLSMaxVersion:
			settings->TLSMaxVersion = cnv.c;
			break;

		case FreeRDP_TLSMinVersion:
			settings->TLSMinVersion = cnv.c;
			break;

		case FreeRDP_TextANSICodePage:
			settings->TextANSICodePage = cnv.c;
			break;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

INT16 freerdp_settings_get_int16(WINPR_ATTR_UNUSED const rdpSettings* settings,
                                 WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Int16 id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return 0;
	}
}

BOOL freerdp_settings_set_int16(WINPR_ATTR_UNUSED rdpSettings* settings,
                                WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Int16 id, INT16 val)
{
	union
	{
		void* v;
		const void* cv;
		INT16 c;
		const INT16 cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.c = val;

	switch (id)
	{
		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

UINT32 freerdp_settings_get_uint32(WINPR_ATTR_UNUSED const rdpSettings* settings,
                                   WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_UInt32 id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_AcceptedCertLength:
			return settings->AcceptedCertLength;

		case FreeRDP_AuthenticationLevel:
			return settings->AuthenticationLevel;

		case FreeRDP_AutoReconnectMaxRetries:
			return settings->AutoReconnectMaxRetries;

		case FreeRDP_BitmapCacheV2NumCells:
			return settings->BitmapCacheV2NumCells;

		case FreeRDP_BitmapCacheV3CodecId:
			return settings->BitmapCacheV3CodecId;

		case FreeRDP_BitmapCacheVersion:
			return settings->BitmapCacheVersion;

		case FreeRDP_BrushSupportLevel:
			return settings->BrushSupportLevel;

		case FreeRDP_ChannelCount:
			return settings->ChannelCount;

		case FreeRDP_ChannelDefArraySize:
			return settings->ChannelDefArraySize;

		case FreeRDP_ClientBuild:
			return settings->ClientBuild;

		case FreeRDP_ClientRandomLength:
			return settings->ClientRandomLength;

		case FreeRDP_ClientSessionId:
			return settings->ClientSessionId;

		case FreeRDP_ClipboardFeatureMask:
			return settings->ClipboardFeatureMask;

		case FreeRDP_ClusterInfoFlags:
			return settings->ClusterInfoFlags;

		case FreeRDP_ColorDepth:
			return settings->ColorDepth;

		case FreeRDP_ColorPointerCacheSize:
			return settings->ColorPointerCacheSize;

		case FreeRDP_CompDeskSupportLevel:
			return settings->CompDeskSupportLevel;

		case FreeRDP_CompressionLevel:
			return settings->CompressionLevel;

		case FreeRDP_ConnectionType:
			return settings->ConnectionType;

		case FreeRDP_CookieMaxLength:
			return settings->CookieMaxLength;

		case FreeRDP_DesktopHeight:
			return settings->DesktopHeight;

		case FreeRDP_DesktopPhysicalHeight:
			return settings->DesktopPhysicalHeight;

		case FreeRDP_DesktopPhysicalWidth:
			return settings->DesktopPhysicalWidth;

		case FreeRDP_DesktopPosX:
			return settings->DesktopPosX;

		case FreeRDP_DesktopPosY:
			return settings->DesktopPosY;

		case FreeRDP_DesktopScaleFactor:
			return settings->DesktopScaleFactor;

		case FreeRDP_DesktopWidth:
			return settings->DesktopWidth;

		case FreeRDP_DeviceArraySize:
			return settings->DeviceArraySize;

		case FreeRDP_DeviceCount:
			return settings->DeviceCount;

		case FreeRDP_DeviceScaleFactor:
			return settings->DeviceScaleFactor;

		case FreeRDP_DrawNineGridCacheEntries:
			return settings->DrawNineGridCacheEntries;

		case FreeRDP_DrawNineGridCacheSize:
			return settings->DrawNineGridCacheSize;

		case FreeRDP_DynamicChannelArraySize:
			return settings->DynamicChannelArraySize;

		case FreeRDP_DynamicChannelCount:
			return settings->DynamicChannelCount;

		case FreeRDP_EarlyCapabilityFlags:
			return settings->EarlyCapabilityFlags;

		case FreeRDP_EncryptionLevel:
			return settings->EncryptionLevel;

		case FreeRDP_EncryptionMethods:
			return settings->EncryptionMethods;

		case FreeRDP_ExtEncryptionMethods:
			return settings->ExtEncryptionMethods;

		case FreeRDP_FakeMouseMotionInterval:
			return settings->FakeMouseMotionInterval;

		case FreeRDP_Floatbar:
			return settings->Floatbar;

		case FreeRDP_ForceIPvX:
			return settings->ForceIPvX;

		case FreeRDP_FrameAcknowledge:
			return settings->FrameAcknowledge;

		case FreeRDP_GatewayAcceptedCertLength:
			return settings->GatewayAcceptedCertLength;

		case FreeRDP_GatewayCredentialsSource:
			return settings->GatewayCredentialsSource;

		case FreeRDP_GatewayPort:
			return settings->GatewayPort;

		case FreeRDP_GatewayUsageMethod:
			return settings->GatewayUsageMethod;

		case FreeRDP_GfxCapsFilter:
			return settings->GfxCapsFilter;

		case FreeRDP_GlyphSupportLevel:
			return settings->GlyphSupportLevel;

		case FreeRDP_JpegCodecId:
			return settings->JpegCodecId;

		case FreeRDP_JpegQuality:
			return settings->JpegQuality;

		case FreeRDP_KeySpec:
			return settings->KeySpec;

		case FreeRDP_KeyboardCodePage:
			return settings->KeyboardCodePage;

		case FreeRDP_KeyboardFunctionKey:
			return settings->KeyboardFunctionKey;

		case FreeRDP_KeyboardHook:
			return settings->KeyboardHook;

		case FreeRDP_KeyboardLayout:
			return settings->KeyboardLayout;

		case FreeRDP_KeyboardSubType:
			return settings->KeyboardSubType;

		case FreeRDP_KeyboardType:
			return settings->KeyboardType;

		case FreeRDP_LargePointerFlag:
			return settings->LargePointerFlag;

		case FreeRDP_LoadBalanceInfoLength:
			return settings->LoadBalanceInfoLength;

		case FreeRDP_MonitorAttributeFlags:
			return settings->MonitorAttributeFlags;

		case FreeRDP_MonitorCount:
			return settings->MonitorCount;

		case FreeRDP_MonitorDefArraySize:
			return settings->MonitorDefArraySize;

		case FreeRDP_MonitorFlags:
			return settings->MonitorFlags;

		case FreeRDP_MultifragMaxRequestSize:
			return settings->MultifragMaxRequestSize;

		case FreeRDP_MultitransportFlags:
			return settings->MultitransportFlags;

		case FreeRDP_NSCodecColorLossLevel:
			return settings->NSCodecColorLossLevel;

		case FreeRDP_NSCodecId:
			return settings->NSCodecId;

		case FreeRDP_NegotiationFlags:
			return settings->NegotiationFlags;

		case FreeRDP_NumMonitorIds:
			return settings->NumMonitorIds;

		case FreeRDP_OffscreenCacheEntries:
			return settings->OffscreenCacheEntries;

		case FreeRDP_OffscreenCacheSize:
			return settings->OffscreenCacheSize;

		case FreeRDP_OffscreenSupportLevel:
			return settings->OffscreenSupportLevel;

		case FreeRDP_OsMajorType:
			return settings->OsMajorType;

		case FreeRDP_OsMinorType:
			return settings->OsMinorType;

		case FreeRDP_Password51Length:
			return settings->Password51Length;

		case FreeRDP_PduSource:
			return settings->PduSource;

		case FreeRDP_PercentScreen:
			return settings->PercentScreen;

		case FreeRDP_PerformanceFlags:
			return settings->PerformanceFlags;

		case FreeRDP_PointerCacheSize:
			return settings->PointerCacheSize;

		case FreeRDP_PreconnectionId:
			return settings->PreconnectionId;

		case FreeRDP_ProxyType:
			return settings->ProxyType;

		case FreeRDP_RdpVersion:
			return settings->RdpVersion;

		case FreeRDP_ReceivedCapabilitiesSize:
			return settings->ReceivedCapabilitiesSize;

		case FreeRDP_RedirectedSessionId:
			return settings->RedirectedSessionId;

		case FreeRDP_RedirectionAcceptedCertLength:
			return settings->RedirectionAcceptedCertLength;

		case FreeRDP_RedirectionFlags:
			return settings->RedirectionFlags;

		case FreeRDP_RedirectionGuidLength:
			return settings->RedirectionGuidLength;

		case FreeRDP_RedirectionPasswordLength:
			return settings->RedirectionPasswordLength;

		case FreeRDP_RedirectionPreferType:
			return settings->RedirectionPreferType;

		case FreeRDP_RedirectionTsvUrlLength:
			return settings->RedirectionTsvUrlLength;

		case FreeRDP_RemoteAppNumIconCacheEntries:
			return settings->RemoteAppNumIconCacheEntries;

		case FreeRDP_RemoteAppNumIconCaches:
			return settings->RemoteAppNumIconCaches;

		case FreeRDP_RemoteApplicationExpandCmdLine:
			return settings->RemoteApplicationExpandCmdLine;

		case FreeRDP_RemoteApplicationExpandWorkingDir:
			return settings->RemoteApplicationExpandWorkingDir;

		case FreeRDP_RemoteApplicationSupportLevel:
			return settings->RemoteApplicationSupportLevel;

		case FreeRDP_RemoteApplicationSupportMask:
			return settings->RemoteApplicationSupportMask;

		case FreeRDP_RemoteFxCaptureFlags:
			return settings->RemoteFxCaptureFlags;

		case FreeRDP_RemoteFxCodecId:
			return settings->RemoteFxCodecId;

		case FreeRDP_RemoteFxCodecMode:
			return settings->RemoteFxCodecMode;

		case FreeRDP_RemoteFxRlgrMode:
			return settings->RemoteFxRlgrMode;

		case FreeRDP_RemoteWndSupportLevel:
			return settings->RemoteWndSupportLevel;

		case FreeRDP_RequestedProtocols:
			return settings->RequestedProtocols;

		case FreeRDP_SelectedProtocol:
			return settings->SelectedProtocol;

		case FreeRDP_ServerCertificateLength:
			return settings->ServerCertificateLength;

		case FreeRDP_ServerLicenseProductIssuersCount:
			return settings->ServerLicenseProductIssuersCount;

		case FreeRDP_ServerLicenseProductVersion:
			return settings->ServerLicenseProductVersion;

		case FreeRDP_ServerPort:
			return settings->ServerPort;

		case FreeRDP_ServerRandomLength:
			return settings->ServerRandomLength;

		case FreeRDP_ShareId:
			return settings->ShareId;

		case FreeRDP_SmartSizingHeight:
			return settings->SmartSizingHeight;

		case FreeRDP_SmartSizingWidth:
			return settings->SmartSizingWidth;

		case FreeRDP_StaticChannelArraySize:
			return settings->StaticChannelArraySize;

		case FreeRDP_StaticChannelCount:
			return settings->StaticChannelCount;

		case FreeRDP_SurfaceCommandsSupported:
			return settings->SurfaceCommandsSupported;

		case FreeRDP_TargetNetAddressCount:
			return settings->TargetNetAddressCount;

		case FreeRDP_TcpAckTimeout:
			return settings->TcpAckTimeout;

		case FreeRDP_TcpConnectTimeout:
			return settings->TcpConnectTimeout;

		case FreeRDP_TcpKeepAliveDelay:
			return settings->TcpKeepAliveDelay;

		case FreeRDP_TcpKeepAliveInterval:
			return settings->TcpKeepAliveInterval;

		case FreeRDP_TcpKeepAliveRetries:
			return settings->TcpKeepAliveRetries;

		case FreeRDP_ThreadingFlags:
			return settings->ThreadingFlags;

		case FreeRDP_TlsSecLevel:
			return settings->TlsSecLevel;

		case FreeRDP_VCChunkSize:
			return settings->VCChunkSize;

		case FreeRDP_VCFlags:
			return settings->VCFlags;

#if !defined(WITHOUT_FREERDP_3x_DEPRECATED)
		// API Compatibility section, remove with FreeRDP 4.x
		case (FreeRDP_Settings_Keys_UInt32)FreeRDP_MonitorLocalShiftX:
			return (UINT32)settings->MonitorLocalShiftX;

		// API Compatibility section, remove with FreeRDP 4.x
		case (FreeRDP_Settings_Keys_UInt32)FreeRDP_MonitorLocalShiftY:
			return (UINT32)settings->MonitorLocalShiftY;

#endif
		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return 0;
	}
}

BOOL freerdp_settings_set_uint32(WINPR_ATTR_UNUSED rdpSettings* settings,
                                 WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_UInt32 id, UINT32 val)
{
	union
	{
		void* v;
		const void* cv;
		UINT32 c;
		const UINT32 cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.c = val;

	switch (id)
	{
		case FreeRDP_AcceptedCertLength:
			settings->AcceptedCertLength = cnv.c;
			break;

		case FreeRDP_AuthenticationLevel:
			settings->AuthenticationLevel = cnv.c;
			break;

		case FreeRDP_AutoReconnectMaxRetries:
			settings->AutoReconnectMaxRetries = cnv.c;
			break;

		case FreeRDP_BitmapCacheV2NumCells:
			settings->BitmapCacheV2NumCells = cnv.c;
			break;

		case FreeRDP_BitmapCacheV3CodecId:
			settings->BitmapCacheV3CodecId = cnv.c;
			break;

		case FreeRDP_BitmapCacheVersion:
			settings->BitmapCacheVersion = cnv.c;
			break;

		case FreeRDP_BrushSupportLevel:
			settings->BrushSupportLevel = cnv.c;
			break;

		case FreeRDP_ChannelCount:
			settings->ChannelCount = cnv.c;
			break;

		case FreeRDP_ChannelDefArraySize:
			settings->ChannelDefArraySize = cnv.c;
			break;

		case FreeRDP_ClientBuild:
			settings->ClientBuild = cnv.c;
			break;

		case FreeRDP_ClientRandomLength:
			settings->ClientRandomLength = cnv.c;
			break;

		case FreeRDP_ClientSessionId:
			settings->ClientSessionId = cnv.c;
			break;

		case FreeRDP_ClipboardFeatureMask:
			settings->ClipboardFeatureMask = cnv.c;
			break;

		case FreeRDP_ClusterInfoFlags:
			settings->ClusterInfoFlags = cnv.c;
			break;

		case FreeRDP_ColorDepth:
			settings->ColorDepth = cnv.c;
			break;

		case FreeRDP_ColorPointerCacheSize:
			settings->ColorPointerCacheSize = cnv.c;
			break;

		case FreeRDP_CompDeskSupportLevel:
			settings->CompDeskSupportLevel = cnv.c;
			break;

		case FreeRDP_CompressionLevel:
			settings->CompressionLevel = cnv.c;
			break;

		case FreeRDP_ConnectionType:
			settings->ConnectionType = cnv.c;
			break;

		case FreeRDP_CookieMaxLength:
			settings->CookieMaxLength = cnv.c;
			break;

		case FreeRDP_DesktopHeight:
			settings->DesktopHeight = cnv.c;
			break;

		case FreeRDP_DesktopPhysicalHeight:
			settings->DesktopPhysicalHeight = cnv.c;
			break;

		case FreeRDP_DesktopPhysicalWidth:
			settings->DesktopPhysicalWidth = cnv.c;
			break;

		case FreeRDP_DesktopPosX:
			settings->DesktopPosX = cnv.c;
			break;

		case FreeRDP_DesktopPosY:
			settings->DesktopPosY = cnv.c;
			break;

		case FreeRDP_DesktopScaleFactor:
			settings->DesktopScaleFactor = cnv.c;
			break;

		case FreeRDP_DesktopWidth:
			settings->DesktopWidth = cnv.c;
			break;

		case FreeRDP_DeviceArraySize:
			settings->DeviceArraySize = cnv.c;
			break;

		case FreeRDP_DeviceCount:
			settings->DeviceCount = cnv.c;
			break;

		case FreeRDP_DeviceScaleFactor:
			settings->DeviceScaleFactor = cnv.c;
			break;

		case FreeRDP_DrawNineGridCacheEntries:
			settings->DrawNineGridCacheEntries = cnv.c;
			break;

		case FreeRDP_DrawNineGridCacheSize:
			settings->DrawNineGridCacheSize = cnv.c;
			break;

		case FreeRDP_DynamicChannelArraySize:
			settings->DynamicChannelArraySize = cnv.c;
			break;

		case FreeRDP_DynamicChannelCount:
			settings->DynamicChannelCount = cnv.c;
			break;

		case FreeRDP_EarlyCapabilityFlags:
			settings->EarlyCapabilityFlags = cnv.c;
			break;

		case FreeRDP_EncryptionLevel:
			settings->EncryptionLevel = cnv.c;
			break;

		case FreeRDP_EncryptionMethods:
			settings->EncryptionMethods = cnv.c;
			break;

		case FreeRDP_ExtEncryptionMethods:
			settings->ExtEncryptionMethods = cnv.c;
			break;

		case FreeRDP_FakeMouseMotionInterval:
			settings->FakeMouseMotionInterval = cnv.c;
			break;

		case FreeRDP_Floatbar:
			settings->Floatbar = cnv.c;
			break;

		case FreeRDP_ForceIPvX:
			settings->ForceIPvX = cnv.c;
			break;

		case FreeRDP_FrameAcknowledge:
			settings->FrameAcknowledge = cnv.c;
			break;

		case FreeRDP_GatewayAcceptedCertLength:
			settings->GatewayAcceptedCertLength = cnv.c;
			break;

		case FreeRDP_GatewayCredentialsSource:
			settings->GatewayCredentialsSource = cnv.c;
			break;

		case FreeRDP_GatewayPort:
			settings->GatewayPort = cnv.c;
			break;

		case FreeRDP_GatewayUsageMethod:
			settings->GatewayUsageMethod = cnv.c;
			break;

		case FreeRDP_GfxCapsFilter:
			settings->GfxCapsFilter = cnv.c;
			break;

		case FreeRDP_GlyphSupportLevel:
			settings->GlyphSupportLevel = cnv.c;
			break;

		case FreeRDP_JpegCodecId:
			settings->JpegCodecId = cnv.c;
			break;

		case FreeRDP_JpegQuality:
			settings->JpegQuality = cnv.c;
			break;

		case FreeRDP_KeySpec:
			settings->KeySpec = cnv.c;
			break;

		case FreeRDP_KeyboardCodePage:
			settings->KeyboardCodePage = cnv.c;
			break;

		case FreeRDP_KeyboardFunctionKey:
			settings->KeyboardFunctionKey = cnv.c;
			break;

		case FreeRDP_KeyboardHook:
			settings->KeyboardHook = cnv.c;
			break;

		case FreeRDP_KeyboardLayout:
			settings->KeyboardLayout = cnv.c;
			break;

		case FreeRDP_KeyboardSubType:
			settings->KeyboardSubType = cnv.c;
			break;

		case FreeRDP_KeyboardType:
			settings->KeyboardType = cnv.c;
			break;

		case FreeRDP_LargePointerFlag:
			settings->LargePointerFlag = cnv.c;
			break;

		case FreeRDP_LoadBalanceInfoLength:
			settings->LoadBalanceInfoLength = cnv.c;
			break;

		case FreeRDP_MonitorAttributeFlags:
			settings->MonitorAttributeFlags = cnv.c;
			break;

		case FreeRDP_MonitorCount:
			settings->MonitorCount = cnv.c;
			break;

		case FreeRDP_MonitorDefArraySize:
			settings->MonitorDefArraySize = cnv.c;
			break;

		case FreeRDP_MonitorFlags:
			settings->MonitorFlags = cnv.c;
			break;

		case FreeRDP_MultifragMaxRequestSize:
			settings->MultifragMaxRequestSize = cnv.c;
			break;

		case FreeRDP_MultitransportFlags:
			settings->MultitransportFlags = cnv.c;
			break;

		case FreeRDP_NSCodecColorLossLevel:
			settings->NSCodecColorLossLevel = cnv.c;
			break;

		case FreeRDP_NSCodecId:
			settings->NSCodecId = cnv.c;
			break;

		case FreeRDP_NegotiationFlags:
			settings->NegotiationFlags = cnv.c;
			break;

		case FreeRDP_NumMonitorIds:
			settings->NumMonitorIds = cnv.c;
			break;

		case FreeRDP_OffscreenCacheEntries:
			settings->OffscreenCacheEntries = cnv.c;
			break;

		case FreeRDP_OffscreenCacheSize:
			settings->OffscreenCacheSize = cnv.c;
			break;

		case FreeRDP_OffscreenSupportLevel:
			settings->OffscreenSupportLevel = cnv.c;
			break;

		case FreeRDP_OsMajorType:
			settings->OsMajorType = cnv.c;
			break;

		case FreeRDP_OsMinorType:
			settings->OsMinorType = cnv.c;
			break;

		case FreeRDP_Password51Length:
			settings->Password51Length = cnv.c;
			break;

		case FreeRDP_PduSource:
			settings->PduSource = cnv.c;
			break;

		case FreeRDP_PercentScreen:
			settings->PercentScreen = cnv.c;
			break;

		case FreeRDP_PerformanceFlags:
			settings->PerformanceFlags = cnv.c;
			break;

		case FreeRDP_PointerCacheSize:
			settings->PointerCacheSize = cnv.c;
			break;

		case FreeRDP_PreconnectionId:
			settings->PreconnectionId = cnv.c;
			break;

		case FreeRDP_ProxyType:
			settings->ProxyType = cnv.c;
			break;

		case FreeRDP_RdpVersion:
			settings->RdpVersion = cnv.c;
			break;

		case FreeRDP_ReceivedCapabilitiesSize:
			settings->ReceivedCapabilitiesSize = cnv.c;
			break;

		case FreeRDP_RedirectedSessionId:
			settings->RedirectedSessionId = cnv.c;
			break;

		case FreeRDP_RedirectionAcceptedCertLength:
			settings->RedirectionAcceptedCertLength = cnv.c;
			break;

		case FreeRDP_RedirectionFlags:
			settings->RedirectionFlags = cnv.c;
			break;

		case FreeRDP_RedirectionGuidLength:
			settings->RedirectionGuidLength = cnv.c;
			break;

		case FreeRDP_RedirectionPasswordLength:
			settings->RedirectionPasswordLength = cnv.c;
			break;

		case FreeRDP_RedirectionPreferType:
			settings->RedirectionPreferType = cnv.c;
			break;

		case FreeRDP_RedirectionTsvUrlLength:
			settings->RedirectionTsvUrlLength = cnv.c;
			break;

		case FreeRDP_RemoteAppNumIconCacheEntries:
			settings->RemoteAppNumIconCacheEntries = cnv.c;
			break;

		case FreeRDP_RemoteAppNumIconCaches:
			settings->RemoteAppNumIconCaches = cnv.c;
			break;

		case FreeRDP_RemoteApplicationExpandCmdLine:
			settings->RemoteApplicationExpandCmdLine = cnv.c;
			break;

		case FreeRDP_RemoteApplicationExpandWorkingDir:
			settings->RemoteApplicationExpandWorkingDir = cnv.c;
			break;

		case FreeRDP_RemoteApplicationSupportLevel:
			settings->RemoteApplicationSupportLevel = cnv.c;
			break;

		case FreeRDP_RemoteApplicationSupportMask:
			settings->RemoteApplicationSupportMask = cnv.c;
			break;

		case FreeRDP_RemoteFxCaptureFlags:
			settings->RemoteFxCaptureFlags = cnv.c;
			break;

		case FreeRDP_RemoteFxCodecId:
			settings->RemoteFxCodecId = cnv.c;
			break;

		case FreeRDP_RemoteFxCodecMode:
			settings->RemoteFxCodecMode = cnv.c;
			break;

		case FreeRDP_RemoteFxRlgrMode:
			settings->RemoteFxRlgrMode = cnv.c;
			break;

		case FreeRDP_RemoteWndSupportLevel:
			settings->RemoteWndSupportLevel = cnv.c;
			break;

		case FreeRDP_RequestedProtocols:
			settings->RequestedProtocols = cnv.c;
			break;

		case FreeRDP_SelectedProtocol:
			settings->SelectedProtocol = cnv.c;
			break;

		case FreeRDP_ServerCertificateLength:
			settings->ServerCertificateLength = cnv.c;
			break;

		case FreeRDP_ServerLicenseProductIssuersCount:
			settings->ServerLicenseProductIssuersCount = cnv.c;
			break;

		case FreeRDP_ServerLicenseProductVersion:
			settings->ServerLicenseProductVersion = cnv.c;
			break;

		case FreeRDP_ServerPort:
			settings->ServerPort = cnv.c;
			break;

		case FreeRDP_ServerRandomLength:
			settings->ServerRandomLength = cnv.c;
			break;

		case FreeRDP_ShareId:
			settings->ShareId = cnv.c;
			break;

		case FreeRDP_SmartSizingHeight:
			settings->SmartSizingHeight = cnv.c;
			break;

		case FreeRDP_SmartSizingWidth:
			settings->SmartSizingWidth = cnv.c;
			break;

		case FreeRDP_StaticChannelArraySize:
			settings->StaticChannelArraySize = cnv.c;
			break;

		case FreeRDP_StaticChannelCount:
			settings->StaticChannelCount = cnv.c;
			break;

		case FreeRDP_SurfaceCommandsSupported:
			settings->SurfaceCommandsSupported = cnv.c;
			break;

		case FreeRDP_TargetNetAddressCount:
			settings->TargetNetAddressCount = cnv.c;
			break;

		case FreeRDP_TcpAckTimeout:
			settings->TcpAckTimeout = cnv.c;
			break;

		case FreeRDP_TcpConnectTimeout:
			settings->TcpConnectTimeout = cnv.c;
			break;

		case FreeRDP_TcpKeepAliveDelay:
			settings->TcpKeepAliveDelay = cnv.c;
			break;

		case FreeRDP_TcpKeepAliveInterval:
			settings->TcpKeepAliveInterval = cnv.c;
			break;

		case FreeRDP_TcpKeepAliveRetries:
			settings->TcpKeepAliveRetries = cnv.c;
			break;

		case FreeRDP_ThreadingFlags:
			settings->ThreadingFlags = cnv.c;
			break;

		case FreeRDP_TlsSecLevel:
			settings->TlsSecLevel = cnv.c;
			break;

		case FreeRDP_VCChunkSize:
			settings->VCChunkSize = cnv.c;
			break;

		case FreeRDP_VCFlags:
			settings->VCFlags = cnv.c;
			break;

#if !defined(WITHOUT_FREERDP_3x_DEPRECATED)
		// API Compatibility section, remove with FreeRDP 4.x
		case FreeRDP_MonitorLocalShiftX:
			settings->MonitorLocalShiftX = (int32_t)cnv.c;
			break;

		// API Compatibility section, remove with FreeRDP 4.x
		case FreeRDP_MonitorLocalShiftY:
			settings->MonitorLocalShiftY = (int32_t)cnv.c;
			break;

#endif
		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

INT32 freerdp_settings_get_int32(WINPR_ATTR_UNUSED const rdpSettings* settings,
                                 WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Int32 id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_MonitorLocalShiftX:
			return settings->MonitorLocalShiftX;

		case FreeRDP_MonitorLocalShiftY:
			return settings->MonitorLocalShiftY;

		case FreeRDP_XPan:
			return settings->XPan;

		case FreeRDP_YPan:
			return settings->YPan;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return 0;
	}
}

BOOL freerdp_settings_set_int32(WINPR_ATTR_UNUSED rdpSettings* settings,
                                WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Int32 id, INT32 val)
{
	union
	{
		void* v;
		const void* cv;
		INT32 c;
		const INT32 cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.c = val;

	switch (id)
	{
		case FreeRDP_MonitorLocalShiftX:
			settings->MonitorLocalShiftX = cnv.c;
			break;

		case FreeRDP_MonitorLocalShiftY:
			settings->MonitorLocalShiftY = cnv.c;
			break;

		case FreeRDP_XPan:
			settings->XPan = cnv.c;
			break;

		case FreeRDP_YPan:
			settings->YPan = cnv.c;
			break;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

UINT64 freerdp_settings_get_uint64(WINPR_ATTR_UNUSED const rdpSettings* settings,
                                   WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_UInt64 id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_MonitorOverrideFlags:
			return settings->MonitorOverrideFlags;

		case FreeRDP_ParentWindowId:
			return settings->ParentWindowId;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return 0;
	}
}

BOOL freerdp_settings_set_uint64(WINPR_ATTR_UNUSED rdpSettings* settings,
                                 WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_UInt64 id, UINT64 val)
{
	union
	{
		void* v;
		const void* cv;
		UINT64 c;
		const UINT64 cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.c = val;

	switch (id)
	{
		case FreeRDP_MonitorOverrideFlags:
			settings->MonitorOverrideFlags = cnv.c;
			break;

		case FreeRDP_ParentWindowId:
			settings->ParentWindowId = cnv.c;
			break;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

INT64 freerdp_settings_get_int64(WINPR_ATTR_UNUSED const rdpSettings* settings,
                                 WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Int64 id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return 0;
	}
}

BOOL freerdp_settings_set_int64(WINPR_ATTR_UNUSED rdpSettings* settings,
                                WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Int64 id, INT64 val)
{
	union
	{
		void* v;
		const void* cv;
		INT64 c;
		const INT64 cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.c = val;

	switch (id)
	{
		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

const char* freerdp_settings_get_string(WINPR_ATTR_UNUSED const rdpSettings* settings,
                                        WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_String id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_AadServerHostname:
			return settings->AadServerHostname;

		case FreeRDP_AcceptedCert:
			return settings->AcceptedCert;

		case FreeRDP_ActionScript:
			return settings->ActionScript;

		case FreeRDP_AllowedTlsCiphers:
			return settings->AllowedTlsCiphers;

		case FreeRDP_AlternateShell:
			return settings->AlternateShell;

		case FreeRDP_AssistanceFile:
			return settings->AssistanceFile;

		case FreeRDP_AuthenticationPackageList:
			return settings->AuthenticationPackageList;

		case FreeRDP_AuthenticationServiceClass:
			return settings->AuthenticationServiceClass;

		case FreeRDP_BitmapCachePersistFile:
			return settings->BitmapCachePersistFile;

		case FreeRDP_CardName:
			return settings->CardName;

		case FreeRDP_CertificateAcceptedFingerprints:
			return settings->CertificateAcceptedFingerprints;

		case FreeRDP_CertificateName:
			return settings->CertificateName;

		case FreeRDP_ClientAddress:
			return settings->ClientAddress;

		case FreeRDP_ClientDir:
			return settings->ClientDir;

		case FreeRDP_ClientHostname:
			return settings->ClientHostname;

		case FreeRDP_ClientProductId:
			return settings->ClientProductId;

		case FreeRDP_ClipboardUseSelection:
			return settings->ClipboardUseSelection;

		case FreeRDP_ComputerName:
			return settings->ComputerName;

		case FreeRDP_ConfigPath:
			return settings->ConfigPath;

		case FreeRDP_ConnectionFile:
			return settings->ConnectionFile;

		case FreeRDP_ContainerName:
			return settings->ContainerName;

		case FreeRDP_CspName:
			return settings->CspName;

		case FreeRDP_CurrentPath:
			return settings->CurrentPath;

		case FreeRDP_Domain:
			return settings->Domain;

		case FreeRDP_DrivesToRedirect:
			return settings->DrivesToRedirect;

		case FreeRDP_DumpRemoteFxFile:
			return settings->DumpRemoteFxFile;

		case FreeRDP_DynamicDSTTimeZoneKeyName:
			return settings->DynamicDSTTimeZoneKeyName;

		case FreeRDP_GatewayAcceptedCert:
			return settings->GatewayAcceptedCert;

		case FreeRDP_GatewayAccessToken:
			return settings->GatewayAccessToken;

		case FreeRDP_GatewayAvdAadtenantid:
			return settings->GatewayAvdAadtenantid;

		case FreeRDP_GatewayAvdAccessAadFormat:
			return settings->GatewayAvdAccessAadFormat;

		case FreeRDP_GatewayAvdAccessTokenFormat:
			return settings->GatewayAvdAccessTokenFormat;

		case FreeRDP_GatewayAvdActivityhint:
			return settings->GatewayAvdActivityhint;

		case FreeRDP_GatewayAvdArmpath:
			return settings->GatewayAvdArmpath;

		case FreeRDP_GatewayAvdClientID:
			return settings->GatewayAvdClientID;

		case FreeRDP_GatewayAvdDiagnosticserviceurl:
			return settings->GatewayAvdDiagnosticserviceurl;

		case FreeRDP_GatewayAvdGeo:
			return settings->GatewayAvdGeo;

		case FreeRDP_GatewayAvdHubdiscoverygeourl:
			return settings->GatewayAvdHubdiscoverygeourl;

		case FreeRDP_GatewayAvdScope:
			return settings->GatewayAvdScope;

		case FreeRDP_GatewayAvdWvdEndpointPool:
			return settings->GatewayAvdWvdEndpointPool;

		case FreeRDP_GatewayAzureActiveDirectory:
			return settings->GatewayAzureActiveDirectory;

		case FreeRDP_GatewayDomain:
			return settings->GatewayDomain;

		case FreeRDP_GatewayHostname:
			return settings->GatewayHostname;

		case FreeRDP_GatewayHttpExtAuthBearer:
			return settings->GatewayHttpExtAuthBearer;

		case FreeRDP_GatewayHttpMsUserAgent:
			return settings->GatewayHttpMsUserAgent;

		case FreeRDP_GatewayHttpReferer:
			return settings->GatewayHttpReferer;

		case FreeRDP_GatewayHttpUserAgent:
			return settings->GatewayHttpUserAgent;

		case FreeRDP_GatewayPassword:
			return settings->GatewayPassword;

		case FreeRDP_GatewayUrl:
			return settings->GatewayUrl;

		case FreeRDP_GatewayUsername:
			return settings->GatewayUsername;

		case FreeRDP_HomePath:
			return settings->HomePath;

		case FreeRDP_ImeFileName:
			return settings->ImeFileName;

		case FreeRDP_KerberosArmor:
			return settings->KerberosArmor;

		case FreeRDP_KerberosCache:
			return settings->KerberosCache;

		case FreeRDP_KerberosKdcUrl:
			return settings->KerberosKdcUrl;

		case FreeRDP_KerberosKeytab:
			return settings->KerberosKeytab;

		case FreeRDP_KerberosLifeTime:
			return settings->KerberosLifeTime;

		case FreeRDP_KerberosRealm:
			return settings->KerberosRealm;

		case FreeRDP_KerberosRenewableLifeTime:
			return settings->KerberosRenewableLifeTime;

		case FreeRDP_KerberosStartTime:
			return settings->KerberosStartTime;

		case FreeRDP_KeyboardPipeName:
			return settings->KeyboardPipeName;

		case FreeRDP_KeyboardRemappingList:
			return settings->KeyboardRemappingList;

		case FreeRDP_NtlmSamFile:
			return settings->NtlmSamFile;

		case FreeRDP_Password:
			return settings->Password;

		case FreeRDP_PasswordHash:
			return settings->PasswordHash;

		case FreeRDP_Pkcs11Module:
			return settings->Pkcs11Module;

		case FreeRDP_PkinitAnchors:
			return settings->PkinitAnchors;

		case FreeRDP_PlayRemoteFxFile:
			return settings->PlayRemoteFxFile;

		case FreeRDP_PreconnectionBlob:
			return settings->PreconnectionBlob;

		case FreeRDP_ProxyHostname:
			return settings->ProxyHostname;

		case FreeRDP_ProxyPassword:
			return settings->ProxyPassword;

		case FreeRDP_ProxyUsername:
			return settings->ProxyUsername;

		case FreeRDP_RDP2TCPArgs:
			return settings->RDP2TCPArgs;

		case FreeRDP_ReaderName:
			return settings->ReaderName;

		case FreeRDP_RedirectionAcceptedCert:
			return settings->RedirectionAcceptedCert;

		case FreeRDP_RedirectionDomain:
			return settings->RedirectionDomain;

		case FreeRDP_RedirectionTargetFQDN:
			return settings->RedirectionTargetFQDN;

		case FreeRDP_RedirectionTargetNetBiosName:
			return settings->RedirectionTargetNetBiosName;

		case FreeRDP_RedirectionUsername:
			return settings->RedirectionUsername;

		case FreeRDP_RemoteApplicationCmdLine:
			return settings->RemoteApplicationCmdLine;

		case FreeRDP_RemoteApplicationFile:
			return settings->RemoteApplicationFile;

		case FreeRDP_RemoteApplicationGuid:
			return settings->RemoteApplicationGuid;

		case FreeRDP_RemoteApplicationIcon:
			return settings->RemoteApplicationIcon;

		case FreeRDP_RemoteApplicationName:
			return settings->RemoteApplicationName;

		case FreeRDP_RemoteApplicationProgram:
			return settings->RemoteApplicationProgram;

		case FreeRDP_RemoteApplicationWorkingDir:
			return settings->RemoteApplicationWorkingDir;

		case FreeRDP_RemoteAssistancePassStub:
			return settings->RemoteAssistancePassStub;

		case FreeRDP_RemoteAssistancePassword:
			return settings->RemoteAssistancePassword;

		case FreeRDP_RemoteAssistanceRCTicket:
			return settings->RemoteAssistanceRCTicket;

		case FreeRDP_RemoteAssistanceSessionId:
			return settings->RemoteAssistanceSessionId;

		case FreeRDP_ServerHostname:
			return settings->ServerHostname;

		case FreeRDP_ServerLicenseCompanyName:
			return settings->ServerLicenseCompanyName;

		case FreeRDP_ServerLicenseProductName:
			return settings->ServerLicenseProductName;

		case FreeRDP_ShellWorkingDirectory:
			return settings->ShellWorkingDirectory;

		case FreeRDP_SmartcardCertificate:
			return settings->SmartcardCertificate;

		case FreeRDP_SmartcardPrivateKey:
			return settings->SmartcardPrivateKey;

		case FreeRDP_SspiModule:
			return settings->SspiModule;

		case FreeRDP_TargetNetAddress:
			return settings->TargetNetAddress;

		case FreeRDP_TerminalDescriptor:
			return settings->TerminalDescriptor;

		case FreeRDP_TlsSecretsFile:
			return settings->TlsSecretsFile;

		case FreeRDP_TransportDumpFile:
			return settings->TransportDumpFile;

		case FreeRDP_UserSpecifiedServerName:
			return settings->UserSpecifiedServerName;

		case FreeRDP_Username:
			return settings->Username;

		case FreeRDP_WinSCardModule:
			return settings->WinSCardModule;

		case FreeRDP_WindowTitle:
			return settings->WindowTitle;

		case FreeRDP_WmClass:
			return settings->WmClass;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return NULL;
	}
}

char* freerdp_settings_get_string_writable(rdpSettings* settings, FreeRDP_Settings_Keys_String id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_AadServerHostname:
			return settings->AadServerHostname;

		case FreeRDP_AcceptedCert:
			return settings->AcceptedCert;

		case FreeRDP_ActionScript:
			return settings->ActionScript;

		case FreeRDP_AllowedTlsCiphers:
			return settings->AllowedTlsCiphers;

		case FreeRDP_AlternateShell:
			return settings->AlternateShell;

		case FreeRDP_AssistanceFile:
			return settings->AssistanceFile;

		case FreeRDP_AuthenticationPackageList:
			return settings->AuthenticationPackageList;

		case FreeRDP_AuthenticationServiceClass:
			return settings->AuthenticationServiceClass;

		case FreeRDP_BitmapCachePersistFile:
			return settings->BitmapCachePersistFile;

		case FreeRDP_CardName:
			return settings->CardName;

		case FreeRDP_CertificateAcceptedFingerprints:
			return settings->CertificateAcceptedFingerprints;

		case FreeRDP_CertificateName:
			return settings->CertificateName;

		case FreeRDP_ClientAddress:
			return settings->ClientAddress;

		case FreeRDP_ClientDir:
			return settings->ClientDir;

		case FreeRDP_ClientHostname:
			return settings->ClientHostname;

		case FreeRDP_ClientProductId:
			return settings->ClientProductId;

		case FreeRDP_ClipboardUseSelection:
			return settings->ClipboardUseSelection;

		case FreeRDP_ComputerName:
			return settings->ComputerName;

		case FreeRDP_ConfigPath:
			return settings->ConfigPath;

		case FreeRDP_ConnectionFile:
			return settings->ConnectionFile;

		case FreeRDP_ContainerName:
			return settings->ContainerName;

		case FreeRDP_CspName:
			return settings->CspName;

		case FreeRDP_CurrentPath:
			return settings->CurrentPath;

		case FreeRDP_Domain:
			return settings->Domain;

		case FreeRDP_DrivesToRedirect:
			return settings->DrivesToRedirect;

		case FreeRDP_DumpRemoteFxFile:
			return settings->DumpRemoteFxFile;

		case FreeRDP_DynamicDSTTimeZoneKeyName:
			return settings->DynamicDSTTimeZoneKeyName;

		case FreeRDP_GatewayAcceptedCert:
			return settings->GatewayAcceptedCert;

		case FreeRDP_GatewayAccessToken:
			return settings->GatewayAccessToken;

		case FreeRDP_GatewayAvdAadtenantid:
			return settings->GatewayAvdAadtenantid;

		case FreeRDP_GatewayAvdAccessAadFormat:
			return settings->GatewayAvdAccessAadFormat;

		case FreeRDP_GatewayAvdAccessTokenFormat:
			return settings->GatewayAvdAccessTokenFormat;

		case FreeRDP_GatewayAvdActivityhint:
			return settings->GatewayAvdActivityhint;

		case FreeRDP_GatewayAvdArmpath:
			return settings->GatewayAvdArmpath;

		case FreeRDP_GatewayAvdClientID:
			return settings->GatewayAvdClientID;

		case FreeRDP_GatewayAvdDiagnosticserviceurl:
			return settings->GatewayAvdDiagnosticserviceurl;

		case FreeRDP_GatewayAvdGeo:
			return settings->GatewayAvdGeo;

		case FreeRDP_GatewayAvdHubdiscoverygeourl:
			return settings->GatewayAvdHubdiscoverygeourl;

		case FreeRDP_GatewayAvdScope:
			return settings->GatewayAvdScope;

		case FreeRDP_GatewayAvdWvdEndpointPool:
			return settings->GatewayAvdWvdEndpointPool;

		case FreeRDP_GatewayAzureActiveDirectory:
			return settings->GatewayAzureActiveDirectory;

		case FreeRDP_GatewayDomain:
			return settings->GatewayDomain;

		case FreeRDP_GatewayHostname:
			return settings->GatewayHostname;

		case FreeRDP_GatewayHttpExtAuthBearer:
			return settings->GatewayHttpExtAuthBearer;

		case FreeRDP_GatewayHttpMsUserAgent:
			return settings->GatewayHttpMsUserAgent;

		case FreeRDP_GatewayHttpReferer:
			return settings->GatewayHttpReferer;

		case FreeRDP_GatewayHttpUserAgent:
			return settings->GatewayHttpUserAgent;

		case FreeRDP_GatewayPassword:
			return settings->GatewayPassword;

		case FreeRDP_GatewayUrl:
			return settings->GatewayUrl;

		case FreeRDP_GatewayUsername:
			return settings->GatewayUsername;

		case FreeRDP_HomePath:
			return settings->HomePath;

		case FreeRDP_ImeFileName:
			return settings->ImeFileName;

		case FreeRDP_KerberosArmor:
			return settings->KerberosArmor;

		case FreeRDP_KerberosCache:
			return settings->KerberosCache;

		case FreeRDP_KerberosKdcUrl:
			return settings->KerberosKdcUrl;

		case FreeRDP_KerberosKeytab:
			return settings->KerberosKeytab;

		case FreeRDP_KerberosLifeTime:
			return settings->KerberosLifeTime;

		case FreeRDP_KerberosRealm:
			return settings->KerberosRealm;

		case FreeRDP_KerberosRenewableLifeTime:
			return settings->KerberosRenewableLifeTime;

		case FreeRDP_KerberosStartTime:
			return settings->KerberosStartTime;

		case FreeRDP_KeyboardPipeName:
			return settings->KeyboardPipeName;

		case FreeRDP_KeyboardRemappingList:
			return settings->KeyboardRemappingList;

		case FreeRDP_NtlmSamFile:
			return settings->NtlmSamFile;

		case FreeRDP_Password:
			return settings->Password;

		case FreeRDP_PasswordHash:
			return settings->PasswordHash;

		case FreeRDP_Pkcs11Module:
			return settings->Pkcs11Module;

		case FreeRDP_PkinitAnchors:
			return settings->PkinitAnchors;

		case FreeRDP_PlayRemoteFxFile:
			return settings->PlayRemoteFxFile;

		case FreeRDP_PreconnectionBlob:
			return settings->PreconnectionBlob;

		case FreeRDP_ProxyHostname:
			return settings->ProxyHostname;

		case FreeRDP_ProxyPassword:
			return settings->ProxyPassword;

		case FreeRDP_ProxyUsername:
			return settings->ProxyUsername;

		case FreeRDP_RDP2TCPArgs:
			return settings->RDP2TCPArgs;

		case FreeRDP_ReaderName:
			return settings->ReaderName;

		case FreeRDP_RedirectionAcceptedCert:
			return settings->RedirectionAcceptedCert;

		case FreeRDP_RedirectionDomain:
			return settings->RedirectionDomain;

		case FreeRDP_RedirectionTargetFQDN:
			return settings->RedirectionTargetFQDN;

		case FreeRDP_RedirectionTargetNetBiosName:
			return settings->RedirectionTargetNetBiosName;

		case FreeRDP_RedirectionUsername:
			return settings->RedirectionUsername;

		case FreeRDP_RemoteApplicationCmdLine:
			return settings->RemoteApplicationCmdLine;

		case FreeRDP_RemoteApplicationFile:
			return settings->RemoteApplicationFile;

		case FreeRDP_RemoteApplicationGuid:
			return settings->RemoteApplicationGuid;

		case FreeRDP_RemoteApplicationIcon:
			return settings->RemoteApplicationIcon;

		case FreeRDP_RemoteApplicationName:
			return settings->RemoteApplicationName;

		case FreeRDP_RemoteApplicationProgram:
			return settings->RemoteApplicationProgram;

		case FreeRDP_RemoteApplicationWorkingDir:
			return settings->RemoteApplicationWorkingDir;

		case FreeRDP_RemoteAssistancePassStub:
			return settings->RemoteAssistancePassStub;

		case FreeRDP_RemoteAssistancePassword:
			return settings->RemoteAssistancePassword;

		case FreeRDP_RemoteAssistanceRCTicket:
			return settings->RemoteAssistanceRCTicket;

		case FreeRDP_RemoteAssistanceSessionId:
			return settings->RemoteAssistanceSessionId;

		case FreeRDP_ServerHostname:
			return settings->ServerHostname;

		case FreeRDP_ServerLicenseCompanyName:
			return settings->ServerLicenseCompanyName;

		case FreeRDP_ServerLicenseProductName:
			return settings->ServerLicenseProductName;

		case FreeRDP_ShellWorkingDirectory:
			return settings->ShellWorkingDirectory;

		case FreeRDP_SmartcardCertificate:
			return settings->SmartcardCertificate;

		case FreeRDP_SmartcardPrivateKey:
			return settings->SmartcardPrivateKey;

		case FreeRDP_SspiModule:
			return settings->SspiModule;

		case FreeRDP_TargetNetAddress:
			return settings->TargetNetAddress;

		case FreeRDP_TerminalDescriptor:
			return settings->TerminalDescriptor;

		case FreeRDP_TlsSecretsFile:
			return settings->TlsSecretsFile;

		case FreeRDP_TransportDumpFile:
			return settings->TransportDumpFile;

		case FreeRDP_UserSpecifiedServerName:
			return settings->UserSpecifiedServerName;

		case FreeRDP_Username:
			return settings->Username;

		case FreeRDP_WinSCardModule:
			return settings->WinSCardModule;

		case FreeRDP_WindowTitle:
			return settings->WindowTitle;

		case FreeRDP_WmClass:
			return settings->WmClass;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return NULL;
	}
}

BOOL freerdp_settings_set_string_(WINPR_ATTR_UNUSED rdpSettings* settings,
                                  WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_String id,
                                  const char* val, size_t len)
{
	union
	{
		void* v;
		const void* cv;
		char* c;
		const char* cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.cc = val;

	switch (id)
	{
		case FreeRDP_AadServerHostname:
			return update_string_(&settings->AadServerHostname, cnv.c, len);

		case FreeRDP_AcceptedCert:
			return update_string_(&settings->AcceptedCert, cnv.c, len);

		case FreeRDP_ActionScript:
			return update_string_(&settings->ActionScript, cnv.c, len);

		case FreeRDP_AllowedTlsCiphers:
			return update_string_(&settings->AllowedTlsCiphers, cnv.c, len);

		case FreeRDP_AlternateShell:
			return update_string_(&settings->AlternateShell, cnv.c, len);

		case FreeRDP_AssistanceFile:
			return update_string_(&settings->AssistanceFile, cnv.c, len);

		case FreeRDP_AuthenticationPackageList:
			return update_string_(&settings->AuthenticationPackageList, cnv.c, len);

		case FreeRDP_AuthenticationServiceClass:
			return update_string_(&settings->AuthenticationServiceClass, cnv.c, len);

		case FreeRDP_BitmapCachePersistFile:
			return update_string_(&settings->BitmapCachePersistFile, cnv.c, len);

		case FreeRDP_CardName:
			return update_string_(&settings->CardName, cnv.c, len);

		case FreeRDP_CertificateAcceptedFingerprints:
			return update_string_(&settings->CertificateAcceptedFingerprints, cnv.c, len);

		case FreeRDP_CertificateName:
			return update_string_(&settings->CertificateName, cnv.c, len);

		case FreeRDP_ClientAddress:
			return update_string_(&settings->ClientAddress, cnv.c, len);

		case FreeRDP_ClientDir:
			return update_string_(&settings->ClientDir, cnv.c, len);

		case FreeRDP_ClientHostname:
			return update_string_(&settings->ClientHostname, cnv.c, len);

		case FreeRDP_ClientProductId:
			return update_string_(&settings->ClientProductId, cnv.c, len);

		case FreeRDP_ClipboardUseSelection:
			return update_string_(&settings->ClipboardUseSelection, cnv.c, len);

		case FreeRDP_ComputerName:
			return update_string_(&settings->ComputerName, cnv.c, len);

		case FreeRDP_ConfigPath:
			return update_string_(&settings->ConfigPath, cnv.c, len);

		case FreeRDP_ConnectionFile:
			return update_string_(&settings->ConnectionFile, cnv.c, len);

		case FreeRDP_ContainerName:
			return update_string_(&settings->ContainerName, cnv.c, len);

		case FreeRDP_CspName:
			return update_string_(&settings->CspName, cnv.c, len);

		case FreeRDP_CurrentPath:
			return update_string_(&settings->CurrentPath, cnv.c, len);

		case FreeRDP_Domain:
			return update_string_(&settings->Domain, cnv.c, len);

		case FreeRDP_DrivesToRedirect:
			return update_string_(&settings->DrivesToRedirect, cnv.c, len);

		case FreeRDP_DumpRemoteFxFile:
			return update_string_(&settings->DumpRemoteFxFile, cnv.c, len);

		case FreeRDP_DynamicDSTTimeZoneKeyName:
			return update_string_(&settings->DynamicDSTTimeZoneKeyName, cnv.c, len);

		case FreeRDP_GatewayAcceptedCert:
			return update_string_(&settings->GatewayAcceptedCert, cnv.c, len);

		case FreeRDP_GatewayAccessToken:
			return update_string_(&settings->GatewayAccessToken, cnv.c, len);

		case FreeRDP_GatewayAvdAadtenantid:
			return update_string_(&settings->GatewayAvdAadtenantid, cnv.c, len);

		case FreeRDP_GatewayAvdAccessAadFormat:
			return update_string_(&settings->GatewayAvdAccessAadFormat, cnv.c, len);

		case FreeRDP_GatewayAvdAccessTokenFormat:
			return update_string_(&settings->GatewayAvdAccessTokenFormat, cnv.c, len);

		case FreeRDP_GatewayAvdActivityhint:
			return update_string_(&settings->GatewayAvdActivityhint, cnv.c, len);

		case FreeRDP_GatewayAvdArmpath:
			return update_string_(&settings->GatewayAvdArmpath, cnv.c, len);

		case FreeRDP_GatewayAvdClientID:
			return update_string_(&settings->GatewayAvdClientID, cnv.c, len);

		case FreeRDP_GatewayAvdDiagnosticserviceurl:
			return update_string_(&settings->GatewayAvdDiagnosticserviceurl, cnv.c, len);

		case FreeRDP_GatewayAvdGeo:
			return update_string_(&settings->GatewayAvdGeo, cnv.c, len);

		case FreeRDP_GatewayAvdHubdiscoverygeourl:
			return update_string_(&settings->GatewayAvdHubdiscoverygeourl, cnv.c, len);

		case FreeRDP_GatewayAvdScope:
			return update_string_(&settings->GatewayAvdScope, cnv.c, len);

		case FreeRDP_GatewayAvdWvdEndpointPool:
			return update_string_(&settings->GatewayAvdWvdEndpointPool, cnv.c, len);

		case FreeRDP_GatewayAzureActiveDirectory:
			return update_string_(&settings->GatewayAzureActiveDirectory, cnv.c, len);

		case FreeRDP_GatewayDomain:
			return update_string_(&settings->GatewayDomain, cnv.c, len);

		case FreeRDP_GatewayHostname:
			return update_string_(&settings->GatewayHostname, cnv.c, len);

		case FreeRDP_GatewayHttpExtAuthBearer:
			return update_string_(&settings->GatewayHttpExtAuthBearer, cnv.c, len);

		case FreeRDP_GatewayHttpMsUserAgent:
			return update_string_(&settings->GatewayHttpMsUserAgent, cnv.c, len);

		case FreeRDP_GatewayHttpReferer:
			return update_string_(&settings->GatewayHttpReferer, cnv.c, len);

		case FreeRDP_GatewayHttpUserAgent:
			return update_string_(&settings->GatewayHttpUserAgent, cnv.c, len);

		case FreeRDP_GatewayPassword:
			return update_string_(&settings->GatewayPassword, cnv.c, len);

		case FreeRDP_GatewayUrl:
			return update_string_(&settings->GatewayUrl, cnv.c, len);

		case FreeRDP_GatewayUsername:
			return update_string_(&settings->GatewayUsername, cnv.c, len);

		case FreeRDP_HomePath:
			return update_string_(&settings->HomePath, cnv.c, len);

		case FreeRDP_ImeFileName:
			return update_string_(&settings->ImeFileName, cnv.c, len);

		case FreeRDP_KerberosArmor:
			return update_string_(&settings->KerberosArmor, cnv.c, len);

		case FreeRDP_KerberosCache:
			return update_string_(&settings->KerberosCache, cnv.c, len);

		case FreeRDP_KerberosKdcUrl:
			return update_string_(&settings->KerberosKdcUrl, cnv.c, len);

		case FreeRDP_KerberosKeytab:
			return update_string_(&settings->KerberosKeytab, cnv.c, len);

		case FreeRDP_KerberosLifeTime:
			return update_string_(&settings->KerberosLifeTime, cnv.c, len);

		case FreeRDP_KerberosRealm:
			return update_string_(&settings->KerberosRealm, cnv.c, len);

		case FreeRDP_KerberosRenewableLifeTime:
			return update_string_(&settings->KerberosRenewableLifeTime, cnv.c, len);

		case FreeRDP_KerberosStartTime:
			return update_string_(&settings->KerberosStartTime, cnv.c, len);

		case FreeRDP_KeyboardPipeName:
			return update_string_(&settings->KeyboardPipeName, cnv.c, len);

		case FreeRDP_KeyboardRemappingList:
			return update_string_(&settings->KeyboardRemappingList, cnv.c, len);

		case FreeRDP_NtlmSamFile:
			return update_string_(&settings->NtlmSamFile, cnv.c, len);

		case FreeRDP_Password:
			return update_string_(&settings->Password, cnv.c, len);

		case FreeRDP_PasswordHash:
			return update_string_(&settings->PasswordHash, cnv.c, len);

		case FreeRDP_Pkcs11Module:
			return update_string_(&settings->Pkcs11Module, cnv.c, len);

		case FreeRDP_PkinitAnchors:
			return update_string_(&settings->PkinitAnchors, cnv.c, len);

		case FreeRDP_PlayRemoteFxFile:
			return update_string_(&settings->PlayRemoteFxFile, cnv.c, len);

		case FreeRDP_PreconnectionBlob:
			return update_string_(&settings->PreconnectionBlob, cnv.c, len);

		case FreeRDP_ProxyHostname:
			return update_string_(&settings->ProxyHostname, cnv.c, len);

		case FreeRDP_ProxyPassword:
			return update_string_(&settings->ProxyPassword, cnv.c, len);

		case FreeRDP_ProxyUsername:
			return update_string_(&settings->ProxyUsername, cnv.c, len);

		case FreeRDP_RDP2TCPArgs:
			return update_string_(&settings->RDP2TCPArgs, cnv.c, len);

		case FreeRDP_ReaderName:
			return update_string_(&settings->ReaderName, cnv.c, len);

		case FreeRDP_RedirectionAcceptedCert:
			return update_string_(&settings->RedirectionAcceptedCert, cnv.c, len);

		case FreeRDP_RedirectionDomain:
			return update_string_(&settings->RedirectionDomain, cnv.c, len);

		case FreeRDP_RedirectionTargetFQDN:
			return update_string_(&settings->RedirectionTargetFQDN, cnv.c, len);

		case FreeRDP_RedirectionTargetNetBiosName:
			return update_string_(&settings->RedirectionTargetNetBiosName, cnv.c, len);

		case FreeRDP_RedirectionUsername:
			return update_string_(&settings->RedirectionUsername, cnv.c, len);

		case FreeRDP_RemoteApplicationCmdLine:
			return update_string_(&settings->RemoteApplicationCmdLine, cnv.c, len);

		case FreeRDP_RemoteApplicationFile:
			return update_string_(&settings->RemoteApplicationFile, cnv.c, len);

		case FreeRDP_RemoteApplicationGuid:
			return update_string_(&settings->RemoteApplicationGuid, cnv.c, len);

		case FreeRDP_RemoteApplicationIcon:
			return update_string_(&settings->RemoteApplicationIcon, cnv.c, len);

		case FreeRDP_RemoteApplicationName:
			return update_string_(&settings->RemoteApplicationName, cnv.c, len);

		case FreeRDP_RemoteApplicationProgram:
			return update_string_(&settings->RemoteApplicationProgram, cnv.c, len);

		case FreeRDP_RemoteApplicationWorkingDir:
			return update_string_(&settings->RemoteApplicationWorkingDir, cnv.c, len);

		case FreeRDP_RemoteAssistancePassStub:
			return update_string_(&settings->RemoteAssistancePassStub, cnv.c, len);

		case FreeRDP_RemoteAssistancePassword:
			return update_string_(&settings->RemoteAssistancePassword, cnv.c, len);

		case FreeRDP_RemoteAssistanceRCTicket:
			return update_string_(&settings->RemoteAssistanceRCTicket, cnv.c, len);

		case FreeRDP_RemoteAssistanceSessionId:
			return update_string_(&settings->RemoteAssistanceSessionId, cnv.c, len);

		case FreeRDP_ServerHostname:
			return update_string_(&settings->ServerHostname, cnv.c, len);

		case FreeRDP_ServerLicenseCompanyName:
			return update_string_(&settings->ServerLicenseCompanyName, cnv.c, len);

		case FreeRDP_ServerLicenseProductName:
			return update_string_(&settings->ServerLicenseProductName, cnv.c, len);

		case FreeRDP_ShellWorkingDirectory:
			return update_string_(&settings->ShellWorkingDirectory, cnv.c, len);

		case FreeRDP_SmartcardCertificate:
			return update_string_(&settings->SmartcardCertificate, cnv.c, len);

		case FreeRDP_SmartcardPrivateKey:
			return update_string_(&settings->SmartcardPrivateKey, cnv.c, len);

		case FreeRDP_SspiModule:
			return update_string_(&settings->SspiModule, cnv.c, len);

		case FreeRDP_TargetNetAddress:
			return update_string_(&settings->TargetNetAddress, cnv.c, len);

		case FreeRDP_TerminalDescriptor:
			return update_string_(&settings->TerminalDescriptor, cnv.c, len);

		case FreeRDP_TlsSecretsFile:
			return update_string_(&settings->TlsSecretsFile, cnv.c, len);

		case FreeRDP_TransportDumpFile:
			return update_string_(&settings->TransportDumpFile, cnv.c, len);

		case FreeRDP_UserSpecifiedServerName:
			return update_string_(&settings->UserSpecifiedServerName, cnv.c, len);

		case FreeRDP_Username:
			return update_string_(&settings->Username, cnv.c, len);

		case FreeRDP_WinSCardModule:
			return update_string_(&settings->WinSCardModule, cnv.c, len);

		case FreeRDP_WindowTitle:
			return update_string_(&settings->WindowTitle, cnv.c, len);

		case FreeRDP_WmClass:
			return update_string_(&settings->WmClass, cnv.c, len);

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

BOOL freerdp_settings_set_string_len(rdpSettings* settings, FreeRDP_Settings_Keys_String id,
                                     const char* val, size_t len)
{
	return freerdp_settings_set_string_copy_(settings, id, val, len, TRUE);
}

BOOL freerdp_settings_set_string(rdpSettings* settings, FreeRDP_Settings_Keys_String id,
                                 const char* val)
{
	size_t len = 0;
	if (val)
		len = strlen(val);
	return freerdp_settings_set_string_copy_(settings, id, val, len, TRUE);
}

BOOL freerdp_settings_set_string_copy_(WINPR_ATTR_UNUSED rdpSettings* settings,
                                       WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_String id,
                                       const char* val, size_t len, BOOL cleanup)
{
	union
	{
		void* v;
		const void* cv;
		char* c;
		const char* cc;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.cc = val;

	switch (id)
	{
		case FreeRDP_AadServerHostname:
			return update_string_copy_(&settings->AadServerHostname, cnv.cc, len, cleanup);

		case FreeRDP_AcceptedCert:
			return update_string_copy_(&settings->AcceptedCert, cnv.cc, len, cleanup);

		case FreeRDP_ActionScript:
			return update_string_copy_(&settings->ActionScript, cnv.cc, len, cleanup);

		case FreeRDP_AllowedTlsCiphers:
			return update_string_copy_(&settings->AllowedTlsCiphers, cnv.cc, len, cleanup);

		case FreeRDP_AlternateShell:
			return update_string_copy_(&settings->AlternateShell, cnv.cc, len, cleanup);

		case FreeRDP_AssistanceFile:
			return update_string_copy_(&settings->AssistanceFile, cnv.cc, len, cleanup);

		case FreeRDP_AuthenticationPackageList:
			return update_string_copy_(&settings->AuthenticationPackageList, cnv.cc, len, cleanup);

		case FreeRDP_AuthenticationServiceClass:
			return update_string_copy_(&settings->AuthenticationServiceClass, cnv.cc, len, cleanup);

		case FreeRDP_BitmapCachePersistFile:
			return update_string_copy_(&settings->BitmapCachePersistFile, cnv.cc, len, cleanup);

		case FreeRDP_CardName:
			return update_string_copy_(&settings->CardName, cnv.cc, len, cleanup);

		case FreeRDP_CertificateAcceptedFingerprints:
			return update_string_copy_(&settings->CertificateAcceptedFingerprints, cnv.cc, len,
			                           cleanup);

		case FreeRDP_CertificateName:
			return update_string_copy_(&settings->CertificateName, cnv.cc, len, cleanup);

		case FreeRDP_ClientAddress:
			return update_string_copy_(&settings->ClientAddress, cnv.cc, len, cleanup);

		case FreeRDP_ClientDir:
			return update_string_copy_(&settings->ClientDir, cnv.cc, len, cleanup);

		case FreeRDP_ClientHostname:
			return update_string_copy_(&settings->ClientHostname, cnv.cc, len, cleanup);

		case FreeRDP_ClientProductId:
			return update_string_copy_(&settings->ClientProductId, cnv.cc, len, cleanup);

		case FreeRDP_ClipboardUseSelection:
			return update_string_copy_(&settings->ClipboardUseSelection, cnv.cc, len, cleanup);

		case FreeRDP_ComputerName:
			return update_string_copy_(&settings->ComputerName, cnv.cc, len, cleanup);

		case FreeRDP_ConfigPath:
			return update_string_copy_(&settings->ConfigPath, cnv.cc, len, cleanup);

		case FreeRDP_ConnectionFile:
			return update_string_copy_(&settings->ConnectionFile, cnv.cc, len, cleanup);

		case FreeRDP_ContainerName:
			return update_string_copy_(&settings->ContainerName, cnv.cc, len, cleanup);

		case FreeRDP_CspName:
			return update_string_copy_(&settings->CspName, cnv.cc, len, cleanup);

		case FreeRDP_CurrentPath:
			return update_string_copy_(&settings->CurrentPath, cnv.cc, len, cleanup);

		case FreeRDP_Domain:
			return update_string_copy_(&settings->Domain, cnv.cc, len, cleanup);

		case FreeRDP_DrivesToRedirect:
			return update_string_copy_(&settings->DrivesToRedirect, cnv.cc, len, cleanup);

		case FreeRDP_DumpRemoteFxFile:
			return update_string_copy_(&settings->DumpRemoteFxFile, cnv.cc, len, cleanup);

		case FreeRDP_DynamicDSTTimeZoneKeyName:
			return update_string_copy_(&settings->DynamicDSTTimeZoneKeyName, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAcceptedCert:
			return update_string_copy_(&settings->GatewayAcceptedCert, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAccessToken:
			return update_string_copy_(&settings->GatewayAccessToken, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdAadtenantid:
			return update_string_copy_(&settings->GatewayAvdAadtenantid, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdAccessAadFormat:
			return update_string_copy_(&settings->GatewayAvdAccessAadFormat, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdAccessTokenFormat:
			return update_string_copy_(&settings->GatewayAvdAccessTokenFormat, cnv.cc, len,
			                           cleanup);

		case FreeRDP_GatewayAvdActivityhint:
			return update_string_copy_(&settings->GatewayAvdActivityhint, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdArmpath:
			return update_string_copy_(&settings->GatewayAvdArmpath, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdClientID:
			return update_string_copy_(&settings->GatewayAvdClientID, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdDiagnosticserviceurl:
			return update_string_copy_(&settings->GatewayAvdDiagnosticserviceurl, cnv.cc, len,
			                           cleanup);

		case FreeRDP_GatewayAvdGeo:
			return update_string_copy_(&settings->GatewayAvdGeo, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdHubdiscoverygeourl:
			return update_string_copy_(&settings->GatewayAvdHubdiscoverygeourl, cnv.cc, len,
			                           cleanup);

		case FreeRDP_GatewayAvdScope:
			return update_string_copy_(&settings->GatewayAvdScope, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAvdWvdEndpointPool:
			return update_string_copy_(&settings->GatewayAvdWvdEndpointPool, cnv.cc, len, cleanup);

		case FreeRDP_GatewayAzureActiveDirectory:
			return update_string_copy_(&settings->GatewayAzureActiveDirectory, cnv.cc, len,
			                           cleanup);

		case FreeRDP_GatewayDomain:
			return update_string_copy_(&settings->GatewayDomain, cnv.cc, len, cleanup);

		case FreeRDP_GatewayHostname:
			return update_string_copy_(&settings->GatewayHostname, cnv.cc, len, cleanup);

		case FreeRDP_GatewayHttpExtAuthBearer:
			return update_string_copy_(&settings->GatewayHttpExtAuthBearer, cnv.cc, len, cleanup);

		case FreeRDP_GatewayHttpMsUserAgent:
			return update_string_copy_(&settings->GatewayHttpMsUserAgent, cnv.cc, len, cleanup);

		case FreeRDP_GatewayHttpReferer:
			return update_string_copy_(&settings->GatewayHttpReferer, cnv.cc, len, cleanup);

		case FreeRDP_GatewayHttpUserAgent:
			return update_string_copy_(&settings->GatewayHttpUserAgent, cnv.cc, len, cleanup);

		case FreeRDP_GatewayPassword:
			return update_string_copy_(&settings->GatewayPassword, cnv.cc, len, cleanup);

		case FreeRDP_GatewayUrl:
			return update_string_copy_(&settings->GatewayUrl, cnv.cc, len, cleanup);

		case FreeRDP_GatewayUsername:
			return update_string_copy_(&settings->GatewayUsername, cnv.cc, len, cleanup);

		case FreeRDP_HomePath:
			return update_string_copy_(&settings->HomePath, cnv.cc, len, cleanup);

		case FreeRDP_ImeFileName:
			return update_string_copy_(&settings->ImeFileName, cnv.cc, len, cleanup);

		case FreeRDP_KerberosArmor:
			return update_string_copy_(&settings->KerberosArmor, cnv.cc, len, cleanup);

		case FreeRDP_KerberosCache:
			return update_string_copy_(&settings->KerberosCache, cnv.cc, len, cleanup);

		case FreeRDP_KerberosKdcUrl:
			return update_string_copy_(&settings->KerberosKdcUrl, cnv.cc, len, cleanup);

		case FreeRDP_KerberosKeytab:
			return update_string_copy_(&settings->KerberosKeytab, cnv.cc, len, cleanup);

		case FreeRDP_KerberosLifeTime:
			return update_string_copy_(&settings->KerberosLifeTime, cnv.cc, len, cleanup);

		case FreeRDP_KerberosRealm:
			return update_string_copy_(&settings->KerberosRealm, cnv.cc, len, cleanup);

		case FreeRDP_KerberosRenewableLifeTime:
			return update_string_copy_(&settings->KerberosRenewableLifeTime, cnv.cc, len, cleanup);

		case FreeRDP_KerberosStartTime:
			return update_string_copy_(&settings->KerberosStartTime, cnv.cc, len, cleanup);

		case FreeRDP_KeyboardPipeName:
			return update_string_copy_(&settings->KeyboardPipeName, cnv.cc, len, cleanup);

		case FreeRDP_KeyboardRemappingList:
			return update_string_copy_(&settings->KeyboardRemappingList, cnv.cc, len, cleanup);

		case FreeRDP_NtlmSamFile:
			return update_string_copy_(&settings->NtlmSamFile, cnv.cc, len, cleanup);

		case FreeRDP_Password:
			return update_string_copy_(&settings->Password, cnv.cc, len, cleanup);

		case FreeRDP_PasswordHash:
			return update_string_copy_(&settings->PasswordHash, cnv.cc, len, cleanup);

		case FreeRDP_Pkcs11Module:
			return update_string_copy_(&settings->Pkcs11Module, cnv.cc, len, cleanup);

		case FreeRDP_PkinitAnchors:
			return update_string_copy_(&settings->PkinitAnchors, cnv.cc, len, cleanup);

		case FreeRDP_PlayRemoteFxFile:
			return update_string_copy_(&settings->PlayRemoteFxFile, cnv.cc, len, cleanup);

		case FreeRDP_PreconnectionBlob:
			return update_string_copy_(&settings->PreconnectionBlob, cnv.cc, len, cleanup);

		case FreeRDP_ProxyHostname:
			return update_string_copy_(&settings->ProxyHostname, cnv.cc, len, cleanup);

		case FreeRDP_ProxyPassword:
			return update_string_copy_(&settings->ProxyPassword, cnv.cc, len, cleanup);

		case FreeRDP_ProxyUsername:
			return update_string_copy_(&settings->ProxyUsername, cnv.cc, len, cleanup);

		case FreeRDP_RDP2TCPArgs:
			return update_string_copy_(&settings->RDP2TCPArgs, cnv.cc, len, cleanup);

		case FreeRDP_ReaderName:
			return update_string_copy_(&settings->ReaderName, cnv.cc, len, cleanup);

		case FreeRDP_RedirectionAcceptedCert:
			return update_string_copy_(&settings->RedirectionAcceptedCert, cnv.cc, len, cleanup);

		case FreeRDP_RedirectionDomain:
			return update_string_copy_(&settings->RedirectionDomain, cnv.cc, len, cleanup);

		case FreeRDP_RedirectionTargetFQDN:
			return update_string_copy_(&settings->RedirectionTargetFQDN, cnv.cc, len, cleanup);

		case FreeRDP_RedirectionTargetNetBiosName:
			return update_string_copy_(&settings->RedirectionTargetNetBiosName, cnv.cc, len,
			                           cleanup);

		case FreeRDP_RedirectionUsername:
			return update_string_copy_(&settings->RedirectionUsername, cnv.cc, len, cleanup);

		case FreeRDP_RemoteApplicationCmdLine:
			return update_string_copy_(&settings->RemoteApplicationCmdLine, cnv.cc, len, cleanup);

		case FreeRDP_RemoteApplicationFile:
			return update_string_copy_(&settings->RemoteApplicationFile, cnv.cc, len, cleanup);

		case FreeRDP_RemoteApplicationGuid:
			return update_string_copy_(&settings->RemoteApplicationGuid, cnv.cc, len, cleanup);

		case FreeRDP_RemoteApplicationIcon:
			return update_string_copy_(&settings->RemoteApplicationIcon, cnv.cc, len, cleanup);

		case FreeRDP_RemoteApplicationName:
			return update_string_copy_(&settings->RemoteApplicationName, cnv.cc, len, cleanup);

		case FreeRDP_RemoteApplicationProgram:
			return update_string_copy_(&settings->RemoteApplicationProgram, cnv.cc, len, cleanup);

		case FreeRDP_RemoteApplicationWorkingDir:
			return update_string_copy_(&settings->RemoteApplicationWorkingDir, cnv.cc, len,
			                           cleanup);

		case FreeRDP_RemoteAssistancePassStub:
			return update_string_copy_(&settings->RemoteAssistancePassStub, cnv.cc, len, cleanup);

		case FreeRDP_RemoteAssistancePassword:
			return update_string_copy_(&settings->RemoteAssistancePassword, cnv.cc, len, cleanup);

		case FreeRDP_RemoteAssistanceRCTicket:
			return update_string_copy_(&settings->RemoteAssistanceRCTicket, cnv.cc, len, cleanup);

		case FreeRDP_RemoteAssistanceSessionId:
			return update_string_copy_(&settings->RemoteAssistanceSessionId, cnv.cc, len, cleanup);

		case FreeRDP_ServerHostname:
			return update_string_copy_(&settings->ServerHostname, cnv.cc, len, cleanup);

		case FreeRDP_ServerLicenseCompanyName:
			return update_string_copy_(&settings->ServerLicenseCompanyName, cnv.cc, len, cleanup);

		case FreeRDP_ServerLicenseProductName:
			return update_string_copy_(&settings->ServerLicenseProductName, cnv.cc, len, cleanup);

		case FreeRDP_ShellWorkingDirectory:
			return update_string_copy_(&settings->ShellWorkingDirectory, cnv.cc, len, cleanup);

		case FreeRDP_SmartcardCertificate:
			return update_string_copy_(&settings->SmartcardCertificate, cnv.cc, len, cleanup);

		case FreeRDP_SmartcardPrivateKey:
			return update_string_copy_(&settings->SmartcardPrivateKey, cnv.cc, len, cleanup);

		case FreeRDP_SspiModule:
			return update_string_copy_(&settings->SspiModule, cnv.cc, len, cleanup);

		case FreeRDP_TargetNetAddress:
			return update_string_copy_(&settings->TargetNetAddress, cnv.cc, len, cleanup);

		case FreeRDP_TerminalDescriptor:
			return update_string_copy_(&settings->TerminalDescriptor, cnv.cc, len, cleanup);

		case FreeRDP_TlsSecretsFile:
			return update_string_copy_(&settings->TlsSecretsFile, cnv.cc, len, cleanup);

		case FreeRDP_TransportDumpFile:
			return update_string_copy_(&settings->TransportDumpFile, cnv.cc, len, cleanup);

		case FreeRDP_UserSpecifiedServerName:
			return update_string_copy_(&settings->UserSpecifiedServerName, cnv.cc, len, cleanup);

		case FreeRDP_Username:
			return update_string_copy_(&settings->Username, cnv.cc, len, cleanup);

		case FreeRDP_WinSCardModule:
			return update_string_copy_(&settings->WinSCardModule, cnv.cc, len, cleanup);

		case FreeRDP_WindowTitle:
			return update_string_copy_(&settings->WindowTitle, cnv.cc, len, cleanup);

		case FreeRDP_WmClass:
			return update_string_copy_(&settings->WmClass, cnv.cc, len, cleanup);

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}

void* freerdp_settings_get_pointer_writable(rdpSettings* settings, FreeRDP_Settings_Keys_Pointer id)
{
	WINPR_ASSERT(settings);

	switch (id)
	{
		case FreeRDP_BitmapCacheV2CellInfo:
			return (void*)settings->BitmapCacheV2CellInfo;

		case FreeRDP_ChannelDefArray:
			return (void*)settings->ChannelDefArray;

		case FreeRDP_ClientAutoReconnectCookie:
			return (void*)settings->ClientAutoReconnectCookie;

		case FreeRDP_ClientRandom:
			return (void*)settings->ClientRandom;

		case FreeRDP_ClientTimeZone:
			return (void*)settings->ClientTimeZone;

		case FreeRDP_DeviceArray:
			return (void*)settings->DeviceArray;

		case FreeRDP_DynamicChannelArray:
			return (void*)settings->DynamicChannelArray;

		case FreeRDP_FragCache:
			return (void*)settings->FragCache;

		case FreeRDP_GlyphCache:
			return (void*)settings->GlyphCache;

		case FreeRDP_LoadBalanceInfo:
			return (void*)settings->LoadBalanceInfo;

		case FreeRDP_MonitorDefArray:
			return (void*)settings->MonitorDefArray;

		case FreeRDP_MonitorIds:
			return (void*)settings->MonitorIds;

		case FreeRDP_OrderSupport:
			return (void*)settings->OrderSupport;

		case FreeRDP_Password51:
			return (void*)settings->Password51;

		case FreeRDP_RdpServerCertificate:
			return (void*)settings->RdpServerCertificate;

		case FreeRDP_RdpServerRsaKey:
			return (void*)settings->RdpServerRsaKey;

		case FreeRDP_ReceivedCapabilities:
			return (void*)settings->ReceivedCapabilities;

		case FreeRDP_ReceivedCapabilityData:
			return (void*)settings->ReceivedCapabilityData;

		case FreeRDP_ReceivedCapabilityDataSizes:
			return (void*)settings->ReceivedCapabilityDataSizes;

		case FreeRDP_RedirectionGuid:
			return (void*)settings->RedirectionGuid;

		case FreeRDP_RedirectionPassword:
			return (void*)settings->RedirectionPassword;

		case FreeRDP_RedirectionTargetCertificate:
			return (void*)settings->RedirectionTargetCertificate;

		case FreeRDP_RedirectionTsvUrl:
			return (void*)settings->RedirectionTsvUrl;

		case FreeRDP_ServerAutoReconnectCookie:
			return (void*)settings->ServerAutoReconnectCookie;

		case FreeRDP_ServerCertificate:
			return (void*)settings->ServerCertificate;

		case FreeRDP_ServerLicenseProductIssuers:
			return (void*)settings->ServerLicenseProductIssuers;

		case FreeRDP_ServerRandom:
			return (void*)settings->ServerRandom;

		case FreeRDP_StaticChannelArray:
			return (void*)settings->StaticChannelArray;

		case FreeRDP_TargetNetAddresses:
			return (void*)settings->TargetNetAddresses;

		case FreeRDP_TargetNetPorts:
			return (void*)settings->TargetNetPorts;

		case FreeRDP_instance:
			return settings->instance;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			WINPR_ASSERT(FALSE);
			return NULL;
	}
}

BOOL freerdp_settings_set_pointer(WINPR_ATTR_UNUSED rdpSettings* settings,
                                  WINPR_ATTR_UNUSED FreeRDP_Settings_Keys_Pointer id,
                                  const void* val)
{
	union
	{
		void* v;
		const void* cv;
	} cnv;
	WINPR_ASSERT(settings);

	cnv.cv = val;

	switch (id)
	{
		case FreeRDP_BitmapCacheV2CellInfo:
			settings->BitmapCacheV2CellInfo = (BITMAP_CACHE_V2_CELL_INFO*)cnv.v;
			break;

		case FreeRDP_ChannelDefArray:
			settings->ChannelDefArray = (CHANNEL_DEF*)cnv.v;
			break;

		case FreeRDP_ClientAutoReconnectCookie:
			settings->ClientAutoReconnectCookie = (ARC_CS_PRIVATE_PACKET*)cnv.v;
			break;

		case FreeRDP_ClientRandom:
			settings->ClientRandom = (BYTE*)cnv.v;
			break;

		case FreeRDP_ClientTimeZone:
			settings->ClientTimeZone = (TIME_ZONE_INFORMATION*)cnv.v;
			break;

		case FreeRDP_DeviceArray:
			settings->DeviceArray = (RDPDR_DEVICE**)cnv.v;
			break;

		case FreeRDP_DynamicChannelArray:
			settings->DynamicChannelArray = (ADDIN_ARGV**)cnv.v;
			break;

		case FreeRDP_FragCache:
			settings->FragCache = (GLYPH_CACHE_DEFINITION*)cnv.v;
			break;

		case FreeRDP_GlyphCache:
			settings->GlyphCache = (GLYPH_CACHE_DEFINITION*)cnv.v;
			break;

		case FreeRDP_LoadBalanceInfo:
			settings->LoadBalanceInfo = (BYTE*)cnv.v;
			break;

		case FreeRDP_MonitorDefArray:
			settings->MonitorDefArray = (rdpMonitor*)cnv.v;
			break;

		case FreeRDP_MonitorIds:
			settings->MonitorIds = (UINT32*)cnv.v;
			break;

		case FreeRDP_OrderSupport:
			settings->OrderSupport = (BYTE*)cnv.v;
			break;

		case FreeRDP_Password51:
			settings->Password51 = (BYTE*)cnv.v;
			break;

		case FreeRDP_RdpServerCertificate:
			settings->RdpServerCertificate = (rdpCertificate*)cnv.v;
			break;

		case FreeRDP_RdpServerRsaKey:
			settings->RdpServerRsaKey = (rdpPrivateKey*)cnv.v;
			break;

		case FreeRDP_ReceivedCapabilities:
			settings->ReceivedCapabilities = (BYTE*)cnv.v;
			break;

		case FreeRDP_ReceivedCapabilityData:
			settings->ReceivedCapabilityData = (BYTE**)cnv.v;
			break;

		case FreeRDP_ReceivedCapabilityDataSizes:
			settings->ReceivedCapabilityDataSizes = (UINT32*)cnv.v;
			break;

		case FreeRDP_RedirectionGuid:
			settings->RedirectionGuid = (BYTE*)cnv.v;
			break;

		case FreeRDP_RedirectionPassword:
			settings->RedirectionPassword = (BYTE*)cnv.v;
			break;

		case FreeRDP_RedirectionTargetCertificate:
			settings->RedirectionTargetCertificate = (rdpCertificate*)cnv.v;
			break;

		case FreeRDP_RedirectionTsvUrl:
			settings->RedirectionTsvUrl = (BYTE*)cnv.v;
			break;

		case FreeRDP_ServerAutoReconnectCookie:
			settings->ServerAutoReconnectCookie = (ARC_SC_PRIVATE_PACKET*)cnv.v;
			break;

		case FreeRDP_ServerCertificate:
			settings->ServerCertificate = (BYTE*)cnv.v;
			break;

		case FreeRDP_ServerLicenseProductIssuers:
			settings->ServerLicenseProductIssuers = (char**)cnv.v;
			break;

		case FreeRDP_ServerRandom:
			settings->ServerRandom = (BYTE*)cnv.v;
			break;

		case FreeRDP_StaticChannelArray:
			settings->StaticChannelArray = (ADDIN_ARGV**)cnv.v;
			break;

		case FreeRDP_TargetNetAddresses:
			settings->TargetNetAddresses = (char**)cnv.v;
			break;

		case FreeRDP_TargetNetPorts:
			settings->TargetNetPorts = (UINT32*)cnv.v;
			break;

		case FreeRDP_instance:
			settings->instance = cnv.v;
			break;

		default:
			WLog_ERR(TAG, "Invalid key index %d [%s|%s]", id, freerdp_settings_get_name_for_key(id),
			         freerdp_settings_get_type_name_for_key(id));
			return FALSE;
	}
	return TRUE;
}
